% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{oauth2_resource_app}
\alias{oauth2_resource_app}
\title{Fake OAuth 2.0 resource and authorization app}
\usage{
oauth2_resource_app(
  access_duration = 3600L,
  refresh_duration = 7200L,
  refresh = TRUE,
  seed = NULL,
  authorize_endpoint = "/authorize",
  token_endpoint = "/token"
)
}
\arguments{
\item{access_duration}{After how many seconds should access tokens
expire.}

\item{refresh_duration}{After how many seconds should refresh
tokens expire (ignored if \code{refresh} is \code{FALSE}).}

\item{refresh}{Should a refresh token be returned (logical).}

\item{seed}{Random seed used when creating tokens. If \code{NULL},
we rely on R to provide a seed. The app uses its own RNG stream,
so it does not affect reproducibility of the tests.}

\item{authorize_endpoint}{The authorization endpoint of the resource
server. Change this from the default if the real app that you
are faking does not use \verb{/authorize}.}

\item{token_endpoint}{The endpoint to request tokens. Change this if the
real app that you are faking does not use \verb{/token}.}
}
\value{
a \code{webfakes} app

webfakes app
}
\description{
The webfakes package comes with two fake apps that allow to imitate the
OAuth2.0 flow in your test cases. (See \href{https://aaronparecki.com/oauth-2-simplified/}{Aaron Parecki’s tutorial} for a good
introduction to OAuth2.0.) One app (\code{oauth2_resource_app()}) is the API
server that serves both as the resource and provides authorization.
\code{oauth2_third_party_app()} plays the role of the third-party app. They
are useful when testing or demonstrating code handling OAuth2.0
authorization, token caching, etc. in a package. The apps can be used in
your tests directly, or you could adapt one or both of them to better
mimic a particular OAuth2.0 flow.
}
\details{
The app has the following endpoints:
\itemize{
\item \code{GET /register} is the endpoint that you can use to register
your third party app. It needs to receive the \code{name} of the
third party app, and its \code{redirect_uri} as query parameters,
otherwise returns an HTTP 400 error. On success it returns a
JSON dictionary with entries \code{name} (the name of the third party
app), \code{client_id}, \code{client_secret} and \code{redirect_uri}.
\item \code{GET /authorize} is the endpoint where the user of the third
party app is sent. You can change the URL of this endpoint with
the \code{authorize_endpoint} argument. It needs to receive the \code{client_id}
of the third party app, and its correct \code{redirect_uri} as query
parameters. It may receive a \code{state} string as well, which can
be used by a client to identify the request. Otherwise it
generates a random \code{state} string. On error it fails with a HTTP
400 error. On success it returns a simple HTML login page.
\item \code{POST /authorize/decision} is the endpoint where the HTML login
page generated at \verb{/authorize} connects back to, either with a
positive or negative result. The form on the login page will send
the \code{state} string and the user's choice in the \code{action} variable.
If the user authorized the third party app, then they are
redirected to the \code{redirect_uri} of the app, with a temporary
\code{code} and the \code{state} string supplied as query parameters.
Otherwise a simple HTML page is returned.
\item \code{POST /token} is the endpoint where the third party app requests
a temporary access token. It is also uses for refreshing an
access token with a refresh token. You can change the URL of this
endpoint with the \code{token_endpoint} argument.
To request a new token or refresh an existing one, the following
data must be included in either a JSON or an URL encoded request body:
\itemize{
\item \code{grant_type}, this must be \code{authorization_code} for new tokens,
and \code{refresh_token} for refreshing.
\item \code{code}, this must be the temporary code obtained from the
\verb{/authorize/decision} redirection, for new tokens. It is not
needed when refreshing.
\item \code{client_id} must be the client id of the third party app.
\item \code{client_secret} must be the client secret of the third party
app.
\item \code{redirect_uri} must be the correct redirection URI of the
third party app. It is not needed when refreshing tokens.
\item \code{refresh_token} must be the refresh token obtained previously,
when refreshing a token. It is not needed for new tokens.
On success a JSON dictionary is returned with entries:
\code{access_token}, \code{expiry} and \code{refresh_token}. (The latter is
omitted if the \code{refresh} argument is \code{FALSE}).
}
\item \code{GET /locals} returns a list of current apps, access tokens and
refresh tokens.
\item \code{GET /data} is an endpoint that returns a simple JSON response,
and needs authorization.
}
\subsection{Notes}{
\itemize{
\item Using this app in your tests requires the glue package, so you
need to put it in \code{Suggests}.
\item You can add custom endpoints to the app, as needed.
\item If you need authorization in your custom endpoint, call
\code{app$is_authorized()} in your handler:\preformatted{if (!app$is_authorized(req, res)) return()
}

\code{app$is_authorized()} returns an HTTP 401 response if the
client is not authorized, so you can simply return from your
handler.
}

For more details see \code{vignette("oauth", package = "webfakes")}.
}
}
\section{\code{oauth2_resource_app()}}{

App representing the API server (resource/authorization)
}

\seealso{
Other OAuth2.0 functions: 
\code{\link{oauth2_httr_login}()},
\code{\link{oauth2_login}()},
\code{\link{oauth2_third_party_app}()}
}
\concept{OAuth2.0 functions}
