% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openmx.R
\name{as.IFAgroup}
\alias{as.IFAgroup}
\title{Convert an OpenMx MxModel object into an IFA group}
\usage{
as.IFAgroup(
  mxModel,
  data = NULL,
  container = NULL,
  ...,
  minItemsPerScore = NULL
)
}
\arguments{
\item{mxModel}{MxModel object}

\item{data}{observed data (otherwise the data will be taken from the mxModel)}

\item{container}{an MxModel in which to search for the latent distribution matrices}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{minItemsPerScore}{minimum number of items required to compute a score (also see description)}
}
\value{
a groups with item parameters and latent distribution
}
\description{
When \dQuote{minItemsPerScore} is passed, EAP scores will be computed
from the data and stored. Scores are required for some diagnostic
tests. See discussion of \dQuote{minItemsPerScore} in \link{EAPscores}.
}
\section{Format of a group}{


A model, or group within a model, is represented as a named list.
\describe{
\item{spec}{list of response model objects}
\item{param}{numeric matrix of item parameters}
\item{free}{logical matrix of indicating which parameters are free (TRUE) or fixed (FALSE)}
\item{mean}{numeric vector giving the mean of the latent distribution}
\item{cov}{numeric matrix giving the covariance of the latent distribution}
\item{data}{data.frame containing observed item responses, and optionally,
weights and frequencies}
\item{score}{factors scores with response patterns in rows}
\item{weightColumn}{name of the data column containing the numeric row weights (optional)}
\item{freqColumn}{name of the data column containing the integral row frequencies (optional)}
\item{qwidth}{width of the quadrature expressed in Z units}
\item{qpoints}{number of quadrature points}
\item{minItemsPerScore}{minimum number of non-missing items when estimating factor scores}
}

The \code{param} matrix stores items parameters by column. If a
column has more rows than are required to fully specify a model
then the extra rows are ignored.  The order of the items in
\code{spec} and order of columns in \code{param} are assumed to
match. All items should have the same number of latent dimensions.
Loadings on latent dimensions are given in the first few rows and
can be named by setting rownames. Item names are assigned by
\code{param} colnames.

Currently only a multivariate normal distribution is available,
parameterized by the \code{mean} and \code{cov}. If \code{mean} and
\code{cov} are not specified then a standard normal distribution is
assumed. The quadrature consists of equally spaced points. For
example, \code{qwidth=2} and \code{qpoints=5} would produce points
-2, -1, 0, 1, and 2. The quadrature specification is part of the
group and not passed as extra arguments for the sake of
consistency. As currently implemented, OpenMx uses EAP scores to
estimate latent distribution parameters. By default, the exact same
EAP scores should be produced by \link{EAPscores}.
}

\seealso{
\href{https://cran.r-project.org/package=ifaTools}{ifaTools}
}
