% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_make.R
\name{request_make}
\alias{request_make}
\alias{do_request}
\alias{do_paginated_request}
\title{Make a request for the Google Drive v3 API}
\usage{
request_make(x, ...)

do_request(x, ...)

do_paginated_request(
  x,
  ...,
  n_max = Inf,
  n = function(res) 1,
  verbose = deprecated()
)
}
\arguments{
\item{x}{List, holding the components for an HTTP request, presumably created
with \code{\link[=request_generate]{request_generate()}} Should contain the \code{method}, \code{url}, \code{body},
and \code{token}.}

\item{...}{Optional arguments passed through to the HTTP method.}

\item{n_max}{Maximum number of items to return. Defaults to \code{Inf}, i.e. there
is no limit and we keep making requests until we get all items.}

\item{n}{Function that computes the number of items in one response or page.
The default function always returns \code{1} and therefore treats each page as
an item. If you know more about the structure of the response, you can
pass another function to count and threshhold, for example, the number of
files or comments.}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This logical argument to
individual googledrive functions is deprecated. To globally suppress
googledrive messaging, use \code{options(googledrive_quiet = TRUE)} (the default
behaviour is to emit informational messages). To suppress messaging in a
more limited way, use the helpers \code{\link[=local_drive_quiet]{local_drive_quiet()}} or
\code{\link[=with_drive_quiet]{with_drive_quiet()}}.}
}
\value{
\code{request_make()}: Object of class \code{response} from \link{httr}.

\code{do_request()}: List representing the content returned by a single
request.

\code{do_paginated_request()}: List of lists, representing the returned
content, one component per page.
}
\description{
Low-level functions to execute one or more Drive API requests and, perhaps,
process the response(s). Most users should, instead, use higher-level
wrappers that facilitate common tasks, such as uploading or downloading Drive
files. The functions here are intended for internal use and for programming
around the Drive API. Three functions are documented here:
\itemize{
\item \code{request_make()} does the bare minimum: calls \code{\link[gargle:request_make]{gargle::request_make()}},
only adding the googledrive user agent. Typically the input is created
with \code{\link[=request_generate]{request_generate()}} and the output is processed with
\code{\link[gargle:response_process]{gargle::response_process()}}.
\item \code{do_request()} is simply
\code{gargle::response_process(request_make(x, ...))}. It exists only because
we had to make \code{do_paginated_request()} and it felt weird to not make the
equivalent for a single request.
\item \code{do_paginated_request()} executes the input request \strong{with page
traversal}. It is impossible to separate paginated requests into a "make
request" step and a "process request" step, because the token for the
next page must be extracted from the content of the current page.
Therefore this function does both and returns a list of processed
responses, one per page.
}
}
\examples{
\dontrun{
# build a request for an endpoint that is:
#   * paginated
#   * NOT privileged in googledrive, i.e. not covered by request_generate()
# "comments" are a great example
# https://developers.google.com/drive/v3/reference/comments
#
# Practice with a target file with > 2 comments
# Note that we request 2 items (comments) per page
req <- build_request(
  path = "drive/v3/files/{fileId}/comments",
  method = "GET",
  params = list(
    fileId = "your-file-id-goes-here",
    fields = "*",
    pageSize = 2
  ),
  token = googledrive::drive_token()
)
# make the paginated request, but cap it at 1 page
# should get back exactly two comments
do_paginated_request(req, n_max = 1)
}
}
\seealso{
Other low-level API functions: 
\code{\link{drive_has_token}()},
\code{\link{drive_token}()},
\code{\link{request_generate}()}
}
\concept{low-level API functions}
