% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-oracle.R
\name{backend-oracle}
\alias{simulate_oracle}
\title{Backend: Oracle}
\usage{
simulate_oracle()
}
\description{
See \code{vignette("translate-function")} and \code{vignette("translate-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item Use \verb{FETCH FIRST} instead of \code{LIMIT}
\item Custom types
\item \code{paste()} uses \code{||}
\item Custom subquery generation (no \code{AS})
\item \code{setdiff()} uses \code{MINUS} instead of \code{EXCEPT}
}

Use \code{simulate_oracle()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_oracle())
lf \%>\% transmute(x = paste0(c, " times"))
lf \%>\% setdiff(lf)
}
