% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_tidiers.R
\name{tidy.manova}
\alias{tidy.manova}
\title{tidy a MANOVA object}
\usage{
\method{tidy}{manova}(x, test = "Pillai", ...)
}
\arguments{
\item{x}{object of class "manova"}

\item{test}{one of "Pillai" (Pillai's trace), "Wilks" (Wilk's lambda), "Hotelling-Lawley" (Hotelling-Lawley trace) or "Roy" (Roy's greatest root) indicating which test statistic should be used. Defaults to "Pillai"}

\item{...}{additional arguments passed on to \code{summary.manova}}
}
\value{
A data.frame with the columns
    \item{term}{Term in design}
    \item{statistic}{Approximate F statistic}
    \item{num.df}{Degrees of freedom}
    \item{p.value}{P-value}
    
Depending on which test statistic is specified, one of the following columns is also included:
    \item{pillai}{Pillai's trace}
    \item{wilks}{Wilk's lambda}
    \item{hl}{Hotelling-Lawley trace}
    \item{roy}{Roy's greatest root}
}
\description{
Constructs a data frame with one row for each of the terms in the model,
containing the information from \link{summary.manova}.
}
\examples{

npk2 <- within(npk, foo <- rnorm(24))
npk2.aov <- manova(cbind(yield, foo) ~ block + N*P*K, npk2)

}
\seealso{
\code{\link{summary.manova}}
}
