#! /bin/sh
### BEGIN INIT INFO
# Provides:          privoxy
# Required-Start:    $local_fs $remote_fs $named $network $time
# Required-Stop:     $local_fs $remote_fs $named $network $time
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Privacy enhancing HTTP Proxy
# Description:       Privoxy is a web proxy with advanced filtering
#                    capabilities for protecting privacy, filtering
#                    web page content, managing cookies, controlling
#                    access, and removing ads, banners, pop-ups and
#                    other obnoxious Internet junk.
### END INIT INFO

# Author: Roland Rosenfeld <roland@debian.org>

# Do NOT "set -e"

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="filtering proxy server"
NAME=privoxy
DAEMON=/usr/sbin/$NAME
PIDFILE=/var/run/$NAME.pid
OWNER=privoxy
CONFIGFILE=/etc/privoxy/config
DAEMON_ARGS="--pidfile $PIDFILE --user $OWNER $CONFIGFILE"
SCRIPTNAME=/etc/init.d/$NAME
LOGDIR=/var/log/privoxy
DEFAULTSFILE=/etc/default/$NAME

# Exit if the package is not installed
[ -x "$DAEMON" ] || exit 0

# Read configuration variable file if it is present
[ -r $DEFAULTSFILE ] && . $DEFAULTSFILE

# Create log directory if it does not exist
if [ ! -d "$LOGDIR" ]; then
    mkdir -m 750 $LOGDIR
    chown $OWNER:adm $LOGDIR
fi

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
	start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $DAEMON --test > /dev/null \
		|| return 1
	start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $DAEMON -- \
		$DAEMON_ARGS \
		|| return 2
	# Add code here, if necessary, that waits for the process to be ready
	# to handle requests from services started subsequently which depend
	# on this one.  As a last resort, sleep for some time.
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2
	# Wait for children to finish too if this is a daemon that forks
	# and if the daemon is only ever run from this initscript.
	# If the above conditions are not satisfied then add some other code
	# that waits for the process to drop all resources that could be
	# needed by services started subsequently.  A last resort is to
	# sleep for some time.
	start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --exec $DAEMON
	[ "$?" = 2 ] && return 2
	# Many daemons don't delete their pidfiles when they exit.
	rm -f $PIDFILE
	return "$RETVAL"
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_rotate() {
	#
	# If the daemon can reload its configuration without
	# restarting (for example, when it is sent a SIGHUP),
	# then implement that here.
	#
	start-stop-daemon --stop --signal HUP --quiet --pidfile $PIDFILE --name $NAME
	return 0
}


case "$1" in
  start)
	if [ "$RUN_DAEMON" = "no" ]; then
            log_warning_msg "Not starting $DESC (disabled in $DEFAULTSFILE)."
            exit 0
	fi

	log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) log_end_msg 0 ;;
		2) log_end_msg 1 ;;
	esac
	;;
  stop)
	log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) log_end_msg 0 ;;
		2) log_end_msg 1 ;;
	esac
	;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  rotate)
	log_daemon_msg "Closing open files" "$NAME"
	do_rotate
	log_end_msg $?
	;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	if [ "$RUN_DAEMON" = "no" ]; then
            log_warning_msg "Not restarting $DESC (disabled in $DEFAULTSFILE)."
            exit 0
	fi

	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  status)
        status_of_proc "$DAEMON" "$NAME"
        exit $?
        ;;

  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|rotate|restart|force-reload|status}" >&2
	exit 3
	;;
esac

:
