/* This file was generated by running 'make_rr_types_h.pl rr_types.in'.
   Modifications to this file may be lost the next time it is automatically
   regenerated.
*/

/* rr_types.h - A header file with names & descriptions of
                all rr types known to pdnsd
   Copyright (C) 2000, 2001 Thomas Moestl
   Copyright (C) 2007, 2010, 2011 Paul A. Rombouts

  This file is part of the pdnsd package.

  pdnsd is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  pdnsd is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with pdnsd; see the file COPYING. If not, see
  <http://www.gnu.org/licenses/>.
*/

#ifndef _RR_TYPES_H_
#define _RR_TYPES_H_

#include <config.h>

#define T_MIN 1
#define T_A           1
#define T_NS          2
#define T_MD          3
#define T_MF          4
#define T_CNAME       5
#define T_SOA         6
#define T_MB          7
#define T_MG          8
#define T_MR          9
#define T_NULL       10
#define T_WKS        11
#define T_PTR        12
#define T_HINFO      13
#define T_MINFO      14
#define T_MX         15
#define T_TXT        16
#define T_RP         17
#define T_AFSDB      18
#define T_X25        19
#define T_ISDN       20
#define T_RT         21
#define T_NSAP       22
#define T_NSAP_PTR   23
#define T_SIG        24
#define T_KEY        25
#define T_PX         26
#define T_GPOS       27
#define T_AAAA       28
#define T_LOC        29
#define T_NXT        30
#define T_EID        31
#define T_NIMLOC     32
#define T_SRV        33
#define T_ATMA       34
#define T_NAPTR      35
#define T_KX         36
#define T_CERT       37
#define T_A6         38
#define T_DNAME      39
#define T_SINK       40
#define T_OPT        41
#define T_APL        42
#define T_DS         43
#define T_SSHFP      44
#define T_IPSECKEY   45
#define T_RRSIG      46
#define T_NSEC       47
#define T_DNSKEY     48
#define T_DHCID      49
#define T_NSEC3      50
#define T_NSEC3PARAM 51
#define T_HIP        55
#define T_NINFO      56
#define T_RKEY       57
#define T_TALINK     58
#define T_SPF        99
#define T_UINFO      100
#define T_UID        101
#define T_GID        102
#define T_UNSPEC     103
#define T_MAX 51

/* T_MAX - T_MIN + 1 */
#define T_NUM 51

/* Number of most frequently used rr types. */
#define NRRMU 8

/* Number of remaining rr types. */
#define NRREXT 39

/* NRRMU + NRREXT */
#define NRRTOT 47

/* Lookup table for converting rr type values to internally used indices. */
extern const unsigned short int rrlkuptab[T_NUM];
#if DEFINE_RR_TYPE_ARRAYS && !defined(CLIENT_ONLY)
const unsigned short int rrlkuptab[T_NUM] = {
   0  /* A */,
   1  /* NS */,
   8  /* MD */,
   9  /* MF */,
   2  /* CNAME */,
   3  /* SOA */,
  10  /* MB */,
  11  /* MG */,
  12  /* MR */,
  13  /* NULL */,
  14  /* WKS */,
   4  /* PTR */,
  15  /* HINFO */,
  16  /* MINFO */,
   5  /* MX */,
   6  /* TXT */,
  17  /* RP */,
  18  /* AFSDB */,
  19  /* X25 */,
  20  /* ISDN */,
  21  /* RT */,
  22  /* NSAP */,
  23  /* NSAP_PTR */,
  24  /* SIG */,
  25  /* KEY */,
  26  /* PX */,
  27  /* GPOS */,
   7  /* AAAA */,
  28  /* LOC */,
  29  /* NXT */,
  30  /* EID */,
  31  /* NIMLOC */,
  32  /* SRV */,
  33  /* ATMA */,
  34  /* NAPTR */,
  35  /* KX */,
  36  /* CERT */,
  47  /* A6 */,
  48  /* DNAME */,
  49  /* SINK */,
  50  /* OPT */,
  37  /* APL */,
  38  /* DS */,
  39  /* SSHFP */,
  40  /* IPSECKEY */,
  41  /* RRSIG */,
  42  /* NSEC */,
  43  /* DNSKEY */,
  44  /* DHCID */,
  45  /* NSEC3 */,
  46  /* NSEC3PARAM */
};
#endif

/* List of most frequently used RR types in ascending order. */
extern const unsigned short int rrmuiterlist[NRRMU];
#if DEFINE_RR_TYPE_ARRAYS && !defined(CLIENT_ONLY)
const unsigned short int rrmuiterlist[NRRMU] = {
  T_A,
  T_NS,
  T_CNAME,
  T_SOA,
  T_PTR,
  T_MX,
  T_TXT,
  T_AAAA
};
#endif

/* List of the cache-able RR types in ascending order. */
extern const unsigned short int rrcachiterlist[NRRTOT];
#if DEFINE_RR_TYPE_ARRAYS
const unsigned short int rrcachiterlist[NRRTOT] = {
  T_A,
  T_NS,
  T_MD,
  T_MF,
  T_CNAME,
  T_SOA,
  T_MB,
  T_MG,
  T_MR,
  T_NULL,
  T_WKS,
  T_PTR,
  T_HINFO,
  T_MINFO,
  T_MX,
  T_TXT,
  T_RP,
  T_AFSDB,
  T_X25,
  T_ISDN,
  T_RT,
  T_NSAP,
  T_NSAP_PTR,
  T_SIG,
  T_KEY,
  T_PX,
  T_GPOS,
  T_AAAA,
  T_LOC,
  T_NXT,
  T_EID,
  T_NIMLOC,
  T_SRV,
  T_ATMA,
  T_NAPTR,
  T_KX,
  T_CERT,
  T_APL,
  T_DS,
  T_SSHFP,
  T_IPSECKEY,
  T_RRSIG,
  T_NSEC,
  T_DNSKEY,
  T_DHCID,
  T_NSEC3,
  T_NSEC3PARAM
};
#endif

/* Optimized getrrset macros for fixed rr types. */
#define getrrset_A(cent)          GET_RRSMU(cent,0)
#define getrrset_NS(cent)         GET_RRSMU(cent,1)
#define getrrset_MD(cent)         GET_RRSEXT(cent,0)
#define getrrset_MF(cent)         GET_RRSEXT(cent,1)
#define getrrset_CNAME(cent)      GET_RRSMU(cent,2)
#define getrrset_SOA(cent)        GET_RRSMU(cent,3)
#define getrrset_MB(cent)         GET_RRSEXT(cent,2)
#define getrrset_MG(cent)         GET_RRSEXT(cent,3)
#define getrrset_MR(cent)         GET_RRSEXT(cent,4)
#define getrrset_NULL(cent)       GET_RRSEXT(cent,5)
#define getrrset_WKS(cent)        GET_RRSEXT(cent,6)
#define getrrset_PTR(cent)        GET_RRSMU(cent,4)
#define getrrset_HINFO(cent)      GET_RRSEXT(cent,7)
#define getrrset_MINFO(cent)      GET_RRSEXT(cent,8)
#define getrrset_MX(cent)         GET_RRSMU(cent,5)
#define getrrset_TXT(cent)        GET_RRSMU(cent,6)
#define getrrset_RP(cent)         GET_RRSEXT(cent,9)
#define getrrset_AFSDB(cent)      GET_RRSEXT(cent,10)
#define getrrset_X25(cent)        GET_RRSEXT(cent,11)
#define getrrset_ISDN(cent)       GET_RRSEXT(cent,12)
#define getrrset_RT(cent)         GET_RRSEXT(cent,13)
#define getrrset_NSAP(cent)       GET_RRSEXT(cent,14)
#define getrrset_NSAP_PTR(cent)   GET_RRSEXT(cent,15)
#define getrrset_SIG(cent)        GET_RRSEXT(cent,16)
#define getrrset_KEY(cent)        GET_RRSEXT(cent,17)
#define getrrset_PX(cent)         GET_RRSEXT(cent,18)
#define getrrset_GPOS(cent)       GET_RRSEXT(cent,19)
#define getrrset_AAAA(cent)       GET_RRSMU(cent,7)
#define getrrset_LOC(cent)        GET_RRSEXT(cent,20)
#define getrrset_NXT(cent)        GET_RRSEXT(cent,21)
#define getrrset_EID(cent)        GET_RRSEXT(cent,22)
#define getrrset_NIMLOC(cent)     GET_RRSEXT(cent,23)
#define getrrset_SRV(cent)        GET_RRSEXT(cent,24)
#define getrrset_ATMA(cent)       GET_RRSEXT(cent,25)
#define getrrset_NAPTR(cent)      GET_RRSEXT(cent,26)
#define getrrset_KX(cent)         GET_RRSEXT(cent,27)
#define getrrset_CERT(cent)       GET_RRSEXT(cent,28)
#define getrrset_APL(cent)        GET_RRSEXT(cent,29)
#define getrrset_DS(cent)         GET_RRSEXT(cent,30)
#define getrrset_SSHFP(cent)      GET_RRSEXT(cent,31)
#define getrrset_IPSECKEY(cent)   GET_RRSEXT(cent,32)
#define getrrset_RRSIG(cent)      GET_RRSEXT(cent,33)
#define getrrset_NSEC(cent)       GET_RRSEXT(cent,34)
#define getrrset_DNSKEY(cent)     GET_RRSEXT(cent,35)
#define getrrset_DHCID(cent)      GET_RRSEXT(cent,36)
#define getrrset_NSEC3(cent)      GET_RRSEXT(cent,37)
#define getrrset_NSEC3PARAM(cent) GET_RRSEXT(cent,38)

/* have_rr macros for fixed rr types. */
#define have_rr_A(cent)           HAVE_RRMU(cent,0)
#define have_rr_NS(cent)          HAVE_RRMU(cent,1)
#define have_rr_MD(cent)          HAVE_RREXT(cent,0)
#define have_rr_MF(cent)          HAVE_RREXT(cent,1)
#define have_rr_CNAME(cent)       HAVE_RRMU(cent,2)
#define have_rr_SOA(cent)         HAVE_RRMU(cent,3)
#define have_rr_MB(cent)          HAVE_RREXT(cent,2)
#define have_rr_MG(cent)          HAVE_RREXT(cent,3)
#define have_rr_MR(cent)          HAVE_RREXT(cent,4)
#define have_rr_NULL(cent)        HAVE_RREXT(cent,5)
#define have_rr_WKS(cent)         HAVE_RREXT(cent,6)
#define have_rr_PTR(cent)         HAVE_RRMU(cent,4)
#define have_rr_HINFO(cent)       HAVE_RREXT(cent,7)
#define have_rr_MINFO(cent)       HAVE_RREXT(cent,8)
#define have_rr_MX(cent)          HAVE_RRMU(cent,5)
#define have_rr_TXT(cent)         HAVE_RRMU(cent,6)
#define have_rr_RP(cent)          HAVE_RREXT(cent,9)
#define have_rr_AFSDB(cent)       HAVE_RREXT(cent,10)
#define have_rr_X25(cent)         HAVE_RREXT(cent,11)
#define have_rr_ISDN(cent)        HAVE_RREXT(cent,12)
#define have_rr_RT(cent)          HAVE_RREXT(cent,13)
#define have_rr_NSAP(cent)        HAVE_RREXT(cent,14)
#define have_rr_NSAP_PTR(cent)    HAVE_RREXT(cent,15)
#define have_rr_SIG(cent)         HAVE_RREXT(cent,16)
#define have_rr_KEY(cent)         HAVE_RREXT(cent,17)
#define have_rr_PX(cent)          HAVE_RREXT(cent,18)
#define have_rr_GPOS(cent)        HAVE_RREXT(cent,19)
#define have_rr_AAAA(cent)        HAVE_RRMU(cent,7)
#define have_rr_LOC(cent)         HAVE_RREXT(cent,20)
#define have_rr_NXT(cent)         HAVE_RREXT(cent,21)
#define have_rr_EID(cent)         HAVE_RREXT(cent,22)
#define have_rr_NIMLOC(cent)      HAVE_RREXT(cent,23)
#define have_rr_SRV(cent)         HAVE_RREXT(cent,24)
#define have_rr_ATMA(cent)        HAVE_RREXT(cent,25)
#define have_rr_NAPTR(cent)       HAVE_RREXT(cent,26)
#define have_rr_KX(cent)          HAVE_RREXT(cent,27)
#define have_rr_CERT(cent)        HAVE_RREXT(cent,28)
#define have_rr_A6(cent)          0
#define have_rr_DNAME(cent)       0
#define have_rr_SINK(cent)        0
#define have_rr_OPT(cent)         0
#define have_rr_APL(cent)         HAVE_RREXT(cent,29)
#define have_rr_DS(cent)          HAVE_RREXT(cent,30)
#define have_rr_SSHFP(cent)       HAVE_RREXT(cent,31)
#define have_rr_IPSECKEY(cent)    HAVE_RREXT(cent,32)
#define have_rr_RRSIG(cent)       HAVE_RREXT(cent,33)
#define have_rr_NSEC(cent)        HAVE_RREXT(cent,34)
#define have_rr_DNSKEY(cent)      HAVE_RREXT(cent,35)
#define have_rr_DHCID(cent)       HAVE_RREXT(cent,36)
#define have_rr_NSEC3(cent)       HAVE_RREXT(cent,37)
#define have_rr_NSEC3PARAM(cent)  HAVE_RREXT(cent,38)

/* These macros specify which RR types are cached by pdnsd. */
#define IS_CACHED_A          1
#define IS_CACHED_NS         1
#define IS_CACHED_MD         1
#define IS_CACHED_MF         1
#define IS_CACHED_CNAME      1
#define IS_CACHED_SOA        1
#define IS_CACHED_MB         1
#define IS_CACHED_MG         1
#define IS_CACHED_MR         1
#define IS_CACHED_NULL       1
#define IS_CACHED_WKS        1
#define IS_CACHED_PTR        1
#define IS_CACHED_HINFO      1
#define IS_CACHED_MINFO      1
#define IS_CACHED_MX         1
#define IS_CACHED_TXT        1
#define IS_CACHED_RP         1
#define IS_CACHED_AFSDB      1
#define IS_CACHED_X25        1
#define IS_CACHED_ISDN       1
#define IS_CACHED_RT         1
#define IS_CACHED_NSAP       1
#define IS_CACHED_NSAP_PTR   1
#define IS_CACHED_SIG        1
#define IS_CACHED_KEY        1
#define IS_CACHED_PX         1
#define IS_CACHED_GPOS       1
#define IS_CACHED_AAAA       1
#define IS_CACHED_LOC        1
#define IS_CACHED_NXT        1
#define IS_CACHED_EID        1
#define IS_CACHED_NIMLOC     1
#define IS_CACHED_SRV        1
#define IS_CACHED_ATMA       1
#define IS_CACHED_NAPTR      1
#define IS_CACHED_KX         1
#define IS_CACHED_CERT       1
#define IS_CACHED_APL        1
#define IS_CACHED_DS         1
#define IS_CACHED_SSHFP      1
#define IS_CACHED_IPSECKEY   1
#define IS_CACHED_RRSIG      1
#define IS_CACHED_NSEC       1
#define IS_CACHED_DNSKEY     1
#define IS_CACHED_DHCID      1
#define IS_CACHED_NSEC3      1
#define IS_CACHED_NSEC3PARAM 1

/* Array indices for most frequently used rr types. */
#define RRMUINDEX_A         0
#define RRMUINDEX_NS        1
#define RRMUINDEX_CNAME     2
#define RRMUINDEX_SOA       3
#define RRMUINDEX_PTR       4
#define RRMUINDEX_MX        5
#define RRMUINDEX_TXT       6
#define RRMUINDEX_AAAA      7

/* Table of rr names. */
extern const char *const rrnames[T_NUM];
#if DEFINE_RR_TYPE_ARRAYS
const char *const rrnames[T_NUM] = {
  "A",
  "NS",
  "MD",
  "MF",
  "CNAME",
  "SOA",
  "MB",
  "MG",
  "MR",
  "NULL",
  "WKS",
  "PTR",
  "HINFO",
  "MINFO",
  "MX",
  "TXT",
  "RP",
  "AFSDB",
  "X25",
  "ISDN",
  "RT",
  "NSAP",
  "NSAP_PTR",
  "SIG",
  "KEY",
  "PX",
  "GPOS",
  "AAAA",
  "LOC",
  "NXT",
  "EID",
  "NIMLOC",
  "SRV",
  "ATMA",
  "NAPTR",
  "KX",
  "CERT",
  "A6",
  "DNAME",
  "SINK",
  "OPT",
  "APL",
  "DS",
  "SSHFP",
  "IPSECKEY",
  "RRSIG",
  "NSEC",
  "DNSKEY",
  "DHCID",
  "NSEC3",
  "NSEC3PARAM"
};
#endif

/* Structure for rr information */
struct rr_infos {
	unsigned short class;		/* class (values see below) */
	unsigned short excludes;	/* relations to other classes.
					   Mutual exclusion is marked by or'ing the
					   respective RRCL value in this field.
					   Exclusions should be symmetric. */
};

/* Class values */
#define RRCL_ALIAS	1	/* for CNAMES, conflicts with RRCL_RECORD */
#define RRCL_RECORD	2	/* normal direct record */
#define RRCL_IDEM	4	/* types that conflict with no others (MX, CNAME, ...) */
#define RRCL_PTR	8	/* PTR */

/* Standard excludes for the classes */
#define RRX_ALIAS	(RRCL_RECORD|RRCL_PTR)
#define	RRX_RECORD	(RRCL_ALIAS|RRCL_PTR)
#define	RRX_IDEM	0
#define	RRX_PTR		(RRCL_ALIAS|RRCL_RECORD)

/* There could be a separate table detailing the relationship of types, but this
 * is slightly more flexible, as it allows a finer granularity of exclusion. Also,
 * Membership in multiple classes could be added.
 * Index by internally used RR-set indices, not RR type values!
 */
extern const struct rr_infos rr_info[NRRTOT];
#if DEFINE_RR_TYPE_ARRAYS && !defined(CLIENT_ONLY)
const struct rr_infos rr_info[NRRTOT] = {
  {RRCL_RECORD,    RRX_RECORD}     /* A */,
  {RRCL_IDEM,      RRX_IDEM}       /* NS */,
  {RRCL_ALIAS,     RRX_ALIAS}      /* CNAME */,
  {RRCL_IDEM,      RRX_IDEM}       /* SOA */,
  {RRCL_PTR,       RRX_PTR}        /* PTR */,
  {RRCL_IDEM,      RRX_IDEM}       /* MX */,
  {RRCL_IDEM,      RRX_IDEM}       /* TXT */,
  {RRCL_RECORD,    RRX_RECORD}     /* AAAA */,
  {RRCL_IDEM,      RRX_IDEM}       /* MD */,
  {RRCL_IDEM,      RRX_IDEM}       /* MF */,
  {RRCL_IDEM,      RRX_IDEM}       /* MB */,
  {RRCL_IDEM,      RRX_IDEM}       /* MG */,
  {RRCL_IDEM,      RRX_IDEM}       /* MR */,
  {RRCL_IDEM,      RRX_IDEM}       /* NULL */,
  {RRCL_RECORD,    RRX_RECORD}     /* WKS */,
  {RRCL_RECORD,    RRX_RECORD}     /* HINFO */,
  {RRCL_IDEM,      RRX_IDEM}       /* MINFO */,
  {RRCL_RECORD,    RRX_RECORD}     /* RP */,
  {RRCL_RECORD,    RRX_RECORD}     /* AFSDB */,
  {RRCL_RECORD,    RRX_RECORD}     /* X25 */,
  {RRCL_RECORD,    RRX_RECORD}     /* ISDN */,
  {RRCL_RECORD,    RRX_RECORD}     /* RT */,
  {RRCL_RECORD,    RRX_RECORD}     /* NSAP */,
  {RRCL_PTR,       RRX_PTR}        /* NSAP_PTR */,
  {RRCL_IDEM,      RRX_IDEM}       /* SIG */,
  {RRCL_IDEM,      RRX_IDEM}       /* KEY */,
  {RRCL_IDEM,      RRX_IDEM}       /* PX */,
  {RRCL_RECORD,    RRX_RECORD}     /* GPOS */,
  {RRCL_RECORD,    RRX_RECORD}     /* LOC */,
  {RRCL_IDEM,      RRX_IDEM}       /* NXT */,
  {RRCL_RECORD,    RRX_RECORD}     /* EID */,
  {RRCL_RECORD,    RRX_RECORD}     /* NIMLOC */,
  {RRCL_RECORD,    RRX_RECORD}     /* SRV */,
  {RRCL_RECORD,    RRX_RECORD}     /* ATMA */,
  {RRCL_RECORD,    RRX_RECORD}     /* NAPTR */,
  {RRCL_RECORD,    RRX_RECORD}     /* KX */,
  {RRCL_RECORD,    RRX_RECORD}     /* CERT */,
  {RRCL_IDEM,      RRX_IDEM}       /* APL */,
  {RRCL_IDEM,      RRX_IDEM}       /* DS */,
  {RRCL_IDEM,      RRX_IDEM}       /* SSHFP */,
  {RRCL_IDEM,      RRX_IDEM}       /* IPSECKEY */,
  {RRCL_IDEM,      RRX_IDEM}       /* RRSIG */,
  {RRCL_IDEM,      RRX_IDEM}       /* NSEC */,
  {RRCL_IDEM,      RRX_IDEM}       /* DNSKEY */,
  {RRCL_IDEM,      RRX_IDEM}       /* DHCID */,
  {RRCL_IDEM,      RRX_IDEM}       /* NSEC3 */,
  {RRCL_IDEM,      RRX_IDEM}       /* NSEC3PARAM */
};
#endif

int rr_tp_byname(char *name);
const char *loc2str(const void *binary, char *ascii, size_t asclen);

#endif
