###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for krb5 vulnerability USN-879-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840364);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "879-1");
  script_cve_id("CVE-2009-3295");
  script_name("Ubuntu Update for krb5 vulnerability USN-879-1");
  desc = "

  Vulnerability Insight:

  Jeff Blaine, Radoslav Bodo, Jakob Haufe, and Jorgen Wahlsten discovered
  that the Kerberos Key Distribution Center service did not correctly verify
  certain network traffic.  An unauthenticated remote attacker could send
  a specially crafted request that would cause the KDC to crash, leading
  to a denial of service.

  Affected Software/OS:
  krb5 vulnerability on Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001019.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of krb5 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"krb5-user", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgssapi-krb5-2", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgssrpc4", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libk5crypto3", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkadm5clnt6", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkadm5srv6", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkdb5-4", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-3", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dbg", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkrb5support0", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-clients", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc-ldap", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-pkinit", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"krb5-doc", ver:"1.7dfsg~beta3-1ubuntu0.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}