# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13098 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66509);
 script_cve_id("CVE-2009-4031", "CVE-2009-3547", "CVE-2009-3638", "CVE-2009-3621", "CVE-2009-3620", "CVE-2009-3612", "CVE-2009-2908", "CVE-2009-2903", "CVE-2009-3290", "CVE-2009-2847", "CVE-2009-2692", "CVE-2009-2406", "CVE-2009-2407", "CVE-2009-1895", "CVE-2009-1897", "CVE-2009-0065", "CVE-2008-5079", "CVE-2009-3080", "CVE-2009-4005");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-13098 (kernel)");

 desc = "The remote host is missing an update to the kernel
announced via advisory FEDORA-2009-13098.

Update Information:

Update to kernel 2.6.27.41:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.39
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.40
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.41

References:

[ 1 ] Bug #539414 - CVE-2009-3080 kernel: gdth: Prevent negative offsets in ioctl
https://bugzilla.redhat.com/show_bug.cgi?id=539414
[ 2 ] Bug #539435 - CVE-2009-4005 kernel: isdn: hfc_usb: fix read buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=539435
[ 3 ] Bug #541160 - CVE-2009-4031 kernel: KVM: x86 emulator: limit instructions to 15 bytes
https://bugzilla.redhat.com/show_bug.cgi?id=541160

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13098

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-13098 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.41~170.2.117.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
