# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-11868 (p7zip)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63127);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2008-11868 (p7zip)";
 script_name(name);

 desc = "The remote host is missing an update to p7zip
announced via advisory FEDORA-2008-11868.

Update Information:

This update addresses some moderate archiver flaws discovered in p7zip versions
earlier than 4.57.

ChangeLog:

* Tue Dec 23 2008 Matthias Saou  4.61-1
- Update to 4.61.
- Update norar patch.
- Use asm for x86 too (nasm).
* Wed Jun 18 2008 Matthias Saou  4.58-1
- Update to 4.58.
- Update norar patch.
- Update install patch.

References:

[ 1 ] Bug #438410 - p7zip: Archive Formats Issues
https://bugzilla.redhat.com/show_bug.cgi?id=438410

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update p7zip' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-11868

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2008-11868 (p7zip)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"p7zip", rpm:"p7zip~4.61~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"p7zip-plugins", rpm:"p7zip-plugins~4.61~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"p7zip-debuginfo", rpm:"p7zip-debuginfo~4.61~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
