/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2013, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import java.awt.Font;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

import java.awt.Color; 


/***
 * MyTableRenderer inherits from DefaultTableCellRenderer and manage the design of the table
 * of the CounterWidget class
 */
public class MyTableRenderer extends DefaultTableCellRenderer{
	   
	/**
	 * generated serial VersionUID
	 */
	private static final long serialVersionUID = 140433233558677426L;

	private boolean isEditable = true;
	
	public void setDisabled(){
		isEditable = false;
	}
	/***
	 * set the rendering of the current component
	 */
		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, 
	                                                  boolean hasFocus, int row, int column) {
	      TableModel model = table.getRowSorter().getModel();
	      
	      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 1).toString().toLowerCase().trim().compareTo("no")==0)
	      {
	    	  setBackground(Color.RED);
	    	  setFont(getFont().deriveFont(Font.ITALIC));
	      }else
	      {
	    	 setBackground(Color.WHITE);
	    	 setFont(getFont().deriveFont(Font.PLAIN));
	      }
	      
	      setForeground(Color.BLACK);
	      
	      setText((value != null)?value.toString():"");
	      
	      if (isSelected) {
	         //setBorder(BorderFactory.createLineBorder(Color.BLACK));
	         setBackground(Color.YELLOW);
	      }else {
	         //setBorder(BorderFactory.createLineBorder(table.getBackground()));
	         if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 1).toString().toLowerCase().trim().compareTo("no")==0)
		      {
		    	  setBackground(Color.RED);
		      }else
		      {
		    	 setBackground(Color.WHITE);
		      }
	         
	      }
			setEnabled(isEditable);
	      return this;
	   }
	}