/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "oifrotatearea.h"

#include "gestureevent.h"

OIFRotateArea::OIFRotateArea(QDeclarativeItem* parent)
  : ContinuousGestureArea(parent, kRotate)
{}

bool OIFRotateArea::IsGestureEventHandled(GestureEvent* event) {
  GeisFloat angle =
    event->attributes().value(GEIS_GESTURE_ATTRIBUTE_ANGLE).toFloat();

  angle_.set(angle);

  return ContinuousGestureArea::IsGestureEventHandled(event) ||
         angle_.receivers(SIGNAL(initialChanged())) > 0 ||
         angle_.receivers(SIGNAL(currentChanged())) > 0;
}

void OIFRotateArea::HandleGestureUpdateEvent(bool end,
                                                GestureEvent* event) {
  GeisFloat angle =
    event->attributes().value(GEIS_GESTURE_ATTRIBUTE_ANGLE).toFloat();

  angle_.update(angle);

  ContinuousGestureArea::HandleGestureUpdateEvent(end, event);
}
