/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.webservices.clientproxy;

import com.sourceforge.knecs.webservices.clientproxy.ClientInvocationHandler;
import com.sourceforge.knecs.webservices.clientproxy.ResponseHandler;
import com.sourceforge.knecs.webservices.clientproxy.TimeCorrelationIdGenerator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;

public class AsyncInvocationHandler
extends ClientInvocationHandler {
    protected ResponseHandler mHandler;
    protected String mClientACT;

    public AsyncInvocationHandler(ResponseHandler handler, String endPoint, String namespace, String operation, Object[] args, QName returnType) {
        super(endPoint, namespace, operation, args, returnType);
        this.mHandler = handler;
    }

    public Call constructCall() throws AxisFault {
        Call call = super.constructCall();
        try {
            SOAPHeaderElement cid = new SOAPHeaderElement("http://cmcs.org", "CorrelationId");
            String act = new TimeCorrelationIdGenerator().generateId("cmcs");
            this.setClientACT(act);
            cid.setObjectValue(act);
            call.addHeader(cid);
        }
        catch (SOAPException soapex) {
            throw AxisFault.makeFault(soapex);
        }
        return call;
    }

    public String getClientACT() {
        return this.mClientACT;
    }

    public void setClientACT(String act) {
        this.mClientACT = act;
    }

    public Object invoke() throws AxisFault {
        this.getLogger().info("AsynInvocationHandler - invoke.");
        Object ret = super.invoke();
        this.getLogger().info("return from - invoke.");
        if (this.mHandler != null) {
            this.getLogger().info("AsynInvocationHandler - turn over to handler.");
            this.mHandler.handle(ret, this.getClientACT());
        }
        return ret;
    }
}

