
#line 3 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 160
#define YY_END_OF_BUFFER 161
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[420] =
    {   0,
        0,    0,  161,  159,  136,   63,  137,  135,  103,  159,
      104,   53,  102,  105,  159,   64,   65,   94,   92,   52,
       93,   56,   96,  140,  154,  132,   51,  116,   91,  117,
      130,  158,   67,   68,  107,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,   69,  106,   70,  108,  158,  158,  158,  136,
      135,    2,  114,    0,  139,    0,   79,  122,   89,    0,
      138,    0,  100,   73,   66,  110,   71,  112,   72,   57,
        0,  157,    0,    1,   98,   75,  157,  141,  154,    0,
        0,    0,    0,  131,  126,  118,   61,  113,   59,  120,

      128,  158,   86,  158,  158,  158,  158,  158,  158,   10,
      158,  158,  158,  158,  158,  158,  158,  158,  158,   11,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,   90,
      124,  109,  133,  134,   95,   97,  158,  158,  158,  158,
      158,  158,  158,  158,  158,    0,    2,  139,   87,  138,
       80,   54,  157,    0,   77,  156,  157,    0,    0,  157,
        0,  146,    0,  142,    0,  150,   82,   84,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,    9,  158,  158,  158,  158,   24,  158,  158,  158,

      158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
      158,  158,   19,  158,  158,  158,  158,  158,   88,   74,
       76,   55,  101,   58,   60,  123,  125,  115,  119,  121,
       62,  111,  127,  129,   99,  157,    0,    0,  149,    0,
      149,    0,  145,    0,  145,    0,  153,    0,  153,  150,
        3,   23,  158,   16,  158,  158,  158,  158,   12,   34,
      158,  158,  158,   28,  158,   41,   40,  158,  158,  158,
      158,  158,   22,  158,  158,  158,  158,   26,  158,  158,
      158,  158,  158,  158,  158,   37,  158,  158,  158,   35,
      158,   81,   83,   85,   78,  155,    0,  148,  149,    0,

        0,  149,    0,  144,  145,    0,    0,  145,  153,    0,
      152,  153,  153,    0,    0,  150,  150,   14,   20,    4,
      158,  158,  158,  158,   38,  158,  158,  158,  158,  158,
      158,  158,  158,  158,   45,  158,  158,  158,  158,  158,
      158,  158,  158,   21,  158,   33,    8,  149,    0,    0,
      145,    0,    0,  153,  153,  153,    0,  153,  153,    0,
      153,  158,  158,  158,   48,  158,  158,    5,  158,   43,
      158,  158,  158,   47,  158,   18,  158,    6,   27,   32,
       13,   31,  158,  147,  143,    0,  151,  158,   17,  158,
       36,  158,  158,   49,  158,  158,  158,  158,   39,  158,

       15,  158,    7,  158,  158,  158,   25,  158,  158,   44,
      158,   42,   46,   29,  158,   50,  158,   30,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       23,   23,   23,   23,   23,   24,   24,   25,   26,   27,
       28,   29,   30,    1,   31,   31,   31,   31,   32,   31,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       34,   35,   36,   37,   38,    1,   39,   40,   41,   42,

       43,   44,   45,   46,   47,   33,   48,   49,   50,   51,
       52,   53,   33,   54,   55,   56,   57,   58,   59,   60,
       61,   33,   62,   63,   64,   65,    1,   66,   33,   33,
       33,   33,   33,   67,   68,   69,   70,   71,   33,   33,
       33,   33,   33,   33,   72,   73,   33,   33,   33,   33,
       74,   33,   33,   33,   33,   33,   33,   33,   33,   75,
       76,   77,   33,   78,   79,   80,   81,   82,   33,   83,
       84,   85,   33,   33,   33,   33,   33,   86,   87,   33,
       33,   33,   88,   33,   33,   89,   33,   33,   90,   33,
       33,   33,   33,   91,   92,   33,   33,   33,   33,   33,

       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   93,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33
    } ;

static const YY_CHAR yy_meta[94] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    1,    3,    4,    1,
        5,    5,    5,    5,    1,    1,    1,    1,    1,    1,
        5,    5,    6,    1,    1,    1,    1,    5,    5,    5,
        5,    5,    5,    5,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    7,    1,    8,    1,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6

    } ;

static const flex_int16_t yy_base[432] =
    {   0,
        0,   92,  793,  794,  794,  794,  794,  794,  764,   88,
      794,  794,  763,   85,   86,  794,  794,   84,   86,  794,
       87,   85,  102,  105,  112,  765,  794,  111,   82,   91,
      794,    0,  794,  794,  761,  731,   49,  102,   99,  107,
      114,  738,  747,  118,  746,  118,  120,  121,  128,  733,
      731,  736,  794,   97,  794,  794,   98,   58,  124,  194,
      195,  794,  794,  169,  794,  171,  794,  753,  794,  174,
      794,  176,  752,  794,  794,  794,  794,  794,  794,  794,
      760,  191,  195,  794,  750,  794,  203,  226,  238,  250,
      217,  256,  758,  794,  748,  794,  794,  794,  794,  794,

      747,    0,  794,  718,  721,  729,  165,  720,  726,    0,
      714,  711,  154,  718,  717,  711,  713,  711,  707,    0,
      708,  704,  721,  708,  708,  704,  715,  181,  224,  704,
      213,  706,  698,  183,  704,  697,  702,  701,  700,  794,
      718,    0,    0,    0,  717,  716,  663,  158,  669,  161,
      207,  670,  651,  207,  649,  285,  794,  282,  794,  279,
      794,  794,  275,  281,  794,  719,  288,  300,  306,  311,
      318,  332,  320,  340,  675,  328,  794,  794,  684,  686,
      695,  690,  691,  245,  692,  687,  679,  685,  684,  671,
      682,  208,  683,  683,  684,  669,    0,  664,  676,  657,

      661,  667,  660,  667,  664,  655,  672,  654,  259,  653,
      665,  664,    0,  646,  662,  652,  661,  653,  794,  794,
      794,    0,  673,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  672,  671,  670,  293,  678,  363,  367,  352,
      374,  376,  381,  399,  409,  417,  314,  435,  429,  464,
        0,    0,  648,    0,  649,  638,  646,  635,    0,    0,
      637,  636,  643,    0,  636,    0,  625,  639,  627,  620,
      611,  611,    0,  619,  603,  599,  586,    0,  583,  583,
      581,  576,  585,  584,  585,    0,  563,  575,  565,    0,
      568,  794,  794,  794,  794,  794,  387,  588,  463,  424,

      432,  443,  465,  587,  476,  471,  489,  494,  502,  541,
      585,  481,  505,  518,  547,  512,  163,    0,    0,    0,
      552,  553,  545,  558,    0,  554,  551,  548,  541,  527,
      528,  527,  533,  532,    0,  521,  512,  508,  512,  507,
      495,  501,  504,    0,  493,    0,    0,  323,  516,  544,
      336,  514,  554,  577,  349,  368,  507,  578,  400,  458,
      591,  448,  448,  455,    0,  439,  437,    0,  419,    0,
      425,  424,  404,    0,  411,    0,  397,    0,    0,    0,
        0,    0,  390,  794,  794,  426,  794,  309,    0,  374,
        0,  372,  375,    0,  366,  348,  332,  323,    0,  313,

        0,  264,    0,  265,  252,  250,    0,  211,  185,    0,
      147,    0,    0,    0,  100,    0,   98,    0,  794,  640,
      648,  652,  655,  656,  660,  665,  668,  671,  677,  680,
      686
    } ;

static const flex_int16_t yy_def[432] =
    {   0,
      419,    1,  419,  419,  419,  419,  419,  419,  419,  420,
      419,  419,  419,  419,  421,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  422,  419,  419,  419,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  419,  419,  419,  419,  422,  422,  422,  419,
      419,  419,  419,  420,  419,  420,  419,  419,  419,  421,
      419,  421,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  423,  419,  419,  419,  419,  419,  419,  419,

      419,  422,  419,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  419,
      419,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  419,  419,  420,  419,  421,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  424,  423,  419,  419,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,

      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  419,  419,
      419,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  424,  419,  425,  426,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  419,  419,  419,  419,  419,  419,  419,  419,  419,

      419,  419,  419,  419,  419,  419,  419,  419,  427,  428,
      419,  425,  429,  419,  419,  426,  316,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  419,  419,  419,
      419,  419,  419,  427,  354,  419,  419,  429,  358,  430,
      419,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  419,  419,  431,  419,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,

      422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
      422,  422,  422,  422,  422,  422,  422,  422,    0,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419
    } ;

static const flex_int16_t yy_nxt[888] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   25,   25,   26,   27,   28,   29,   30,   31,
       32,   32,   32,   33,    4,   34,   35,   32,   36,   37,
       38,   39,   40,   41,   42,   43,   44,   32,   32,   32,
       45,   32,   46,   47,   48,   49,   50,   51,   52,   32,
       32,   53,   54,   55,   56,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       57,   58,   59,   60,   65,   68,   61,   71,   73,   62,

      105,   76,  106,   81,   78,   82,   82,   82,   82,   98,
       99,   74,   69,   77,   79,   80,   84,   75,  100,  101,
       72,   85,   66,   87,  140,   88,   88,   88,   89,   86,
       87,  145,   89,   89,   89,   89,   90,   95,   96,   97,
      107,  109,   88,   90,   91,  146,   83,   90,  418,   89,
      110,  417,  114,  108,   90,  111,   92,  112,  128,  141,
      115,  120,  129,  130,   93,  116,  113,  121,  122,  125,
      117,  126,  123,  133,  127,   65,  131,  158,  315,  132,
      315,  134,  142,  143,  144,   71,  135,  160,  136,  147,
      148,  149,  150,  151,  188,  156,  156,  152,  156,  156,

      416,  157,  157,   66,  153,   66,  154,  155,   72,  189,
       72,  163,  163,  163,  163,  164,  164,  164,  164,  182,
      183,  166,   90,  167,  167,  167,  167,  203,  163,  223,
      224,  415,  164,   90,   90,  171,  204,  172,  172,  212,
      167,  226,  227,  213,   87,   90,   88,   88,   88,   89,
      265,  208,   83,  414,  172,  266,   87,   90,   89,   89,
       89,   89,  205,   88,  168,  169,  209,  169,   90,   90,
      170,  170,  170,  170,  173,   89,  174,  174,  174,  206,
       90,  228,  233,  234,  229,  230,  156,  170,   65,  156,
       71,  413,  157,  174,  412,  163,  163,  163,  163,  256,

      257,  164,  164,  164,  164,  282,   90,  411,  167,  167,
      167,  167,  163,   72,  410,  283,   66,   90,  164,   90,
      238,  238,  238,  238,   90,  167,  170,  170,  170,  170,
       90,  170,  170,  170,  170,   90,   83,  238,  239,  239,
      243,  243,  243,  170,  236,  309,  249,  400,  170,  168,
      241,  401,  172,  172,  242,  239,  309,  243,  245,  250,
      174,  174,  174,  242,  315,  242,  315,  246,  409,  172,
      250,  246,  297,  297,  242,  248,  408,  174,  246,  240,
      407,  244,  246,  238,  238,  238,  238,  239,  239,  297,
      406,  301,  298,  301,  299,  299,  302,  302,  242,  386,

      238,  243,  243,  243,  239,  242,  405,  297,  297,  242,
      386,  299,  246,  302,  404,  315,  242,  315,  243,  303,
      303,  303,  403,  246,  297,  402,  236,  304,  240,  305,
      305,  305,  307,  399,  307,  300,  303,  308,  308,  308,
      246,  315,  244,  315,  350,  350,  305,  311,  398,  397,
      348,  246,  302,  302,  308,  310,  310,  310,  310,  396,
      313,  350,  395,  302,  302,  310,  310,  394,  393,  302,
      306,  313,  310,  310,  310,  310,  310,  310,  310,  315,
      302,  315,  249,  299,  299,  303,  303,  303,  392,  391,
      314,  353,  353,  353,  242,  317,  305,  305,  305,  419,

      299,  390,  303,  389,  388,  242,  317,  246,  353,  308,
      308,  308,  313,  305,  308,  308,  308,  315,  246,  315,
      315,  356,  315,  313,  300,  387,  308,  419,  351,  419,
      249,  308,  385,  355,  384,  383,  359,  306,  360,  360,
      360,  360,  314,  317,  355,  382,  381,  359,  360,  360,
      380,  379,  378,  377,  317,  360,  360,  360,  360,  360,
      360,  360,  376,  248,  350,  350,  314,  361,  361,  361,
      361,  375,  374,  373,  353,  353,  353,  361,  361,  372,
      371,  350,  370,  369,  361,  361,  361,  361,  361,  361,
      361,  353,  419,  419,  419,  419,  368,  367,  366,  365,

      364,  363,  362,  357,  356,  352,  349,  348,  355,  359,
      347,  361,  361,  361,  361,  346,  345,  351,  344,  355,
      359,  361,  361,  343,  342,  341,  340,  339,  361,  361,
      361,  361,  361,  361,  361,  338,  337,  336,  248,  314,
       64,  335,   64,   64,   64,   64,   64,   64,   70,  334,
       70,   70,   70,   70,   70,   70,  102,  102,  176,  176,
      247,  333,  247,  312,  312,  332,  312,  316,  316,  316,
      354,  331,  354,  330,  354,  310,  329,  328,  310,  358,
      327,  358,  326,  358,  360,  325,  324,  360,  361,  323,
      361,  322,  321,  320,  319,  318,  296,  295,  294,  293,

      292,  291,  290,  289,  288,  287,  286,  285,  284,  281,
      280,  279,  278,  277,  276,  275,  274,  273,  272,  271,
      270,  269,  268,  267,  264,  263,  262,  261,  260,  259,
      258,  255,  254,  253,  252,  251,  248,  237,  235,  232,
      231,  225,  222,  221,  220,  219,  218,  217,  216,  215,
      214,  211,  210,  207,  202,  201,  200,  199,  198,  197,
      196,  195,  194,  193,  192,  191,  190,  187,  186,  185,
      184,  181,  180,  179,  178,  177,  175,  165,  162,  161,
      159,  139,  138,  137,  124,  119,  118,  104,  103,   94,
       67,   63,  419,    3,  419,  419,  419,  419,  419,  419,

      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419
    } ;

static const flex_int16_t yy_chk[888] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,   10,   14,    2,   15,   18,    2,

       37,   19,   37,   22,   21,   22,   22,   22,   22,   29,
       29,   18,   14,   19,   21,   21,   23,   18,   30,   30,
       15,   23,   10,   24,   54,   24,   24,   24,   24,   23,
       25,   58,   25,   25,   25,   25,   24,   28,   28,   28,
       38,   39,   24,   25,   24,   58,   22,   24,  417,   25,
       39,  415,   41,   38,   25,   40,   24,   40,   47,   54,
       41,   44,   47,   48,   24,   41,   40,   44,   44,   46,
       41,   46,   44,   49,   46,   64,   48,   66,  317,   48,
      317,   49,   57,   57,   57,   70,   49,   72,   49,   59,
       59,   59,   59,   59,  113,   60,   61,   59,   60,   61,

      411,   60,   61,   64,   59,   66,   59,   59,   70,  113,
       72,   82,   82,   82,   82,   83,   83,   83,   83,  107,
      107,   87,   82,   87,   87,   87,   87,  128,   82,  148,
      148,  409,   83,   82,   87,   91,  128,   91,   91,  134,
       87,  150,  150,  134,   88,   87,   88,   88,   88,   88,
      192,  131,   82,  408,   91,  192,   89,   88,   89,   89,
       89,   89,  129,   88,   87,   90,  131,   90,   88,   89,
       90,   90,   90,   90,   92,   89,   92,   92,   92,  129,
       89,  151,  154,  154,  151,  151,  156,   90,  158,  156,
      160,  406,  156,   92,  405,  163,  163,  163,  163,  184,

      184,  164,  164,  164,  164,  209,  163,  404,  167,  167,
      167,  167,  163,  160,  402,  209,  158,  163,  164,  167,
      168,  168,  168,  168,  236,  167,  169,  169,  169,  169,
      167,  170,  170,  170,  170,  236,  163,  168,  171,  171,
      173,  173,  173,  169,  164,  247,  176,  388,  170,  167,
      172,  388,  172,  172,  348,  171,  247,  173,  174,  176,
      174,  174,  174,  172,  355,  348,  355,  351,  400,  172,
      176,  174,  240,  240,  172,  247,  398,  174,  351,  171,
      397,  173,  174,  238,  238,  238,  238,  239,  239,  240,
      396,  242,  241,  242,  241,  241,  242,  242,  239,  356,

      238,  243,  243,  243,  239,  241,  395,  297,  297,  239,
      356,  241,  243,  242,  393,  359,  241,  359,  243,  244,
      244,  244,  392,  243,  297,  390,  238,  245,  239,  245,
      245,  245,  246,  383,  246,  241,  244,  246,  246,  246,
      245,  386,  243,  386,  300,  300,  245,  249,  377,  375,
      297,  245,  301,  301,  246,  248,  248,  248,  248,  373,
      249,  300,  372,  302,  302,  248,  248,  371,  369,  301,
      245,  249,  248,  248,  248,  248,  248,  248,  248,  250,
      302,  250,  250,  299,  299,  303,  303,  303,  367,  366,
      249,  306,  306,  306,  299,  250,  305,  305,  305,  312,

      299,  364,  303,  363,  362,  299,  250,  305,  306,  307,
      307,  307,  312,  305,  308,  308,  308,  309,  305,  309,
      313,  360,  313,  312,  299,  357,  307,  316,  303,  316,
      316,  308,  352,  309,  349,  345,  313,  305,  314,  314,
      314,  314,  312,  316,  309,  343,  342,  313,  314,  314,
      341,  340,  339,  338,  316,  314,  314,  314,  314,  314,
      314,  314,  337,  309,  350,  350,  313,  315,  315,  315,
      315,  336,  334,  333,  353,  353,  353,  315,  315,  332,
      331,  350,  330,  329,  315,  315,  315,  315,  315,  315,
      315,  353,  354,  358,  354,  358,  328,  327,  326,  324,

      323,  322,  321,  311,  310,  304,  298,  350,  354,  358,
      291,  361,  361,  361,  361,  289,  288,  353,  287,  354,
      358,  361,  361,  285,  284,  283,  282,  281,  361,  361,
      361,  361,  361,  361,  361,  280,  279,  277,  354,  358,
      420,  276,  420,  420,  420,  420,  420,  420,  421,  275,
      421,  421,  421,  421,  421,  421,  422,  422,  423,  423,
      424,  274,  424,  425,  425,  272,  425,  426,  426,  426,
      427,  271,  427,  270,  427,  428,  269,  268,  428,  429,
      267,  429,  265,  429,  430,  263,  262,  430,  431,  261,
      431,  258,  257,  256,  255,  253,  237,  235,  234,  233,

      223,  218,  217,  216,  215,  214,  212,  211,  210,  208,
      207,  206,  205,  204,  203,  202,  201,  200,  199,  198,
      196,  195,  194,  193,  191,  190,  189,  188,  187,  186,
      185,  183,  182,  181,  180,  179,  175,  166,  155,  153,
      152,  149,  147,  146,  145,  141,  139,  138,  137,  136,
      135,  133,  132,  130,  127,  126,  125,  124,  123,  122,
      121,  119,  118,  117,  116,  115,  114,  112,  111,  109,
      108,  106,  105,  104,  101,   95,   93,   85,   81,   73,
       68,   52,   51,   50,   45,   43,   42,   36,   35,   26,
       13,    9,    3,  419,  419,  419,  419,  419,  419,  419,

      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"
#line 2 "lex.l"
/* $Header$ */

/*
 * Copyright © 1988-2004 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#include	"nickle.h"
#include	"gram.h"
#include	"ref.h"
#include	<strings.h>
#include	<errno.h>
#ifdef HAVE_LIBREADLINE
#include	<readline/readline.h>
#include	<readline/history.h>
#endif
    
/*
 * Silence gcc by providing prototypes for these functions
 */
int yyget_lineno (void);
FILE *yyget_in (void);
FILE *yyget_out (void);
int yyget_leng (void);
char *yyget_text (void);
void yyset_lineno (int);
void yyset_in (FILE *);
void yyset_out (FILE *);
int yyget_debug (void);
void yyset_debug (int);
int yylex_destroy (void);

typedef struct _lexInput {
    DataType		data;
    struct _lexInput	*next;
    Value		file;
    Atom		name;
    int			lineno;
    Bool		at_bol;
    Bool		at_eof;
    Bool		interactive;
} LexInput;

LexInput    *lexInput;
extern int  ignorenl;
extern int  notCommand;
extern int  seeComment;
#define	    FILE_END_CHAR	-2
    
static void lexInputMark (void *object)
{
    LexInput *lex = object;
    
    MemReference (lex->next);
    MemReference (lex->file);
}

static DataType lexInputType = {
    lexInputMark, 0, "lexInputType"
};

void
NewLexInput (Value file, Atom name, Bool after, Bool interactive)
{
    ENTER ();
    LexInput	*lex;

    lex = MemAllocate (&lexInputType, sizeof (*lex));
    lex->file = file;
    lex->name = name;
    lex->lineno = 0;
    lex->at_bol = True;
    lex->at_eof = False;
    lex->interactive = interactive;
    if (after)
    {
	LexInput **prev;
	
	for (prev = &lexInput; *prev; prev = &(*prev)->next)
	    ;
	lex->next = 0;
	*prev = lex;
    } else {
	lex->next = lexInput;
	lexInput = lex;
    }
    EXIT ();
}

#ifdef HAVE_LIBREADLINE

volatile int stdin_in_readline;

static void
my_prep_terminal(int meta_flag)
{
    stdin_in_readline = 1;
    rl_prep_terminal(meta_flag);
}

static void
my_deprep_terminal(void)
{
    rl_deprep_terminal();
    stdin_in_readline = 0;
}

static int
LexGetChar (void);

static int
ReadlineGetChar (FILE *f)
{
    return LexGetChar ();
}
#endif

ReferencePtr	LexInputReference;

void
LexInit (void)
{
    ENTER ();

#if HAVE_LIBREADLINE
    rl_getc_function = ReadlineGetChar;
    rl_prep_term_function = my_prep_terminal;
    rl_deprep_term_function = my_deprep_terminal;
    rl_catch_signals = 0;
#endif
    LexInputReference = NewReference ((void **) &lexInput);
    MemAddRoot (LexInputReference);
    EXIT ();
}

Atom
LexFileName (void)
{
    if (lexInput)
	return lexInput->name;
    return AtomId ("<initialization>");
}

int
LexFileLine (void)
{
    if (lexInput)
	return lexInput->lineno;
    return 0;
}

Bool
LexInteractive (void)
{
    if (lexInput)
	return lexInput->interactive;
    return False;
}

Bool
LexResetInteractive (void)
{
    while (lexInput->next && !lexInput->interactive)
    {
	FileClose (lexInput->file);
	lexInput = lexInput->next;
    }
    if (lexInput->interactive)
	return True;
    return False;
}

Bool
LexFile (char *s, Bool complain, Bool after)
{
    Value	f;
    int		err;

    f = FileFopen (s, "r", &err);
    if (f == 0) {
	if (complain)
	    (void) FilePrintf (FileStderr, "%s: %s\n",
			       s, StringChars (&FileGetErrorMessage (err)->string));
	return False;
    }
    (void) NewLexInput(f, AtomId (s), after, False);
    return True;
}

static int
LexGetChar (void)
{
    int	    c;

    for (;;)
    {
	c = FileInput (lexInput->file);
	if (c >= 0)
	    return c;
	if (c == FileBlocked)
	    ThreadsRun (0, lexInput->file);
	else
	{
	    if (!lexInput->next)
		return FileEOF;
	    lexInput->at_eof = True;
	    return '\n';
	}
    }
}

static Value
prompt (void)
{
    Value	v;
    
    if (ignorenl)
	v = lookupVar (0, "prompt2");
    else if (CurrentFrame)
	v = lookupVar (0, "prompt3");
    else
	v = lookupVar (0, "prompt");
    return v;
}

static int
LexGetInteractiveChar (void)
{
#ifdef HAVE_LIBREADLINE
    static char	*line, *line_base;
    int	    c;

    if (!line)
    {
	char    *p;

	p = StrzPart (prompt (), "invalid prompt");
	if (!p)
	    p = "??? ";
	for (;;)
	{
	    FileFlush (FileStdout, False);
	    FileFlush (FileStderr, False);
	    if (FileStdout->file.flags & FileOutputBlocked)
		ThreadsRun (0, FileStdout);
	    else if (FileStderr->file.flags & FileOutputBlocked)
		ThreadsRun (0, FileStderr);
	    else
		break;
	}
	rl_inhibit_completion = 1;
	line_base = readline (p);
	line = line_base;
	if (!line)
	    return FileEOF;
	add_history (line_base);
    }
    c = (*line++) & 0xff;
    if (!c)
    {
	c = '\n';
	free (line_base);
	line = 0;
    }
    return c;
#else
    if (lexInput->at_bol)
    {
	Value	v = prompt ();
	Print (FileStdout, v, 's', 0, 0, 0, ' ');
	FileFlush (FileStdout, True);
    }
    return LexGetChar ();
#endif
}

#undef YY_INPUT
#define YY_NO_UNPUT

static int yy_input (char *buf, int max_size)
{
    int	    c;
    int	    result = 0;
    
    while (result < max_size) {
	if (lexInput->at_eof)
	{
	    FileClose (lexInput->file);
	    lexInput = lexInput->next;
	}
	if (lexInput->interactive)
	    c = LexGetInteractiveChar ();
	else
	    c = LexGetChar ();
	if (lexInput->at_bol) { lexInput->lineno++; }
	lexInput->at_bol = False;
	if (c < 0) 
	    break;
	buf[result++] = c;
	if (c == '\n')
	{
	    lexInput->at_bol = True;
	    break;
	}
    }
    return result;
}

#define YY_INPUT(buf,result,max_size) ((result) = yy_input (buf, max_size))
    
#ifndef FLEX_SCANNER
#undef		input
#undef		unput
int input (void)
{
    char    buf[1];
    int	    r;

    YY_INPUT(buf, r, 1);
    if (r == 0)
	return 0;
    return buf[0];
}

void unput (char c)
{
    if (c == '\n')
	lexInput->lineno--;
    FileUnput (lexInput->file, c);
}
#endif

#line 1116 "lex.c"
#line 1117 "lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 336 "lex.l"

#line 1339 "lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 420 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 794 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 337 "lex.l"
{   
		    if (seeComment) 
		    {
			yylval.value = lexdoc ();
			return COMMENT_CONST;
		    }
		    else
			skipcomment (); 
		}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 346 "lex.l"
skipline();
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 347 "lex.l"
{ yylval.class = class_auto; return AUTO; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 348 "lex.l"
{ yylval.class = class_const; return CONST; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 349 "lex.l"
{ yylval.class = class_global; return GLOBAL; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 350 "lex.l"
{ yylval.class = class_static; return STATIC; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 351 "lex.l"
{ yylval.type = typePrim[rep_void]; return FUNCTION; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 352 "lex.l"
{ yylval.ints = WHILE; return WHILE; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 353 "lex.l"
{ yylval.ints = FOR; return FOR; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 354 "lex.l"
{ yylval.ints = DO; return DO; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 355 "lex.l"
{ yylval.ints = IF; return IF; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 356 "lex.l"
{ yylval.ints = ELSE; return ELSE; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 357 "lex.l"
{ yylval.ints = SWITCH; return SWITCH; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 358 "lex.l"
{ yylval.ints = BREAK; return BREAK; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 359 "lex.l"
{ yylval.ints = CONTINUE; return CONTINUE; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 360 "lex.l"
{ yylval.ints = CASE; return CASE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 361 "lex.l"
{ yylval.ints = DEFAULT; return DEFAULT; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 362 "lex.l"
{ yylval.ints = RETURNTOK; return RETURNTOK; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 363 "lex.l"
{ yylval.ints = TRY; return TRY; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 364 "lex.l"
{ yylval.ints = CATCH; return CATCH; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 365 "lex.l"
{ yylval.ints = TWIXT; return TWIXT; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 367 "lex.l"
{ yylval.type = typePoly; return POLY; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 368 "lex.l"
{ yylval.type = typePrim[rep_bool]; return BOOL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 369 "lex.l"
{ yylval.type = typePrim[rep_integer]; return INTEGER; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 370 "lex.l"
{ yylval.type = typePrim[rep_rational]; return RATIONAL; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 371 "lex.l"
{ yylval.type = typePrim[rep_float]; return REAL; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 372 "lex.l"
{ yylval.type = typePrim[rep_string]; return STRING; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 373 "lex.l"
{ yylval.type = typePrim[rep_file]; return FILET; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 374 "lex.l"
{ yylval.type = typePrim[rep_semaphore]; return SEMAPHORE; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 375 "lex.l"
{ yylval.type = typePrim[rep_continuation]; return CONTINUATION; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 376 "lex.l"
{ yylval.type = typePrim[rep_thread]; return THREAD; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 377 "lex.l"
{ yylval.ints = STRUCT; return STRUCT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 378 "lex.l"
{ yylval.ints = UNION; return UNION; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 379 "lex.l"
{ yylval.ints = ENUM; return ENUM; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 380 "lex.l"
{ yylval.type = typePrim[rep_void]; return VOID; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 381 "lex.l"
{ yylval.type = typePrim[rep_foreign]; return FOREIGN; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 382 "lex.l"
{ yylval.value = TrueVal; return BOOLVAL; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 383 "lex.l"
{ yylval.value = FalseVal; return BOOLVAL; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 385 "lex.l"
{ yylval.ints = TYPEDEF; return TYPEDEF; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 386 "lex.l"
{ yylval.ints = FUNC; return FUNC; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 387 "lex.l"
{ yylval.ints = FORK; return FORK; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 388 "lex.l"
{ yylval.ints = NAMESPACE; return NAMESPACE; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 389 "lex.l"
{ yylval.ints = IMPORT; return IMPORT; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 390 "lex.l"
{ yylval.ints = EXCEPTION; return EXCEPTION; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 391 "lex.l"
{ yylval.ints = RAISE; return RAISE; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 392 "lex.l"
{ yylval.publish = publish_protected; return PROTECTED; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 393 "lex.l"
{ yylval.publish = publish_public; return PUBLIC; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 394 "lex.l"
{ yylval.publish = publish_extend; return EXTEND; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 395 "lex.l"
{ yylval.ints = ISTYPE; return ISTYPE; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 396 "lex.l"
{ yylval.ints = HASMEMBER; return HASMEMBER; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 397 "lex.l"
{ yylval.ints = SEMI; return SEMI; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 398 "lex.l"
{ yylval.ints = COMMA; return COMMA; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 399 "lex.l"
{ yylval.ints = DOLLAR; return DOLLAR; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 400 "lex.l"
{ yylval.ints = DOTDOTDOT; return DOTDOTDOT; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 401 "lex.l"
{ yylval.ints = DOTDOTDOT; return DOTDOTDOT; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 402 "lex.l"
{ yylval.ints = DOT; return DOT; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 403 "lex.l"
{ yylval.ints = ARROW; return ARROW; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 404 "lex.l"
{ yylval.ints = ARROW; return ARROW; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 405 "lex.l"
{ yylval.ints = DARROW; return DARROW; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 406 "lex.l"
{ yylval.ints = DARROW; return DARROW; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 407 "lex.l"
{ yylval.value = Void; return VOIDVAL; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 408 "lex.l"
{ yylval.value = Void; return VOIDVAL; }
	YY_BREAK
case 63:
/* rule 63 can match eol */
YY_RULE_SETUP
#line 409 "lex.l"
{ 
		    if (lexInput->at_eof) { strcpy (yytext, "EOF"); yylval.ints = ENDFILE; return ENDFILE; }
		    if (!ignorenl) { yylval.ints = NL; return NL; } 
		}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 413 "lex.l"
{ yylval.ints = OP; ++ignorenl; return OP; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 414 "lex.l"
{ yylval.ints = CP; if (ignorenl > 0) --ignorenl; return CP; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 415 "lex.l"
{ yylval.ints = STAROS; ++ignorenl; return STAROS; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 416 "lex.l"
{ yylval.ints = OS; ++ignorenl; return OS; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 417 "lex.l"
{ yylval.ints = CS; if (ignorenl > 0) --ignorenl; return CS; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 418 "lex.l"
{ yylval.ints = OC; ++ignorenl; return OC; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 419 "lex.l"
{ yylval.ints = CC; if (ignorenl > 0) --ignorenl; return CC; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 420 "lex.l"
{ yylval.ints = ASSIGNPLUS; return ASSIGNPLUS; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 421 "lex.l"
{ yylval.ints = ASSIGNMINUS; return ASSIGNMINUS; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 422 "lex.l"
{ yylval.ints = ASSIGNTIMES; return ASSIGNTIMES; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 423 "lex.l"
{ yylval.ints = ASSIGNTIMES; return ASSIGNTIMES; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 424 "lex.l"
{ yylval.ints = ASSIGNDIVIDE; return ASSIGNDIVIDE; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 425 "lex.l"
{ yylval.ints = ASSIGNDIVIDE; return ASSIGNDIVIDE; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 426 "lex.l"
{ yylval.ints = ASSIGNDIV; return ASSIGNDIV; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 427 "lex.l"
{ yylval.ints = ASSIGNDIV; return ASSIGNDIV; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 428 "lex.l"
{ yylval.ints = ASSIGNMOD; return ASSIGNMOD; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 429 "lex.l"
{ yylval.ints = ASSIGNPOW; return ASSIGNPOW; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 430 "lex.l"
{ yylval.ints = ASSIGNPOW; return ASSIGNPOW; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 431 "lex.l"
{ yylval.ints = ASSIGNSHIFTL; return ASSIGNSHIFTL; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 432 "lex.l"
{ yylval.ints = ASSIGNSHIFTL; return ASSIGNSHIFTL; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 433 "lex.l"
{ yylval.ints = ASSIGNSHIFTR; return ASSIGNSHIFTR; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 434 "lex.l"
{ yylval.ints = ASSIGNSHIFTR; return ASSIGNSHIFTR; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 435 "lex.l"
{ yylval.ints = ASSIGNLXOR; return ASSIGNLXOR; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 436 "lex.l"
{ yylval.ints = ASSIGNAND; return ASSIGNAND; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 437 "lex.l"
{ yylval.ints = ASSIGNOR; return ASSIGNOR; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 438 "lex.l"
{ yylval.ints = ASSIGNLAND; return ASSIGNLAND; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 439 "lex.l"
{ yylval.ints = ASSIGNLOR; return ASSIGNLOR; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 440 "lex.l"
{ yylval.ints = ASSIGN; return ASSIGN; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 442 "lex.l"
{ yylval.ints = PLUS; return PLUS; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 443 "lex.l"
{ yylval.ints = MINUS; return MINUS; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 444 "lex.l"
{ yylval.ints = TIMES; return TIMES; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 445 "lex.l"
{ yylval.ints = TIMES; return TIMES; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 446 "lex.l"
{ yylval.ints = DIVIDE; return DIVIDE; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 447 "lex.l"
{ yylval.ints = DIVIDE; return DIVIDE; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 448 "lex.l"
{ yylval.ints = DIV; return DIV; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 449 "lex.l"
{ yylval.ints = DIV; return DIV; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 450 "lex.l"
{ yylval.ints = STARSTAR; return STARSTAR; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 451 "lex.l"
{ yylval.ints = STARSTAR; return STARSTAR; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 452 "lex.l"
{ yylval.ints = MOD; return MOD; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 453 "lex.l"
{ yylval.ints = BANG; return BANG; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 454 "lex.l"
{ yylval.ints = POUND; return POUND; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 455 "lex.l"
{ yylval.ints = LAND; return LAND; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 456 "lex.l"
{ yylval.ints = LOR; return LOR; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 457 "lex.l"
{ yylval.ints = LXOR; return LXOR; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 458 "lex.l"
{ yylval.ints = LNOT; return LNOT; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 459 "lex.l"
{ yylval.ints = LNOT; return LNOT; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 460 "lex.l"
{ yylval.ints = INC; return INC; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 461 "lex.l"
{ yylval.ints = INC; return INC; }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 462 "lex.l"
{ yylval.ints = DEC; return DEC; }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 463 "lex.l"
{ yylval.ints = EQ; return EQ; }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 464 "lex.l"
{ yylval.ints = NE; return NE; }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 465 "lex.l"
{ yylval.ints = NE; return NE; }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 466 "lex.l"
{ yylval.ints = LT; return LT; }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 467 "lex.l"
{ yylval.ints = GT; return GT; }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 468 "lex.l"
{ yylval.ints = LE; return LE; }
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 469 "lex.l"
{ yylval.ints = LE; return LE; }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 470 "lex.l"
{ yylval.ints = GE; return GE; }
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 471 "lex.l"
{ yylval.ints = GE; return GE; }
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 472 "lex.l"
{ yylval.ints = AND; return AND; }
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 473 "lex.l"
{ yylval.ints = AND; return AND; }
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 474 "lex.l"
{ yylval.ints = OR; return OR; }
	YY_BREAK
case 125:
YY_RULE_SETUP
#line 475 "lex.l"
{ yylval.ints = OR; return OR; }
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 476 "lex.l"
{ yylval.ints = SHIFTL; return SHIFTL; }
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 477 "lex.l"
{ yylval.ints = SHIFTL; return SHIFTL; }
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 478 "lex.l"
{ yylval.ints = SHIFTR; return SHIFTR; }
	YY_BREAK
case 129:
YY_RULE_SETUP
#line 479 "lex.l"
{ yylval.ints = SHIFTR; return SHIFTR; }
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 480 "lex.l"
{ yylval.ints = QUEST; return QUEST; }
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 481 "lex.l"
{ yylval.ints = COLONCOLON; return COLONCOLON; }
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 482 "lex.l"
{ yylval.ints = COLON; return COLON; }
	YY_BREAK
case 133:
YY_RULE_SETUP
#line 483 "lex.l"
{ yylval.ints = POW2; return POW2; }
	YY_BREAK
case 134:
YY_RULE_SETUP
#line 484 "lex.l"
{ yylval.ints = POW3; return POW3; }
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 485 "lex.l"
;
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 486 "lex.l"
;
	YY_BREAK
case 137:
YY_RULE_SETUP
#line 487 "lex.l"
;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 488 "lex.l"
{
			ENTER ();
			char	    *s;
			long	    len = yyleng - 1;
			unsigned    c;

			s = yytext + 1;
			s = StringNextChar (s, &c, &len);
			if (c == '\\')
			{
			    if (!(s = StringNextChar (s, &c, &len)))
				c = 0;
			    else if ('0' <= c && c <= '7')
			    {
				unsigned    ch;
				char	    *ps = s;

				c = c - '0';
				while ((s = StringNextChar (s, &ch, &len)) &&
				       '0' <= ch && ch <= '7')
				{
				    c = (c << 3) | (ch - '0');
				    ps = s;
				}
				s = ps;
			    }
			    else
				c = lexEscape (c);
			}
			yylval.value = NewInt (c);
			EXIT ();
			REFERENCE (yylval.value);
			return CHAR_CONST;
		}
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 522 "lex.l"
{
			ENTER ();
			char	    *d, *s;
			unsigned    c;
			long	    len = yyleng - 2;

			yylval.value = NewString (len);
			d = StringChars (&yylval.value->string);
			s = yytext + 1;
			while ((s = StringNextChar (s, &c, &len)))
			{
			    if (c == '\\')
			    {
				if (!(s = StringNextChar (s, &c, &len)))
				    break;
				if ('0' <= c && c <= '7')
				{
				    unsigned	ch;
    				    char	*ps = s;
				    long	plen = len;

				    c = c - '0';
				    while ((s = StringNextChar (s, &ch, &len)) &&
					   '0' <= ch && ch <= '7')
				    {
					c = (c << 3) | (ch - '0');
					ps = s;
					plen = len;
				    }
				    s = ps;
				    len = plen;
				}
				else
				    c = lexEscape (c);
			    }
			    d += StringPutChar (c, d);
			}
			*d = '\0';
			yylval.value->string.length = d - StringChars(&yylval.value->string);
			EXIT ();
			REFERENCE (yylval.value);
			return STRING_CONST;
		}
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 565 "lex.l"
{
		yylval.value = Zero;
		return TEN_NUM;
		}
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 569 "lex.l"
{
		yylval.value = atov(yytext+1, 8);
		return OCTAL0_NUM;
		}
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 573 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 143:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 577 "lex.l"
{
		yylval.value = aetov(yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 144:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 581 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 585 "lex.l"
{
		yylval.value = aetov (yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 589 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 147:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 593 "lex.l"
{
		yylval.value = aetov(yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 148:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 597 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 601 "lex.l"
{
		yylval.value = aetov (yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 605 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 151:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 609 "lex.l"
{
		yylval.value = aetov(yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 152:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 613 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 617 "lex.l"
{
		yylval.value = aetov (yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 154:
YY_RULE_SETUP
#line 621 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 155:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 625 "lex.l"
{
		yylval.value = aetov(yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 156:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 629 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 157:
YY_RULE_SETUP
#line 633 "lex.l"
{
		yylval.value = aetov (yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 158:
YY_RULE_SETUP
#line 637 "lex.l"
{
	        CommandPtr	c;
		SymbolPtr	symbol;
		yylval.atom = AtomId (yytext);
		if (!notCommand && (c = CommandFind (CurrentCommands, yylval.atom)))
		{
		    if (c->names)
			return NAMECOMMAND;
		    return COMMAND;
		}
		if (LexNamespace)
		    symbol = NamespaceFindName (LexNamespace, yylval.atom, False);
	        else
		    symbol = NamespaceFindName (CurrentNamespace, yylval.atom, True);
		if (symbol)
		{
		    switch (symbol->symbol.class) {
		    case class_namespace:
			return NAMESPACENAME;
		    case class_typedef:
			return TYPENAME;
		    default:
			break;
		    }
		}
		return NAME;
		}
	YY_BREAK
case 159:
YY_RULE_SETUP
#line 664 "lex.l"
FilePrintf (FileStderr, "character \\%o ignored\n", *yytext & 0xff);
	YY_BREAK
case 160:
YY_RULE_SETUP
#line 665 "lex.l"
ECHO;
	YY_BREAK
#line 2388 "lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 420 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 420 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 419);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 665 "lex.l"


int
lexEscape (int c)
{
    switch (c) {
    case '0':
	return '\0';
	break;
    case 'b':
	return '\b';
	break;
    case 'n':
	return '\n';
	break;
    case 'r':
	return '\r';
	break;
    case 't':
	return '\t';
	break;
    case 'f':
	return '\f';
	break;
    case 'v':
	return '\v';
	break;
    default:
	return c;
    }
}


Value
lexdoc (void)
{
    int	    c;
    Value   s = NewStrString ("");

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return Void;
    }
    for (;;) {
	Bool skip = False;
	while (c != EOF && c != '*')
	{
	    if (skip && c != ' ' && c != '\t')
		skip = False;
	    if (!skip)
		s = Plus (s, NewCharString (c));
	    if (c == '\n')
		skip = True;
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    break;
	if (!skip)
	    s = Plus (s, NewCharString ('*'));
    }
    return s;
}

void
skipcomment (void)
{
    int	c;

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return;
    }
    for (;;) {
	while (c != EOF && c != '*')
	{
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    return;
    }
}

void
skipline (void)
{
    int	    c;

    do {
	c = input();
    } while (c != EOF && c != '\n');
}

Value
atov (char *s, int base)
{
    ENTER ();
    Value	result;
    Value	b;
    char	c;
    int		i;

    b = NewInt (base);
    result = NewInt (0);
    for (;;) {
	c = *s++;
	if ('0' <= c  && c <= '9')
	    i = c - '0';
	else if ('a' <= c && c <= 'z')
	    i = c - 'a' + 10;
	else if ('A' <= c && c <= 'Z')
	    i = c - 'A' + 10;
	else if (c == '_')
	    continue;
	else
	    break;
	if (i >= base)
	    break;
	result = Plus (NewInt (i), Times (result, b));
    }
    RETURN (result);
}

static char *
scan_number(char *s, char needle, int *lenp)
{
    int len = 0;
    for (;;) {
	char c = *s;
	if (tolower(c) == needle)
	    break;
	switch (c) {
	case '\0':
	    return NULL;
	case '_':
	    break;
	default:
	    len++;
	    break;
	}
	s++;
    }
    if (lenp)
	*lenp = len;
    return s;
}

static int
number_len(char *s)
{
    int len = 0;
    char c;
    while ((c = *s++))
	if (c != '_')
	    len++;
    return len;
}

Value
aetov (char *s, int base)
{
    ENTER ();
    char    *int_part, *frac_part, *rep_part, *exp_part, *next;
    int	    sign, int_len = -1, frac_len = -1, rep_len = -1, exp_frac_len = -1, esign;
    Value   v, sv;

    int_part = s;
    sign = 1;
    if (*int_part == '+')
	int_part++;
    else if (*int_part == '-') {
	int_part++;
	sign = -1;
    }
    next = int_part;
    frac_part = scan_number(next, '.', &int_len);
    frac_len = -1;
    rep_part = 0;
    rep_len = 0;
    esign = 1;
    if (frac_part) {
	frac_part++;
	next = frac_part;
	rep_part = scan_number(next, '{', &frac_len);
	if (rep_part)
	{
	    rep_part++;
	    next = rep_part;
	    next = scan_number(next, '}', &rep_len);
	    if (!next)
		RETURN(Void);	/* can't happen */
	}
    }
    exp_part = scan_number(next, 'e', &exp_frac_len);
    if (exp_part) {
	if (frac_len < 0)
	    frac_len = exp_frac_len;
	exp_part++;
	if (*exp_part == '+')
	    exp_part++;
	else if (*exp_part == '-') {
	    esign = -1;
	    exp_part++;
	}
    } else if (frac_len < 0 && frac_part)
	frac_len = number_len(frac_part);
    v = atov (int_part, base);
    if (frac_part)
    {
	v = Plus (v, Divide (atov (frac_part, base),
				 Pow (NewInt (base),
				       NewInt (frac_len))));
    }
    if (rep_part)
    {
	Value	rep;

	rep = Divide (atov (rep_part, base), Minus (Pow (NewInt (base),
						       NewInt (rep_len)),
						  One));
	if (frac_len)
	    rep = Divide (rep, Pow (NewInt (base),
				    NewInt (frac_len)));
	v = Plus (v, rep);
    }
    if (exp_part)
    {
	sv = Pow (NewInt (base), atov (exp_part, base));
	if (esign > 0)
	    v = Times (v, sv);
	else
	    v = Divide (v, sv);
    }
    if (sign == -1)
	v = Negate (v);
    RETURN (v);
}

