
/*
         
    plant.h planet structures derived from Shiva Iyer
    Copyright (C) 2011 Enas Giovanni <gio.enas@alice.it>
 
    This file is part of Nautic.

    Nautic is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Nautic is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Nautic.  If not, see <http://www.gnu.org/licenses/>.

 */

#ifndef PLANT_H
#define PLANT_H

#define NARGS 18

struct plantbl {
  char maxargs;
  char max_harmonic[NARGS];
  char max_power_of_t;
  char  *arg_tbl;
  void  *lon_tbl;
  void  *lat_tbl;
  void  *rad_tbl;
  double distance;
  double timescale;
  double trunclvl;
};


static long  tabl[] = {
   -242809,   -178223,     -6154,     -6547,

     15526,    -79460,     66185,    -19531,

    -12754,      4389,      3153,     -1151,
       768,      1750,

      -248,       657,       -80,         0,

        -4,       -29,

     -3020,       301,      -360,       412,
     -1463,      2266,

       -41,        30,

    -39868,    -14275,    -25052,      1583,
     15695,     10018,

      -113,      -122,

      -243,        18,       -33,        31,

      -134,      -171,       243,      -115,

        18,       148,

      -120,      -129,        19,      -220,

       -30,        19,

         8,        23,

      -162,      -124,       189,      -315,

        73,        77,

     32006,    -11295,     11595,      5629,
      -838,      1728,

         0,         4,

        38,        15,

       142,      -228,        92,        32,

     -2274,     -1500,     -2277,      3143,
      3204,       127,

       -20,       -11,

      5186,      1054,       996,      1769,
      -231,       163,

       -88,       -19,

        -2,      -145,

       -27,        48,

        -8,       421,

        -7,       148,

       -16,        -2,

     -3964,      4259,    -11192,     -8385,
     11513,    -13415,

       103,       -43,

      -289,       -79,       -29,       163,

      -117,       559,      -190,       -15,

      7108,      5345,     12933,     -7709,
      3485,    -26023,

        11,        -5,

       311,        78,        22,        76,

      2846,     -3922,      2329,        43,
        34,       442,

         3,      -245,

        -5,        -3,

       -17,         5,

       318,     15963,      2520,      7115,
      2548,     -9836,

     -7063,      1950,     -4471,     -8326,
      4964,     -3101,

       563,       -80,     -1444,      -472,

         8,       -22,

      1558,       -88,       235,       359,

       293,       -16,       144,       209,

       -13,        -7,

       812,      -744,       150,      -740,

     -2569,      -956,        69,     -2475,
      1009,       -55,

     -1707,     -2525,      1071,     -1761,
       550,       279,

       -14,        36,

    -10442,      3344,     -6759,    -21551,
     24737,      -434,

       504,      -385,       191,        96,

     -2760,     -1068,        85,     -2617,
      1062,       -43,

       192,       -16,        30,        42,

     -2446,       588,     -1522,     -2933,
      1746,     -1070,

       511,     -1401,       139,       729,

       -12,        29,

     -2618,     -2076,      2079,     -3711,

       -21,     -2727,

       -80,       -19,

       113,      2420,       325,      1058,
       379,     -1478,

       296,      -251,      -265,      -409,

       -10,        20,

        15,       -15,

        11,       143,       -83,        19,

       266,       -17,        40,        59,

        19,      -105,         5,     48331,

        21,       -16,

       -97,      -318,       158,      -171,

       456,      -351,       168,        85,

        12,        -2,

        20,       -15,

        15,         2,

       385,     -1125,       521,       -23,

      -815,     -2088,      1644,     -1329,

         7,        14,

      -582,       234,       -67,      -467,

      -167,       -51,

      -684,     -2302,      1315,      -797,

         6,       -70,

      -118,      -406,        67,       -63,

     -4848,      3713,     -8483,     -8776,
     13049,     -9404,

       -23,        34,

       -12,         1,

       -24,       -10,

       -21,         0,

        -1,        24,

        -3,        28,

     -3032,     -2494,      2498,     -4342,

     -6538,      1899,     -4414,    -13249,
     15540,      -292,

      -228,       176,       -40,      -161,

       -20,       -36,

      -800,      -172,       -36,      -208,

      -249,      -374,     -1410,    -72118,

      -745,       213,       -23,       196,

       -14,        -2,

      -239,      -341,      1015,      -291,

        33,       -94,        90,    -20431,

         4,       -39,

        75,       216,       -23,        41,

       116,        24,         5,        26,

       -45,     -4178,

        -9,       -23,

        12,        18,

        68,        -2,

        36,       -19,

        42,        -8,

         6,      -106,

         4,       -38,

       -73,       259,       107,      -293,

       -12,       -44,        37,        13,

        73,       -46,        17,         8,

      5832,      1989,     -1404,      4469,
     -1619,      -743,

     -1796,     -2206,       461,      -291,
       153,      1104,

     19195,    652503,      5587,  -5252787,
        47, -17340051,       -32,  68926621,

      1054,      -230,     -1601,       356,
      -562,      -998,

       124,      -446,      -171,        66,
        26,        60,

        -7,         0,

       -88,       -43,        65,      -400,

         4,       183,

     -1014,      2043,     -1076,       126,
       -41,      -205,

      -127,       -85,       -15,        68,

         0,         0,

      -320,        75,       -42,       285,

      -303,       771,       616,       400,

      -470,        48,       -76,      -103,

      -190,       -11,

      -139,        -5,       -48,       -87,

       -22,      -362,      -271,      1233,

      -392,       353,      -154,       -71,

      -109,       112,

        17,         8,

         1,       -17,

      -170,       623,      -279,        21,

       139,      -151,      -107,    -55199,

       588,      -188,       397,       674,
      -406,       269,

       166,      -207,       585,       333,
      -386,       754,

        29,       -65,

        35,        10,

        63,      1291,

        62,         8,

       239,      1323,     -1434,        53,

        19,        -1,

        34,        82,

       -15,       -16,

       265,      -338,      -729,      -207,

         3,        17,

       697,       399,       274,       760,

       -12,         2,

       -48,        -9,

         3,        64,

       147,        36,         9,        46,

        77,       144,       -76,        65,

      2329,      1763,       987,      5506,

        66,      -123,       -41,       -24,

       -12,         1,

       -19,        94,

        19,         8,

        -1,       -18,

       142,        77,       -78,       187,

         6,        18,

       607,       163,        17,       158,

        27,      -208,       154,     27317,

       587,      -143,        22,      -153,

         5,       -34,

        75,       330,

        98,      -128,       -67,     -6542,

      -115,      -236,       217,       -12,

        10,        -6,

      -250,       653,      1611,      -209,

         4,      1072,

      -129,       216,       402,        81,

       117,        11,

         0,        20,

        24,       -28,

       245,       437,       -16,        59,

    527952,    -74895,    169682,    177186,
      -376,   -362869,       -60,    719658,

      -151,      -382,       -22,       -43,

         5,        -5,

        14,         5,

        -9,        13,

        83,       296,      -369,        -1,

       -14,        -6,

        42,         8,

       -31,         7,

      -354,       634,      1132,       243,

       -38,        42,

       -14,        68,

        -6,        31,

       -36,       -13,

         7,     -2104,

        16,        67,

         9,        -4,

       174,       144,        58,       438,

       -15,         5,

       -16,        19,

      -135,      1642,

      -140,       -11,

        -4,        27,

       253,      -382,      -651,      -221,

        11,         1,

       -12,        -6,

       136,        23,

        -1,        43,

         3,        38,

       -26,        -5,

     17864,     -4244,      5704,      7754,
       -36,     -7891,        -3,     10418,

         2,      -844,

        -1,       126,

        -7,        32,

       -67,        -5,

        39,        10,

         5,        52,

       -13,       159,

       -49,       -21,

         1,      -394,

         7,       -15,

        -4,      -245,         1,       172,

       -36,        -3,

        13,         5,

         0,         1,

        -1,         0,         0,      -202,

        -2,        19,

       -20,        -2,

         5,         3,

         0,      -110,

       -12,        -1,

         0,       -62,

         0,       -36,

         0,       -22,

       -13,         3,

};
static long  tabb[] = {
   -428091,   -488399,    746850,         6,

       210,       -93,        32,         1,

      -365,       332,      -105,        76,
        -7,         2,

        -8,        14,        -1,         2,

         0,         0,

       -65,        12,       -17,         7,
        -1,         1,

         0,         0,

       -15,        65,        -4,        26,
        -2,         0,

         0,         0,

         0,         2,         0,         0,

         2,         2,         0,         0,

         0,         0,

        -1,        -3,         0,         0,

         0,         0,

         0,         0,

        -2,         0,         0,         0,

        -1,         0,

       -30,        28,        -6,        10,
         0,         0,

         0,         0,

         0,         0,

         2,         0,         0,         0,

       -16,        20,        -6,       -41,
        -9,        -3,

         0,         0,

        -6,         2,         2,         0,
         0,         0,

         0,         0,

         0,         0,

         0,         0,

         0,         0,

         0,         0,

         0,         0,

       -96,        33,       -12,       228,
       -23,       -21,

         0,         0,

       -12,        -2,        -4,         4,

        -1,         0,         1,         0,

      -329,       -22,       -34,      -726,
      -147,       -21,

         0,         0,

        -2,         4,        -1,         0,

         2,        -7,         0,         1,
         0,         0,

         0,         0,

         0,         0,

         0,         0,

        36,        88,      -162,       -19,
       -11,        21,

        31,        37,       -31,        53,
        -5,       -15,

        -3,       -11,         9,         3,

         0,         0,

        -2,         0,         1,         0,

         2,        -1,         0,         0,

         0,         0,

      -162,      -102,       -37,        30,

        19,        23,       -18,         9,
         1,        -6,

        -6,        22,        -2,         3,
         1,        -2,

         0,        -1,

        26,       -25,        66,        52,
      -641,      -153,

       -13,        -9,         2,        -3,

       -29,         8,        -6,        -2,
         0,        -6,

         2,        -4,         1,         0,

       -26,       -11,        -1,       -10,
        -6,       -13,

        66,     -1337,      -879,      -207,

         1,        -1,

         8,       -30,       -24,       -18,

       -16,         1,

         9,         1,

       -24,        -8,         9,       -17,
       -13,        75,

        19,        -8,       -29,        24,

         0,         0,

        -1,         1,

       -25,        36,        -7,       -22,

         0,        -3,         1,        -1,

       187,       -46,        -6,        74,

         5,       -10,

        -5,        -4,       -16,        10,

        -5,        -5,         2,        -4,

         5,        -2,

        -2,         1,

        -1,         0,

       -16,       -12,         1,       -13,

       -17,      -111,      -186,        73,

        -1,        -2,

      -277,       -77,       -27,       106,

        16,         5,

       -12,       -15,       -13,       -30,

        -1,         1,

         0,        36,       -10,         4,

       607,       262,       533,     -1530,
     -1630,       304,

         8,        -6,

         1,         1,

         0,        -1,

         5,        -2,

         0,        -1,

        -1,        -4,

       -44,       -22,       -64,       -46,

       537,       430,       268,     -1553,
     -2040,      -486,

        -3,       -23,        20,        41,

        -1,         2,

       -21,        -4,        -1,        -3,

       -84,        50,      -177,        26,

         5,       -12,         2,        -4,

         7,         1,

      -115,      -305,      -310,       138,

      -186,       246,       -96,        17,

         0,         0,

         4,        -2,         1,         1,

        -3,         2,        -1,         0,

       -15,        68,

         0,         2,

        -3,         0,

        -5,         0,

        -1,         1,

        -5,         6,

         0,         0,

         0,         0,

      -235,       -98,        -2,         2,

         9,       -40,        -1,        -2,

       -33,        -9,        -5,        -4,

      5662,     -3849,      1941,      -124,
       210,       160,

    -24721,    -72945,      4099,    -21914,
      1345,      -555,

  23637393,  -5516830,  17737677,  43330654,
 -44668315,  14540723,      -824,     -2086,

     -4423,    -41801,      5562,    -11664,
       960,      -125,

      2001,      -149,       587,      -350,
        23,       -52,

        -3,         3,

      -248,      -148,       -40,        86,

         2,         0,

        21,       -82,        11,         8,
        -8,         0,

       -30,       -33,       -22,        46,

         0,      -191,

      -168,      -135,        27,       -85,

        14,       232,       217,        59,

         5,        12,        -5,         2,

       -24,       -26,

       -52,        13,        -3,        18,

        26,        45,        32,      -169,

        14,        -6,        -3,         4,

        -5,         2,

         6,         2,

        -2,         3,

        20,       -15,         0,        10,

      -486,        -8,         4,      -114,

       102,      -188,        23,       -67,
         6,        12,

       -43,        -1,       -32,         2,
        15,         9,

        16,       -36,

        -6,        -2,

        14,        -5,

        17,       -15,

       -28,       307,       289,        69,

         2,        -7,

         3,        -1,

        -1,         1,

       -16,      -811,       287,       -68,

         0,         0,

         0,        -1,        16,        -7,

         0,         0,

         0,         2,

         0,         0,

         0,        -1,         1,         0,

        -3,        -4,         2,         3,

       -29,        34,        59,       -15,

        -3,        -3,        -1,         0,

        -2,        -3,

         3,       -19,

         0,         0,

         0,         0,

       -15,         1,         5,         2,

         0,         0,

        -1,        -5,         0,        -1,

      -120,        84,         7,       -30,

        -7,        -3,        -1,         0,

         0,        -1,

         9,        -6,

      -186,       -11,        13,       -57,

         1,         4,         1,        -1,

         0,         0,

        -5,       796,        46,         5,

        -1,        -6,

       -10,       228,         5,        -6,

         1,        -5,

         0,         0,

        -6,        -2,

       148,       137,        10,        28,

    430546,   -279834,    488902,    664558,
   -746515,    243112,       -39,       -37,

       -13,      -174,         6,       -25,

         2,        -3,

        -4,        -2,

         0,         4,

        -5,        70,        82,        20,

         0,         1,

         1,         1,

         0,         1,

       -27,       430,       226,       -53,

         1,         1,

         0,         1,

         1,        -7,

         2,         1,

        -3,        -8,

         1,         0,

        -1,        12,

        -2,        -5,         4,         0,

         0,         1,

         1,         1,

         1,         9,

        33,         4,

         0,         0,

         0,      -321,         4,         1,

         0,         0,

         1,         0,

       106,       -22,

         0,         0,

         4,         0,

         0,         2,

      7006,     -9443,     12833,     11137,
    -14037,      4575,        -2,         0,

        -1,        -6,

         1,         1,

         4,         6,

        16,         2,

        55,       -10,

         1,         0,

         0,         1,

         0,         2,

         0,        -4,

        -2,         0,

      -351,        24,         0,         0,

         8,         1,

        30,        -5,

       -12,        10,

        -4,         1,        -1,        -2,

         0,         0,

         4,         0,

        17,        -3,

         0,        -2,

         2,         0,

         0,        -1,

         0,        -1,

         0,         0,

         0,         0,

};
static long  tabr[] = {
     14575,    -26192,   -144864,         2,

       -22,        15,        -8,       -21,

      -148,      -104,       -14,       -75,
        15,         2,

        -5,        -3,        -1,         0,

         0,         0,

         0,        21,        -2,         7,
        -5,        -3,

         0,         0,

        83,       -94,         9,       -67,
       -29,        50,

         1,        -1,

         3,         2,         0,         0,

         4,         3,         1,         1,

        -1,        -1,

         0,        -1,         2,        -1,

         0,         1,

         0,         0,

        -2,         3,        -5,        -2,

        -1,         1,

       197,       511,       -82,       189,
       -28,       -12,

         0,         0,

         0,        -1,

         6,        -1,         0,         1,

        30,       -30,       -37,       -25,
         6,        21,

         0,         0,

        16,      -139,        43,       -28,
         4,         6,

         0,         3,

         4,         0,

         1,         1,

       -13,         0,

        -4,         0,

         0,         1,

       150,       135,      -291,       436,
      -560,      -343,

         1,         3,

         8,       -15,       -13,        -5,

       -17,        -3,         1,        -6,

      -314,       428,       606,       758,
      1230,      -411,

         0,        -1,

        11,       -14,         4,         1,

       221,       157,         1,       132,
       -25,         3,

        12,         0,

         0,         0,

         0,        -1,

      1487,      -108,       707,       -79,
      -950,      -190,

       177,       582,      -676,       399,
      -281,      -396,

         0,        52,        39,      -130,

         2,         1,

        12,       148,       -34,        23,

         1,        27,       -20,        13,

         1,        -1,

       198,       -34,       -21,       -80,

       -99,       332,      -307,         9,
       -15,      -125,

       330,      -231,       236,       139,
       -36,        74,

         7,         3,

      -588,     -1722,      3623,     -1245,
       187,      4366,

       -72,       -75,        11,       -33,

       174,      -467,       444,         9,
        11,       180,

        -6,       -39,         8,        -7,

      -126,      -500,       599,      -317,
       224,       355,

      -590,       -39,       134,      -379,

        -7,        -3,

       494,      -628,       893,       490,

       712,        -7,

        -7,        35,

      -720,        50,      -321,        72,
       443,       106,

        74,        82,       112,       -84,

        -6,        -3,

         5,         4,

        58,         7,        -2,        38,

         6,        92,       -20,        14,

        33,        13,    -11189,        -2,

       -11,        -8,

       106,       -35,        58,        52,

       132,       170,       -32,        63,

        -2,        -6,

         6,         7,

        -1,         6,

       452,       155,         9,       209,

       788,      -318,       511,       616,

        -5,         3,

       142,       303,      -280,        32,

        21,       -69,

       984,      -291,       340,       562,

        30,         2,

       171,       -51,        27,        28,

     -1570,     -2053,      3702,     -3593,
      4012,      5467,

       -14,        -9,

        -1,        -6,

         4,       -11,

         0,        -9,

       -11,         0,

        15,         2,

      1133,     -1366,      1961,      1134,

      -867,     -3010,      6041,     -2049,
       142,      7138,

       -79,      -103,        73,       -18,

        17,        -9,

        79,      -372,        97,       -17,

       182,      -118,     33577,      -675,

       -99,      -347,       -91,       -11,

         1,        -7,

       158,      -111,       136,       474,

        50,        16,      9739,        51,

        19,         2,

      -105,        36,       -20,       -11,

       -12,        56,       -13,         2,

      2030,       -22,

        11,        -4,

         9,        -6,

         1,        33,

        10,        18,

         4,        21,

        53,         3,

        19,         2,

       130,        37,      -147,       -54,

       -22,         6,         7,       -19,

        22,        36,        -4,         8,

      -949,      2911,     -2221,      -697,
       371,      -808,

      1203,     -1117,       191,       189,
      -549,        77,

   -321201,     19788,   2622593,      5990,
   8667033,       114, -34455835,        86,

       -92,      -493,       179,       807,
      -499,       281,

       225,        51,       -34,       -88,
       -30,        13,

         0,        -3,

        20,       -43,       201,        33,

       -93,         2,

     -1034,      -518,       -63,      -545,
       104,       -20,

        43,       -64,       -34,        -7,

         0,         0,

       -61,      -159,      -143,        -8,

      -392,      -157,      -204,       309,

       -24,      -248,        55,       -40,

        -6,        91,

       -16,        57,       -41,        18,

       197,       -20,      -668,      -150,

      -192,      -216,        39,       -84,

       -62,       -59,

        -4,         8,

        -7,        -1,

      -352,      -100,       -10,      -158,

        61,        55,     32493,       -49,

       107,       344,      -395,       227,
      -154,      -238,

       123,       104,      -205,       348,
      -449,      -236,

       -54,       -19,

        -6,        21,

      -790,        27,

        -5,        30,

      -846,       154,       -26,      -920,

         0,        12,

       -54,        21,

        11,       -10,

       137,       132,       109,      -337,

       -11,         2,

      -272,       467,      -511,       179,

        -1,        -8,

         7,       -32,

       -44,         2,

       -26,       101,       -32,         6,

       -98,        48,       -42,       -53,

     -1222,      1601,     -3775,       656,

        83,        46,        16,       -28,

         0,         7,

       -66,       -14,

        -6,        13,

        12,         0,

       -58,        91,      -123,       -58,

       -12,         4,

      -114,       423,      -111,        12,

       112,        27,    -19072,        71,

       100,       410,       107,        15,

        24,         3,

      -214,        30,

        49,        44,      5017,       -27,

       167,       -80,         8,       153,

         4,         7,

      -219,       -35,       244,       694,

      -762,         2,

       -84,       -49,       -28,       158,

        -4,        56,

       -14,         0,

         9,        12,

         7,        18,         2,        -7,

    -15426,        91,     25800,       -15,
    144767,       -53,   -287824,       -24,

        19,        -9,         6,         7,

         0,         0,

        -3,         8,

        -5,        -3,

      -232,        53,        -1,      -271,

         4,       -12,

        -8,        30,

        -8,       -25,

      -253,      -150,      -105,       470,

       -37,       -29,

       -59,        -6,

       -24,        -5,

         9,       -18,

      1784,         3,

       -54,        13,

       -12,         7,

      -116,       144,      -353,        52,

        -4,       -12,

       -17,       -14,

     -1340,       -64,

        10,      -116,

       -24,        -2,

       190,       131,       130,      -307,

        -1,         9,

         5,        -7,

       -10,        56,

       -33,         0,

       -14,         3,

         2,       -12,

      -635,      -160,        64,       -44,
      2712,        -3,     -3606,        -1,

       774,         1,

       133,        -1,

       -19,         0,

         5,       -59,

        -5,        14,

       -45,         5,

      -140,        -8,

        15,       -28,

       379,         1,

         6,         3,

        55,         0,       -54,         0,

         3,       -33,

        -3,         4,

         0,        -4,

         0,        -1,       200,         0,

       -17,        -1,

         2,       -20,

        -2,         0,

       111,         0,

         1,       -12,

        64,         0,

        38,         0,

        23,         0,

         3,        13,

};
static char  args[] = {
  0,  3,
  3,  4,  3, -8,  4,  3,  5,  1,
  2,  2,  5, -5,  6,  2,
  4,  4,  3, -8,  4,  5,  5, -5,  6,  1,
  3,  2,  2,  1,  3, -8,  4,  0,
  3,  3,  2, -7,  3,  4,  4,  2,
  3,  7,  3,-13,  4, -1,  5,  0,
  2,  8,  2,-13,  3,  2,
  3,  1,  3, -2,  4,  2,  6,  0,
  3,  1,  2, -8,  3, 12,  4,  1,
  3,  6,  2,-10,  3,  3,  5,  1,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  1,
  2,  1,  5, -3,  6,  0,
  3,  1,  3, -2,  4,  1,  5,  0,
  3,  3,  3, -6,  4,  2,  5,  1,
  3,  1,  1, -5,  2,  4,  3,  0,
  2,  8,  3,-15,  4,  2,
  3,  4,  3, -7,  4, -3,  5,  0,
  3,  2,  2, -7,  3,  7,  4,  0,
  2,  2,  5, -4,  6,  1,
  1,  1,  6,  2,
  2,  2,  5, -6,  6,  0,
  2,  9,  3,-17,  4,  2,
  3,  3,  2, -5,  3,  1,  5,  0,
  3,  2,  3, -4,  4,  2,  5,  0,
  3,  2,  3, -4,  4,  1,  5,  0,
  3,  3,  2, -5,  3,  2,  5,  0,
  2,  1,  5, -1,  6,  0,
  3,  3,  2, -6,  3,  2,  4,  0,
  2,  1,  3, -2,  4,  2,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  1,
  2,  3,  5, -5,  6,  1,
  1,  1,  5,  2,
  3,  4,  3, -8,  4,  2,  5,  0,
  2,  1,  5, -5,  6,  1,
  2,  7,  3,-13,  4,  2,
  2,  2,  5, -2,  6,  0,
  2, 10,  3,-19,  4,  0,
  2,  3,  5, -4,  6,  0,
  2,  3,  2, -5,  3,  2,
  2,  2,  3, -4,  4,  2,
  2,  5,  2, -8,  3,  1,
  2,  3,  5, -3,  6,  0,
  2,  6,  3,-11,  4,  1,
  2,  1,  1, -4,  3,  1,
  2,  4,  5, -5,  6,  0,
  1,  2,  5,  1,
  2,  3,  3, -6,  4,  2,
  2,  5,  3, -9,  4,  2,
  2,  6,  2,-10,  3,  0,
  2,  2,  2, -3,  3,  2,
  2,  4,  3, -8,  4,  1,
  2,  4,  3, -7,  4,  2,
  2,  5,  3,-10,  4,  1,
  2,  3,  3, -5,  4,  2,
  2,  1,  2, -2,  3,  1,
  2,  7,  2,-11,  3,  0,
  2,  2,  3, -3,  4,  1,
  2,  1,  3, -1,  4,  0,
  2,  4,  2, -7,  3,  0,
  2,  4,  2, -6,  3,  2,
  1,  1,  4,  1,
  2,  8,  3,-14,  4,  0,
  2,  1,  3, -5,  5,  0,
  2,  1,  3, -3,  4,  1,
  2,  7,  3,-12,  4,  1,
  2,  1,  2, -1,  3,  1,
  2,  2,  3, -5,  4,  0,
  2,  1,  3, -4,  5,  1,
  2,  6,  3,-10,  4,  1,
  2,  3,  3, -7,  4,  0,
  3,  1,  3, -4,  5,  2,  6,  0,
  3,  1,  3, -1,  5, -5,  6,  0,
  2,  5,  3, -8,  4,  1,
  2,  1,  3, -3,  5,  1,
  3,  1,  3, -5,  5,  5,  6,  0,
  2,  2,  2, -4,  3,  1,
  2,  6,  2, -9,  3,  0,
  2,  4,  3, -6,  4,  1,
  3,  1,  3, -3,  5,  2,  6,  0,
  2,  1,  3, -5,  6,  1,
  2,  1,  3, -2,  5,  2,
  3,  1,  3, -4,  5,  5,  6,  0,
  3,  1,  3, -1,  5, -2,  6,  0,
  3,  1,  3, -3,  5,  3,  6,  0,
  2,  1,  3, -4,  6,  0,
  3,  1,  3, -2,  5,  1,  6,  0,
  2,  5,  2, -9,  3,  0,
  2,  3,  3, -4,  4,  1,
  2,  3,  2, -4,  3,  2,
  2,  1,  3, -3,  6,  1,
  3,  1,  3, -2,  5,  2,  6,  0,
  3,  1,  3,  1,  5, -5,  6,  1,
  2,  1,  3, -1,  5,  1,
  3,  1,  3, -3,  5,  5,  6,  1,
  3,  1,  3,  2,  5, -7,  6,  0,
  2,  1,  3, -2,  6,  1,
  2,  2,  3, -2,  4,  1,
  3,  3,  2, -4,  3,  1,  5,  0,
  2, 10,  3,-17,  4,  1,
  3,  1,  3,  2,  5, -6,  6,  1,
  2,  1,  3, -1,  6,  0,
  3,  1,  3, -2,  5,  4,  6,  0,
  2,  7,  3,-15,  4,  0,
  2,  1,  3, -2,  7,  0,
  3,  1,  3,  1,  5, -3,  6,  0,
  2,  1,  3, -2,  8,  0,
  2,  1,  3, -1,  7,  0,
  2,  1,  3, -1,  8,  0,
  2,  8,  2,-14,  3,  1,
  3,  3,  2, -8,  3,  4,  4,  1,
  3,  1,  3,  4,  5,-10,  6,  1,
  3,  1,  3,  2,  5, -5,  6,  2,
  3,  5,  3, -8,  4,  3,  5,  2,
  1,  1, 12,  3,
  3,  3,  3, -8,  4,  3,  5,  2,
  3,  1,  3, -2,  5,  5,  6,  2,
  3,  3,  2, -6,  3,  4,  4,  0,
  2,  8,  2,-12,  3,  1,
  3,  1,  3,  1,  5, -2,  6,  0,
  2,  9,  3,-15,  4,  2,
  2,  1,  3,  1,  6,  1,
  2,  1, 10, -1, 11,  0,
  1,  2,  4,  1,
  2,  1,  3,  1,  5,  1,
  2,  8,  3,-13,  4,  1,
  2,  3,  2, -6,  3,  0,
  2,  1,  3, -4,  4,  1,
  2,  5,  2, -7,  3,  1,
  2,  7,  3,-11,  4,  1,
  2,  1,  1, -3,  3,  0,
  2,  1,  3,  2,  5,  0,
  2,  2,  3, -6,  4,  0,
  2,  6,  3, -9,  4,  1,
  2,  2,  2, -2,  3,  1,
  2,  5,  3, -7,  4,  2,
  2,  4,  3, -5,  4,  2,
  2,  1,  2, -3,  3,  0,
  2,  7,  2,-10,  3,  0,
  2,  3,  3, -3,  4,  0,
  2,  2,  3, -1,  4,  0,
  2,  4,  2, -5,  3,  1,
  2,  1,  3,  1,  4,  0,
  2,  2,  3, -5,  5,  0,
  2,  8,  3,-12,  4,  0,
  1,  1,  2,  1,
  3,  2,  3, -5,  5,  2,  6,  0,
  2,  2,  3, -4,  5,  1,
  3,  2,  3, -6,  5,  5,  6,  0,
  2,  7,  3,-10,  4,  0,
  3,  2,  3, -4,  5,  2,  6,  0,
  3,  2,  3, -1,  5, -5,  6,  1,
  2,  6,  3, -8,  4,  1,
  2,  2,  3, -3,  5,  1,
  3,  2,  3, -5,  5,  5,  6,  1,
  2,  2,  2, -5,  3,  0,
  2,  6,  2, -8,  3,  0,
  3,  2,  3, -4,  5,  3,  6,  0,
  3,  2,  3, -3,  5,  1,  6,  0,
  2,  5,  3, -6,  4,  1,
  3,  2,  3, -3,  5,  2,  6,  0,
  2,  2,  3, -5,  6,  1,
  2,  2,  3, -2,  5,  1,
  3,  2,  3, -4,  5,  5,  6,  1,
  2,  2,  3, -4,  6,  0,
  2,  4,  3, -4,  4,  0,
  2,  3,  2, -3,  3,  1,
  2,  2,  3, -3,  6,  1,
  3,  2,  3, -2,  5,  2,  6,  0,
  2,  2,  3, -1,  5,  1,
  2,  2,  3, -2,  6,  0,
  2,  3,  3, -2,  4,  1,
  2,  2,  3, -1,  6,  0,
  2,  2,  3, -2,  7,  0,
  3,  2,  3,  2,  5, -5,  6,  0,
  3,  6,  3, -8,  4,  3,  5,  1,
  1,  2, 12,  3,
  3,  2,  3, -8,  4,  3,  5,  1,
  3,  2,  3, -2,  5,  5,  6,  0,
  2,  8,  2,-11,  3,  0,
  2,  2,  3,  1,  5,  0,
  2,  5,  2, -6,  3,  1,
  2,  8,  3,-11,  4,  0,
  2,  1,  1, -2,  3,  0,
  2,  7,  3, -9,  4,  0,
  2,  2,  2, -1,  3,  1,
  2,  6,  3, -7,  4,  0,
  2,  5,  3, -5,  4,  0,
  2,  7,  2, -9,  3,  0,
  2,  4,  3, -3,  4,  0,
  2,  4,  2, -4,  3,  0,
  2,  3,  3, -5,  5,  0,
  2,  1,  2,  1,  3,  0,
  2,  3,  3, -4,  5,  1,
  2,  8,  3,-10,  4,  0,
  2,  7,  3, -8,  4,  0,
  2,  3,  3, -3,  5,  0,
  2,  6,  2, -7,  3,  0,
  2,  6,  3, -6,  4,  0,
  2,  3,  3, -2,  5,  1,
  2,  3,  3, -4,  6,  0,
  2,  5,  3, -4,  4,  0,
  2,  3,  2, -2,  3,  0,
  2,  3,  3, -3,  6,  0,
  2,  3,  3, -1,  5,  0,
  2,  3,  3, -2,  6,  0,
  1,  3, 12,  3,
  2,  5,  2, -5,  3,  0,
  2,  1,  1, -1,  3,  0,
  1,  2,  2,  0,
  2,  7,  2, -8,  3,  0,
  2,  4,  2, -3,  3,  0,
  2,  4,  3, -5,  5,  0,
  2,  4,  3, -4,  5,  0,
  2,  4,  3, -3,  5,  0,
  2,  6,  2, -6,  3,  0,
  2,  4,  3, -2,  5,  0,
  1,  4, 12,  1,
  2,  8,  2, -9,  3,  0,
  2,  5,  2, -4,  3,  0,
  1,  1,  1,  0,
  2,  7,  2, -7,  3,  1,
  2,  5,  3, -5,  5,  0,
  2,  9,  2,-10,  3,  0,
  2,  6,  2, -5,  3,  0,
  2,  8,  2, -8,  3,  0,
  2, 10,  2,-11,  3,  0,
  2,  9,  2, -9,  3,  0,
  2, 10,  2,-10,  3,  0,
  2, 11,  2,-11,  3,  0,
  2,  2,  1, -1,  3,  0,
 -1
};



/* geocentric moon
   polar coordinates re mean equinox and ecliptic of date

   For latitude coefficients, see mlat404.c.


   S. L. Moshier
   December, 1996


              Residuals against JPL ephemeris DE404 (arc seconds)

First date in file = 1221000.5
Number of samples = 1053099
Sampling interval = 1.515625 days

Peak excursions from these mostly different test points
were consolidated with the above.  They added .01" to a few
of the peak readings.
First date in file = 1221000.50
Number of samples = 524290.0
Sampling interval = 3.0 days


 Julian Years             Longitude          Latitude           Distance
                                                               1 = 1.9 km
                       Peak  RMS   Ave    Peak  RMS   Ave    Peak  RMS   Ave
 -1369.0 to -1000.0:   0.43  0.07  0.00   0.33  0.05 -0.00   0.18  0.03  0.00
 -1000.0 to  -500.0:   0.49  0.06 -0.00   0.33  0.04 -0.00   0.18  0.03  0.00
  -500.0 to     0.0:   0.48  0.06  0.00   0.32  0.04  0.00   0.15  0.03  0.00
     0.0 to   500.0:   0.45  0.05  0.00   0.30  0.04 -0.00   0.17  0.03 -0.00
   500.0 to  1000.0:   0.48  0.05 -0.00   0.29  0.04  0.00   0.17  0.03 -0.00
  1000.0 to  1500.0:   0.42  0.05 -0.00   0.28  0.04 -0.00   0.16  0.03  0.00
  1500.0 to  2000.0:   0.35  0.05 -0.00   0.26  0.04  0.00   0.15  0.03  0.00
  2000.0 to  2500.0:   0.39  0.06  0.00   0.25  0.04 -0.00   0.15  0.03 -0.00
  2500.0 to  3000.0:   0.44  0.07 -0.00   0.30  0.05 -0.00   0.19  0.03 -0.00
  3000.0 to  3000.8:   0.23  0.08 -0.04   0.11  0.04 -0.00   0.08  0.03 -0.00
 */





static long  tablm[] = {
    175667,     66453,      5249,       -42,

     20057,       403,     -2360,      6148,

     -7644,     24646,     -1273,      9127,
     -1395,      1958,

       232,      -289,

       -97,       553,        69,       130,

       -80,         6,

       129,      -868,        26,       -89,

      1042,      1172,       194,      -112,

    -47433,   -241666,    224626,   -103752,
     63419,    127606,

      2294,      -691,     -1827,     -1254,

        -1,      -119,

      1057,       324,

       505,      -195,       254,      -641,

       -36,      1008,     -1082,        -3,

       -87,       122,

       161,        11,

         2,      -106,

        29,      -123,

       -32,        41,

      -524,       -35,

       133,      -595,

       225,       837,      -108,      -191,

     -2294,       841,      -340,      -394,

      -351,     -1039,       238,      -108,

       -66,        21,

      1405,       869,       520,      2776,

      -174,        71,

       425,       652,     -1260,       -80,

       249,        77,

      -192,       -17,

       -97,       134,

        -7,       -54,

      -802,     -7436,     -2824,     70869,

       -35,      2481,

      1865,      1749,     -2166,      2415,

        33,      -183,

      -835,       283,

        27,       -45,

        56,       235,

         2,       718,

     -1206,       275,       -87,      -158,

        -7,     -2534,         0,     10774,

         1,      -324,

      -208,       821,

       281,      1340,      -797,       440,

       224,        72,

       -65,        -5,

        -7,       -44,

       -48,        66,

      -151,       -40,

       -41,       -45,

        76,      -108,

       -18,      1202,         0,     -2501,

      1438,      -595,       900,      3040,
     -3435,        -5,

      -100,       -26,

         0,    -13714,

      -183,        68,

       453,       -83,

      -228,       325,

        97,        13,

         2,       105,

       -61,       257,

         0,        57,

        88,       -11,

        -1,     -8220,

         0,       275,

       -43,       -10,

      -199,       105,

         1,     -5849,         2,     24887,

      -128,        48,

       712,       970,     -1407,       845,

      -266,       378,

       311,      1526,     -1751,        27,

         0,   -185858,

       133,      6383,

      -108,        25,

        -7,      1944,

         5,       390,

       -11,        31,

       277,      -384,       158,        72,

       -81,       -41,       -13,      -111,

     -2332,    -65804,      -698,    505812,
        34,   1676716,       -72,  -6664384,

       154,       -57,        52,        95,

        -4,        -5,

        -7,        37,

       -63,       -32,

         4,      3349,         1,    -14370,

        16,       -83,

         0,      -401,

        13,      3013,

        48,       -20,

         0,       250,

        51,       -79,

        -7,      -146,

       148,         9,

         0,       -64,

       -17,       -59,

       -67,      -492,

        -2,   2116601,

       -12,     -1848,

         8,      -436,

        -6,       324,         0,     -1363,

      -163,         9,

         0,       -74,

        63,      8167,       -29,     37587,
       -22,    -74501,

       -71,       497,

        -1,    551747,

       -87,       -22,

         0,       -51,

        -1,      -463,

         0,      -444,

         3,        89,

        15,       -84,

       -36,     -6829,        -5,    -21663,
         0,     86058,

         0,      -298,

        -2,       751,        -2,     -1015,

         0,        69,

         1,     -4989,         0,     21458,

         0,      -330,

         0,        -7,

         0,      -226,

         0,     -1407,         0,      2942,

         0,        66,

         0,       667,

         0,      -155,

         0,       105,

         0,      -107,

         0,       -74,

         0,       -52,

         0,        91,

         0,        59,

         0,       235,

        -1,     -1819,         0,      2470,

        71,        13,

         0,      1026,

        14,       -54,

         0,      -174,

      -121,       -19,

         0,      -200,

         0,      3008,

       -16,     -8043,       -10,    -37136,
        -3,     73724,

      -157,        -5,

         0,      -854,

         8,       147,

       -13,      -893,

         0,     11869,

       -23,      -172,

        89,        14,

        -1,       872,         0,     -3744,

        11,      1606,

         0,      -559,

        -1,     -2530,

         0,       454,

         0,      -193,

       -60,       -10,

       -82,       -13,

       -75,         6,

        36,        81,

       354,   -162836,       148,   -516569,
         4,   2054441,

         4,       -94,

        39,        38,

        61,       -30,

         2,       121,

       -11,       590,

        62,      2108,

         0,    -12242,

      -476,       -42,

       -84,       113,

      -394,       236,

         0,       276,

       -49,        31,

         0,        86,

         1,     -1313,

         1,        69,

       -60,        88,

       -46,        18,

         0,    -63818,

        14,       -93,

       113,       547,      -618,        17,

        -7,     12290,        -1,    -25679,

         0,        92,

      -115,        50,

       -48,       233,

         4,      1311,         1,     -5567,

         3,      1251,

        29,       548,

      -244,       257,

        -2,      1825,

        42,       637,

       -46,        68,

       -62,         8,

         3,       110,

       445,      -100,      -316,      -202,

      2925,      -621,       763,      1495,

      -169,      -184,        20,       -76,

      -475,      -138,         8,      -141,

      -197,      1351,     -1284,       422,

      -129,      1879,      -102,      8382,
        -9,  45864958,

      -215,      1350,     -1285,       422,

      -481,      -136,         8,      -140,

        40,       -53,

      2622,      -543,       700,      1406,

       402,       -95,      -318,      -194,

       122,        13,

       -30,       147,

      -121,      -902,

        61,       -23,

       -63,         7,

        69,       479,

      -224,       228,

        -7,       500,

         0,      -429,

       -42,       193,

       -92,        37,

        67,         5,

      -350,       -31,

         0,        67,

       -55,        -5,

         0,        47,

       -36,        53,

         5,       561,

         0,      -126,

         0,       871,

       -52,         4,

      -201,    116922,       -22,    371352,
       -12,  -1473285,

         0,        87,

      -164,        84,

        -3,       422,

        30,      1434,

       -26,        38,

         2,  -1249943,

      -404,       -34,

       -57,        79,

         5,       509,

         1,       131,

      -344,       168,

       112,     22540,        30,     71218,
        18,   -283983,

         0,      -851,

         0,     -1538,

         0,      1360,

       -12,        51,

       -48,        68,

        88,       -20,

         1,        63,

         0,      -568,

       303,        25,

         0,      -122,

        87,       586,      -606,       -14,

         0,      -100,

       -85,         8,

      -165,        54,

       -45,       140,

         0,       -54,

         4,      -831,         1,      3495,

        31,       116,

       -46,       -11,

      -371,       190,

      -507,       399,

        -2,        57,

       -60,        36,

      -198,     -1174,      -613,      4988,

       -87,        -4,

       141,       560,      -276,       187,

      1876,      1379,       778,      4386,

        24,       -15,

       167,      -774,

       -71,        -9,

       -62,        90,

        98,       580,      -663,        -7,

        34,      -112,

        57,        15,

      -355,      -214,

     -3240,    -13605,     12229,     -5723,
      3496,      7063,

        33,       -51,

      1908,      1160,      -226,       715,

       964,      1170,     -1264,       623,

     14071,      5280,      5614,      3026,
       488,      1576,        -2, 226395859,

       824,      1106,     -1287,       617,

      1917,      1156,      -214,       718,

        90,       -97,

     12078,     -2366,      3282,      6668,

      -219,      9179,       593,      2015,
      -282,      -186,

        57,        25,

        31,      -102,

       -77,        -4,

      -268,      -341,        -7,       -45,

        -3,        74,

        15,      -615,

       -88,        -7,

       234,      -353,

         1,      -119,

      -163,     -1159,      -601,      4969,

        22,       -58,

       -17,    -11434,

        17,        54,

       348,       348,      -460,       434,

      -371,       175,

       -11,      -204,

         4,     -6440,

        -5,       -53,

        -4,    -14388,       -37,    -45231,
        -7,    179562,

       -44,       136,

      -160,        49,

      -101,        81,

        -1,      -188,

         0,         2,

        -4,     12124,       -11,    -25217,

        71,       543,      -557,       -14,

       -75,       526,

         0,    395274,

      -233,       -16,

        93,       -20,

       -43,        61,

         0,     -1275,

         0,      -824,

         1,      -415,         0,      1762,

      -261,       131,

       -45,        64,

      -297,       -25,

         0,    -17533,

        -6,       -56,

        21,      1100,

         1,       327,

         1,        66,

        23,      -217,

       -83,        -7,

        83,     86847,        49,    275754,
        -4,  -1093857,

       -46,         2,

         0,       -24,

         0,      -419,

         0,     -5833,

         1,       506,

         0,      -827,

        -1,      -377,

       -11,       -78,

         0,    131945,

        -2,      -334,

         1,       -75,

         0,       -72,

         0,      -213,

        -6,      5564,        -2,    -11618,

         0,      1790,

         0,      -131,

         0,         6,

         0,       -76,

         0,      -130,

         0,     -1115,         0,      4783,

         0,      -195,

         0,      -627,

         0,       -55,

         0,       -83,

         0,       163,

         0,       -54,

         0,        82,

         0,       149,

         0,      -754,         0,      1578,

         0,       138,

         0,        68,

         2,     -2506,         0,      3399,

         0,      -125,

        86,        16,

         0,     -6350,         0,     27316,

        18,       -63,

         0,      -169,

        -1,        46,

      -136,       -21,

         0,      -239,

       -30,     -8788,       -15,    -40549,
        -4,     80514,

       -46,        -8,

      -168,        -6,

        -1,       536,         0,     -2314,

         9,       148,

       -13,      -842,

        -1,    307713,

       -23,      -175,

        95,        15,

         0,      -297,

        11,      1341,

         0,      -106,

         0,         5,

        -4,        68,

      -114,        10,

        32,        75,

       159,   -130487,        98,   -413967,
         2,   1647339,

        -4,       -85,

       100,       -46,

         2,        95,

       -11,       461,

        51,      1647,

         0,    -32090,

      -375,       -33,

       -65,        86,

      -300,       180,

         0,       836,         0,     -3576,

         0,      -222,

         0,      -993,

       -41,        60,

         0,     -4537,

      -431,       -34,

         2,       927,         0,     -1931,

       -79,        33,

       -31,       144,

        -1,       284,         0,     -1207,

         0,        88,

       -11,       315,

      -178,       177,

        -1,       144,

       -58,       986,

        11,        86,

      -228,      -110,

      2636,      -494,       718,      1474,

        28,       -35,

       -24,       782,      -797,       277,

      2142,     -1231,       856,      1853,
        74,     10797,         0,  23699298,

       -21,       786,      -796,       277,

        27,       -34,

      2615,      -494,       712,      1461,

      -226,      -109,

       -11,       663,

         0,      -123,

      -169,       157,

       -54,       266,

         0,       -76,

         1,      -634,         0,      2738,

       -25,       106,

       -63,        24,

         0,      -372,

      -221,       -24,

         0,     -5356,

         0,      -219,

         0,        91,

       -28,      7684,        -6,     24391,
        -1,    -96795,

       -77,        43,

         2,        95,

       -47,        -3,

         0,    -84530,

         2,       310,

         1,        88,

       111,     19331,        32,     61306,
         4,   -243595,

         0,       770,

         0,      -103,

         0,       160,

         0,       356,

         0,       236,

       -41,       354,

        39,       303,

        12,       -56,

       873,      -143,       238,       482,

       -28,        35,

       -93,        31,

        -3,   7690211,

       -91,        33,

       -34,        43,

       824,      -130,       226,       450,

       -39,       341,

        -1,      -687,

         0,      -303,

        11,     -2935,         1,     12618,

       121,       924,         9,     -1836,

      -268,     -1144,      -678,      3685,

       -69,      -261,

         0,  -4115951,

       -69,      -261,

         5,      -151,

         0,       -88,

         0,        91,

         0,       187,

         0,     -1281,

         1,        77,

         1,      6059,         3,     19238,
         0,    -76305,

         0,       -90,

         0,      -238,

         0,      -962,         0,      4133,

         0,        96,

         0,      9483,

         0,        85,

         0,      -688,

         0,     -5607,

         0,        55,

         0,      -752,

         0,        71,

         0,       303,

         0,      -288,

         0,        57,

         0,        45,

         0,       189,

         0,       401,

         0,     -1474,         0,      3087,

         0,       -71,

         0,      2925,

         0,       -75,

         0,       359,

         0,        55,

         1,    -10155,         0,     43735,

         0,      -572,

         0,       -49,

         0,      -660,

         0,     -3591,         0,      7516,

         0,       668,

        -1,       -53,

        -2,    384259,

         0,      -163,

         0,       -93,

         1,       112,

       -95,    -11528,       -22,    -36505,
        -1,    145308,

         5,       145,

         0,      4047,

         1,      1483,         0,     -6352,

         0,       991,         0,     -4262,

         0,       -93,

         0,      -334,

         0,      -160,

         0,      -153,

       -10,       127,

        51,       185,

       -77,        18,

        56,      1217,         6,   1919574,

       -74,        17,

        50,       180,

        -5,        93,

         0,      -104,

         0,       -58,

        -3,      -353,        -1,      1499,

         0,      -229,

       -15,        86,

         0,    -93657,

         0,      1561,         0,     -6693,

         0,     -5839,

         1,      6791,         0,    -29143,

         1,      -701,         0,      3015,

         0,      2543,

         0,       693,

        -1,    361233,

         0,       -50,

         0,       946,

        -1,      -140,

       -70,       407,

         0,   -450995,

         0,      -368,

         0,        54,

         0,      -802,

         0,       -96,

         0,      1274,         0,     -5459,

         0,      -614,         0,      2633,

         0,       685,

         0,      -915,

         0,       -85,

         0,        88,

         0,       106,

         0,       928,

         0,      -726,         0,      1523,

         0,      5715,

         0,     -4338,         0,     18706,

         0,      -135,

         0,      -132,

         0,      -158,

         0,       -98,

         0,       680,

        -1,    138968,

         0,      -192,

         0,     -1698,

         0,     -2734,         0,     11769,

         0,         4,

         0,       673,         0,     -2891,

         0,       889,         0,     -3821,

         0,       121,

        -1,    143783,

         0,       231,

        -9,        51,

         0,    -57413,

         0,      -483,

         0,      -407,

         0,       676,         0,     -2902,

         0,       531,

         0,       445,

         0,       672,

         0,     19336,

         0,        70,

         0,    -39976,

         0,       -68,

         0,      4203,

         0,      -406,

         0,       446,

         0,      -108,

         0,        79,

         0,        84,

         0,       734,

         0,       255,

         0,      3944,

         0,      -655,         0,      2825,

         0,      -109,

         0,      -234,

         0,        57,

         0,     19773,

         0,     -2013,

         0,       958,

         0,      -521,

         0,      -757,

         0,     10594,

         0,     -9901,

         0,       199,

         0,      -275,

         0,        64,

         0,        54,

         0,       165,

         0,      1110,

         0,     -3286,

         0,       909,

         0,        54,

         0,        87,

         0,       258,

         0,      1261,

         0,       -51,

         0,       336,

         0,      -114,

         0,      2185,

         0,      -850,

         0,        75,

         0,       -69,

         0,      -103,

         0,       776,

         0,     -1238,

         0,       137,

         0,        67,

         0,      -260,

         0,       130,

         0,        49,

         0,       228,

         0,       215,

         0,      -178,

         0,        57,

         0,      -133,

};
static long  tabbm[] = {-1};
static long  tabrm[] = {
     -5422,     -2120,      1077,       772,

        39,        75,         3,        10,

      -468,      -326,      -113,       -78,
        -4,        -2,

         1,         3,

        29,        24,         4,         2,

         1,         0,

        -9,         7,        -2,         0,

       -32,       -13,        -3,        -3,

       233,       126,        89,        77,
       -33,        16,

         3,        -3,         0,        -1,

         2,         0,

         0,         1,

         4,         9,         1,         1,

        16,        -1,         0,        18,

         3,         2,

         0,         0,

         0,         0,

         0,         0,

         0,         0,

         0,        -1,

       -22,        -5,

        10,         3,         1,         1,

       -15,         7,        -2,         1,

        -8,       -11,        -1,        -2,

        -1,         1,

        46,       -58,       126,       -23,

         4,         8,

        35,         8,        10,       -17,

         0,         0,

         0,         0,

       -10,        -7,

         0,         0,

       -23,         3,       151,        10,

      -327,         0,

         4,        -5,         6,         5,

         1,         0,

        -1,        -3,

         0,         0,

         0,         1,

      -185,         0,

        -3,       -24,        -5,        -2,

     -1062,         3,      4560,         0,

        -3,         0,

         4,         1,

         8,        -1,         2,         4,

         0,         1,

         0,        -1,

         0,         0,

        -1,         0,

         0,         1,

         0,         0,

        -1,        -1,

       277,         3,      -583,         1,

        -1,         4,       -32,         7,
         0,       -34,

         1,        -1,

    -23685,         0,

        -1,        -2,

        -1,        -7,

        -5,        -4,

         0,         2,

        -2,         0,

        -5,        -1,

        35,         0,

         0,         2,

       202,         0,

       180,         0,

         0,        -1,

        -3,        -6,

      -193,         0,       770,        -1,

        -2,        -4,

       -32,        23,       -28,       -46,

       -13,        -9,

       -54,        10,        -1,       -61,

    -44895,         0,

      -230,         5,

        -1,        -4,

       -71,         0,

       -15,         0,

         1,         0,

        15,        11,        -3,         6,

         2,        -3,         4,        -1,

      2576,      -138,    -19881,       -47,
    -65906,        -1,    261925,        -4,

        -2,        -7,         4,        -2,

         0,         0,

        -1,         0,

         1,        -3,

       172,        -2,      -727,         0,

         4,         1,

       324,         0,

      -139,         1,

         1,         3,

      -276,         0,

         5,         3,

         9,         0,

        -1,        10,

       -37,         0,

         5,        -1,

        76,       -10,

   1318810,         1,

        12,        -1,

       -38,         1,

      -141,         0,       611,         0,

         0,       -11,

         4,         0,

      -627,         2,     -2882,        -3,
      5711,        -2,

       -48,        -7,

     55294,         0,

         2,        -7,

        31,         0,

        34,         0,

      -259,         0,

       -55,         2,

         6,         3,

     -4273,        20,    -13554,         3,
     53878,         0,

       -46,         0,

       -85,         0,       114,         0,

       -45,         0,

      -818,         0,      3520,         0,

        34,         0,

      -157,         0,

        29,         0,

      -878,         0,      1838,         0,

      -428,         0,

       161,         0,

        24,         0,

        65,         0,

        19,         0,

        15,         0,

        12,         0,

       -26,         0,

       -14,         0,

      -149,         0,

       584,         0,      -793,         0,

         4,       -23,

      -238,         0,

       -18,        -5,

        45,         0,

        -7,        42,

        79,         0,

     -1723,         0,

      2895,        -6,     13362,        -4,
    -26525,        -1,

        -2,        57,

       291,         0,

        52,        -3,

      -327,         5,

     -2755,         0,

       -63,         9,

         5,       -33,

      -261,        -1,      1122,         0,

       621,        -4,

      -227,         0,

      1077,         0,

      -167,         0,

        85,         0,

        -4,        23,

        -5,        32,

         3,        30,

       -32,        14,

     64607,       141,    204958,        59,
   -815115,         2,

       -37,        -1,

        15,       -15,

        12,        24,

        48,        -1,

       235,         4,

       843,       -25,

      4621,         0,

       -17,       191,

        45,        34,

        95,       159,

      -132,         0,

        13,        20,

        32,         0,

      -540,         0,

        29,         0,

        37,        25,

         8,        19,

     22127,         0,

       -35,        -5,

       232,       -48,         7,       262,

      5428,         3,    -11342,         1,

       -45,         0,

       -21,       -49,

      -100,       -21,

      -626,         1,      2665,         0,

       532,        -2,

       235,       -12,

      -111,      -105,

       774,         1,

      -283,        17,

        29,        20,

         3,        27,

        47,        -2,

       -43,      -192,       -87,       136,

      -269,     -1264,       646,      -330,

       -79,        73,       -33,        -9,

        60,      -205,        61,         4,

      -584,       -85,      -182,      -555,

      -780,       -57,     -3488,       -45,
 -19818328,        -4,

       583,        93,       182,       555,

       -59,       208,       -60,        -4,

        23,        17,

       235,      1133,      -608,       302,

        41,       174,        84,      -137,

         6,       -53,

        63,        13,

      -392,        52,

       -10,       -27,

        -3,       -27,

       199,       -31,

        99,        97,

      -218,        -3,

       209,         0,

        84,        18,

        16,        40,

         2,       -30,

        14,      -154,

        30,         0,

        -2,        24,

      -108,         0,

       -24,       -16,

       262,        -2,

        55,         0,

      -304,         0,

         2,        25,

     55112,        95,    175036,        11,
   -694477,         5,

        41,         0,

       -38,       -76,

       199,         1,

       679,       -14,

       -17,       -12,

    582619,         1,

       -16,       191,

        38,        27,

      -234,         2,

       -60,         0,

        80,       163,

    -10296,        48,    -32526,        13,
    129703,         8,

     -1366,         0,

      -741,         0,

      -646,         0,

        25,         6,

        33,        23,

        10,        43,

       -31,         0,

        -6,         0,

       -12,       147,

        59,         0,

       287,       -42,        -7,       297,

       -59,         0,

        -4,       -42,

       -27,       -81,

       -69,       -22,

        27,         0,

      -423,        -2,      1779,        -1,

       -57,        15,

         5,       -23,

        94,       182,

      -197,      -250,

        24,         1,

       -18,       -30,

       581,       -98,     -2473,      -303,

        -2,        43,

      -277,        70,       -92,      -136,

      -681,       925,     -2165,       384,

        -8,       -12,

       382,        82,

        -4,        35,

       -45,       -31,

      -286,        48,         3,      -328,

       -55,       -17,

         8,       -28,

      -106,       175,

     -6735,      1601,     -2832,     -6052,
      3495,     -1730,

       -25,       -17,

      -574,       944,      -354,      -112,

      -579,       476,      -308,      -625,

     -2411,      7074,     -1529,      2828,
     -1335,       247,-112000844,        -1,

       545,      -409,       305,       637,

       572,      -950,       356,       106,

        48,        44,

      1170,      5974,     -3298,      1624,

     -4538,      -106,      -996,       294,
        92,      -139,

       -12,        28,

        50,        16,

         2,       -38,

       169,      -133,        22,        -3,

        38,         1,

       305,         7,

         4,       -44,

       175,       116,

        59,         1,

      -573,        81,      2453,       297,

        29,        11,

      5674,        -8,

       -27,         9,

       173,      -173,       215,       228,

       -87,      -184,

       102,        -5,

      3206,         2,

       -53,         2,

      7159,        -7,     22505,       -19,
    -89344,        -3,

        67,        22,

        24,        79,

       -40,       -50,

        94,         0,

       186,         0,

     -6063,         0,     12612,        -5,

      -271,        35,         7,      -278,

      -479,       -74,

    426754,         0,

         8,      -116,

       -10,       -47,

       -31,       -22,

       645,         0,

       426,         0,

      -213,         0,       903,         0,

       -67,      -133,

       -33,       -23,

        13,      -152,

     -9316,         0,

        29,        -3,

      -564,        11,

      -167,         0,

       -34,         0,

       114,        12,

         4,       -44,

    -44561,        42,   -141493,        25,
    561256,        -2,

        -1,       -24,

      -261,         0,

       211,         0,

     -4263,         0,

      -262,         1,

      1842,         0,

       202,         0,

        41,        -6,

     77165,         0,

       176,        -1,

        39,         1,

       -24,         0,

       118,         0,

     -2991,        -4,      6245,        -1,

     46886,         0,

       -75,         0,

      -100,         0,

        40,         0,

        75,         0,

      -618,         0,      2652,         0,

       112,         0,

      1780,         0,

        30,         0,

        49,         0,

        86,         0,

        33,         0,

       -30,         0,

       -95,         0,

       277,         0,      -580,         0,

       -35,         0,

      -319,         0,

      1622,         1,     -2201,         0,

        79,         0,

        10,       -57,

      2363,         0,    -10162,         0,

       -41,       -12,

        62,         0,

        30,         1,

       -14,        89,

     -2721,         0,

      5780,       -19,     26674,       -10,
    -52964,        -2,

        -5,        30,

        -4,       111,

      -317,        -1,      1369,         0,

        93,        -6,

      -564,         9,

   -115913,         0,

      -113,        15,

        10,       -62,

        99,         0,

       891,        -7,

        36,         0,

       108,         0,

       -42,        -2,

         7,        75,

       -50,        21,

     86822,       104,    275441,        65,
  -1096109,         1,

       -56,         3,

        31,        66,

        63,        -1,

       307,         7,

      1097,       -34,

     17453,         0,

       -22,       250,

        57,        43,

       120,       200,

      -297,         0,      1269,         0,

       166,         0,

      -662,         0,

        40,        28,

      1521,         0,

       -23,       288,

       351,        -2,      -729,         0,

       -22,       -52,

       -96,       -21,

      -139,        -1,       589,         0,

        35,         0,

       210,         7,

      -118,      -119,

        62,         0,

      -583,       -26,

       -42,         5,

       -73,       152,

      -330,     -1759,       983,      -479,

       -23,       -19,

      -522,       -15,      -185,      -533,

       739,      1559,     -1300,       614,
     -7332,        52, -15836758,         0,

       524,        16,       185,       532,

        23,        18,

       330,      1751,      -978,       476,

        73,      -151,

       519,        18,

        38,         0,

       105,       113,

      -178,       -37,

        26,         0,

       262,         1,     -1139,         0,

        71,        17,

        16,        42,

       151,         0,

        16,      -148,

      4147,         0,

       149,         0,

       -30,         0,

      2980,         9,      9454,         2,
    -37519,         0,

       -28,       -49,

        37,        -1,

         2,       -31,

     33870,         0,

      -208,         1,

       -59,         1,

    -13105,        68,    -41564,        21,
    165148,         3,

     -1022,         0,

       -40,         0,

      -132,         0,

      -228,         0,

        95,         0,

      -138,       -16,

      -126,        16,

        24,         5,

       -57,      -346,       191,       -94,

       -14,       -11,

       -12,       -37,

  -3053364,        -1,

        13,        36,

        17,        13,

        51,       327,      -179,        90,

       138,        16,

       233,         0,

        62,         0,

      1164,         0,     -5000,         0,

      -407,       117,       770,         9,

        -4,         1,        21,         2,

         1,         0,

    -16869,         0,

        -1,         0,

         1,         0,

        35,         0,

       -78,         0,

        78,         0,

      -533,         0,

       -31,         1,

     -2448,        -6,     -7768,        -1,
     30812,         0,

        37,         0,

      -227,         0,

       197,         0,      -846,         0,

       -77,         0,

      4171,         0,

       -67,         0,

       287,         0,

      2532,         0,

       -19,         0,

       -40,         0,

       -56,         0,

       128,         0,

        83,         0,

       -45,         0,

       -36,         0,

       -92,         0,

      -134,         0,

       714,         0,     -1495,         0,

        32,         0,

      -981,         0,

        15,         0,

      -166,         0,

       -59,         0,

      4923,         0,    -21203,         0,

       246,         0,

        15,         0,

       104,         0,

      1683,         0,     -3523,         0,

      -865,         0,

       -25,         1,

   -186329,        -1,

        10,         0,

        50,         0,

        53,         0,

      5455,       -45,     17271,       -10,
    -68747,         0,

        69,        -2,

     -7604,         0,

      -724,         1,      3101,         0,

       -46,         0,       200,         0,

       -44,         0,

        97,         0,

       -53,         0,

        62,         0,

       -54,        -4,

        88,       -24,

        -9,       -36,

      -581,        27,   -914711,         3,

         8,        35,

       -86,        24,

        51,         3,

        48,         0,

        26,         0,

       133,         1,      -577,         0,

       105,         0,

        -3,        -1,

      3194,         0,

       528,         0,     -2263,         0,

      2028,         0,

     -3266,         1,     14016,         0,

        10,         0,       -41,         0,

      -100,         0,

       -32,         0,

   -124348,         0,

        16,         0,

      -325,         0,

        50,        -1,

         1,         0,

      -553,         0,

         0,         0,

         0,         0,

         2,         0,

       -34,         0,

      -444,         0,      1902,         0,

         9,         0,       -37,         0,

       254,         0,

       156,         0,

        -2,         0,

       -35,         0,

       -48,         0,

      -368,         0,

       327,         0,      -686,         0,

     -2263,         0,

      1952,         0,     -8418,         0,

       -13,         0,

        52,         0,

         9,         0,

        21,         0,

      -261,         0,

    -62404,         0,

         0,         0,

        79,         0,

      1056,         0,     -4547,         0,

      -351,         0,

      -305,         0,      1310,         0,

        -1,         0,         6,         0,

         0,         0,

    -55953,         0,

       -80,         0,

         0,         0,

       168,         0,

      -147,         0,

       127,         0,

      -265,         0,      1138,         0,

        -1,         0,

        -9,         0,

        -8,         0,

     -5984,         0,

       -22,         0,

        -5,         0,

         0,         0,

         0,         0,

       127,         0,

        -2,         0,

        10,         0,

       -31,         0,

       -29,         0,

      -286,         0,

       -98,         0,

     -1535,         0,

       252,         0,     -1087,         0,

        43,         0,

         4,         0,

       -19,         0,

     -7620,         0,

        29,         0,

      -322,         0,

       203,         0,

         0,         0,

     -3587,         0,

        10,         0,

         0,         0,

        94,         0,

         0,         0,

        -1,         0,

        -1,         0,

      -315,         0,

         1,         0,

         0,         0,

         0,         0,

       -30,         0,

       -94,         0,

      -460,         0,

         1,         0,

      -114,         0,

         0,         0,

      -746,         0,

         4,         0,

       -23,         0,

        24,         0,

         0,         0,

      -237,         0,

         1,         0,

         0,         0,

       -18,         0,

         0,         0,

         0,         0,

       -16,         0,

       -76,         0,

       -67,         0,

         0,         0,

       -16,         0,

         0,         0,

};

static char  argsm[] = {
  0,  3,
  3,  4,  3, -8,  4,  3,  5,  1,
  2,  2,  5, -5,  6,  2,
  5, -1, 10,  2, 13, -1, 11,  3,  3, -7,  4,  0,
  3,  1, 13, -1, 11,  2,  5,  1,
  2,  4,  5,-10,  6,  0,
  4,  2, 10, -2, 13, 14,  3,-23,  4,  1,
  3,  3,  2, -7,  3,  4,  4,  1,
  3, -1, 13, 18,  2,-16,  3,  2,
  2,  8,  2,-13,  3,  1,
  5,  2, 10, -2, 13,  2,  3, -3,  5,  1,  6,  0,
  3, -1, 13, 26,  2,-29,  3,  0,
  3,  1, 10, -1, 11,  2,  4,  1,
  4,  1, 10, -1, 13,  3,  2, -4,  3,  1,
  4,  1, 10, -1, 13,  3,  3, -4,  4,  0,
  3, -1, 10, 15,  2,-12,  3,  0,
  4,  2, 10, -3, 13, 24,  2,-24,  3,  0,
  3, -1, 10, 23,  2,-25,  3,  0,
  4,  1, 10, -1, 11,  1,  3,  1,  6,  0,
  4,  2, 10, -2, 11,  5,  2, -6,  3,  0,
  4,  2, 10, -2, 13,  6,  2, -8,  3,  0,
  4, -2, 10,  1, 13, 12,  2, -8,  3,  1,
  5, -1, 10,  1, 13, -1, 11, 20,  2,-20,  3,  1,
  4, -2, 10,  1, 13,  3,  1, -1,  3,  1,
  5,  2, 10, -2, 13,  2,  3, -5,  5,  5,  6,  0,
  4,  2, 10, -2, 13,  2,  3, -3,  5,  1,
  4,  2, 10, -2, 13,  6,  3, -8,  4,  0,
  4, -2, 10,  1, 13, 20,  2,-21,  3,  1,
  4,  1, 10, -1, 11,  1,  3,  1,  5,  0,
  1,  1,  6,  0,
  4,  2, 10, -2, 13,  5,  3, -6,  4,  0,
  3,  3,  2, -5,  3,  2,  5,  0,
  2, -1, 11,  1, 14,  1,
  4,  2, 10, -2, 13,  2,  3, -2,  5,  0,
  2,  1,  3, -2,  4,  1,
  4,  1, 10, -1, 11,  5,  2, -7,  3,  0,
  1,  1,  5,  0,
  2,  7,  3,-13,  4,  0,
  4, -2, 10,  1, 13, 15,  2,-13,  3,  0,
  4,  2, 10, -2, 13,  3,  2, -3,  3,  0,
  2, -2, 11,  2, 14,  1,
  3,  1, 10,  1, 12, -1, 13,  1,
  3, -1, 13, 21,  2,-21,  3,  0,
  2,  3,  2, -5,  3,  0,
  2,  2,  3, -4,  4,  1,
  2,  5,  2, -8,  3,  0,
  3, -1, 13, 23,  2,-24,  3,  0,
  2,  6,  3,-11,  4,  0,
  1,  2,  5,  0,
  2,  3,  3, -6,  4,  0,
  2,  5,  3, -9,  4,  0,
  4,  1, 10, -1, 11,  1,  3, -2,  5,  0,
  3,  2, 10,  2, 12, -2, 13,  1,
  2,  2,  2, -3,  3,  2,
  2,  4,  3, -7,  4,  0,
  2,  2, 13, -2, 11,  0,
  2,  3,  3, -5,  4,  0,
  2,  1,  2, -2,  3,  0,
  2,  2,  3, -3,  4,  0,
  4,  1, 10, -1, 11,  4,  2, -5,  3,  0,
  2,  1,  3, -1,  4,  0,
  2,  4,  2, -6,  3,  0,
  4,  2, 10, -2, 13,  2,  2, -2,  3,  0,
  3,  1, 10, -1, 11,  1,  2,  0,
  2,  1,  2, -1,  3,  0,
  3,  1, 12,  2, 13, -2, 11,  0,
  2,  5,  3, -8,  4,  0,
  2,  1,  3, -3,  5,  0,
  3,  2, 10,  1, 12, -2, 13,  1,
  2,  4,  3, -6,  4,  0,
  2,  1,  3, -2,  5,  1,
  2,  3,  3, -4,  4,  0,
  2,  3,  2, -4,  3,  1,
  2,  1, 10, -1, 13,  0,
  2,  1,  3, -1,  5,  0,
  2,  1,  3, -2,  6,  0,
  2,  2,  3, -2,  4,  0,
  2,  1,  3, -1,  6,  0,
  2,  8,  2,-14,  3,  0,
  3,  1,  3,  2,  5, -5,  6,  1,
  3,  5,  3, -8,  4,  3,  5,  1,
  1,  1, 12,  3,
  3,  3,  3, -8,  4,  3,  5,  1,
  3,  1,  3, -2,  5,  5,  6,  0,
  2,  8,  2,-12,  3,  0,
  2,  1,  3,  1,  5,  0,
  3,  2, 10,  1, 12, -2, 11,  1,
  2,  5,  2, -7,  3,  0,
  3,  1, 10,  1, 13, -2, 11,  0,
  2,  2,  2, -2,  3,  0,
  2,  5,  3, -7,  4,  0,
  3,  1, 12, -2, 13,  2, 11,  0,
  2,  4,  3, -5,  4,  0,
  2,  3,  3, -3,  4,  0,
  1,  1,  2,  0,
  3,  3, 10,  1, 12, -3, 13,  0,
  2,  2,  3, -4,  5,  0,
  2,  2,  3, -3,  5,  0,
  2,  2, 10, -2, 13,  0,
  2,  2,  3, -2,  5,  0,
  2,  3,  2, -3,  3,  0,
  3,  1, 10, -1, 12, -1, 13,  1,
  2,  2,  3, -1,  5,  0,
  2,  2,  3, -2,  6,  0,
  1,  2, 12,  2,
  3, -2, 10,  1, 11,  1, 14,  0,
  2,  2, 10, -2, 11,  0,
  2,  2,  2, -1,  3,  0,
  4, -2, 10,  2, 13,  1,  2, -1,  3,  0,
  2,  4,  2, -4,  3,  0,
  2,  3, 10, -3, 13,  0,
  4, -2, 10,  2, 13,  1,  3, -1,  5,  0,
  2,  3,  3, -3,  5,  0,
  3,  2, 10, -1, 12, -2, 13,  2,
  3,  3, 10, -1, 13, -2, 11,  0,
  1,  3, 12,  1,
  4, -2, 10,  2, 13,  2,  2, -2,  3,  0,
  3,  2, 10, -1, 12, -2, 11,  1,
  2,  5,  2, -5,  3,  0,
  2,  4, 10, -4, 13,  0,
  2,  6,  2, -6,  3,  0,
  3,  2, 10, -2, 12, -2, 13,  1,
  3,  4, 10, -2, 13, -2, 11,  0,
  3,  2, 10, -2, 12, -2, 11,  0,
  2,  7,  2, -7,  3,  0,
  3,  2, 10, -3, 12, -2, 13,  0,
  2,  8,  2, -8,  3,  0,
  2,  9,  2, -9,  3,  0,
  2, 10,  2,-10,  3,  0,
  3,  2, 10, -4, 12, -1, 13,  0,
  3,  4, 10, -2, 12, -3, 13,  0,
  4,  4, 10, -1, 12, -1, 13, -2, 11,  0,
  3,  2, 10, -3, 12, -1, 13,  1,
  4, -2, 10,  1, 13,  3,  3, -2,  5,  0,
  3,  4, 10, -1, 12, -3, 13,  0,
  4, -2, 10,  1, 13,  3,  3, -3,  5,  0,
  4,  2, 10, -2, 12,  1, 13, -2, 11,  0,
  4, -2, 10,  1, 13,  2,  2, -1,  3,  0,
  3,  3, 10, -1, 12, -2, 11,  0,
  3,  4, 10, -1, 13, -2, 11,  0,
  3,  2, 10, -2, 12, -1, 13,  2,
  4, -2, 10,  1, 13,  2,  3, -1,  5,  0,
  3,  3, 10, -1, 12, -2, 13,  0,
  4, -2, 10,  1, 13,  3,  2, -3,  3,  0,
  4, -2, 10,  1, 13,  2,  3, -2,  5,  0,
  2,  4, 10, -3, 13,  0,
  4, -2, 10,  1, 13,  2,  3, -3,  5,  0,
  3, -2, 10,  1, 13,  1,  2,  0,
  4,  2, 10, -1, 12,  1, 13, -2, 11,  1,
  4, -2, 10,  1, 13,  2,  2, -2,  3,  0,
  2,  3, 12, -1, 13,  0,
  2,  3, 10, -2, 11,  0,
  2,  1, 10, -2, 12,  0,
  4,  4, 10,  1, 12, -1, 13, -2, 11,  0,
  3, -1, 13,  3,  2, -2,  3,  0,
  3, -1, 13,  3,  3, -2,  5,  0,
  3, -2, 10, 18,  2,-15,  3,  0,
  5,  2, 10, -1, 13,  3,  3, -8,  4,  3,  5,  0,
  3,  2, 10, -1, 12, -1, 13,  2,
  5, -2, 10,  1, 13,  5,  3, -8,  4,  3,  5,  0,
  5, -2, 10,  1, 13,  1,  3,  2,  5, -5,  6,  0,
  4,  2, 10, -2, 13, 18,  2,-17,  3,  0,
  4, -2, 10,  1, 13,  1,  3, -1,  6,  0,
  4, -2, 10,  1, 13,  2,  3, -2,  4,  0,
  4, -2, 10,  1, 13,  1,  3, -1,  5,  0,
  2,  3, 10, -2, 13,  0,
  4, -2, 10,  1, 13,  3,  2, -4,  3,  0,
  4, -2, 10,  1, 13,  3,  3, -4,  4,  0,
  4, -2, 10,  1, 13,  1,  3, -2,  5,  0,
  3,  4, 10,  1, 12, -3, 13,  0,
  4, -2, 10,  1, 13,  1,  3, -3,  5,  0,
  3, -1, 13,  4,  2, -4,  3,  0,
  4, -2, 10,  1, 13,  1,  2, -1,  3,  0,
  4, -2, 10,  1, 13,  1,  3, -1,  4,  0,
  4, -2, 10,  1, 13,  2,  3, -3,  4,  0,
  4, -2, 10,  1, 13,  3,  3, -5,  4,  0,
  3,  2, 10,  1, 13, -2, 11,  0,
  4, -2, 10, -1, 13,  1, 11,  1, 14,  0,
  4, -2, 10,  1, 13,  2,  2, -3,  3,  1,
  2,  2, 12, -1, 13,  1,
  3,  3, 10,  1, 12, -2, 11,  0,
  4,  2, 10, -1, 13,  2,  3, -4,  4,  0,
  4,  2, 10, -1, 13,  3,  2, -5,  3,  0,
  2,  1, 10, -1, 12,  1,
  3, -1, 13,  3,  2, -3,  3,  0,
  3, -2, 10,  1, 13,  1,  5,  0,
  4,  2, 10, -1, 13,  1,  3, -2,  4,  0,
  3, -1, 13,  2,  3, -2,  5,  0,
  4,  2, 10, -1, 13, -1, 11,  1, 14,  0,
  3, -1, 13,  5,  3, -6,  4,  0,
  3, -2, 10,  1, 13,  1,  6,  0,
  3, -1, 10,  1,  3, -1,  5,  0,
  4, -2, 10,  1, 13,  8,  2,-13,  3,  1,
  3, -2, 10, 18,  2,-16,  3,  1,
  5, -2, 10,  1, 13,  3,  2, -7,  3,  4,  4,  1,
  4,  2, 10, -1, 13,  2,  5, -5,  6,  1,
  5,  2, 10, -1, 13,  4,  3, -8,  4,  3,  5,  1,
  2,  2, 10, -1, 13,  2,
  5, -2, 10,  1, 13,  4,  3, -8,  4,  3,  5,  1,
  4, -2, 10,  1, 13,  2,  5, -5,  6,  1,
  5,  2, 10, -1, 13,  3,  2, -7,  3,  4,  4,  0,
  4,  2, 10, -2, 13, 18,  2,-16,  3,  1,
  4,  2, 10, -1, 13,  8,  2,-13,  3,  1,
  3, -1, 10,  3,  2, -4,  3,  0,
  3, -1, 13,  6,  2, -8,  3,  0,
  3, -1, 13,  2,  3, -3,  5,  0,
  3, -1, 13,  6,  3, -8,  4,  0,
  3,  2, 10, -1, 13,  1,  6,  0,
  4, -2, 10,  1, 13, -1, 11,  1, 14,  0,
  4, -2, 10,  1, 13,  1,  3, -2,  4,  0,
  3,  2, 10, -1, 13,  1,  5,  0,
  3,  3, 10,  1, 12, -2, 13,  0,
  4, -2, 10,  1, 13,  3,  2, -5,  3,  0,
  4, -2, 10,  1, 13,  2,  3, -4,  4,  0,
  2, -1, 13,  1,  2,  0,
  4,  2, 10, -1, 13,  2,  2, -3,  3,  0,
  3, -1, 10,  1,  2, -1,  3,  0,
  3, -1, 13,  4,  2, -5,  3,  0,
  3,  2, 10, -3, 13,  2, 11,  0,
  4,  2, 10, -1, 13,  2,  3, -3,  4,  0,
  3, -1, 13,  2,  2, -2,  3,  0,
  4,  2, 10, -1, 13,  1,  2, -1,  3,  0,
  4,  2, 10,  1, 12,  1, 13, -2, 11,  0,
  3, -2, 13, 18,  2,-15,  3,  0,
  2,  1, 12, -1, 13,  2,
  3, -1, 13,  1,  3, -1,  6,  0,
  4,  2, 10, -1, 13,  1,  3, -2,  5,  0,
  3, -1, 13,  2,  3, -2,  4,  0,
  3, -1, 13,  1,  3, -1,  5,  0,
  4,  2, 10, -1, 13,  3,  3, -4,  4,  0,
  1,  1, 10,  0,
  3, -1, 13,  3,  2, -4,  3,  0,
  3, -1, 13,  3,  3, -4,  4,  0,
  4,  2, 10, -1, 13,  1,  3, -1,  5,  0,
  4,  2, 10, -1, 13,  2,  3, -2,  4,  0,
  3, -1, 13,  1,  3, -2,  5,  0,
  3,  2, 10,  1, 12, -1, 13,  2,
  3,  1, 12,  1, 13, -2, 11,  0,
  3, -1, 13,  1,  2, -1,  3,  0,
  4,  2, 10, -1, 13,  2,  2, -2,  3,  0,
  3, -1, 13,  4,  2, -6,  3,  0,
  3, -1, 13,  2,  3, -3,  4,  0,
  3,  1, 13,  1,  2, -2,  3,  0,
  4,  2, 10, -1, 13,  3,  3, -3,  4,  0,
  2,  3, 13, -2, 11,  0,
  4,  2, 10, -1, 13,  4,  2, -5,  3,  0,
  3,  1, 10,  1,  2, -1,  3,  0,
  3, -1, 13,  2,  2, -3,  3,  1,
  3,  2, 10,  2, 12, -3, 13,  0,
  3,  2, 10, -1, 13,  1,  2,  0,
  3,  1, 13,  2,  3, -4,  4,  0,
  3,  1, 13,  3,  2, -5,  3,  0,
  2, 21,  2,-21,  3,  0,
  3,  1, 10,  1, 12, -2, 13,  1,
  4,  2, 10, -1, 13,  2,  3, -4,  5,  0,
  4,  2, 10, -1, 13,  7,  3,-10,  4,  0,
  2, -1, 13,  1,  5,  0,
  3,  1, 13,  1,  3, -2,  4,  0,
  4,  2, 10, -3, 13,  2,  3, -2,  5,  0,
  3,  1, 10,  1,  3, -2,  5,  0,
  3,  1, 13, -1, 11,  1, 14,  1,
  2, -1, 13,  1,  6,  0,
  4,  2, 10, -1, 13,  6,  3, -8,  4,  1,
  4,  2, 10, -1, 13,  2,  3, -3,  5,  1,
  3, -1, 13,  8,  3,-15,  4,  0,
  4,  2, 10, -1, 13,  6,  2, -8,  3,  0,
  5,  2, 10, -1, 13, -2, 11,  5,  2, -6,  3,  0,
  3,  1, 10,  3,  3, -4,  4,  0,
  3,  1, 10,  3,  2, -4,  3,  1,
  4,  1, 10, -1, 13, -1, 11,  2,  4,  0,
  3, -2, 13, 26,  2,-29,  3,  0,
  3, -1, 13,  8,  2,-13,  3,  0,
  3, -2, 13, 18,  2,-16,  3,  2,
  4, -1, 13,  3,  2, -7,  3,  4,  4,  0,
  3,  1, 13,  2,  5, -5,  6,  1,
  4,  1, 13,  4,  3, -8,  4,  3,  5,  1,
  1,  1, 13,  3,
  4, -1, 13,  4,  3, -8,  4,  3,  5,  1,
  3, -1, 13,  2,  5, -5,  6,  1,
  4,  1, 13,  3,  2, -7,  3,  4,  4,  0,
  2, 18,  2,-16,  3,  1,
  3,  1, 13,  8,  2,-13,  3,  2,
  2, 26,  2,-29,  3,  0,
  4,  1, 10,  1, 13, -1, 11,  2,  4,  0,
  5,  2, 10,  1, 13, -2, 11,  5,  2, -6,  3,  0,
  3,  1, 13,  8,  3,-15,  4,  1,
  4,  2, 10, -3, 13,  2,  3, -3,  5,  0,
  3,  1, 10,  1,  3, -1,  5,  0,
  2,  1, 13,  1,  6,  0,
  4,  2, 10, -1, 13,  5,  3, -6,  4,  0,
  3,  1, 10,  2,  3, -2,  4,  0,
  3, -1, 13, -1, 11,  1, 14,  1,
  4,  2, 10, -1, 13,  2,  3, -5,  6,  0,
  4,  2, 10, -1, 13,  2,  3, -2,  5,  0,
  5,  2, 10, -1, 13,  2,  3, -4,  5,  5,  6,  0,
  3, -1, 13,  1,  3, -2,  4,  1,
  2,  1, 13,  1,  5,  0,
  4,  2, 10, -1, 13,  4,  3, -4,  4,  0,
  4,  2, 10, -1, 13,  3,  2, -3,  3,  0,
  4,  2, 10,  2, 12, -1, 13, -2, 11,  0,
  2,  1, 10,  1, 12,  2,
  3, -1, 13,  3,  2, -5,  3,  0,
  3, -1, 13,  2,  3, -4,  4,  0,
  4,  2, 10, -1, 13,  2,  3, -1,  5,  0,
  4,  2, 10, -1, 13,  2,  3, -2,  6,  0,
  3,  1, 10,  1, 12, -2, 11,  0,
  3,  2, 10,  2, 12, -1, 13,  1,
  3,  1, 13,  2,  2, -3,  3,  1,
  3, -1, 13,  1, 11,  1, 14,  0,
  2,  1, 13, -2, 11,  0,
  4,  2, 10, -1, 13,  5,  2, -6,  3,  0,
  3, -1, 13,  1,  2, -2,  3,  0,
  3,  1, 13,  2,  3, -3,  4,  0,
  3,  1, 13,  1,  2, -1,  3,  0,
  4,  2, 10, -1, 13,  4,  2, -4,  3,  0,
  3,  2, 10,  1, 12, -3, 13,  1,
  3,  1, 13,  1,  3, -2,  5,  0,
  3,  1, 13,  3,  3, -4,  4,  0,
  3,  1, 13,  3,  2, -4,  3,  0,
  2,  1, 10, -2, 13,  0,
  4,  2, 10, -1, 13,  3,  3, -4,  5,  0,
  3,  1, 13,  1,  3, -1,  5,  0,
  3,  1, 13,  2,  3, -2,  4,  0,
  3,  1, 13,  1,  3, -1,  6,  0,
  4,  2, 10, -1, 13,  3,  3, -3,  5,  0,
  4,  2, 10, -1, 13,  6,  2, -7,  3,  0,
  2,  1, 12,  1, 13,  2,
  4,  2, 10, -1, 13,  3,  3, -2,  5,  0,
  4,  2, 10,  1, 12, -1, 13, -2, 11,  0,
  2,  1, 10,  2, 12,  0,
  2,  1, 10, -2, 11,  0,
  3,  1, 13,  2,  2, -2,  3,  0,
  3,  1, 12, -1, 13,  2, 11,  0,
  4,  2, 10, -1, 13,  5,  2, -5,  3,  0,
  3,  1, 13,  2,  3, -3,  5,  0,
  2,  2, 10, -3, 13,  0,
  3,  1, 13,  2,  3, -2,  5,  0,
  3,  1, 13,  3,  2, -3,  3,  0,
  3,  1, 10, -1, 12, -2, 13,  0,
  4,  2, 10, -1, 13,  6,  2, -6,  3,  0,
  2,  2, 12,  1, 13,  1,
  3,  2, 10, -1, 13, -2, 11,  0,
  3,  1, 10, -1, 12, -2, 11,  0,
  3,  2, 10,  1, 13, -4, 11,  0,
  3,  1, 13,  4,  2, -4,  3,  0,
  4,  2, 10, -1, 13,  7,  2, -7,  3,  0,
  3,  2, 10, -1, 12, -3, 13,  1,
  2,  3, 12,  1, 13,  0,
  4,  2, 10, -1, 12, -1, 13, -2, 11,  0,
  3,  1, 13,  5,  2, -5,  3,  0,
  4,  2, 10, -1, 13,  8,  2, -8,  3,  0,
  3,  2, 10, -2, 12, -3, 13,  0,
  4,  2, 10, -1, 13,  9,  2, -9,  3,  0,
  3,  4, 10, -3, 12, -2, 13,  0,
  2,  2, 10, -4, 12,  0,
  3,  4, 10, -2, 12, -2, 13,  1,
  2,  6, 10, -4, 13,  0,
  3,  4, 10, -1, 12, -2, 11,  0,
  2,  2, 10, -3, 12,  1,
  3,  3, 10, -2, 12, -1, 13,  0,
  3, -2, 10,  3,  3, -2,  5,  0,
  3,  4, 10, -1, 12, -2, 13,  1,
  3, -2, 10,  3,  3, -3,  5,  0,
  2,  5, 10, -3, 13,  0,
  3, -2, 10,  4,  2, -4,  3,  0,
  3, -2, 10,  2,  2, -1,  3,  0,
  2,  4, 10, -2, 11,  0,
  2,  2, 10, -2, 12,  2,
  3, -2, 10,  3,  3, -2,  4,  0,
  3, -2, 10,  2,  3, -1,  5,  0,
  3,  3, 10, -1, 12, -1, 13,  1,
  3, -2, 10,  3,  2, -3,  3,  0,
  3, -2, 10,  2,  3, -2,  5,  0,
  2,  4, 10, -2, 13,  0,
  3, -2, 10,  2,  3, -3,  5,  0,
  2, -2, 10,  1,  2,  0,
  4,  2, 10, -1, 12,  2, 13, -2, 11,  0,
  3, -2, 10,  2,  2, -2,  3,  0,
  3,  3, 10,  1, 13, -2, 11,  0,
  3,  4, 10,  1, 12, -2, 11,  0,
  4,  2, 10, -1, 12, -1, 11,  1, 14,  0,
  4, -2, 10, -1, 13, 18,  2,-15,  3,  0,
  4,  2, 10,  3,  3, -8,  4,  3,  5,  0,
  2,  2, 10, -1, 12,  2,
  4, -2, 10,  5,  3, -8,  4,  3,  5,  0,
  4,  2, 10, -1, 13, 18,  2,-17,  3,  0,
  3, -2, 10,  1,  3, -1,  6,  0,
  3, -2, 10,  2,  3, -2,  4,  0,
  3, -2, 10,  1,  3, -1,  5,  0,
  2,  3, 10, -1, 13,  0,
  3, -2, 10,  3,  2, -4,  3,  0,
  3, -2, 10,  3,  3, -4,  4,  0,
  3, -2, 10,  1,  3, -2,  5,  0,
  3,  4, 10,  1, 12, -2, 13,  1,
  4,  2, 10, -1, 12, -2, 13,  2, 11,  0,
  3, -2, 10,  1,  2, -1,  3,  0,
  3, -2, 10,  2,  3, -3,  4,  0,
  3,  2, 10,  2, 13, -2, 11,  0,
  3, -2, 10,  2,  2, -3,  3,  0,
  2,  2, 12, -2, 13,  1,
  3,  2, 10,  2,  3, -4,  4,  0,
  3,  2, 10,  3,  2, -5,  3,  0,
  3,  1, 10, -1, 12,  1, 13,  1,
  3, -2, 13,  3,  2, -3,  3,  0,
  2, -2, 10,  1,  5,  0,
  3,  2, 10,  1,  3, -2,  4,  0,
  3, -2, 13,  2,  3, -2,  5,  0,
  3,  2, 10, -1, 11,  1, 14,  0,
  4,  4, 10, -2, 13,  2,  3, -3,  5,  0,
  3, -2, 10,  8,  2,-13,  3,  0,
  4, -2, 10, -1, 13, 18,  2,-16,  3,  1,
  4, -2, 10,  3,  2, -7,  3,  4,  4,  0,
  4,  2, 10,  4,  3, -8,  4,  3,  5,  1,
  1,  2, 10,  3,
  4, -2, 10,  4,  3, -8,  4,  3,  5,  1,
  4,  2, 10,  3,  2, -7,  3,  4,  4,  0,
  4,  2, 10, -1, 13, 18,  2,-16,  3,  1,
  3,  2, 10,  8,  2,-13,  3,  0,
  3, -2, 10, -1, 11,  1, 14,  0,
  4,  4, 10, -2, 13,  2,  3, -2,  5,  0,
  3, -2, 10,  1,  3, -2,  4,  0,
  2,  2, 10,  1,  5,  0,
  4,  4, 10, -2, 13,  3,  2, -3,  3,  0,
  3,  3, 10,  1, 12, -1, 13,  1,
  3, -2, 10,  3,  2, -5,  3,  0,
  3, -2, 10,  2,  3, -4,  4,  0,
  3,  4, 10,  2, 12, -2, 13,  0,
  3,  2, 10,  2,  2, -3,  3,  0,
  3,  2, 10, -2, 13,  2, 11,  0,
  3,  2, 10,  1,  2, -1,  3,  0,
  4,  2, 10,  1, 12,  2, 13, -2, 11,  0,
  2,  1, 12, -2, 13,  2,
  3,  2, 10,  1,  3, -2,  5,  0,
  3, -2, 13,  1,  3, -1,  5,  0,
  3,  2, 10,  3,  2, -4,  3,  0,
  2,  1, 10,  1, 13,  0,
  3,  2, 10,  1,  3, -1,  5,  0,
  3,  2, 10,  2,  3, -2,  4,  0,
  2,  2, 10,  1, 12,  2,
  2,  1, 12, -2, 11,  0,
  3, -2, 13,  1,  2, -1,  3,  0,
  3,  1, 10, -1, 13,  2, 11,  0,
  3,  2, 10,  2,  2, -2,  3,  0,
  3,  1, 10,  1, 12, -3, 13,  0,
  3,  2, 13, -1, 11,  1, 14,  0,
  3,  2, 10,  2,  3, -3,  5,  0,
  3,  2, 10,  6,  2, -8,  3,  0,
  3, -3, 13, 18,  2,-16,  3,  1,
  3,  2, 13,  2,  5, -5,  6,  0,
  4,  2, 13,  4,  3, -8,  4,  3,  5,  0,
  1,  2, 13,  0,
  4, -2, 13,  4,  3, -8,  4,  3,  5,  0,
  3, -2, 13,  2,  5, -5,  6,  0,
  3,  1, 13, 18,  2,-16,  3,  1,
  3, -2, 13, -1, 11,  1, 14,  0,
  3,  2, 10,  2,  3, -2,  5,  0,
  3,  2, 10,  3,  2, -3,  3,  0,
  3,  1, 10,  1, 12,  1, 13,  1,
  2,  2, 10,  2, 12,  1,
  2,  1, 11,  1, 14,  1,
  4, -1, 13, -2, 11, 18,  2,-16,  3,  0,
  1,  2, 11,  0,
  4, -1, 13,  2, 11, 18,  2,-16,  3,  0,
  2, -3, 11,  1, 14,  0,
  3,  2, 13,  1,  2, -1,  3,  0,
  3,  2, 10,  4,  2, -4,  3,  0,
  3,  2, 10,  1, 12, -4, 13,  0,
  2,  1, 10, -3, 13,  0,
  3,  2, 13,  1,  3, -1,  5,  0,
  2,  1, 12,  2, 13,  2,
  3,  1, 10,  2, 12,  1, 13,  0,
  3,  1, 10, -1, 13, -2, 11,  0,
  2,  1, 12,  2, 11,  1,
  3,  2, 10,  5,  2, -5,  3,  0,
  2,  2, 10, -4, 13,  0,
  3,  2, 10,  6,  2, -6,  3,  0,
  2,  2, 12,  2, 13,  0,
  3,  2, 10, -2, 13, -2, 11,  0,
  2,  2, 12,  2, 11,  0,
  2,  2, 10, -4, 11,  0,
  3,  2, 10,  7,  2, -7,  3,  0,
  3,  2, 10, -1, 12, -4, 13,  0,
  4,  2, 10, -1, 12, -2, 13, -2, 11,  0,
  3,  2, 10,  8,  2, -8,  3,  0,
  3,  2, 10,  9,  2, -9,  3,  0,
  3,  4, 10, -3, 12, -1, 13,  0,
  3,  6, 10, -1, 12, -3, 13,  0,
  3,  4, 10, -2, 12, -1, 13,  1,
  3,  5, 10, -1, 12, -2, 13,  0,
  2,  6, 10, -3, 13,  0,
  4,  4, 10, -1, 12,  1, 13, -2, 11,  0,
  3,  2, 10, -3, 12,  1, 13,  0,
  2,  3, 10, -2, 12,  0,
  3,  4, 10, -1, 12, -1, 13,  1,
  2,  5, 10, -2, 13,  0,
  3,  6, 10,  1, 12, -3, 13,  0,
  3,  4, 10,  1, 13, -2, 11,  0,
  3,  2, 10, -2, 12,  1, 13,  1,
  2,  3, 10, -1, 12,  0,
  4, -2, 10, -1, 13,  2,  3, -2,  5,  0,
  2,  4, 10, -1, 13,  0,
  4,  2, 10, -2, 12, -1, 13,  2, 11,  0,
  3,  4, 10, -3, 13,  2, 11,  0,
  4, -2, 10, -1, 13,  2,  2, -2,  3,  0,
  3,  2, 10, -1, 12,  1, 13,  2,
  4, -2, 10, -1, 13,  1,  3, -1,  5,  0,
  1,  3, 10,  0,
  3,  4, 10,  1, 12, -1, 13,  1,
  4,  2, 10, -1, 12, -1, 13,  2, 11,  1,
  4, -2, 10, -1, 13,  1,  2, -1,  3,  0,
  3,  2, 10,  3, 13, -2, 11,  0,
  2,  2, 12, -3, 13,  0,
  3,  1, 10, -1, 12,  2, 13,  0,
  4,  2, 10,  1, 13, -1, 11,  1, 14,  0,
  4, -2, 10, -2, 13, 18,  2,-16,  3,  0,
  5,  2, 10,  1, 13,  4,  3, -8,  4,  3,  5,  0,
  2,  2, 10,  1, 13,  1,
  5, -2, 10, -1, 13,  4,  3, -8,  4,  3,  5,  0,
  3,  2, 10, 18,  2,-16,  3,  0,
  4, -2, 10, -1, 13, -1, 11,  1, 14,  0,
  4,  4, 10, -1, 13,  2,  3, -2,  5,  0,
  4,  4, 10, -1, 13,  3,  2, -3,  3,  0,
  2,  3, 10,  1, 12,  1,
  3,  4, 10,  2, 12, -1, 13,  0,
  4,  2, 10, -1, 13,  1, 11,  1, 14,  0,
  3,  2, 10, -1, 13,  2, 11,  0,
  2,  1, 12, -3, 13,  1,
  2,  1, 10,  2, 13,  0,
  3,  2, 10,  1, 12,  1, 13,  1,
  3,  1, 12, -1, 13, -2, 11,  1,
  2,  1, 10,  2, 11,  0,
  4,  2, 10,  1, 12, -1, 13,  2, 11,  0,
  1,  3, 13,  0,
  4,  2, 10,  1, 13,  2,  3, -2,  5,  0,
  3,  1, 10,  1, 12,  2, 13,  0,
  3,  2, 10,  2, 12,  1, 13,  0,
  3,  1, 13,  1, 11,  1, 14,  0,
  2,  1, 13,  2, 11,  0,
  3,  1, 10,  1, 12,  2, 11,  0,
  4,  2, 10,  2, 12, -1, 13,  2, 11,  0,
  2,  1, 13, -4, 11,  0,
  2,  1, 10, -4, 13,  0,
  2,  1, 12,  3, 13,  1,
  3,  1, 12,  1, 13,  2, 11,  1,
  2,  2, 10, -5, 13,  0,
  3,  2, 10, -3, 13, -2, 11,  0,
  3,  2, 10, -1, 13, -4, 11,  0,
  3,  6, 10, -2, 12, -2, 13,  0,
  2,  4, 10, -3, 12,  0,
  3,  6, 10, -1, 12, -2, 13,  0,
  2,  4, 10, -2, 12,  1,
  2,  6, 10, -2, 13,  0,
  2,  4, 10, -1, 12,  1,
  2,  5, 10, -1, 13,  0,
  3,  6, 10,  1, 12, -2, 13,  0,
  4,  4, 10, -1, 12, -2, 13,  2, 11,  0,
  3,  4, 10,  2, 13, -2, 11,  0,
  3,  2, 10, -2, 12,  2, 13,  0,
  1,  4, 10,  0,
  3,  2, 10, -2, 12,  2, 11,  0,
  3,  4, 10, -2, 13,  2, 11,  0,
  3,  2, 10, -1, 12,  2, 13,  1,
  2,  3, 10,  1, 13,  0,
  2,  4, 10,  1, 12,  1,
  3,  2, 10, -1, 12,  2, 11,  1,
  3,  3, 10, -1, 13,  2, 11,  0,
  2,  2, 10,  2, 13,  0,
  3,  3, 10,  1, 12,  1, 13,  0,
  3,  2, 10,  1, 11,  1, 14,  0,
  2,  2, 10,  2, 11,  0,
  2,  1, 12, -4, 13,  0,
  2,  1, 10,  3, 13,  0,
  3,  2, 10,  1, 12,  2, 13,  1,
  3,  1, 12, -2, 13, -2, 11,  0,
  3,  1, 10,  1, 13,  2, 11,  0,
  3,  2, 10,  1, 12,  2, 11,  0,
  1,  4, 13,  0,
  3,  1, 10,  1, 12,  3, 13,  0,
  2,  2, 13,  2, 11,  0,
  4,  1, 10,  1, 12,  1, 13,  2, 11,  0,
  1,  4, 11,  0,
  2,  1, 12,  4, 13,  0,
  3,  1, 12,  2, 13,  2, 11,  0,
  3,  2, 10, -4, 13, -2, 11,  0,
  3,  6, 10, -2, 12, -1, 13,  0,
  2,  8, 10, -3, 13,  0,
  3,  6, 10, -1, 12, -1, 13,  0,
  3,  4, 10, -2, 12,  1, 13,  0,
  2,  6, 10, -1, 13,  0,
  3,  4, 10, -1, 12,  1, 13,  1,
  3,  6, 10,  1, 12, -1, 13,  0,
  4,  4, 10, -1, 12, -1, 13,  2, 11,  0,
  3,  2, 10, -2, 12,  3, 13,  0,
  2,  4, 10,  1, 13,  0,
  3,  4, 10, -1, 13,  2, 11,  0,
  3,  2, 10, -1, 12,  3, 13,  0,
  3,  4, 10,  1, 12,  1, 13,  0,
  4,  2, 10, -1, 12,  1, 13,  2, 11,  0,
  2,  2, 10,  3, 13,  0,
  3,  2, 10,  1, 13,  2, 11,  0,
  3,  2, 10, -1, 13,  4, 11,  0,
  3,  2, 10,  1, 12,  3, 13,  0,
  3,  1, 12, -3, 13, -2, 11,  0,
  3,  1, 10,  2, 13,  2, 11,  0,
  4,  2, 10,  1, 12,  1, 13,  2, 11,  0,
  1,  5, 13,  0,
  2,  3, 13,  2, 11,  0,
  2,  1, 13,  4, 11,  0,
  3,  1, 12,  3, 13,  2, 11,  0,
  2,  8, 10, -2, 13,  0,
  2,  6, 10, -1, 12,  0,
  1,  6, 10,  0,
  3,  6, 10, -2, 13,  2, 11,  0,
  3,  4, 10, -1, 12,  2, 13,  0,
  3,  4, 10, -1, 12,  2, 11,  0,
  2,  4, 10,  2, 13,  0,
  2,  4, 10,  2, 11,  0,
  3,  2, 10, -1, 12,  4, 13,  0,
  3,  4, 10,  1, 12,  2, 13,  0,
  4,  2, 10, -1, 12,  2, 13,  2, 11,  0,
  2,  2, 10,  4, 13,  0,
  3,  2, 10,  2, 13,  2, 11,  0,
  2,  2, 10,  4, 11,  0,
  1,  6, 13,  0,
  2,  4, 13,  2, 11,  0,
  2,  2, 13,  4, 11,  0,
  3,  6, 10, -1, 12,  1, 13,  0,
  2,  6, 10,  1, 13,  0,
  2,  4, 10,  3, 13,  0,
  3,  4, 10,  1, 13,  2, 11,  0,
  2,  2, 10,  5, 13,  0,
  3,  2, 10,  3, 13,  2, 11,  0,
 -1
};





static long  tabrl[] = {-1};
static long  tabbl[] = {-1};
static long  tabll[] = {
        -3,        -4,

         4,     -1856,         0,      8043,

        -9,     -1082,

        -1,      -310,

        -1,      -522,

      -330,     -1449,      -853,      4656,

       -66,         7,

        -1,   9996928,

       -66,         6,

        23,       183,

         0,       173,

         0,       -56,

         0,        50,

         0,      -785,

         1,        51,

         0,       -60,

         1,     11843,         0,    -50754,

         0,      1834,         1,     -7910,

         0,    -48060,

         1,        56,

         0,     13141,        -1,    -56318,

         0,      2541,

        -1,      -649,

      -133,       778,

       -46,         8,

         1,   1665737,

       -47,         7,

         0,        65,

         0,        45,

         0,      -138,

         0,     -1005,

         0,     -2911,

         0,       -47,

         0,        96,

         0,      -394,

         2,        76,

         2,    -17302,         0,     74337,

         0,      -101,

         0,        58,

         0,      -171,

         0,       -77,

         0,     -1283,         0,      2686,

         0,       -55,

         0,        99,

         0,        55,

         0,       397,

         0,       540,

         0,       626,

        -1,     -5188,         0,     10857,

         0,      -216,

        -2,      -123,

         0,      6337,

         2,       224,

      -152,    -23472,       -29,    -74336,         0,    295775,

       -20,       149,

        -2,        84,

         9,       304,

         0,     -3051,

       -70,        -6,

       -57,        34,

         0,      -638,

         0,      -201,

       -73,         9,

         0,      -100,

      -101,        -8,

         0,       -57,

         0,      -207,

        -3,        80,

       -45,        45,

        -5,       102,

       -59,       -23,

        52,       201,

       -48,       233,      -220,        71,

         4,      2810,         0,   6236541,

       -61,       218,      -216,        67,

        51,       201,

       -59,       -23,

      -144,      -837,      -457,      3029,

       -45,        42,

       -15,        73,

        -6,      -169,

         0,       135,

       -64,        -7,

         0,    -16245,

         0,       -81,

       -74,       -10,

         0,       702,         0,     -3013,

         0,     -5889,

         1,       141,

        58,      9598,        12,     30443,         1,   -120946,

        -1,       -84,

        -2,     11246,        -1,    -48391,

         0,      1393,

         0,       200,

      -136,       -17,

         0,       558,

       -64,        -8,

         0,       -71,

         0,    317577,

       -28,       183,

         1,       219,

         0,       421,

         0,      -133,

       501,      -139,

         3,       354,

      -101,       -13,

        74,         7,

       144,       -84,

        59,        -2,

         1,        64,

     -2931,     12559,     -4641,      2638,      -303,     -2058,

       -13,      -100,      -123,       -79,

    -19214,      6084,      1494,     26993,     15213,    -82219,

        42,        52,        48,      -101,

       -53,        -4,

         4,        47,

        58,      -131,

        46,        14,

       -21,        -6,

     -1311,     -8791,     10198,     -4185,      2815,      5640,

       167,       422,      -229,        83,

      3140,        39,      1221,       120,        96,       -30,
        -1, 184612405,

       187,       416,      -226,        81,

     -1985,    -10083,      9983,     -4464,      2807,      5643,

       -21,        -9,

       113,      -367,

       120,       580,      -667,        27,

         8,        66,

       -56,        -6,

       337,        95,

       -87,      3303,

        -1,        65,

        68,      -374,

         0,      -574,

        15,       -94,

         0,       -53,

         0,     -1303,

         0,      -236,

       283,        36,

        -1,       -54,

       269,       -35,

         0,       -83,

         0,       -52,

         0,       730,         0,     -3129,

         0,       813,

         0,     -4299,

         1,        59,

        -6,      5130,         1,     16239,        -1,    -64603,

         0,       -80,

        91,        12,

         0,      -561,

       133,       -17,

         0,       250,

       -12,        71,

         0,    155664,

        82,       -11,

         0,       106,

         0,      -604,

         0,     21862,

        55,        -7,

         0,     -1514,         0,      6501,

         0,       906,

         0,       -68,

         0,       241,

         0,       366,

         0,        70,

         0,     -1382,         0,      5957,

         0,       113,

         0,       -51,

         0,       -55,

         0,       731,

         0,      -264,

         0,     65788,

         1,     -1504,         0,      3147,

         0,       217,

         0,     -4105,         0,     17658,

         1,        69,

         0,     -3518,

         0,     -1767,

       -43,     -7044,       -10,    -22304,         0,     88685,

         3,        91,

         0,      -485,

         0,       -57,

        -1,    333548,

       -24,       172,

        11,       544,         1,     -1132,

         0,       353,

         0,      -188,

         0,        53,

         0,        77,

       158,      -887,

        35,       131,

       -54,        13,

         0,   1994821,

       -53,        14,

        36,       125,

         2,        56,

         0,      -243,

         0,      -364,

        -2,      1916,         0,     -8227,

         0,     15700,        -1,    -67308,

         1,        66,

         0,    -53686,

         1,      3058,         1,    -13177,

         0,       -72,

         0,       -72,

         0,        61,

         0,     15812,

         0,       165,

         8,       -96,

       318,      1341,       803,     -4252,

        24,       193,

      1137,      -226,       310,       622,

       -56,        30,

        -3,  10101666,

       -56,        30,

      1096,      -225,       300,       600,

       -31,       409,

        -1,      -507,

         0,      -287,

         0,     -1869,         0,      8026,

         1,       544,        -1,     -1133,

         0,     27984,

         0,       -62,

         0,      -249,

         0,       187,

         0,     -1096,

         1,        53,

         2,     12388,         0,    -53107,

         0,      -322,

         0,       -94,

         0,     15157,

         0,      -582,

         0,      3291,

         0,       565,

         0,       106,

         0,       112,

         0,       306,

         0,       809,

         0,       130,

         0,      -961,         0,      4149,

         0,       174,

         0,      -105,

         0,      2196,

         0,        59,

         0,     36737,

        -1,     -1832,         0,      3835,

         0,      -139,

         0,     24138,

         0,      1325,

         1,        64,

         0,      -361,

         0,     -1162,

       -44,     -6320,       -10,    -20003,         0,     79588,

         2,        80,

         0,     -2059,

         0,      -304,

         0,     21460,

         0,      -166,

         0,       -87,

        89,      -493,

        32,       114,

        34,       510,         1,   1172616,

        31,       113,

        -1,        57,

         0,       214,

         0,      -656,

         0,      -646,

         0,      1850,         0,     -7931,

         0,     -6674,

         0,      2944,         0,    -12641,

         0,       916,

        45,      -255,

        16,        60,

        -1,    619116,

        16,        57,

         0,       -58,

         0,      1045,

         0,      -156,

       -15,        88,

         0,    -62964,

         0,      -126,

         0,      1490,         0,     -6387,

         0,       119,

         0,      1338,

         0,       -56,

         0,       204,

         0,       153,

         0,       940,

         0,       251,

         0,       312,

         0,       584,

         0,      -786,         0,      3388,

         0,       -52,

         0,      4733,

         0,       618,

         0,     29982,

         0,       101,

         0,      -174,

         0,     -2637,         0,     11345,

         0,      -284,

         0,      -524,

         0,      -121,

         0,      1464,

        11,       -60,

        -1,    151205,

         0,       139,

         0,     -2448,

         0,       -51,

         0,      -768,

         0,      -638,

         0,       552,         0,     -2370,

         0,        70,

         0,        64,

         0,        57,

         0,     39840,

         0,       104,

         0,    -10194,

         0,      -635,

         0,        69,

         0,       113,

         0,        67,

         0,        96,

         0,       367,

         0,       134,

         0,       596,

         0,        63,

         0,      1622,

         0,       483,

         0,        72,

         0,     11917,

         0,       -63,

         0,      1273,

         0,       -66,

         0,      -262,

         0,       -97,

         0,       103,

         0,     15196,

         0,     -1445,

         0,       -66,

         0,       -55,

         0,      -323,

         0,      2632,

         0,     -1179,

         0,        59,

         0,       -56,

         0,        78,

         0,        65,

         0,       422,

         0,       309,

         0,      2125,

         0,       -66,

         0,       124,

         0,       -57,

         0,      1379,

         0,      -304,

         0,       177,

         0,      -118,

         0,       146,

         0,       283,

         0,       119,

};
static char  argsl[] = {
  0,  1,
  3,  1, 10,  1, 12, -1, 11,  1,
  4,  2, 10,  2, 12, -1, 13, -1, 11,  0,
  5,  2, 10, -1, 13, -1, 11,  3,  2, -3,  3,  0,
  5,  2, 10, -1, 13, -1, 11,  2,  3, -2,  5,  0,
  2, -1, 13,  1, 14,  1,
  5, -1, 13,  1, 11,  4,  3, -8,  4,  3,  5,  0,
  2,  1, 13, -1, 11,  0,
  5,  1, 13, -1, 11,  4,  3, -8,  4,  3,  5,  0,
  5,  2, 10, -1, 13, -1, 11,  2,  3, -3,  5,  0,
  4,  1, 10,  1, 12, -2, 13,  1, 11,  0,
  4,  1, 13, -1, 11,  1,  2, -1,  3,  0,
  5,  2, 10, -1, 13, -1, 11,  2,  2, -2,  3,  0,
  3,  1, 10, -2, 13,  1, 11,  0,
  4,  1, 13, -1, 11,  1,  3, -1,  5,  0,
  4, -1, 13,  1, 11,  1,  2, -1,  3,  0,
  3,  1, 12,  1, 13, -1, 11,  1,
  4,  2, 10,  1, 12, -1, 13, -1, 11,  1,
  2,  1, 10, -1, 11,  0,
  4, -1, 13,  1, 11,  1,  3, -1,  5,  0,
  3,  1, 12, -1, 13,  1, 11,  1,
  3,  2, 10, -3, 13,  1, 11,  0,
  3,  2, 12,  1, 13, -1, 11,  0,
  3, -2, 10,  1, 13,  1, 14,  0,
  6, -2, 10,  1, 13,  1, 11,  4,  3, -8,  4,  3,  5,  0,
  3,  2, 10, -1, 13, -1, 11,  0,
  6,  2, 10, -1, 13, -1, 11,  4,  3, -8,  4,  3,  5,  0,
  4, -1, 13,  1, 11,  2,  3, -2,  5,  0,
  4, -1, 13,  1, 11,  3,  2, -3,  3,  0,
  3,  1, 10, -1, 12, -1, 11,  0,
  3,  2, 12, -1, 13,  1, 11,  0,
  3,  2, 10,  1, 13, -3, 11,  0,
  5, -2, 10,  1, 13,  1, 11,  1,  2, -1,  3,  0,
  4,  2, 10, -1, 12, -3, 13,  1, 11,  0,
  3,  3, 10, -2, 13, -1, 11,  0,
  5, -2, 10,  1, 13,  1, 11,  1,  3, -1,  5,  0,
  4,  2, 10, -1, 12, -1, 13, -1, 11,  1,
  2,  3, 10, -3, 11,  0,
  5, -2, 10,  1, 13,  1, 11,  2,  2, -2,  3,  0,
  4,  2, 10, -1, 12,  1, 13, -3, 11,  0,
  3,  4, 10, -3, 13, -1, 11,  0,
  4,  2, 10, -2, 12, -1, 13, -1, 11,  1,
  3,  4, 10, -1, 13, -3, 11,  0,
  4,  2, 10, -3, 12, -1, 13, -1, 11,  0,
  3,  4, 10, -1, 12, -3, 11,  0,
  3,  2, 10, -3, 12, -1, 11,  0,
  4,  4, 10, -1, 12, -2, 13, -1, 11,  0,
  2,  4, 10, -3, 11,  0,
  3,  2, 10, -2, 12, -1, 11,  1,
  4,  3, 10, -1, 12, -1, 13, -1, 11,  0,
  4, -2, 10,  1, 11,  2,  3, -2,  5,  0,
  3,  4, 10, -2, 13, -1, 11,  0,
  4, -2, 10,  1, 11,  2,  2, -2,  3,  0,
  3,  2, 10, -1, 12, -1, 11,  2,
  3, -2, 10,  1, 12,  1, 14,  0,
  4, -2, 10,  1, 11,  2,  3, -2,  4,  0,
  4, -2, 10,  1, 11,  1,  3, -1,  5,  0,
  3,  3, 10, -1, 13, -1, 11,  0,
  4, -2, 10,  1, 11,  3,  2, -4,  3,  0,
  4, -2, 10,  1, 11,  1,  3, -2,  5,  0,
  4,  2, 10, -1, 12, -2, 13,  1, 11,  0,
  4, -2, 10,  1, 11,  1,  2, -1,  3,  0,
  2, -1, 10,  1,  2,  0,
  3,  2, 10,  2, 13, -3, 11,  0,
  4, -2, 10,  1, 11,  2,  2, -3,  3,  0,
  3,  2, 12, -2, 13,  1, 11,  0,
  4,  1, 10, -1, 12,  1, 13, -1, 11,  0,
  3, -2, 10,  1, 11,  1,  5,  0,
  4,  2, 10, -1, 11,  1,  3, -2,  4,  0,
  3,  2, 10, -2, 11,  1, 14,  0,
  4, -2, 10,  1, 11,  8,  2,-13,  3,  0,
  5, -2, 10, -1, 13,  1, 11, 18,  2,-16,  3,  0,
  5,  2, 10, -1, 11,  4,  3, -8,  4,  3,  5,  1,
  2,  2, 10, -1, 11,  1,
  5, -2, 10,  1, 11,  4,  3, -8,  4,  3,  5,  1,
  5,  2, 10, -1, 13, -1, 11, 18,  2,-16,  3,  0,
  4,  2, 10, -1, 11,  8,  2,-13,  3,  0,
  2, -2, 10,  1, 14,  1,
  4, -2, 10,  1, 11,  1,  3, -2,  4,  0,
  3,  2, 10, -1, 11,  1,  5,  0,
  2,  2, 12, -1, 11,  0,
  4,  3, 10,  1, 12, -1, 13, -1, 11,  0,
  4,  2, 10, -1, 11,  2,  2, -3,  3,  0,
  3,  2, 10, -2, 13,  1, 11,  0,
  4,  2, 10, -1, 11,  1,  2, -1,  3,  0,
  3,  1, 10,  1,  2, -2,  3,  0,
  3,  1, 12, -2, 13,  1, 11,  1,
  3,  1, 10,  1, 13, -1, 11,  0,
  4,  2, 10, -1, 11,  1,  3, -1,  5,  0,
  3,  2, 10,  1, 12, -1, 11,  2,
  3, -2, 10, -1, 12,  1, 14,  0,
  2,  1, 12, -1, 11,  1,
  3,  1, 10, -1, 13,  1, 11,  0,
  4,  2, 10, -1, 11,  2,  2, -2,  3,  0,
  3,  1, 10,  2,  2, -3,  3,  0,
  4,  2, 10,  1, 12, -2, 13,  1, 11,  0,
  3, -1, 10,  1,  2, -2,  3,  0,
  3, -1, 11,  1,  2, -1,  3,  0,
  2,  2, 13, -1, 11,  0,
  2, -2, 13,  1, 14,  0,
  4,  2, 10, -1, 11,  2,  3, -2,  5,  0,
  4,  2, 10, -1, 11,  3,  2, -3,  3,  0,
  4,  2, 10,  2, 12, -2, 13, -1, 11,  0,
  3,  1, 10,  1,  3, -2,  5,  0,
  4,  1, 10,  1, 12,  1, 13, -1, 11,  0,
  3,  1, 10,  3,  2, -4,  3,  0,
  3,  1, 10,  1,  3, -1,  5,  0,
  3,  1, 10,  1,  3, -2,  6,  0,
  3,  1, 10,  2,  3, -2,  4,  0,
  4,  1, 10,  1, 12, -1, 13, -1, 11,  0,
  3,  2, 10,  2, 12, -1, 11,  2,
  4,  1, 10,  1,  3,  2,  5, -5,  6,  1,
  1,  1, 14,  2,
  3,  1, 10,  8,  2,-12,  3,  1,
  5, -2, 10,  1, 13, -1, 11, 20,  2,-21,  3,  0,
  5,  2, 10, -2, 13,  1, 11,  2,  3, -3,  5,  0,
  3,  1, 10,  1,  3,  1,  6,  0,
  4, -1, 13, -1, 11, 26,  2,-29,  3,  0,
  3, -1, 11,  8,  2,-13,  3,  0,
  4, -1, 13, -1, 11, 18,  2,-16,  3,  2,
  4, -1, 13,  1, 11, 10,  2, -3,  3,  1,
  1,  1, 11,  3,
  4, -1, 13, -1, 11, 10,  2, -3,  3,  1,
  4, -1, 13,  1, 11, 18,  2,-16,  3,  2,
  3,  1, 11,  8,  2,-13,  3,  0,
  2,  1, 10,  2,  4,  0,
  4,  2, 10, -1, 11,  5,  2, -6,  3,  1,
  5,  2, 10, -2, 13, -1, 11,  2,  3, -3,  5,  0,
  5, -2, 10,  1, 13,  1, 11, 20,  2,-21,  3,  0,
  3,  1, 10,  1,  3,  1,  5,  0,
  2, -2, 11,  1, 14,  0,
  5,  2, 10, -2, 13,  1, 11,  2,  3, -2,  5,  0,
  3,  1, 10,  5,  2, -7,  3,  0,
  4,  1, 10,  1, 12, -1, 13,  1, 11,  0,
  3,  1, 10,  2,  2, -2,  3,  0,
  4,  2, 10,  2, 12, -2, 13,  1, 11,  0,
  2,  2, 13, -3, 11,  0,
  4,  2, 10, -1, 11,  4,  2, -4,  3,  0,
  3,  1, 10,  4,  2, -5,  3,  0,
  3,  1, 10, -3, 13,  1, 11,  0,
  2,  1, 10,  1,  2,  0,
  3,  1, 11,  1,  2, -1,  3,  0,
  4,  2, 10, -1, 11,  3,  3, -3,  5,  0,
  3,  1, 12,  2, 13, -1, 11,  1,
  4,  2, 10,  1, 12, -2, 13, -1, 11,  0,
  3,  1, 10, -1, 13, -1, 11,  0,
  3,  1, 11,  1,  3, -1,  5,  0,
  2,  1, 12,  1, 11,  2,
  4,  2, 10, -1, 11,  5,  2, -5,  3,  0,
  3,  1, 10,  5,  2, -6,  3,  0,
  3,  2, 10,  1, 12, -3, 11,  0,
  3,  1, 10,  2,  2, -1,  3,  0,
  3,  2, 10, -4, 13,  1, 11,  0,
  3, -2, 10,  2, 13,  1, 14,  0,
  3,  2, 10, -2, 13, -1, 11,  0,
  3,  1, 10,  3,  2, -2,  3,  0,
  4,  1, 10, -1, 12, -1, 13, -1, 11,  0,
  2,  2, 12,  1, 11,  0,
  2,  2, 10, -3, 11,  0,
  3,  1, 10,  4,  2, -3,  3,  0,
  4,  2, 10, -1, 12, -2, 13, -1, 11,  1,
  3,  2, 10, -1, 12, -3, 11,  0,
  3,  4, 10, -4, 13, -1, 11,  0,
  4,  2, 10, -2, 12, -2, 13, -1, 11,  0,
  4,  4, 10, -2, 12, -1, 13, -1, 11,  0,
  3,  6, 10, -3, 13, -1, 11,  0,
  4,  4, 10, -1, 12, -1, 13, -1, 11,  1,
  4,  2, 10, -3, 12, -1, 13,  1, 11,  0,
  3,  5, 10, -2, 13, -1, 11,  0,
  3,  4, 10,  1, 13, -3, 11,  0,
  4,  2, 10, -2, 12,  1, 13, -1, 11,  0,
  3,  3, 10, -1, 12, -1, 11,  0,
  3,  4, 10, -1, 13, -1, 11,  0,
  4,  2, 10, -2, 12, -1, 13,  1, 11,  1,
  3,  4, 10, -3, 13,  1, 11,  0,
  4,  2, 10, -1, 12,  1, 13, -1, 11,  1,
  5, -2, 10,  1, 13, -1, 11,  2,  2, -2,  3,  0,
  2,  3, 10, -1, 11,  0,
  4,  4, 10,  1, 12, -1, 13, -1, 11,  0,
  4,  2, 10, -1, 12, -1, 13,  1, 11,  2,
  5, -2, 10,  1, 13, -1, 11,  1,  3, -1,  5,  0,
  3,  3, 10, -2, 13,  1, 11,  0,
  5, -2, 10,  1, 13, -1, 11,  1,  2, -1,  3,  0,
  3,  2, 10,  1, 13, -1, 11,  0,
  3, -2, 10, -1, 13,  1, 14,  0,
  3,  2, 12, -1, 13, -1, 11,  1,
  3,  3, 10,  1, 12, -1, 11,  0,
  3,  1, 10, -1, 12,  1, 11,  0,
  4, -1, 13, -1, 11,  3,  2, -3,  3,  0,
  4, -1, 13, -1, 11,  2,  3, -2,  5,  0,
  3,  2, 10, -1, 13,  1, 14,  0,
  4, -2, 10, -1, 11, 18,  2,-16,  3,  0,
  6,  2, 10, -1, 13,  1, 11,  4,  3, -8,  4,  3,  5,  0,
  3,  2, 10, -1, 13,  1, 11,  0,
  6, -2, 10,  1, 13, -1, 11,  4,  3, -8,  4,  3,  5,  0,
  5,  2, 10, -2, 13,  1, 11, 18,  2,-16,  3,  0,
  4, -2, 10,  1, 13, -2, 11,  1, 14,  0,
  3,  1, 12, -3, 13,  1, 11,  0,
  3,  1, 10,  2, 13, -1, 11,  0,
  4,  2, 10,  1, 12,  1, 13, -1, 11,  1,
  3,  1, 12, -1, 13, -1, 11,  1,
  4, -1, 13, -1, 11,  1,  3, -1,  5,  0,
  2,  1, 10,  1, 11,  0,
  4,  2, 10,  1, 12, -1, 13,  1, 11,  1,
  3,  1, 12,  1, 13, -3, 11,  0,
  4, -1, 13, -1, 11,  1,  2, -1,  3,  0,
  5,  2, 10, -1, 13,  1, 11,  2,  2, -2,  3,  0,
  2,  3, 13, -1, 11,  0,
  4,  1, 10,  1, 12, -2, 13, -1, 11,  0,
  4,  2, 10,  2, 12,  1, 13, -1, 11,  0,
  2,  1, 13,  1, 14,  1,
  5,  2, 10, -1, 13,  1, 11,  2,  3, -3,  5,  0,
  4, -2, 13, -1, 11, 18,  2,-16,  3,  1,
  5,  1, 13,  1, 11,  4,  3, -8,  4,  3,  5,  0,
  2,  1, 13,  1, 11,  0,
  5, -1, 13, -1, 11,  4,  3, -8,  4,  3,  5,  0,
  3,  1, 11, 18,  2,-16,  3,  1,
  3, -1, 13, -2, 11,  1, 14,  0,
  5,  2, 10, -1, 13,  1, 11,  2,  3, -2,  5,  0,
  5,  2, 10, -1, 13,  1, 11,  3,  2, -3,  3,  0,
  3,  1, 10,  1, 12,  1, 11,  1,
  4,  2, 10,  2, 12, -1, 13,  1, 11,  1,
  2,  1, 13, -3, 11,  0,
  4,  1, 13,  1, 11,  1,  2, -1,  3,  0,
  3,  1, 12,  3, 13, -1, 11,  0,
  4,  2, 10,  1, 12, -3, 13, -1, 11,  0,
  3,  1, 10, -2, 13, -1, 11,  0,
  4,  1, 13,  1, 11,  1,  3, -1,  5,  0,
  3,  1, 12,  1, 13,  1, 11,  1,
  2,  1, 10, -3, 11,  0,
  3,  1, 12, -1, 13,  3, 11,  0,
  3,  2, 10, -3, 13, -1, 11,  0,
  3,  2, 12,  1, 13,  1, 11,  0,
  3,  2, 10, -1, 13, -3, 11,  0,
  4,  2, 10, -1, 12, -3, 13, -1, 11,  0,
  4,  2, 10, -1, 12, -1, 13, -3, 11,  0,
  4,  6, 10, -1, 12, -2, 13, -1, 11,  0,
  3,  4, 10, -2, 12, -1, 11,  0,
  3,  6, 10, -2, 13, -1, 11,  0,
  4,  4, 10, -2, 12, -2, 13,  1, 11,  0,
  3,  4, 10, -1, 12, -1, 11,  1,
  3,  2, 10, -3, 12,  1, 11,  0,
  3,  5, 10, -1, 13, -1, 11,  0,
  4,  4, 10, -1, 12, -2, 13,  1, 11,  0,
  4,  2, 10, -2, 12,  2, 13, -1, 11,  0,
  2,  4, 10, -1, 11,  0,
  3,  2, 10, -2, 12,  1, 11,  1,
  4,  3, 10, -1, 12, -1, 13,  1, 11,  0,
  3,  4, 10, -2, 13,  1, 11,  0,
  4,  2, 10, -1, 12,  2, 13, -1, 11,  0,
  4, -2, 10, -1, 11,  2,  2, -2,  3,  0,
  3,  3, 10,  1, 13, -1, 11,  0,
  3,  4, 10,  1, 12, -1, 11,  0,
  3,  2, 10, -1, 12,  1, 11,  2,
  4, -2, 10, -1, 11,  1,  3, -1,  5,  0,
  3,  3, 10, -1, 13,  1, 11,  0,
  4,  4, 10,  1, 12, -2, 13,  1, 11,  0,
  3,  2, 10,  2, 13, -1, 11,  0,
  3,  2, 12, -2, 13, -1, 11,  0,
  4,  1, 10, -1, 12,  1, 13,  1, 11,  0,
  2,  2, 10,  1, 14,  0,
  5, -2, 10, -1, 13, -1, 11, 18,  2,-16,  3,  0,
  2,  2, 10,  1, 11,  1,
  5,  2, 10, -1, 13,  1, 11, 18,  2,-16,  3,  0,
  3, -2, 10, -2, 11,  1, 14,  0,
  4,  3, 10,  1, 12, -1, 13,  1, 11,  0,
  3,  2, 10, -2, 13,  3, 11,  0,
  4,  2, 10,  1, 12,  2, 13, -1, 11,  0,
  3,  1, 12, -2, 13, -1, 11,  1,
  3,  1, 10,  1, 13,  1, 11,  0,
  3,  2, 10,  1, 12,  1, 11,  1,
  2,  4, 13, -1, 11,  0,
  2,  2, 13,  1, 14,  0,
  4, -3, 13, -1, 11, 18,  2,-16,  3,  0,
  2,  2, 13,  1, 11,  0,
  4,  1, 13,  1, 11, 18,  2,-16,  3,  0,
  4,  2, 10,  1, 11,  2,  3, -2,  5,  0,
  4,  1, 10,  1, 12,  1, 13,  1, 11,  0,
  3,  2, 10,  2, 12,  1, 11,  0,
  2,  2, 11,  1, 14,  0,
  1,  3, 11,  0,
  3,  1, 10, -3, 13, -1, 11,  0,
  3,  1, 12,  2, 13,  1, 11,  1,
  2,  1, 12,  3, 11,  0,
  3,  2, 10, -4, 13, -1, 11,  0,
  3,  2, 12,  2, 13,  1, 11,  0,
  3,  2, 10, -2, 13, -3, 11,  0,
  4,  6, 10, -1, 12, -1, 13, -1, 11,  0,
  3,  6, 10, -1, 13, -1, 11,  0,
  4,  4, 10, -2, 12, -1, 13,  1, 11,  0,
  3,  6, 10, -3, 13,  1, 11,  0,
  4,  4, 10, -1, 12,  1, 13, -1, 11,  0,
  4,  4, 10, -1, 12, -1, 13,  1, 11,  1,
  3,  5, 10, -2, 13,  1, 11,  0,
  3,  4, 10,  1, 13, -1, 11,  0,
  4,  2, 10, -2, 12,  1, 13,  1, 11,  0,
  3,  4, 10, -1, 13,  1, 11,  0,
  4,  2, 10, -1, 12,  3, 13, -1, 11,  0,
  4,  4, 10,  1, 12,  1, 13, -1, 11,  0,
  4,  2, 10, -1, 12,  1, 13,  1, 11,  1,
  2,  3, 10,  1, 11,  0,
  4,  4, 10,  1, 12, -1, 13,  1, 11,  0,
  4,  2, 10, -1, 12, -1, 13,  3, 11,  0,
  3,  2, 10,  3, 13, -1, 11,  0,
  3,  2, 10,  1, 13,  1, 14,  0,
  3,  2, 10,  1, 13,  1, 11,  0,
  3,  3, 10,  1, 12,  1, 11,  0,
  3,  2, 10, -1, 13,  3, 11,  0,
  4,  2, 10,  1, 12,  3, 13, -1, 11,  0,
  3,  1, 12, -3, 13, -1, 11,  0,
  3,  1, 10,  2, 13,  1, 11,  0,
  4,  2, 10,  1, 12,  1, 13,  1, 11,  1,
  3,  1, 12, -1, 13, -3, 11,  0,
  2,  1, 10,  3, 11,  0,
  2,  5, 13, -1, 11,  0,
  2,  3, 13,  1, 11,  0,
  4,  1, 10,  1, 12,  2, 13,  1, 11,  0,
  2,  1, 13,  3, 11,  0,
  3,  1, 12,  3, 13,  1, 11,  0,
  3,  1, 12,  1, 13,  3, 11,  0,
  3,  2, 10, -5, 13, -1, 11,  0,
  3,  6, 10, -1, 12, -1, 11,  0,
  4,  6, 10, -1, 12, -2, 13,  1, 11,  0,
  2,  6, 10, -1, 11,  0,
  3,  4, 10, -2, 12,  1, 11,  0,
  3,  6, 10, -2, 13,  1, 11,  0,
  4,  4, 10, -1, 12,  2, 13, -1, 11,  0,
  3,  4, 10, -1, 12,  1, 11,  0,
  3,  4, 10,  2, 13, -1, 11,  0,
  4,  2, 10, -2, 12,  2, 13,  1, 11,  0,
  2,  4, 10,  1, 11,  0,
  3,  4, 10, -2, 13,  3, 11,  0,
  4,  2, 10, -1, 12,  2, 13,  1, 11,  0,
  3,  3, 10,  1, 13,  1, 11,  0,
  3,  4, 10,  1, 12,  1, 11,  0,
  3,  2, 10, -1, 12,  3, 11,  0,
  3,  2, 10,  4, 13, -1, 11,  0,
  3,  2, 10,  2, 13,  1, 11,  0,
  2,  2, 10,  3, 11,  0,
  3,  1, 12, -4, 13, -1, 11,  0,
  3,  1, 10,  3, 13,  1, 11,  0,
  4,  2, 10,  1, 12,  2, 13,  1, 11,  0,
  2,  4, 13,  1, 11,  0,
  2,  2, 13,  3, 11,  0,
  1,  5, 11,  0,
  3,  1, 12,  4, 13,  1, 11,  0,
  4,  6, 10, -1, 12, -1, 13,  1, 11,  0,
  3,  6, 10,  1, 13, -1, 11,  0,
  3,  6, 10, -1, 13,  1, 11,  0,
  4,  4, 10, -1, 12,  1, 13,  1, 11,  0,
  3,  4, 10,  1, 13,  1, 11,  0,
  3,  4, 10, -1, 13,  3, 11,  0,
  4,  2, 10, -1, 12,  3, 13,  1, 11,  0,
  4,  4, 10,  1, 12,  1, 13,  1, 11,  0,
  3,  2, 10,  3, 13,  1, 11,  0,
  3,  2, 10,  1, 13,  3, 11,  0,
  2,  5, 13,  1, 11,  0,
  2,  3, 13,  3, 11,  0,
  2,  6, 10,  1, 11,  0,
  3,  4, 10,  2, 13,  1, 11,  0,
  3,  2, 10,  4, 13,  1, 11,  0,
 -1
};

/*//////////////////////////Mars starts here///////////////////////////////////////*/

static double  tablmr[] = {
       43471.66140,       21291.11063,        2033.37848,  6890507597.78366,
     1279543.73631,

         317.74183,         730.69258,         -15.26502,         277.56960,
         -62.96711,          20.96285,

           1.01857,          -2.19395,

           3.75708,           3.65854,           0.01049,           1.09183,

          -0.00605,          -0.04769,

           0.41839,           0.10091,           0.03887,           0.11666,

          -0.03301,           0.02664,

           0.38777,          -0.56974,

           0.02974,          -0.15041,           0.02179,          -0.00808,

           0.08594,           0.09773,

          -0.00902,          -0.04597,           0.00762,          -0.03858,

          -0.00139,           0.01562,

           0.02019,           0.01878,

          -0.01244,           0.00795,

           0.00815,           0.03501,

          -0.00335,          -0.02970,

          -0.00518,          -0.01763,

           0.17257,           0.14698,          -0.14417,           0.26028,

           0.00062,          -0.00180,

          13.35262,          39.38771,         -15.49558,          22.00150,
          -7.71321,          -4.20035,           0.62074,          -1.42376,

           0.07043,          -0.06670,           0.16960,          -0.06859,
           0.07787,           0.01845,

          -0.01608,          -0.00914,

           5.60438,          -3.44436,           5.88876,           6.77238,
          -5.29704,           3.48944,

           0.01291,           0.01280,

          -0.53532,           0.86584,           0.79604,           0.31635,

          -3.92977,          -0.94829,          -0.74254,          -1.37947,
           0.17871,          -0.12477,

           0.00171,           0.11537,

           0.02281,          -0.03922,

          -0.00165,           0.02965,

           1.59773,           1.24565,          -0.35802,           1.37272,
          -0.44811,          -0.08611,

           3.04184,          -3.39729,           8.86270,           6.65967,
          -9.10580,          10.66103,

           0.02015,          -0.00902,

          -0.01166,          -0.23957,          -0.12128,          -0.04640,

          -0.07114,           0.14053,          -0.04966,          -0.01665,

           0.28411,          -0.37754,          -1.26265,           1.01377,
           3.70433,          -0.21025,

          -0.00972,           0.00350,

           0.00997,           0.00450,

          -2.15305,           3.18147,          -1.81957,          -0.02321,
          -0.02560,          -0.35188,

           0.00003,          -0.01110,

           0.00244,          -0.05083,

          -0.00216,          -0.02026,

           0.05179,           0.04188,

           5.92031,          -1.61316,           3.72001,           6.98783,
          -4.17690,           2.61250,

           0.04157,           2.76453,          -1.34043,           0.74586,
          -0.20258,          -0.30467,

           0.00733,           0.00376,

           1.72800,           0.76593,           1.26577,          -2.02682,
          -1.14637,          -0.91894,

          -0.00002,           0.00036,

           2.54213,           0.89533,          -0.04166,           2.36838,
          -0.97069,           0.05486,

           0.46927,           0.04500,           0.23388,           0.35005,

           1.61402,           2.30209,          -0.99859,           1.63349,
          -0.51490,          -0.26112,

           0.27848,          -0.26100,          -0.07645,          -0.22001,

           0.92901,           1.12627,          -0.39829,           0.77120,
          -0.23716,          -0.11245,

          -0.02387,           0.03960,

          -0.00802,           0.02179,

           2.86448,           1.00246,          -0.14647,           2.80278,
          -1.14143,           0.05177,

           1.68671,          -1.23451,           3.16285,           0.70070,
           0.25817,           3.17416,

           0.07447,          -0.08116,          -0.03029,          -0.02795,

           0.00816,           0.01023,

           0.00685,          -0.01075,

          -0.34268,           0.03680,          -0.05488,          -0.07430,

          -0.00041,          -0.02968,

           3.13228,          -0.83209,           1.95765,           3.78394,
          -2.26196,           1.38520,

          -0.00401,          -0.01397,

           1.01604,          -0.99485,           0.62465,           0.22431,
          -0.05076,           0.12025,

           4.35229,          -5.04483,          14.87533,           9.00826,
         -10.37595,          19.26596,

           0.40352,           0.19895,           0.09463,          -0.10774,

          -0.17809,          -0.08979,          -0.00796,          -0.04313,

           0.01520,          -0.03538,

           1.53301,          -1.75553,           4.87236,           3.23662,
          -3.62305,           6.42351,

          -0.00439,          -0.01305,

           0.17194,          -0.64003,           0.26609,           0.06600,

           0.01767,          -0.00251,

          -0.08871,          -0.15523,           0.01201,          -0.03408,

          -0.29126,          -0.07093,          -0.00998,          -0.07876,

           1.05932,         -25.38650,

          -0.29354,           0.04179,          -0.01726,           0.07473,

          -0.07607,          -0.08859,           0.00842,          -0.02359,

           0.47858,          -0.39809,           1.25061,           0.87017,
          -0.82453,           1.56864,

          -0.00463,           0.02385,

          -0.29070,           8.56535,

          -0.12495,           0.06580,          -0.03395,          -0.02465,

          -1.06759,           0.47004,          -0.40281,          -0.23957,
           0.03572,          -0.07012,

           0.00571,          -0.00731,

           0.18601,          -1.34068,

           0.03798,          -0.00532,           0.00448,          -0.01147,

           1.41208,          -0.00668,           0.25883,           1.23788,
          -0.57774,           0.09166,

          -2.49664,          -0.25235,          -0.53582,          -0.80126,
           0.10827,          -0.08861,

          -0.03577,           0.06825,

          -0.00143,           0.04633,

           0.01586,          -0.01056,

          -0.02106,           0.03804,

          -0.00088,          -0.03458,

          -0.00033,          -0.01079,

           0.05821,          -0.02445,

           0.00602,           0.00721,

          -0.00315,          -0.01021,

          -0.65454,           1.08478,          -0.44593,          -0.21492,

          -1.35004,           4.47299,          -4.19170,           3.51236,

        1946.04629,       13960.88247,         576.24572,        8023.81797,
        2402.48512,        -753.87007,       -6376.99217,      -10278.88014,
      -25743.89874,       15506.87748,       15609.59853,       35173.63133,

          -3.70370,           6.29538,          -4.84183,          -0.76942,

          -0.02465,          -0.03840,

           0.00565,          -0.06071,

           0.01174,           0.00253,

          -0.00230,           0.05252,

          -0.02813,           0.01359,

           0.23208,           0.03393,           0.01734,           0.04838,

          -0.46340,          -0.18941,           0.25428,          -0.56925,

           0.05213,           0.24704,           0.12922,          -0.01531,

           0.06885,          -0.08510,           0.01853,          -0.00390,

           0.01196,          -0.30530,           0.13117,          -0.03533,

           1.79597,          -0.42743,           0.98545,           2.13503,
          -1.32942,           0.68005,

          -0.01226,           0.00571,

           0.31081,           0.34932,           0.34531,          -0.32947,

          -0.00548,           0.00186,          -0.00157,          -0.00065,

           0.30877,          -0.03864,           0.04921,           0.06693,

           0.01761,          -0.04119,

           1.28318,           0.38546,           0.06462,           1.18337,
          -0.48698,           0.07086,

           0.26031,          -0.22813,           0.10272,           0.04737,

          -0.04506,          -0.38581,          -0.16624,          -0.04588,

           0.00992,           0.00722,

          -0.21041,           0.20560,          -0.09267,          -0.03438,

           0.32264,          -0.07383,

           0.09553,          -0.38730,           0.17109,          -0.01342,

          -0.02336,          -0.01286,

           0.00230,           0.04626,

           0.01176,           0.01868,

          -0.15411,          -0.32799,           0.22083,          -0.14077,

           1.98392,           1.68058,

          -0.02526,          -0.13164,          -0.04447,          -0.00153,

           0.01277,           0.00553,

          -0.26035,          -0.11362,           0.14672,          -0.32242,

           0.16686,          -0.69957,           0.40091,          -0.06721,
           0.00837,           0.09635,

          -0.08545,           0.25178,          -0.22486,          16.03256,

           0.34130,          -0.06313,           0.01469,          -0.09012,

          -0.00744,          -0.02510,

          -0.08492,          -0.13733,

          -0.07620,          -0.15329,           0.13716,          -0.03769,

           2.01176,          -1.35991,          -1.04319,          -2.97226,

          -0.01433,           0.61219,

          -0.55522,           0.38579,           0.31831,           0.81843,

          -0.04583,          -0.14585,

          -0.10218,           0.16039,          -0.06552,          -0.01802,

           0.06480,          -0.06641,           0.01672,          -0.00287,

           0.00308,           0.09982,          -0.05679,          -0.00249,

          -0.36034,           0.52385,          -0.29759,           0.59539,

          -3.59641,          -1.02499,

        -547.53774,         734.11470,         441.86760,        -626.68255,
       -2255.81376,       -1309.01028,       -2025.69590,        2774.69901,
        1711.21478,        1509.99797,

          -0.99274,           0.61858,          -0.47634,          -0.33034,

           0.00261,           0.01183,

          -0.00038,           0.11687,

           0.00994,          -0.01122,

           0.03482,          -0.01942,

          -0.11557,           0.38237,          -0.17826,           0.00830,

           0.01193,          -0.05469,

           0.01557,           0.01747,

           0.02730,          -0.01182,

          -0.11284,           0.12939,          -0.05621,          -0.01615,

           0.04258,           0.01058,

          -0.01723,           0.00963,

           0.20666,           0.11742,

           0.07830,          -0.02922,

          -0.10659,          -0.05407,           0.07254,          -0.13005,

          -0.02365,           0.24583,           0.31915,           1.27060,

           0.00009,          -0.21541,

          -0.55324,          -0.45999,          -1.45885,           0.86530,
           0.85932,           1.92999,

          -0.00755,          -0.00715,

          -0.02004,          -0.00788,

           0.01539,           0.00837,

           0.27652,          -0.50297,          -0.26703,          -0.28159,

           0.03950,           0.07182,

          -0.07177,           0.14140,           0.07693,           0.07564,

          -0.01316,          -0.01259,

           0.01529,           0.07773,

         -90.74225,        -378.15784,        -510.30190,         -52.35396,
         -89.15267,         415.56828,         181.52119,          54.01570,

          -0.01093,          -0.05931,

          -0.01344,          -0.02390,

           0.01432,          -0.02470,

          -0.01509,          -0.01346,

           0.03352,           0.02248,

           0.02588,          -0.00948,

           0.03610,           0.17238,

           0.02909,          -0.04065,

           0.00155,          -0.07025,

          -0.09508,           0.14487,           0.12441,           0.16451,

           0.00001,          -0.00005,

          -0.00982,          -0.01895,

          -0.16968,           0.36565,           0.20234,           0.17789,

          -0.04519,          -0.00588,

           0.01268,           0.00107,

         -56.32137,         -58.22145,         -80.55270,          28.14532,
          11.43301,          52.05752,          17.79480,          -2.61997,

          -0.00005,          -0.02629,

           0.01080,          -0.00390,

           0.00744,           0.03132,

           0.01156,          -0.01621,

           0.02162,           0.02552,

           0.00075,          -0.02497,

           0.02495,           0.00830,

           0.03230,           0.00103,

         -14.84965,          -4.50200,          -9.73043,           9.40426,
           4.08054,           5.38571,           1.53731,          -1.01288,

           0.21076,           1.74227,           0.79760,           0.39583,
           0.09879,          -0.16736,

          -0.00723,          -0.01536,

};
static double tabbmr[] = {
        -364.49380,         -47.17612,        -554.97858,        -430.63121,
         596.44312,

          -3.94434,          -7.43169,          -0.06665,          -2.23987,
           0.10366,          -0.05567,

          -0.01463,           0.01908,

          -0.02611,          -0.00350,          -0.01057,          -0.00610,

          -0.00015,           0.00002,

           0.00010,           0.00033,           0.00007,          -0.00000,

          -0.00010,          -0.00004,

           0.00012,           0.00002,

          -0.00014,          -0.00048,          -0.00003,          -0.00007,

           0.00008,          -0.00005,

          -0.00043,          -0.00003,          -0.00010,          -0.00004,

           0.00001,           0.00001,

          -0.00003,          -0.00003,

           0.00004,           0.00007,

          -0.00041,           0.00031,

           0.00076,           0.00062,

           0.00001,          -0.00002,

           0.00035,           0.00053,           0.00026,           0.00019,

           0.00020,           0.00010,

           0.02936,           0.09624,          -0.01153,           0.01386,
           0.00551,          -0.00690,           0.00196,           0.00148,

          -0.00408,          -0.00673,          -0.00067,          -0.00152,
          -0.00014,          -0.00005,

           0.00000,           0.00005,

          -0.00116,           0.00276,          -0.00391,           0.00983,
          -0.01327,          -0.01986,

          -0.00003,           0.00001,

           0.01104,           0.00631,          -0.01364,           0.01152,

          -0.00439,           0.01103,          -0.00546,           0.00181,
          -0.00039,          -0.00083,

           0.00007,           0.00002,

          -0.00010,          -0.00008,

           0.00005,           0.00002,

          -0.00584,           0.00512,          -0.00722,          -0.00174,
           0.00101,          -0.00316,

          -0.02229,          -0.02797,          -0.10718,           0.05741,
           0.11403,           0.10033,

           0.00036,          -0.00022,

           0.00787,           0.01191,           0.01756,          -0.02121,

          -0.00169,          -0.00364,           0.00070,          -0.00051,

           0.01850,          -0.06836,           0.21471,           0.00162,
          -0.29165,           0.16799,

          -0.00002,           0.00011,

          -0.00075,          -0.00077,

          -0.00675,          -0.00814,           0.00029,          -0.00599,
           0.00107,           0.00013,

           0.00010,          -0.00002,

           0.00005,           0.00020,

           0.00355,           0.00306,

          -0.00013,          -0.00061,

          -0.02950,          -0.00847,           0.01037,          -0.04783,
           0.04237,           0.11662,

          -0.00331,           0.00207,          -0.00107,          -0.00264,
           0.00072,          -0.00023,

          -0.00151,           0.00146,

          -0.12847,           0.02294,           0.03611,           0.19705,
           0.16855,          -0.28279,

          -0.00000,          -0.00002,

          -0.00525,          -0.03619,           0.05048,          -0.00481,
          -0.00745,           0.04618,

           0.00286,           0.00443,           0.00521,          -0.00351,

           0.00200,           0.00474,          -0.00149,           0.00031,
          -0.00003,           0.00029,

           0.00686,           0.02467,           0.04275,          -0.02223,

           0.02282,          -0.04228,           0.03312,           0.01847,
          -0.01253,           0.01601,

           0.00076,           0.00091,

           0.00045,           0.00035,

           0.00658,           0.01586,          -0.00310,           0.00628,
          -0.00045,           0.00316,

          -0.01602,          -0.00340,          -0.01744,           0.04907,
           0.06426,           0.02275,

          -0.00217,          -0.00377,          -0.00091,           0.00037,

           0.00040,          -0.00003,

          -0.00017,          -0.00027,

           0.00366,           0.02693,          -0.00934,           0.00386,

           0.00616,          -0.00037,

           0.02028,           0.02120,          -0.01768,           0.02421,
           0.00102,           0.00877,

           0.00012,           0.00030,

          -0.00019,          -0.02165,           0.01245,          -0.00742,
           0.00172,           0.00320,

          -0.17117,          -0.12908,          -0.43134,           0.15617,
           0.21216,           0.56432,

           0.01139,          -0.00937,          -0.00058,          -0.00337,

          -0.00999,           0.01862,          -0.00621,          -0.00080,

          -0.00025,          -0.00140,

           0.09250,           0.01173,          -0.03549,           0.14651,
          -0.01784,           0.00945,

           0.00000,          -0.00006,

          -0.00500,           0.00086,           0.01079,          -0.00002,

          -0.00012,          -0.00029,

          -0.02661,           0.00140,          -0.00524,          -0.00460,

          -0.00352,          -0.00563,          -0.00277,          -0.00052,

          -0.10171,          -0.02001,

           0.00045,           0.00265,          -0.00082,           0.00160,

          -0.00302,          -0.00434,          -0.00022,          -0.00134,

           0.03285,           0.02964,          -0.05612,          -0.00668,
          -0.01821,           0.06590,

           0.00039,           0.00061,

          -0.13531,          -0.03831,

           0.02553,           0.02130,          -0.00336,           0.00468,

          -0.04522,          -0.05540,           0.00129,          -0.01767,
           0.00181,           0.00031,

          -0.00011,          -0.00034,

          -0.00146,           0.01101,

          -0.00030,           0.00240,          -0.00039,           0.00072,

          -0.01954,          -0.03822,           0.09682,          -0.04541,
          -0.01567,           0.09617,

          -0.03371,           0.33028,          -0.12102,           0.05874,
          -0.00990,          -0.02236,

           0.00109,           0.00158,

          -0.00482,           0.00019,

          -0.00036,           0.00004,

           0.00024,           0.00201,

           0.00017,           0.00011,

          -0.00012,           0.00002,

          -0.00323,          -0.01062,

          -0.00130,           0.00091,

           0.00056,          -0.00017,

           0.00774,           0.00601,           0.02550,           0.01700,

          -0.84327,           0.77533,          -0.71414,          -0.50643,

        -473.30877,       -1504.79179,        -458.52274,        -865.82237,
        -417.34994,        -681.03976,         765.50697,       -1653.67165,
        4427.33176,         710.53895,       -5016.39367,        4280.60361,

           0.33957,           0.38390,          -0.38631,           0.81193,

           0.00154,          -0.00043,

           0.01103,          -0.00017,

          -0.00046,           0.00221,

           0.00059,           0.00014,

           0.00160,           0.00475,

           0.06191,          -0.13289,           0.02884,          -0.00566,

          -0.01572,           0.23780,          -0.05140,          -0.03228,

          -0.00716,          -0.00978,          -0.01048,           0.01317,

          -0.01267,          -0.01198,           0.00037,          -0.00330,

          -0.02305,           0.00355,          -0.00121,          -0.00496,

          -0.04369,          -0.01343,           0.05347,          -0.12433,
           0.02090,           0.17683,

           0.00028,          -0.00490,

          -0.02778,          -0.05587,          -0.01658,           0.05655,

           0.00204,          -0.00092,           0.00020,           0.00014,

          -0.00603,          -0.03829,           0.00778,          -0.00588,

          -0.00266,           0.00097,

          -0.02158,          -0.07742,           0.09306,          -0.01827,
          -0.01048,           0.07885,

          -0.02485,          -0.02505,           0.00471,          -0.01026,

           0.06663,           0.01110,           0.00469,          -0.05347,

          -0.00016,          -0.00013,

           0.02622,           0.02273,          -0.01009,           0.01391,

          -0.01042,          -0.00444,

          -0.04293,          -0.00767,          -0.00154,          -0.01739,

           0.00353,          -0.00763,

          -0.00060,           0.00010,

          -0.00053,          -0.00146,

          -0.05317,           0.05760,          -0.01801,          -0.02099,

          -0.02611,          -0.01836,

          -0.00256,           0.00812,          -0.00145,           0.00054,

          -0.00008,           0.00015,

          -0.04087,           0.08860,          -0.05385,          -0.02134,

           0.02771,           0.02441,          -0.00234,           0.01571,
          -0.00260,           0.00097,

           0.10151,           0.49378,          -0.28555,           0.11428,

          -0.00286,           0.01224,           0.00160,           0.00069,

           0.00000,          -0.00040,

          -0.13286,           0.00448,

           0.01225,          -0.00568,           0.00341,           0.00224,

          -0.23483,          -0.07859,           0.30733,          -0.21548,

          -0.02608,           0.00756,

           0.09789,           0.02878,          -0.11968,           0.08981,

           0.02046,          -0.00888,

           0.02955,           0.01486,          -0.00981,           0.01542,

          -0.01674,          -0.01540,           0.00019,          -0.00449,

          -0.02140,           0.00638,           0.00112,          -0.00730,

          -0.08571,           0.13811,          -0.16951,          -0.02917,

          -0.03931,          -0.32643,

         -68.64541,         -81.00521,         -47.97737,          15.75290,
         181.76392,         -36.00647,         -48.32098,        -259.02226,
        -265.57466,         554.05904,

           0.09017,           0.18803,          -0.12459,           0.10852,

           0.00211,           0.00002,

           0.00304,          -0.00370,

           0.00174,           0.00279,

           0.00139,           0.00095,

           0.04881,           0.00262,          -0.01020,           0.03762,

           0.00987,           0.00612,

           0.00054,          -0.00036,

           0.00009,          -0.00094,

           0.02279,           0.01785,          -0.00778,           0.01263,

           0.00040,          -0.00112,

          -0.00452,          -0.00662,

           0.00483,          -0.00030,

          -0.00054,          -0.00205,

          -0.00052,          -0.00362,          -0.00215,          -0.00247,

           0.02893,          -0.01965,          -0.00004,           0.04114,

          -0.00284,          -0.00103,

           0.01827,          -0.07822,           0.18010,           0.04805,
          -0.21702,           0.18808,

           0.00095,          -0.00132,

          -0.01488,           0.00746,

           0.00198,           0.00190,

           0.01032,           0.03392,           0.04318,          -0.07332,

          -0.01004,           0.00787,

          -0.00308,          -0.01177,          -0.01431,           0.02659,

           0.00273,          -0.00374,

          -0.02545,           0.00644,

          28.68376,          13.74978,          29.60401,         -47.98255,
         -65.91944,         -18.48404,          -1.73580,          64.67487,

          -0.02492,           0.00104,

          -0.00829,          -0.00134,

           0.00077,           0.00005,

          -0.00513,           0.00403,

           0.00071,          -0.00047,

          -0.00023,          -0.00063,

           0.00120,           0.00370,

          -0.00038,          -0.00037,

           0.00080,          -0.00018,

           0.00866,           0.00156,          -0.01064,           0.02131,

           0.00000,          -0.00001,

           0.00038,          -0.00068,

          -0.00909,          -0.02187,          -0.02599,           0.05507,

          -0.00022,          -0.01468,

           0.00032,           0.00500,

           9.86233,          -2.85314,          -2.25791,         -13.83444,
         -12.38794,           3.79861,           2.76343,           6.63505,

           0.00066,           0.00007,

          -0.00016,          -0.00039,

           0.00014,           0.00059,

          -0.00031,          -0.00024,

          -0.00168,           0.00259,

           0.00007,          -0.00005,

          -0.00052,           0.00558,

           0.00110,           0.01037,

           1.59224,          -2.37284,          -2.00023,          -2.28280,
          -1.49571,           1.48293,           0.60041,           0.56376,

          -0.54386,           0.03568,          -0.10392,           0.31005,
           0.09104,           0.03015,

           0.00826,          -0.00524,

};
/*mars*/
static double  tabrmr[] = {
        -816.07287,        -381.41365,         -33.69436,         177.22955,
           0.18630,

          -8.29605,         -11.15519,          -0.57407,          -3.53642,
           0.16663,          -0.06334,

          -0.03056,           0.02767,

          -0.04161,           0.03917,          -0.02425,           0.00204,

          -0.00034,           0.00023,

           0.00058,          -0.00111,           0.00039,          -0.00015,

           0.00006,          -0.00023,

           0.00237,           0.00191,

           0.00154,          -0.00029,           0.00009,           0.00011,

          -0.00041,           0.00037,

          -0.00010,          -0.00064,           0.00015,          -0.00005,

           0.00012,          -0.00003,

          -0.00034,           0.00026,

           0.00011,          -0.00007,

          -0.00158,           0.00087,

           0.00278,           0.00137,

           0.00024,          -0.00020,

           0.00530,          -0.00448,           0.00780,           0.00408,

           0.00062,           0.00035,

          -1.35261,           0.79891,          -0.81597,          -0.43774,
           0.14713,          -0.27415,           0.05298,           0.02230,

          -0.02089,          -0.01070,          -0.00374,           0.00342,
          -0.00142,           0.00270,

          -0.00039,           0.00063,

           0.16024,           0.27088,          -0.32127,           0.27467,
          -0.16615,          -0.24460,

          -0.00073,           0.00032,

          -0.05710,          -0.05265,          -0.06025,           0.05120,

          -0.05295,           0.23477,          -0.08211,           0.04575,
          -0.00769,          -0.01067,

          -0.00570,           0.00015,

          -0.00251,          -0.00140,

          -0.00131,          -0.00018,

          -0.12246,           0.15836,          -0.13065,          -0.03222,
           0.00795,          -0.04232,

          -0.36585,          -0.31154,           0.68504,          -0.96006,
           1.19304,           0.88631,

           0.00132,           0.00046,

           0.13105,           0.04252,           0.05164,          -0.06837,

          -0.01351,          -0.01458,           0.00376,          -0.00557,

           0.28532,          -0.17290,          -0.53946,          -0.79365,
          -0.95246,           0.74984,

           0.00019,           0.00132,

          -0.00163,          -0.00295,

          -0.40106,          -0.26573,          -0.00155,          -0.22655,
           0.04349,          -0.00376,

           0.00149,          -0.00001,

           0.00523,           0.00078,

           0.01203,           0.00558,

          -0.00708,           0.00520,

          -0.36428,          -1.28827,           1.50845,          -0.83063,
           0.58802,           0.89998,

          -0.55256,           0.01255,          -0.15169,          -0.26715,
           0.06061,          -0.04122,

          -0.00397,           0.00534,

          -0.52576,           1.22031,           1.44098,           0.92406,
           0.67214,          -0.85486,

          -0.00010,           0.00001,

           0.28820,          -0.84198,           0.78291,           0.00251,
           0.02398,           0.32093,

          -0.02331,           0.10109,          -0.07555,           0.03557,

          -0.61580,           0.43399,          -0.43779,          -0.26390,
           0.06885,          -0.13803,

           0.17694,           0.19245,           0.15119,          -0.05100,

           0.49469,          -0.45028,           0.33590,           0.15677,
          -0.04702,           0.10265,

          -0.00942,          -0.00580,

          -0.00555,          -0.00252,

          -0.32933,           0.92539,          -0.91004,          -0.04490,
          -0.01812,          -0.37121,

           0.34695,           0.50855,          -0.24721,           0.86063,
          -0.84747,           0.01983,

           0.01948,           0.02039,           0.00748,          -0.00727,

          -0.00271,           0.00220,

           0.00309,           0.00196,

           0.02030,           0.17201,          -0.03716,           0.02801,

           0.01871,           0.00002,

           0.31736,           1.17319,          -1.42245,           0.73416,
          -0.52302,          -0.85056,

           0.00522,          -0.00126,

           0.33571,           0.34594,          -0.07709,           0.21114,
          -0.04066,          -0.01742,

           1.72228,           1.46934,          -3.06437,           5.06723,
          -6.53800,          -3.55839,

          -0.06933,           0.13815,           0.03684,           0.03284,

          -0.04841,           0.09571,          -0.02350,           0.00418,

           0.01302,           0.00579,

           0.73408,           0.64718,          -1.37437,           2.04816,
          -2.70756,          -1.52808,

           0.00523,          -0.00166,

           0.25915,           0.06900,          -0.02758,           0.10707,

           0.00062,           0.00744,

          -0.08117,           0.04840,          -0.01806,          -0.00637,

           0.03034,          -0.12414,           0.03419,          -0.00388,

          10.92603,           0.48169,

          -0.01753,          -0.12853,          -0.03207,          -0.00801,

           0.03904,          -0.03326,           0.01033,           0.00366,

           0.17249,           0.20846,          -0.38157,           0.54639,
          -0.68518,          -0.36121,

          -0.01043,          -0.00186,

          -3.33843,          -0.16353,

           0.03462,           0.06669,          -0.01305,           0.01803,

          -0.22703,          -0.52219,           0.11709,          -0.19628,
           0.03410,           0.01741,

           0.00338,           0.00265,

           0.63213,           0.08944,

           0.00236,           0.01829,           0.00546,           0.00218,

           0.00073,          -0.72570,           0.63698,          -0.13340,
           0.04698,           0.29716,

          -0.13126,           1.27705,          -0.40980,           0.27400,
          -0.04525,          -0.05529,

          -0.03249,          -0.01696,

          -0.02314,          -0.00076,

           0.00510,           0.00764,

          -0.01847,          -0.01021,

           0.01688,          -0.00044,

           0.00531,          -0.00016,

          -0.01219,          -0.02903,

          -0.00361,           0.00299,

           0.00504,          -0.00153,

          -0.53625,          -0.32460,           0.10642,          -0.22070,

          -2.21651,          -0.66036,          -1.74652,          -2.08198,

       -6810.78679,         967.02869,       -3915.97140,         291.65905,
         372.99563,        1196.01966,        5108.01033,       -3172.64698,
       -7685.78246,      -12789.43898,      -17474.50562,        7757.84703,

           3.13224,           1.84743,          -0.38257,           2.40590,

           0.01860,          -0.01217,

           0.03004,           0.00278,

          -0.00125,           0.00579,

          -0.02673,          -0.00112,

           0.00662,           0.01374,

          -0.02729,           0.13109,          -0.02836,           0.00877,

           0.12171,          -0.27475,           0.34765,           0.15882,

          -0.12548,           0.02603,           0.00710,           0.06538,

          -0.04039,          -0.03257,          -0.00186,          -0.00880,

           0.16643,           0.00707,           0.01918,           0.07156,

          -0.20459,          -0.85107,           1.01832,          -0.47158,
           0.32582,           0.63002,

          -0.00282,          -0.00711,

          -0.19695,           0.15053,           0.15676,           0.17847,

           0.00071,           0.00286,          -0.00039,           0.00083,

           0.02009,           0.17859,          -0.03894,           0.02805,

           0.02379,           0.00752,

           0.17529,          -0.57783,           0.53257,          -0.02829,
           0.03211,           0.21777,

           0.13813,           0.16305,          -0.02996,           0.06303,

           0.21058,          -0.02659,           0.02596,          -0.08808,

          -0.00389,           0.00586,

           0.08986,           0.09204,          -0.01480,           0.04031,

           0.06115,           0.18366,

           0.25636,           0.06905,           0.00719,           0.11391,

           0.00636,          -0.01113,

          -0.02808,           0.00150,

          -0.01219,           0.00832,

           0.28626,          -0.09573,           0.10481,           0.16559,

          -0.94578,           1.26394,

           0.08846,          -0.01623,           0.00082,          -0.02640,

          -0.00347,           0.00798,

           0.12873,          -0.21248,           0.27999,           0.14348,

           0.44082,           0.10453,           0.04362,           0.25332,
          -0.06077,           0.00555,

          -0.06947,          -0.05511,         -10.08703,          -0.10614,

           0.04059,           0.21355,           0.05632,           0.00871,

           0.01599,          -0.00531,

           0.36835,          -0.03530,

           0.09519,          -0.04961,           0.02568,           0.08613,

           0.57033,           0.84599,           1.27123,          -0.41266,

          -0.36937,          -0.00655,

          -0.16547,          -0.24000,          -0.35213,           0.13345,

           0.05870,          -0.01524,

           0.06419,           0.04136,          -0.00681,           0.02606,

          -0.02519,          -0.02732,          -0.00105,          -0.00677,

          -0.03891,           0.00106,           0.00087,          -0.02256,

          -0.20834,          -0.14624,          -0.23178,          -0.11786,

           0.32479,          -1.41222,

        -303.74549,        -202.79324,         260.20290,         184.84320,
         536.68016,        -881.56427,       -1125.64824,        -791.09928,
        -596.61162,         659.35664,

           0.24561,           0.39519,          -0.12601,           0.18709,

          -0.00700,           0.00136,

           0.30750,           0.00009,

           0.00443,           0.00384,

           0.01170,           0.02078,

           0.15043,           0.04802,           0.00386,           0.06942,

           0.02107,           0.00495,

          -0.01067,           0.00951,

           0.00937,           0.01996,

           0.04922,           0.04337,          -0.00583,           0.02110,

          -0.00691,           0.02793,

          -0.00364,          -0.00682,

          -0.09143,           0.15369,

           0.02043,           0.05451,

           0.04053,          -0.08179,           0.09645,           0.05330,

          -0.10149,          -0.01594,          -0.96773,           0.13660,

           0.17326,           0.00013,

           0.20990,          -0.23184,          -0.38407,          -0.64733,
          -0.84754,           0.38889,

           0.00310,          -0.00340,

           0.00970,          -0.00788,

          -0.01111,           0.00677,

           0.18147,           0.09968,           0.10170,          -0.09233,

          -0.03165,           0.01790,

          -0.04727,          -0.02364,          -0.02546,           0.02451,

           0.00442,          -0.00426,

          -0.02540,           0.00471,

         130.42585,         -31.30051,          17.99957,        -174.75585,
        -142.96798,         -27.89752,         -19.42122,          59.14872,

          -0.01899,           0.00388,

          -0.01265,           0.00694,

           0.01966,           0.01140,

          -0.00439,           0.00503,

          -0.01867,           0.02826,

           0.00752,           0.02012,

          -0.14734,           0.01909,

           0.03312,           0.02327,

           0.05843,           0.00061,

          -0.06958,          -0.05798,          -0.09174,           0.06242,

           0.00003,           0.00001,

           0.00670,          -0.00305,

          -0.13637,          -0.06058,          -0.06372,           0.07257,

           0.00209,          -0.01369,

          -0.00044,           0.00355,

          17.90079,         -17.48270,          -8.77915,         -24.54483,
         -15.67123,           3.62668,           0.52038,           5.13220,

           0.02574,           0.00003,

           0.00339,           0.00919,

          -0.02778,           0.00464,

           0.01429,           0.01003,

          -0.01661,           0.01327,

           0.02216,           0.00034,

          -0.00389,           0.01076,

          -0.00035,           0.00983,

           1.23731,          -4.18017,          -2.61932,          -2.66346,
          -1.45540,           1.10310,           0.23322,           0.40775,

          -0.43623,           0.06212,          -0.09900,           0.19456,
           0.03639,           0.02566,

           0.00309,          -0.00116,

};
/* Mars*/
static char  argsmr[] = {
  0,  4,
  3,  4,  3, -8,  4,  3,  5,  2,
  3,  5,  2, -6,  3, -4,  4,  0,
  2,  2,  5, -5,  6,  1,
  3, 12,  3,-24,  4,  9,  5,  0,
  3,  2,  2,  1,  3, -8,  4,  1,
  3, 11,  3,-21,  4,  2,  5,  0,
  3,  3,  2, -7,  3,  4,  4,  0,
  3,  7,  3,-13,  4, -1,  5,  1,
  3,  1,  3, -2,  4,  2,  6,  0,
  3,  1,  2, -8,  3, 12,  4,  1,
  3,  1,  4, -8,  5,  4,  6,  0,
  3,  1,  4, -7,  5,  2,  6,  0,
  3,  1,  4, -9,  5,  7,  6,  0,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  0,
  3,  1,  3, -2,  4,  1,  5,  0,
  3,  3,  3, -6,  4,  2,  5,  1,
  3, 12,  3,-23,  4,  3,  5,  0,
  2,  8,  3,-15,  4,  3,
  2,  1,  4, -6,  5,  2,
  3,  2,  2, -7,  3,  7,  4,  0,
  2,  1,  2, -3,  4,  2,
  2,  2,  5, -4,  6,  0,
  1,  1,  6,  1,
  2,  9,  3,-17,  4,  2,
  3,  2,  3, -4,  4,  2,  5,  0,
  3,  2,  3, -4,  4,  1,  5,  0,
  2,  1,  5, -1,  6,  0,
  2,  2,  2, -6,  4,  2,
  2,  1,  3, -2,  4,  2,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  1,
  2,  3,  5, -5,  6,  1,
  1,  1,  5,  2,
  3,  4,  3, -8,  4,  2,  5,  0,
  2,  1,  5, -5,  6,  0,
  2,  7,  3,-13,  4,  2,
  2,  3,  2, -9,  4,  0,
  2,  2,  5, -2,  6,  0,
  1,  3,  6,  0,
  2,  1,  4, -5,  5,  0,
  2,  2,  3, -4,  4,  2,
  2,  6,  3,-11,  4,  2,
  2,  4,  5, -5,  6,  0,
  1,  2,  5,  2,
  3,  1,  4, -3,  5, -3,  6,  0,
  2,  3,  3, -6,  4,  2,
  2,  1,  4, -4,  5,  1,
  2,  5,  3, -9,  4,  2,
  1,  3,  5,  1,
  2,  4,  3, -8,  4,  2,
  3,  1,  4, -4,  5,  2,  6,  0,
  3,  1,  4, -1,  5, -5,  6,  0,
  2,  4,  3, -7,  4,  2,
  2,  1,  4, -3,  5,  2,
  3,  1,  4, -5,  5,  5,  6,  1,
  3,  1,  4, -4,  5,  3,  6,  0,
  3,  1,  4, -3,  5,  1,  6,  0,
  2,  5,  3,-10,  4,  1,
  1,  4,  5,  0,
  2,  3,  3, -5,  4,  2,
  3,  1,  4, -3,  5,  2,  6,  0,
  2,  1,  4, -5,  6,  2,
  2,  1,  4, -2,  5,  2,
  3,  1,  4, -4,  5,  5,  6,  1,
  2,  6,  3,-12,  4,  1,
  2,  1,  4, -4,  6,  0,
  2,  2,  3, -3,  4,  2,
  2, 10,  3,-18,  4,  0,
  2,  1,  4, -3,  6,  1,
  3,  1,  4, -2,  5,  2,  6,  0,
  2,  7,  3,-14,  4,  1,
  3,  1,  4,  1,  5, -5,  6,  1,
  2,  1,  4, -1,  5,  0,
  3,  1,  4, -3,  5,  5,  6,  1,
  3,  1,  4,  2,  5, -7,  6,  1,
  2,  1,  4, -2,  6,  2,
  3,  1,  4, -2,  5,  3,  6,  0,
  2,  1,  3, -1,  4,  0,
  2,  2,  2, -7,  4,  1,
  2,  9,  3,-16,  4,  2,
  2,  1,  4, -3,  7,  0,
  2,  1,  4, -1,  6,  0,
  3,  1,  4, -2,  5,  4,  6,  1,
  2,  1,  2, -4,  4,  2,
  2,  8,  3,-16,  4,  2,
  2,  1,  4, -2,  7,  0,
  3,  3,  3, -5,  4,  2,  5,  0,
  3,  1,  4,  1,  5, -3,  6,  0,
  2,  1,  4, -2,  8,  0,
  2,  1,  4, -1,  7,  0,
  2,  1,  4, -1,  8,  0,
  3,  3,  2, -7,  3,  3,  4,  0,
  3,  2,  2,  1,  3, -7,  4,  0,
  3,  1,  4,  1,  6, -3,  7,  0,
  3,  1,  4,  2,  5, -5,  6,  1,
  3,  4,  3, -7,  4,  3,  5,  1,
  1,  1,  4,  5,
  3,  4,  3, -9,  4,  3,  5,  1,
  3,  1,  4, -2,  5,  5,  6,  0,
  3,  3,  2, -7,  3,  5,  4,  0,
  3,  1,  3, -1,  4,  2,  6,  0,
  3,  1,  4,  1,  5, -2,  6,  0,
  3,  3,  3, -7,  4,  2,  5,  0,
  2,  8,  3,-14,  4,  1,
  2,  1,  2, -2,  4,  1,
  2,  1,  4,  1,  6,  1,
  2,  9,  3,-18,  4,  1,
  2,  2,  2, -5,  4,  1,
  2,  1,  3, -3,  4,  2,
  2,  1,  4,  2,  6,  0,
  2,  1,  4,  1,  5,  1,
  3,  4,  3, -9,  4,  2,  5,  1,
  2,  7,  3,-12,  4,  1,
  2,  2,  4, -5,  5,  0,
  2,  2,  3, -5,  4,  2,
  2,  6,  3,-10,  4,  1,
  2,  1,  4,  2,  5,  1,
  3,  2,  4, -5,  5,  2,  6,  0,
  2,  3,  3, -7,  4,  1,
  2,  2,  4, -4,  5,  0,
  2,  5,  3, -8,  4,  1,
  2,  1,  4,  3,  5,  0,
  3,  2,  4, -4,  5,  2,  6,  0,
  3,  2,  4, -1,  5, -5,  6,  0,
  2,  4,  3, -6,  4,  1,
  2,  2,  4, -3,  5,  0,
  3,  2,  4, -5,  5,  5,  6,  1,
  3,  2,  4, -4,  5,  3,  6,  0,
  2,  3,  3, -4,  4,  1,
  2,  2,  4, -5,  6,  2,
  2,  2,  4, -2,  5,  1,
  3,  2,  4, -4,  5,  5,  6,  1,
  2,  2,  4, -4,  6,  0,
  2,  2,  3, -2,  4,  0,
  2,  2,  4, -3,  6,  1,
  2,  2,  4, -1,  5,  1,
  2,  2,  4, -2,  6,  0,
  1,  1,  3,  1,
  2,  2,  4, -1,  6,  0,
  2,  1,  2, -5,  4,  1,
  2,  8,  3,-17,  4,  1,
  3,  2,  4,  2,  5, -5,  6,  1,
  3,  4,  3, -6,  4,  3,  5,  1,
  3, 10,  3,-17,  4,  3,  6,  0,
  1,  2,  4,  4,
  3,  4,  3,-10,  4,  3,  5,  1,
  2,  8,  3,-13,  4,  0,
  2,  1,  2, -1,  4,  0,
  2,  2,  4,  1,  6,  0,
  2,  2,  2, -4,  4,  0,
  2,  1,  3, -4,  4,  1,
  2,  2,  4,  1,  5,  0,
  2,  7,  3,-11,  4,  0,
  2,  3,  4, -5,  5,  0,
  2,  2,  3, -6,  4,  1,
  2,  6,  3, -9,  4,  0,
  2,  2,  4,  2,  5,  0,
  2,  3,  4, -4,  5,  0,
  2,  5,  3, -7,  4,  0,
  2,  4,  3, -5,  4,  1,
  2,  3,  4, -3,  5,  1,
  2,  3,  3, -3,  4,  0,
  2,  3,  4, -2,  5,  2,
  3,  3,  4, -4,  5,  5,  6,  0,
  2,  2,  3, -1,  4,  0,
  2,  3,  4, -3,  6,  0,
  2,  3,  4, -1,  5,  1,
  2,  3,  4, -2,  6,  0,
  2,  1,  3,  1,  4,  1,
  2,  3,  4, -1,  6,  0,
  3,  4,  3, -5,  4,  3,  5,  0,
  1,  3,  4,  3,
  3,  4,  3,-11,  4,  3,  5,  0,
  1,  1,  2,  0,
  2,  2,  2, -3,  4,  0,
  2,  1,  3, -5,  4,  0,
  2,  4,  4, -5,  5,  0,
  2,  6,  3, -8,  4,  0,
  2,  4,  4, -4,  5,  0,
  2,  5,  3, -6,  4,  0,
  2,  4,  3, -4,  4,  0,
  2,  4,  4, -3,  5,  1,
  3,  6,  3, -8,  4,  2,  5,  0,
  2,  3,  3, -2,  4,  0,
  2,  4,  4, -2,  5,  1,
  2,  4,  4, -1,  5,  0,
  2,  1,  3,  2,  4,  0,
  1,  4,  4,  3,
  2,  2,  2, -2,  4,  0,
  2,  7,  3, -9,  4,  0,
  2,  5,  4, -5,  5,  0,
  2,  6,  3, -7,  4,  0,
  2,  5,  4, -4,  5,  0,
  2,  5,  3, -5,  4,  0,
  2,  5,  4, -3,  5,  0,
  2,  5,  4, -2,  5,  0,
  1,  5,  4,  3,
  1,  6,  4,  2,
  1,  7,  4,  0,
 -1
};

/*//////////////////////////////////Venus Starts here////////////////////////////*/

static double tablv[] = {
           9.08078,          55.42416, 21066413644.98911,      655127.20186,

           0.00329,           0.10408,

           0.00268,          -0.01908,

           0.00653,           0.00183,

           0.15083,          -0.21997,

           6.08596,           2.34841,           3.70668,          -0.22740,
          -2.29376,          -1.46741,

          -0.03840,           0.01242,

           0.00176,           0.00913,

           0.00121,          -0.01222,

          -1.22624,           0.65264,          -1.15974,          -1.28172,
           1.00656,          -0.66266,

           0.01560,          -0.00654,           0.00896,           0.00069,

           0.21649,          -0.01786,

           0.01239,           0.00255,

           0.00084,          -0.06086,

          -0.00041,           0.00887,

           0.13453,          -0.20013,           0.08234,           0.01575,

           0.00658,          -0.00214,

           0.00254,           0.00857,

          -0.01047,          -0.00519,

           0.63215,          -0.40914,           0.34271,          -1.53258,

           0.00038,          -0.01437,

          -0.02599,          -2.27805,          -0.36873,          -1.01799,
          -0.36798,           1.41356,

          -0.08167,           0.01368,           0.20676,           0.06807,

           0.02282,          -0.04691,

           0.30308,          -0.20218,           0.24785,           0.27522,

           0.00197,          -0.00499,

           1.43909,          -0.46154,           0.93459,           2.99583,
          -3.43274,           0.05672,

          -0.06586,           0.12467,           0.02505,          -0.08433,

           0.00743,           0.00174,

          -0.04013,           0.17715,

          -0.00603,          -0.01024,

           0.01542,          -0.02378,

           0.00676,           0.00002,

          -0.00168,          -4.89487,

           0.02393,          -0.03064,

           0.00090,           0.00977,

           0.01223,           0.00381,

           0.28135,          -0.09158,           0.18550,           0.58372,
          -0.67437,           0.01409,

          -0.25404,          -0.06863,

           0.06763,          -0.02939,

          -0.00009,          -0.04888,

           0.01718,          -0.00978,

          -0.01945,           0.08847,

          -0.00135,         -11.29920,

           0.01689,          -0.04756,

           0.02075,          -0.01667,

           0.01397,           0.00443,

          -0.28437,           0.07600,           0.17996,          -0.44326,

           0.29356,           1.41869,          -1.58617,           0.03206,

           0.00229,          -0.00753,

          -0.03076,          -2.96766,

           0.00245,           0.00697,

           0.01063,          -0.02468,

          -0.00351,          -0.18179,

          -0.01088,           0.00380,

           0.00496,           0.02072,

          -0.12890,           0.16719,          -0.06820,          -0.03234,

         -60.36135,         -11.74485,         -11.03752,          -3.80145,
         -21.33955,        -284.54495,        -763.43839,         248.50823,
        1493.02775,        1288.79621,       -2091.10921,       -1851.15420,

          -0.00922,           0.06233,

           0.00004,           0.00785,

           0.10363,          -0.16770,           0.45497,           0.24051,
          -0.28057,           0.61126,

          -0.02057,           0.00010,

           0.00561,           0.01994,

           0.01416,          -0.00442,

           0.03073,          -0.14961,

          -0.06272,           0.08301,

           0.02040,           7.12824,

          -0.00453,          -0.01815,

           0.00004,          -0.00013,

          -0.03593,          -0.18147,           0.20353,          -0.00683,

           0.00003,           0.06226,

          -0.00443,           0.00257,

           0.03194,           0.03254,

           0.00282,          -0.01401,

           0.00422,           1.03169,

          -0.00169,          -0.00591,

          -0.00307,           0.00540,

           0.05511,           0.00347,

           0.07896,           0.06583,

           0.00783,           0.01926,

           0.03109,           0.15967,

           0.00343,           0.88734,

           0.01047,           0.32054,

           0.00814,           0.00051,

           0.02474,           0.00047,

           0.00052,           0.03763,

         -57.06618,          20.34614,         -45.06541,        -115.20465,
         136.46887,         -84.67046,          92.93308,         160.44644,

          -0.00020,          -0.00082,

           0.02496,           0.00279,

           0.00849,           0.00195,

          -0.05013,          -0.04331,

          -0.00136,           0.14491,

          -0.00183,          -0.00406,

           0.01163,           0.00093,

          -0.00604,          -0.00680,

          -0.00036,           0.06861,

          -0.00450,          -0.00969,

           0.00171,           0.00979,

          -0.00152,           0.03929,

           0.00631,           0.00048,

          -0.00709,          -0.00864,

           1.51002,          -0.24657,           1.27338,           2.64699,
          -2.40990,          -0.57413,

          -0.00023,           0.03528,

           0.00268,           0.00522,

          -0.00010,           0.01933,

          -0.00006,           0.01100,

           0.06313,          -0.09939,           0.08571,           0.03206,

          -0.00004,           0.00645,

};
static double  tabbv[] = {
         -23.91858,          31.44154,          25.93273,         -67.68643,

          -0.00171,           0.00123,

           0.00001,          -0.00018,

          -0.00005,           0.00018,

          -0.00001,           0.00019,

           0.00733,           0.00030,          -0.00038,           0.00011,
           0.00181,           0.00120,

           0.00010,           0.00002,

          -0.00012,           0.00002,

           0.00021,           0.00004,

          -0.00403,           0.00101,           0.00342,          -0.00328,
           0.01564,           0.01212,

           0.00011,           0.00010,          -0.00002,          -0.00004,

          -0.00524,           0.00079,

           0.00011,           0.00002,

          -0.00001,           0.00003,

           0.00001,           0.00000,

           0.00108,           0.00035,           0.00003,           0.00064,

          -0.00000,          -0.00002,

          -0.00069,           0.00031,

           0.00020,           0.00003,

           0.00768,           0.03697,          -0.07906,           0.01673,

          -0.00003,          -0.00001,

          -0.00198,          -0.01045,           0.01761,          -0.00803,
          -0.00751,           0.04199,

           0.00280,          -0.00213,          -0.00482,          -0.00209,

          -0.01077,           0.00715,

           0.00048,          -0.00004,           0.00199,           0.00237,

           0.00017,          -0.00032,

          -0.07513,          -0.00658,          -0.04213,           0.16065,
           0.27661,           0.06515,

           0.02156,          -0.08144,          -0.23994,          -0.05674,

           0.00167,           0.00069,

           0.00244,          -0.01247,

          -0.00100,           0.00036,

           0.00240,           0.00012,

           0.00010,           0.00018,

           0.00208,          -0.00098,

          -0.00217,           0.00707,

          -0.00338,           0.01260,

          -0.00127,          -0.00039,

          -0.03516,          -0.00544,          -0.01746,           0.08258,
           0.10633,           0.02523,

           0.00077,          -0.00214,

          -0.02335,           0.00976,

          -0.00019,           0.00003,

           0.00041,           0.00039,

           0.00199,          -0.01098,

           0.00813,          -0.00853,

           0.02230,           0.00349,

          -0.02250,           0.08119,

          -0.00214,          -0.00052,

          -0.00220,           0.15216,           0.17152,           0.08051,

          -0.01561,           0.27727,           0.25837,           0.07021,

          -0.00005,          -0.00000,

          -0.02692,          -0.00047,

          -0.00007,          -0.00016,

           0.01072,           0.01418,

          -0.00076,           0.00379,

          -0.00807,           0.03463,

          -0.05199,           0.06680,

          -0.00622,           0.00787,           0.00672,           0.00453,

         -10.69951,         -67.43445,        -183.55956,         -37.87932,
        -102.30497,        -780.40465,        2572.21990,        -446.97798,
        1665.42632,        5698.61327,      -11889.66501,        2814.93799,

           0.03204,          -0.09479,

           0.00014,          -0.00001,

          -0.04118,          -0.04562,           0.03435,          -0.05878,
           0.01700,           0.02566,

          -0.00121,           0.00170,

           0.02390,           0.00403,

           0.04629,           0.01896,

          -0.00521,           0.03215,

          -0.01051,           0.00696,

          -0.01332,          -0.08937,

          -0.00469,          -0.00751,

           0.00016,          -0.00035,

           0.00492,          -0.03930,          -0.04742,          -0.01013,

           0.00065,           0.00021,

          -0.00006,           0.00017,

           0.06768,          -0.01558,

          -0.00055,           0.00322,

          -0.00287,          -0.01656,

           0.00061,          -0.00041,

           0.00030,           0.00047,

          -0.01436,          -0.00148,

           0.30302,          -0.05511,

          -0.00020,          -0.00005,

           0.00042,          -0.00025,

           0.01270,           0.00458,

          -0.00593,          -0.04480,

           0.00005,          -0.00008,

           0.08457,          -0.01569,

           0.00062,           0.00018,

           9.79942,          -2.48836,           4.17423,           6.72044,
         -63.33456,          34.63597,          39.11878,         -72.89581,

          -0.00066,           0.00036,

          -0.00045,          -0.00062,

          -0.00287,          -0.00118,

          -0.21879,           0.03947,

           0.00086,           0.00671,

          -0.00113,           0.00122,

          -0.00193,          -0.00029,

          -0.03612,           0.00635,

           0.00024,           0.00207,

          -0.00273,           0.00443,

          -0.00055,           0.00030,

          -0.00451,           0.00175,

          -0.00110,          -0.00015,

          -0.02608,           0.00480,

           2.16555,          -0.70419,           1.74648,           0.97514,
          -1.15360,           1.73688,

           0.00004,           0.00105,

           0.00187,          -0.00311,

           0.00005,           0.00055,

           0.00004,           0.00032,

          -0.04629,           0.02292,          -0.00363,          -0.03807,

           0.00002,           0.00020,

};
static double tabrv[] = {
          -0.24459,           3.72698,          -6.67281,           5.24378,

           0.00030,           0.00003,

          -0.00002,          -0.00000,

          -0.00000,           0.00001,

           0.00032,           0.00021,

          -0.00326,           0.01002,           0.00067,           0.00653,
           0.00243,          -0.00417,

          -0.00004,          -0.00010,

          -0.00002,          -0.00001,

           0.00004,          -0.00002,

          -0.00638,          -0.01453,           0.01458,          -0.01235,
           0.00755,           0.01030,

           0.00006,           0.00014,           0.00000,           0.00009,

           0.00063,           0.00176,

           0.00003,          -0.00022,

           0.00112,           0.00001,

          -0.00014,          -0.00001,

           0.00485,           0.00322,          -0.00035,           0.00198,

           0.00004,           0.00013,

          -0.00015,          -0.00003,

           0.00011,          -0.00025,

           0.00634,           0.02207,           0.04620,           0.00160,

           0.00045,           0.00001,

          -0.11563,           0.00643,          -0.05947,           0.02018,
           0.07704,           0.01574,

          -0.00090,          -0.00471,          -0.00322,           0.01104,

           0.00265,          -0.00038,

           0.01395,           0.02165,          -0.01948,           0.01713,

          -0.00057,          -0.00019,

           0.04889,           0.13403,          -0.28327,           0.10597,
          -0.02325,          -0.35829,

           0.01171,          -0.00904,           0.00747,           0.02546,

           0.00029,          -0.00190,

          -0.03408,          -0.00703,

           0.00176,          -0.00109,

           0.00463,           0.00293,

           0.00000,           0.00148,

           1.06691,          -0.00054,

          -0.00935,          -0.00790,

           0.00552,          -0.00084,

          -0.00100,           0.00336,

           0.02874,           0.08604,          -0.17876,           0.05973,
          -0.00720,          -0.21195,

           0.02134,          -0.07980,

           0.01500,           0.01398,

           0.01758,          -0.00004,

           0.00371,           0.00650,

          -0.03375,          -0.00723,

           4.65465,          -0.00040,

           0.02040,           0.00707,

          -0.00727,          -0.01144,

          -0.00196,           0.00620,

          -0.03396,          -0.12904,           0.20160,           0.08092,

          -0.67045,           0.14014,          -0.01571,          -0.75141,

           0.00361,           0.00110,

           1.42165,          -0.01499,

          -0.00334,           0.00117,

           0.01187,           0.00507,

           0.08935,          -0.00174,

          -0.00211,          -0.00525,

           0.01035,          -0.00252,

          -0.08355,          -0.06442,           0.01616,          -0.03409,

           5.55241,         -30.62428,           2.03824,          -6.26978,
         143.07279,         -10.24734,        -125.25411,        -380.85360,
        -644.78411,         745.02852,         926.70000,       -1045.09820,

          -0.03124,          -0.00465,

          -0.00396,           0.00002,

           0.08518,           0.05248,          -0.12178,           0.23023,
          -0.30943,          -0.14208,

          -0.00005,          -0.01054,

          -0.00894,           0.00233,

          -0.00173,          -0.00768,

           0.07881,           0.01633,

          -0.04463,          -0.03347,

          -3.92991,           0.00945,

           0.01524,          -0.00422,

          -0.00011,          -0.00005,

           0.10842,          -0.02126,           0.00349,           0.12097,

          -0.03752,           0.00001,

          -0.00156,          -0.00270,

          -0.01520,           0.01349,

           0.00895,           0.00186,

          -0.67751,           0.00180,

           0.00516,          -0.00151,

          -0.00365,          -0.00210,

          -0.00276,           0.03793,

          -0.02637,           0.03235,

          -0.01343,           0.00541,

          -0.11270,           0.02169,

          -0.63365,           0.00122,

          -0.24329,           0.00428,

          -0.00040,           0.00586,

           0.00581,           0.01112,

          -0.02731,           0.00008,

          -2.69091,           0.42729,           2.78805,           3.43849,
          -0.87998,          -6.62373,           0.56882,           4.69370,

           0.00005,          -0.00008,

          -0.00181,           0.01767,

          -0.00168,           0.00660,

           0.01802,          -0.01836,

          -0.11245,          -0.00061,

           0.00199,          -0.00070,

          -0.00076,           0.00919,

           0.00311,          -0.00165,

          -0.05650,          -0.00018,

           0.00121,          -0.00069,

          -0.00803,           0.00146,

          -0.03260,          -0.00072,

          -0.00042,           0.00524,

           0.00464,          -0.00339,

          -0.06203,          -0.00278,           0.04145,           0.02871,
          -0.01962,          -0.01362,

          -0.03040,          -0.00010,

           0.00085,          -0.00001,

          -0.01712,          -0.00006,

          -0.00996,          -0.00003,

          -0.00029,           0.00026,           0.00016,          -0.00005,

          -0.00594,          -0.00003,

};

static char  argsv[] = {
  0,  3,
  2,  2,  5, -5,  6,  0,
  3,  2,  2,  1,  3, -8,  4,  0,
  3,  5,  1,-14,  2,  2,  3,  0,
  3,  3,  2, -7,  3,  4,  4,  0,
  2,  8,  2,-13,  3,  2,
  3,  6,  2,-10,  3,  3,  5,  0,
  1,  1,  7,  0,
  2,  1,  5, -2,  6,  0,
  2,  1,  2, -3,  4,  2,
  2,  2,  5, -4,  6,  1,
  1,  1,  6,  0,
  3,  3,  2, -5,  3,  1,  5,  0,
  3,  3,  2, -5,  3,  2,  5,  0,
  2,  1,  5, -1,  6,  0,
  2,  2,  2, -6,  4,  1,
  2,  2,  5, -3,  6,  0,
  1,  2,  6,  0,
  2,  3,  5, -5,  6,  0,
  1,  1,  5,  1,
  2,  2,  5, -2,  6,  0,
  2,  3,  2, -5,  3,  2,
  2,  5,  2, -8,  3,  1,
  1,  2,  5,  0,
  2,  2,  1, -5,  2,  1,
  2,  6,  2,-10,  3,  0,
  2,  2,  2, -3,  3,  2,
  2,  1,  2, -2,  3,  1,
  2,  4,  2, -7,  3,  0,
  2,  4,  2, -6,  3,  0,
  1,  1,  4,  0,
  2,  1,  2, -2,  4,  0,
  2,  2,  2, -5,  4,  0,
  2,  1,  2, -1,  3,  0,
  2,  1,  1, -3,  2,  0,
  2,  2,  2, -4,  3,  0,
  2,  6,  2, -9,  3,  0,
  2,  3,  2, -4,  3,  2,
  2,  1,  1, -2,  2,  0,
  1,  1,  3,  0,
  2,  1,  2, -1,  4,  0,
  2,  2,  2, -4,  4,  0,
  2,  5,  2, -7,  3,  0,
  2,  2,  2, -2,  3,  0,
  2,  1,  2, -3,  5,  0,
  2,  1,  2, -3,  3,  0,
  2,  7,  2,-10,  3,  0,
  2,  1,  2, -2,  5,  1,
  2,  4,  2, -5,  3,  1,
  3,  1,  2,  1,  5, -5,  6,  0,
  2,  1,  2, -1,  5,  0,
  3,  1,  2, -3,  5,  5,  6,  0,
  2,  1,  2, -2,  6,  0,
  2,  1,  2, -1,  6,  0,
  1,  3,  4,  0,
  2,  7,  2,-13,  3,  0,
  3,  1,  2,  2,  5, -5,  6,  1,
  1,  1,  2,  5,
  2,  9,  2,-13,  3,  0,
  3,  1,  2,  1,  5, -2,  6,  0,
  2,  2,  2, -3,  4,  2,
  2,  3,  2, -6,  4,  0,
  2,  1,  2,  1,  5,  0,
  2,  2,  2, -5,  3,  0,
  2,  6,  2, -8,  3,  0,
  2,  2,  1, -4,  2,  0,
  2,  3,  2, -3,  3,  0,
  1,  2,  3,  0,
  2,  3,  2, -7,  3,  0,
  2,  5,  2, -6,  3,  1,
  2,  2,  2, -2,  4,  0,
  2,  3,  2, -5,  4,  0,
  2,  2,  2, -1,  3,  0,
  2,  7,  2, -9,  3,  0,
  2,  4,  2, -4,  3,  0,
  2,  1,  2,  1,  3,  0,
  2,  3,  2, -4,  4,  0,
  2,  6,  2, -7,  3,  0,
  2,  3,  2, -2,  3,  0,
  2,  2,  2, -4,  5,  0,
  2,  2,  2, -3,  5,  0,
  2,  2,  2, -2,  5,  0,
  2,  5,  2, -5,  3,  0,
  2,  2,  2, -3,  6,  0,
  2,  2,  2, -1,  5,  0,
  2,  2,  2, -2,  6,  0,
  1,  2,  2,  3,
  2,  2,  2,  1,  5,  0,
  2,  7,  2, -8,  3,  0,
  2,  2,  1, -3,  2,  0,
  2,  4,  2, -3,  3,  0,
  2,  6,  2, -6,  3,  0,
  2,  3,  2, -1,  3,  0,
  2,  8,  2, -9,  3,  0,
  2,  5,  2, -4,  3,  0,
  2,  7,  2, -7,  3,  0,
  2,  4,  2, -2,  3,  0,
  2,  3,  2, -4,  5,  0,
  2,  3,  2, -3,  5,  0,
  2,  9,  2,-10,  3,  0,
  2,  3,  2, -2,  5,  0,
  1,  3,  2,  2,
  2,  8,  2, -8,  3,  0,
  2,  5,  2, -3,  3,  0,
  2,  9,  2, -9,  3,  0,
  2, 10,  2,-10,  3,  0,
  1,  4,  2,  1,
  2, 11,  2,-11,  3,  0,
 -1
};

/*/////////////////////////////////Jupiter starts here/////////////////////////////////*/

static double tablj[] = {
      153429.13855,      130818.16897,       18120.42948,       -8463.12663,
       -5058.91447,  1092566021.02148,      123671.25097,

          -5.43364,          12.06012,

       30428.31077,      -74667.61443,       46848.16236,      -66373.44474,
       24312.54264,      -26045.64766,       18353.92564,       -4022.13679,
        4037.97936,       10059.82468,       -4622.55896,        1383.21617,
        -187.25468,       -1171.66028,

          -0.00062,          -0.21713,

       -1198.83945,        1178.62445,       -1492.07393,         153.07155,
        -245.57966,        -391.94010,          82.26400,         -40.92104,
           3.72520,          10.57242,

          -0.04720,          -0.04448,          -0.04329,          -0.06043,

          -0.03905,           0.15712,

          -0.05644,          -0.00129,

          -0.00342,           0.02473,

           0.00434,          -0.01862,

           0.00431,          -0.03993,

          -0.03159,          -0.15982,

          -0.09928,           0.04430,          -0.00357,           0.31312,

          -0.01346,          -0.00180,

          -0.09107,           0.01215,

           0.02485,           0.01024,

          27.29869,           2.70896,          12.91956,          19.21726,
          -6.91384,           5.12954,          -1.07533,          -1.71691,

          -0.01423,           0.03121,

         -32.48652,         -26.13483,          46.78162,         -62.02701,
          94.96809,          81.73791,         -20.13673,         131.05065,

          -0.00798,           0.01786,

          13.99591,          16.87756,          -8.51726,          21.59490,
         -14.28833,          -9.45530,           7.73954,          -6.53078,

           0.03175,          -0.04295,

           3.06742,          -0.11838,           1.03630,           0.94004,
          -0.14085,           0.14434,

          -0.03363,           0.00993,

          -0.00007,          -0.02748,

          26.01507,          -7.37178,          16.96955,           6.24203,
          -0.40481,           3.72456,          -0.53597,          -0.14938,

          37.82081,          26.15887,          -2.82115,          78.26478,
         -63.39155,          -5.52419,          13.11482,         -43.54977,
          15.64940,           6.67505,

         -10.25616,          -7.39672,         -12.37441,          12.24417,
           8.54922,           9.68451,

          -0.03658,          -0.00963,

           1.65523,           0.43093,           0.32023,           0.71365,
          -0.12226,           0.03759,

           0.10388,           0.47212,          -0.02791,           0.09929,

          -0.04116,          -0.03125,

          -0.10240,          -0.23199,          -0.03524,          -0.13625,

           7.52726,           6.86314,           0.01239,          13.46530,
          -5.22256,           1.56116,          -0.15925,          -1.19571,

           3.26302,           0.06097,          -0.14444,          -0.20301,
           1.93822,         -80.12566,

           0.98665,          -7.52986,           3.86703,          -2.43028,
           0.64180,           0.78351,

           0.00190,          -0.00633,

          -0.00321,          -0.04403,

           0.19018,           0.14335,           0.10315,           0.53154,

          -0.00062,          -0.00464,

          -0.00109,           0.02150,

           1.19993,          47.21638,         -24.56067,          25.06332,
          -7.50751,          -6.36250,           1.39443,          -1.23806,

           0.04951,           0.02176,

           0.02802,          -0.01665,

          -0.10698,          -0.13635,

          73.54797,         -52.34968,          74.98754,          86.56283,
         -69.01463,          44.56866,

           0.04387,          -0.05925,

          -0.03732,          -0.03264,

           0.00967,           0.02143,

          10.59429,          26.48226,          34.03470,           3.96160,
           4.15919,         -20.22616,          -5.25903,          -3.40177,

           0.05111,          -0.06788,

           0.06497,           1.21024,          -0.29607,           0.49991,
          -0.06055,          -0.03464,

           0.02950,           0.16429,

           0.00722,          -0.90806,

          -0.02161,           0.00902,

          -0.00261,           0.00077,

           0.00434,          -0.29231,

           0.00456,           0.04781,

           1.33214,          -2.62015,           0.79761,          -0.81850,
           0.06371,           0.00119,

           0.03049,          -0.03553,           0.02373,          -0.01411,

        -189.06132,        -169.17940,           5.27464,        -227.72664,
          83.72511,         -12.04794,           0.23965,          23.75496,
          -3.43532,          -0.34276,

          -1.35880,           0.45053,          -0.34298,          -0.11441,

          -0.16328,           0.07423,

         481.48150,          79.82461,         453.82764,         941.94205,
        -635.83924,         397.29087,         -81.54066,        -417.22420,
         149.91822,          10.53490,

          -0.13210,           0.36740,

           0.33777,           0.15893,

       -2562.04968,        2442.77844,       -2602.66709,        2838.87348,
         723.50715,       -1284.58208,       -4557.23362,       -4514.61100,
       -8960.81693,        4663.55087,       -4947.61530,       19377.42027,

          -0.16786,          -0.19514,

           0.32100,           0.91502,

           4.96600,          -1.11836,

         307.38057,         175.14618,          16.02093,         444.42376,
        -219.80047,          62.39286,         -18.14266,         -52.23698,

           0.02111,           0.00469,

         -20.97409,         -34.48296,          -2.03906,         -27.07560,
           3.73818,          -3.00599,           0.24112,           0.41430,

          -0.03552,           0.00394,

          -0.00217,           0.02307,

           0.03686,           0.00510,

          34.46537,          10.23293,           9.99520,          28.88781,
         -11.31210,           3.52646,          -0.48062,          -2.93641,

          -0.00987,          -0.05310,

         -38.39539,           0.04568,         -31.73684,          -1.83151,
         -24.97332,          -1.71244,           0.33498,           7.03899,
          -4.15247,         200.43434,

          -0.00800,           0.04462,

          37.83113,         -13.40661,           9.49434,         -35.41588,
         -14.72767,          -3.84674,          -0.31412,           3.97734,

           0.02908,          -0.00353,

           1.89935,         -14.31774,           7.77051,          -7.08945,
           1.90915,           1.78908,          -0.41445,           0.30506,

         -14.43121,           7.30707,         -11.97842,         -17.64121,
          13.38962,          -7.20982,

          -5.23362,           2.11364,          -0.45605,           4.08835,
           1.42683,           0.24838,

          -0.00605,           0.03199,

          -0.17609,          -1.43091,           0.32444,          -0.51371,
           0.06182,           0.03733,

           0.00696,          -0.13438,

           4.67581,           4.42379,          -1.52602,           4.20659,
          -1.31757,          -0.72910,

           1.29012,           0.97780,           2.25895,          -0.85306,
           1.74120,          -5.09507,

           0.28107,          -0.05040,           0.05508,          -0.06349,

          -0.00061,           0.48249,

          -2.37749,           1.78180,          -1.67423,          -0.35618,
           0.05789,          -0.35287,

           0.56252,          -0.66584,           0.61979,           4.84016,
          -4.64462,          17.48002,

           0.40982,          -4.19214,          -1.55252,          -1.87505,
          -0.31070,           0.15554,

          -0.00034,           0.11102,

           0.01116,          -0.04166,

           9.27689,          -4.32090,           6.84888,           1.78741,
          -0.09306,           1.68391,          -0.27482,          -0.04197,

          -7.83068,          37.71086,         -37.53346,           7.18559,
           0.74427,         -24.29751,          10.87837,           1.35503,

           0.00998,          -0.03395,

        -133.52206,        -150.11329,           4.27494,        -173.79469,
         150.87961,        -356.29181,        -330.17873,        -426.29809,
        -607.98186,         126.35464,        -299.69623,         556.41055,

          -0.00342,           0.04411,

          44.65946,          42.07312,          85.71397,           5.95130,
          24.98064,         -41.20026,         -14.05970,         -10.46101,
          -2.24038,           2.89211,

           0.06175,           0.08128,           0.00705,           0.01939,

          -1.08361,          -0.08213,          -0.20868,          -0.36268,

          -4.96489,          -2.05966,          -6.16586,           3.65514,
          -3.12555,          12.20821,

          -1.11236,          -1.73772,          -1.34045,          -0.22774,
          -0.08639,           0.27355,

          -0.07700,           1.06260,          -0.46013,           0.31916,
          -0.04969,          -0.09488,

          -1.54000,           0.04949,          -0.07616,          -0.95933,
           0.93303,           3.43183,

          -0.82917,          -0.82042,          -0.68158,           0.17083,
           0.06942,           0.17491,

          -0.02699,          -0.01051,

           0.00657,           0.03063,

          -0.52595,           0.84035,          -0.88323,          -0.70188,
           0.60928,          -0.48179,

           0.38290,           0.04482,           0.26456,          -0.32369,

          -0.00615,           0.03218,

          -0.32943,           0.14675,          -0.10782,          -0.09036,

          -0.58003,           0.72888,          -0.46654,           1.17977,

           0.00222,           0.01541,

          -0.19226,          -0.07770,          -0.01829,          -0.05070,

          -1.75385,          -1.32969,           0.52361,          -1.36036,
           0.67222,           1.34612,

           6.96841,         -29.24025,         -23.76900,         -39.91647,
         -41.01215,          -2.23638,         -18.81024,          20.77095,

          -0.68592,          -2.26212,          -1.14065,          -0.76493,
          -0.18044,           0.15193,

          -0.20669,          -0.44387,           0.25697,          -0.17880,

          -0.53097,           0.43181,          -0.35187,           0.71934,

          -0.14962,           0.09220,          -0.05031,          -0.03924,

           0.06571,           0.29487,

           0.05170,           0.36847,

           0.02754,          -0.00411,

          -0.08313,          -0.16907,           0.10273,          -0.07315,

          -0.02312,           0.04912,

          -0.01062,          -0.02713,

           0.03806,           0.13401,

          -1.79865,          -2.04540,          -2.69965,          -0.65706,
          -1.17916,           0.79292,

           0.02415,           0.14001,

          -0.01767,           0.04209,

           0.05212,          -0.01795,

           0.01285,           0.04028,

           0.01075,           0.05533,

           0.02323,          -0.00864,

          -0.04691,           0.03128,

           0.00548,           0.02254,

           0.00011,           0.12033,

};
static double tabbj[] = {
         548.59659,         594.29629,         219.97664,          59.71822,
          23.62157,          40.77732,         227.07380,

           0.00293,          -0.00745,

        -307.33226,        -347.92807,        -309.49383,        -428.18929,
         -96.59506,        -191.36254,           2.11014,         -34.44145,
           2.23085,           6.77110,          -5.43468,          -0.28391,
           0.28355,          -1.81690,

           0.00036,           0.00078,

          -1.83259,           1.17464,          -2.66976,          -0.92339,
          -0.23645,          -1.20623,           0.25248,          -0.04958,
           0.00064,           0.03599,

          -0.00079,           0.00004,          -0.00005,          -0.00010,

          -0.00024,           0.00051,

           0.00001,           0.00005,

           0.00015,           0.00010,

           0.00017,          -0.00004,

           0.00113,          -0.00011,

           0.00021,           0.00087,

           0.00120,          -0.00114,          -0.00881,          -0.00020,

          -0.00005,           0.00009,

           0.00005,           0.00007,

           0.00002,          -0.00033,

          -0.00554,          -0.32274,           0.23695,          -0.11184,
           0.04050,           0.09929,          -0.02189,           0.00305,

          -0.00142,          -0.00055,

           0.66623,           0.34590,           0.74913,          -0.23202,
          -1.08316,          -1.40407,           1.72287,          -0.07604,

           0.00024,           0.00004,

           0.03592,           0.91143,          -1.11848,          -0.17473,
           0.91500,          -1.34912,           0.85229,           0.69029,

          -0.00019,           0.00075,

           0.03615,           0.30768,          -0.08733,           0.12016,
          -0.01716,          -0.01138,

           0.00021,           0.00004,

           0.00531,           0.00098,

          -0.14354,          -0.02364,          -0.05559,          -0.07561,
           0.01419,          -0.01141,           0.00014,           0.00218,

          -0.36564,           0.13498,          -0.13283,          -0.11462,
           0.23741,           0.14960,          -0.23173,           0.25148,
           0.00763,          -0.05987,

          -0.00857,           0.20312,          -0.29399,           0.34831,
          -1.33166,          -0.46808,

          -0.00027,           0.00046,

           0.15729,           0.01367,           0.04093,           0.07447,
          -0.01598,           0.00785,

           0.00583,           0.00324,           0.00053,           0.00160,

          -0.00030,           0.00043,

          -0.00208,           0.00334,          -0.00316,           0.00136,

           0.23086,           0.05711,           0.19558,           0.05897,
           0.01070,           0.05021,          -0.00818,          -0.02242,

           0.06301,          -0.26483,           0.66177,           0.02125,
           0.13477,           0.19376,

          -0.36520,           0.83588,          -0.69848,          -0.00877,
           0.01626,          -0.23878,

          -0.00373,           0.00044,

           0.00008,          -0.00004,

          -0.00374,          -0.00283,           0.01104,          -0.00619,

           0.00004,           0.00015,

           0.00026,           0.00013,

           0.04630,          -0.11815,           0.00773,           0.03796,
          -0.05172,           0.00149,           0.00444,          -0.01493,

          -0.00064,          -0.00044,

          -0.00033,           0.00002,

          -0.00012,           0.00284,

          -0.15622,          -0.92158,          -0.82690,          -1.52101,
          -0.55934,           0.69375,

          -0.00171,           0.00031,

           0.00129,          -0.00013,

          -0.00024,          -0.00083,

           0.66101,          -0.21764,          -0.43967,           0.30157,
           0.53389,           1.59141,           1.94286,           0.14146,

          -0.00064,          -0.00006,

           0.21850,          -0.02912,           0.08594,           0.08734,
          -0.01678,           0.01629,

           0.00133,           0.00562,

           0.00128,          -0.00025,

          -0.00005,           0.00027,

           0.00032,           0.00001,

           0.00037,           0.00042,

           0.00070,           0.00003,

           0.00275,          -0.13096,           0.02329,          -0.05582,
           0.00405,          -0.00251,

           0.01316,          -0.01165,           0.00279,          -0.00374,

         -39.62783,          20.91467,         -28.97236,           3.77560,
          -3.30029,           0.11472,          -0.48216,           1.05814,
          -0.21607,          -0.03055,

          -0.64162,          -0.57355,          -0.05861,          -0.18592,

          -0.12207,          -0.06279,

         -38.55325,        -125.74207,         -47.22357,          41.75842,
        -119.38841,          18.88515,         -11.04830,         -50.98851,
          16.64895,           1.76553,

           0.09474,           0.03714,

           0.02593,           0.07967,

       -1187.61854,       -1094.91786,       -1011.21939,       -1102.25998,
        -575.88672,        -107.84860,        -890.58889,        -807.06589,
         971.78461,       -1287.24560,       -4601.44669,        -849.54329,

          -0.00904,           0.06233,

          -0.19456,          -0.05521,

          -0.36915,           1.15363,

          32.64763,         -85.19705,         114.34437,         -13.37747,
          15.92865,          55.84857,         -13.10538,           3.07629,

          -0.00327,           0.00104,

          -7.81035,           6.19960,          -6.36096,           1.00493,
          -0.66971,          -0.84572,           0.09943,          -0.04583,

           0.00200,          -0.00032,

          -0.00265,           0.00047,

          -0.00053,           0.00046,

          -0.24396,           0.20664,          -0.30820,          -0.04917,
           0.06184,          -0.12642,           0.03053,           0.05054,

           0.00035,           0.00012,

           0.42063,          -0.58254,           0.90517,          -0.66276,
           0.64765,           0.39338,          -1.40645,           0.33017,
          -1.43377,          -0.67089,

          -0.00045,          -0.00036,

           0.23690,           0.07185,           0.28386,          -0.04397,
           0.02836,          -0.13082,          -0.00978,           0.00108,

           0.00046,           0.00083,

          -0.01665,           0.32499,          -0.09980,           0.18611,
          -0.02561,           0.00239,          -0.00084,          -0.00110,

           0.46854,          -0.35113,           0.69908,           0.53244,
           0.12875,           0.01115,

           0.13930,           0.02747,          -0.10587,          -0.17759,
          -0.26850,           0.04400,

           0.00010,          -0.00015,

           0.00164,          -0.01308,           0.00488,          -0.01046,
           0.00170,           0.00024,

           0.00084,           0.00014,

          -0.08481,          -0.02547,          -0.02290,          -0.02281,
          -0.03946,          -0.02810,

           0.01298,           0.08658,           0.05575,          -0.01081,
           1.09695,           0.35441,

          -0.03127,           0.07946,           0.01245,           0.02578,

          -0.00524,          -0.00027,

           0.08217,          -0.31742,           0.15273,          -0.07804,
           0.01197,           0.03053,

           0.81596,           0.38640,          -0.89777,           0.59499,
          -0.39581,          -0.87375,

           0.02096,           0.49772,           0.29986,           0.24210,
           0.14038,          -0.03016,

          -0.00208,           0.00045,

           0.01024,           0.00114,

           1.23010,           1.75663,          -0.12741,           1.44996,
          -0.31607,           0.03151,           0.00259,          -0.04741,

         -11.57091,           8.00331,          -9.24028,          -6.36906,
           4.71248,          -2.43695,           0.38630,           1.90625,

           0.01401,           0.00114,

          33.56690,         -55.17784,          33.21425,         -52.57002,
          27.04138,          13.78610,          69.60307,         -81.16312,
          27.53960,        -158.28336,        -205.94418,         -95.08051,

          -0.01407,          -0.00364,

         -18.56128,           6.02270,         -10.11059,          24.69471,
          12.31878,           9.94393,           3.81994,          -4.84109,
          -1.08440,          -0.72136,

           0.03731,          -0.02094,           0.00789,          -0.00176,

           0.09673,          -0.11181,           0.03112,          -0.00065,

          -0.29167,          -0.82083,           0.40866,          -0.77487,
          -2.23349,          -0.46973,

           0.41024,          -0.14274,           0.07755,          -0.24895,
          -0.04965,          -0.01197,

          -0.02264,           0.05917,          -0.02817,           0.01242,
          -0.00250,          -0.00247,

          -0.14414,          -0.03739,           0.14708,          -0.07908,
           0.05843,           0.15173,

          -0.01601,          -0.07844,          -0.05957,          -0.03143,
          -0.01830,           0.01257,

          -0.00109,          -0.00000,

           0.00174,           0.00050,

          -0.02119,           0.06918,          -0.02470,           0.00185,
           0.02372,          -0.02417,

           0.01081,           0.05222,           0.09820,           0.05931,

          -0.00588,          -0.00086,

           0.01688,          -0.00133,          -0.00073,           0.00041,

          -0.02280,          -0.05706,          -0.17694,          -0.12027,

           0.00196,          -0.00060,

           0.00051,          -0.02426,           0.00314,          -0.00302,

           0.17923,          -0.78343,           0.52073,          -0.02398,
          -0.03978,           0.20841,

           6.51325,           3.37139,          12.88844,          -6.72098,
           3.40949,         -14.34313,          -9.68278,          -7.85143,

           1.06886,          -0.21727,           0.36675,          -0.49815,
          -0.07289,          -0.07537,

           0.01107,          -0.00644,           0.01013,          -0.00306,

          -0.00708,          -0.13488,          -0.23041,          -0.10698,

          -0.00049,          -0.00692,          -0.00142,          -0.00211,

          -0.04021,           0.01805,

           0.00479,           0.00620,

           0.00739,           0.00566,

          -0.00101,          -0.00022,           0.00261,          -0.00188,

          -0.01812,          -0.01205,

          -0.00061,          -0.00061,

          -0.02479,           0.01157,

           0.91642,          -0.65781,           0.39969,          -1.13699,
          -0.43337,          -0.57828,

           0.00145,           0.00281,

          -0.01675,          -0.00975,

           0.00119,          -0.00074,

          -0.00343,           0.00139,

           0.00061,           0.00086,

           0.00054,          -0.00046,

          -0.01996,          -0.02689,

           0.00034,           0.00037,

          -0.00006,           0.00001,

};
static double tabrj[] = {
        -734.58857,       -1081.04460,        -551.65750,        -148.79782,
         -25.23171,         164.64781,         248.64813,

          -0.05163,          -0.02413,

       -1306.61004,         560.02437,       -1622.58047,         589.92513,
        -812.39674,         166.85340,        -157.92826,        -107.14755,
          68.98900,         -18.95875,          -0.16183,          36.24345,
          -9.19972,          -2.29315,

          -0.00316,           0.00222,

          10.95234,          21.37177,          -6.29550,          21.83656,
          -7.70755,           1.38228,          -0.21770,          -1.49525,
           0.17951,           0.01043,

           0.00062,           0.00208,          -0.00066,           0.00050,

           0.00313,           0.00187,

           0.00010,           0.00131,

           0.00102,           0.00047,

           0.00102,           0.00012,

           0.00012,          -0.00037,

           0.00808,           0.00027,

          -0.01219,          -0.00961,          -0.04166,          -0.00327,

          -0.00001,          -0.00146,

          -0.00092,          -0.00989,

          -0.00135,           0.00196,

           0.19216,           2.48442,          -1.43599,           1.39651,
          -0.48549,          -0.53272,           0.14066,          -0.10352,

           0.00141,           0.00066,

           2.96838,          -3.09575,           6.27741,           5.24306,
          -8.77080,           9.03247,         -10.98350,          -3.58579,

          -0.00168,          -0.00100,

           0.20234,          -0.75737,           0.36838,          -0.58241,
           0.41430,          -0.35784,           0.47038,          -0.10586,

           0.00539,           0.00490,

          -0.01375,          -0.01950,           0.00145,           0.00723,
          -0.00391,           0.00391,

          -0.00131,          -0.00568,

           0.01317,           0.00319,

           1.31006,           5.89394,          -1.61753,           3.68814,
          -0.80644,          -0.14747,           0.04481,          -0.11361,

          -4.36130,           7.92488,         -16.29047,          -1.52163,
           2.14492,         -14.38028,           9.65573,           3.56881,
          -1.87208,           3.36213,

           1.84499,          -2.41575,          -2.77076,          -3.23915,
          -3.34573,           1.40979,

           0.00217,          -0.00841,

           0.29313,          -0.36246,           0.22043,           0.02328,
          -0.01182,           0.04074,

          -0.15728,           0.02468,          -0.03185,          -0.01099,

           0.01059,          -0.01274,

           0.07362,          -0.02642,           0.04035,          -0.00968,

          -2.14457,           2.53297,          -4.34196,          -0.11421,
          -0.38757,          -1.73872,           0.39784,          -0.01397,

          -0.03311,           0.97723,           0.16060,          -0.07486,
          25.96413,           0.75088,

          -3.04736,           0.30340,          -1.43451,          -1.35136,
           0.26526,          -0.40247,

          -0.00460,          -0.00056,

           0.01633,          -0.00128,

          -0.05197,           0.07002,          -0.19450,           0.03737,

           0.00188,          -0.00037,

          -0.00903,          -0.00059,

         -19.73809,           0.58424,         -10.42034,         -10.14579,
           2.65990,          -3.07889,           0.50884,           0.58508,

          -0.00970,           0.02099,

           0.00716,           0.01161,

           0.05751,          -0.04515,

          22.08042,          30.82415,         -36.27430,          31.40265,
         -18.30150,         -29.16403,

           0.02454,           0.01834,

          -0.01312,           0.01576,

          -0.00928,           0.00330,

         -11.78094,           4.06738,          -2.51590,          15.05277,
           9.12747,           2.88088,           2.32916,          -2.08271,

           0.02872,           0.02194,

           0.60494,          -0.04597,           0.24749,           0.15971,
          -0.02185,           0.03384,

          -0.07075,           0.01287,

           0.40201,           0.00347,

          -0.00410,          -0.00998,

          -0.00005,          -0.00121,

           0.13770,           0.00186,

          -0.02268,           0.00210,

           1.26291,           0.65546,           0.38885,           0.38880,
          -0.00184,           0.03067,

           0.01273,           0.01136,           0.00557,           0.01117,

          94.13171,         -88.37882,         120.53292,           8.32903,
           7.77313,          43.46523,         -11.66698,           0.44639,
           0.15092,          -1.68367,

          -0.30833,          -0.49030,           0.01971,          -0.14144,

          -0.04019,          -0.05110,

         -39.70024,         272.91667,        -468.46263,         256.77696,
        -200.63130,        -307.98554,         206.56301,         -41.76039,
          -4.74242,          74.19909,

           0.18474,           0.05547,

          -0.06732,           0.16515,

       -1156.31285,       -1102.97666,       -1346.99288,       -1121.01090,
         666.84550,         421.92305,        2259.49740,       -2268.69758,
       -2325.87639,       -4476.46256,       -9683.77583,       -2472.92565,

          -0.10400,           0.08075,

          -0.45225,           0.16621,

           0.57789,           2.43804,

          85.21675,        -154.17208,         219.91042,          -9.71116,
          31.13240,         108.60117,         -25.85622,           8.98402,

          -0.00233,           0.01030,

         -17.01324,          10.41588,         -13.34449,           1.08782,
          -1.48199,          -1.81734,           0.20334,          -0.11734,

          -0.00230,          -0.01869,

          -0.01182,          -0.00129,

          -0.00281,           0.02021,

          -5.75973,          19.13309,         -16.13690,           5.53382,
          -1.96585,          -6.29211,           1.63105,          -0.26089,

           0.02935,          -0.00555,

           0.30700,         -19.96182,           0.99825,         -16.32664,
           0.83052,         -13.76201,          -3.15609,           0.17360,
        -111.81423,          -2.05419,

          -0.02455,          -0.00478,

           7.45114,          21.53296,          19.90263,           5.69420,
           2.31253,          -8.15116,          -2.17440,          -0.23014,

           0.00168,           0.01590,

           8.78005,           0.71418,           4.48561,           4.50680,
          -1.05713,           1.17880,          -0.19327,          -0.24877,

          -5.00870,          -8.66354,          10.51902,          -7.71011,
           4.65486,           8.05673,

          -1.39635,          -3.07669,          -2.40347,          -0.11167,
          -0.04064,           0.83512,

          -0.02041,          -0.00351,

           0.97375,          -0.15795,           0.36361,           0.19913,
          -0.02142,           0.04193,

           0.08801,           0.00475,

          -2.81010,           3.11341,          -2.79191,          -0.93313,
           0.44570,          -0.88287,

          -0.51815,           0.54776,           0.29736,           0.99779,
           2.28957,           0.82183,

           0.03386,           0.12855,           0.03124,           0.02454,

          -0.31958,           0.00070,

          -1.48184,          -1.28195,           0.03965,          -1.12026,
           0.23910,           0.01293,

           0.36146,          -0.64483,          -1.88470,           0.21469,
         -11.79819,          -1.87287,

           2.65699,          -0.36287,           0.88148,          -1.26883,
          -0.19657,          -0.14279,

          -0.07536,          -0.00004,

           0.01496,           0.00537,

           2.48352,           3.75581,          -0.34909,           3.26696,
          -0.82105,           0.11287,          -0.00755,          -0.13764,

         -15.34429,          -2.79957,          -3.22976,         -15.46084,
          10.66793,          -0.26054,          -0.12188,           5.06211,

           0.01313,           0.00424,

          84.34332,         -57.05646,          92.68150,          -0.02024,
         149.62698,          59.14407,         174.04569,        -129.26785,
         -55.99789,        -238.01484,        -212.51618,        -115.94914,

          -0.01720,          -0.00158,

         -13.65602,          17.47396,           0.16714,          32.66367,
          16.30095,           9.18345,           3.98555,          -5.39985,
          -1.09958,          -0.86072,

           0.02752,          -0.02474,           0.00671,          -0.00278,

          -0.21030,          -0.73658,           0.20708,          -0.21378,

           0.78462,          -2.14051,          -1.60070,          -2.60915,
          -5.02441,          -1.19246,

           0.67622,          -0.41889,           0.07430,          -0.53204,
          -0.11214,          -0.03417,

          -0.72636,          -0.15535,          -0.16815,          -0.35603,
           0.07530,          -0.02521,

          -0.01261,          -0.94883,           0.39930,          -0.05370,
          -2.77309,           0.38431,

           0.72127,          -0.52030,          -0.01804,          -0.51188,
          -0.11993,           0.02189,

           0.00928,          -0.02129,

          -0.02760,           0.00441,

          -0.56832,          -0.48114,           0.64192,          -0.65656,
           0.37483,           0.51883,

          -0.08474,           0.20324,           0.12783,           0.13041,

          -0.01545,          -0.00282,

          -0.16196,          -0.26980,           0.06584,          -0.09987,

          -0.36305,          -0.27610,          -0.57074,          -0.13607,

          -0.00824,           0.00369,

           0.06094,          -0.12214,           0.03581,          -0.00876,

           0.49346,          -0.74596,           0.47814,           0.18201,
          -1.00640,           0.24465,

          10.09808,           2.30496,          13.63359,          -7.94007,
           0.29792,         -13.55724,          -6.48556,          -5.99581,

           0.69686,          -0.22434,           0.23198,          -0.35579,
          -0.04736,          -0.05683,

           0.36710,          -0.16571,           0.14876,           0.21824,

          -0.18940,          -0.15063,          -0.23692,          -0.09990,

          -0.08923,          -0.12222,           0.02998,          -0.04560,

          -0.16229,           0.04552,

          -0.33051,           0.02585,

          -0.00622,           0.01583,

           0.15436,          -0.07109,           0.06429,           0.09218,

          -0.01277,          -0.00019,

           0.02345,          -0.01057,

          -0.07294,           0.02506,

           0.62063,          -0.52533,           0.16814,          -0.77168,
          -0.20614,          -0.31828,

          -0.12856,           0.01316,

          -0.01522,          -0.00126,

           0.01558,           0.04765,

          -0.02776,           0.01166,

          -0.05185,           0.00674,

           0.00754,           0.02183,

          -0.00645,          -0.01050,

          -0.02155,           0.00375,

           0.12040,          -0.00004,

};

static char  argsj[] = {
  0,  6,
  3,  2,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -5,  6,  6,
  3,  1,  5, -2,  6, -3,  8,  0,
  2,  4,  5,-10,  6,  4,
  3,  2,  5, -4,  6, -3,  7,  1,
  3,  3,  5,-10,  6,  7,  7,  0,
  2,  6,  5,-15,  6,  0,
  3,  1,  5, -4,  6,  4,  7,  0,
  3,  3,  5, -8,  6,  2,  7,  0,
  3,  1,  5, -3,  6,  1,  7,  0,
  3,  1,  5, -3,  6,  2,  7,  0,
  1,  1,  7,  1,
  2,  5,  5,-12,  6,  0,
  3,  2,  5, -7,  6,  7,  7,  0,
  3,  1,  5, -1,  6, -3,  7,  0,
  2,  3,  5, -7,  6,  3,
  3,  1,  5, -4,  6,  3,  7,  0,
  2,  1,  5, -2,  6,  3,
  3,  3,  5, -8,  6,  3,  7,  0,
  2,  1,  5, -3,  6,  3,
  3,  1,  5, -3,  6,  3,  7,  0,
  2,  3,  5, -8,  6,  2,
  3,  2,  5, -5,  6,  2,  7,  0,
  1,  2,  7,  0,
  2,  4,  5, -9,  6,  3,
  2,  2,  5, -4,  6,  4,
  1,  1,  6,  2,
  3,  2,  5, -5,  6,  3,  7,  0,
  2,  2,  5, -6,  6,  2,
  2,  5,  5,-11,  6,  1,
  3,  1,  5, -2,  7, -2,  8,  0,
  2,  1,  5, -3,  7,  1,
  2,  3,  5, -6,  6,  3,
  2,  1,  5, -1,  6,  2,
  2,  1,  5, -4,  6,  2,
  2,  3,  5, -9,  6,  0,
  3,  2,  5, -4,  6,  2,  7,  0,
  2,  1,  5, -2,  7,  1,
  2,  6,  5,-13,  6,  0,
  3,  2,  5, -2,  6, -3,  7,  0,
  2,  4,  5, -8,  6,  3,
  2,  3,  6, -3,  7,  0,
  3,  6,  5,-14,  6,  3,  7,  0,
  3,  1,  5, -2,  7,  1,  8,  0,
  2,  2,  5, -3,  6,  2,
  3,  1,  5, -4,  7,  5,  8,  0,
  3,  2,  5, -8,  6,  3,  7,  0,
  3,  4,  5, -9,  6,  3,  7,  0,
  1,  2,  6,  3,
  3,  2,  5, -4,  6,  3,  7,  0,
  2,  2,  5, -7,  6,  2,
  2,  1,  5, -2,  8,  0,
  2,  1,  5, -1,  7,  0,
  3,  3,  5, -6,  6,  2,  7,  0,
  3,  4,  5, -8,  6,  2,  8,  0,
  2,  1,  5, -1,  8,  0,
  3,  2,  5, -3,  6,  1,  7,  0,
  2,  7,  5,-15,  6,  2,
  3,  3,  5, -4,  6, -3,  7,  1,
  2,  5,  5,-10,  6,  4,
  3,  1,  5,  1,  6, -3,  7,  1,
  3,  7,  5,-16,  6,  3,  7,  0,
  2,  3,  5, -5,  6,  4,
  3,  1,  5, -6,  6,  3,  7,  0,
  3,  5,  5,-11,  6,  3,  7,  0,
  1,  1,  5,  5,
  3,  3,  5,-11,  6,  3,  7,  0,
  3,  3,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -7,  7,  0,
  2,  1,  5, -5,  6,  3,
  3,  1,  5, -1,  6,  3,  7,  0,
  2,  3,  5,-10,  6,  3,
  3,  2,  5, -3,  6,  2,  7,  0,
  2,  1,  5,  1,  7,  0,
  3,  2,  5, -1,  6, -3,  7,  0,
  2,  4,  5, -7,  6,  3,
  2,  4,  6, -3,  7,  0,
  2,  2,  5, -2,  6,  4,
  3,  4,  5, -8,  6,  3,  7,  0,
  1,  3,  6,  3,
  3,  2,  5, -3,  6,  3,  7,  0,
  2,  5,  5, -9,  6,  3,
  2,  3,  5, -4,  6,  2,
  2,  1,  5,  1,  6,  2,
  2,  2,  5, -4,  7,  0,
  2,  6,  5,-11,  6,  2,
  2,  2,  5, -3,  7,  0,
  2,  4,  5, -6,  6,  2,
  2,  2,  5, -1,  6,  2,
  1,  4,  6,  1,
  2,  2,  5, -2,  7,  0,
  2,  5,  5, -8,  6,  2,
  2,  3,  5, -3,  6,  2,
  2,  1,  5,  2,  6,  2,
  2,  2,  5, -2,  8,  0,
  2,  2,  5, -1,  7,  0,
  2,  6,  5,-10,  6,  3,
  2,  4,  5, -5,  6,  3,
  2,  6,  6, -3,  7,  0,
  1,  2,  5,  5,
  3,  4,  5, -6,  6,  3,  7,  0,
  1,  5,  6,  4,
  2,  2,  5,-10,  6,  1,
  2,  5,  5, -7,  6,  1,
  2,  3,  5, -2,  6,  2,
  2,  1,  5,  3,  6,  2,
  2,  6,  5, -9,  6,  2,
  2,  4,  5, -4,  6,  2,
  2,  2,  5,  1,  6,  2,
  2,  7,  5,-11,  6,  0,
  2,  3,  5, -3,  7,  0,
  2,  5,  5, -6,  6,  2,
  2,  3,  5, -1,  6,  1,
  2,  3,  5, -2,  7,  0,
  2,  6,  5, -8,  6,  1,
  2,  4,  5, -3,  6,  1,
  2,  2,  5,  2,  6,  0,
  2,  7,  5,-10,  6,  1,
  2,  5,  5, -5,  6,  2,
  1,  3,  5,  3,
  2,  1,  5,  5,  6,  2,
  2,  6,  5, -7,  6,  1,
  2,  4,  5, -2,  6,  1,
  2,  7,  5, -9,  6,  1,
  2,  5,  5, -4,  6,  0,
  2,  6,  5, -6,  6,  0,
  2,  4,  5, -1,  6,  0,
  2,  7,  5, -8,  6,  1,
  2,  5,  5, -3,  6,  0,
  2,  8,  5,-10,  6,  0,
  2,  6,  5, -5,  6,  0,
  1,  4,  5,  2,
  2,  7,  5, -7,  6,  0,
  2,  5,  5, -2,  6,  0,
  2,  8,  5, -9,  6,  0,
  2,  7,  5, -6,  6,  0,
  2,  8,  5, -8,  6,  0,
  2,  9,  5,-10,  6,  0,
  1,  5,  5,  0,
  2,  9,  5, -9,  6,  0,
  2,  1,  3, -1,  5,  0,
 -1
};

/*////////////////////////////////////Saturn starts here/////////////////////////////////////////*/

static double tablst[] = {
     1788381.26240,     2460423.68044,     1370113.15868,      415406.99187,
       72040.39885,       12669.58806,   439960754.85333,      180256.80433,

          18.71177,         -40.37092,

       66531.01889,     -195702.70142,       57188.02694,     -179110.60982,
      -19803.06520,      -58084.15705,       -9055.13344,      -31146.10779,
       11245.43286,       -3247.59575,         459.48670,        2912.82402,

          -4.06749,         -13.53763,

         -30.55598,          -4.51172,

           1.48832,           0.37139,

         597.35433,        1193.44545,        -297.50957,         976.38608,
        -263.26842,          34.84354,          -6.77785,         -29.92106,

          -0.16325,          -0.18346,

          -0.15364,          -0.08227,

           0.20180,           0.02244,

           0.04672,          -0.29867,

          -0.04143,          -0.00760,

          -0.17046,          -0.00778,

           0.04200,           0.23937,          -0.00098,          -0.05236,

          -0.02749,          -0.01813,

           0.00637,           0.01256,

          -0.04506,           0.04448,

          -0.00105,           0.06224,

           0.01157,           0.17057,          -0.03214,           0.18178,

          -0.22059,          -0.01472,

          -0.24213,           0.04309,           0.03436,           0.44873,

           0.01350,          -0.01931,

          -0.80618,          -0.56864,           0.29223,          -0.03101,

           0.04171,           0.02264,

          -0.01264,          -0.01645,

           0.01774,           0.06374,

          -0.01925,          -0.03552,

           0.10473,          -0.04119,

           0.08045,           0.04635,

          -3.01112,          -9.26158,           8.13745,           1.88838,

          -0.15184,           0.16898,

          -0.22091,           0.29070,          -0.03259,           0.06938,

          -0.08499,          -0.21688,           0.01848,          -0.05594,

           0.50100,          -0.00027,           0.13300,           0.12055,

           0.03039,           0.03854,

          -1.55287,           2.55618,          -0.45497,          -0.29895,
          -0.93268,           0.83518,

          -0.32785,           7.03878,          -1.66649,           2.75564,
          -0.29459,           0.01050,

           0.08293,          -0.03161,

          -0.12750,          -0.04359,

           0.04217,           0.07480,

        -114.43467,          49.47867,         -66.52340,         -26.27841,
          15.48190,         -13.06589,           3.28365,           5.02286,

          -0.17155,          -0.07404,

           0.00924,          -0.07407,

          -0.02922,           0.06184,

         108.04882,          86.09791,        -155.12793,         208.10044,
        -311.72810,        -268.92703,          74.57561,        -420.03057,

          -0.07893,           0.09246,

          -0.66033,          -0.39026,          -0.13816,          -0.08490,

         -36.79241,         -78.88254,          71.88167,         -68.05297,
          51.71616,          65.77970,         -43.59328,          23.51076,

          -0.02029,          -0.32943,

          -8.82754,           1.48646,          -3.12794,           2.12866,
          -0.06926,           0.44979,

           0.00621,          -0.51720,

          -3.82964,          -1.48596,          -0.11277,          -3.21677,
           0.81705,          -0.19487,

          -0.06195,           0.10005,          -0.02208,           0.00108,

           0.00455,          -0.03825,

           0.01217,          -0.00599,

          -0.17479,          -0.47290,           0.85469,           1.12548,
          -0.80648,          -0.44134,

          -0.01559,          -0.07061,

           0.01268,          -0.01773,

           0.01308,          -0.03461,

          -0.71114,           1.97680,          -0.78306,          -0.23052,
           0.94475,          -0.10743,

           0.18252,          -8.03174,

           0.00734,           0.04779,

           0.12334,          -0.03513,

           0.01341,           0.02461,

           0.02047,          -0.03454,

           0.02169,          -0.01921,

          -1.12789,           0.09304,           0.14585,           0.36365,

           0.03702,           0.10661,          -0.00464,          -1.72706,

          -0.00769,          -0.04635,

          -0.01157,           0.00099,

          10.92646,           1.96174,           2.91142,           4.74585,
          -0.29832,           0.75543,

           0.05411,           1.05850,

           0.38846,          -0.16265,

           1.52209,           0.12185,           0.18650,           0.35535,

        -278.33587,         -82.58648,        -160.00093,        -225.55776,
          35.17458,         -77.56672,          10.61975,           3.33907,

           0.06090,           2.17429,

          -4.32981,          -5.84246,          11.43116,          20.61395,

          -0.65772,           1.28796,

        1224.46687,       -3113.15508,        3798.33409,        -137.28735,
        -256.89302,        2227.35649,        -779.78215,        -260.37372,

          11.73617,         -13.25050,          -0.75248,          -2.87527,

          -8.38102,          17.21321,

      -61784.69616,       39475.02257,      -54086.68308,       54550.85490,
      -16403.69351,       29602.70098,       14672.06363,       16234.17489,
       15702.37109,      -22086.30300,      -22889.89844,       -1245.88352,

           1.48864,          19.75000,           0.78646,           3.29343,

       -1058.13125,        4095.02368,       -2793.78506,        1381.93282,
        -409.19381,        -772.54270,         161.67509,         -34.15910,

        -514.27437,          27.34222,        -311.04046,          48.01030,
         -43.36486,          16.19535,          -0.73816,          -0.81422,

         287.32231,        -110.44135,         200.43610,          37.98170,
          17.73719,          34.40023,          -2.46337,           1.48125,

           0.09042,          -0.11788,

           0.37284,           0.51725,           0.00597,           0.14590,

          -0.01536,           0.00980,

           0.00721,           0.02023,

           0.00027,           0.02451,

          -0.72448,          -0.71371,           0.29322,           0.18359,

           0.72719,          -0.37154,           0.14854,          -0.02530,

           0.23052,           0.04258,

           4.82082,           0.01885,           3.11279,          -0.63338,
           0.10559,          -0.02146,

          -0.01672,           0.03412,

           0.00605,           0.06415,

          -0.89085,           1.51929,          -0.36571,           0.39317,

          12.05250,          -3.79392,           3.96557,          -3.51272,
          -0.17953,          12.30669,

          -0.05083,          -0.11442,

           0.02013,          -0.02837,

          -0.02087,          -0.01599,

           0.49190,           0.30360,           0.01316,           0.17649,

           0.21193,          -0.09149,          -0.07173,          -0.05707,

           4.24196,          -1.25155,           1.81336,           0.68887,
          -0.01675,           0.20772,

          -0.04117,          -0.03531,

          -0.02690,          -0.02766,

          37.54264,          10.95327,           8.05610,          30.58210,
         -12.68257,           1.72831,           0.13466,          -3.27007,

           0.01864,          -0.00595,

           0.03676,           0.14857,          -0.07223,           0.06179,

           0.44878,          -1.64901,         -20.06001,           0.63384,
          -4.97849,           4.78627,          29.87370,           7.29899,

           0.00047,          -0.00155,

           0.00314,           0.01425,

          -0.17842,          -0.08461,

          -1.61020,          -8.47710,           6.85048,          -4.38196,
           1.05809,           2.68088,

          -0.01027,          -0.00833,

           0.06834,          -0.04205,

           0.03330,          -0.01271,

           0.01301,          -0.01358,

           0.03537,           0.03612,           0.02962,           0.62471,
          -0.30400,          -0.64857,

           0.01773,           0.01890,

           0.01426,          -0.00226,

          -0.50957,          -0.01955,          -0.09702,           1.09983,

           0.64387,          -0.02755,

           0.26604,           0.30684,           0.06354,           0.05114,

          -0.00058,          -0.04672,

          -0.00828,           0.00712,

          -0.00440,           0.00029,

          -0.01601,           0.03566,

           0.13398,          -0.02666,

          -0.06752,          -0.43044,           0.07172,          -0.01999,

          -0.01761,          -0.05357,

           0.06104,           0.29742,          -0.08785,           0.05241,

          -6.57162,          -4.20103,           0.03199,          -6.46187,
           1.32846,          -0.51137,

           0.06358,           0.37309,

          -1.46946,           2.34981,

          -0.18712,           0.11618,

         240.62965,        -107.21962,         219.81977,          84.04246,
         -62.22931,          68.35902,          -9.48460,         -32.62906,

           5.57483,          -1.82396,           1.00095,          -0.39774,

           7.87054,          11.45449,

        -432.67155,       55064.72398,       12444.62359,       54215.28871,
        8486.03749,       12297.48243,        -333.27968,        1147.93192,
        1403.73797,         990.40885,          -3.84938,        -722.43963,

          16.83276,          96.48787,           7.04834,          38.22208,
           0.63843,           2.61007,

         230.73221,         171.64166,           1.96751,         287.80846,
         -85.21762,          31.33649,          -2.25739,         -11.28441,

           0.04699,           0.06555,

          -0.08887,           1.70919,           0.09477,           0.26291,

          -0.15490,           0.16009,

           1.93274,           1.01953,           0.36380,           1.29582,
          -0.13911,           0.14169,

          -0.00491,          -0.00030,

          -0.08908,          -0.10216,

          -0.03265,          -0.03889,

           0.40413,          -1.12715,          -0.94687,          -0.04514,

           0.02487,          -0.01048,

           0.39729,           2.82305,          -0.61100,           1.11728,
          -0.13083,          -0.04965,

          -0.00602,          -0.02952,

          -6.13507,          13.73998,         -15.70559,          -1.28059,
           2.64422,          -9.33798,           3.26470,           1.56984,

          -0.00572,           0.09992,

          -8.80458,          -8.23890,         -11.51628,           9.47904,
          11.31646,           4.29587,

          -2.41367,          -0.05883,          -0.80022,          -1.02706,
           0.21461,          -0.06864,

           0.01882,           0.01798,

           0.27614,          -0.01007,           0.04362,           0.07560,
           0.05519,           0.23435,

          -0.09389,           0.01613,

           0.01298,           0.04691,

          -0.02665,          -0.03582,

           0.60080,          -4.28673,           1.87316,          -1.05840,
           0.13248,           0.40887,

          -0.67657,           0.67732,           0.05522,           0.07812,
          -0.17707,          -0.07510,

           0.24885,          10.63974,          -7.40226,          -2.33827,
           2.75463,         -32.51518,

           0.05140,           0.01555,

         180.43808,         263.28252,         384.50646,         -76.53434,
         -93.50706,        -220.50123,         -81.91610,         103.92061,
          30.90305,          -2.89292,

          -0.06634,          -0.37717,          -0.01945,          -0.05936,

          29.27877,         -59.73705,          35.86569,         -18.36556,
           3.88812,           4.82090,          -0.70903,           0.06615,

           0.01558,          -0.01854,

           0.16209,           0.12682,           0.02508,           0.02406,

          -0.03078,          -0.01737,          -0.00033,          -0.00020,

           0.01023,           0.05972,

          -0.03373,          -0.07289,

          -2.08162,          -0.14717,          -0.64233,          -0.75397,
           0.11752,          -0.09202,

           4.42981,          -4.19241,           5.02542,           5.03467,
          -4.22983,           2.80794,

           3.03016,          -2.74373,          -1.11490,          -2.72378,
          -0.63131,           0.74864,

          -0.00759,          -0.00675,

           0.03615,          -0.01806,

          -2.71920,          -1.50954,           0.54479,          -1.92088,
           0.66427,           0.32228,

          -2.55188,          -0.65332,          -2.73798,           2.10182,
           1.54407,           3.01357,

          38.76777,          23.54578,          27.29884,         -14.93005,
          -7.50931,          -5.66773,           0.30142,           1.52416,

           0.00634,           0.09697,          -0.00748,           0.01433,

           0.02936,           0.53228,          -0.03603,           0.06345,

           0.30816,          -1.07925,           0.46709,          -0.21568,
           0.01663,           0.10810,

          -0.42511,           0.35872,          -0.19662,          -6.74031,

           1.05776,           1.86205,           1.08919,           0.10483,
          -0.03368,          -0.21535,

           0.07556,          -0.27104,           0.05142,          -0.03812,

           1.20189,          -1.36782,           1.35764,           1.39387,
          -1.19124,           0.77347,

          -0.54760,          -0.26295,          -0.07473,           0.23043,

           2.82621,          -0.23524,           0.47352,          -0.81672,
          -0.08515,           0.04700,

           0.55355,          -0.40138,           0.22255,           0.12236,

          -0.09110,           0.31982,           0.39404,          -0.17898,

          -0.00056,           0.00014,

          -0.02012,           0.03102,

           0.43236,          -0.10037,          -0.00961,           0.07440,
          -0.07076,          -1.97272,

           0.25555,          -0.21832,          -0.00837,          -0.08393,

           0.01531,           0.00627,

           0.33193,           0.70765,          -0.43556,           0.28542,

          -0.23190,          -0.04293,          -0.08062,           0.13427,

           0.23763,          -0.17092,           0.09259,           0.05155,

           0.08065,          -0.11943,

          -0.02174,          -0.68899,

          -0.01875,          -0.01746,

           0.13604,           0.29280,          -0.17871,           0.11799,

           0.02003,           0.04065,

           0.01343,          -0.06060,

          -0.01290,          -0.26068,

          -0.09033,           0.02649,

          -0.00092,          -0.03094,

          -0.00770,          -0.10447,

          -0.04113,           0.01259,

          -0.00469,          -0.04346,

          -0.00010,           0.06547,

};
static double tabbst[] = {
     -567865.62548,     -796277.29029,     -410804.00791,      -91793.12562,
       -6268.13975,         398.64391,        -710.67442,         175.29456,

          -0.87260,           0.18444,

       -1314.88121,       20709.97394,       -1850.41481,       20670.34255,
        -896.96283,        6597.16433,        -179.80702,         613.45468,
          17.37823,         -13.62177,          -0.36348,          12.34740,

           0.47532,           0.48189,

           0.27162,          -0.20655,

          -0.23268,           0.05992,

          46.94511,          15.78836,          21.57439,          23.11342,
          -0.25862,           5.21410,          -0.22612,          -0.05822,

          -0.00439,          -0.01641,

          -0.01108,          -0.00608,

           0.00957,           0.00272,

          -0.00217,           0.00001,

          -0.00534,          -0.00545,

           0.00277,          -0.00843,

           0.00167,          -0.00794,           0.00032,          -0.00242,

          -0.00002,          -0.00041,

          -0.00025,           0.00031,

           0.00062,          -0.00060,

           0.00083,           0.00032,

           0.00527,          -0.00211,           0.00054,           0.00004,

          -0.02769,          -0.01777,

           0.00247,           0.00097,           0.00020,          -0.00232,

           0.00044,          -0.00035,

          -0.00072,           0.01341,           0.00325,          -0.01159,

           0.00079,          -0.00078,

          -0.00009,           0.00066,

           0.00222,           0.00002,

           0.00013,          -0.00161,

           0.01374,          -0.05305,

           0.00478,          -0.00283,

           0.16033,           0.13859,           0.33288,          -0.16932,

          -0.00316,           0.00625,

          -0.00309,           0.01687,           0.00001,           0.00486,

           0.00401,          -0.01805,          -0.00048,          -0.00407,

          -0.01329,           0.01311,          -0.00591,           0.00166,

           0.00830,           0.00665,

          -0.80207,           0.22994,          -0.34687,           0.08460,
          -0.11499,          -0.01449,

          -0.01574,           0.78813,          -0.03063,           0.28872,
          -0.00337,           0.01801,

          -0.01703,          -0.00929,

          -0.00738,           0.03938,

           0.05616,          -0.00516,

          -3.09497,          30.13091,          -3.14968,          17.62201,
          -0.73728,           2.46962,          -0.11233,           0.03450,

          -0.07837,          -0.01573,

          -0.01595,           0.00394,

           0.00174,           0.01470,

           6.83560,          -2.37594,           4.95125,           3.24711,
           2.44781,           5.17159,           1.99820,          -2.38419,

           0.00840,           0.03614,

          -0.00209,          -0.30407,          -0.02681,          -0.06128,

           1.50134,          11.82856,           4.39644,           6.98850,
          -4.17679,           5.73436,          -9.66087,           1.98221,

          -0.29755,           0.08019,

          -0.24766,          -8.54956,          -1.74494,          -3.36794,
          -0.32661,          -0.00722,

           0.14141,           0.01023,

          -1.21541,          -2.58470,           0.38983,          -1.70307,
           0.31209,          -0.10345,

           0.02593,           0.02178,           0.00289,           0.00393,

          -0.00236,          -0.00373,

          -0.00270,          -0.00049,

          -0.06282,          -0.00443,          -0.02439,          -0.02254,
          -0.02220,           0.03532,

          -0.00072,           0.00010,

          -0.00049,          -0.00112,

           0.00086,           0.00112,

           0.10135,          -0.10972,           0.08357,           0.00155,
           0.04363,          -0.00201,

          -0.01996,          -0.01341,

          -0.00039,          -0.00042,

          -0.00294,           0.00070,

           0.00005,          -0.00027,

           0.00070,          -0.00076,

           0.00234,          -0.00239,

          -0.08365,          -0.08531,          -0.03531,           0.15012,

          -0.01995,          -0.01731,          -0.00370,          -0.00745,

          -0.00315,          -0.00079,

          -0.00120,          -0.00145,

          -0.99404,          -1.31859,           0.03584,          -0.83421,
           0.10720,          -0.05768,

           0.06664,          -0.09338,

          -0.01814,          -0.00003,

          -0.05371,          -0.06458,          -0.00100,          -0.01298,

          -7.08710,         -23.13374,           4.18669,         -19.94756,
           4.85584,          -3.37187,           0.58851,           0.31363,

           0.01994,           0.27494,

          -1.37112,           2.61742,           0.52477,          -0.46520,

          -0.13183,           0.26777,

         836.90400,        -484.65861,         815.99098,         236.54649,
         -32.38814,         288.95705,         -68.17178,         -18.87875,

          -1.79782,          -3.68662,          -1.27310,          -0.65697,

          -3.67530,           2.10471,

      -13758.97795,        4807.62301,      -14582.14552,        9019.73021,
       -3202.60105,        4570.16895,        2078.68911,        2892.62326,
       -2399.35382,        3253.16198,       -8182.38152,       -3588.77680,

          -0.16505,           1.08603,           0.53388,           0.87152,

          61.53677,         538.43813,        -407.32927,         322.27446,
        -148.71585,        -179.37765,          54.07268,         -34.12281,

         -14.76569,         -17.95681,         -10.82061,          -6.39954,
          -2.10954,           0.67063,           0.22607,          -0.43648,

          20.90476,         -45.48667,          30.39436,         -14.20077,
           5.17385,           5.12726,          -0.66319,           0.55668,

           0.02269,          -0.00016,

           0.07811,           0.00111,           0.01603,           0.01020,

          -0.00107,           0.00494,

          -0.00077,          -0.00084,

          -0.00196,           0.00081,

          -0.03776,           0.01286,          -0.00652,          -0.01450,

           0.05942,          -0.08612,           0.01093,          -0.01644,

           0.02147,          -0.00592,

           0.36350,          -0.00201,           0.14419,          -0.10070,
          -0.00491,          -0.01771,

          -0.00053,          -0.00033,

           0.00146,           0.00048,

           0.00582,           0.04423,          -0.00549,           0.00983,

           0.27355,          -0.38057,           0.24001,          -0.05441,
          -0.07706,           0.14269,

          -0.00059,          -0.00154,

          -0.00013,          -0.00088,

          -0.00046,           0.00029,

          -0.00276,          -0.00507,           0.00075,          -0.00076,

           0.01806,           0.00862,          -0.00510,          -0.01364,

          -0.00029,          -0.12664,           0.03899,          -0.03562,
           0.00318,           0.00514,

           0.00057,           0.00201,

           0.00028,           0.00014,

          -0.47022,          -0.74561,           0.40155,          -0.16471,
          -0.18445,           0.34425,          -0.07464,          -0.13709,

          -0.01018,          -0.00748,

          -0.01210,          -0.04274,          -0.00579,          -0.00692,

         -11.09188,          -1.67755,          -6.62063,         -13.84023,
          12.75563,          -6.73501,           8.31662,           5.40196,

           0.00052,           0.00034,

           0.00128,           0.00085,

          -0.02202,          -0.00599,

          -0.33458,          -1.65852,           1.47003,          -1.02434,
           0.87885,           1.15334,

          -0.00241,          -0.00721,

           0.03154,           0.00612,

           0.00318,          -0.02521,

           0.00042,           0.00213,

          -0.01094,           0.05417,          -0.03989,          -0.00567,
           0.00123,          -0.00244,

           0.00108,           0.00242,

          -0.00138,          -0.00099,

           0.04967,           0.01643,          -0.00133,           0.02296,

           0.12207,           0.05584,

           0.00437,          -0.04432,          -0.00176,          -0.00922,

          -0.00252,           0.00326,

          -0.00020,          -0.00050,

          -0.00263,          -0.00084,

          -0.01971,           0.00297,

           0.03076,           0.01736,

          -0.01331,           0.01121,          -0.00675,           0.00340,

          -0.00256,           0.00327,

          -0.00946,           0.03377,          -0.00770,           0.00337,

           0.61383,           0.71128,          -0.02018,           0.62097,
          -0.07247,           0.04418,

          -0.02886,          -0.03848,

          -0.44062,           0.03973,

          -0.00999,          -0.04382,

          57.94459,         117.45112,         -71.22893,         126.39415,
         -62.33152,         -31.90754,          12.17738,         -16.46809,

          -1.13298,           0.08962,          -0.20532,           0.16320,

          -1.55110,          -1.44757,

       -3102.08749,       -7452.61957,       -5009.53858,       -7216.29165,
       -2476.87148,       -1880.58197,        -574.49433,         227.45615,
         144.50228,         379.15791,         225.36130,        -443.47371,

          -8.51989,          -3.75208,          -4.25415,          -1.59741,
          -0.43946,          -0.06595,

         150.42986,           6.54937,          87.67736,          92.32332,
         -21.97187,          29.87097,          -4.21636,          -5.72955,

          -0.03879,          -0.01071,

          -0.45985,           0.02679,          -0.02448,           0.02397,

          -0.06551,          -0.01154,

           1.97905,          -0.82292,           1.10140,           0.30924,
           0.03389,           0.14230,

           0.00003,           0.00119,

          -0.01117,           0.00665,

          -0.00132,          -0.00576,

          -0.08356,           0.08556,          -0.26362,          -0.12450,

           0.00509,           0.00165,

           0.02591,           0.16200,          -0.03318,           0.06463,
          -0.00899,          -0.00462,

           0.00102,           0.00004,

          -0.73102,           0.08299,          -0.52957,          -0.35744,
           0.14119,          -0.24903,           0.20843,           0.14143,

           0.00031,          -0.00234,

          -0.42643,          -2.02084,           1.58848,          -1.57963,
           0.68418,           2.07749,

          -0.45888,           0.19859,          -0.30277,          -0.22591,
           0.11607,          -0.09705,

           0.00040,           0.00431,

          -0.02683,           0.03158,          -0.01302,          -0.00541,
           0.01742,          -0.00006,

          -0.02231,          -0.01128,

          -0.00800,           0.02055,

          -0.00346,           0.00151,

           0.56732,          -0.68995,           0.27701,          -0.16748,
           0.01002,           0.00043,

           0.26916,          -0.57751,           0.15547,          -0.15825,
          -0.02074,          -0.07722,

          -8.23483,          -4.02022,           0.69327,          -5.91543,
           1.72440,           1.02090,

           0.00024,          -0.00053,

          20.03959,          14.79136,          76.43531,         -14.42019,
          -7.82608,         -69.96121,         -54.94229,          23.55140,
          26.60767,          14.68275,

           0.05118,          -0.10401,          -0.00075,          -0.01942,

          -3.84266,         -26.23442,          10.20395,         -14.77139,
           3.40853,           2.07297,          -0.53348,           0.40635,

           0.00716,          -0.00189,

           0.12472,          -0.02903,           0.02254,          -0.00183,

          -0.00175,          -0.01522,           0.00003,          -0.00339,

           0.00383,          -0.00168,

           0.01327,          -0.03657,

          -0.08458,          -0.00115,          -0.03991,          -0.02629,
           0.00243,          -0.00505,

           0.33875,          -0.16744,           0.05183,           0.01744,
          -0.24427,           0.15271,

           0.37550,          -0.17378,           0.09198,          -0.27966,
          -0.22160,           0.16426,

           0.00032,          -0.00310,

          -0.00022,          -0.00144,

          -0.06170,          -0.01195,          -0.00918,           0.02538,
           0.03602,           0.03414,

          -0.14998,          -0.44351,           0.45512,          -0.11766,
           0.35638,           0.27539,

           5.93405,          10.55777,          12.42596,          -1.82530,
          -2.36124,          -6.04176,          -0.98609,           1.67652,

          -0.09271,           0.03448,          -0.01951,           0.00108,

           0.33862,           0.21461,           0.02564,           0.06924,

           0.01126,          -0.01168,          -0.00829,          -0.00740,
           0.00106,          -0.00854,

          -0.08404,           0.02508,          -0.02722,          -0.06537,

           0.01662,           0.11454,           0.06747,           0.00742,
          -0.01975,          -0.02597,

          -0.00097,          -0.01154,           0.00164,          -0.00274,

           0.02954,          -0.05161,          -0.02162,          -0.02069,
          -0.06369,           0.03846,

           0.00219,          -0.01634,          -0.04518,           0.06696,

           1.21537,           0.99500,           0.68376,          -0.28709,
          -0.11397,          -0.06468,

           0.00607,          -0.00744,           0.01531,           0.00975,

          -0.03983,           0.02405,           0.07563,           0.00356,

          -0.00018,          -0.00009,

           0.00172,          -0.00331,

           0.01565,          -0.03466,          -0.00230,           0.00142,
          -0.00788,          -0.01019,

           0.01411,          -0.01456,          -0.00672,          -0.00543,

           0.00059,          -0.00011,

          -0.00661,          -0.00496,          -0.01986,           0.01271,

          -0.01323,          -0.00764,           0.00041,           0.01145,

           0.00378,          -0.00137,           0.00652,           0.00412,

           0.01946,          -0.00573,

          -0.00326,          -0.00257,

          -0.00225,           0.00090,

          -0.00292,          -0.00317,          -0.00719,           0.00468,

           0.00245,           0.00189,

           0.00565,          -0.00330,

          -0.00168,          -0.00047,

          -0.00256,           0.00220,

           0.00180,          -0.00162,

          -0.00085,          -0.00003,

          -0.00100,           0.00098,

          -0.00043,           0.00007,

          -0.00003,          -0.00013,

};
static double tabrst[] = {
      -38127.94034,      -48221.08524,      -20986.93487,       -3422.75861,
          -8.97362,          53.34259,        -404.15708,          -0.05434,

           0.46327,           0.16968,

        -387.16771,        -146.07622,         103.77956,          19.11054,
         -40.21762,         996.16803,        -702.22737,         246.36496,
         -63.89626,        -304.82756,          78.23653,          -2.58314,

          -0.11368,          -0.06541,

          -0.34321,           0.33039,

           0.05652,          -0.16493,

          67.44536,         -29.43578,          50.85074,          18.68861,
           0.39742,          13.64587,          -1.61284,           0.11482,

           0.01668,          -0.01182,

          -0.00386,           0.01025,

           0.00234,          -0.01530,

          -0.02569,          -0.00799,

          -0.00429,          -0.00217,

          -0.00672,           0.00650,

           0.01154,           0.00120,          -0.00515,           0.00125,

           0.00236,          -0.00216,

          -0.00098,           0.00009,

          -0.00460,          -0.00518,

           0.00600,           0.00003,

           0.00834,           0.00095,           0.01967,           0.00637,

          -0.00558,          -0.06911,

          -0.01344,          -0.06589,          -0.05425,          -0.00607,

          -0.00247,          -0.00266,

           0.08790,          -0.08537,          -0.00647,           0.04028,

          -0.00325,           0.00488,

           0.00111,          -0.00044,

          -0.00731,           0.00127,

          -0.00417,           0.00303,

           0.05261,           0.01858,

          -0.00807,           0.01195,

           1.26352,          -0.38591,          -0.34825,           1.10733,

          -0.02815,          -0.02148,

          -0.05083,          -0.04377,          -0.01206,          -0.00586,

           0.03158,          -0.01117,           0.00643,           0.00306,

          -0.01186,          -0.05161,           0.01136,          -0.00976,

          -0.00536,           0.01949,

          -1.41680,          -0.81290,          -0.09254,          -0.24347,
          -0.14831,          -0.34381,

          -2.44464,           0.41202,          -0.99240,          -0.33707,
          -0.01930,          -0.08473,

           0.00830,           0.01165,

          -0.01604,          -0.02439,

           0.00227,           0.04493,

         -42.75310,         -22.65155,          -9.93679,         -18.36179,
           2.73773,           3.24126,          -1.20698,           1.07731,

           0.00434,          -0.10360,

          -0.02359,           0.00054,

          -0.02664,          -0.00122,

         -19.79520,          33.11770,         -53.56452,         -35.41902,
          67.95039,         -82.46551,         117.31843,          14.08609,

           0.06447,           0.03289,

           0.40365,          -0.33397,           0.07079,          -0.09504,

         -30.36873,           6.23538,         -14.25988,         -44.91408,
          38.53146,         -16.31919,           6.99584,          22.47169,

          -0.13313,           0.28016,

           6.83715,          -6.01384,           1.68531,          -3.62443,
          -0.22469,          -0.29718,

           0.25169,           0.13780,

          -3.64824,           1.22420,          -2.48963,          -1.12515,
          -0.01510,          -0.56180,

          -0.03306,           0.01848,          -0.00103,          -0.00077,

          -0.01681,          -0.00227,

          -0.00402,          -0.00287,

           0.04965,          -0.16190,          -0.40025,           0.20734,
           0.15819,          -0.25451,

           0.02467,          -0.00495,

           0.00597,           0.00490,

          -0.01085,          -0.00460,

          -0.71564,          -0.26624,           0.03797,          -0.28263,
           0.03510,           0.30014,

           2.79810,           0.07258,

          -0.01618,           0.00337,

           0.00876,           0.04438,

           0.00742,          -0.00455,

          -0.01163,          -0.00683,

           0.00950,           0.01275,

          -0.02124,          -0.67527,          -0.23635,           0.06298,

          -0.03844,           0.01010,           0.73588,          -0.00271,

           0.01742,          -0.00467,

           0.00017,          -0.00505,

          -0.27482,           5.00521,          -1.92099,           1.55295,
          -0.35919,          -0.09314,

          -0.47002,           0.06826,

           0.07924,           0.16838,

          -0.04221,           0.71510,          -0.16482,           0.08809,

          41.76829,        -125.79427,         106.65271,         -71.30642,
          36.18112,          17.36143,          -1.63846,           5.02215,

          -1.08404,           0.00061,

           2.45567,          -2.42818,          -9.88756,           5.36587,

          -0.61253,          -0.35003,

        1523.54790,         602.82184,          68.66902,        1878.26100,
       -1098.78095,        -120.72600,         127.30918,        -383.96064,

          -7.00838,          -6.09942,          -1.54187,           0.34883,

          -9.47561,          -4.35408,

      -21541.63676,      -32542.09807,      -29720.82604,      -28072.21231,
      -15755.56255,       -8084.58657,       -8148.87315,        7434.89857,
       11033.30133,        7827.94658,         610.18256,      -11411.93624,

          -9.87426,           0.94865,          -1.63656,           0.41275,

        1996.57150,         511.48468,         669.78228,        1363.67610,
        -379.72037,         198.84438,         -16.63126,         -79.37624,

          -2.30776,        -246.07820,         -16.85846,        -148.18168,
          -6.89632,         -20.49587,           0.39892,          -0.34627,

         -57.81309,        -136.96971,          15.25671,         -96.61153,
          16.09785,          -8.79091,           0.70515,           1.16197,

           0.05647,           0.04684,

           0.25032,          -0.19951,           0.07282,          -0.00696,

           0.00493,           0.00733,

          -0.01085,           0.00422,

          -0.01309,           0.00262,

           0.37616,          -0.36203,          -0.11154,           0.18213,

           0.15691,           0.29343,           0.00485,           0.06106,

          -0.01492,           0.09954,

           0.28486,           2.27190,           0.33102,           1.50696,
          -0.01926,           0.04901,

           0.01827,           0.00863,

          -0.03315,           0.00178,

          -0.77600,          -0.48576,          -0.21111,          -0.19485,

           1.90295,           6.44856,           1.71638,           2.12980,
          -7.19585,          -0.08043,

           0.07004,          -0.02764,

           0.01604,           0.01158,

           0.00936,          -0.01199,

           0.18396,          -0.29234,           0.10422,          -0.00720,

           0.05196,           0.10753,           0.02859,          -0.03602,

           0.63828,           1.96280,          -0.31919,           0.85859,
          -0.10218,          -0.00673,

           0.01748,          -0.02190,

           0.01266,          -0.02729,

          -4.80220,           8.90557,          -5.94059,           2.28577,
          -0.19687,          -1.28666,           0.32398,           0.14879,

          -0.02619,          -0.02056,

          -0.04872,          -0.07011,          -0.04082,          -0.04740,

           0.60167,          -2.20365,          -0.27919,          -0.45957,
          -1.31664,          -2.22682,         176.89871,          13.03918,

           0.00568,           0.00560,

           0.01093,           0.00486,

          -0.00948,          -0.31272,

         -11.87638,          -3.68471,          -1.74977,          -9.60468,
           2.94988,          -0.57118,

           0.00307,          -0.01636,

           0.02624,           0.03032,

          -0.00464,          -0.01338,

           0.00935,           0.00530,

          -0.11822,           0.03328,          -0.41854,           0.04331,
           0.41340,          -0.21657,

          -0.00865,           0.00849,

          -0.00374,          -0.00899,

           0.01227,          -0.23462,          -0.71894,          -0.04515,

           0.00047,           0.28112,

          -0.12788,           0.11698,          -0.02030,           0.02759,

           0.02967,          -0.00092,

           0.00454,           0.00565,

          -0.00026,           0.00164,

          -0.01405,          -0.00862,

           0.01088,           0.05589,

           0.18248,          -0.06931,          -0.00011,           0.03713,

           0.01932,          -0.00982,

          -0.13861,           0.09853,          -0.03441,          -0.02492,

           2.26163,          -5.94453,           4.14361,          -0.94105,
           0.39561,           0.75414,

          -0.17642,           0.03724,

          -1.32978,          -0.56610,

          -0.03259,          -0.06752,

          39.07495,          80.25429,         -28.15558,          82.69851,
         -37.53894,         -17.88963,           6.98299,         -13.04691,

          -0.48675,          -1.84530,          -0.07985,          -0.33004,

          -3.39292,           2.73153,

      -17268.46134,        1144.22336,      -16658.48585,        5252.94094,
       -3461.47865,        2910.56452,        -433.49442,        -305.74268,
        -383.45023,         545.16136,         313.83376,          27.00533,

         -31.41075,           7.90570,         -12.40592,           3.01833,
          -0.83334,           0.23404,

          59.26487,        -112.74279,         113.29402,         -15.37579,
          14.03282,          32.74482,          -4.73299,           1.30224,

          -0.00866,           0.01232,

          -0.53797,           0.00238,          -0.07979,           0.04443,

          -0.05617,          -0.05396,

           0.10185,          -1.05476,           0.43791,          -0.32302,
           0.06465,           0.03815,

           0.00028,          -0.00446,

           0.09289,          -0.06389,

           0.01701,          -0.01409,

           0.47101,           0.16158,           0.01036,          -0.39836,

           0.00477,           0.01101,

          -2.06535,           0.33197,          -0.82468,          -0.41414,
           0.03209,          -0.09348,

           0.00843,          -0.00030,

          -9.49517,          -3.82206,           0.66899,         -10.28786,
           6.33435,           1.73684,          -0.98164,           2.25164,

          -0.07577,          -0.00277,

           1.02122,           0.75747,           1.79155,          -0.77789,
          -2.56780,          -2.07807,

           0.19528,           0.77118,          -0.28083,           0.32130,
          -0.04350,          -0.07428,

          -0.01161,           0.01387,

           0.02074,           0.19802,          -0.03600,           0.04922,
          -0.19837,           0.02572,

          -0.00682,          -0.04277,

          -0.01805,           0.00299,

           0.03283,          -0.02099,

           3.57307,           1.17468,           0.65769,           1.88181,
          -0.39215,           0.08415,

          -0.53635,          -0.19087,          -0.12456,           0.02176,
           0.01182,          -0.07941,

          -2.43731,           2.44464,           1.03961,          -1.81936,
          30.33140,           0.92645,

           0.00508,          -0.01771,

         -81.06338,          66.43957,          33.16729,         131.44697,
          76.63344,         -34.34324,         -35.33012,         -28.04413,
          -1.47440,          13.09015,

           0.13253,          -0.01629,           0.02187,          -0.00963,

         -21.47470,          -9.44332,          -7.21711,         -12.59472,
           1.76195,          -1.63911,           0.09060,           0.28656,

           0.00635,           0.00536,

           0.03470,          -0.06493,           0.00666,          -0.01084,

           0.01116,          -0.01612,          -0.00102,           0.00208,

          -0.05568,           0.00628,

           0.02665,          -0.01032,

           0.21261,          -1.90651,           0.72728,          -0.57788,
           0.08662,           0.10918,

           3.39133,           3.97302,          -4.63381,           4.26670,
          -2.50873,          -3.76064,

           1.28114,           1.81919,           1.48064,          -0.37578,
          -0.26209,          -0.47187,

           0.00282,          -0.00499,

           0.01749,           0.03222,

           1.60521,          -1.79705,           1.61453,           0.68886,
          -0.29909,           0.55025,

          -0.07894,           0.19880,          -0.15635,           0.46159,
           2.09769,           1.52742,

          -7.60312,          11.34886,           4.35640,           8.61048,
           2.15001,          -2.15303,          -0.61587,          -0.11950,

          -0.03289,          -0.00520,          -0.00501,          -0.00445,

           0.15294,          -0.05277,           0.02455,           0.00408,

           1.19601,           0.43479,           0.20422,           0.57125,
          -0.12790,           0.01318,

          -0.15275,          -0.43856,           6.99144,          -0.08794,

          -1.69865,           0.82589,          -0.20235,           0.97040,
           0.20903,           0.00675,

           0.26943,           0.08281,           0.03686,           0.05311,

           1.28468,           1.21735,          -1.38174,           1.29570,
          -0.75899,          -1.17168,

           0.44696,          -0.32341,          -0.06378,          -0.27573,

          -0.06406,           0.87186,           0.21069,           0.19724,
           0.00119,          -0.04147,

           0.39279,           0.51437,          -0.11035,           0.21450,

          -0.04309,           0.02359,           0.20490,           0.14210,

           0.00007,          -0.00017,

          -0.03529,          -0.02644,

           0.10710,           0.44476,          -0.02632,          -0.01817,
           2.11335,          -0.04432,

           0.18206,           0.27335,           0.08867,           0.00313,

          -0.00692,           0.01595,

          -0.72957,           0.32080,          -0.29291,          -0.44764,

           0.12767,          -0.05778,           0.04797,          -0.00223,

           0.17661,           0.22427,          -0.04914,           0.09114,

           0.12236,           0.00708,

           0.74315,          -0.01346,

           0.02245,          -0.02555,

          -0.30446,           0.13947,          -0.12340,          -0.18498,

          -0.04099,           0.02103,

           0.06337,          -0.01224,

           0.28181,          -0.01019,

          -0.02794,          -0.09412,

           0.03272,          -0.01095,

           0.11247,          -0.00650,

          -0.01319,          -0.04296,

           0.04653,          -0.00423,

           0.06535,           0.00014,

};

static char argsst[] = {
  0,  7,
  3,  2,  5, -6,  6,  3,  7,  0,
  2,  2,  5, -5,  6,  5,
  3,  1,  6, -4,  7,  2,  8,  0,
  2,  1,  6, -3,  7,  0,
  3,  1,  6, -2,  7, -2,  8,  0,
  2,  4,  5,-10,  6,  3,
  3,  1,  5, -1,  6, -4,  7,  0,
  3,  2,  5, -4,  6, -3,  7,  0,
  3,  2,  6, -8,  7,  4,  8,  0,
  3,  3,  5,-10,  6,  7,  7,  0,
  2,  6,  5,-15,  6,  0,
  2,  2,  6, -6,  7,  0,
  3,  1,  5, -4,  6,  4,  7,  1,
  3,  1,  5, -2,  6, -1,  7,  0,
  3,  2,  5, -5,  6,  1,  8,  0,
  3,  3,  5, -8,  6,  2,  7,  0,
  3,  1,  5, -3,  6,  2,  8,  0,
  3,  1,  5, -3,  6,  1,  7,  1,
  1,  1,  8,  0,
  3,  1,  5, -3,  6,  2,  7,  1,
  3,  1,  5, -2,  6, -2,  7,  0,
  2,  2,  6, -5,  7,  1,
  3,  2,  6, -6,  7,  2,  8,  0,
  3,  2,  6, -7,  7,  4,  8,  0,
  3,  2,  5, -4,  6, -2,  7,  0,
  3,  1,  5, -1,  6, -5,  7,  0,
  3,  2,  6, -7,  7,  5,  8,  0,
  3,  1,  6, -1,  7, -2,  8,  0,
  2,  1,  6, -2,  7,  1,
  3,  1,  6, -3,  7,  2,  8,  0,
  3,  1,  6, -4,  7,  4,  8,  1,
  3,  2,  5, -5,  6,  2,  8,  1,
  3,  2,  5, -6,  6,  2,  7,  1,
  2,  2,  7, -2,  8,  0,
  1,  1,  7,  2,
  2,  5,  5,-12,  6,  2,
  3,  2,  6, -5,  7,  1,  8,  0,
  3,  1,  5, -1,  6, -3,  7,  0,
  3,  7,  5,-18,  6,  3,  7,  0,
  2,  3,  5, -7,  6,  3,
  3,  1,  6,  1,  7, -5,  8,  0,
  3,  1,  5, -4,  6,  3,  7,  0,
  3,  5,  5,-13,  6,  3,  7,  0,
  2,  1,  5, -2,  6,  3,
  3,  3,  5, -9,  6,  3,  7,  0,
  3,  3,  5, -8,  6,  3,  7,  1,
  2,  1,  5, -3,  6,  3,
  3,  5,  5,-14,  6,  3,  7,  0,
  3,  1,  5, -3,  6,  3,  7,  2,
  2,  3,  6, -7,  7,  0,
  2,  3,  5, -8,  6,  2,
  3,  2,  5, -3,  6, -4,  7,  1,
  3,  2,  5, -8,  6,  7,  7,  0,
  2,  5,  5,-13,  6,  0,
  2,  2,  6, -4,  7,  2,
  3,  2,  6, -5,  7,  2,  8,  0,
  3,  2,  5, -4,  6, -1,  7,  0,
  3,  2,  5, -7,  6,  4,  7,  0,
  2,  1,  6, -2,  8,  2,
  2,  1,  6, -1,  7,  0,
  3,  1,  6, -2,  7,  2,  8,  0,
  3,  2,  5, -5,  6,  2,  7,  0,
  3,  2,  5, -6,  6,  2,  8,  0,
  3,  2,  5, -6,  6,  1,  7,  0,
  2,  3,  7, -2,  8,  0,
  1,  2,  7,  1,
  2,  1,  6, -1,  8,  1,
  3,  1,  5, -2,  6,  1,  7,  0,
  3,  1,  5, -2,  6,  2,  8,  0,
  2,  3,  6, -6,  7,  2,
  2,  6,  5,-14,  6,  0,
  3,  3,  6, -7,  7,  2,  8,  0,
  3,  2,  5, -3,  6, -3,  7,  1,
  2,  4,  5, -9,  6,  3,
  3,  2,  6, -2,  7, -2,  8,  0,
  2,  2,  6, -3,  7,  1,
  3,  2,  6, -4,  7,  2,  8,  0,
  2,  2,  5, -4,  6,  3,
  3,  2,  5, -7,  6,  3,  7,  1,
  3,  1,  6,  1,  7, -2,  8,  0,
  1,  1,  6,  5,
  3,  2,  5, -5,  6,  3,  7,  1,
  2,  2,  5, -6,  6,  3,
  1,  3,  7,  3,
  2,  4,  5,-11,  6,  3,
  2,  1,  5, -4,  7,  0,
  3,  2,  5, -5,  6, -3,  7,  1,
  2,  6,  5,-16,  6,  0,
  3,  3,  5, -7,  6,  2,  7,  0,
  3,  3,  6, -4,  7, -2,  8,  0,
  2,  3,  6, -5,  7,  1,
  3,  3,  6, -6,  7,  2,  8,  1,
  3,  3,  6, -7,  7,  4,  8,  0,
  3,  2,  5, -3,  6, -2,  7,  2,
  3,  2,  5, -8,  6,  5,  7,  0,
  2,  2,  6, -4,  8,  0,
  3,  2,  6, -1,  7, -2,  8,  1,
  2,  2,  6, -2,  7,  2,
  3,  2,  6, -3,  7,  2,  8,  0,
  3,  2,  5, -4,  6,  1,  7,  0,
  3,  2,  5, -4,  6,  2,  8,  0,
  3,  2,  5, -7,  6,  2,  7,  1,
  2,  1,  6,  1,  7,  1,
  2,  5,  5,-11,  6,  2,
  3,  1,  5, -2,  7, -2,  8,  0,
  2,  1,  5, -3,  7,  0,
  2,  3,  5, -6,  6,  3,
  3,  2,  6,  1,  7, -5,  8,  0,
  2,  2,  6, -3,  8,  1,
  2,  1,  5, -1,  6,  3,
  3,  2,  5, -7,  6,  3,  8,  0,
  3,  3,  5, -7,  6,  3,  7,  0,
  3,  2,  5, -1,  6, -7,  7,  0,
  2,  1,  5, -4,  6,  2,
  3,  1,  5, -2,  6,  3,  7,  0,
  2,  4,  6, -7,  7,  0,
  2,  3,  5, -9,  6,  0,
  3,  2,  5, -2,  6, -4,  7,  0,
  2,  3,  6, -4,  7,  2,
  3,  2,  5, -3,  6, -1,  7,  0,
  3,  2,  5, -8,  6,  4,  7,  0,
  2,  2,  6, -2,  8,  1,
  2,  2,  6, -1,  7,  0,
  3,  2,  6, -2,  7,  2,  8,  1,
  3,  2,  5, -4,  6,  2,  7,  0,
  3,  2,  5, -7,  6,  2,  8,  0,
  3,  2,  5, -7,  6,  1,  7,  0,
  2,  1,  6,  2,  7,  0,
  2,  2,  6, -1,  8,  0,
  2,  4,  6, -6,  7,  1,
  2,  6,  5,-13,  6,  0,
  3,  2,  5, -2,  6, -3,  7,  1,
  2,  4,  5, -8,  6,  2,
  3,  3,  6, -2,  7, -2,  8,  0,
  2,  3,  6, -3,  7,  0,
  3,  3,  6, -4,  7,  2,  8,  0,
  2,  2,  5, -3,  6,  3,
  3,  2,  5, -8,  6,  3,  7,  1,
  3,  2,  6,  1,  7, -2,  8,  0,
  1,  2,  6,  5,
  3,  2,  5, -4,  6,  3,  7,  2,
  2,  2,  5, -7,  6,  3,
  3,  1,  6,  4,  7, -2,  8,  0,
  2,  1,  6,  3,  7,  1,
  3,  1,  6,  2,  7,  2,  8,  0,
  2,  4,  5,-12,  6,  2,
  2,  5,  6, -8,  7,  0,
  2,  4,  6, -5,  7,  0,
  3,  2,  5, -2,  6, -2,  7,  0,
  2,  3,  6, -2,  7,  1,
  3,  3,  6, -3,  7,  2,  8,  0,
  2,  5,  5,-10,  6,  2,
  3,  1,  5,  1,  6, -3,  7,  0,
  2,  3,  5, -5,  6,  3,
  2,  3,  6, -3,  8,  0,
  1,  1,  5,  2,
  2,  1,  5, -5,  6,  2,
  2,  5,  6, -7,  7,  0,
  2,  4,  6, -4,  7,  2,
  2,  3,  6, -2,  8,  0,
  2,  3,  6, -1,  7,  0,
  2,  5,  6, -6,  7,  0,
  2,  4,  5, -7,  6,  2,
  2,  4,  6, -3,  7,  2,
  2,  2,  5, -2,  6,  2,
  3,  2,  6, -9,  7,  3,  8,  0,
  1,  3,  6,  4,
  3,  2,  5, -3,  6,  3,  7,  1,
  2,  2,  5, -8,  6,  3,
  3,  2,  6,  4,  7, -2,  8,  0,
  2,  4,  5,-13,  6,  1,
  2,  6,  6, -8,  7,  1,
  2,  5,  6, -5,  7,  0,
  2,  4,  6, -2,  7,  0,
  2,  5,  5, -9,  6,  2,
  2,  3,  5, -4,  6,  2,
  2,  1,  5,  1,  6,  2,
  2,  6,  5,-11,  6,  0,
  3,  6,  6, -7,  7,  2,  8,  0,
  2,  4,  5, -6,  6,  2,
  2,  2,  5, -1,  6,  2,
  1,  4,  6,  3,
  3,  2,  5, -2,  6,  3,  7,  1,
  2,  2,  5, -9,  6,  1,
  2,  5,  5, -8,  6,  2,
  2,  3,  5, -3,  6,  1,
  2,  1,  5,  2,  6,  2,
  2,  6,  5,-10,  6,  1,
  2,  4,  5, -5,  6,  2,
  1,  2,  5,  1,
  1,  5,  6,  2,
  2,  5,  5, -7,  6,  1,
  2,  3,  5, -2,  6,  1,
  3,  1,  5,  2,  6,  3,  7,  0,
  2,  6,  5, -9,  6,  0,
  2,  4,  5, -4,  6,  2,
  2,  2,  5,  1,  6,  1,
  2,  7,  5,-11,  6,  0,
  2,  5,  5, -6,  6,  1,
  2,  3,  5, -1,  6,  1,
  2,  6,  5, -8,  6,  1,
  2,  4,  5, -3,  6,  0,
  2,  5,  5, -5,  6,  0,
  1,  3,  5,  0,
  2,  6,  5, -7,  6,  1,
  2,  7,  5, -9,  6,  0,
  2,  5,  5, -4,  6,  0,
  2,  6,  5, -6,  6,  0,
  2,  7,  5, -8,  6,  0,
  2,  6,  5, -5,  6,  0,
  2,  7,  5, -7,  6,  0,
  2,  8,  5, -9,  6,  0,
  2,  8,  5, -8,  6,  0,
  2,  1,  3, -1,  6,  0,
 -1
};
#endif
