/* Rzwrapper.c generated by valac 0.28.1, the Vala compiler
 * generated from Rzwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the rz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>


#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

struct _moserialRzwrapperPrivate {
	moserialRzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _path;
	gchar* _filename;
};


static gpointer moserial_rzwrapper_parent_class = NULL;

GType moserial_rzwrapper_get_type (void) G_GNUC_CONST;
GType moserial_rzwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_RZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperPrivate))
enum  {
	MOSERIAL_RZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_RZWRAPPER_PROTOCOL,
	MOSERIAL_RZWRAPPER_SC,
	MOSERIAL_RZWRAPPER_PATH,
	MOSERIAL_RZWRAPPER_FILENAME
};
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
static void moserial_rzwrapper_shutdown (moserialRzwrapper* self);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self);
moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self);
static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value);
static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self);
static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value);
const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self);
static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value);
static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_rzwrapper_finalize (GObject* obj);
static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_RZWRAPPER_ProtocolStrings[3] = {"Xmodem", "Ymodem", "Zmodem"};

GType moserial_rzwrapper_protocol_get_type (void) {
	static volatile gsize moserial_rzwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_NULL, "MOSERIAL_RZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_rzwrapper_protocol_type_id;
		moserial_rzwrapper_protocol_type_id = g_enum_register_static ("moserialRzwrapperProtocol", values);
		g_once_init_leave (&moserial_rzwrapper_protocol_type_id__volatile, moserial_rzwrapper_protocol_type_id);
	}
	return moserial_rzwrapper_protocol_type_id__volatile;
}


moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	moserialRzwrapper * self = NULL;
	moserialRzwrapperProtocol pro = 0;
	moserialRzwrapperProtocol* _tmp0_ = NULL;
	moserialSerialConnection* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = protocol;
	pro = *_tmp0_;
	_tmp1_ = sc;
	_tmp2_ = p;
	_tmp3_ = filename;
	self = (moserialRzwrapper*) g_object_new (object_type, "protocol", pro, "sc", _tmp1_, "path", _tmp2_, "filename", _tmp3_, NULL);
	return self;
}


moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	return moserial_rzwrapper_construct (MOSERIAL_TYPE_RZWRAPPER, protocol, sc, p, filename);
}


void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gsize bytesWritten = 0UL;
		gchar* b = NULL;
		gchar* _tmp1_ = NULL;
		gint b_length1 = 0;
		gint _b_size_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		guchar _tmp3_ = '\0';
		gchar _tmp4_ = '\0';
		_tmp1_ = g_new0 (gchar, 1);
		b = _tmp1_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		_tmp3_ = byte;
		_tmp2_[0] = (gchar) _tmp3_;
		_tmp4_ = _tmp2_[0];
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = self->running;
			if (_tmp5_) {
				GIOChannel* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gsize _tmp8_ = 0UL;
				_tmp6_ = self->priv->IOChannelInput;
				_tmp7_ = b;
				_tmp7__length1 = b_length1;
				g_io_channel_write_chars (_tmp6_, _tmp7_, _tmp7__length1, &_tmp8_, &_inner_error_);
				bytesWritten = _tmp8_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch14_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch14_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally14;
		__catch14_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "writeChar() %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		goto __finally14;
		__catch14_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = stdout;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp12_, "%s\n", _tmp14_);
			_g_error_free0 (e);
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


void moserial_rzwrapper_flush (moserialRzwrapper* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->running;
			if (_tmp1_) {
				GIOChannel* _tmp2_ = NULL;
				_tmp2_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp2_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch15_g_io_channel_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally15;
		__catch15_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp3_ = stdout;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			fprintf (_tmp3_, "flush() %s\n", _tmp5_);
			_g_error_free0 (e);
		}
		__finally15:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gchar* m_buf = NULL;
		gchar* _tmp1_ = NULL;
		gint m_buf_length1 = 0;
		gint _m_buf_size_ = 0;
		gchar* message = NULL;
		gchar* _tmp2_ = NULL;
		gchar* messages = NULL;
		gchar* _tmp3_ = NULL;
		gsize bytesRead = 0UL;
		GIOCondition _tmp4_ = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		const gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		_tmp1_ = g_new0 (gchar, 1000);
		m_buf = _tmp1_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp2_ = g_strdup ("");
		message = _tmp2_;
		_tmp3_ = g_strdup ("");
		messages = _tmp3_;
		bytesRead = (gsize) 0;
		_tmp4_ = condition;
		if (!(_tmp4_ == G_IO_IN)) {
			result = TRUE;
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gsize _tmp7_ = 0UL;
			_tmp5_ = source;
			_tmp6_ = m_buf;
			_tmp6__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp5_, _tmp6_, _tmp6__length1, &_tmp7_, &_inner_error_);
			bytesRead = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch16_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch16_g_io_channel_error;
				}
				_g_free0 (messages);
				_g_free0 (message);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally16;
		__catch16_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = stdout;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			fprintf (_tmp8_, "readError() %s\n", _tmp10_);
			_g_error_free0 (e);
		}
		goto __finally16;
		__catch16_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = stdout;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			fprintf (_tmp11_, "readError() %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		__finally16:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gint _tmp16_ = 0;
					gsize _tmp17_ = 0UL;
					gunichar c = 0U;
					gchar* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					gchar _tmp20_ = '\0';
					gboolean _tmp21_ = FALSE;
					gunichar _tmp22_ = 0U;
					gboolean _tmp23_ = FALSE;
					if (!_tmp14_) {
						gint _tmp15_ = 0;
						_tmp15_ = x;
						x = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = x;
					_tmp17_ = bytesRead;
					if (!(((gsize) _tmp16_) < _tmp17_)) {
						break;
					}
					_tmp18_ = m_buf;
					_tmp18__length1 = m_buf_length1;
					_tmp19_ = x;
					_tmp20_ = _tmp18_[_tmp19_];
					c = (gunichar) _tmp20_;
					_tmp22_ = c;
					_tmp23_ = g_unichar_isprint (_tmp22_);
					if (_tmp23_) {
						_tmp21_ = TRUE;
					} else {
						gunichar _tmp24_ = 0U;
						gboolean _tmp25_ = FALSE;
						_tmp24_ = c;
						_tmp25_ = g_unichar_isspace (_tmp24_);
						_tmp21_ = _tmp25_;
					}
					if (_tmp21_) {
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gint _tmp27__length1 = 0;
						gint _tmp28_ = 0;
						gchar _tmp29_ = '\0';
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						_tmp26_ = messages;
						_tmp27_ = m_buf;
						_tmp27__length1 = m_buf_length1;
						_tmp28_ = x;
						_tmp29_ = _tmp27_[_tmp28_];
						_tmp30_ = g_strdup_printf ("%c", (gint) _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strconcat (_tmp26_, _tmp31_, NULL);
						_g_free0 (messages);
						messages = _tmp32_;
						_g_free0 (_tmp31_);
					}
				}
			}
		}
		_tmp33_ = messages;
		_tmp34_ = mo_utils_getLastMessage (_tmp33_);
		_g_free0 (message);
		message = _tmp34_;
		_tmp35_ = message;
		if (!(g_strcmp0 (_tmp35_, "") == 0)) {
			const gchar* _tmp36_ = NULL;
			_tmp36_ = message;
			g_signal_emit_by_name (self, "update-status", _tmp36_);
		}
		_tmp37_ = messages;
		_tmp38_ = string_index_of (_tmp37_, "Transfer complete", 0);
		if (_tmp38_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		_tmp39_ = messages;
		_tmp40_ = string_index_of (_tmp39_, "Transfer incomplete", 0);
		if (_tmp40_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (messages);
		_g_free0 (message);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_shutdown_timeout ((moserialRzwrapper*) self);
	return result;
}


void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		g_signal_emit_by_name (self, "update-status", "canceled");
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_ = 0;
					moserialRzwrapperProtocol _tmp4_ = 0;
					if (!_tmp1_) {
						gint _tmp2_ = 0;
						_tmp2_ = x;
						x = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = x;
					if (!(_tmp3_ < 20)) {
						break;
					}
					_tmp4_ = self->priv->_protocol;
					if (_tmp4_ == MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM) {
						moserialSerialConnection* _tmp5_ = NULL;
						_tmp5_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp5_, (guchar) ('X' & 037));
						moserial_rzwrapper_writeChar (self, (guchar) ('X' & 037));
					} else {
						moserialSerialConnection* _tmp6_ = NULL;
						_tmp6_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp6_, (guchar) 0x18);
					}
				}
			}
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_rzwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_rzwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_rzwrapper_shutdown (moserialRzwrapper* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		GPid _tmp3_ = 0;
		self->running = FALSE;
		_tmp1_ = self->priv->outputChannelId;
		g_source_remove (_tmp1_);
		_tmp2_ = self->priv->errorChannelId;
		g_source_remove (_tmp2_);
		_tmp3_ = self->priv->pid;
		g_spawn_close_pid (_tmp3_);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gchar* m_buf = NULL;
		gchar* _tmp1_ = NULL;
		gint m_buf_length1 = 0;
		gint _m_buf_size_ = 0;
		gsize bytesRead = 0UL;
		GIOCondition _tmp2_ = 0;
		_tmp1_ = g_new0 (gchar, 1000);
		m_buf = _tmp1_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		_tmp2_ = condition;
		if (!(_tmp2_ == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gsize _tmp5_ = 0UL;
			_tmp3_ = source;
			_tmp4_ = m_buf;
			_tmp4__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
			bytesRead = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch17_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch17_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally17;
		__catch17_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = stdout;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "readBytes() %s\n", _tmp8_);
			_g_error_free0 (e);
		}
		goto __finally17;
		__catch17_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "readError() %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally17:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gint _tmp14_ = 0;
					gsize _tmp15_ = 0UL;
					moserialSerialConnection* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					gchar _tmp19_ = '\0';
					if (!_tmp12_) {
						gint _tmp13_ = 0;
						_tmp13_ = x;
						x = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = x;
					_tmp15_ = bytesRead;
					if (!(((gsize) _tmp14_) < _tmp15_)) {
						break;
					}
					_tmp16_ = self->priv->_sc;
					_tmp17_ = m_buf;
					_tmp17__length1 = m_buf_length1;
					_tmp18_ = x;
					_tmp19_ = _tmp17_[_tmp18_];
					moserial_serial_connection_sendByte (_tmp16_, (guchar) _tmp19_);
				}
			}
		}
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self) {
	moserialRzwrapperProtocol result;
	moserialRzwrapperProtocol _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value) {
	moserialRzwrapperProtocol _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_protocol = _tmp0_;
	g_object_notify ((GObject *) self, "protocol");
}


moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self) {
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value) {
	moserialSerialConnection* _tmp0_ = NULL;
	moserialSerialConnection* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_sc);
	self->priv->_sc = _tmp1_;
	g_object_notify ((GObject *) self, "sc");
}


const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_path);
	self->priv->_path = _tmp1_;
	g_object_notify ((GObject *) self, "path");
}


const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readBytes ((moserialRzwrapper*) self, source, condition);
	return result;
}


static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readError ((moserialRzwrapper*) self, source, condition);
	return result;
}


static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialRzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialRzwrapperProtocol _tmp1_ = 0;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_rzwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_RZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->priv->_path;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialRzwrapperProtocol _tmp3_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		moserialRzwrapperProtocol _tmp9_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		moserialRzwrapperProtocol _tmp22_ = 0;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp3_ = self->priv->_protocol;
		if (_tmp3_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp4_ = NULL;
			_tmp4_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp4_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
		} else {
			gchar** _tmp5_ = NULL;
			_tmp5_ = g_new0 (gchar*, 3 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp5_;
			argv_length1 = 3;
			_argv_size_ = argv_length1;
		}
		_tmp6_ = argv;
		_tmp6__length1 = argv_length1;
		_tmp7_ = g_strdup ("rz");
		_g_free0 (_tmp6_[0]);
		_tmp6_[0] = _tmp7_;
		_tmp8_ = _tmp6_[0];
		_tmp9_ = self->priv->_protocol;
		switch (_tmp9_) {
			case MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM:
			{
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp10_ = argv;
				_tmp10__length1 = argv_length1;
				_tmp11_ = g_strdup ("--xmodem");
				_g_free0 (_tmp10_[1]);
				_tmp10_[1] = _tmp11_;
				_tmp12_ = _tmp10_[1];
				break;
			}
			case MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM:
			{
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp13_ = argv;
				_tmp13__length1 = argv_length1;
				_tmp14_ = g_strdup ("--ymodem");
				_g_free0 (_tmp13_[1]);
				_tmp13_[1] = _tmp14_;
				_tmp15_ = _tmp13_[1];
				break;
			}
			default:
			case MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM:
			{
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp16_ = argv;
				_tmp16__length1 = argv_length1;
				_tmp17_ = g_strdup ("--zmodem");
				_g_free0 (_tmp16_[1]);
				_tmp16_[1] = _tmp17_;
				_tmp18_ = _tmp16_[1];
				break;
			}
		}
		_tmp19_ = argv;
		_tmp19__length1 = argv_length1;
		_tmp20_ = g_strdup ("-vv");
		_g_free0 (_tmp19_[2]);
		_tmp19_[2] = _tmp20_;
		_tmp21_ = _tmp19_[2];
		_tmp22_ = self->priv->_protocol;
		if (_tmp22_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			_tmp23_ = argv;
			_tmp23__length1 = argv_length1;
			_tmp24_ = self->priv->_filename;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (_tmp23_[3]);
			_tmp23_[3] = _tmp25_;
			_tmp26_ = _tmp23_[3];
		}
		{
			const gchar* _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			GPid _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			GIOChannel* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			GIOChannel* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			GIOChannel* _tmp38_ = NULL;
			GIOChannel* _tmp39_ = NULL;
			GIOChannel* _tmp40_ = NULL;
			GIOChannel* _tmp41_ = NULL;
			GIOChannel* _tmp42_ = NULL;
			GIOChannel* _tmp43_ = NULL;
			GIOChannel* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
			GIOChannel* _tmp46_ = NULL;
			guint _tmp47_ = 0U;
			_tmp27_ = self->priv->_path;
			_tmp28_ = argv;
			_tmp28__length1 = argv_length1;
			g_spawn_async_with_pipes (_tmp27_, _tmp28_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp29_, &_tmp30_, &_tmp31_, &_tmp32_, &_inner_error_);
			self->priv->pid = _tmp29_;
			input = _tmp30_;
			output = _tmp31_;
			_error_ = _tmp32_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp33_ = output;
			_tmp34_ = g_io_channel_unix_new (_tmp33_);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp34_;
			_tmp35_ = input;
			_tmp36_ = g_io_channel_unix_new (_tmp35_);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp36_;
			_tmp37_ = _error_;
			_tmp38_ = g_io_channel_unix_new (_tmp37_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp38_;
			_tmp39_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp39_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp40_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp40_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp41_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp41_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp42_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp42_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp43_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp43_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch18_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp44_ = self->priv->IOChannelOutput;
			_tmp45_ = g_io_add_watch (_tmp44_, G_IO_IN, _moserial_rzwrapper_readBytes_gio_func, self);
			self->priv->outputChannelId = _tmp45_;
			_tmp46_ = self->priv->IOChannelError;
			_tmp47_ = g_io_add_watch (_tmp46_, G_IO_IN, _moserial_rzwrapper_readError_gio_func, self);
			self->priv->errorChannelId = _tmp47_;
			self->running = TRUE;
		}
		goto __finally18;
		__catch18_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp48_ = NULL;
			GError* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			GtkMessageDialog* _tmp53_ = NULL;
			GtkMessageDialog* _tmp54_ = NULL;
			GtkMessageDialog* _tmp55_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			_tmp48_ = stdout;
			_tmp49_ = e;
			_tmp50_ = _tmp49_->message;
			fprintf (_tmp48_, "spawn error: %s\n", _tmp50_);
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			_tmp53_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp52_);
			g_object_ref_sink (_tmp53_);
			errorDialog = _tmp53_;
			_tmp54_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp54_);
			_tmp55_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp55_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally18;
		__catch18_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp56_ = NULL;
			GError* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp56_ = stdout;
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			fprintf (_tmp56_, "readError() %s\n", _tmp58_);
			_g_error_free0 (e);
		}
		__finally18:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_rzwrapper_class_init (moserialRzwrapperClass * klass) {
	moserial_rzwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_rzwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_rzwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_rzwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_rzwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_RZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_SC, g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_rzwrapper_instance_init (moserialRzwrapper * self) {
	self->priv = MOSERIAL_RZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_rzwrapper_finalize (GObject* obj) {
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_rzwrapper_parent_class)->finalize (obj);
}


GType moserial_rzwrapper_get_type (void) {
	static volatile gsize moserial_rzwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_rzwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRzwrapper), 0, (GInstanceInitFunc) moserial_rzwrapper_instance_init, NULL };
		GType moserial_rzwrapper_type_id;
		moserial_rzwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_rzwrapper_type_id__volatile, moserial_rzwrapper_type_id);
	}
	return moserial_rzwrapper_type_id__volatile;
}


static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_rzwrapper_get_protocol (self));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		g_value_set_object (value, moserial_rzwrapper_get_sc (self));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		g_value_set_string (value, moserial_rzwrapper_get_path (self));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_rzwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		moserial_rzwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		moserial_rzwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		moserial_rzwrapper_set_path (self, g_value_get_string (value));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		moserial_rzwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



