package org.apache.maven.plugins.war.stub;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

/**
 * Stub
 */
public class WarArtifactStub
    extends AbstractArtifactStub
{

    private String groupId;

    private String artifactId;

    private String classifier;

    private File file;

    public WarArtifactStub( String _basedir )
    {
        super( _basedir );
    }

    public String getType()
    {
        return "war";
    }

    public String getArtifactId()
    {
        if ( artifactId == null )
        {
            return "simple";
        }
        else
        {
            return artifactId;
        }
    }

    public void setArtifactId( String _artifactId )
    {
        artifactId = _artifactId;
    }


    public String getGroupId()
    {
        if ( groupId == null )
        {
            return "wartests";
        }
        else
        {
            return groupId;
        }
    }

    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    }

    public File getFile()
    {
        if ( file == null )
        {
            return new File( basedir, "/target/test-classes/unit/sample_wars/simple.war" );
        }
        else
        {
            return file;
        }
    }

    public void setFile( File _file )
    {
        file = _file;
    }

    public String getClassifier()
    {
        return classifier;
    }

    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    }

    public boolean hasClassifier()
    {
        return classifier != null;
    }
}
