/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.UUID;
import javax.sql.DataSource;

public class JdbcInterface {
    static Hashtable<String, DataSource> dst = null;
    boolean DEBUG = false;
    boolean CatisSchema = false;
    String Errmsg = "No error";
    Connection conn = null;
    DatabaseMetaData dbmd = null;
    Statement stmt = null;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;

    public JdbcInterface() {
        this(false);
    }

    public JdbcInterface(boolean b) {
        this.DEBUG = b;
    }

    protected void SetErrmsg(Exception e) {
        if (this.DEBUG) {
            System.out.println(e.getMessage());
        }
        this.Errmsg = e.toString();
    }

    public String GetErrmsg() {
        String err = this.Errmsg;
        this.Errmsg = "No error";
        return err;
    }

    protected void CheckURL(String url, String vendor) throws Exception {
        if (url == null) {
            throw new Exception("URL cannot be null");
        }
        String[] tk = url.split(":", 3);
        if (!tk[0].equals("jdbc") || tk[1] == null) {
            throw new Exception("Invalid URL");
        }
        if (vendor != null && !tk[1].equals(vendor)) {
            throw new Exception("Wrong URL for this wrapper");
        }
        this.CatisSchema = tk[1].equals("mysql") || tk[1].equals("mariadb");
    }

    public int JdbcConnect(String[] parms, int fsize, boolean scrollable) {
        int rc = 0;
        if (this.DEBUG) {
            System.out.println("In JdbcInterface: driver=" + parms[0]);
        }
        try {
            if (this.DEBUG) {
                System.out.println("In try block");
            }
            if (parms[0] != null && !parms[0].isEmpty()) {
                if (this.DEBUG) {
                    System.out.println("Loading class" + parms[0]);
                }
                Class.forName(parms[0]);
            }
            if (this.DEBUG) {
                System.out.println("URL=" + parms[1]);
            }
            this.CheckURL(parms[1], null);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (parms[2] != null && !parms[2].isEmpty()) {
                if (this.DEBUG) {
                    System.out.println("user=" + parms[2] + " pwd=" + parms[3]);
                }
                this.conn = DriverManager.getConnection(parms[1], parms[2], parms[3]);
            } else {
                this.conn = DriverManager.getConnection(parms[1]);
            }
            if (this.DEBUG) {
                System.out.println("Connection " + this.conn.toString() + " established");
            }
            this.dbmd = this.conn.getMetaData();
            this.stmt = this.GetStmt(fsize, scrollable);
        }
        catch (ClassNotFoundException e) {
            this.SetErrmsg(e);
            rc = -1;
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            rc = -2;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -3;
        }
        return rc;
    }

    protected Statement GetStmt(int fsize, boolean scrollable) throws SQLException, Exception {
        Statement stmt = null;
        stmt = scrollable ? this.conn.createStatement(1004, 1007) : this.conn.createStatement(1003, 1007);
        if (this.DEBUG) {
            System.out.println("Statement type = " + stmt.getResultSetType() + " concurrency = " + stmt.getResultSetConcurrency());
        }
        if (this.DEBUG) {
            System.out.println("Default fetch size = " + stmt.getFetchSize());
        }
        if (fsize != 0) {
            stmt.setFetchSize(fsize);
            if (this.DEBUG) {
                System.out.println("New fetch size = " + stmt.getFetchSize());
            }
        }
        return stmt;
    }

    public int CreatePrepStmt(String sql) {
        int rc = 0;
        try {
            this.pstmt = this.conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            rc = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -2;
        }
        return rc;
    }

    public void SetStringParm(int i, String s) {
        try {
            this.pstmt.setString(i, s);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetIntParm(int i, int n) {
        try {
            this.pstmt.setInt(i, n);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetShortParm(int i, short n) {
        try {
            this.pstmt.setShort(i, n);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetBigintParm(int i, long n) {
        try {
            this.pstmt.setLong(i, n);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetFloatParm(int i, float f) {
        try {
            this.pstmt.setFloat(i, f);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetDoubleParm(int i, double d) {
        try {
            this.pstmt.setDouble(i, d);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetTimestampParm(int i, Timestamp t) {
        try {
            this.pstmt.setTimestamp(i, t);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public void SetUuidParm(int i, String s) {
        try {
            UUID uuid = s == null ? null : (s.isEmpty() ? UUID.randomUUID() : UUID.fromString(s));
            this.pstmt.setObject(i, uuid);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
        }
    }

    public int SetNullParm(int i, int typ) {
        int rc = 0;
        try {
            this.pstmt.setNull(i, typ);
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            rc = -1;
        }
        return rc;
    }

    public int ExecutePrep() {
        int n = -3;
        if (this.pstmt != null) {
            try {
                n = this.pstmt.executeUpdate();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                n = -1;
            }
            catch (Exception e) {
                this.SetErrmsg(e);
                n = -2;
            }
        }
        return n;
    }

    public boolean ClosePrepStmt() {
        boolean b = false;
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                b = true;
            }
            catch (Exception e) {
                this.SetErrmsg(e);
                b = true;
            }
        }
        return b;
    }

    public int JdbcDisconnect() {
        int rc = 0;
        if (this.stmt != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Cancelling statement");
                }
                this.stmt.cancel();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                ++rc;
            }
        }
        if (this.rs != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing result set");
                }
                this.rs.close();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                rc = 2;
            }
        }
        if (this.stmt != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing statement");
                }
                this.stmt.close();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                rc += 4;
            }
        }
        this.ClosePrepStmt();
        if (this.conn != null) {
            try {
                if (this.DEBUG) {
                    System.out.println("Closing connection");
                }
                this.conn.close();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                rc += 8;
            }
        }
        if (this.DEBUG) {
            System.out.println("All closed");
        }
        return rc;
    }

    public int GetMaxValue(int n) {
        int m = 0;
        try {
            switch (n) {
                case 1: {
                    m = this.dbmd.getMaxColumnsInTable();
                    break;
                }
                case 2: {
                    m = this.dbmd.getMaxCatalogNameLength();
                    break;
                }
                case 3: {
                    m = this.dbmd.getMaxSchemaNameLength();
                    break;
                }
                case 4: {
                    m = this.dbmd.getMaxTableNameLength();
                    break;
                }
                case 5: {
                    m = this.dbmd.getMaxColumnNameLength();
                }
            }
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            m = -1;
        }
        return m;
    }

    public String GetQuoteString() {
        String qs = null;
        try {
            qs = this.dbmd.getIdentifierQuoteString();
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
        }
        return qs;
    }

    public int GetColumns(String[] parms) {
        int ncol = -1;
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.CatisSchema ? this.dbmd.getColumns(parms[1], null, parms[2], parms[3]) : this.dbmd.getColumns(parms[0], parms[1], parms[2], parms[3]);
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                ncol = this.rsmd.getColumnCount();
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
        }
        return ncol;
    }

    public int GetTables(String[] parms) {
        int ncol = -1;
        String[] typ = null;
        if (parms[3] != null) {
            typ = new String[]{parms[3]};
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.CatisSchema ? this.dbmd.getTables(parms[1], null, parms[2], typ) : this.dbmd.getTables(parms[0], parms[1], parms[2], typ);
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                ncol = this.rsmd.getColumnCount();
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
        }
        return ncol;
    }

    public int Execute(String query) {
        int n = 0;
        if (this.DEBUG) {
            System.out.println("Executing '" + query + "'");
        }
        try {
            boolean b = this.stmt.execute(query);
            if (!b) {
                n = this.stmt.getUpdateCount();
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            if (this.DEBUG) {
                System.out.println("Query '" + query + "' executed: n = " + n);
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            n = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            n = -2;
        }
        return n;
    }

    public int GetResult() {
        int ncol = 0;
        try {
            this.rs = this.stmt.getResultSet();
            if (this.rs != null) {
                this.rsmd = this.rs.getMetaData();
                ncol = this.rsmd.getColumnCount();
                if (this.DEBUG) {
                    System.out.println("Result set has " + this.rsmd.getColumnCount() + " column(s)");
                }
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            ncol = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            ncol = -2;
        }
        return ncol;
    }

    public int ExecuteQuery(String query) {
        int ncol = 0;
        if (this.DEBUG) {
            System.out.println("Executing query '" + query + "'");
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = this.stmt.executeQuery(query);
            this.rsmd = this.rs.getMetaData();
            ncol = this.rsmd.getColumnCount();
            if (this.DEBUG) {
                System.out.println("Query '" + query + "' executed successfully");
                System.out.println("Result set has " + this.rsmd.getColumnCount() + " column(s)");
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            ncol = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            ncol = -2;
        }
        return ncol;
    }

    public int ExecuteUpdate(String query) {
        int n = 0;
        if (this.DEBUG) {
            System.out.println("Executing update query '" + query + "'");
        }
        try {
            n = this.stmt.executeUpdate(query);
            if (this.DEBUG) {
                System.out.println("Update Query '" + query + "' executed: n = " + n);
            }
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            n = -1;
        }
        catch (Exception e) {
            this.SetErrmsg(e);
            n = -2;
        }
        return n;
    }

    public int ReadNext() {
        if (this.rs != null) {
            try {
                return this.rs.next() ? 1 : 0;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                return -1;
            }
        }
        return 0;
    }

    public boolean Fetch(int row) {
        if (this.rs != null) {
            try {
                return this.rs.absolute(row);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
                return false;
            }
        }
        return false;
    }

    public String ColumnName(int n) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
        } else {
            try {
                return this.rsmd.getColumnLabel(n);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return null;
    }

    public int ColumnType(int n, String name) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
        } else {
            try {
                if (n == 0) {
                    n = this.rs.findColumn(name);
                }
                return this.rsmd.getColumnType(n);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 666;
    }

    public String ColumnDesc(int n, int[] val) {
        if (this.rsmd == null) {
            System.out.println("No result metadata");
            return null;
        }
        try {
            val[0] = this.rsmd.getColumnType(n);
            val[1] = this.rsmd.getPrecision(n);
            val[2] = this.rsmd.getScale(n);
            val[3] = this.rsmd.isNullable(n);
            return this.rsmd.getColumnLabel(n);
        }
        catch (SQLException se) {
            this.SetErrmsg(se);
            return null;
        }
    }

    public String StringField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getString(n) : this.rs.getString(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return null;
    }

    public int IntField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getInt(n) : this.rs.getInt(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0;
    }

    public long BigintField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                BigDecimal bigDecimal = n > 0 ? this.rs.getBigDecimal(n) : this.rs.getBigDecimal(name);
                return bigDecimal != null ? bigDecimal.longValue() : 0L;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0L;
    }

    public double DoubleField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getDouble(n) : this.rs.getDouble(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0.0;
    }

    public float FloatField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getFloat(n) : this.rs.getFloat(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0.0f;
    }

    public boolean BooleanField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getBoolean(n) : this.rs.getBoolean(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return false;
    }

    public int DateField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Date d = n > 0 ? this.rs.getDate(n) : this.rs.getDate(name);
                return d != null ? (int)(d.getTime() / 1000L) : 0;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0;
    }

    public int TimeField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Time t = n > 0 ? this.rs.getTime(n) : this.rs.getTime(name);
                return t != null ? (int)(t.getTime() / 1000L) : 0;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0;
    }

    public int TimestampField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Timestamp ts = n > 0 ? this.rs.getTimestamp(n) : this.rs.getTimestamp(name);
                return ts != null ? (int)(ts.getTime() / 1000L) : 0;
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return 0;
    }

    public Object ObjectField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                return n > 0 ? this.rs.getObject(n) : this.rs.getObject(name);
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return null;
    }

    public String UuidField(int n, String name) {
        if (this.rs == null) {
            System.out.println("No result set");
        } else {
            try {
                Object job = n > 0 ? this.rs.getObject(n) : this.rs.getObject(name);
                return job.toString();
            }
            catch (SQLException se) {
                this.SetErrmsg(se);
            }
        }
        return null;
    }

    public int GetDrivers(String[] s, int mxs) {
        int n = 0;
        ArrayList<Driver> drivers = Collections.list(DriverManager.getDrivers());
        int size = Math.min(mxs, drivers.size());
        int i = 0;
        while (i < size) {
            Driver driver = (Driver)drivers.get(i);
            s[n++] = driver.getClass().getName();
            s[n++] = String.valueOf(driver.getMajorVersion()) + "." + driver.getMinorVersion();
            s[n++] = driver.jdbcCompliant() ? "Yes" : "No";
            s[n++] = driver.toString();
            ++i;
        }
        return size;
    }
}

