/*
 * libsysactivity
 * http://sourceforge.net/projects/libsysactivity/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>

int main() {
	int ret, i;
#ifdef SA_OPEN_NET
	ret = sa_open_net();
	if (ret != 0) {
		printf("sa_open_network(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif

	uint16_t number, written;

	ret = sa_count_net_interfaces(&number);
	if (ret != 0) {
		printf("sa_count_net_interfaces(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}

	size_t interfaces_size = number * 2;
	struct sa_net_interface* interfaces = (struct sa_net_interface*) malloc(interfaces_size * sizeof(struct sa_net_interface));
	char* interface_names = (char*) malloc(interfaces_size * SA_NET_INTERFACE_NAME);

	for (i = 0; i < 65000; i++) {
		ret = sa_count_net_interfaces(&number);
		if (ret != 0) {
			printf("sa_count_net_interfaces(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_reset_net_interfaces();
		if (ret != 0) {
			printf("sa_reset_net_interfaces(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_net_interfaces_ids(interface_names, interfaces_size, &written);
		if (ret != 0) {
			printf("sa_get_net_interfaces_ids(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}

		ret = sa_get_net_interfaces(interfaces, interfaces_size, &written);
		if (ret != 0) {
			printf("sa_get_network_interfaces(): %s\n", strerror(ret));
			exit(EXIT_FAILURE);
		}
	}

	free(interfaces);
	free(interface_names);

#ifdef SA_CLOSE_NET
	ret = sa_close_net();
	if (ret != 0) {
		printf("sa_close_network(): %s\n", strerror(ret));
		exit(EXIT_FAILURE);
	}
#endif
	return EXIT_SUCCESS;
}
