/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "obex_internals.h"
#include <errno.h>

/* The error code should be returned and errno is set. */
/* I want to define this as macro but I failed until now. */

int GET_OBEX_RESULT(int result)
{
	/* no error */
	if (result >= 0)
		return result;

	/* real error code is set in result */
	if (result < -1)
	{
		errno = - result;
		return result;
	}

	/* result is -1 */

	/* errno is set */
	if (errno)
		return - errno;

	/* errno is not set */
	errno = 1;
	return -1;
}

