-----------------------------------------------------------------
--         Copyright (C) 2007-2014, AdaCore                    --
-----------------------------------------------------------------

with Ada.Command_Line; use Ada.Command_Line;
with GNATCOLL.Mmap;        use GNATCOLL.Mmap;

procedure Test_Mmap_Write is
   Mmap : constant String := Argument (1);
   File : Mapped_File;
   Str  : Str_Access;
   Offs : File_Size;
begin
   File := Open_Write ("mmap.in", Use_Mmap_If_Available => Mmap = "mmap");

   --  Partially load the file, modify a random byte, and write it back

   Offs := 10;
   Read (File, Offset => Offs, Length => 10);
   Str := Data (File);
   Str (Integer (Offs - Offset (File)) + 3) := 'G';  --  byte 13 in file
   Str (Integer (Offs - Offset (File)) + 4) := 'N';
   Str (Integer (Offs - Offset (File)) + 5) := 'A';
   Str (Integer (Offs - Offset (File)) + 6) := 'T';
   Close (File);

end Test_Mmap_Write;
