; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK

declare <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1>, <vscale x 1 x i1>, metadata, <vscale x 1 x i1>, i32)

define <vscale x 1 x i1> @icmp_eq_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"eq", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

declare <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1>, <vscale x 2 x i1>, metadata, <vscale x 2 x i1>, i32)

define <vscale x 2 x i1> @icmp_eq_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"eq", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

declare <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1>, <vscale x 4 x i1>, metadata, <vscale x 4 x i1>, i32)

define <vscale x 4 x i1> @icmp_eq_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"eq", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

declare <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1>, <vscale x 8 x i1>, metadata, <vscale x 8 x i1>, i32)

define <vscale x 8 x i1> @icmp_eq_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"eq", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

declare <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1>, <vscale x 16 x i1>, metadata, <vscale x 16 x i1>, i32)

define <vscale x 16 x i1> @icmp_eq_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"eq", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

declare <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1>, <vscale x 32 x i1>, metadata, <vscale x 32 x i1>, i32)

define <vscale x 32 x i1> @icmp_eq_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"eq", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

declare <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1>, <vscale x 64 x i1>, metadata, <vscale x 64 x i1>, i32)

define <vscale x 64 x i1> @icmp_eq_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_eq_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"eq", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_ne_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"ne", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_ne_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"ne", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_ne_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"ne", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_ne_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"ne", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_ne_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"ne", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_ne_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"ne", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_ne_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ne_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"ne", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_slt_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"slt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_slt_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"slt", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_slt_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"slt", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_slt_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"slt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_slt_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"slt", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_slt_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"slt", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_slt_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_slt_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"slt", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_ult_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"ult", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_ult_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"ult", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_ult_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"ult", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_ult_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"ult", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_ult_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"ult", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_ult_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"ult", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_ult_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ult_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"ult", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_sgt_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"sgt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_sgt_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"sgt", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_sgt_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"sgt", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_sgt_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"sgt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_sgt_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"sgt", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_sgt_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"sgt", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_sgt_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sgt_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"sgt", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_ugt_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"ugt", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_ugt_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"ugt", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_ugt_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"ugt", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_ugt_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"ugt", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_ugt_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"ugt", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_ugt_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"ugt", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_ugt_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ugt_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"ugt", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_sle_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"sle", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_sle_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"sle", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_sle_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"sle", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_sle_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"sle", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_sle_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"sle", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_sle_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"sle", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_sle_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sle_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"sle", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_ule_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"ule", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_ule_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"ule", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_ule_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"ule", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_ule_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"ule", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_ule_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"ule", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_ule_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"ule", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_ule_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_ule_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"ule", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_sge_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"sge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_sge_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"sge", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_sge_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"sge", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_sge_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"sge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_sge_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"sge", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_sge_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"sge", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_sge_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_sge_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v0, v8
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"sge", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}

define <vscale x 1 x i1> @icmp_uge_vv_nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 1 x i1> @llvm.vp.icmp.nxv1i1(<vscale x 1 x i1> %va, <vscale x 1 x i1> %vb, metadata !"uge", <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i1> %v
}

define <vscale x 2 x i1> @icmp_uge_vv_nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i1> @llvm.vp.icmp.nxv2i1(<vscale x 2 x i1> %va, <vscale x 2 x i1> %vb, metadata !"uge", <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i1> %v
}

define <vscale x 4 x i1> @icmp_uge_vv_nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 4 x i1> @llvm.vp.icmp.nxv4i1(<vscale x 4 x i1> %va, <vscale x 4 x i1> %vb, metadata !"uge", <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i1> %v
}

define <vscale x 8 x i1> @icmp_uge_vv_nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 8 x i1> @llvm.vp.icmp.nxv8i1(<vscale x 8 x i1> %va, <vscale x 8 x i1> %vb, metadata !"uge", <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i1> %v
}

define <vscale x 16 x i1> @icmp_uge_vv_nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i1> @llvm.vp.icmp.nxv16i1(<vscale x 16 x i1> %va, <vscale x 16 x i1> %vb, metadata !"uge", <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i1> %v
}

define <vscale x 32 x i1> @icmp_uge_vv_nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 32 x i1> @llvm.vp.icmp.nxv32i1(<vscale x 32 x i1> %va, <vscale x 32 x i1> %vb, metadata !"uge", <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i1> %v
}

define <vscale x 64 x i1> @icmp_uge_vv_nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: icmp_uge_vv_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vmxnor.mm v0, v8, v0
; CHECK-NEXT:    ret
  %v = call <vscale x 64 x i1> @llvm.vp.icmp.nxv64i1(<vscale x 64 x i1> %va, <vscale x 64 x i1> %vb, metadata !"uge", <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i1> %v
}
