package tests::FirstTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture /;

use Lire::First;
use Lire::ReportSpec;
use tests::MockAggregator;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_test_schema();

    $self->{'spec'} = new Lire::ReportSpec();
    $self->{'spec'}->superservice( 'test' );
    $self->{'spec'}->id( 'test-first' );

    my $mock = new tests::MockAggregator( 'report_spec' => $self->{'spec'} );

    $self->{'first_nosort'} =
      new Lire::First( 'report_spec' => $self->{'spec'},
                       'parent' => $mock,
                       'field' => 'connection_id',
                       'name' => 'firstTest' );
    $self->{'first_sorted'} =
      new Lire::First( 'report_spec' => $self->{'spec'},
                       'parent' => $mock,
                       'field' => 'connection_id',
                       'sort_fields' => [ 'connection_id', 'user' ],
                       'name' => 'firstTest' );

    $self->{'cfg'}{'lr_scale_numbers'} = 0;
    $self->{'cfg'}{'lr_scale_bytes'} = 1;
    $self->{'cfg'}{'lr_scale_seconds'} = 1;

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->SUPER::tear_down();

    return;
}

sub test_build_first_query {
    my $self = $_[0];

    my $op = $self->{'first_nosort'};
    foreach my $t ( [ 'file-size', undef,
                      [ 'firstTest', 'lr_first("file-size")' ] ],
                    [ 'file_size', [ 'time_taken', 'connection-id' ],
                      [ 'firstTest', 
                        'lr_first(file_size,time_taken,"connection-id")',
                        'firstTest_key',
                        'lr_first_key(file_size,time_taken,"connection-id")'
                      ] ], )
    {
        my ( $field, $sort_fields,  $aggrFields ) = @$t;

        $op->{'field'} = $field;
        $op->{'sort_fields'} = $sort_fields;
        my $e_query = new Lire::DlfQuery( 'test' );
        for ( my $i=0; $i < @$aggrFields; $i += 2) {
            $e_query->add_aggr_field( $aggrFields->[$i], $aggrFields->[$i+1] );
        }
        my $query = new Lire::DlfQuery( 'test' );
        $op->_build_first_query( $query );
        $self->assert_deep_equals( $e_query, $query );
    }
}

sub test_sql_required_fields {
    my $self = $_[0];

    $self->assert_deep_equals( [ 'connection_id' ],
                               $self->{'first_nosort'}->sql_required_fields());
    $self->assert_deep_equals( [ 'connection_id', 'connection_id', 'user' ],
                               $self->{'first_sorted'}->sql_required_fields());
}

sub test_create_value {
    my $self = $_[0];

    my $aggr = $self->{'first_nosort'};
    foreach my $t ( [ 'connection_id', 'QWERTY', undef, 10, 'QWERTY' ],
                    [ 'file_size', 10240, 'QWERTY', 0, '10k' ],
                    [ 'file_size', undef, undef, 0, 'NaN' ],
                    [ 'connection_id', undef, undef, 0, undef ],
                  )
    {
        my ($field, $value, $total, $mc, $content ) = @$t;

        my $row = { 'firstTest_key' => $total,
                    'firstTest' => $value,
                    '_lr_firstTest_mc' => $mc };

        $aggr->{'field'} = $field;
        my $v = $aggr->create_value( undef, $row );
        my $e_v = { 'value' => $value,
                    'missing_cases' => $mc,
                    'content' => $content,
                    'total' => $total };
        $self->assert_deep_equals( $e_v, $v );
    }
}
1;
