#include "lc_global.h"
#include "lc_colors.h"
#include "lc_math.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <zlib.h>
#include "minifig.h"
#include "opengl.h"
#include "pieceinf.h"
#include "project.h"
#include "system.h"
#include "lc_library.h"
#include "lc_application.h"

// =============================================================================
// Static variables

// Settings for the 2013.1 update (from holly-wood@holly-wood.it).
static const unsigned char sDefaultSettings[] = 
{
	0x78,0x9C,0xED,0x9D,0x79,0x73,0xE3,0x46,0x92,0xE8,0xFF,0xDE,0x89,0xF0,0x77,0xC0,0xF0,0xC5,0xBA,0x7B,0x22,0x44,0x35,0x71,0xF0,0xF2,0xCC,0x3A,0x9E,0x44,0x9D,0xB6,
	0x2E,0x93,0xEC,0x96,0x3D,0x63,0x47,0x07,0x48,0x42,0x22,0x46,0x20,0x40,0x03,0x60,0xAB,0x35,0xF1,0x3E,0xFC,0xCB,0xAC,0x2A,0xDC,0x57,0x25,0xA4,0xEE,0xF5,0xCE,0xAA,
	0x67,0x6C,0xAB,0x29,0xA2,0x7E,0xA8,0x2B,0x2B,0x33,0x2B,0xAB,0xF2,0xAF,0xCA,0xE5,0xC5,0xC4,0x5C,0xED,0xDB,0xAE,0xFD,0xCD,0x9F,0xFE,0xAA,0x7C,0xB0,0xFC,0xC0,0xF6,
	0x5C,0x45,0xEB,0xA9,0x7A,0xB7,0xA7,0xC2,0x47,0xF8,0xA9,0xD6,0xEB,0x19,0xDD,0xDE,0xA0,0xAB,0x6A,0xCA,0x99,0xE7,0x38,0x4F,0xCA,0xAD,0xE7,0xAD,0x14,0x73,0xB5,0xB2,
	0x56,0xCA,0xC5,0x91,0x6F,0x3E,0x2A,0x5B,0xD3,0x0F,0x03,0x65,0xB7,0x5D,0x99,0xA1,0x25,0xBE,0xAE,0x25,0x4F,0x0E,0xE1,0x61,0xE5,0xC2,0x5C,0xAE,0x37,0xA6,0xEB,0x2A,
	0x97,0xF6,0x72,0x6D,0x5A,0x8E,0x62,0xAD,0xEC,0x10,0x0A,0x08,0x96,0xA6,0xAB,0x78,0xFE,0xCA,0xF2,0x95,0xC0,0x5A,0x86,0x40,0x4F,0x1E,0x1C,0x77,0xD5,0x11,0x01,0xA9,
	0xC7,0x4F,0xAA,0x2A,0x50,0x09,0x4F,0x1A,0xE2,0xC9,0x3E,0xD4,0xB1,0xAB,0xAB,0xB2,0x4F,0xF6,0x79,0x1B,0xE1,0x8F,0x83,0x6E,0x6F,0xD4,0xED,0xF5,0x95,0x03,0xC7,0xB1,
	0x5C,0x65,0xB6,0xB1,0xC3,0xB5,0x72,0x67,0x7F,0x86,0x47,0x3F,0x99,0xBE,0xED,0xED,0x02,0x65,0xB1,0xBB,0x0F,0xC4,0x97,0xC7,0xD0,0x3C,0xF8,0x65,0x49,0xCC,0x38,0xC1,
	0x8C,0x59,0xA3,0x0C,0x08,0x4F,0x6A,0xF1,0x93,0x6A,0xAF,0xB4,0x39,0xA3,0xF7,0xBB,0x98,0x3D,0xB9,0xF0,0xD2,0x01,0xFE,0xDB,0x0A,0xEC,0xC0,0x4A,0xDE,0x16,0x1A,0x45,
	0x1B,0x13,0x98,0xA2,0x23,0x00,0xD8,0x53,0xBB,0x9A,0x41,0x61,0x2A,0x4B,0xDF,0x32,0x71,0x5C,0x2C,0x9E,0x94,0x1F,0xF6,0x27,0xFB,0xCA,0x1C,0x46,0x8B,0x7B,0x9F,0x14,
	0x88,0x23,0x51,0xF2,0x55,0x18,0x3F,0x79,0x72,0x48,0x7B,0x52,0x34,0x1C,0x0E,0x25,0x95,0xF6,0xA4,0x9E,0x3C,0x09,0xC3,0xA2,0xA4,0xE1,0xDA,0x56,0x1F,0x47,0x75,0x57,
	0x93,0x1D,0x37,0xEC,0xCD,0xC5,0x93,0x1A,0xAB,0x84,0x4E,0x78,0x52,0x4B,0x9E,0x84,0x26,0x97,0x9D,0x12,0x0C,0x94,0x3C,0x09,0x6F,0x5B,0x32,0x0D,0xC3,0x47,0x4F,0x71,
	0xAD,0x47,0x65,0x09,0xCF,0xDC,0x7B,0xBE,0xDD,0x54,0x6D,0x0D,0xE7,0x96,0xDA,0x23,0xBC,0x42,0xF4,0xF2,0x28,0xC4,0x68,0x4F,0xEA,0xC9,0x93,0xF0,0xF2,0xD2,0xD5,0xE6,
	0xD2,0x12,0xFF,0xF7,0x57,0xE5,0xBF,0x5E,0xF0,0x0F,0x96,0x37,0x5F,0xDB,0x01,0xC8,0x12,0xC7,0x52,0xE0,0xBF,0xD0,0x4E,0xAC,0x95,0x98,0xD8,0x56,0x3E,0xE8,0xFB,0xBD,
	0x1E,0x48,0x4F,0x65,0x6D,0xDF,0xAF,0x2D,0xFF,0x4B,0xD0,0x2F,0x6C,0x17,0xFA,0x67,0x61,0xDD,0xDB,0xAE,0x6B,0xBB,0xF7,0xCA,0x23,0x4A,0xB6,0xBF,0x2A,0xA6,0x6F,0x29,
	0x4B,0x6F,0xB3,0xB1,0x5C,0x68,0x87,0xFD,0xFD,0x7D,0xFC,0xEA,0xF1,0x66,0x1B,0x3E,0x29,0x0E,0x7B,0x00,0x7F,0x6F,0xDF,0xBB,0x9E,0x6F,0xAD,0x78,0xAB,0x9C,0x5F,0xCD,
	0xA7,0xD7,0x47,0xEF,0x27,0xF3,0xF3,0xEB,0x2B,0xFE,0xC9,0x7C,0x6D,0x25,0xAB,0x0F,0xAF,0x60,0x68,0x39,0x4E,0xC0,0x3F,0x7C,0x13,0x28,0x1B,0xF8,0xFC,0xCE,0xBE,0x57,
	0xEE,0x2D,0xD7,0xF2,0xCD,0x10,0xAA,0xF9,0xB8,0x86,0xC5,0x43,0x34,0x3E,0x12,0xCC,0x4F,0xA6,0xED,0x98,0x0B,0xC7,0xDA,0xC3,0x02,0xCD,0x40,0x79,0x84,0x02,0xF0,0xBF,
	0x30,0x9F,0x6C,0x5F,0xD9,0x7A,0x81,0x8D,0x2B,0x8A,0x62,0xBA,0x2B,0xC5,0xF7,0x42,0x13,0xFF,0xB2,0xCF,0x1B,0xF4,0xDE,0xFE,0x04,0xAF,0xF9,0xE4,0xED,0x94,0xBB,0x1D,
	0x3C,0xB3,0xF5,0x1E,0x61,0x05,0xF2,0x3E,0xC1,0xBF,0xE0,0x59,0x2C,0x2D,0xB0,0x1C,0x58,0x8F,0xB0,0x70,0x05,0x7E,0x62,0x15,0xDD,0x03,0x21,0x1E,0x2A,0xA6,0x13,0x78,
	0xCA,0xC6,0x32,0x5D,0xC4,0x98,0x21,0x7E,0x5F,0x81,0xE1,0xEA,0x87,0xCA,0x1A,0xC9,0x1E,0x34,0x96,0x18,0x19,0x2B,0xC5,0x82,0x02,0x9F,0xB0,0xB4,0xD0,0xDE,0x58,0x62,
	0xEC,0xF8,0x50,0x9C,0x89,0x73,0xDD,0x64,0xB3,0x20,0x33,0x94,0x96,0x9E,0x1B,0x9A,0x36,0x6B,0xE8,0xA8,0xF6,0xEC,0xF7,0xFB,0xCA,0x2F,0xF0,0xA6,0xB8,0x54,0xC2,0x28,
	0x64,0xE5,0x01,0x94,0xCD,0x21,0x6F,0x65,0xE1,0x78,0x80,0x8A,0xF8,0xF0,0xC6,0x77,0x7B,0x38,0x1A,0xFE,0xB9,0x0B,0x42,0x65,0xE5,0x3D,0xBA,0x8E,0x07,0x83,0x04,0xBF,
	0x1A,0xBD,0x0F,0x6B,0xE5,0x3B,0xDF,0xDB,0x60,0x19,0x8F,0x8F,0x8F,0xFB,0x6B,0x1C,0xDF,0xDD,0x47,0x18,0xDF,0xFB,0x76,0xF8,0x6E,0xE3,0x2C,0xCD,0x55,0xD7,0x72,0xF7,
	0xD7,0xE1,0xC6,0xD9,0x57,0x6E,0xA1,0xAF,0x6D,0x40,0x2A,0x77,0x40,0x5A,0x99,0x4F,0xF8,0xCA,0x25,0xE3,0x1F,0xAA,0x8D,0xC5,0x2D,0x2C,0x58,0xF9,0x44,0xE5,0x38,0x95,
	0xD1,0x1E,0x6D,0x68,0x5E,0xD6,0x24,0xD8,0x36,0xF8,0xC0,0x3E,0xEB,0x7A,0x77,0xB7,0x59,0x80,0xBA,0xA1,0x00,0x20,0xFA,0xAE,0x6B,0x42,0x23,0xF9,0xD6,0x1D,0x1F,0xC9,
	0xF0,0xED,0xE4,0xD5,0xF7,0x92,0x02,0x83,0xD0,0x5E,0x3E,0x60,0x43,0xB3,0x41,0x77,0xB0,0x5A,0xB1,0x3E,0x36,0x71,0x9E,0xC6,0xDF,0x59,0x59,0x77,0x6C,0x18,0xE2,0x07,
	0x5C,0xB9,0xF0,0xEE,0x98,0xAA,0xE1,0x62,0x23,0x78,0xCE,0x0A,0xC9,0xAB,0x9D,0x8F,0x0D,0x8D,0xDF,0x71,0xCC,0x9D,0xBB,0x5C,0x63,0x79,0xF0,0x3D,0xFC,0x60,0xEB,0x7B,
	0xF7,0xBE,0xB9,0xC9,0x8D,0x29,0x18,0x14,0x61,0x08,0xCF,0xC0,0x7C,0xF4,0xFC,0xE8,0x7B,0x5B,0x28,0xDD,0x76,0x43,0x18,0xA2,0x4C,0x7D,0xE1,0x33,0x84,0x8B,0xF6,0x7D,
	0x85,0x0F,0xF5,0xCB,0xF3,0xAB,0xF3,0x93,0xF3,0xD3,0xF7,0xD3,0x63,0xE5,0xF4,0xF8,0xEA,0x78,0x7A,0x30,0xBF,0x9E,0x2A,0xB3,0x63,0x36,0x19,0xBE,0x8B,0x67,0x83,0xCF,
	0x66,0xB8,0xE7,0x5A,0x91,0x26,0xA4,0x60,0xD1,0xD1,0x38,0x10,0x83,0x70,0x3F,0x9A,0x3A,0xD1,0x77,0xB0,0xD1,0xF8,0x6C,0x00,0xF5,0x6A,0x85,0xD3,0xE4,0x49,0xE9,0x2A,
	0x36,0xAB,0xC6,0x13,0xFF,0xDC,0x0E,0x02,0xAC,0x28,0x4E,0x20,0xDF,0x83,0x1F,0xB8,0xF0,0xD8,0x89,0x25,0xDE,0xE4,0x6F,0x0F,0x2D,0x88,0xCD,0x66,0xEE,0x9C,0x10,0x3E,
	0x08,0x42,0x10,0x34,0x7B,0x62,0xC2,0xC1,0x5B,0xAD,0xEC,0x3B,0xE8,0x16,0xE0,0xB3,0xD1,0xC3,0xC7,0x3C,0x8C,0x55,0xFC,0x00,0x5F,0xFC,0xCF,0x6C,0xFE,0x83,0x8A,0xC7,
	0xA6,0x3F,0x9F,0x08,0xD8,0x17,0x30,0xBA,0xBC,0x47,0x64,0x43,0x7B,0x6D,0xCC,0xF0,0x3B,0xFC,0x5A,0xE7,0x6F,0x47,0x76,0xB0,0x75,0xCC,0x27,0xF6,0xEA,0xDF,0x77,0xF0,
	0x83,0x83,0xF9,0xBB,0x8B,0xA3,0x29,0xEF,0x3B,0xF1,0xE9,0xDF,0x4E,0x1C,0xF3,0x3E,0xF8,0x5E,0xF9,0xDB,0xA5,0x19,0xFA,0xF6,0x67,0xF8,0xE1,0xFA,0xEE,0x0E,0xDA,0xFF,
	0x7B,0x2C,0x23,0x5B,0x04,0x1F,0x4F,0x38,0x78,0x44,0xEF,0x89,0xB6,0xC2,0x5E,0xB3,0x43,0xFE,0xFA,0xEC,0xEB,0xD0,0xF9,0x62,0xB8,0x89,0x6F,0x60,0x59,0xB9,0x3F,0x8E,
	0x1D,0x84,0x1C,0x51,0x78,0x29,0xC6,0x89,0xFF,0x9A,0x87,0x41,0xF3,0x76,0x3A,0x6C,0x60,0xAC,0x6D,0x58,0x2A,0xDC,0x34,0x23,0xAA,0x8C,0xE9,0x3C,0xE2,0x34,0xEA,0xC1,
	0x28,0x0F,0x2C,0xFF,0x13,0x1B,0x8C,0x3E,0x48,0xA0,0x70,0x07,0xFD,0x04,0x1D,0xC2,0xBE,0x1B,0x55,0xD8,0x8C,0x65,0x16,0x74,0x2D,0x7E,0xA4,0x98,0xAA,0x0A,0xFF,0x68,
	0xF0,0x8F,0x8E,0x42,0x57,0x31,0x75,0x9D,0x15,0xE0,0x6D,0x41,0xBE,0x40,0xFF,0x99,0xDB,0xAD,0x65,0xFA,0xA6,0xBB,0x04,0xD1,0x98,0xAD,0x5B,0x0F,0xFA,0xF6,0xDE,0xB7,
	0xAC,0xA4,0x48,0x58,0x5F,0x1D,0xCE,0x13,0xED,0xCA,0x6A,0xE7,0xB1,0x9F,0xE3,0x59,0x80,0x52,0x8D,0x4B,0x34,0x68,0x37,0x68,0xC1,0xA5,0xF5,0xA5,0xD6,0x38,0x68,0x8F,
	0x68,0x48,0xF3,0xD1,0x5C,0x58,0xE9,0xD4,0x2F,0xBA,0xD2,0x61,0x89,0xB3,0xC9,0xC1,0x95,0x72,0x3D,0x3D,0x3A,0x2E,0x99,0x9C,0x20,0x03,0x4D,0xD6,0x4B,0x38,0xB6,0x99,
	0xA8,0x0B,0xD7,0xDE,0xEE,0x7E,0xCD,0xDA,0xC7,0x76,0x97,0xCE,0x0E,0x04,0xF1,0xCE,0x85,0xF6,0xB3,0x97,0x36,0x76,0x05,0x2C,0x39,0x4B,0x90,0xC3,0x5C,0xD4,0x72,0x79,
	0x09,0xF3,0xCC,0xE3,0xF5,0xD9,0x63,0x52,0xC2,0xDB,0x85,0x42,0x90,0xA3,0xC0,0x84,0x45,0x05,0xBA,0x18,0xFE,0xBE,0xE1,0x22,0x24,0xE4,0xDD,0xC1,0x8B,0x63,0x62,0x37,
	0x5D,0x12,0xFB,0xF5,0xAF,0x37,0x07,0xD3,0xF9,0x8C,0xB1,0x7E,0xBD,0x89,0xE4,0xDA,0xBE,0x02,0x23,0x97,0x0D,0x53,0x14,0x53,0x3B,0x37,0x1E,0xF3,0xCC,0xD4,0x42,0x71,
	0xCC,0xA5,0x75,0xF4,0xD6,0xF1,0xEF,0x79,0xD1,0x8E,0xBD,0xF0,0x4D,0x90,0x21,0x58,0x68,0x17,0x46,0xCD,0xD6,0x72,0x57,0x4C,0x7A,0x08,0x39,0x0D,0x03,0x19,0x3E,0x0F,
	0xD6,0xDE,0x23,0x8A,0x74,0xDB,0x8D,0x56,0x23,0xFE,0x74,0x88,0x63,0x2C,0x5D,0x04,0xFF,0x78,0xEB,0x5B,0x9F,0x6C,0x58,0x44,0x40,0x16,0xC0,0xBA,0xC4,0x65,0x98,0xF9,
	0x00,0x35,0xF7,0x40,0x98,0x5B,0xD1,0x3A,0x8A,0x7A,0x8E,0x68,0x65,0xF8,0xF1,0xEA,0x7A,0xAE,0x58,0xBF,0xEF,0xA0,0xF2,0x62,0x25,0xE8,0x9C,0xE0,0xD4,0xFB,0x5E,0x99,
	0x61,0x3D,0x6E,0xB0,0xDC,0x0E,0xD3,0x41,0x00,0xC3,0xE4,0x98,0xCB,0x56,0x1D,0x58,0x3F,0x40,0xEB,0xE0,0xCB,0x0E,0x16,0xE1,0x5B,0x8F,0x3E,0x58,0x9A,0xAC,0x04,0xF6,
	0xD0,0xBE,0x03,0xAB,0x23,0x36,0xCF,0xBE,0x72,0x8D,0xDF,0x17,0x4B,0x5A,0xE8,0x79,0xA0,0x7B,0xC4,0xF5,0x65,0x6B,0x81,0x5B,0xF2,0x14,0xF4,0x12,0xF6,0x3A,0xBC,0x39,
	0x14,0xBD,0xF4,0xEE,0x5D,0xD0,0xDB,0x15,0x94,0x13,0x30,0x38,0x2F,0x6F,0x8E,0x44,0xC3,0xA7,0x16,0xF2,0x60,0xC7,0x57,0x96,0x8E,0xF5,0x99,0x8B,0xD9,0x0E,0x6F,0x94,
	0x3F,0x2B,0xB1,0x28,0x0F,0xE1,0xEF,0x5D,0x68,0x4D,0x98,0x76,0x7C,0xB8,0x47,0x8B,0x66,0x00,0xE2,0x13,0x3A,0x08,0xD7,0xF2,0x62,0x57,0xF0,0x15,0x14,0x1E,0xC2,0x72,
	0xA2,0x45,0x0D,0x5B,0x21,0xD8,0x2D,0xA2,0xBF,0xF2,0xC9,0x2B,0x56,0x3E,0xBE,0xF0,0xA2,0xB9,0x61,0x7E,0x86,0x2F,0x6D,0xB7,0x1E,0xF6,0x0D,0xBE,0x96,0x8B,0xC3,0xE0,
	0x60,0x36,0x39,0x3F,0xEF,0xA2,0x46,0xB1,0x0F,0x12,0x43,0x18,0xFF,0xD0,0x84,0xC7,0x7F,0x8E,0xD5,0x50,0x1B,0x55,0x80,0xD0,0xDA,0xC0,0x93,0xD8,0xC1,0x81,0xE7,0xEC,
	0x98,0x30,0xD9,0xB9,0xA1,0x2D,0x06,0xE9,0xBE,0xE7,0xDF,0xB3,0x49,0x62,0xA2,0xBC,0x59,0xE1,0xCB,0x9A,0x4C,0xB1,0x32,0xF9,0xC0,0x8B,0x9E,0x89,0x16,0x17,0x56,0x55,
	0xBE,0x8C,0xC2,0x0A,0xCE,0x17,0x6E,0xAC,0x5E,0x80,0xFF,0x66,0x6B,0x2D,0x0C,0xCF,0x64,0xF9,0x89,0x74,0xC5,0xFD,0xE8,0x05,0x67,0x21,0x1B,0x61,0x6C,0xCA,0xFC,0x03,
	0x67,0xF0,0x47,0x36,0x83,0x7F,0x63,0x83,0xEC,0xDA,0xB5,0xF8,0x8A,0x84,0x2B,0xE9,0xCA,0x86,0x0E,0x63,0xEB,0x23,0xB4,0x0A,0x36,0x49,0xBC,0x96,0xF2,0xD5,0x09,0x9B,
	0xDF,0xE4,0x5F,0xB7,0x83,0xEF,0x14,0x57,0xF9,0x2F,0xE5,0x6F,0xB3,0xB3,0xEB,0xDB,0xFF,0x77,0x76,0x7E,0x74,0xFC,0xBD,0xF2,0x8F,0xBF,0x41,0x2F,0x1F,0xDC,0x1E,0x9D,
	0x4F,0xBF,0xFF,0xED,0x1F,0x9D,0xDF,0x6E,0xCC,0x70,0x8D,0xCB,0x00,0xFC,0xC8,0x5E,0x03,0xBE,0x88,0x32,0x99,0xFD,0x01,0xCD,0x09,0x2A,0x25,0x16,0x9D,0xD4,0xEC,0x88,
	0xA6,0x63,0x60,0xAF,0x2C,0x3E,0xDE,0x93,0x77,0xE2,0x93,0xB0,0xB8,0x20,0xE1,0x93,0xDD,0xD4,0x8C,0x7A,0x07,0xE3,0x8C,0x7D,0x96,0x9D,0x53,0xF8,0x20,0xBE,0x67,0xEE,
	0x1D,0x70,0x06,0xB0,0xB9,0xFA,0xD5,0x5E,0x22,0x69,0x25,0x78,0x15,0xE5,0xC1,0x7A,0x7A,0x04,0x05,0x8C,0x0B,0xC9,0x95,0x8D,0x26,0x1F,0xEA,0x88,0xB0,0x04,0x7D,0xC2,
	0xF7,0x09,0xD7,0x01,0x08,0x13,0xF6,0x12,0x89,0xF2,0x1C,0x6C,0xAD,0x25,0xA8,0x3C,0xD6,0x8A,0x75,0x2A,0x94,0xF9,0x1F,0xFF,0x81,0x6F,0x0F,0xF0,0xE5,0x83,0x05,0x15,
	0xF8,0x9B,0xC2,0x74,0x80,0xA8,0x03,0x58,0x8D,0x95,0xD9,0x6E,0x91,0xAE,0x06,0xAB,0x9C,0xB3,0xC2,0x89,0xBD,0x00,0x7D,0x94,0xA1,0x70,0x86,0x9A,0x0B,0x36,0xFE,0xC4,
	0x07,0x5C,0x02,0x8A,0xD9,0x9E,0xFD,0xB3,0xF2,0xF1,0x0D,0xB1,0xFC,0x7D,0xE5,0xCA,0x0B,0x85,0x8C,0x02,0xB5,0x0A,0x35,0xED,0x44,0x5B,0x15,0xF3,0x3C,0x80,0x97,0x86,
	0xC5,0x31,0xE0,0x6A,0x2A,0x8C,0x53,0x78,0x95,0x62,0x99,0xF1,0x53,0x1B,0x54,0xD0,0x17,0xF8,0xC5,0xA5,0xE3,0x05,0x5C,0x02,0xAF,0xBC,0x1D,0xDA,0x1A,0xBF,0xEF,0x00,
	0x06,0x32,0xFC,0x6D,0x34,0xDF,0x40,0x38,0x80,0x5A,0xE7,0x33,0x4D,0xA1,0x58,0xA4,0xE9,0x82,0x75,0xCA,0xDA,0x3E,0x88,0x64,0x21,0x1F,0xC1,0x6C,0x3E,0x38,0xA8,0xED,
	0x45,0xD4,0xE0,0x2F,0x62,0xC6,0xFC,0x7A,0xB3,0x97,0x59,0x39,0x2E,0xAF,0x8F,0x8E,0x2F,0x66,0x39,0x15,0x92,0xF7,0x0D,0xFE,0x9E,0x19,0x5A,0x5C,0x6F,0xD9,0xA2,0xDA,
	0x02,0x93,0x10,0xCC,0x1A,0x17,0xDB,0x02,0x84,0x20,0x9B,0xD2,0x51,0x87,0xED,0x2B,0xE7,0xEC,0x43,0x98,0xC6,0x4B,0x07,0x9E,0x43,0x81,0x0C,0xF5,0x4B,0xC4,0x19,0x4C,
	0x3A,0xF8,0x10,0x1A,0xD2,0x31,0x83,0x30,0x9E,0xC2,0xE7,0x5C,0xDB,0x88,0xC6,0x4A,0x6A,0x04,0xA1,0x3E,0xBC,0xD9,0xD8,0x61,0x28,0x2C,0x0A,0xDE,0x6B,0xF0,0x5E,0x41,
	0xB0,0xDB,0xF0,0x45,0x13,0x8A,0x45,0xB3,0x28,0xDD,0xAF,0xFB,0xA2,0xDC,0xE3,0xCF,0xE6,0x66,0xEB,0x58,0xDF,0x89,0xBF,0xA6,0xA5,0x03,0xFE,0x5D,0x85,0x09,0xCE,0xA6,
	0xCC,0x0D,0x33,0xFA,0xA3,0xBF,0x25,0xF8,0xF7,0xF1,0x72,0xFE,0x2B,0xFB,0x8A,0x0E,0x5F,0x61,0xF3,0xBC,0xFC,0x2B,0x38,0xBB,0xF0,0x6B,0x46,0xF1,0x6B,0x97,0x4F,0x1F,
	0xE3,0x5F,0xF7,0x8B,0xBF,0xEE,0x1C,0xEC,0xA0,0xA1,0xD0,0x1A,0xF9,0xF5,0xD6,0xF3,0x1F,0x98,0xB2,0x85,0x06,0x88,0x15,0x04,0x1D,0x7C,0x64,0x10,0x3D,0x72,0xF4,0xDD,
	0xAF,0x81,0x07,0x15,0xB7,0x7D,0xF6,0x5F,0x10,0xF4,0x91,0xD7,0xE1,0x62,0xF6,0xCB,0xD5,0xFC,0x4C,0x39,0x3A,0x3E,0x01,0x5B,0x03,0x55,0x97,0x19,0xFF,0x7C,0x6A,0xDD,
	0xC3,0xE0,0x81,0x25,0x29,0x88,0x94,0xBA,0xD8,0x1E,0x0A,0xF9,0xD2,0x13,0x72,0xE3,0x36,0xD2,0x02,0x52,0xD6,0x38,0x53,0xF2,0x37,0x0B,0x68,0x63,0xEF,0x73,0xAC,0x38,
	0x04,0xB0,0x68,0x28,0x7C,0x98,0x05,0x21,0x57,0x57,0xD0,0x46,0x74,0xB6,0x6B,0x73,0x61,0xC1,0x6A,0x0E,0xEB,0x35,0x23,0xEC,0x97,0xC9,0x67,0xFE,0x96,0x5C,0x36,0xFF,
	0xE7,0xCD,0x01,0xBC,0x30,0xC8,0x58,0xD6,0xA9,0x5C,0xC1,0xDE,0x4F,0xFE,0x28,0x47,0x29,0x1B,0x2E,0x3B,0x6D,0xA1,0xD7,0xB9,0x7D,0x55,0xA2,0xBE,0x17,0xFE,0xB0,0x05,
	0x4C,0x79,0x8B,0x82,0x90,0x49,0x11,0xB6,0x9A,0x08,0x41,0xF1,0xE7,0xBF,0x14,0x57,0x00,0x6E,0xE6,0xC5,0xB6,0x7F,0x7A,0x52,0x05,0x6C,0x5D,0xF8,0xDB,0xFC,0x7C,0x7E,
	0x01,0xEB,0x01,0xBC,0xF9,0xE4,0xFA,0xF2,0xF2,0xE0,0xEA,0x48,0x99,0xCD,0xA7,0xE7,0x57,0xA7,0xDF,0xF3,0x05,0x1D,0x7F,0x9B,0xA9,0x48,0x6C,0x9D,0x14,0xAC,0x90,0xA4,
	0x75,0x05,0xB8,0x03,0xE6,0x6C,0xE4,0x16,0x9C,0x70,0x72,0xA7,0xBC,0x92,0x2B,0x18,0x72,0xDE,0x3D,0x6B,0xC8,0xEC,0x5B,0x28,0x82,0x18,0xBD,0xB8,0x98,0x22,0xDC,0xF3,
	0xE6,0x45,0x46,0xEB,0x3F,0xA1,0x7E,0xFB,0xCA,0x0D,0x33,0xD6,0xB9,0xC9,0x0D,0xBF,0x2C,0x27,0xF1,0xD7,0x81,0x55,0xC2,0x5B,0xEE,0x70,0xA4,0x70,0xF3,0x01,0xCD,0x0E,
	0x13,0xE6,0xB9,0xC5,0xCD,0xDF,0x00,0x95,0xA2,0xAA,0x79,0x27,0x7A,0x3D,0xDD,0xE9,0x9D,0xC9,0x77,0xBF,0xDE,0x70,0x1B,0x3B,0xF8,0x95,0x13,0x58,0x45,0x7B,0x2A,0xAC,
	0x07,0xC7,0x17,0xA0,0x7D,0x4F,0xCF,0x27,0x1F,0xAF,0x7E,0x9E,0x7F,0x9C,0x1C,0x1C,0x42,0x7B,0x16,0xFF,0xC0,0x8C,0x60,0x23,0xFE,0xF0,0xF8,0xF4,0xFC,0xAA,0xEC,0x11,
	0x75,0xC0,0x0A,0xD4,0xD2,0x05,0xDE,0x5C,0xDF,0x1E,0x4F,0x3F,0x9E,0xBC,0xBF,0x62,0xDA,0xFD,0x2C,0x53,0x78,0x45,0x81,0xE5,0x8F,0x88,0xC2,0xF5,0x74,0xE1,0xD3,0xC9,
	0xCF,0xD4,0xB7,0x4D,0x1E,0x11,0x05,0x1A,0x50,0xE0,0xC9,0xF9,0x21,0x10,0xAF,0x6F,0xE6,0xE7,0x93,0x99,0x64,0x81,0x25,0x8F,0x60,0x81,0xC2,0xAC,0x79,0x7F,0x73,0x73,
	0x3D,0x9D,0x0B,0x5B,0xE6,0xC4,0xB2,0x1C,0x30,0xE2,0x41,0x4D,0x47,0x8B,0xC3,0x03,0xCD,0x2A,0xF1,0x9B,0x70,0x07,0xD7,0x39,0x88,0xD7,0x07,0xE6,0x1A,0x43,0x3D,0x09,
	0x74,0x43,0x05,0xC6,0xAE,0x09,0x03,0x6A,0xFB,0x84,0xE3,0xD4,0x0E,0x85,0x77,0x06,0x87,0x15,0x4E,0x11,0x74,0xEB,0x80,0x2C,0xF0,0xED,0x05,0xCE,0x50,0x9B,0x59,0x44,
	0x1E,0xD3,0xAC,0xC1,0xA2,0x45,0x95,0x94,0xFB,0x50,0x60,0x8D,0xC6,0xB2,0xA0,0x18,0xF4,0xF8,0xF2,0xD1,0x96,0xB8,0x9F,0xFE,0x6F,0xC6,0x13,0xC5,0xC5,0x05,0x30,0x41,
	0x69,0xE4,0x3A,0xF4,0x22,0x33,0x62,0x57,0x1E,0x5B,0x66,0x82,0xA4,0x40,0x2C,0x0D,0x56,0xA4,0x1D,0xF3,0x74,0xA4,0xEC,0x30,0xA6,0xF3,0xEC,0x09,0xA7,0x1D,0x9A,0x1C,
	0x01,0x9A,0x17,0x58,0x39,0x93,0x99,0xDC,0x89,0x07,0x08,0x96,0xDD,0x90,0x7D,0x1D,0x8B,0xE2,0xBA,0x0E,0xBE,0x28,0xF3,0x77,0xA0,0xAB,0x2C,0xD6,0x6E,0xF7,0x79,0x43,
	0x1E,0x4C,0x7E,0xBC,0xBA,0xBE,0xBD,0x38,0x3E,0x3A,0x3D,0xBE,0x3C,0xBE,0x9A,0xCF,0x62,0x5B,0xF1,0x33,0x36,0xC0,0xDB,0x52,0xA1,0xF8,0x97,0x78,0xFB,0xEB,0xCC,0x02,
	0x0D,0x05,0x37,0xC4,0xF6,0xE2,0x8F,0xA2,0x2D,0xB2,0xBD,0xB4,0x0F,0x9C,0x89,0xDA,0x03,0x77,0x05,0x66,0x8C,0x72,0x0B,0x6F,0xE8,0xC3,0x7B,0xF2,0x8E,0xFD,0xE6,0x4F,
	0xFF,0x38,0x3B,0x98,0xCF,0x60,0x5A,0x75,0x26,0xE6,0xB6,0xD3,0x28,0x08,0xCB,0xFF,0x74,0x0C,0x63,0xD4,0xDF,0x07,0x8B,0x31,0x55,0x40,0x0F,0xFE,0x51,0xE1,0xDF,0xF8,
	0xBF,0xE4,0xBF,0xFC,0x07,0x4E,0x53,0x0E,0x3E,0xD9,0xA8,0x27,0x50,0xA9,0x1D,0xBD,0xA7,0x0E,0xD5,0x2C,0xAE,0x91,0x16,0x84,0x30,0xC8,0xCE,0x2C,0x67,0x63,0x89,0x71,
	0x31,0x01,0xBB,0xA0,0x7B,0xBA,0x83,0x75,0xAD,0x9E,0xDF,0xD1,0x47,0xE3,0x01,0xB5,0x6E,0x05,0xDA,0x95,0xB5,0x7C,0x50,0x40,0x56,0x85,0x6C,0xCD,0xA8,0x26,0x02,0xCD,
	0x30,0x88,0x34,0xCF,0x85,0x1E,0xDD,0x71,0x47,0x1E,0x67,0xCA,0xB6,0x28,0xD0,0x74,0x9D,0x4A,0xF3,0x1E,0xDE,0x04,0xCA,0x99,0x29,0x0D,0x49,0xD3,0xC6,0xA3,0xFD,0x55,
	0xE6,0xC9,0x06,0xDA,0x09,0x2C,0xB2,0xC4,0x3A,0xA5,0xEB,0x46,0x6C,0xC9,0x14,0x8D,0xF7,0x1A,0xFB,0xE0,0xC2,0xBB,0xF7,0x94,0xD9,0xDA,0xB6,0x9C,0x15,0x9A,0x0B,0x68,
	0x7E,0x17,0xDF,0x85,0xD1,0xB6,0xBD,0xCC,0xA8,0x6C,0xA2,0x79,0xA0,0x9A,0x85,0x30,0x57,0x15,0xF2,0xCC,0xEB,0x0C,0x87,0xF9,0xE9,0x46,0xA2,0xF1,0xDA,0xCD,0x36,0x20,
	0x18,0x41,0x18,0xC2,0x82,0xAC,0xBC,0x9D,0x81,0xEA,0x18,0x2E,0x77,0xE1,0x5F,0x4A,0xEA,0x06,0xB4,0x65,0xB6,0x6A,0x4D,0xB4,0x53,0xD0,0xD8,0x43,0x68,0x34,0xDF,0xDB,
	0x35,0x4C,0xAF,0x22,0x4D,0xEB,0x8F,0x46,0xA4,0x7E,0x43,0x81,0xF9,0x3E,0xB7,0x8B,0xD6,0x39,0x33,0x6D,0x5F,0x39,0x04,0x63,0x2F,0x70,0xEC,0xE5,0x03,0xE9,0x1D,0x3A,
	0x03,0x63,0x38,0x1E,0x51,0xE4,0x4B,0xC4,0x3B,0x01,0x61,0xEC,0x08,0xB3,0xE9,0xC6,0xBE,0x07,0xA3,0xCE,0x09,0x9A,0xD1,0x1D,0x7D,0xA0,0x11,0xA5,0x27,0xA3,0x9D,0x07,
	0x0E,0xC8,0x75,0x8B,0x28,0x3F,0x3B,0x83,0x5E,0x2B,0xDA,0x25,0xD4,0x8C,0xBE,0x3E,0x74,0xF4,0x71,0x6E,0xE4,0xC8,0xD1,0x2E,0x3C,0xB1,0x6A,0x9D,0x99,0xCE,0x9D,0x72,
	0xE8,0x9B,0xB0,0xD0,0x35,0x8F,0x24,0x58,0x19,0x8C,0xFC,0xCC,0x90,0xA6,0xCD,0x60,0x59,0x44,0x05,0x54,0xBA,0x92,0x1D,0xA3,0xA7,0xE9,0xE3,0xAC,0x40,0x93,0xA6,0x71,
	0xF9,0xE2,0x83,0xF1,0xBE,0xE6,0xD5,0x6B,0xC2,0x76,0xFA,0x63,0x7D,0xA0,0xB7,0xAC,0x1B,0xA3,0x9D,0x59,0xE6,0x6A,0x81,0xC6,0x80,0x4C,0xDD,0x60,0x8D,0x55,0x8D,0x97,
	0xA0,0xB1,0x5E,0x3C,0xB1,0x4C,0xD4,0xE5,0x02,0xE5,0x2D,0x18,0x24,0xA0,0xD5,0x87,0x56,0x46,0xCE,0x70,0xDA,0x24,0x33,0x52,0xA4,0x69,0xB7,0xE6,0xA7,0x27,0xDA,0xFC,
	0x86,0x7E,0xEB,0xD3,0xF4,0x07,0x46,0xBB,0xB1,0x40,0xF5,0xA3,0x8A,0x33,0xA0,0x69,0x46,0x7E,0x49,0x97,0xA2,0x79,0xEE,0x13,0x0A,0x10,0xF2,0xEC,0x1E,0xEB,0x66,0x7B,
	0x9A,0xD8,0x78,0xC4,0x76,0x3D,0x04,0xC5,0xB1,0x41,0x7A,0x75,0x06,0xDA,0x20,0xAF,0x1C,0x49,0xD1,0x76,0x8E,0x03,0x96,0x24,0x8A,0x67,0x42,0xF5,0x3A,0x63,0x6D,0xD8,
	0x6F,0x41,0x63,0x4B,0xDB,0x9E,0x32,0xF7,0x76,0x81,0x23,0xFC,0x81,0xCA,0x0C,0x5D,0x7B,0xE8,0x4D,0x01,0xD5,0xBD,0xFC,0x15,0xA0,0x6E,0x23,0xB5,0xD7,0x8A,0xB6,0x43,
	0xB7,0xB9,0x72,0x61,0xB9,0xF7,0x60,0x90,0x4A,0xD6,0xCD,0xE8,0xEB,0xBD,0x16,0x72,0x72,0xB6,0xB5,0x1F,0x9E,0x58,0x7F,0x51,0xC6,0x49,0xA7,0xAF,0x8F,0x47,0x1A,0x5D,
	0x72,0x71,0x1A,0x6B,0x4F,0x4A,0xBF,0x21,0x4D,0x6D,0x41,0x7B,0xB4,0xB6,0xA1,0x32,0x65,0x3B,0x25,0x42,0x5C,0x7A,0x6E,0xA8,0x4C,0x76,0x7E,0xDD,0xA4,0xE8,0x8C,0x47,
	0x43,0x8D,0x34,0x4A,0xAA,0xF5,0x07,0x31,0x64,0xA8,0x1A,0x8C,0xDA,0xEB,0x19,0xAD,0xF4,0x07,0x56,0xCB,0xF9,0xA3,0xA7,0x1C,0xEE,0x5C,0x09,0xC5,0x21,0xE2,0xC1,0xAA,
	0xD7,0x1B,0x13,0x47,0x6A,0xA8,0x1C,0xDA,0x4B,0xCF,0x77,0xC9,0x6B,0x3A,0xE8,0x67,0x1A,0x4D,0x3F,0x4B,0xD3,0x78,0x15,0x8F,0x3F,0x81,0xA4,0x99,0x3D,0x60,0xCC,0x0C,
	0xAE,0x0E,0x13,0xDF,0x0B,0x82,0x85,0x87,0xBE,0xB1,0xBC,0x82,0xCD,0x68,0x37,0xD9,0xA9,0x21,0x43,0xF3,0x1E,0x1D,0xAA,0x62,0x84,0xB4,0x71,0x7F,0x30,0xA4,0xCA,0xEA,
	0x88,0xC6,0xAB,0x36,0x05,0x09,0x73,0xE2,0xB0,0x40,0x20,0xF6,0xF7,0x5F,0x2C,0x8C,0x5E,0x50,0x26,0x96,0x1B,0xFA,0x56,0xB6,0x7A,0x9C,0x76,0x43,0x5B,0xF5,0x60,0xFC,
	0x7B,0x2E,0xF3,0x05,0x1C,0x04,0xB6,0x59,0x62,0x89,0x54,0xD7,0x4D,0xEF,0xF5,0xE9,0xA3,0x64,0xE2,0x3D,0x2E,0x3C,0xDA,0xFA,0xCA,0x68,0xA0,0xD3,0x8E,0xE9,0xA3,0x84,
	0xD3,0x84,0x81,0x6E,0x7E,0x32,0x1D,0xFF,0x89,0xDB,0x5F,0x95,0x86,0x57,0x42,0xBB,0xB9,0xA5,0x58,0x5F,0x79,0xDA,0xCC,0x76,0x30,0x6E,0x0B,0x1D,0xCD,0x0D,0xB0,0x88,
	0xA6,0x51,0x69,0xBE,0xF7,0x48,0xE8,0xAF,0x98,0x36,0x54,0x7B,0x2A,0x55,0xA7,0x0D,0x41,0xE3,0x5A,0x79,0xBE,0x49,0xEF,0xB7,0x81,0xDA,0xEF,0x51,0xD7,0x58,0xA4,0xFD,
	0xAB,0x8D,0xEF,0xA8,0x33,0xEA,0x8F,0x41,0x5F,0x97,0x5B,0x19,0xBA,0xAA,0x11,0xF3,0xCE,0x37,0x5B,0xCB,0x47,0xCF,0x1C,0x73,0xE0,0xC0,0x8A,0x64,0x3E,0x78,0x12,0x2F,
	0x00,0xD2,0xC4,0x20,0xDB,0x3E,0xA1,0x72,0x06,0x4B,0x10,0x4E,0x3B,0x0B,0x41,0x5B,0xE9,0xF5,0xA0,0xA3,0xE9,0x7A,0x0B,0x49,0xF9,0xA3,0xB5,0xB5,0x5B,0x34,0x26,0xEA,
	0xD0,0xBA,0x6C,0x5B,0xA6,0x68,0xAE,0x1D,0xD2,0x1D,0x10,0xA0,0xAF,0xA8,0x7A,0xDE,0xBD,0x22,0x41,0xBB,0xE1,0x96,0x01,0xD5,0x9F,0xC3,0x3C,0x7E,0x1A,0x99,0x36,0x35,
	0x49,0x5A,0x51,0x4C,0x83,0x51,0x42,0xF4,0x8A,0x21,0x6D,0xEE,0xB7,0x5A,0x50,0x91,0x46,0xF4,0x53,0xA5,0x69,0xC2,0xD9,0xC0,0x9D,0x38,0xA5,0xC6,0x55,0x91,0x36,0x21,
	0xF9,0xA9,0x90,0x76,0x8B,0xEA,0xF2,0xA1,0x6F,0x6F,0x60,0x6D,0x23,0x78,0xFE,0xB0,0xDF,0x06,0x43,0x5A,0xBF,0x81,0xD9,0xB8,0xC2,0x3D,0x4B,0xB0,0x0E,0xD0,0x5D,0x45,
	0xD2,0x33,0xFB,0xC3,0x1E,0x71,0x4C,0xC6,0xB4,0x89,0x19,0x3E,0x7A,0x14,0x1E,0xD3,0x33,0x89,0xEB,0x69,0x4C,0x3B,0xF3,0xFC,0x9D,0xBC,0x82,0xC7,0x68,0xBA,0x66,0x3C,
	0x8B,0x26,0x34,0xAF,0x27,0xAB,0x69,0x79,0x8B,0x69,0x37,0x3F,0xF5,0x08,0x9A,0x49,0x4C,0xBB,0xB2,0x30,0x96,0x74,0xFE,0xB4,0xB5,0x14,0x55,0xAA,0x8A,0x6C,0x94,0x90,
	0xF4,0xE5,0x72,0x9A,0x26,0x47,0x1B,0xF7,0x8C,0x01,0x51,0x96,0xE4,0x68,0xAC,0x25,0x35,0xE5,0xC8,0xF4,0x1F,0x16,0xCE,0x0E,0x56,0x05,0xD7,0x7C,0x28,0xD1,0x5D,0x13,
	0xDA,0xB3,0x5A,0x92,0xD1,0x12,0x56,0xE8,0xDB,0xDB,0x0A,0x58,0x4C,0xA3,0x68,0x94,0x31,0x6D,0x76,0xAB,0xFC,0xDD,0x5C,0xF8,0xE6,0x03,0x8E,0x17,0x19,0xF3,0x03,0xED,
	0xF1,0x01,0xD1,0x8F,0x12,0xD3,0xE6,0x3B,0x7F,0x41,0x9B,0xDD,0xE8,0x6D,0x23,0xEA,0x41,0x31,0xED,0xD6,0xF2,0xAD,0x47,0xCF,0xB9,0x23,0xF8,0xF6,0x34,0x23,0xBF,0x08,
	0x34,0xD2,0xD8,0xC6,0xC1,0x81,0xBF,0x21,0xAB,0xCB,0x9D,0xD1,0x70,0x4C,0xF3,0x38,0xA7,0x69,0x7C,0x84,0xDC,0xAE,0x31,0x40,0x71,0x16,0x5A,0xEE,0x12,0x8C,0x2B,0x66,
	0x52,0x55,0xCC,0x74,0x4E,0xDB,0x92,0xEC,0x0E,0x41,0x73,0x6C,0x3C,0x98,0xC6,0x0C,0x37,0x6E,0x91,0x4B,0xF8,0x88,0x40,0xC7,0xCB,0x2B,0x5D,0x72,0xB4,0x36,0x1B,0x92,
	0x9D,0x41,0x6F,0x48,0xB3,0xBD,0x53,0x34,0xD1,0x90,0x76,0x63,0x9D,0x32,0x34,0xD2,0xFA,0x56,0xEE,0x6B,0x88,0xDE,0x80,0x6D,0x1B,0xBE,0xF7,0x77,0x0F,0xDD,0x33,0xD3,
	0x16,0xAE,0x38,0x13,0x0F,0x05,0x38,0x18,0xC8,0xB1,0x28,0x79,0x29,0xF4,0x35,0x50,0x7D,0x99,0x92,0x34,0xE5,0x5B,0xE5,0x0C,0xAD,0xF3,0xD4,0x20,0xE2,0x34,0x8A,0xC5,
	0x5A,0xE0,0x71,0x69,0xE6,0x9B,0xF7,0x9E,0xCB,0x2D,0x22,0x65,0xEE,0x55,0x76,0x33,0x58,0x23,0x9A,0x46,0xD4,0x8D,0xB2,0xB4,0x77,0x05,0x96,0x72,0xE8,0x98,0xCB,0x87,
	0xD4,0x6F,0x98,0xEE,0xD4,0x89,0x68,0x4B,0x9A,0x6E,0x94,0xA5,0xED,0x17,0x69,0xF0,0x19,0xA8,0x16,0xF0,0xDB,0x35,0x08,0x55,0x3E,0x49,0x3B,0x49,0xDD,0x96,0x3D,0x92,
	0x15,0x59,0x6C,0xC9,0x13,0x76,0x3C,0xF4,0xC4,0x5C,0x5A,0xCA,0xA9,0x6F,0x3B,0x95,0x5B,0x34,0x1D,0xA3,0xDF,0xA3,0xEA,0xB4,0x82,0xE6,0x98,0x41,0x60,0x2F,0x85,0x6F,
	0x0A,0x8F,0xF2,0xE0,0xCE,0xB9,0x52,0xBB,0x73,0x8E,0xBB,0xD8,0x1A,0xD1,0x0B,0x5D,0x4E,0x83,0x9E,0x6A,0xC4,0x31,0xDA,0xA2,0x0D,0x0D,0x56,0x55,0xC0,0x7C,0x30,0x29,
	0x9B,0x68,0xA0,0xAD,0xE8,0x64,0x6D,0x85,0xD1,0x62,0xA3,0xF5,0x60,0xDE,0x9D,0xCD,0xC1,0x16,0x72,0xBC,0x46,0x55,0xBA,0xD3,0x1F,0x8E,0x7B,0x24,0x2F,0x74,0x9D,0x84,
	0x39,0xF7,0x61,0x6C,0x5E,0x92,0x96,0x5D,0x9C,0xF3,0xE3,0x1E,0x51,0xC6,0x45,0xBC,0x4B,0x6F,0x55,0xAF,0x68,0x96,0xF1,0x60,0xE1,0x25,0xC6,0x5B,0xC4,0x34,0xDF,0xF6,
	0xA8,0x34,0x9D,0xEA,0xAB,0x8D,0x68,0x37,0x78,0xCC,0x9D,0xD6,0x94,0xB0,0x16,0x8E,0xB4,0x11,0xD5,0x42,0x61,0xB4,0x99,0xB9,0xD9,0xF9,0x26,0xCD,0x2F,0xC0,0xAC,0xE6,
	0x56,0x2B,0xAF,0xA0,0x89,0x8D,0x3C,0x14,0x5C,0x75,0xF1,0x01,0x69,0xDA,0xB2,0x85,0x56,0x31,0x5B,0xE2,0x19,0x96,0xB9,0xEF,0x61,0xF8,0xBE,0xAC,0x6F,0x05,0x67,0x21,
	0xD5,0x1E,0xE2,0xB4,0x07,0x98,0x1A,0x0B,0xAF,0x31,0xEE,0x27,0x43,0x33,0x06,0x7A,0x5E,0x7C,0x4A,0xD2,0x42,0xCF,0xDF,0x84,0xA4,0xAA,0x71,0x7F,0x7E,0xAB,0x31,0x99,
	0xA6,0x09,0xB7,0x66,0xFA,0x93,0x72,0x9B,0x81,0xD1,0xDA,0x68,0x83,0x45,0xDA,0xFC,0xFC,0xB8,0x7B,0x82,0xFB,0x35,0x08,0x43,0xF1,0x56,0xF4,0xE7,0x0B,0x9A,0x46,0xA7,
	0xDD,0x2A,0x53,0x6B,0x61,0x39,0x72,0x72,0x33,0xA6,0xE9,0x43,0xE2,0x1E,0x5E,0x19,0x8D,0xD7,0xEE,0x10,0xED,0x2F,0xF1,0x69,0x45,0x4B,0x02,0x6D,0x1B,0xE8,0xCF,0xAC,
	0x5B,0x14,0x9F,0x66,0x2D,0x1F,0x2C,0x0C,0x7F,0xAF,0xD0,0xE2,0x05,0xCD,0x78,0x11,0x1A,0x6E,0x5B,0xD4,0x54,0x2D,0xA6,0x3D,0xB7,0xDF,0x32,0x9B,0x22,0xA0,0xB1,0x94,
	0xD7,0x2E,0xA2,0xD1,0xC7,0xE4,0x07,0xFB,0x21,0x3E,0x60,0x2E,0x69,0xC6,0xE2,0xFE,0x24,0x68,0x47,0xB4,0xE8,0x83,0x22,0xED,0x0A,0xCF,0x28,0xC8,0x44,0xF8,0x31,0x5A,
	0x9B,0x31,0xC9,0x07,0x21,0xF3,0xC6,0xC9,0x5B,0x28,0x20,0x95,0x7B,0xAD,0xD6,0x80,0x38,0x48,0x12,0xC3,0x45,0xB7,0x6C,0x9F,0x2E,0xF6,0x02,0xD6,0xAC,0x01,0xDA,0xB0,
	0x95,0x9C,0x14,0x21,0x23,0x9F,0x51,0x7B,0x06,0x0D,0x09,0x34,0xE7,0x3D,0xE8,0xBF,0xC0,0xAA,0xAB,0x26,0xD6,0x4D,0x6B,0xDF,0x92,0x65,0xB4,0x3D,0xE5,0xD4,0x73,0x56,
	0xC2,0xCE,0xCD,0x8E,0x4C,0x4E,0xA3,0xED,0xD6,0x35,0xD2,0xC4,0xAE,0x53,0x91,0x17,0xD1,0x28,0xF3,0xCD,0xF3,0xC8,0xC1,0x29,0x49,0x4B,0xEA,0x23,0xA2,0x15,0x89,0xB7,
	0x59,0x5C,0x5A,0x2B,0xDB,0xFA,0xC4,0xEC,0xC5,0x47,0xF9,0x40,0x15,0xB4,0x45,0xFA,0x34,0xEB,0xE0,0x07,0x2B,0x80,0xA6,0x79,0x13,0xB4,0xD9,0xA9,0x18,0x68,0x7D,0x9D,
	0xE6,0x83,0x4E,0xD3,0x22,0xD1,0x8F,0x36,0x23,0x8B,0x45,0x63,0x13,0x81,0xF9,0x5A,0x6E,0xBC,0x4D,0xC1,0xC5,0xC2,0x69,0xA4,0xF5,0xAD,0x8C,0x06,0x0B,0x4D,0x0C,0x63,
	0x7F,0x03,0x56,0x89,0xA4,0x8C,0x68,0x84,0x31,0x59,0xA4,0xA1,0xE8,0x8F,0x61,0xF8,0x97,0x72,0x56,0x42,0x23,0xAC,0x6F,0x37,0x9E,0x83,0x47,0x73,0xDB,0x45,0x0B,0x0F,
	0x34,0xE2,0xBE,0x08,0xDA,0xDB,0x6D,0x50,0x8C,0x36,0x1A,0x12,0xF7,0xEA,0x6E,0xED,0x7F,0x81,0x12,0xD9,0x2A,0x14,0x1A,0x6C,0x7F,0x9D,0x18,0x15,0xD9,0x7D,0xE1,0x3F,
	0x89,0x46,0x56,0xF2,0xF2,0x0D,0xEF,0x72,0xE5,0xD1,0xC3,0x46,0x5A,0xD3,0xE2,0x33,0x0A,0xDA,0x6F,0x5F,0x1B,0x9D,0x3E,0xA4,0x00,0x0B,0xC3,0xFD,0xBD,0x53,0xBB,0x1E,
	0x65,0x69,0x68,0x0E,0xC9,0x2E,0x4E,0x23,0x41,0x8B,0xFC,0x44,0x81,0xA2,0xBC,0xF5,0xAD,0xE8,0xE6,0x19,0x76,0x91,0x0B,0x5E,0x53,0x61,0x59,0x2B,0x6B,0x55,0x6A,0x80,
	0x61,0x50,0xEF,0x58,0x56,0xA4,0x76,0x07,0x4A,0x57,0x1D,0x01,0xF0,0xC8,0xC6,0xC5,0xE7,0xD2,0x0C,0x68,0xF1,0xD1,0xA2,0x7A,0xBD,0x31,0x6D,0xED,0x8D,0x63,0x40,0x45,
	0x78,0x34,0x25,0x76,0x05,0x57,0x43,0xD9,0xA8,0x04,0x7D,0x7F,0xA4,0x2B,0xEA,0x70,0x7F,0x38,0x28,0x83,0x0A,0x91,0x8A,0xE2,0x7C,0x6E,0x6F,0xEB,0xF6,0xC2,0x38,0x54,
	0x52,0xB8,0x66,0xA0,0x39,0x2B,0x9A,0x19,0xD0,0x92,0x1D,0xDA,0xE9,0x17,0xC2,0x66,0x24,0x3A,0x32,0x56,0x47,0x03,0xF2,0x69,0x1A,0x74,0xB7,0x0C,0x69,0xA2,0x28,0x4D,
	0x53,0xCE,0x41,0xBC,0xDF,0x38,0xA6,0x2B,0xB7,0xA1,0x0F,0x82,0x4F,0xA5,0x86,0x05,0xA5,0x69,0x33,0x3C,0x20,0x2D,0xAF,0x68,0x68,0xBA,0xAE,0x12,0x03,0xF1,0xAA,0x9D,
	0x67,0xFC,0x0D,0xDE,0x63,0xC4,0xFD,0x23,0xBA,0xC9,0xE5,0xEA,0x5B,0x98,0x25,0x8D,0x6F,0xD0,0xE1,0x9B,0xF9,0xC2,0x93,0x4C,0x13,0x04,0x9D,0xD1,0x70,0x30,0x92,0x55,
	0x76,0xF0,0x2E,0xC6,0x61,0xCC,0xBB,0x30,0xFD,0x7B,0x8B,0x2C,0x77,0x80,0x37,0x96,0x75,0x68,0x65,0x79,0xFC,0xF4,0x09,0x0D,0xC7,0x79,0xB2,0x06,0x46,0x96,0x37,0xF7,
	0xED,0xAD,0x63,0xB5,0xA9,0x9F,0xEC,0x66,0x71,0x86,0xF7,0xEE,0xC4,0x31,0xE9,0xD4,0xCE,0xC0,0x18,0x48,0x6F,0x28,0x09,0x1E,0x5F,0x20,0x8F,0x0F,0x8E,0x70,0x7D,0x9C,
	0x85,0xBB,0x95,0x32,0x03,0xAD,0x8B,0x6E,0x0A,0xA0,0xC2,0x35,0x38,0x20,0x89,0xF4,0x84,0x16,0x79,0x9B,0xC4,0x35,0x03,0x60,0xD9,0xE7,0xED,0xA7,0x52,0x1A,0xC9,0x9C,
	0x22,0x94,0x5E,0x4A,0x3B,0x24,0xD1,0x0E,0x56,0x9F,0x2C,0x17,0xAF,0x91,0x81,0xC5,0xE3,0x72,0xB7,0xD9,0x3C,0xC9,0x13,0x05,0xED,0x40,0xDE,0x08,0x28,0x95,0x3B,0x87,
	0x16,0x8B,0x6D,0x0B,0x77,0x0B,0xBC,0x9C,0x0E,0x43,0x37,0x16,0xBE,0xF7,0x88,0x56,0xE3,0x86,0x1D,0xB3,0x9D,0x2D,0x2B,0x63,0x15,0xD9,0x1B,0x4C,0x48,0x61,0x07,0x7C,
	0x4D,0x8C,0x20,0x3C,0x2E,0x77,0x6D,0x59,0x0F,0xE2,0xF2,0x3E,0xC1,0x51,0xDE,0xDE,0x61,0x10,0x76,0x76,0xD8,0x0A,0xDA,0xE1,0xF8,0xE5,0x69,0x3E,0xB4,0x41,0x7E,0x8E,
	0x54,0xD0,0xBA,0x79,0x5C,0xB7,0xC0,0x43,0x55,0x67,0x8F,0x1B,0x54,0x80,0x0E,0x52,0xBA,0xC0,0x85,0xBD,0xAD,0xDC,0x2E,0xE7,0xBD,0x79,0x78,0x40,0xE8,0x4D,0x46,0xC4,
	0x68,0x8D,0x9D,0x7B,0x8F,0x3B,0x5A,0x55,0x01,0x1B,0x35,0xE3,0x67,0xB1,0x1D,0x2E,0x28,0xED,0x09,0xB4,0x5B,0xDF,0xDC,0x76,0x0F,0x7C,0x76,0x35,0x8B,0x3C,0x39,0xA2,
	0x2D,0x09,0x34,0xFB,0x9E,0x35,0xE0,0x1E,0x06,0xE3,0xE3,0x05,0x64,0xC9,0xD8,0xBC,0xF6,0x4D,0x17,0xD6,0x91,0x4B,0x6F,0x87,0xFA,0x56,0x91,0x1C,0xCD,0x8D,0x6B,0x02,
	0x8D,0x6D,0xA6,0x66,0x86,0xBF,0xCF,0xFC,0x6E,0xB8,0xED,0xB9,0xA7,0xDC,0xEC,0xB6,0xB6,0x53,0x15,0x10,0xC3,0x69,0x23,0x82,0xC9,0xCA,0x69,0x2C,0x1C,0x9F,0xDD,0xE4,
	0x88,0x11,0x53,0xC9,0x38,0x89,0x47,0x6C,0xB9,0xDB,0x92,0xD1,0x86,0xF2,0x23,0x25,0x45,0x63,0x13,0x1C,0x7A,0x6C,0x8D,0xCD,0x8A,0x40,0x1C,0x92,0x78,0x4B,0x61,0x55,
	0xFF,0x45,0x2D,0x39,0x90,0xA7,0x61,0x14,0x11,0x48,0x4F,0xEB,0x09,0x9B,0x0E,0x77,0x22,0xF9,0x69,0x1C,0x99,0x91,0x29,0x68,0xBA,0xFC,0x1C,0x2F,0x95,0x69,0xEC,0x0D,
	0xD0,0xC9,0x80,0xB5,0x13,0x5D,0xF9,0x0E,0x2A,0xBE,0xC1,0xDB,0x02,0xEA,0x64,0x4C,0x32,0x0F,0x47,0xC4,0xFA,0x36,0xD2,0x4A,0x64,0x4C,0x35,0xAD,0x4E,0xCA,0x00,0x11,
	0x0A,0x8F,0xA6,0x1D,0xEF,0xC3,0xFB,0x75,0xC8,0x96,0xFC,0x1A,0x61,0x9D,0x25,0x9E,0x11,0xD6,0x28,0x71,0x8E,0xC2,0x72,0xAC,0xD0,0x8B,0xE2,0x72,0x24,0xE5,0x4C,0x34,
	0x7A,0x08,0xAD,0x99,0x3E,0xDD,0x1A,0x35,0xAA,0x50,0xE3,0x6A,0xA7,0x45,0x42,0xEB,0xC9,0xD3,0x4A,0x47,0x4F,0xFA,0x0D,0x70,0x11,0x84,0x86,0x7D,0x87,0x0D,0x9B,0x6C,
	0x92,0x54,0x8C,0x9D,0xF8,0x0D,0x7E,0x22,0x48,0x02,0x19,0x5A,0xE9,0xD8,0xA9,0xA6,0x35,0x8C,0x9E,0x13,0xDF,0x5A,0x3E,0x00,0x92,0xED,0x25,0xE0,0xF8,0x91,0x57,0x79,
	0x84,0x14,0xCF,0xEC,0xD4,0x37,0xD4,0xEF,0x34,0x35,0x50,0xB9,0x47,0xF3,0x72,0x17,0xC2,0x40,0x5A,0xAE,0xBD,0xCA,0xC5,0x30,0x37,0x7A,0x08,0x63,0x95,0x39,0xD6,0x6F,
	0x4C,0xDB,0xE5,0x17,0xFF,0xCC,0xC0,0x66,0x0C,0xF9,0xCA,0x21,0xB7,0x42,0x1D,0xDE,0x0C,0xDE,0x13,0x69,0x53,0x6F,0x51,0xB2,0x05,0xD9,0xF4,0x27,0xA2,0x11,0x36,0xD6,
	0x40,0xA4,0x5A,0x2E,0x3B,0xC6,0xCB,0xFD,0x0B,0x62,0x7F,0xAB,0x72,0x11,0x2C,0xA1,0xFD,0x42,0xA5,0xB1,0xD9,0x17,0xB9,0x6C,0x9B,0xE6,0x5F,0x8E,0x76,0xD8,0x27,0xD1,
	0xEE,0xF1,0x2E,0xAF,0x53,0xEF,0xC9,0xB1,0xDE,0x9D,0x99,0x3E,0xFC,0x7C,0xE3,0x85,0x61,0xB2,0x9F,0xDC,0x34,0xE7,0xCE,0x68,0x2D,0xD9,0x48,0xAB,0x9F,0x73,0x05,0x5A,
	0xAD,0x5E,0x88,0x8E,0xEF,0xEE,0xA5,0x07,0xD2,0x33,0x3D,0x1B,0xD8,0x12,0x29,0x29,0xD3,0xCE,0x08,0xAB,0x3D,0x06,0xA4,0xE2,0xCD,0xA8,0xD7,0xA8,0x58,0xA4,0x14,0x8D,
	0x6F,0x9B,0x3B,0x30,0x1A,0x27,0x04,0x1D,0x3B,0x71,0xCD,0x44,0x17,0x13,0x70,0x57,0xBF,0xC4,0x92,0x1F,0xD1,0x08,0xE3,0x24,0x45,0xBB,0xB4,0x82,0xE0,0x49,0x88,0x14,
	0x19,0x5C,0x44,0x23,0x6C,0x9A,0xA4,0x69,0xDE,0x2E,0x08,0xCD,0xE5,0x9A,0x4B,0xCC,0xE6,0x99,0x10,0xD1,0x08,0xB2,0x2B,0xBA,0x69,0x81,0xD7,0xE9,0x1D,0xDF,0x91,0x41,
	0x51,0x16,0xC5,0xDE,0x55,0x57,0x30,0xD2,0x9B,0x7E,0x6C,0x4D,0x63,0x5B,0x32,0x72,0xB0,0x98,0xF6,0x83,0x3C,0x8D,0xFB,0x7D,0x58,0x95,0x2E,0x53,0x6A,0x91,0xB4,0x9D,
	0x02,0x2D,0xF9,0x81,0x40,0xB3,0xEE,0xC2,0x27,0x21,0x18,0xF9,0x02,0xC7,0xAC,0x5B,0x19,0x6A,0xA4,0xCB,0x13,0xFA,0xED,0xE2,0x7A,0x3E,0x55,0xB2,0xE6,0x83,0x72,0xEB,
	0xF9,0xBE,0x6D,0xAD,0xDE,0x31,0x23,0xBA,0x5A,0x84,0x09,0x2B,0xF3,0x92,0x30,0x26,0x09,0xB4,0xBC,0x08,0xAB,0xA2,0xD5,0xEB,0x0B,0x25,0x1A,0x12,0x7B,0x87,0x13,0x7C,
	0x07,0xD4,0x56,0x40,0x6B,0xD8,0x80,0xA2,0x0F,0xEA,0x67,0x93,0xA8,0x4E,0xBD,0x03,0xC1,0x9E,0x68,0xA4,0x55,0x88,0xEA,0x1A,0x5A,0xAD,0xB4,0xCE,0xF2,0x24,0x35,0xBF,
	0x2C,0x8F,0xB0,0x16,0xD5,0xD3,0xAA,0xAB,0x56,0x43,0xA3,0xD4,0x0E,0x6F,0x76,0x96,0xEC,0xBA,0x98,0x47,0x90,0xD7,0x4D,0xB4,0x9A,0xFA,0x55,0xD1,0x1A,0xB4,0x5B,0x46,
	0xE4,0x31,0xBD,0xA7,0xBE,0xF9,0x94,0xF5,0xFE,0x64,0x26,0x48,0xF9,0xEA,0x07,0x44,0x4A,0xE0,0x79,0xD5,0xEC,0x98,0xDB,0xD0,0x8F,0xEF,0x6E,0x3C,0x3B,0xF0,0x5C,0xE9,
	0xE1,0x13,0xBF,0x01,0xC1,0x7E,0xA8,0xA5,0xD5,0x0E,0x9F,0x4A,0x5A,0x43,0x0B,0x33,0x01,0x7E,0xE8,0xEF,0x73,0x0D,0x31,0x3A,0xF0,0xB5,0xF6,0x1C,0xAB,0xB1,0x91,0x23,
	0xCD,0x90,0x20,0xEF,0xF8,0x72,0xB1,0xF3,0xB7,0x91,0x91,0x24,0xCB,0x4A,0x68,0x04,0x59,0xC3,0x95,0x0A,0xA6,0x4E,0x88,0x75,0x1E,0x0B,0x5F,0x36,0xE9,0xD7,0x29,0x9A,
	0x4E,0x58,0x39,0x72,0xB4,0x44,0xC7,0x90,0xA7,0x11,0x7C,0xAF,0x29,0x9A,0xD0,0xD4,0xA8,0xBE,0x66,0xA3,0x15,0x6D,0x4F,0xE1,0x3E,0x66,0xE9,0x06,0x8D,0xEA,0x46,0x90,
	0xA2,0x69,0x5A,0x56,0x55,0xE3,0x6C,0x09,0x1A,0x61,0xCE,0x55,0xD3,0x1A,0xEB,0x17,0xD1,0x28,0x33,0xA0,0x92,0xD6,0xA8,0xD7,0x44,0x34,0x82,0xC4,0xBE,0xF4,0x5C,0x6F,
	0xE9,0xA4,0xBD,0x91,0x29,0x23,0x5A,0xC2,0x7A,0x58,0x6C,0x17,0x04,0xEF,0x80,0xA0,0xF1,0x6D,0x86,0x3D,0xD2,0x2C,0x88,0xBC,0x03,0xB2,0x34,0xBC,0x27,0xBE,0xC3,0xF7,
	0x58,0x98,0x82,0x2B,0xCE,0x57,0x32,0xD7,0xC0,0x3B,0xF8,0x56,0xEA,0xD0,0x6A,0xF5,0xFE,0xC3,0x21,0x69,0xB7,0x43,0x96,0x56,0xB5,0xFF,0x50,0x42,0xAB,0x5D,0xDB,0x39,
	0x2F,0x8B,0x62,0x3E,0x8A,0x23,0x0C,0x50,0xC8,0x68,0xDE,0xF9,0x2A,0x46,0x3C,0x8A,0xF4,0xA2,0xD0,0xB2,0x55,0xAC,0xA2,0xD5,0xD6,0x6E,0x0A,0xF6,0xF3,0xAD,0x65,0x06,
	0x8E,0x45,0xD8,0x25,0xCB,0x8C,0xCC,0xB5,0x9E,0xBA,0xB9,0xA0,0xA1,0x76,0x62,0x8B,0x21,0x11,0x5D,0xE2,0xE8,0x63,0xAD,0x06,0x91,0xA9,0xDD,0x88,0x30,0x52,0x6E,0x30,
	0x27,0xD2,0x2A,0x71,0xB7,0x70,0x18,0x5E,0xA7,0xB8,0xC6,0xE4,0x22,0x8D,0x3E,0x39,0x58,0xE5,0x08,0x3D,0x37,0x4D,0xA3,0xF8,0x24,0x7F,0xBF,0x0D,0xD8,0x45,0x48,0xF1,
	0xF6,0x40,0xDD,0x3E,0xD5,0x62,0x3B,0xB8,0x23,0xEC,0xA8,0x62,0x6A,0xA9,0x5D,0x80,0x07,0x98,0xB7,0x84,0x35,0x27,0x55,0xB7,0xB3,0x43,0x02,0xCD,0x5E,0x59,0x8B,0x1D,
	0x46,0x37,0x61,0xE5,0x8E,0xF0,0xE0,0xC0,0x53,0x4A,0xA6,0xF0,0xDA,0xD6,0xEE,0xC1,0xE9,0x57,0x2F,0x47,0x63,0x76,0x5A,0x3D,0xED,0xA7,0xE7,0x69,0x9B,0xF1,0x1B,0x60,
	0x54,0x31,0xFC,0xCA,0x8A,0x96,0xDB,0x78,0x4B,0xB7,0x72,0x53,0x20,0x9A,0x85,0x94,0x1D,0xE4,0x8E,0x08,0x26,0x66,0xB3,0x5B,0x88,0x6B,0x98,0xEC,0xFC,0x58,0xA0,0xA4,
	0x17,0xF2,0x67,0x4A,0xFB,0x32,0x5A,0x1B,0x1F,0x6B,0x44,0x23,0xAC,0xEB,0x7C,0x6F,0x83,0x5F,0x2A,0xA0,0xBC,0x3D,0x33,0xB7,0xDB,0xA7,0xBF,0x48,0x52,0x3B,0x23,0x4D,
	0x27,0x5E,0x7C,0xC4,0x37,0x35,0x9E,0xE5,0x13,0xB9,0x25,0xD4,0x8D,0x09,0x2E,0xE6,0x77,0x44,0x19,0x3D,0xF7,0xBC,0x46,0xAF,0x71,0x8E,0x36,0x22,0xE8,0xD1,0x22,0x78,
	0xA0,0x64,0x03,0x5E,0x44,0x35,0x57,0x6F,0xA7,0x46,0x34,0x82,0xF6,0x17,0xD1,0xB2,0x5E,0x11,0x12,0x8D,0xA0,0x21,0xB1,0x0D,0xBE,0xA8,0x6E,0x14,0x9D,0x3D,0xD1,0x59,
	0x28,0x63,0x32,0x4D,0x8B,0x4D,0x05,0x3E,0xD5,0x25,0xD7,0x21,0x82,0xAE,0x99,0xDD,0x0A,0x92,0x73,0x75,0x66,0x69,0x3D,0x4A,0x4B,0x16,0x68,0x60,0xC2,0x32,0x5D,0xB3,
	0xB1,0x59,0x23,0x1A,0xA5,0x25,0x0B,0x34,0xE9,0xF0,0x85,0x88,0x46,0x19,0x93,0x69,0xDA,0x5E,0x76,0x54,0x5E,0xDA,0x4B,0xDF,0xDB,0xAE,0xF1,0xAE,0xA7,0x9A,0x31,0xD9,
	0xA3,0xCC,0xB7,0x88,0x76,0x8B,0xD7,0xCB,0x90,0x24,0x65,0x44,0x23,0x8D,0x12,0xB1,0xB4,0xE4,0xCC,0x11,0x1C,0xAA,0x92,0x5A,0x3B,0x65,0x94,0xDC,0x8A,0xA3,0x2B,0xE2,
	0xF2,0x00,0xEE,0x49,0x16,0x82,0xA5,0xBE,0xE7,0x04,0x6D,0x46,0xD1,0x1F,0x6E,0xCB,0xA4,0x16,0xAE,0xA1,0xB2,0xFB,0x5E,0x33,0x82,0xFD,0x83,0xB4,0xA2,0xD4,0x6A,0xB4,
	0x59,0xD3,0x34,0xC2,0x5E,0x4D,0x91,0x46,0xF5,0x00,0xCC,0x28,0xA3,0xE4,0x56,0x1C,0x7D,0xBF,0x34,0x77,0xD2,0x11,0x03,0x59,0x1A,0x21,0x6E,0x00,0x68,0x62,0x63,0x9B,
	0xB7,0x21,0xBB,0x44,0x40,0xAE,0xB6,0x11,0xED,0x88,0x44,0x63,0xDB,0x77,0x19,0xCF,0x06,0x49,0x4E,0xCE,0x28,0xB2,0xE4,0x36,0xB7,0x59,0xF8,0x2D,0x1E,0xF3,0x47,0xB3,
	0x5C,0x76,0x77,0x74,0x36,0x79,0x59,0x5A,0xFD,0xEE,0x68,0x81,0x56,0x6B,0xD7,0xB1,0xB3,0x9B,0x51,0xF4,0x4C,0x32,0xB1,0xF7,0x78,0x17,0xCA,0xC4,0x42,0xCD,0x08,0x96,
	0x16,0xD0,0x32,0x47,0xC1,0x05,0x91,0xC7,0x5D,0x4B,0xC9,0xAE,0xD9,0x31,0x8D,0x26,0xD4,0xBC,0xC6,0xC0,0xAE,0x0A,0x1A,0x65,0x85,0xBB,0x15,0x32,0x98,0x09,0x11,0xD2,
	0x4C,0x8F,0x68,0x34,0xB9,0x3C,0xDF,0x05,0x0F,0x20,0x98,0xA7,0x78,0x71,0xBA,0x64,0x88,0x57,0x86,0x36,0x97,0xA7,0xCD,0xCD,0x9C,0x90,0x3C,0xA9,0xB1,0xAD,0x4A,0x69,
	0x67,0x04,0xD9,0x35,0xF7,0xED,0x85,0xE9,0xA4,0x22,0x49,0xC8,0xB4,0x03,0xC2,0x8C,0xFB,0x00,0xC6,0x93,0x0D,0xF5,0xE3,0x83,0x84,0x14,0x35,0x17,0xD1,0x08,0xD2,0x04,
	0x69,0x50,0x2F,0x4C,0xEB,0x1E,0x85,0x23,0x7C,0x2B,0x89,0x16,0xD6,0xBF,0x49,0x58,0x73,0x3E,0xD8,0xEE,0x12,0x13,0xB1,0x4D,0x7C,0x73,0xB1,0xB0,0xDE,0x51,0x9C,0x38,
	0x91,0xD7,0xA6,0x2F,0xEF,0xB5,0x49,0xC2,0x01,0xD2,0xA1,0xCC,0x52,0x6E,0x45,0xD1,0x92,0x57,0xCF,0xDC,0xFD,0x61,0xC7,0x97,0x85,0x41,0x92,0xF1,0xB3,0xE0,0x6D,0x3D,
	0x6F,0x02,0x4C,0x6A,0x54,0x65,0xC9,0x46,0x9E,0x1C,0xF9,0x19,0xCF,0x78,0x7E,0xCA,0xE3,0x10,0x39,0x01,0xA4,0x96,0x24,0xD1,0xBE,0xBA,0x25,0xDF,0x9B,0x65,0x87,0xFC,
	0xAE,0x3C,0xB7,0x1B,0xA7,0xFE,0x43,0x77,0x55,0xF0,0x55,0x0E,0x08,0x96,0xB6,0xBE,0xB8,0x3B,0xEC,0xF7,0x9D,0xBD,0xA2,0x5D,0xEB,0xA8,0xF0,0x2B,0xC4,0x64,0x4F,0x45,
	0x68,0xFC,0x96,0xD8,0x2C,0x2E,0x7D,0x8A,0x97,0xA9,0xA6,0xDF,0x66,0x03,0xCD,0x3B,0x45,0x9C,0xE4,0x61,0x01,0x8E,0x43,0xA0,0xBB,0x5B,0xD8,0x41,0xFD,0xBD,0x48,0x55,
	0xF5,0xC3,0xEB,0x16,0x65,0xCF,0x29,0x45,0xF5,0x4B,0xE1,0xF0,0x92,0x29,0xE6,0x3A,0x88,0x62,0x95,0x6B,0x2F,0x09,0x14,0x38,0x49,0x77,0xB9,0xC0,0x1D,0x13,0xEE,0xCE,
	0xCB,0xD7,0xCE,0xD0,0x87,0xD2,0x17,0xC0,0x25,0x38,0xDE,0x65,0x7C,0x27,0x53,0x26,0x48,0x30,0x8B,0x23,0xF5,0x5E,0xE7,0xF8,0xD1,0xA3,0x1F,0x81,0x14,0xB8,0x81,0x31,
	0x92,0xBE,0x60,0x41,0xE0,0x4E,0xBD,0x85,0x43,0x39,0xFE,0x98,0xA9,0x9D,0xA6,0x4A,0xDF,0xF5,0x2E,0x70,0x97,0x98,0xE6,0xC0,0x74,0x59,0x46,0x0E,0x71,0xAD,0x83,0x63,
	0xCB,0x1D,0xA3,0xEF,0xE8,0xBD,0xC2,0x81,0xC4,0x4A,0x9C,0xAE,0xD5,0xE0,0xE2,0x1D,0xE2,0x00,0xE3,0xB6,0x2A,0x82,0x59,0x39,0x4E,0xB2,0xEF,0xE4,0x70,0x75,0x2E,0xF3,
	0x08,0x27,0xA5,0x7D,0x44,0x38,0x0B,0x33,0xAA,0xB1,0x0B,0xD8,0x19,0x11,0x0D,0x37,0x76,0x6E,0x17,0x5D,0xCC,0xF5,0xA7,0xAE,0xD8,0xAD,0x26,0xB2,0xD3,0x5C,0xE0,0xF0,
	0x42,0x11,0x6F,0xE9,0x39,0xCD,0xA5,0x97,0xE1,0x8C,0x91,0xEC,0x11,0xDD,0x48,0x8C,0x95,0x08,0xEE,0xA9,0xB7,0xB2,0x85,0x04,0x45,0xE5,0x9C,0xE4,0xC0,0x30,0x86,0x85,
	0x0B,0xB7,0x9B,0x46,0x6B,0x0A,0x97,0x1C,0xD2,0xE1,0x97,0xAB,0x34,0x6A,0x5C,0x0C,0x47,0x15,0xDC,0xB3,0xAD,0xE7,0xDE,0x5B,0x87,0x5E,0xD9,0xF5,0x8A,0x4D,0xF5,0xEB,
	0x1B,0x23,0xE9,0x7B,0xA9,0xF9,0x21,0xEF,0x98,0x26,0xAE,0x05,0x41,0x4F,0xB6,0xAC,0xB3,0x97,0xD1,0x24,0x0F,0x24,0x8F,0x92,0x03,0x7A,0x67,0x1E,0x46,0x23,0x53,0x6B,
	0xC7,0x55,0x1E,0x92,0xDB,0xFC,0x17,0x6F,0x65,0x8A,0x29,0x28,0x8E,0x05,0x99,0xBE,0xEC,0x3D,0x35,0x86,0x3A,0x22,0x0E,0xD6,0xFF,0xDD,0x57,0x22,0x7C,0xF3,0xA7,0x7F,
	0x1C,0x5E,0x1F,0xFD,0x82,0x67,0x3E,0x99,0x3C,0x6D,0x07,0xEF,0x8C,0xF3,0xD7,0xF5,0x34,0xD6,0xF4,0xFF,0xA8,0x60,0x54,0xA6,0xA3,0xFC,0xE4,0xC9,0x48,0xBB,0xC9,0xF5,
	0x72,0x03,0xED,0xCD,0xEC,0x0D,0x4F,0x00,0xC1,0xFC,0x1E,0xEF,0xC4,0x65,0x28,0x72,0xD3,0x05,0x69,0x9A,0xDE,0x8A,0x86,0xE6,0xC1,0xBB,0xDA,0x1D,0xC9,0x52,0x5A,0x2E,
	0x63,0x56,0x03,0x4D,0x63,0xD7,0x2B,0x61,0x8E,0xFA,0x0B,0x0B,0x11,0x41,0x74,0x6E,0x80,0xAB,0x6F,0xB5,0x91,0x31,0x48,0x3B,0xF8,0x89,0x42,0xD3,0xBB,0x37,0xB6,0xB5,
	0xC4,0x23,0x89,0x76,0xB8,0x17,0x6D,0x99,0xAF,0x6D,0x91,0x87,0x19,0x2B,0x3C,0xB7,0xAB,0x62,0xC3,0x90,0x76,0x74,0x48,0xA1,0x1D,0x80,0x99,0x7A,0x6A,0xEE,0xEE,0x2D,
	0xB1,0x77,0x80,0x49,0xD7,0x49,0xFD,0x36,0x26,0xD2,0xD0,0x0B,0x26,0x72,0x35,0x22,0xF1,0xCD,0xC1,0xF9,0xF4,0x0D,0xAC,0xCC,0xAB,0xFB,0x86,0xE1,0xC2,0xC7,0x64,0xBF,
	0x3D,0x8D,0xE6,0x3D,0x65,0xA3,0x64,0x40,0xA2,0xE1,0x79,0x1C,0x1F,0xEC,0xC8,0xD0,0xBE,0xA3,0xEE,0xB3,0x22,0xAD,0x47,0x6B,0x49,0x7F,0x19,0xDA,0x4B,0xE0,0xF8,0x0F,
	0xA6,0x72,0xA0,0x92,0x76,0x3E,0x91,0x36,0x3C,0x68,0x4F,0xD3,0xE8,0x34,0xDA,0x98,0x0C,0x42,0x9F,0xD8,0x5F,0x19,0xDA,0xE0,0x84,0x44,0xDB,0x85,0x9E,0xEF,0x61,0x32,
	0xE3,0x76,0x72,0x52,0x1B,0x12,0x68,0xE5,0x16,0xB7,0xB8,0xB9,0xE6,0x07,0x93,0xCD,0xBE,0xC7,0x77,0xB0,0x1E,0xDF,0x3B,0xD6,0xBB,0x37,0xB3,0xCB,0xB3,0x37,0x8A,0xE7,
	0xB2,0xFC,0x6B,0x35,0x33,0xFE,0x27,0xCA,0xAC,0x00,0xDE,0x21,0x3A,0x1A,0xEE,0x53,0x3B,0xD9,0x98,0xF4,0xD6,0x69,0x38,0xB1,0x90,0xE6,0x91,0x56,0x06,0x41,0xDB,0xCB,
	0xA1,0x62,0xF8,0xA1,0xE5,0x54,0x7A,0x73,0x18,0x8D,0x94,0xD0,0x94,0x27,0xA3,0xC0,0x68,0x07,0xEA,0xD5,0x03,0x9C,0xB6,0xD0,0x48,0x34,0xB6,0xF0,0x4C,0x40,0x6F,0x33,
	0xFD,0x94,0x00,0x95,0xB1,0x81,0x91,0xB6,0x0D,0x42,0x3A,0xED,0xC8,0x16,0xF7,0xD3,0xFD,0xDD,0xDE,0x4A,0x0B,0x6D,0x46,0xEB,0x2D,0x5A,0xD0,0x76,0xEE,0xBD,0xE9,0x37,
	0xEE,0x93,0x97,0xB4,0xA4,0x4A,0x92,0x30,0x91,0xF3,0xD4,0x59,0x7A,0xAD,0xFA,0xCD,0x20,0xE9,0x0F,0x82,0xB6,0x0B,0x77,0x3E,0x15,0xC7,0x25,0x0C,0x49,0x9E,0x31,0x5A,
	0x88,0xA4,0x73,0x72,0xD4,0x1D,0xD2,0xFA,0xF4,0x31,0xC9,0x69,0x54,0x1C,0xA7,0x51,0xE6,0x5B,0xF9,0x7D,0x18,0x8E,0xB7,0x0B,0x58,0x10,0x95,0xC3,0x95,0x16,0xAA,0x7C,
	0xA1,0xAC,0xBB,0xDF,0x88,0x3B,0x15,0x78,0x50,0x80,0x1B,0x0A,0x4F,0x54,0xBD,0x67,0x2D,0xC3,0xDB,0x6A,0x16,0xAD,0x7D,0x81,0x26,0xAE,0x76,0x3F,0x04,0x1B,0x58,0xA6,
	0x5A,0xE9,0xDA,0x19,0x57,0x64,0x5A,0xAB,0x49,0x28,0x66,0x21,0x71,0xA4,0x02,0xAD,0xD5,0xB4,0x10,0xF3,0x62,0x42,0xA7,0xB1,0x1C,0x7C,0x01,0x2E,0x73,0xA0,0xD7,0xAE,
	0x84,0xAA,0xDB,0xB8,0xAF,0xC1,0x56,0xDE,0xD3,0x4C,0x16,0x2D,0x19,0xDA,0x99,0xE7,0xDB,0xFF,0xF2,0xDC,0x10,0xC4,0xA7,0xE4,0x08,0x89,0x68,0x5B,0x75,0x45,0xAE,0x5B,
	0x2E,0xFB,0xD9,0xF5,0xDD,0x1D,0x8C,0x96,0xE6,0x53,0x96,0x58,0x37,0x7D,0xFA,0x5C,0x9A,0xAC,0x1B,0x96,0xD1,0xE8,0x63,0x12,0x8D,0x59,0xD1,0x5B,0x04,0x15,0x8D,0x5B,
	0x28,0x47,0x64,0x5A,0x62,0x00,0xCD,0xCC,0x3B,0x2B,0x7C,0x92,0xEB,0x3D,0x6E,0x33,0x9C,0xD2,0x69,0xAC,0xF0,0x55,0x3C,0xEF,0xE4,0x7C,0xDA,0x7C,0xBE,0xD1,0xFB,0x8D,
	0xDD,0x54,0x16,0xB0,0x0A,0x8A,0xF3,0xE9,0x60,0x5A,0x32,0xF5,0x68,0x57,0x33,0x09,0x19,0xED,0x96,0xA6,0xF9,0x95,0xCA,0x6A,0x78,0x83,0x0F,0x56,0x00,0xA6,0x66,0x4A,
	0x8D,0x91,0xC9,0xAE,0x28,0x6C,0x5B,0x7A,0x7D,0x0B,0xB4,0x39,0x7C,0xA0,0xCC,0x77,0x0B,0x09,0x4B,0x7A,0xD6,0x92,0x26,0xF4,0xB2,0xBD,0xD4,0x40,0x3A,0xC2,0x78,0xDB,
	0xCA,0x7D,0x3D,0x46,0x9B,0xB7,0xA4,0xCD,0x3D,0xCF,0xC9,0xB0,0x0E,0x31,0x4D,0x4B,0xCD,0xD9,0x63,0x46,0x7B,0x4F,0x5C,0xF5,0xA0,0x4C,0x2B,0x36,0x1A,0xA2,0xED,0x67,
	0x29,0xF1,0xC9,0x6D,0x32,0x9A,0x16,0x9F,0xA6,0xF1,0xA5,0x7D,0x4F,0x12,0xCA,0x6B,0x47,0xB2,0xDC,0x79,0xE0,0x05,0x6F,0xCC,0x83,0x60,0xE9,0x89,0x56,0xAC,0xB6,0x14,
	0x72,0x34,0x9D,0xB6,0xEA,0xA5,0x68,0x87,0x3B,0x76,0xB1,0x47,0xB4,0x39,0x87,0xE9,0xB5,0xBD,0xC7,0xB0,0xCA,0xE1,0x22,0x66,0x21,0xC9,0x72,0x3F,0x64,0x77,0x77,0x70,
	0x77,0xF9,0x35,0x5E,0xB5,0xC1,0xAF,0xDE,0x95,0x70,0x81,0x08,0x09,0x43,0xB2,0x6E,0x27,0xB0,0x14,0xEC,0x09,0x5F,0x12,0xAF,0x61,0x6C,0x78,0x9D,0x78,0x75,0x63,0x32,
	0xAA,0xDB,0x88,0x46,0xE3,0x6A,0x91,0x6F,0xC1,0x0F,0x5B,0xC7,0x24,0x18,0xD5,0x5C,0x37,0x22,0x8D,0xC9,0xAC,0x12,0xC6,0x02,0x04,0x1C,0xCF,0x94,0x72,0x04,0x72,0xDA,
	0x59,0x0B,0xDA,0x64,0x6D,0xDA,0xEE,0x06,0x33,0xB0,0x13,0x62,0x75,0x18,0x8D,0x64,0xC7,0x46,0x34,0x4C,0x0F,0x86,0xC7,0x51,0xED,0xAA,0xC4,0x75,0x55,0x34,0x92,0xCD,
	0x20,0x68,0xE2,0x4C,0xE3,0x81,0xBF,0xF1,0x76,0xB2,0xB1,0x48,0x9C,0x46,0x5A,0x63,0x05,0x6D,0x6A,0xAD,0xDE,0xB1,0xF3,0xC5,0x54,0x6F,0x92,0x41,0xF1,0xB8,0xE0,0x6D,
	0xBD,0x01,0x1B,0xFE,0xD7,0xDD,0x29,0xCE,0x67,0x69,0x49,0x22,0x68,0x87,0xB4,0x19,0xB0,0xB6,0xA8,0xDE,0xBF,0x34,0x6D,0x9B,0xCB,0xC6,0xD4,0x44,0x13,0x59,0x98,0xD8,
	0x75,0xAB,0x2D,0xAC,0x83,0x31,0x6D,0xBE,0x39,0xB0,0x8A,0x3E,0x7A,0x78,0x55,0x17,0xF5,0x30,0x09,0xA3,0x4D,0xB2,0x29,0x46,0x9B,0x68,0x9E,0x1F,0x58,0x49,0xD6,0x8B,
	0x95,0x1D,0xAC,0x45,0x40,0xDE,0x05,0x54,0xB6,0x76,0x32,0xB0,0x96,0x34,0x1E,0x49,0x75,0x63,0x25,0x83,0x11,0x82,0x57,0x91,0xE1,0x52,0xFE,0x0E,0xEF,0xCC,0xDF,0x6D,
	0xD8,0xAA,0xFE,0x13,0x28,0xD4,0xCC,0xEF,0x5F,0xE9,0x83,0xDB,0x1A,0xFF,0xA4,0xD0,0xD8,0x7D,0x67,0xE2,0x78,0x1C,0x4A,0x65,0xEE,0xC7,0xE1,0x27,0xB4,0x51,0xFB,0xAB,
	0xF4,0xF0,0x0B,0xDA,0x62,0x48,0xB1,0x7C,0x8E,0x1E,0xF8,0x09,0x99,0x5D,0xB0,0x8C,0x42,0x7B,0x65,0xDD,0x7E,0x8C,0xF6,0x3B,0x49,0x96,0x1C,0x3D,0x70,0x2D,0x36,0xDD,
	0x7F,0x17,0xFC,0x76,0xE7,0xA6,0x79,0xC7,0x5B,0xF2,0x33,0x95,0x66,0x3E,0x89,0xA0,0xD7,0xBD,0xF4,0xA5,0x4E,0xC2,0x13,0xD8,0xA0,0x75,0x1D,0x92,0xA4,0xB2,0xB8,0xEB,
	0xF7,0xAC,0xE9,0x40,0x61,0xC9,0x1F,0x2E,0xB9,0x48,0x7A,0xC9,0xF1,0xE7,0xAD,0x03,0xF6,0x2A,0xDE,0x21,0x45,0xDD,0xC0,0x60,0x2D,0xD9,0x27,0xE9,0x5C,0xC7,0x9F,0x43,
	0xDF,0xC2,0x9B,0x70,0x2D,0x73,0x13,0x69,0x95,0x92,0x5C,0x6E,0x67,0x91,0xFC,0x7D,0x27,0x26,0x18,0xE1,0xC1,0x93,0x72,0xEC,0x9B,0xCA,0x0D,0x68,0x0B,0x18,0x1A,0x3D,
	0xF5,0xB6,0x96,0x84,0x68,0xE6,0xA3,0xE4,0x13,0x89,0x26,0x0E,0xEB,0xDB,0x3E,0x45,0x25,0x49,0xEA,0xA6,0x93,0xD6,0x00,0x41,0x4B,0x6D,0xDD,0xC1,0xE2,0xB3,0x85,0x6E,
	0x14,0xAD,0xDA,0x68,0xE5,0x1C,0x3F,0xD7,0xAA,0x4B,0xDF,0x88,0x77,0x66,0xFA,0x8E,0xF5,0xFB,0xCE,0x16,0xB1,0xB1,0xEF,0xC4,0x79,0xAE,0x5A,0xBB,0xF2,0x90,0xD2,0x97,
	0x39,0xDE,0x45,0x28,0x04,0x19,0x1E,0xF8,0xB8,0x13,0xD7,0x74,0x99,0x4F,0x55,0x1D,0xCB,0x6D,0x91,0x5F,0x48,0xED,0x6B,0x7F,0x82,0x71,0xC2,0xD4,0x68,0xE5,0xC4,0xF6,
	0x41,0x6F,0x89,0x52,0x59,0xC9,0x8D,0x54,0x8D,0x34,0xE7,0xF1,0x04,0x71,0xC0,0x44,0x89,0x10,0xD2,0x32,0x11,0x2E,0x29,0x9A,0x41,0xDA,0x45,0x4C,0x68,0x99,0xBD,0x05,
	0x69,0xFF,0x43,0x9F,0xB4,0xA2,0xA7,0x69,0xE8,0xD5,0x94,0x87,0x89,0xBA,0x91,0x2C,0x9F,0x84,0x76,0x69,0xFA,0x78,0x95,0x9B,0x3C,0x8F,0xD3,0x68,0xB3,0x10,0x75,0x58,
	0x31,0x4A,0xD0,0xFE,0xE1,0xAE,0x06,0x76,0xF5,0x5F,0x93,0x58,0xE3,0xF2,0x8C,0x14,0x23,0x10,0x5B,0x54,0x48,0x51,0x7B,0x3D,0xE5,0x88,0xD7,0xED,0xD0,0x76,0xAA,0xEE,
	0xBC,0xCD,0xD0,0x6E,0x49,0xD2,0x93,0xD1,0x52,0x57,0xAB,0x51,0x35,0xB1,0x01,0x69,0x06,0x30,0xDA,0x85,0xED,0xB9,0x89,0xEE,0x0C,0x3F,0xA3,0xFA,0xCE,0x65,0x89,0x50,
	0x8F,0xCA,0xDE,0x82,0xF7,0xDB,0x05,0x99,0x96,0xD9,0x26,0x14,0x0B,0x7A,0xCA,0x4F,0x56,0xE7,0xB5,0x19,0x92,0xB4,0x15,0x16,0xAE,0x92,0xEC,0x45,0x36,0xE9,0x0C,0x79,
	0xDA,0x76,0x41,0x9A,0x6F,0x42,0x33,0x6A,0xB3,0x79,0xC0,0x5B,0x92,0x14,0x49,0xC2,0x69,0xCF,0xD8,0xC1,0xFB,0x81,0x4E,0x8B,0xFC,0xB2,0xEC,0x52,0x5D,0xA1,0xF5,0xCD,
	0x58,0x62,0xB2,0xA6,0xF9,0xA6,0x93,0xBC,0x6D,0xA7,0xFE,0xD3,0xDD,0x9D,0xED,0xAE,0x58,0xA6,0x07,0xFB,0xCE,0xF3,0xCB,0x53,0x21,0x55,0xD6,0xED,0x8C,0x34,0x03,0xCE,
	0xBC,0xFB,0x47,0x18,0xE3,0x01,0x99,0x15,0xD1,0x48,0xA3,0x04,0x53,0x76,0xE1,0x4E,0xC8,0x23,0xB4,0x1F,0x1B,0xEF,0xE2,0x22,0x43,0xE6,0xC3,0x7C,0x07,0x3A,0xE8,0x63,
	0xC0,0x5D,0x53,0xE5,0xAB,0xE9,0x76,0x48,0xB2,0x45,0xCE,0x50,0x4F,0x6F,0xA5,0xD2,0x8A,0xD5,0xF4,0x92,0x62,0x8B,0x9C,0xDD,0x88,0xCC,0xD2,0xD1,0x8D,0xCF,0xAC,0x96,
	0x96,0x9F,0x9E,0xE8,0x38,0xF9,0xAB,0xEA,0xB6,0x26,0xAD,0x01,0x11,0x8D,0xCD,0xF2,0x34,0x89,0xDD,0xF7,0xAC,0x9C,0x80,0x39,0xB4,0xAE,0xC0,0x71,0x1A,0xC9,0xD3,0x10,
	0xD1,0x84,0x9A,0xC7,0x9C,0xCC,0xF9,0x6A,0xD6,0x59,0x75,0x6B,0x92,0xA6,0x50,0x42,0xE3,0xB5,0xCA,0x54,0xB6,0xDA,0x62,0x5D,0x93,0xAC,0x83,0x78,0x73,0x69,0x06,0x72,
	0xD2,0xA6,0x9D,0x54,0x63,0xB3,0x9B,0xE6,0xDD,0x2E,0xD1,0x69,0xA3,0x9C,0xC8,0xC2,0x3D,0x85,0x6D,0x8A,0xAB,0xFA,0x25,0xB6,0xF0,0x87,0xFA,0x9D,0x6E,0xAE,0xD3,0x52,
	0x6C,0x2F,0xE4,0x7D,0x7A,0x52,0x8E,0x40,0x61,0x21,0x65,0x04,0x48,0xF3,0x48,0xED,0x1B,0x3B,0xD6,0x99,0x1B,0xB8,0x31,0xD2,0xAF,0x40,0x1B,0x92,0xF6,0x61,0x62,0x1A,
	0xF7,0x35,0x44,0xAE,0xE1,0x43,0x6F,0x07,0xDA,0x92,0x0B,0xDD,0x5B,0x73,0xC3,0x1F,0xF3,0xE4,0x64,0xC3,0x35,0x25,0x69,0x29,0x87,0xC7,0x9E,0xD8,0xEA,0xC2,0xB9,0xD7,
	0x5D,0xAE,0xED,0x2A,0xA7,0x19,0x6F,0x49,0x52,0x6C,0x47,0x44,0xBB,0xB1,0xDD,0x87,0xC8,0xFA,0x62,0x8E,0x3F,0xCF,0x6D,0xF2,0x78,0x70,0xE9,0xB9,0x6E,0x45,0xF3,0x52,
	0xFD,0x27,0x52,0x57,0x34,0xF4,0x1E,0xEF,0x37,0xD2,0x8A,0x1E,0xD1,0xB0,0x64,0x1E,0xFA,0x43,0xDA,0x3B,0xD8,0x0E,0x49,0x12,0x26,0xA2,0x65,0x0C,0x59,0xB9,0x78,0x0E,
	0x6E,0xC7,0x92,0x64,0xB5,0x90,0x63,0x2C,0x97,0xC3,0x45,0xC8,0x5B,0x50,0xA8,0xEF,0x47,0xE8,0x9B,0xAB,0xD9,0x64,0xE2,0x2D,0xF9,0xF7,0xB6,0xB4,0x64,0x9F,0xEE,0xC6,
	0xC7,0xEB,0x1F,0x1B,0x8F,0x65,0x61,0x4B,0x92,0x22,0xB7,0x7E,0xC0,0xFD,0x82,0xB4,0x6A,0xF4,0x46,0xD3,0x87,0x83,0xD1,0x1B,0x59,0x8B,0x75,0xF8,0x23,0x85,0x76,0x61,
	0xEE,0xDC,0xE5,0x1A,0xAC,0xAB,0xCD,0x86,0xAD,0x0A,0x51,0xAC,0xED,0xF1,0xEF,0x3B,0x7B,0xBB,0xB1,0xDC,0x1A,0x7B,0x81,0x47,0x3A,0xFC,0x4E,0xA2,0x09,0x2D,0xAF,0xD9,
	0xB9,0x51,0x5E,0x37,0x8D,0x34,0x4A,0x72,0x34,0x66,0x90,0x48,0x8C,0xFE,0xA4,0x25,0x29,0xEB,0x50,0x8E,0x16,0xCF,0xEE,0x37,0x37,0xD7,0x17,0xE7,0x93,0xE3,0x37,0x35,
	0x81,0x99,0x62,0x94,0xB8,0x14,0xDD,0xA8,0xA4,0x6E,0xD1,0x8A,0x6E,0x3E,0xD5,0x6F,0xB2,0xF2,0xF9,0x46,0xB2,0xC6,0x2F,0xEC,0x3B,0x4C,0xF7,0x1C,0x26,0xE3,0xE3,0xFC,
	0x48,0x99,0x48,0x45,0x8E,0xF0,0x96,0x24,0xD2,0xF0,0xEA,0x76,0xB4,0xB1,0x3C,0xE1,0x6C,0x80,0xFA,0x58,0x8E,0x8C,0xCE,0xC9,0x2D,0x1F,0xCA,0xAE,0x67,0xF5,0x9D,0xB2,
	0xA8,0x3B,0xF8,0xD1,0x35,0x47,0xCC,0x92,0xFD,0x56,0x58,0x7E,0x7C,0xDF,0xB7,0x66,0x97,0xF7,0xB2,0x4F,0xE8,0xCB,0x88,0x17,0xF9,0x1F,0x58,0xDF,0xF1,0xB3,0xAD,0x7E,
	0xD3,0xEE,0x45,0xC4,0xD3,0x48,0x63,0x07,0x69,0x6C,0xFB,0x73,0x8F,0xFB,0x51,0xE5,0xB7,0xB9,0x38,0x4D,0x25,0xD5,0xAE,0xAA,0x7D,0xCB,0x54,0x5F,0xB6,0xC1,0x21,0x51,
	0x5F,0xBD,0x45,0xFB,0x46,0x53,0x86,0xF5,0xAB,0x68,0xE0,0xBA,0x9E,0x4C,0xF3,0x7A,0x2F,0x52,0x63,0xB1,0x2C,0xB2,0xDA,0x66,0x86,0xD5,0xA1,0x59,0x73,0xF2,0x86,0xBF,
	0x81,0x41,0xAB,0xF1,0xA5,0x79,0x0F,0xC2,0xDB,0x54,0x7E,0xDA,0x41,0x8B,0xC2,0x7C,0xDA,0x98,0x8D,0x77,0x05,0x65,0x78,0x87,0xA4,0xD5,0xFF,0x12,0xD7,0x2C,0x96,0x12,
	0xB3,0x9D,0xFE,0xAB,0x92,0x62,0x75,0xB8,0x47,0x90,0xDD,0xA1,0x1F,0xEF,0xB6,0x49,0x4A,0x08,0x2E,0x1F,0x48,0x72,0xFD,0xD2,0x7C,0x32,0x13,0x6D,0x70,0x4F,0x11,0x77,
	0x55,0x88,0xBE,0xFC,0x56,0xB9,0x32,0x3F,0x59,0x15,0x1B,0xFC,0x5C,0xD2,0x92,0xE2,0x1C,0x2F,0xAD,0x95,0xE9,0x38,0xD0,0x61,0xA9,0x90,0x58,0x71,0x2B,0x5F,0x14,0x0C,
	0x52,0xA7,0x6D,0x6F,0x75,0x52,0xE4,0xE1,0xA5,0xB7,0x82,0x92,0x98,0x63,0xFC,0x4E,0xF8,0xC5,0xC5,0x75,0x7C,0x52,0x92,0x60,0x3B,0x24,0xD9,0xBC,0x55,0x34,0x89,0x33,
	0x22,0x9C,0x46,0x5A,0xFD,0x2F,0xE7,0x68,0x04,0xD2,0x8F,0xF3,0x44,0xFD,0x36,0x20,0xD1,0x32,0x4E,0x48,0xBE,0x66,0xFD,0x0E,0x63,0x53,0x26,0x10,0x83,0xFB,0x74,0x29,
	0xFB,0x38,0x40,0x83,0xAA,0x65,0x0E,0x96,0x05,0x20,0xCA,0xCD,0x95,0xED,0x35,0x6A,0x39,0x7C,0x3D,0xFE,0x40,0xA2,0xD9,0xEE,0x3F,0x4D,0x96,0x88,0x4E,0x1C,0xCC,0x98,
	0xAD,0x77,0xBE,0x8D,0x37,0xD1,0x7C,0xDB,0x14,0xFF,0xC1,0x68,0x57,0x24,0x59,0x52,0x47,0x3B,0x32,0xEF,0xEF,0x6B,0xFC,0x09,0x9C,0x46,0x1A,0x93,0x69,0x9A,0x98,0x67,
	0xB2,0x3C,0x4E,0x23,0x59,0xEE,0xD7,0xCB,0x10,0x64,0xC9,0xF5,0xF9,0x85,0xB4,0x22,0x9A,0xA5,0x8D,0x48,0x9E,0x48,0x4E,0x6B,0x3F,0x03,0xE6,0x24,0xEF,0x38,0xC6,0xA7,
	0x5D,0x2F,0xEC,0xEE,0x2D,0xF1,0x42,0xBC,0x88,0x36,0x23,0x8D,0x92,0xF4,0x1E,0x29,0x37,0xCC,0x44,0x1C,0xAE,0xA4,0x06,0xA1,0x93,0x76,0x6C,0x6E,0x4C,0x67,0x03,0x82,
	0x9F,0x1A,0x55,0x1F,0xD3,0xB4,0x33,0x8A,0x7E,0x96,0xD0,0x98,0x6E,0xE4,0x39,0xDB,0xB5,0xEC,0x01,0x25,0x4E,0xFB,0xA1,0x3D,0x8D,0x7B,0x78,0x29,0xFB,0x0C,0xDA,0x8F,
	0x34,0x1A,0xBB,0xAD,0x9D,0x72,0x76,0x34,0x4B,0x23,0x8D,0x92,0x9B,0xB5,0xE9,0x9B,0xDE,0xBA,0x4D,0x90,0x21,0x5F,0xBB,0x49,0x33,0x40,0x84,0x0C,0x4C,0xCC,0x6D,0x58,
	0x75,0x19,0x46,0x2D,0x4D,0xA7,0xD5,0x8D,0xD3,0xB8,0x6F,0x8C,0xFB,0xC9,0x52,0x6E,0x97,0x5A,0x75,0x9E,0xD3,0x48,0x7A,0x89,0xA0,0x15,0xA6,0x5D,0x12,0x0F,0xDB,0x40,
	0x23,0x59,0x80,0x51,0xF0,0x05,0x0F,0x0E,0x88,0xA3,0x9E,0xC4,0xB1,0xD9,0x39,0x80,0xBC,0x2A,0x99,0xC6,0x69,0xA4,0x3D,0x14,0x41,0x9B,0xA2,0xB0,0x5F,0xA5,0xA3,0xBE,
	0xEB,0x57,0x9B,0x84,0x46,0xDA,0x8F,0x15,0xB4,0x9C,0xDF,0x48,0x79,0xCB,0x02,0xC9,0x26,0x30,0x50,0x37,0xD5,0xF9,0x4A,0x18,0xAD,0xCD,0x98,0x2C,0xD0,0x70,0x47,0x96,
	0x45,0x0D,0xD4,0xE4,0x2B,0x61,0x34,0x92,0x3F,0xB5,0x8E,0x56,0x5F,0x35,0x41,0x23,0xAD,0x6F,0x82,0x26,0x42,0xBF,0xD3,0x63,0x43,0xD8,0xB5,0xD5,0xC7,0x61,0x39,0x8D,
	0xA4,0x05,0xF1,0x1B,0x6E,0x52,0xD6,0x39,0xED,0xFC,0xE6,0xCD,0x90,0x14,0xF7,0xCA,0xBD,0x8B,0x62,0x07,0xEA,0x4D,0xBF,0xA7,0x8F,0x7A,0x32,0x1E,0xC0,0x84,0x46,0xB2,
	0xA8,0xC4,0x44,0x03,0x59,0x02,0xE2,0xD9,0x33,0x29,0x92,0x99,0xEF,0x0F,0x91,0x4E,0x8B,0x8A,0xAB,0x26,0x52,0xF6,0xFF,0xFC,0xD1,0x63,0xE7,0x48,0xA4,0xCE,0xE0,0xDD,
	0xA8,0xA4,0x58,0xEC,0x3A,0xDA,0xD4,0xAA,0xCF,0x55,0xC2,0x68,0xA4,0xF3,0x4E,0x58,0x22,0x0B,0xC4,0x16,0xC7,0x02,0xAC,0x70,0xED,0x05,0x4B,0x4F,0xE6,0x26,0x7E,0xBE,
	0xBE,0x91,0xF4,0xC9,0x84,0xD6,0x52,0x2F,0x21,0x69,0x41,0xD3,0xD4,0x31,0xA7,0x36,0x6B,0xB7,0x4A,0x5A,0x71,0x90,0xD6,0xEE,0x78,0xA1,0xB0,0xDF,0x48,0x27,0xC7,0x58,
	0x16,0xC5,0x56,0x07,0xFE,0x84,0x1F,0x9C,0x64,0xBF,0x21,0xAD,0xDD,0x81,0x3F,0x21,0xB9,0x48,0xB3,0xBB,0x84,0x46,0x8A,0x7F,0xD0,0x49,0xFB,0x4E,0x48,0x2B,0x5A,0xC3,
	0xCD,0x01,0x39,0x11,0x6D,0x48,0x5A,0x03,0x90,0x86,0x62,0xDE,0x03,0xB1,0xBF,0x11,0x57,0x87,0xDA,0xAE,0xB4,0x8F,0x7F,0xFB,0xB8,0xA2,0x68,0xAF,0xD3,0x8C,0x7E,0xC0,
	0xF6,0x94,0x49,0x2D,0xA9,0x91,0xD6,0x6E,0xA4,0xA5,0xDA,0x8D,0x52,0x39,0xEE,0x53,0x20,0x59,0xC2,0xCC,0xFD,0xDA,0x65,0x01,0x0E,0xAC,0xD7,0x1A,0xBC,0x4D,0x05,0x9A,
	0x4A,0xA7,0x45,0x7A,0x9D,0x5C,0xA4,0x5D,0x86,0x36,0x22,0xB7,0xE4,0xB7,0xA9,0xAD,0x11,0xDC,0x83,0x0D,0x51,0x47,0x76,0x9E,0xF6,0x1A,0x36,0xA3,0xB8,0x1D,0x40,0x3A,
	0x47,0x85,0xDA,0xCE,0x8D,0x65,0x82,0x9D,0x43,0x75,0x4F,0x0A,0xFF,0x24,0x29,0xBA,0x69,0x7A,0x3C,0xEB,0xFE,0x14,0xED,0x97,0x47,0x3A,0x49,0xBC,0x97,0xD7,0x6C,0x09,
	0x8F,0x48,0x71,0xE6,0x53,0x7B,0x95,0x5A,0x4D,0xE9,0xD1,0xD1,0x2A,0xAD,0xDF,0x5A,0x25,0x7B,0x4E,0x68,0x03,0x92,0xF6,0x3A,0x85,0xC6,0x13,0x97,0x2B,0x07,0xCA,0x0F,
	0xA4,0xEA,0xF1,0x51,0x42,0x8A,0x81,0x9B,0x7A,0x4F,0x20,0x8E,0x7F,0x74,0xD1,0x13,0x1A,0xF0,0x90,0x49,0x16,0x58,0xF5,0x2D,0x0F,0x74,0x60,0x67,0xC7,0xEA,0x6C,0x1C,
	0x83,0xB6,0xE2,0x14,0x68,0x5D,0x7E,0xD5,0x61,0xF3,0xC0,0xE4,0x34,0xDA,0x6A,0xBA,0xDB,0x80,0x3E,0xB9,0x8A,0x26,0x9B,0x06,0x8A,0xD6,0x27,0x0F,0x9D,0x6B,0x81,0x62,
	0xBB,0x12,0xB6,0xE9,0x01,0xC9,0xA2,0x9A,0x99,0x77,0xA6,0x6F,0x47,0x30,0x1E,0x0B,0x3D,0xC7,0xCC,0x3C,0xDC,0xA1,0xE1,0x04,0xD5,0xC1,0x54,0x9C,0x46,0x92,0x5C,0x79,
	0x1A,0x06,0x6F,0x80,0x3E,0xF4,0x2D,0x53,0x26,0xD9,0x05,0x36,0xAE,0x59,0x4B,0x23,0x59,0xF9,0x59,0x1A,0x9E,0xF2,0x96,0x01,0xA5,0x68,0x94,0x19,0x50,0x9E,0xF1,0x28,
	0xF3,0x06,0x78,0x2F,0x78,0xC4,0xFE,0x16,0xC3,0x06,0xB6,0x66,0xB5,0xF6,0xC9,0xDE,0xE0,0x27,0xDA,0x9D,0x47,0xC0,0xDB,0xEC,0x60,0x3D,0x50,0xC4,0xF9,0x19,0x10,0x01,
	0x34,0x9F,0xCD,0x15,0xC9,0xF6,0x8F,0x68,0x88,0xD9,0x53,0x66,0x66,0xB0,0x96,0x35,0xFD,0x05,0x8D,0xA4,0xAD,0xCC,0xAC,0xE5,0xCE,0xB7,0xC3,0x27,0xA2,0x16,0x16,0xD3,
	0x0E,0x49,0xFA,0xFA,0x6C,0x0D,0x0B,0xDC,0x73,0x76,0x40,0x68,0x2D,0xB9,0x06,0x05,0xF3,0xAE,0xD5,0x81,0x46,0xAE,0xAD,0x10,0xEB,0xC6,0xA7,0x5F,0x36,0x84,0x4A,0x2A,
	0xDC,0x82,0x6B,0x99,0x97,0xCF,0x9E,0x17,0x7C,0xB7,0x80,0xEF,0x26,0x9F,0x60,0x3A,0x08,0xB1,0xF7,0x22,0x14,0xA8,0x9A,0x3B,0x03,0xF8,0xCC,0xA4,0x78,0x1F,0x12,0x5E,
	0x9B,0x48,0x7E,0xDE,0x9B,0xA4,0x95,0x77,0x66,0x7F,0x2E,0x1C,0x88,0x88,0xEF,0xC8,0x93,0x88,0x1E,0xEB,0x51,0xF6,0xAB,0xCB,0x69,0xDC,0xA1,0x23,0x63,0x0F,0x6D,0x7B,
	0x24,0xAB,0x79,0xE6,0x3C,0x61,0x20,0x00,0xAC,0x44,0xE4,0x10,0x6D,0x1E,0xA1,0x4D,0x6B,0x49,0x6F,0xB9,0x8C,0x03,0xC7,0xDE,0xA8,0xBD,0x37,0xDC,0xA5,0xF3,0xF7,0xF3,
	0xA3,0x83,0xAB,0xE3,0x7A,0x9F,0x0E,0xA3,0x9D,0xD2,0x66,0x21,0x3F,0xDD,0xCB,0x63,0xFD,0xCE,0xCF,0x79,0x74,0x28,0xDB,0x18,0x94,0xD3,0x3D,0x07,0x24,0x3F,0x6D,0x9E,
	0x36,0xC1,0xE8,0x4C,0x82,0x36,0x38,0xA0,0xAD,0xF3,0x5B,0xB0,0xF2,0x50,0xAB,0x00,0x0D,0xD4,0xB1,0x48,0xD7,0x45,0xB1,0x51,0xA2,0xDD,0x91,0xC6,0xE4,0xF6,0xC9,0xB7,
	0x77,0x2D,0x3C,0x2B,0x51,0xDD,0x68,0xEB,0x7C,0xCA,0x53,0x94,0xBA,0xA8,0x8D,0x3B,0x1A,0xAD,0x5A,0x3B,0x8C,0x6B,0xF1,0x44,0x1A,0xAC,0x79,0x18,0x2D,0xF6,0x77,0x7B,
	0xBB,0xA5,0xC5,0xE3,0x71,0x2D,0x9E,0xA4,0x57,0xB3,0x33,0x1D,0x0E,0x46,0x47,0xCF,0x76,0x6E,0xE8,0xD5,0x1E,0xEF,0x28,0xA3,0x69,0x24,0xBF,0x51,0xB4,0x11,0x98,0xB2,
	0xD3,0xE5,0xE2,0x27,0x22,0x6F,0x07,0xC9,0xD6,0xC3,0xCB,0x98,0xF1,0x00,0x06,0x5F,0x06,0xE8,0xF6,0x90,0x41,0x93,0x5C,0x40,0xB3,0xBD,0x40,0x39,0xB2,0x7D,0x6B,0x19,
	0x92,0x80,0x8C,0x76,0x44,0x93,0x25,0xF1,0x49,0x38,0x99,0xD0,0xF2,0x22,0x4D,0x25,0x45,0x50,0x64,0x68,0x6C,0xDC,0x73,0xB7,0x80,0xB4,0x47,0xE0,0xF9,0x9A,0x2E,0xBE,
	0x41,0xCA,0xB5,0xBF,0x17,0xC5,0xD5,0xEF,0x35,0xBE,0x0A,0x7F,0x03,0x8A,0x5F,0x9A,0xF1,0x60,0xEE,0x6D,0xA2,0x2D,0xFA,0x38,0x0E,0x2E,0x73,0x00,0xBF,0xEE,0x0C,0xC8,
	0x82,0x26,0xAB,0x77,0xC1,0xD6,0x62,0xDE,0xA4,0xF8,0xC8,0x40,0xED,0x75,0x35,0xF9,0xDA,0x1D,0x3C,0xFB,0xAE,0x3F,0xBC,0x56,0x9F,0x99,0x7E,0x29,0x27,0x45,0x2C,0xBF,
	0x0F,0x1D,0x3B,0x08,0x1C,0xE5,0xC4,0x29,0xBD,0x5D,0x95,0xBD,0xC1,0x94,0xB2,0x83,0xF2,0x4D,0x2A,0xB7,0x1C,0x73,0x34,0x7D,0x9B,0xB9,0x1F,0x59,0x66,0x9F,0x61,0x46,
	0x9B,0x9B,0x8C,0x06,0x20,0x2E,0x0A,0xDE,0xF2,0x8D,0xD9,0x1B,0xDC,0x73,0x0E,0xFE,0xC2,0x0F,0xDA,0xD4,0xDA,0xBC,0x33,0x92,0x1F,0xA6,0x9E,0x76,0xE8,0xEC,0x57,0x03,
	0x79,0x5B,0x3E,0x8B,0x26,0x24,0x6A,0x84,0x6B,0xD4,0x61,0x66,0x24,0xCF,0x48,0x9E,0xF6,0xDE,0x5D,0x7A,0x8E,0x87,0xA7,0x78,0x1A,0x81,0xBC,0x6E,0xB4,0xF5,0xE2,0x56,
	0x99,0x98,0xCC,0xA0,0x26,0x47,0x77,0xF0,0xBA,0xDD,0x92,0xB4,0x0A,0xA4,0x6D,0xBC,0xDD,0x9D,0x83,0xB7,0xEA,0xCE,0x36,0x9E,0xF4,0x65,0xE4,0x82,0x46,0xB1,0x5B,0x18,
	0xCD,0xF1,0x82,0xCC,0x6A,0x98,0x0A,0x3C,0x6D,0xEC,0xB7,0x29,0x6D,0xBD,0xB8,0x4D,0x02,0x79,0x29,0x66,0x7B,0x5C,0xB7,0x9F,0x89,0x2D,0xC9,0xF3,0x1D,0x7E,0x30,0x31,
	0x1B,0x5A,0xED,0x04,0x2B,0xA5,0xD1,0xBC,0x3E,0x59,0x1A,0xC8,0x68,0xBC,0x63,0x46,0x0A,0xCA,0x5B,0x92,0xA6,0xE9,0x66,0x69,0x3C,0xC3,0xBB,0xD4,0x45,0x7B,0xA2,0x6E,
	0x7F,0x27,0xB6,0x24,0x3F,0x07,0x28,0x6C,0x6A,0x1C,0x1A,0xD1,0x55,0x3A,0x0D,0x21,0xD2,0xBC,0x6E,0xD4,0x96,0x3C,0xC5,0x4D,0x44,0x7E,0x7D,0x0E,0x73,0xCA,0xBF,0x63,
	0x3F,0xA1,0x6B,0x89,0xBD,0x42,0xBD,0x3F,0x69,0x4A,0xD3,0x74,0x6F,0x95,0x33,0x8F,0xE9,0x12,0x3C,0xFD,0x20,0x35,0xE2,0x6E,0x46,0xDA,0x6B,0x06,0x5A,0xB2,0xD1,0xE6,
	0xF3,0x3C,0x68,0x92,0x2E,0x11,0x5E,0x37,0xDA,0x8A,0x9E,0xA2,0xC9,0x6E,0x1F,0x66,0xEA,0x46,0xDA,0xD7,0x4B,0xD3,0x66,0xEB,0x1D,0x4B,0x8F,0x73,0x63,0x3B,0x32,0xFE,
	0x79,0x4E,0x23,0xED,0xA3,0x03,0xED,0x07,0xF3,0xB1,0xD6,0xBF,0x59,0x4F,0x23,0xED,0x90,0x22,0xCD,0x5A,0x71,0x2F,0xA0,0xD8,0xB9,0x47,0x4F,0xA0,0x74,0xBF,0xCD,0x68,
	0x1E,0x81,0x5B,0xE5,0xC2,0x7C,0xB2,0xFC,0xC4,0x41,0x2E,0x29,0x93,0xA3,0x51,0x42,0xB3,0xBE,0x6A,0x68,0xF8,0x33,0x5E,0xCD,0x5A,0x3B,0xDF,0x68,0x7E,0xB9,0x02,0xED,
	0xD6,0xB4,0x61,0x29,0x97,0x68,0x4F,0xDE,0x92,0x34,0x9B,0x01,0x68,0x96,0x6D,0xF2,0x29,0x4E,0xDB,0x93,0xE2,0x75,0x23,0xED,0x6A,0x20,0xCD,0xC3,0xA4,0x45,0xFC,0xA8,
	0x2F,0x3F,0x6F,0x95,0x5E,0x09,0x4E,0x3C,0x67,0x55,0x91,0x7E,0x8E,0xD5,0x8D,0x74,0x73,0x4D,0x29,0xAD,0x01,0x93,0xA9,0x1B,0x95,0x76,0xE9,0x41,0x47,0xED,0xF0,0x8A,
	0x1C,0xD3,0xDF,0x10,0x44,0x25,0xAF,0x1B,0x29,0x96,0x0A,0x68,0xDC,0x08,0xE8,0x26,0x7B,0xC0,0xD6,0x72,0xED,0x7A,0xDD,0xC6,0x13,0x39,0x9C,0x46,0xD5,0xF0,0xB2,0x29,
	0xB7,0x68,0xFE,0xBE,0x6D,0xE0,0x13,0x57,0xD3,0x29,0x1E,0x96,0x53,0x0E,0xBA,0xB7,0xEC,0xE2,0x05,0x39,0x19,0x99,0xD4,0x8D,0xAA,0x73,0x71,0x5A,0x94,0xC3,0x8C,0xE8,
	0xCB,0x9C,0x51,0xF5,0x12,0x4E,0x23,0x54,0x2A,0x43,0xA3,0xED,0x96,0x64,0x69,0x74,0x9D,0x8B,0x2A,0x4B,0x98,0xD2,0xCA,0x8C,0x63,0xB9,0xDB,0xC5,0xB2,0x34,0xEA,0x1A,
	0x90,0xDB,0x72,0x12,0x36,0x15,0x0B,0xC0,0xC0,0xBB,0x1A,0x2B,0xDD,0x64,0x9C,0x46,0x6D,0xC9,0x6C,0x16,0x66,0xAA,0x66,0x4E,0xDA,0x6B,0x2E,0xC9,0xF9,0x2C,0xDB,0x73,
	0xBC,0x6E,0x64,0x1A,0x33,0x6E,0xDE,0xB2,0xE0,0x64,0x7E,0x4F,0xD4,0x9E,0x72,0xE5,0x31,0xB3,0xBF,0xD6,0x38,0xE5,0x75,0xA3,0xAE,0x6F,0xB3,0xD0,0xF3,0x37,0x61,0x5B,
	0x7D,0x92,0x74,0x3A,0x1B,0x73,0x3E,0x9B,0x2E,0xA8,0xC6,0x24,0xA7,0x69,0xAA,0x25,0x4F,0x88,0x92,0x6B,0xBE,0x43,0x11,0x42,0xB8,0xF6,0x34,0x53,0x37,0x2A,0x8D,0x47,
	0xEE,0xA6,0xDD,0x32,0xDF,0xE2,0x71,0xFE,0xBA,0xAB,0x56,0x52,0x75,0xA3,0x7A,0x67,0xF0,0x90,0x4F,0xF7,0xC0,0xF7,0x76,0xB8,0xDA,0xEC,0xE4,0x45,0x25,0xAF,0x1B,0x49,
	0xE7,0x8A,0x3A,0x6D,0x2F,0x3A,0xC2,0xFB,0x6D,0x7C,0x5A,0xEB,0xA1,0xC1,0xA5,0xC9,0xF7,0xCC,0x49,0x63,0x32,0xA1,0xCD,0xF0,0xE0,0x41,0x00,0x4D,0xEA,0x5B,0xEE,0x72,
	0xCD,0x03,0x20,0x9A,0xA3,0xE5,0x0F,0x48,0xBE,0xA0,0xB9,0xE5,0x58,0xDB,0xB5,0x47,0xF7,0x96,0x44,0x5E,0x52,0x92,0x7F,0x9D,0x3B,0x5E,0x27,0x6B,0xEB,0x53,0xBB,0xEC,
	0x2B,0x2A,0xC9,0xA2,0x9A,0xFB,0x76,0x17,0x04,0x88,0xB8,0x32,0x86,0x87,0xC6,0xC4,0x17,0x7E,0xC1,0x2F,0x6B,0x76,0x0A,0x99,0xA6,0x60,0x04,0xCF,0xA5,0x5D,0x98,0xBE,
	0x74,0x7C,0x9F,0x41,0xBA,0xC7,0x65,0xFE,0x21,0x13,0x0A,0x20,0x4B,0x8A,0xEB,0xA6,0x6E,0x9E,0x43,0x9B,0x6D,0xCC,0xEA,0x1B,0xF4,0xCB,0xFA,0x8D,0x24,0x27,0xDF,0x9F,
	0x5C,0x2B,0x3C,0x39,0xB4,0x88,0x83,0x4B,0x2D,0xA8,0x32,0x9E,0xDE,0x3E,0x69,0xBE,0x25,0x34,0xE8,0x41,0xC0,0xED,0xF0,0xF2,0xBE,0x73,0x37,0xB0,0xEF,0x5D,0xBB,0xC1,
	0x62,0xE5,0x3B,0x83,0xA4,0xF3,0xC7,0x09,0x4D,0x88,0x90,0x88,0xB4,0xA7,0xE8,0xE2,0xE6,0x93,0xAA,0xC0,0x79,0x4E,0x23,0x69,0xE6,0x09,0x6D,0x62,0xFB,0xCB,0x9D,0x1D,
	0xFA,0x4F,0x22,0xB1,0xBA,0x55,0x79,0xCC,0x39,0x43,0xBB,0xA5,0xD2,0x44,0x37,0xC5,0xD3,0x2C,0xE6,0xCA,0xB4,0xE4,0xCF,0x24,0x9A,0x6B,0x87,0x2D,0xA2,0xC9,0x13,0x1A,
	0x6D,0x94,0xCC,0x94,0x89,0xF9,0xC9,0x74,0xA0,0x22,0xA7,0x96,0x6B,0xF9,0xA6,0xFC,0x2D,0xF0,0x3C,0x1E,0x86,0xA4,0xE1,0xA5,0x68,0x44,0x57,0x90,0xA0,0x91,0xB4,0xD7,
	0x14,0x8D,0x7A,0xC7,0x17,0xA7,0x91,0x56,0x53,0x11,0x95,0x9C,0x72,0x61,0xE3,0xA8,0xBF,0xFE,0x84,0x6D,0xDA,0x70,0x61,0x26,0x8F,0xF5,0x21,0x8D,0xC9,0x0F,0x96,0x1F,
	0xB2,0x54,0xD0,0x2C,0xD8,0x3B,0x7D,0x0F,0xCF,0xC4,0xD9,0x85,0xCB,0xB5,0xE5,0x07,0x55,0x51,0x1B,0x8C,0x36,0xD1,0x33,0xDB,0x54,0xB2,0xB4,0x68,0xDB,0x9A,0x1D,0x03,
	0x6B,0x38,0x97,0x92,0xA2,0xF5,0x48,0xFD,0x56,0xA0,0xF1,0x63,0x60,0x32,0xE9,0x57,0x39,0x8D,0x34,0x26,0x99,0x6D,0xCF,0xF7,0x53,0x53,0xA7,0x3E,0xA5,0xB3,0x28,0xDD,
	0x0C,0x69,0xA3,0x84,0x27,0x6F,0xC9,0x90,0x24,0xEF,0xBD,0xE2,0x34,0xD2,0xEC,0x16,0x07,0x2E,0x1D,0xB0,0xF0,0x83,0x35,0x18,0xA7,0x4D,0x61,0xAD,0x79,0xDA,0x01,0xC9,
	0xF3,0xF4,0x01,0x26,0x99,0xB5,0xF1,0xFC,0x90,0xBA,0xAF,0x12,0x45,0x2C,0x91,0x5A,0x92,0x79,0xEC,0xF0,0x18,0x58,0x31,0xA5,0x2C,0x86,0x7E,0x42,0x7B,0xD6,0xC7,0xD3,
	0xFE,0x44,0xA5,0x55,0xC7,0xE7,0x4A,0xD4,0x4D,0x23,0xF9,0x4B,0x58,0x85,0xF8,0x90,0xE7,0x8B,0xB7,0x83,0x57,0x27,0xB0,0x49,0xC7,0xEB,0x7A,0xB0,0xD9,0x39,0xE5,0x5E,
	0x44,0x2E,0xB9,0x48,0x9E,0xA7,0x72,0x5A,0x72,0x1B,0x6E,0x35,0x4C,0xD0,0x48,0x9A,0x39,0x2F,0x53,0x58,0x1C,0x2C,0xC5,0x89,0xE9,0xC3,0x3C,0xC7,0x71,0xDF,0x34,0x36,
	0x39,0x8D,0xB4,0xB3,0x22,0x68,0x75,0x19,0x6A,0x66,0x20,0x6C,0x1E,0x2C,0xBF,0x00,0x44,0xDA,0x51,0x8F,0x36,0x4A,0x18,0xED,0x19,0xF9,0x2C,0x4D,0x8A,0x6D,0xCA,0x69,
	0xC7,0x2E,0xA8,0x3C,0x51,0x40,0x96,0x88,0x94,0x92,0x93,0x93,0x43,0x92,0x5E,0xC2,0x69,0xCC,0xE7,0xF4,0x2D,0x17,0x60,0x78,0xAC,0x4F,0xEA,0xBE,0x6B,0x56,0xB7,0xD5,
	0xBD,0x34,0x4D,0x89,0x71,0xC9,0x9C,0xA6,0x06,0x7F,0xB5,0xE9,0x38,0x9E,0x54,0x28,0x75,0x58,0x5C,0x26,0xAC,0x88,0x0B,0x4A,0x92,0x58,0xBE,0xB5,0xDD,0x55,0xB0,0xF3,
	0xEF,0x16,0x1E,0x35,0xBE,0x5A,0x08,0x13,0x92,0x58,0xBE,0xF5,0x9C,0xBB,0xAD,0x7C,0x3A,0xF1,0x02,0xCD,0x20,0xD5,0x2D,0xCA,0x55,0x91,0x9A,0x71,0xCC,0xA3,0xC6,0xE6,
	0x76,0xD5,0x54,0x4B,0x68,0x47,0x34,0x55,0x41,0xD0,0xDA,0x9C,0xC0,0xE4,0xCA,0x32,0xC9,0x89,0x27,0x66,0x57,0x8B,0x3C,0x57,0xC2,0x5C,0x24,0x1D,0xAE,0xCE,0x46,0x3D,
	0xA6,0x94,0x04,0xC9,0x23,0x53,0x43,0x92,0xEB,0xA9,0x5B,0xF2,0xE7,0xCA,0x73,0xBB,0x41,0x88,0xE7,0x28,0x60,0x98,0x86,0x9E,0x1F,0xD8,0x65,0xDF,0x2A,0xFF,0x13,0x73,
	0x3B,0x25,0xAF,0xD8,0xF0,0x2E,0xD1,0x2E,0x01,0x88,0x50,0x76,0xFC,0x87,0x4D,0x43,0xC0,0x7B,0x12,0x2E,0xBE,0xBE,0x3E,0x1E,0x65,0x3D,0xEA,0xD5,0xB4,0xEE,0x28,0x8F,
	0x93,0xA4,0x24,0x38,0xBD,0xA7,0xE7,0xDA,0xB9,0x1A,0x67,0x14,0x6A,0xC7,0x70,0xE2,0x92,0x37,0x96,0xF0,0x52,0x18,0xCD,0x95,0xA3,0x88,0xE1,0xB2,0x6E,0xBE,0x76,0x38,
	0xE1,0x81,0xA8,0x07,0x46,0x38,0xF5,0xD9,0x38,0x8C,0x9A,0x68,0xAA,0x5C,0x8C,0xD3,0x9E,0x8D,0x33,0xC0,0x5E,0x5F,0x81,0xE2,0x12,0x86,0xE6,0x72,0xCD,0xEE,0x07,0x9D,
	0x3C,0x81,0x12,0x8C,0x61,0x85,0x09,0xBD,0xD3,0x37,0x34,0xE9,0xBE,0x53,0x39,0x6E,0xF6,0x60,0x81,0x2A,0x84,0x99,0x5D,0x89,0x03,0x05,0x70,0x03,0x2D,0x77,0x54,0xA5,
	0x69,0x1E,0x64,0xC3,0x13,0xB5,0x6E,0x4F,0x2F,0xBC,0x01,0xAF,0xEE,0x6C,0xED,0xED,0x1C,0x0C,0xC1,0x99,0x7A,0xAB,0xA0,0xFA,0xA5,0x3A,0x83,0x9E,0xAA,0xCA,0x56,0x58,
	0xBC,0x41,0x27,0x85,0x39,0x77,0x43,0xEB,0x1E,0x3D,0x04,0x07,0xFE,0xA6,0x06,0x93,0xF0,0x72,0x87,0x6D,0x9B,0x79,0xA5,0x52,0xE8,0x39,0x7F,0x9E,0x23,0x85,0x40,0xFA,
	0x59,0xA4,0x1E,0x4E,0xD5,0x9C,0x4C,0xE3,0xFF,0xFB,0xC7,0xE1,0xF5,0xD1,0x2F,0xDA,0x6F,0xDF,0x88,0x7B,0x3C,0xDA,0xD1,0x3B,0xFA,0x28,0xDF,0xCB,0x4D,0x55,0x7D,0x4E,
	0x1E,0x34,0xA4,0xE5,0x12,0xA1,0x35,0xD0,0xF8,0xF5,0xA4,0xD1,0xBD,0x81,0x51,0x7A,0x32,0x58,0xD6,0x6C,0x77,0xE9,0x78,0x61,0x5D,0x04,0x06,0xA7,0xFD,0x94,0xB9,0xE8,
	0x92,0x44,0x13,0x72,0x6F,0x62,0x2E,0x1A,0x6E,0xD4,0x4C,0x68,0x59,0x47,0xA8,0x0C,0xED,0xBA,0x1B,0xF3,0x64,0x2A,0x95,0xAD,0x9B,0x46,0xAD,0xDB,0xCF,0x09,0xED,0xC8,
	0x5A,0x7A,0x78,0xDB,0x8C,0x04,0x57,0xD0,0x54,0x79,0x5A,0xA9,0x38,0xCA,0xE5,0x62,0x12,0xF7,0x09,0xCA,0xA9,0xE9,0xEC,0x0D,0x0E,0x0F,0x28,0x6F,0xD0,0x89,0x0E,0xCA,
	0xD2,0x37,0xFF,0x04,0x2F,0x7B,0xA5,0x70,0x43,0xFB,0x5E,0x98,0x0B,0x6C,0x4F,0x0F,0x3D,0x88,0x94,0x20,0xD8,0x98,0x76,0x74,0x4C,0xE8,0xCD,0x4C,0x4E,0xB9,0xB7,0xDC,
	0xB1,0xB7,0x5B,0x35,0x44,0x2E,0xA7,0x68,0x5B,0xE3,0x8E,0x52,0xB7,0xC2,0x6D,0xB3,0xD2,0xE2,0x86,0xD7,0xED,0x92,0x32,0x0B,0x9F,0x73,0x77,0x0F,0xAB,0xDB,0x7A,0x41,
	0xA0,0x3D,0xE7,0x44,0x3E,0xA3,0x0D,0x74,0x02,0x2D,0x3A,0xB9,0x43,0x1B,0x8E,0x09,0x2D,0xB7,0x1D,0x41,0xA0,0xF1,0x18,0x40,0x67,0x83,0x99,0xA7,0x24,0x24,0x9A,0xA0,
	0x7D,0xA0,0xD0,0x58,0x1C,0xEC,0xA2,0x45,0xD5,0x44,0x4B,0x06,0x7D,0x42,0x4B,0x96,0x2D,0xE1,0x19,0x23,0x64,0x6D,0x6F,0x83,0xAF,0xB3,0xFC,0x97,0xC9,0x3A,0x80,0x8B,
	0x34,0x40,0xF7,0x78,0x59,0x86,0x27,0xEE,0xD8,0xC2,0x20,0x12,0x90,0x4B,0x75,0xCA,0x42,0xC7,0x50,0x47,0xC3,0xF1,0x01,0x51,0xF7,0x62,0x1C,0xB0,0x34,0x5B,0xE8,0x01,
	0x9D,0x82,0x0A,0xD0,0x6C,0x75,0x99,0x7E,0x68,0xE3,0x39,0x1F,0xA0,0x12,0x89,0xA0,0xB9,0xF7,0x73,0xB7,0xD9,0x55,0xD3,0x8C,0x82,0xD5,0x45,0x25,0x32,0x43,0x61,0x20,
	0x8B,0x1B,0xF0,0x81,0xCC,0x7C,0x64,0x87,0xBE,0x0D,0x52,0x7C,0xD0,0x57,0xB4,0xCF,0xF0,0x3F,0x49,0x66,0x47,0x1F,0x0C,0x47,0x66,0x11,0xD7,0xCD,0xF3,0xBA,0xE9,0x89,
	0x53,0xC2,0x13,0x89,0x82,0x1E,0x4E,0xDD,0xDA,0x3C,0x2C,0x8C,0xB7,0xC8,0xA6,0x0D,0x7D,0x06,0xEF,0xA7,0x9D,0x65,0xB9,0x6F,0x82,0x6A,0x24,0xE3,0x6D,0x8D,0x75,0x5E,
	0x2C,0xB4,0xE4,0x09,0xA7,0xF1,0xB6,0xD2,0x21,0x13,0xD5,0xEF,0xF1,0x65,0xEA,0x77,0x6B,0x87,0xCB,0x75,0x63,0xFD,0xCC,0x6D,0x2F,0x6F,0xC6,0xD6,0xF2,0x5E,0xC8,0x00,
	0x79,0x09,0x51,0xF4,0xF5,0x2D,0x11,0x66,0x87,0xE8,0xBF,0x7D,0x6D,0x74,0x47,0xDC,0xD3,0xCC,0x0F,0x04,0xB9,0x56,0x1C,0x9A,0x37,0x37,0x83,0xC0,0x0A,0x6B,0xDF,0xA3,
	0x33,0x50,0xD5,0x71,0x6F,0x49,0x3A,0x7B,0xC7,0xAA,0x7A,0x75,0x3C,0xF9,0xF1,0xEB,0xD7,0xF4,0x8F,0x34,0xBC,0xA2,0xDB,0xB1,0xF1,0xD8,0x1A,0x55,0xF0,0x6B,0xFD,0x51,
	0xDE,0xC8,0x97,0xEC,0x63,0x7E,0xA5,0x09,0xCD,0x85,0xA2,0xF7,0xD4,0xDC,0x06,0xA8,0x2C,0x4D,0x78,0x48,0x88,0xAB,0x8C,0x9A,0x4B,0xAC,0xDA,0x76,0xFC,0xDE,0x98,0x40,
	0x07,0x79,0x58,0xA7,0x21,0xB0,0xF1,0x4B,0xBA,0xA1,0xF2,0xAB,0xCE,0x96,0x0E,0x5E,0x19,0xC2,0xB6,0x11,0x30,0x80,0x95,0x29,0x9B,0xFC,0xD0,0x9E,0x94,0x06,0xDF,0x53,
	0xFB,0xA3,0x65,0x41,0x00,0xD7,0xD2,0xD8,0xED,0x3D,0x6D,0x26,0x24,0xD2,0x72,0x17,0xC2,0x36,0xD2,0x2C,0x54,0x2E,0x2F,0x3C,0xF7,0x5E,0x39,0xF1,0xFC,0x07,0xA9,0x4A,
	0x45,0xB4,0x41,0x6F,0xD8,0x97,0x55,0x7D,0x0A,0x34,0xB6,0x80,0xF1,0xEC,0xBF,0x78,0xC4,0xA5,0x51,0x0B,0x42,0x5A,0x2E,0x45,0x6D,0x23,0xCD,0xE7,0x1B,0x08,0xAA,0xF2,
	0x19,0xFE,0xE9,0xF2,0xFF,0x4A,0x6E,0x36,0x19,0x9A,0x61,0xC8,0xEA,0x59,0x9C,0x36,0x31,0xB7,0x6C,0x60,0x84,0x6B,0x72,0xD7,0x75,0xFA,0xB9,0x8B,0x07,0xEB,0x68,0x5D,
	0x8D,0xE1,0x8E,0xB7,0x26,0xEE,0x4D,0x93,0xE5,0x96,0xC2,0x44,0x57,0xEE,0x9A,0xEE,0x66,0xDC,0x81,0xED,0x83,0x25,0xF2,0x40,0x55,0x8F,0x19,0x4E,0x1F,0xE5,0x72,0x6E,
	0x4B,0xE0,0x7C,0xDF,0x7B,0x04,0xFD,0x0D,0xC6,0x07,0x49,0x72,0x21,0xCE,0x30,0xC6,0x65,0xB8,0x5A,0x9D,0x27,0x9E,0xE2,0x68,0x73,0xE1,0x34,0xB7,0xDD,0x7B,0x59,0x1D,
	0x19,0x5A,0xD3,0x20,0x3A,0x1D,0x61,0xA8,0xB4,0x5D,0x70,0x0D,0x02,0x4D,0x34,0xE6,0x04,0xEF,0x4C,0xB5,0xF1,0xB2,0xE2,0xA3,0xEE,0xA1,0x19,0x3C,0x34,0x48,0xC8,0x3C,
	0x4E,0x97,0xC5,0xA9,0x8C,0x76,0x66,0xDA,0x68,0xA3,0xC3,0x44,0xA7,0xCF,0x83,0x81,0xAA,0xE7,0x27,0x42,0x43,0x53,0xF2,0x6B,0x00,0xA1,0xE3,0x98,0x3C,0xD1,0x14,0xCC,
	0xA9,0xC0,0x43,0x10,0xAE,0xBC,0x7F,0xFD,0xCB,0xB1,0xEA,0x37,0x05,0xE4,0xEB,0x16,0xD3,0xBA,0x09,0x0D,0x7D,0x54,0xCA,0xB5,0xCB,0x2F,0x97,0x6A,0x94,0x5F,0xC6,0x50,
	0x97,0x9E,0x74,0x9C,0x86,0x59,0xBD,0x3E,0x59,0x81,0x7C,0x6F,0xA5,0x68,0xDA,0x40,0xA5,0x6D,0xB9,0x74,0x66,0x50,0xAF,0xB6,0x83,0x72,0xAC,0xF5,0xC7,0xB4,0x95,0x60,
	0xC6,0xC2,0x28,0x1C,0xE5,0x2D,0x98,0x4A,0x3E,0x3B,0x3A,0x17,0x08,0x45,0xA5,0xFA,0x0A,0xF2,0x88,0x36,0x50,0xC7,0xD2,0x36,0x70,0x91,0xE6,0x58,0x77,0x04,0x58,0x25,
	0xAD,0xDE,0x64,0x5B,0x9A,0x8B,0x05,0x2E,0x75,0x77,0x78,0xE5,0x39,0x5E,0x67,0xFD,0xE8,0xF9,0xCD,0x6B,0x1C,0xE3,0x8D,0x46,0x1A,0xB5,0x2D,0x97,0xBB,0x85,0xC9,0x0E,
	0xA2,0xD0,0x67,0x9C,0xDE,0xEB,0x8D,0x49,0x9A,0x5E,0xF9,0xCD,0x21,0x58,0x3D,0x25,0xAE,0x35,0xA5,0x53,0x3B,0xE3,0xBE,0x6E,0xC8,0x6E,0x5B,0x8B,0xFA,0x16,0x69,0xB2,
	0x9D,0x5A,0x45,0xAB,0xEB,0x4D,0x11,0x4D,0xD8,0x76,0x6E,0xE8,0x23,0x83,0x38,0x13,0x93,0xB8,0xCC,0x09,0x0B,0xC8,0xF1,0xC4,0x51,0x7C,0x9E,0x05,0xB5,0x3E,0x90,0x04,
	0x69,0x47,0xD9,0x30,0x50,0x3A,0xED,0x83,0xED,0x61,0xD8,0x5B,0x3D,0x2A,0xA1,0xF5,0x5B,0xD1,0x44,0xFE,0x74,0x7E,0x72,0x24,0x50,0xD2,0x09,0x93,0x2A,0xA2,0xD2,0x38,
	0x8D,0x92,0xAD,0xB6,0x99,0xB6,0x7F,0x11,0xF2,0xBB,0x15,0xF2,0x50,0x41,0x1B,0xB6,0xA2,0x71,0x47,0xD0,0xA5,0xE9,0x84,0x56,0x60,0x89,0x1B,0xE0,0xF1,0xAE,0x4C,0xB6,
	0xB1,0x51,0x56,0x3B,0x41,0xD3,0x5E,0x98,0xF6,0xAE,0xBC,0x76,0x82,0x36,0x68,0x45,0x13,0xBD,0x34,0xF7,0xAD,0x3B,0xCF,0x76,0x82,0x24,0x07,0x64,0xD5,0x68,0x11,0x34,
	0xE3,0xA5,0x68,0x47,0x0F,0x75,0x3C,0x41,0x1B,0xC9,0xD3,0x84,0x37,0xE4,0xE2,0x60,0x7A,0x89,0xDE,0x90,0x29,0x0A,0xAE,0x76,0x93,0x1D,0xFD,0xFE,0xD2,0x9A,0x2E,0xAF,
	0xE9,0xA1,0xED,0xB9,0xF6,0x12,0x4C,0x4A,0x30,0x69,0xF1,0xA0,0x88,0x6F,0x3E,0xC8,0x7A,0x06,0x3A,0xFD,0x61,0x5F,0x3A,0xE0,0xA7,0x97,0xF7,0x3C,0x03,0x8F,0xEA,0x81,
	0xD0,0x73,0xE9,0xE4,0x68,0x34,0x25,0xBA,0xD4,0x4E,0x6A,0x15,0xEC,0x8F,0x35,0x69,0xB7,0x7A,0x29,0x8D,0x4B,0x34,0x47,0xC4,0xA1,0x4E,0xBD,0x55,0xCD,0x46,0x05,0x0B,
	0x9D,0x2A,0xB1,0x2D,0x23,0x92,0xCA,0x17,0x04,0xFC,0x6B,0x32,0x68,0x4A,0x96,0xC1,0xE7,0xBC,0xC2,0x70,0xA0,0xAA,0x25,0x6A,0x46,0xED,0x2B,0x24,0x21,0x31,0xD4,0xDE,
	0xE4,0x41,0x39,0x92,0xB1,0x12,0xDD,0x01,0xFE,0xB4,0xDF,0xFF,0x83,0x39,0xEF,0xFE,0x3B,0xA2,0x54,0xA6,0x42,0x48,0x5C,0x80,0xBE,0xD1,0x5E,0x21,0xC8,0x1D,0x7A,0x7C,
	0x15,0x12,0xAF,0x42,0xE2,0x7F,0xBC,0x90,0x78,0x95,0x11,0xB1,0x22,0x71,0x76,0x70,0x75,0xF4,0x1B,0xF3,0x84,0xB8,0x6D,0x36,0xB0,0x19,0x5C,0x1F,0x69,0x44,0xAB,0xE1,
	0x8C,0xDF,0xA6,0xEF,0xB5,0x30,0xE2,0x3B,0x5A,0x3F,0x97,0xD9,0xAB,0x8E,0xB6,0x6F,0xFC,0xE1,0xF6,0x71,0xFE,0x5B,0x96,0x82,0x7F,0x9B,0x6E,0x2E,0x18,0xBF,0xAF,0xFD,
	0x9C,0x9F,0xCE,0x07,0x5F,0x66,0x9F,0xB4,0xA6,0xAA,0x7F,0xA4,0x66,0x3F,0x70,0xED,0x0D,0x1E,0x4A,0x75,0xCD,0x07,0xF2,0x36,0xA9,0xCE,0x22,0xAF,0xD3,0x67,0xBB,0xD8,
	0xEA,0xB4,0x6F,0x0C,0xC6,0xC6,0x50,0xC3,0x05,0xAB,0xB7,0x8F,0x2E,0x2F,0x8C,0x8D,0x89,0x7F,0xC8,0xFC,0x5E,0xE5,0xCB,0x59,0xD7,0x80,0xFF,0xA7,0x5E,0x26,0x34,0xFD,
	0x3B,0x3B,0x20,0x6D,0xB6,0x74,0x74,0x5D,0xD5,0xB4,0xC2,0xCB,0xC4,0xE3,0x3F,0x59,0x45,0x91,0xA7,0x0D,0x40,0xF3,0x65,0x7B,0x03,0x78,0x97,0x9E,0xF9,0xB9,0xCD,0x4E,
	0x0B,0x18,0xA3,0xA3,0x2C,0x2F,0x03,0x2C,0xDF,0x8A,0xF0,0x71,0x21,0xBD,0x88,0x0E,0x47,0x98,0x2B,0x4B,0xD1,0x2F,0xA4,0xD8,0x9D,0x01,0x34,0xD9,0xB0,0x50,0xBF,0xF2,
	0xBD,0x81,0x51,0x09,0x6D,0xB2,0xF3,0x3F,0xB1,0x33,0xCE,0x08,0xD5,0x1A,0xA0,0x9D,0xD1,0x70,0x68,0x3C,0x87,0x76,0x62,0x2E,0x2D,0x76,0x5F,0xFC,0xD6,0x7E,0xB0,0x14,
	0xB5,0x1E,0xD7,0x19,0x8D,0x06,0xE3,0xE2,0x40,0x6A,0xA2,0xA9,0x49,0xDD,0x40,0xC7,0x22,0xEC,0x7B,0x8C,0x86,0xDA,0x58,0x92,0xA6,0x25,0x1D,0x27,0xD9,0x51,0xC5,0xCA,
	0x0D,0xC7,0x63,0x43,0x12,0x67,0xA4,0x71,0x69,0x0F,0xD0,0xB1,0x5B,0x7F,0xED,0x5C,0x0E,0x87,0x61,0x41,0x09,0x51,0x06,0x67,0x5C,0x88,0x6B,0xEE,0x66,0xE6,0xC2,0xB7,
	0xF8,0x30,0x91,0xA8,0x2F,0xB3,0x0A,0xAA,0x6B,0xD7,0xCD,0xCE,0x02,0x55,0x4B,0x78,0xD8,0x79,0x14,0x8B,0x40,0xF0,0x86,0xAA,0x3A,0x92,0x6C,0xCD,0x54,0xDF,0x19,0xF1,
	0x50,0xC1,0x35,0xB6,0x36,0xA8,0x31,0xD7,0x98,0x03,0x75,0x54,0x2D,0x54,0xBA,0xB9,0xA1,0x99,0x00,0x07,0x02,0x37,0x5F,0x63,0x68,0xD7,0x2C,0xF4,0xE4,0xC6,0x67,0x67,
	0xA0,0x8F,0x07,0xF4,0x99,0x30,0xD8,0x8F,0x78,0xD2,0x24,0x46,0x33,0x7A,0xF9,0x69,0x27,0x41,0x5B,0xC0,0xB4,0xBE,0xB5,0x7D,0x3C,0xDA,0x40,0x60,0x31,0x83,0x63,0xD8,
	0xEB,0x15,0x97,0x0B,0xDE,0x8A,0x29,0x41,0xDD,0x4D,0x6F,0x70,0x82,0x84,0x36,0xF1,0x74,0x43,0x9B,0x8D,0xB2,0x7E,0x7F,0xD8,0x1B,0x2E,0xF3,0x87,0x8F,0x33,0xB6,0x54,
	0x6A,0xA6,0x73,0x1C,0x86,0x9C,0x34,0x49,0xC7,0x0A,0xDC,0x58,0x57,0x07,0xC5,0xFA,0xD5,0xD9,0xFE,0x08,0xEB,0xB7,0x84,0x69,0x83,0xB1,0x4A,0x83,0xB1,0x6B,0x63,0xF9,
	0x91,0x31,0x1F,0x6D,0x54,0xF9,0x71,0x32,0xEE,0x6B,0x5A,0x71,0x1A,0x94,0x8F,0x93,0x68,0x8E,0x17,0x70,0x62,0xD1,0xE3,0x9F,0xCF,0xD6,0x76,0xCD,0x25,0x7B,0x88,0x93,
	0x14,0x61,0x31,0xEE,0x91,0x97,0xCF,0xA2,0x0B,0x68,0x8E,0x0D,0xC3,0x18,0x8F,0x8B,0xB3,0x20,0x9E,0xDF,0x6A,0xCC,0xE4,0x3F,0xB0,0xE8,0x13,0xCF,0xA3,0xDA,0xDB,0x31,
	0x4D,0xD7,0x35,0x69,0xB5,0xA1,0x3B,0xE4,0x71,0xBE,0x87,0xBB,0x7B,0x69,0xA1,0x95,0x07,0x0E,0x55,0xDD,0x28,0x2A,0x46,0x35,0x23,0x65,0x62,0x6E,0x2C,0xDF,0x54,0x2E,
	0xBD,0x4F,0x76,0x1B,0x95,0x30,0xAF,0x15,0x49,0xC1,0x40,0xFF,0xDC,0xE2,0x65,0x1E,0x34,0x95,0xAF,0xD7,0x1B,0x15,0x17,0x72,0xD4,0x30,0xFB,0xA8,0x70,0x0E,0x06,0x3D,
	0xAD,0xCF,0xFE,0x2A,0x7E,0xEC,0xE2,0x2F,0x22,0x27,0x4A,0xD7,0xD8,0xEF,0x0D,0x34,0x45,0x63,0x1F,0x8D,0x92,0x37,0xE1,0x62,0x14,0x0F,0x5A,0xCE,0xA4,0x97,0x26,0xE8,
	0xD4,0xFC,0xCC,0x8F,0x86,0x50,0xD1,0x77,0xD3,0xD5,0x0C,0x10,0xD8,0x7D,0x46,0x0C,0x70,0x2E,0x5C,0x98,0xEE,0x92,0xDE,0xD0,0x23,0xA3,0x64,0xD0,0x66,0xB5,0xDD,0x48,
	0xBD,0x16,0xCB,0x3C,0xBB,0xDD,0x09,0x2F,0x36,0xE0,0x3A,0xE0,0xCC,0x94,0x9F,0x27,0xD8,0xAF,0x25,0x4A,0x4C,0xB2,0x10,0x82,0x52,0xAF,0x69,0xB0,0x56,0x42,0x63,0x8F,
	0x7B,0x03,0xBD,0xC7,0x15,0xFD,0xE8,0xC7,0xE8,0x97,0xF8,0x5E,0xD8,0xDC,0x43,0x16,0xB9,0x62,0xBB,0xBC,0xB1,0xDF,0xA8,0x6F,0x94,0x53,0x2F,0x84,0x95,0x52,0x99,0x3F,
	0xC9,0x44,0xCF,0x74,0xC6,0x83,0x71,0xAF,0xF8,0x36,0x99,0xC9,0x13,0x77,0xB3,0xC6,0xAC,0x0B,0xB5,0x97,0x45,0x6A,0x6D,0x90,0x25,0xB6,0x0E,0x01,0xD9,0x6F,0x83,0x1C,
	0x3C,0x0B,0x89,0x19,0xAF,0x28,0x4C,0x86,0x2C,0xAA,0xFD,0x54,0xE4,0xCC,0x74,0x83,0x6E,0x80,0x29,0xE9,0x9A,0xB1,0x9D,0x61,0xAF,0xDF,0x53,0x0B,0x37,0x84,0x90,0xFA,
	0xB2,0x15,0x72,0xF1,0x1C,0xA4,0xDE,0x0A,0x59,0xA1,0x8A,0xC8,0x21,0x8D,0x56,0xC8,0x42,0x8A,0xE5,0x26,0x64,0xA9,0x5F,0x7B,0xE2,0x6D,0x16,0xAD,0xDD,0x60,0x3D,0x55,
	0xD5,0x0A,0x8D,0x5D,0xB1,0x98,0x0B,0xB7,0xB6,0xC8,0x6D,0xD9,0x4A,0x31,0x1A,0x8D,0xC6,0xCB,0x9E,0x2A,0xC7,0xD3,0xA3,0x18,0x3A,0xA6,0x9F,0x9C,0x38,0x66,0x40,0x74,
	0xBD,0x75,0x76,0x63,0x75,0x24,0xA9,0xF3,0x75,0xC5,0x69,0xFB,0x0C,0x0E,0xB3,0x1B,0xB9,0xC1,0xC4,0xB1,0x40,0x2C,0x73,0x53,0x36,0xBA,0x94,0xF2,0xD0,0x0C,0x0A,0x1D,
	0xCC,0x71,0x4B,0x49,0xCD,0x48,0xE0,0x30,0x66,0x60,0x41,0xD4,0x89,0x04,0x4E,0x03,0x05,0x5A,0xD6,0x3E,0x10,0x6D,0xB9,0xA3,0x98,0x04,0x59,0x9A,0x3E,0x2A,0xD3,0xC3,
	0x2A,0x2A,0xD7,0x47,0xDB,0x1C,0x80,0x47,0xB6,0xEB,0x5A,0x2D,0xC3,0xFC,0x07,0x5A,0x7F,0x50,0xB2,0x6A,0xEF,0x83,0x55,0x64,0xF4,0x0C,0xA6,0x2F,0x24,0x9A,0x83,0x31,
	0xEE,0x8D,0x54,0x03,0x17,0xB5,0x91,0x0A,0x96,0x0C,0x5B,0xDF,0x54,0xF8,0xAC,0x37,0xC6,0xDF,0xAA,0x83,0xBE,0x66,0x08,0x0D,0x03,0x9E,0x82,0x99,0x07,0xDF,0x55,0x86,
	0x4A,0x17,0xDF,0x13,0x3D,0x4D,0x47,0x4F,0xAE,0xB9,0x61,0xD7,0xF1,0x60,0x6C,0x43,0xA0,0x1C,0xEE,0xA4,0xED,0x50,0xE6,0xFA,0x29,0x2A,0x55,0x0C,0x95,0xD6,0x73,0x54,
	0xBE,0x10,0xA7,0xF4,0x9E,0x3E,0xD7,0x37,0x46,0x4A,0x77,0x0C,0xAF,0x70,0x62,0xDF,0xE3,0x15,0xF3,0x13,0x67,0x47,0x9F,0xCC,0x9D,0x41,0x6F,0xD0,0x97,0x74,0x9A,0xF0,
	0x91,0x70,0xE2,0x79,0x2B,0xE5,0x60,0xBB,0x6D,0xA1,0xB7,0x76,0x74,0xBD,0xD7,0x2F,0x1A,0x37,0xD8,0xAE,0x43,0x75,0x30,0xC4,0x8A,0xA9,0xFD,0x9E,0x3E,0xE2,0xF5,0x8D,
	0x7E,0x8E,0x7F,0x1B,0xBD,0x09,0xF4,0x80,0x9E,0x7A,0x97,0x43,0xD3,0x6D,0x11,0x7B,0x8F,0xEF,0x32,0x2A,0x5B,0xF8,0x63,0xDB,0xA0,0xA0,0xD2,0x32,0xDA,0xC4,0x04,0x43,
	0x84,0xBC,0x8F,0x8C,0x5E,0xCC,0xA1,0xA4,0xB2,0xDE,0xED,0x17,0x70,0x78,0x13,0x31,0xD5,0x69,0x3A,0xD2,0xE5,0x70,0xC2,0xD0,0x4A,0xD3,0xB8,0x41,0xC7,0xA2,0x01,0x3F,
	0xF2,0x20,0xAC,0x0B,0xCB,0xFC,0x54,0x19,0x97,0xCB,0x2B,0xB7,0xEC,0x69,0x12,0xD2,0x4B,0x2D,0xD6,0x2D,0x15,0xEB,0x55,0x8B,0xC9,0xD1,0x64,0x64,0x65,0x86,0xB6,0xB6,
	0x7C,0xFF,0x89,0xDC,0x71,0xA0,0xE0,0x0E,0x64,0x1D,0xA6,0xAA,0x9A,0xC2,0xF9,0x9E,0x1D,0x04,0x66,0x73,0x90,0x71,0xA1,0x72,0x5A,0x95,0x3A,0x8A,0x32,0x40,0x1D,0xAB,
	0x7D,0x8D,0xCB,0x80,0xA1,0xDE,0x47,0x2B,0x32,0xFE,0x41,0x89,0x7F,0xAD,0xC0,0x9A,0x0F,0x92,0x8C,0x0B,0x07,0x7C,0x99,0x13,0x76,0x77,0x35,0x74,0xA9,0x65,0x52,0x0E,
	0x8B,0x18,0x05,0x03,0x53,0x4C,0x91,0xDE,0xBE,0x36,0xD6,0x74,0x74,0xF5,0xEF,0x8F,0xFB,0x60,0x0A,0xF4,0x93,0x09,0x13,0x7D,0x10,0x7F,0x05,0x7D,0x74,0xF0,0x8B,0x7E,
	0xF4,0x2E,0x98,0x6C,0x77,0x02,0x2F,0xB2,0x81,0x25,0x51,0x7E,0x6F,0x86,0x35,0x8C,0xEC,0x82,0x9C,0x1A,0xD1,0x37,0xDE,0x36,0xC0,0x30,0x0C,0xE2,0xF2,0xAF,0xF7,0xB4,
	0x92,0x4D,0x87,0xBA,0x05,0x92,0xD1,0x66,0xE6,0x2E,0x30,0xEF,0xE9,0x36,0x9F,0xDE,0x1B,0x96,0xAC,0x03,0x4D,0xA2,0x68,0xBE,0xF3,0x1F,0xAC,0x27,0x3C,0x8F,0x4C,0x94,
	0x0D,0xBD,0x7E,0x99,0x2D,0x80,0x2B,0x20,0x5B,0xE9,0xD4,0xA1,0xC1,0x57,0xC1,0xA1,0x21,0x3E,0x14,0xEA,0xE4,0x98,0xD9,0xB8,0x5D,0xD4,0x1C,0x4F,0xFC,0xA7,0xAD,0xD9,
	0xEE,0xCA,0x17,0x3C,0x9F,0x50,0xB2,0xC1,0x92,0x6E,0xD6,0xD8,0x94,0x67,0x40,0xAC,0xF0,0xA9,0xB7,0x70,0x08,0x67,0x20,0x32,0x3C,0x4D,0x37,0x74,0x59,0xFD,0x43,0xE3,
	0x7E,0x19,0x4C,0x0A,0x7F,0xE2,0xD8,0x6E,0xE8,0xB0,0x7B,0x34,0xEC,0x20,0xF4,0x64,0xDD,0x6A,0xA0,0x5C,0x0D,0x4A,0x66,0x4D,0x8D,0x62,0xCC,0x68,0x17,0xA0,0x16,0xFA,
	0x34,0x12,0xA3,0xE1,0xB6,0x80,0xA4,0xA4,0xEF,0x1A,0x09,0x0D,0x8F,0x73,0xB1,0x84,0x80,0xA4,0xB3,0x3A,0x9D,0xFE,0xB0,0xA0,0xCB,0x35,0x6D,0xB1,0x20,0xEE,0x72,0x47,
	0x3A,0xC1,0x12,0xE3,0xA0,0x29,0xD5,0xB2,0x91,0xD2,0xDB,0x1F,0xF6,0x86,0xD1,0xBF,0xC5,0x7F,0xBB,0xE2,0x3F,0xB1,0xE9,0xD3,0xDF,0x07,0x43,0x48,0xD7,0xF7,0x87,0xF1,
	0x6B,0x4C,0xAD,0x4F,0x9E,0xD3,0xE2,0x74,0x12,0x1E,0xD1,0xA3,0x49,0x03,0x46,0xB3,0xEF,0xDA,0xF8,0xF6,0x98,0xAB,0xAD,0x44,0x49,0x52,0x4A,0x7D,0x4E,0xA3,0x18,0x37,
	0xB3,0x36,0xB6,0xB9,0x0B,0xBD,0x8D,0x19,0x62,0x1A,0x06,0xD9,0x81,0xC4,0x9D,0xE9,0x05,0x3B,0xBD,0xB1,0x4B,0x59,0x8A,0x10,0xBC,0x53,0x82,0x36,0x8A,0x3A,0xFD,0x91,
	0x26,0xBD,0x01,0xA9,0x67,0x68,0xEC,0xB6,0x7B,0x41,0x53,0x8E,0x26,0x5D,0x75,0xD8,0xEC,0xF7,0x60,0x07,0x47,0x25,0x2B,0xA7,0xC7,0x47,0xA1,0x16,0xFE,0x8E,0xB6,0x49,
	0x2D,0x68,0xFA,0xA8,0x2F,0xEB,0x02,0xD6,0x60,0x58,0x8A,0xCE,0x63,0xD1,0x21,0x27,0xAD,0x84,0x69,0x67,0xAC,0xF7,0xFB,0x92,0xB3,0x5F,0x4B,0x60,0x73,0x7F,0x07,0x52,
	0xED,0x2D,0xEB,0xBF,0xE5,0x2E,0x6C,0x3E,0x50,0xC3,0x61,0x9A,0x31,0xEE,0xE7,0x4C,0xF0,0x0A,0xD7,0xA4,0xC6,0xFD,0x0E,0xFD,0x91,0x20,0x2E,0x77,0x77,0x77,0x2D,0xAC,
	0x7E,0xE8,0x3E,0x63,0x24,0x35,0xF1,0x60,0x95,0x50,0x07,0xA0,0xCA,0x32,0x9E,0xBF,0xF5,0x6A,0x0F,0x2F,0x57,0xF3,0xFA,0x43,0x43,0x56,0xD9,0xD3,0x44,0xE7,0x61,0x36,
	0x31,0x7E,0x6C,0x2D,0xED,0x61,0x0E,0x7D,0x4C,0x53,0x55,0x7F,0xCD,0x0A,0x4C,0x05,0x5D,0x5A,0xB5,0xD4,0xE4,0x68,0xF0,0xC1,0x66,0xEB,0xD8,0x77,0x76,0xE1,0x50,0x30,
	0x18,0x7A,0x05,0xCF,0x72,0x03,0x0D,0x35,0xB5,0x83,0x36,0x21,0x14,0xC2,0xAF,0x2C,0x39,0x30,0xF9,0x8A,0x8B,0x17,0x87,0xAE,0xCD,0xCD,0x86,0x2C,0x9D,0x85,0xB6,0x56,
	0x66,0x47,0xEB,0x1A,0x57,0x8B,0xC7,0xC6,0x80,0x29,0xCF,0x63,0x66,0xD2,0xEB,0x60,0xD9,0xC3,0xBF,0x55,0xAE,0xA2,0xE2,0x27,0xE3,0x3E,0xFE,0x45,0xED,0xB1,0x79,0xC9,
	0xB6,0x0D,0xE0,0xDF,0x2A,0xAA,0x39,0x3F,0xBA,0xF6,0x5D,0xDB,0xFD,0x19,0x3D,0xD7,0xB7,0x35,0x4D,0xC0,0xC5,0xEA,0x85,0x29,0xBF,0x83,0x9D,0x87,0x19,0x7A,0x01,0x57,
	0x2D,0xE8,0x06,0xF1,0x51,0x45,0x58,0xA4,0xDA,0x6C,0xC1,0x62,0x74,0x80,0x51,0xB6,0xE5,0x5B,0xA6,0xC2,0xC1,0xC4,0xEC,0x6A,0x2A,0x03,0x82,0x41,0x49,0x38,0xA5,0x9B,
	0x06,0x62,0xD8,0xB0,0xAC,0x9A,0xC3,0x47,0x2F,0x57,0x71,0x5A,0x6D,0x1F,0x82,0x58,0xD5,0xF4,0x32,0x3F,0xC5,0x78,0x80,0x03,0x0A,0xCD,0x9F,0xFE,0x38,0xC2,0x8A,0x9F,
	0xF9,0x2F,0x95,0xC4,0x0A,0xBC,0xF0,0x76,0xAB,0xB5,0x69,0x3B,0x6D,0x06,0x34,0x18,0x5E,0xF2,0x1E,0x33,0xDE,0x9B,0x97,0xE6,0x72,0x6D,0xBB,0x16,0xDE,0x7F,0x25,0x2E,
	0xEE,0xF1,0x77,0x1B,0xE5,0xD2,0xBC,0x37,0xFF,0x65,0x37,0x98,0x59,0x5C,0x05,0x90,0x75,0xE5,0x46,0xB8,0x7B,0xD0,0x32,0x6E,0xDB,0x84,0x51,0x82,0x54,0xD7,0x0C,0xC9,
	0xDA,0x89,0xCB,0x97,0x4C,0xDF,0x5C,0x9A,0xED,0xDC,0xC6,0xE3,0x5E,0xBF,0x47,0xDA,0xB8,0x14,0xB0,0xB4,0x5B,0xE2,0xD0,0xF3,0xA5,0x6E,0xE3,0xE0,0xB0,0x1B,0x29,0xD7,
	0x84,0x80,0x59,0xA1,0xE9,0x28,0x47,0x56,0x68,0x2D,0x43,0xC2,0x95,0x76,0x0C,0x66,0x18,0x43,0xE9,0x41,0x22,0xAC,0xA8,0x4B,0x7B,0xE9,0x7B,0x2C,0xD1,0x14,0xBD,0xD7,
	0xC6,0x3D,0x3D,0xEF,0x34,0x6E,0x88,0x29,0x49,0x68,0xBC,0x31,0x59,0x65,0x1D,0x18,0x36,0xE2,0x52,0xB8,0x1A,0xA7,0x16,0xA7,0x49,0x86,0x0A,0x08,0xDA,0xAE,0x4D,0x2C,
	0x09,0xA7,0xA1,0x49,0x2C,0x1B,0xCA,0xA5,0x6A,0xC2,0x43,0x7D,0xB3,0x86,0x91,0xE2,0xE1,0x5D,0x4E,0xB3,0xD0,0xBC,0xBB,0x13,0xF1,0x71,0xEC,0x42,0x0E,0x0C,0xEB,0xAA,
	0x7B,0x19,0x14,0x30,0x79,0x55,0xB1,0xDA,0x6A,0xD3,0x2A,0xCF,0x25,0xDC,0x60,0x10,0xDE,0x3B,0x65,0xB6,0xC5,0x6D,0x86,0x63,0x87,0xDF,0xFF,0x58,0xD1,0xDA,0x67,0x59,
	0xDF,0x0F,0xB6,0xF0,0x58,0xA5,0x8C,0xD5,0x3A,0xD8,0x89,0x63,0x86,0x15,0xA0,0x34,0x4C,0xC6,0x43,0xD8,0x13,0x7B,0x45,0x37,0xF6,0xD6,0x12,0x49,0xD7,0xC8,0x4E,0x3B,
	0x43,0x2F,0xF3,0x30,0xD4,0xD6,0x2D,0x5C,0xAE,0xEF,0xA0,0xEF,0x5A,0x2C,0x4D,0x86,0x31,0x2E,0xD9,0x6D,0xA8,0x1C,0x3C,0x0C,0xE7,0xE1,0xC6,0xD0,0x46,0x39,0x33,0x9D,
	0x85,0x45,0xBB,0x74,0x01,0xA5,0xA7,0xAC,0x37,0x83,0xD7,0x6D,0x6A,0xAE,0x6C,0x71,0x27,0x32,0x5B,0x13,0x09,0x91,0x72,0x1D,0x7D,0x3C,0xC8,0xED,0xF1,0x29,0x95,0x21,
	0x34,0xC2,0x99,0x91,0xC2,0x71,0x03,0x51,0x9E,0xC7,0x70,0x26,0x09,0x57,0x3A,0x2D,0x50,0xA9,0x51,0x08,0x37,0xC7,0xA4,0x5F,0x41,0x05,0x35,0x50,0x36,0x98,0x8D,0xF9,
	0xA7,0x58,0xC0,0x71,0x04,0xE5,0xB1,0x81,0x22,0x2D,0x89,0x34,0x9C,0x45,0xE5,0x96,0x39,0x00,0x93,0x9D,0x1F,0x64,0xB2,0x2D,0xA8,0x78,0x6F,0x48,0xA8,0x3A,0x5D,0xAD,
	0x5F,0x0A,0x17,0xEB,0x17,0xBB,0x4E,0xD8,0xC4,0x20,0x53,0x96,0xBC,0xC4,0x37,0x17,0xF9,0xE8,0x2C,0x0E,0x2F,0x08,0x82,0x97,0x87,0x5F,0x9A,0x6E,0x68,0x2A,0x53,0x33,
	0x9D,0x84,0x2C,0x82,0xF7,0xBF,0x34,0x7C,0xB6,0x66,0xA7,0xF1,0x33,0x55,0x8F,0xE0,0xFA,0x17,0x87,0xFF,0xBE,0x2B,0x24,0x48,0x8E,0xE0,0xC6,0x97,0x86,0xC7,0xBF,0x4C,
	0xF1,0x23,0xF8,0xE0,0x8B,0xC3,0x77,0x7E,0x98,0xBF,0xE8,0x95,0xC3,0xB7,0xF9,0xC5,0x80,0x02,0x47,0xA7,0x2C,0x9B,0xE0,0xF0,0xAF,0x53,0x6B,0xC3,0xA3,0xD2,0x43,0x99,
	0x8B,0xB0,0xD8,0xE5,0x5E,0xB2,0x86,0xC4,0x48,0x5C,0x44,0xB2,0x5B,0x5A,0xED,0x9C,0xDD,0xE8,0xEA,0x2E,0x0D,0x41,0x2C,0xDA,0x49,0x83,0x58,0x49,0x9B,0x59,0x9F,0x43,
	0xEA,0xBE,0x51,0xBA,0x76,0x65,0x01,0x54,0xA5,0xBE,0x43,0xBD,0xCF,0x79,0x3C,0x4B,0xE6,0xA1,0xEF,0x99,0x2B,0x21,0xB7,0x31,0xB8,0x7F,0xC5,0x42,0x3A,0xBD,0x0D,0x17,
	0x1C,0xBB,0x10,0xEF,0x8D,0x9D,0x78,0xBE,0x9B,0xB9,0x70,0x41,0xED,0xF5,0x4A,0x9C,0x0A,0x9C,0x97,0x8D,0xA6,0xE6,0x81,0x28,0xD5,0xB7,0x91,0x64,0x5E,0x62,0x3F,0xFB,
	0x0A,0x7B,0x59,0xFE,0x1E,0x5B,0x52,0x92,0x41,0xC5,0xDF,0x22,0x23,0xC1,0x24,0x5E,0x22,0x42,0x26,0xB7,0x0F,0xC5,0x17,0x04,0x35,0xFB,0x15,0x8D,0x91,0x51,0x12,0x36,
	0x57,0x8A,0x8C,0x0D,0xD2,0x52,0x1E,0xD6,0xAA,0x19,0x09,0x8B,0xFE,0x28,0x1F,0xD2,0xD0,0x8E,0x87,0xD7,0xEE,0x39,0x8E,0x32,0x7B,0xD8,0xC1,0xBF,0xA3,0x4B,0x4A,0x0A,
	0xA9,0xF1,0x38,0xEF,0x26,0x63,0xE2,0x4B,0xF3,0x3E,0x11,0x22,0x90,0xA3,0xFA,0x8D,0xB5,0xB2,0x63,0x29,0xF5,0x5D,0x98,0x06,0x8A,0xBE,0x63,0xD7,0x3F,0xDF,0x9B,0xEC,
	0x26,0x57,0xA8,0xA7,0x48,0x00,0x5B,0xF2,0x36,0x1C,0x58,0xB0,0x2F,0x64,0x81,0x9E,0x4D,0x35,0x7B,0xF1,0xEA,0xC9,0xB2,0x98,0x14,0x79,0xA0,0xF0,0x63,0x6C,0x2C,0x0C,
	0xBA,0xC6,0xFC,0x24,0x2B,0xDB,0xAC,0xC9,0x21,0xC4,0x80,0x98,0xF0,0x32,0xEB,0xAD,0x25,0x03,0x0F,0xCD,0xD0,0xF1,0x64,0xF2,0x3E,0x71,0xA0,0x71,0xF2,0x6C,0x20,0x5E,
	0x14,0x72,0xE4,0xE3,0x98,0x6D,0x48,0x1B,0xC4,0x81,0x93,0x67,0x03,0x71,0x2A,0xB0,0xCC,0x3D,0x4D,0x59,0x91,0x38,0x30,0x9F,0x8A,0x92,0x0C,0xCC,0xDC,0x10,0xF4,0xEE,
	0x52,0x24,0xA8,0x54,0x7E,0xDA,0x99,0x3E,0xE0,0x53,0xC7,0x81,0x04,0xF0,0x87,0xE7,0x02,0x8F,0x1E,0xB8,0x1F,0x43,0xB4,0x2A,0xFC,0xFF,0x72,0x75,0xF4,0xC0,0x52,0x82,
	0xBF,0x9B,0xA7,0x07,0x91,0x00,0xFE,0xF8,0x5C,0x20,0x6A,0x01,0x18,0xCE,0x61,0xCB,0xF5,0xE1,0x59,0xFE,0xEE,0xA3,0x56,0x40,0x8E,0x13,0x97,0xE8,0xF0,0xD3,0x55,0x95,
	0x4D,0x7A,0xF1,0x6C,0x60,0xBA,0x41,0x6B,0x13,0xAE,0x71,0xE0,0xE1,0x73,0x47,0x29,0xCE,0xF7,0x7B,0x4F,0x39,0x0F,0x1C,0x93,0x65,0x06,0xAA,0x84,0x72,0xA0,0x9E,0x4F,
	0x77,0x40,0x06,0x4E,0xBD,0x27,0x90,0xAB,0x3F,0xBA,0xE8,0xB4,0x0D,0xEA,0xBA,0x52,0xD4,0xF0,0xE8,0xB9,0x40,0xE1,0x3E,0x68,0x58,0x9A,0x12,0xE0,0xD9,0x73,0xFB,0x30,
	0x02,0xE2,0x11,0x59,0x89,0x3E,0x3C,0xCB,0xDF,0xF4,0x44,0x07,0x46,0xEB,0x53,0x10,0x2D,0x50,0x55,0x27,0x65,0x18,0x70,0xD6,0x6E,0x5A,0x4C,0xBD,0x1D,0xD9,0x2B,0xDB,
	0xD1,0x47,0xC3,0xCA,0xE5,0xA9,0xA0,0x38,0xAA,0x5A,0x81,0x87,0x9E,0x76,0xC2,0x45,0xB4,0x9D,0x61,0x7F,0xDC,0x2B,0x3A,0xC0,0x08,0x15,0xE4,0xC0,0xAC,0x7C,0x8B,0xF3,
	0x5D,0x4F,0xBD,0x75,0x4E,0x5F,0xE7,0xC0,0x12,0x2B,0x57,0x1E,0x88,0x3E,0x2E,0xF9,0x66,0x65,0x3B,0x16,0x72,0xDB,0xF8,0x18,0xD1,0x5B,0xDA,0xA6,0xCC,0xAB,0x26,0x3D,
	0x37,0x38,0x11,0xE7,0x45,0x49,0x15,0x1B,0x89,0xB3,0xA5,0xE9,0x9B,0xC4,0xF8,0x51,0xE6,0xC6,0xAC,0xAA,0x63,0xBE,0x51,0xC7,0x3C,0x30,0x3D,0x21,0x26,0x89,0xDE,0x09,
	0xAD,0xAA,0x8F,0x8C,0xB6,0xE3,0x34,0x95,0x58,0x5E,0x5A,0xB3,0x61,0x3C,0xCC,0x54,0x53,0x26,0xDB,0xA8,0x3C,0x96,0x72,0xE8,0xC4,0x74,0x96,0xD1,0xF5,0x6B,0x7C,0x5F,
	0x21,0xD3,0x87,0x9C,0x97,0xCF,0x42,0xF2,0x7C,0x5E,0x94,0xE8,0x32,0x47,0x14,0xBC,0xC1,0xCB,0xF0,0x9A,0x15,0x37,0xC1,0x5B,0xBE,0x18,0x2F,0x5A,0xF3,0xA3,0xFA,0x41,
	0x95,0xEF,0xFD,0x44,0x00,0x0A,0xDE,0xFD,0x4B,0xF0,0x1A,0xD4,0xB6,0x4E,0xCC,0x43,0x8D,0xED,0xA5,0x79,0xDD,0xF2,0x8B,0x24,0x19,0x6F,0x55,0x88,0xC9,0x78,0x1E,0xAF,
	0xE6,0x2A,0x49,0xC1,0x7B,0x91,0xF1,0xD9,0xA8,0x8D,0x26,0xED,0xF9,0xE3,0x4B,0xF0,0x4E,0x3C,0xDF,0x0A,0xC2,0x4D,0x9D,0xD1,0x14,0x8D,0x97,0xD1,0x73,0x79,0xFB,0xB5,
	0x1A,0xE9,0x3E,0x7B,0x83,0xFD,0x4E,0x5C,0xBF,0x8B,0x97,0xA8,0x9F,0xCC,0xE5,0x9C,0xA2,0xFF,0xF2,0xF9,0xA2,0x5E,0x94,0xC7,0xAE,0xE7,0x34,0x9F,0x92,0xFE,0x5B,0xF5,
	0x5E,0x44,0xBE,0xB0,0xC6,0x44,0x3B,0x8D,0xE7,0x16,0x57,0xBE,0x8D,0xEA,0x57,0x94,0x9F,0xD6,0x4B,0xF0,0x2E,0x4D,0xDF,0xF3,0xDC,0x77,0xB8,0xCA,0x16,0xED,0x88,0xEC,
	0x78,0xD9,0xBD,0x04,0x0F,0x41,0x3C,0x01,0x71,0xE2,0x22,0x17,0x55,0x3D,0xF1,0xCD,0x8D,0x95,0xAA,0xDF,0xF0,0xA5,0x78,0xFC,0xE2,0x51,0x76,0x3D,0x91,0xE5,0x6C,0x8A,
	0x21,0x9A,0x9C,0xF7,0x32,0xF2,0x05,0x27,0xC1,0x8D,0x65,0x2E,0xD7,0xD5,0xCD,0x19,0xD5,0x2F,0x7C,0x11,0x9E,0x84,0x01,0x23,0x78,0xAB,0x97,0xE0,0xC9,0x5C,0x20,0x2B,
	0xE6,0x43,0x3E,0x6B,0x62,0x3B,0x9E,0x44,0xA6,0x6C,0x51,0x3F,0xE3,0x25,0x78,0x62,0xB6,0x45,0x32,0x8D,0x6B,0x30,0xE5,0xEB,0xED,0xFA,0x05,0x79,0xB5,0x97,0xD6,0x8A,
	0xF6,0x7C,0xC9,0xFA,0xD5,0x5E,0x5B,0x2B,0x78,0xD4,0xF9,0xE7,0x7D,0xB2,0xC8,0x3E,0xD1,0xA8,0x3D,0xE5,0xE3,0xBA,0x22,0x9C,0x7D,0x8F,0xDE,0xDE,0x33,0x8F,0x9A,0x42,
	0x86,0x6D,0xC0,0xE6,0x6F,0xF2,0x48,0xE3,0x52,0xDB,0xB0,0x0A,0x8F,0x23,0xEB,0x6A,0x79,0x60,0x66,0x6D,0xB0,0x7D,0xBC,0x01,0x13,0x1A,0x52,0x64,0xAC,0x2F,0x68,0x14,
	0x0C,0x58,0xD4,0x5F,0x9A,0x80,0x0F,0x36,0x66,0x17,0x6F,0x13,0x2B,0x87,0x21,0x3A,0xAA,0x6C,0xA8,0xC7,0xA8,0x7A,0xBB,0xC2,0xB1,0x56,0xF7,0x56,0xAB,0x78,0x45,0x66,
	0x89,0x4A,0xEF,0xD1,0xA8,0x46,0xB4,0x5B,0x01,0x53,0xDD,0x42,0x2B,0x8D,0x1D,0x8B,0x9C,0x7B,0x84,0x53,0x02,0x78,0x9F,0x82,0x2E,0x7B,0xF9,0x8C,0x8A,0x76,0x1A,0x1B,
	0x46,0x18,0xE7,0xD1,0x6A,0xD0,0xB2,0x90,0x08,0xE9,0x51,0x2B,0x2E,0x31,0xE0,0x61,0x25,0x42,0x51,0xC3,0x3C,0x41,0x18,0xD9,0xCA,0x2E,0x34,0x68,0x4E,0x33,0x63,0x14,
	0x4F,0x98,0x56,0xD7,0xCF,0x30,0x12,0xDE,0xFD,0xAE,0xD5,0xAE,0x1E,0xDE,0x4F,0x21,0x7D,0x6D,0x0A,0x0F,0x2B,0x9F,0x85,0x96,0xF9,0xC0,0x44,0x18,0x39,0xF8,0xAA,0x33,
	0x06,0x19,0x20,0x1B,0x2C,0xA4,0x15,0x69,0xC9,0x6A,0x7F,0x69,0x35,0x7B,0x30,0x38,0x4D,0x2E,0x2E,0x28,0xA6,0x99,0xE1,0xAE,0x65,0x5A,0x1B,0x0C,0x0C,0x92,0x6E,0x4A,
	0x4E,0xDB,0xD9,0xE1,0xB2,0xE4,0x0C,0xB5,0x0C,0xCD,0x30,0xCA,0xE2,0x2A,0x85,0x9C,0xC9,0xFA,0x2B,0xD8,0xCF,0xDF,0x44,0x89,0x0B,0x26,0xBB,0xD0,0x21,0x1F,0x5C,0xC7,
	0xBB,0x1B,0xA5,0x8F,0x59,0x6B,0x29,0x1A,0xCB,0x3B,0x1B,0xE0,0x8F,0x04,0x60,0x27,0x7F,0x8C,0xB7,0x86,0x96,0xAE,0xDA,0x8F,0x66,0x68,0xBA,0x26,0xBB,0x77,0x00,0x7E,
	0xF9,0xF6,0x7A,0x19,0x7A,0x7C,0xBB,0xF0,0x14,0xB4,0xB4,0x55,0xC5,0xD9,0x00,0x96,0xDB,0x4C,0x97,0x3B,0x58,0x31,0xA8,0x80,0x69,0xCA,0x5B,0x91,0x7F,0xB9,0x8E,0x14,
	0xC3,0xE4,0xE2,0x53,0x33,0xB0,0xB5,0xB7,0xB5,0xA8,0x07,0x39,0xD0,0xA7,0x45,0xBB,0x21,0xAF,0x26,0xBB,0x06,0xC6,0x5B,0x51,0xFB,0x91,0xCF,0x40,0x52,0xA4,0x65,0xCC,
	0x9B,0x9A,0x5B,0x9B,0xBE,0x20,0xE1,0x21,0x12,0xD2,0xD1,0xCA,0x9A,0x1A,0x4F,0x3D,0x34,0xB0,0x4F,0x41,0x6E,0xDB,0x3B,0xE9,0xE9,0xD2,0x19,0xF7,0x07,0x43,0x52,0x50,
	0x46,0xCC,0x9B,0x99,0x8B,0x48,0xE7,0x60,0x17,0x32,0xDF,0x78,0xB0,0x24,0x37,0x2D,0x8D,0xE8,0x29,0x95,0xBF,0x29,0x30,0x35,0xA2,0x66,0x4B,0x7B,0x63,0x87,0xC4,0x65,
	0x11,0x97,0xA7,0x91,0xF4,0x11,0xE2,0x51,0x1A,0x87,0xF1,0x73,0x64,0x39,0x00,0x2A,0x2A,0x59,0x65,0x64,0xB8,0xF7,0xFE,0xEE,0xA1,0x7B,0x46,0xCD,0x72,0xA8,0xF6,0x7A,
	0x25,0xA3,0xA7,0xF4,0xD0,0x53,0x4F,0x31,0xD2,0xB5,0x63,0xFF,0xE6,0xBB,0xDA,0x42,0x0F,0x3F,0xB3,0x9D,0x86,0x05,0x8A,0x45,0x5E,0x94,0x1D,0x90,0x4E,0xA9,0x8A,0x29,
	0xED,0x49,0x08,0xBA,0x27,0x3C,0x20,0xD3,0xEE,0x20,0xCB,0x68,0x38,0x2E,0xB9,0x8B,0xAA,0x46,0xAA,0xCE,0x2D,0xC7,0x0A,0x96,0x5E,0x9B,0x6C,0x61,0x9D,0x81,0x31,0x30,
	0xA4,0xE3,0x90,0x55,0x81,0x73,0x5D,0x3B,0x80,0x99,0xBF,0x24,0x9F,0xB0,0x44,0x51,0xA7,0x16,0xA3,0x4A,0xCA,0x71,0x5C,0x8D,0x41,0xBD,0x53,0x39,0xB4,0x5D,0x8F,0x5D,
	0x38,0x15,0x28,0x4C,0x2B,0x95,0xA3,0xE2,0x99,0x91,0x12,0xBD,0xB7,0x4C,0xD5,0xEF,0xF6,0xA3,0xC5,0x3E,0xCF,0x9B,0x7B,0x8F,0xB2,0x1A,0x1B,0xAE,0x1A,0xF9,0x83,0xB8,
	0x75,0xBC,0xFD,0x41,0x8A,0xE8,0x7D,0x6E,0x11,0x7A,0xDC,0xE9,0xC3,0x7A,0x4F,0xBA,0x28,0x90,0xC1,0x4E,0xEC,0x60,0x8D,0xD1,0x74,0x53,0x8F,0x34,0xCD,0xB5,0x41,0xDE,
	0x8E,0x91,0x81,0x9D,0xB5,0x3A,0x62,0x05,0x35,0xD3,0x64,0x2F,0x72,0xCD,0xC0,0xDC,0x15,0xFD,0x0E,0x5E,0xB4,0x79,0xA5,0x6F,0xAF,0x54,0x53,0xBD,0x56,0x38,0x1D,0x27,
	0x15,0x79,0xDC,0x31,0x34,0xB5,0x57,0x0C,0x3A,0xAE,0x10,0x60,0x91,0xC4,0x64,0xC0,0xF4,0xC5,0xAA,0xCD,0xA2,0x2B,0x06,0xF6,0x87,0x85,0x93,0x61,0xD5,0xAB,0x4F,0xAF,
	0x1C,0xD7,0xC5,0x24,0x76,0x52,0x27,0x38,0x11,0x27,0x7D,0x71,0x52,0x35,0xEE,0x68,0x07,0x2A,0xA1,0x04,0x93,0xE3,0x34,0x3A,0xEE,0xD2,0xBC,0x77,0xED,0xBB,0x27,0x9C,
	0x09,0xA7,0xF2,0xBA,0x36,0x8B,0x78,0x94,0xBE,0x58,0x45,0x4B,0xE3,0x9C,0x16,0x17,0x0A,0x60,0x40,0x67,0xE9,0x95,0x18,0xA5,0xC6,0xBB,0x38,0x23,0xCA,0x78,0xD7,0xAD,
	0x8C,0x69,0x30,0x21,0xCA,0xAE,0xE0,0xC8,0xEE,0xAD,0xC6,0x15,0x34,0x52,0xCD,0x79,0x6D,0x3B,0x4B,0x7A,0xCC,0x2A,0x9B,0xE8,0xC5,0x6C,0x15,0xE5,0xCD,0x99,0x9A,0x7A,
	0x98,0x7E,0x13,0x0F,0xBD,0xD0,0xA4,0x26,0xA3,0xD1,0x16,0x57,0x84,0xDD,0xD8,0xCB,0x87,0x56,0x62,0x25,0x7F,0xAC,0xBE,0x46,0xAC,0xA4,0x46,0xCA,0x8D,0xF7,0x88,0x07,
	0xCE,0x7D,0xDB,0x21,0x5D,0xCC,0x80,0x75,0x93,0xD5,0xFA,0x52,0x2D,0x39,0x5B,0xFA,0xD6,0xE3,0xCA,0x27,0x26,0x51,0x65,0x34,0xD2,0x31,0x37,0x0E,0xDB,0x32,0x77,0xD2,
	0x3B,0x1A,0xB4,0x63,0xF4,0xF2,0xF7,0x17,0x2A,0x35,0x3A,0x98,0x91,0x6A,0xCA,0x5D,0xB0,0x5E,0x90,0xEF,0x58,0xC5,0x05,0xA1,0x8E,0xD7,0xCD,0x4E,0x3B,0x23,0x02,0xFA,
	0xF4,0x93,0x43,0x11,0x70,0x5C,0x30,0xA6,0x9B,0x1C,0x3C,0x0C,0x17,0x87,0xF4,0x9E,0x42,0x25,0x1B,0x6F,0x32,0x8A,0x71,0xA3,0x81,0x26,0x7B,0x46,0x31,0xC1,0x3D,0x29,
	0xB7,0x36,0x46,0x82,0x29,0x3F,0x5A,0xB4,0x5B,0x8D,0x98,0x7D,0x59,0xA9,0x42,0xE7,0xBD,0x20,0x5D,0x71,0xDC,0xAD,0xD4,0xE6,0x9B,0xE3,0x56,0x55,0x9B,0x80,0x5F,0x76,
	0xD0,0xA6,0xEC,0x08,0x5C,0x6A,0x08,0x45,0xB5,0xC6,0xD0,0x78,0x1D,0x57,0x7A,0x66,0xF6,0xBD,0xC7,0x3A,0x3F,0x9A,0x78,0x07,0xC4,0x6C,0xE9,0x79,0x94,0xFB,0x4B,0x58,
	0xE2,0xCC,0x9A,0x54,0x02,0xE9,0x95,0x5E,0xC3,0x9A,0x43,0xD5,0x47,0xEC,0x42,0xD7,0x5B,0xCB,0xDC,0xB2,0xED,0x07,0x73,0x85,0x9B,0x66,0x0E,0xE5,0x86,0xD5,0xD1,0x68,
	0xA4,0x4A,0x5E,0xE8,0xCC,0x85,0x8E,0x80,0x4D,0x7C,0x30,0x23,0x2C,0x37,0x8C,0x6E,0x75,0xB5,0x7C,0x3C,0x6E,0x17,0x47,0xE5,0xF2,0x4B,0xF9,0x73,0xAF,0x01,0x5D,0x5B,
	0x76,0x77,0x88,0x04,0x2C,0x9D,0x44,0x60,0x94,0x64,0x32,0x10,0xB7,0xF1,0x97,0xD6,0x16,0x61,0xF9,0xCD,0x89,0x2A,0x98,0x9A,0xA1,0xB1,0xF0,0xFD,0x23,0xF3,0xFE,0x9E,
	0xD2,0x79,0xD8,0x8E,0x92,0x0B,0x7D,0x06,0x36,0xF7,0xED,0x95,0x45,0xBD,0x86,0x0B,0xFD,0x03,0x92,0x9A,0xBC,0x38,0xB5,0x71,0xBB,0x26,0xA4,0x2A,0xC8,0xD1,0x34,0x23,
	0xEF,0x4E,0xAE,0x9E,0xFF,0xA3,0x98,0xA6,0xD8,0x78,0x6B,0x10,0x26,0xC9,0xC5,0x6B,0xAE,0x02,0x3B,0xC4,0x8D,0xB9,0x66,0x95,0x90,0xD1,0xAA,0xAF,0xF1,0xA8,0xA4,0x4D,
	0x3C,0xDB,0xA1,0xA4,0x9A,0x17,0x34,0x4C,0xC5,0x2B,0x6D,0xAF,0x0B,0x1C,0x3B,0xC7,0x4E,0xF7,0xB7,0x22,0x4E,0xD7,0x7B,0xF9,0x2B,0x83,0xAA,0x4D,0x5A,0x3E,0x4E,0xFE,
	0x0E,0x95,0xBB,0x40,0x24,0x29,0x85,0x80,0xC0,0xF5,0xE4,0x1D,0x49,0xAA,0xF0,0x9D,0x25,0x99,0x88,0x5E,0x33,0xD4,0xBC,0x6C,0x86,0x9A,0x6E,0x2A,0x05,0x4D,0x43,0x86,
	0x9A,0x68,0x75,0x33,0x94,0xD7,0xFC,0x34,0xF5,0xB8,0xD7,0xFC,0x34,0xAF,0xF9,0x69,0x5E,0xF3,0xD3,0xBC,0xE6,0xA7,0x29,0x9B,0x09,0xAF,0xF9,0x69,0x4A,0x81,0xAF,0xF9,
	0x69,0x5E,0xF3,0xD3,0x48,0xD4,0xEE,0x35,0x3F,0x4D,0x76,0xA4,0xBC,0xE6,0xA7,0x79,0xCD,0x4F,0x53,0xC0,0xBD,0xE6,0xA7,0x79,0xCD,0x4F,0x23,0x8B,0x7C,0xCD,0x4F,0x53,
	0x8E,0xFC,0x9F,0x90,0x9F,0xE6,0xDF,0x3B,0x5B,0xCB,0xFF,0xC6,0xEC,0x3B,0xAF,0xF9,0x69,0xAA,0x80,0xE5,0xF9,0x69,0xBA,0x49,0x82,0x9A,0x44,0x89,0x88,0xD2,0xD3,0x74,
	0x53,0xF9,0x69,0xBA,0xCD,0x09,0x6A,0xBA,0xAF,0x19,0x6A,0x5E,0x33,0xD4,0x50,0x69,0xAF,0x19,0x6A,0x18,0xAD,0x58,0xB7,0xD7,0x0C,0x35,0xD9,0xCA,0xFD,0xF1,0x33,0xD4,
	0x48,0x24,0xA8,0x49,0x92,0xD8,0xA0,0x49,0xF6,0x9A,0xA2,0xA6,0xA9,0x6E,0x7F,0x84,0x14,0x35,0x5D,0x9E,0x8E,0xA6,0x2C,0x45,0x4D,0xAC,0x52,0xBE,0x26,0xA9,0x91,0xC2,
	0xBD,0x26,0xA9,0x49,0xEF,0xB3,0xBC,0x26,0xA9,0xA1,0xD3,0x5E,0x93,0xD4,0xE4,0xDA,0xF2,0x35,0x49,0x4D,0x39,0xF1,0x0F,0x9A,0xA4,0xA6,0xFB,0xD5,0xB3,0xD4,0x74,0xBF,
	0x5C,0x9A,0x9A,0x4A,0xE6,0x6B,0xA6,0x9A,0x86,0xC6,0xFC,0x03,0x65,0xAA,0xE9,0xF2,0x54,0x35,0xC5,0x4C,0x35,0xDD,0x4C,0xAA,0x9A,0xAE,0xC8,0x55,0xD3,0x7D,0x4D,0x56,
	0x23,0x57,0xB7,0x8A,0x64,0x35,0x29,0x99,0x17,0x2D,0x56,0xFF,0x86,0xD9,0x6A,0xD2,0xC9,0x6A,0xBA,0xAF,0xD9,0x6A,0xC8,0xB5,0x7B,0xCD,0x56,0x93,0xC0,0x5E,0xB3,0xD5,
	0xD4,0xD0,0x5E,0xB3,0xD5,0x20,0xF0,0x35,0x5B,0x0D,0xD9,0x81,0xF7,0x9A,0xAD,0xE6,0x35,0x5B,0xCD,0xBF,0x43,0xB6,0x1A,0xCE,0x4B,0x76,0x81,0xBA,0xB9,0x1C,0x1E,0x3D,
	0xED,0xCB,0x27,0xAD,0xF9,0x42,0xEF,0x40,0xCA,0x5D,0xF3,0x85,0xDE,0x81,0x94,0xC2,0xE6,0x4B,0xBD,0x03,0x25,0x93,0xCD,0x17,0x7A,0x07,0x52,0x42,0x9B,0x2F,0xF5,0x0E,
	0x94,0xBC,0x36,0xE4,0x77,0x78,0x4D,0x6F,0x53,0x53,0xBB,0x3F,0x46,0x7A,0x9B,0xC2,0x49,0xC9,0xAF,0x99,0xDD,0x46,0xE2,0x25,0xBE,0x50,0x76,0x9B,0xF2,0x03,0xA2,0xBD,
	0x2A,0xDE,0xB3,0xB3,0xDB,0x10,0x79,0xCF,0xCE,0x6E,0xD3,0xCC,0x7B,0xD9,0xEC,0x36,0x95,0x3D,0xF8,0x85,0x92,0xDB,0x48,0xF0,0x5E,0x34,0xB7,0x8D,0x1C,0xAF,0x4D,0x6A,
	0x9B,0xED,0x63,0xD9,0xA5,0xB4,0x14,0xDE,0x4B,0x64,0xB6,0x21,0xF1,0x48,0x89,0x6D,0xCA,0x2F,0x49,0x27,0xF1,0x5E,0x20,0xAF,0x0D,0x85,0xF7,0x12,0x69,0x6D,0x28,0xBC,
	0x97,0xC8,0x6A,0x43,0xE1,0xD1,0x92,0xDA,0x6C,0xD7,0x65,0xD9,0x3B,0xA8,0xBC,0xE7,0xE6,0xB4,0x21,0xF1,0x48,0x29,0x6D,0xB6,0xC6,0xE2,0x99,0xE3,0xF3,0x25,0x32,0xDA,
	0x50,0x78,0xB4,0x84,0x36,0xE5,0x97,0x42,0x53,0x78,0x2F,0x91,0xCF,0xA6,0x0D,0xEF,0x39,0xE9,0x6C,0x48,0x3C,0x52,0x36,0x9B,0x6D,0xD0,0x6A,0x3E,0xBC,0x70,0x32,0x9B,
	0x32,0xC3,0xFC,0x4B,0x26,0xB3,0x91,0xAB,0xDF,0xCB,0xE5,0xB2,0x91,0xE4,0xBD,0x58,0x2A,0x9B,0x7C,0x7B,0x7E,0xF1,0x4C,0x36,0xCD,0xC0,0x17,0x4E,0x64,0x53,0x68,0xD1,
	0x2F,0x9D,0xC7,0xA6,0x71,0x88,0xBE,0x70,0x1E,0x1B,0x3A,0xEF,0x79,0x79,0x6C,0x9E,0xC7,0xA3,0xE7,0xB1,0x69,0xC1,0x7B,0x56,0x1E,0x9B,0x76,0xBC,0xF6,0x79,0x6C,0xC8,
	0xBC,0x67,0xE6,0xB1,0x79,0x1E,0x8F,0x9E,0xC7,0xA6,0x3D,0xAF,0x5D,0x1E,0x1B,0x32,0xEF,0x99,0x79,0x6C,0xC8,0xBC,0x67,0xE6,0xB1,0x21,0xF1,0x5E,0x20,0x8F,0x0D,0xB9,
	0x7E,0xCF,0xCC,0x63,0xF3,0x62,0x3C,0xC9,0x3C,0x36,0x64,0xDE,0x33,0xF3,0xD8,0x90,0x79,0xCF,0xCC,0x63,0x43,0xE6,0x3D,0x33,0x8F,0x4D,0x2B,0xDE,0x33,0xF2,0xD8,0xB4,
	0xE1,0x3D,0x27,0x8F,0x0D,0x9D,0xF7,0xBC,0x3C,0x36,0x64,0xDE,0x33,0xF3,0xD8,0xD0,0x79,0xCF,0xCB,0x63,0x43,0xE6,0x3D,0x33,0x8F,0x4D,0x5B,0x5E,0xDB,0x3C,0x36,0x2F,
	0xC1,0xA3,0xE4,0xB1,0xA9,0xE3,0xBD,0xE6,0xB1,0x79,0xCD,0x63,0x13,0xBF,0xC1,0x6B,0x1E,0x9B,0x0C,0xF0,0x35,0x8F,0x4D,0x13,0xEE,0x35,0x8F,0xCD,0x6B,0x1E,0x1B,0x09,
	0xDA,0x6B,0x1E,0x9B,0x3C,0xEC,0x35,0x8F,0x8D,0x64,0x8D,0x5F,0xF3,0xD8,0xC8,0x4D,0xCC,0xD7,0x3C,0x36,0x45,0xDC,0x6B,0x1E,0x9B,0xAC,0x54,0x7D,0xCD,0x63,0x53,0x41,
	0x7B,0xCD,0x63,0x53,0x1C,0x2B,0xAF,0x79,0x6C,0x4A,0x60,0xAF,0x79,0x6C,0x52,0xAB,0x4F,0xAF,0x1C,0xF7,0x9A,0xC7,0x46,0xE0,0x5E,0xF3,0xD8,0x24,0x15,0x7C,0xCD,0x63,
	0x53,0x07,0x7B,0xCD,0x63,0x53,0x68,0xC9,0xD7,0x3C,0x36,0x15,0xC0,0xD7,0x3C,0x36,0xA9,0x30,0xDE,0xAF,0x9B,0xC7,0x26,0xD5,0x99,0xBC,0xD6,0xFF,0x1D,0x69,0x6C,0xBA,
	0xAF,0x79,0x6C,0x5E,0xF3,0xD8,0x48,0xC2,0x5E,0xF3,0xD8,0xD4,0xD5,0xED,0x35,0x8F,0x4D,0x56,0xA7,0x10,0x79,0x6C,0x2E,0x2E,0x8E,0x4F,0x31,0x8B,0xCD,0x8D,0x63,0x62,
	0x37,0xD2,0xEE,0xF9,0x8A,0xE0,0x23,0x35,0xA7,0xAA,0x21,0xBC,0x6E,0xD1,0x3F,0x08,0x42,0xDF,0x93,0x4A,0x4B,0x51,0x4E,0xBB,0x19,0x9C,0xE4,0x82,0x51,0xEB,0x68,0x87,
	0xBB,0x30,0xF4,0x5C,0x36,0x3A,0xD1,0x39,0x41,0xE1,0x72,0xDA,0x81,0x4E,0xA0,0x4D,0xF0,0x36,0xAF,0x47,0x0F,0xA3,0x22,0xBD,0x85,0xD7,0x82,0x36,0x19,0x0C,0x53,0xB8,
	0x06,0x1A,0xC6,0x64,0xF1,0x00,0x34,0xCF,0x76,0x97,0x8E,0x07,0xC2,0x52,0x16,0xC8,0x69,0x3F,0xE5,0xC3,0xB2,0xA5,0x68,0x71,0x74,0xAB,0x34,0x56,0xD0,0xF2,0xD3,0xBD,
	0x8E,0x26,0x02,0xF6,0xD9,0xF5,0xE3,0x36,0xA9,0x21,0xA3,0x51,0x72,0x4B,0xE8,0xB7,0x53,0x1F,0x26,0xBA,0x32,0x7B,0xB0,0x7D,0x1A,0x2A,0xA2,0x6D,0xF5,0x7F,0x92,0x68,
	0xB8,0x31,0xFD,0x23,0x18,0xEB,0xFC,0x3C,0xA2,0x67,0xC9,0xA5,0x69,0x89,0x69,0x66,0x3E,0xFC,0xBB,0x8E,0x76,0xE6,0x39,0xEC,0x42,0x2B,0x44,0x1D,0x5A,0x0E,0xA5,0x82,
	0x62,0x06,0x8C,0x09,0xB4,0x0B,0x7E,0x58,0xDF,0xF3,0x9F,0x94,0xD9,0xC6,0xAB,0x0F,0x0C,0x29,0xA5,0x1D,0x1D,0x53,0x68,0x96,0x19,0xAE,0x51,0x0D,0x0B,0x7D,0x73,0x1B,
	0x28,0x6F,0x79,0x9C,0xCB,0x6E,0x15,0xFC,0xA5,0x91,0xCB,0x5B,0xD2,0xB8,0xA3,0xD0,0xAE,0xE7,0x53,0x25,0x42,0x1E,0xF8,0x1B,0xCF,0x27,0xCE,0xB7,0x4B,0xCA,0x7C,0xBB,
	0xC6,0x0C,0x26,0x96,0x32,0x31,0x17,0xF9,0xC3,0xAA,0x92,0x2D,0x39,0xD8,0x11,0xEA,0x76,0xB3,0xF3,0xB7,0xC0,0x61,0xBB,0x7E,0x4B,0xCF,0x24,0x8F,0x92,0xED,0x3A,0x7F,
	0xA4,0xA4,0x8E,0x46,0x96,0x8E,0x85,0xBA,0x51,0xA4,0xF2,0xCC,0x74,0x36,0xA8,0x5F,0xB6,0x6F,0xC9,0x0F,0x14,0x1A,0x3B,0x5A,0xB1,0xA0,0xCD,0xB4,0x14,0x6D,0x1B,0xF4,
	0x69,0x34,0x1E,0xD7,0x02,0xCB,0xF7,0xBD,0xED,0xDE,0x4B,0x4B,0x92,0xA8,0x6E,0x33,0xCA,0x98,0x2C,0x4B,0x23,0x77,0xE5,0xB9,0xDD,0x20,0x44,0x2F,0xAB,0xBF,0x52,0x1C,
	0xEB,0x3E,0xF8,0x4A,0x29,0xE8,0xA0,0xC2,0x20,0xB1,0x2D,0xC7,0x0A,0xC9,0x37,0xB1,0x75,0x06,0xDA,0x40,0x52,0x6B,0x61,0xDB,0x37,0x31,0xEF,0xD6,0xF3,0x60,0x55,0xA2,
	0x6B,0x84,0x5A,0x5F,0xD7,0x68,0x5A,0xD2,0xA5,0xB5,0x5C,0x9B,0xFC,0x96,0x7B,0xAA,0x62,0xD6,0xE9,0xEB,0xE3,0x91,0x51,0xF0,0x9F,0x55,0xD5,0xCE,0x88,0x2E,0xF1,0x7F,
	0x91,0xA4,0x82,0x2F,0xD4,0xB9,0x67,0xF6,0x96,0x87,0x84,0x42,0xE5,0x03,0x71,0xBB,0x47,0xF7,0x7B,0x05,0x3F,0xFE,0xAE,0xC9,0x97,0xDE,0x6A,0x28,0x05,0xCA,0x35,0x68,
	0x34,0x92,0x88,0xE7,0xD1,0xB2,0x5D,0x1B,0x50,0xA0,0x2D,0x68,0x4C,0xA9,0x81,0xA5,0x71,0xE6,0x78,0x5B,0x0B,0xAF,0xDD,0x86,0x35,0x79,0xD0,0x07,0xF3,0xF4,0x33,0xFF,
	0xE7,0x2F,0xD5,0xFC,0x16,0xB4,0x3F,0xD2,0x18,0x7A,0xF9,0xE4,0x9C,0x35,0xB4,0x28,0x35,0xE8,0xCB,0x98,0x54,0x43,0x92,0xB0,0x28,0x75,0x8B,0x69,0x2C,0xDA,0xEA,0xC8,
	0x36,0x61,0xE9,0x93,0x4C,0x03,0x98,0x79,0x83,0x9B,0xC3,0x03,0xF9,0x65,0xE8,0xF9,0x66,0xDD,0xF0,0xAB,0x9A,0x75,0xC3,0xAF,0x6A,0xD6,0x0D,0xBF,0xAA,0x59,0x37,0xFC,
	0xAA,0x66,0xDD,0xF0,0xAB,0x9A,0x75,0xC3,0xAF,0x6A,0xD6,0x0D,0xBF,0xAA,0x59,0x37,0xFC,0xAA,0x66,0xDD,0xF0,0xAB,0x9A,0x75,0xC3,0xAF,0x6A,0xD6,0x0D,0xBF,0xAA,0x59,
	0x37,0x24,0x99,0x75,0xA5,0xB2,0x9A,0xBD,0xC1,0x0C,0x14,0x02,0x8B,0xC8,0x8F,0xDF,0x80,0x30,0x07,0x9F,0x6F,0x5A,0x0E,0xBF,0xAA,0x69,0x39,0xFC,0xAA,0xA6,0xE5,0xF0,
	0xAB,0x9A,0x96,0x43,0xB2,0x69,0xF9,0x1C,0x63,0x6F,0xF8,0x3F,0xDB,0xD8,0x7B,0x61,0xE3,0xAB,0x74,0xCF,0x2D,0x03,0xFC,0xF2,0xD6,0x65,0x6C,0x5C,0x7E,0x1D,0x73,0xEF,
	0xD5,0xDA,0x7B,0xB5,0xF6,0x5E,0xAD,0xBD,0x17,0x68,0xE7,0xD4,0x06,0xDA,0xC1,0x6F,0x5F,0x1B,0xFE,0x87,0x6A,0xF6,0x13,0xC7,0xDE,0x6E,0x41,0x6F,0x7A,0x7B,0x65,0x59,
	0x60,0x66,0xDE,0x82,0x91,0x24,0x99,0xED,0x01,0x05,0xF3,0x78,0x5C,0x22,0x27,0x7B,0xFB,0xE3,0x31,0xBF,0xFC,0xBC,0x37,0x1A,0x0A,0x6A,0x37,0xFA,0x0B,0xFF,0x25,0x73,
	0x5C,0x61,0x82,0x3A,0xB5,0xEA,0x5E,0x56,0xCF,0x71,0xD8,0x4D,0x25,0x2D,0x32,0xFC,0x61,0x50,0x88,0x2E,0xED,0x3E,0x8B,0xDF,0xA2,0xD3,0x06,0x16,0x31,0xF1,0xF8,0x43,
	0x9F,0xCA,0xE4,0xC4,0x85,0x67,0xFA,0xAB,0xF4,0x6D,0x1B,0xB7,0x6B,0xCB,0x72,0x82,0x86,0x5D,0xF8,0x8E,0xA1,0xF5,0x55,0x15,0xB7,0xE0,0x25,0xEC,0x52,0xE0,0x31,0x9C,
	0xEB,0x3D,0x06,0x6B,0xAF,0xD5,0xA9,0x27,0xBD,0xA7,0x11,0x7C,0x92,0x49,0x05,0x69,0x07,0x01,0xD2,0xC4,0x01,0x26,0xF4,0x92,0xF6,0xF1,0x46,0x55,0x7C,0xB0,0x95,0x41,
	0xAB,0xE4,0xEA,0xFC,0x4A,0xF6,0x31,0xB9,0x8A,0x65,0x13,0x32,0xA3,0x65,0x99,0xCB,0xA5,0x15,0x04,0x9E,0x6F,0x5B,0x52,0xCA,0xD6,0x73,0x26,0x33,0x4B,0x88,0xA9,0x68,
	0x9F,0x0D,0x71,0x98,0x45,0x04,0xE4,0x58,0x9F,0x40,0x0F,0x5A,0xB1,0xD3,0x90,0x95,0xD1,0x10,0x9D,0xD1,0xA8,0xD7,0xEB,0x49,0xD5,0x3E,0xCE,0x6A,0x32,0xDB,0xF9,0x77,
	0xCA,0x21,0x1B,0xBE,0xB8,0x38,0x0D,0xF6,0xFB,0xF2,0x3B,0x25,0x78,0x66,0x6F,0x58,0xC4,0x45,0x28,0x26,0x33,0x38,0x53,0x49,0x0D,0xA7,0x02,0x90,0x57,0x94,0xDD,0x6B,
	0x72,0xE2,0x98,0x9B,0x6A,0x8B,0x9D,0x03,0xF1,0x5E,0xF1,0xEC,0x7C,0xA9,0x05,0xC6,0x2E,0xC1,0x83,0xDF,0x92,0x92,0x5E,0x97,0x8B,0x2F,0xB3,0x5C,0x74,0xD3,0xEB,0x45,
	0x6E,0xB9,0xF8,0x43,0xAC,0x16,0xFF,0x0D,0x8B,0xC5,0xBF,0xFB,0x5A,0xF1,0x92,0x4B,0x45,0x21,0xF6,0xAD,0x1A,0xF8,0xF5,0x56,0x8A,0xD7,0x85,0xE2,0x0B,0x2E,0x14,0xC5,
	0xE0,0xBF,0x2F,0xBC,0x50,0x54,0x02,0xD9,0x42,0x31,0x9B,0x1C,0x5C,0x7D,0xBC,0x9E,0x1E,0x1D,0x4F,0xC1,0xA4,0x50,0x95,0xFF,0x52,0x66,0x67,0xD7,0xB7,0xCA,0xDF,0x2E,
	0x8E,0xA6,0x07,0xB7,0x47,0xE7,0xD3,0xEF,0x6F,0x4C,0x30,0xED,0xBE,0xF9,0x93,0x06,0xBF,0x39,0x3B,0x3F,0x3A,0x4E,0xFF,0x06,0xA5,0x9A,0x5E,0x7C,0xE2,0xBD,0xEB,0xDD,
	0xDD,0xD9,0x4B,0xDB,0x74,0x7E,0xBD,0x98,0x3D,0xB9,0xE1,0x1A,0xBF,0x67,0xD4,0x7E,0x4F,0x40,0xFE,0xAA,0xF4,0x8B,0x98,0xF4,0xD7,0xF0,0x2B,0x83,0xDA,0x92,0xCE,0x2C,
	0x07,0x24,0x3D,0x7E,0x6F,0x58,0xFB,0xBD,0xC9,0x2E,0x08,0xBD,0x4D,0x64,0x51,0xCD,0x7E,0xB9,0x9A,0x9F,0x41,0xFD,0xFF,0xF3,0xE6,0x60,0x7E,0x06,0xCF,0x75,0x8E,0xAC,
	0x3B,0x8C,0x8B,0x34,0x17,0x81,0xE7,0xEC,0x60,0xD0,0x6D,0x4D,0xE8,0x87,0xD0,0x53,0x78,0x85,0x3A,0x58,0xFE,0xC1,0x67,0xC7,0xDA,0x53,0x96,0xCC,0x07,0xB7,0xC6,0xF3,
	0x57,0xE8,0x4A,0x08,0x78,0xBA,0xB2,0xF0,0x69,0x0B,0x7D,0xC5,0xBF,0xAC,0x3C,0xA0,0x50,0x82,0xA2,0xBC,0x5D,0xF8,0xDD,0x37,0x7F,0xEA,0x41,0x87,0x28,0x1F,0x8E,0xA7,
	0xB3,0xF3,0xEB,0x2B,0x45,0xDF,0x57,0xAB,0x07,0xD1,0x7F,0xA5,0xBF,0x06,0x0F,0xAA,0xF0,0xE0,0xE1,0xF4,0x7C,0xF2,0xE3,0xC7,0x83,0xE9,0xA4,0x6E,0xF4,0x41,0xBD,0xB1,
	0x3E,0xCA,0xE1,0xF1,0xE9,0xF9,0x55,0xEA,0x11,0x0C,0x24,0xEF,0x69,0x50,0xCA,0xF1,0xC5,0xF1,0x64,0x0E,0x1F,0x7F,0xBC,0xFA,0x79,0xFE,0x71,0x72,0x70,0x78,0x71,0xDC,
	0x58,0x4A,0xC9,0x23,0xAC,0x38,0x3D,0x5D,0xDC,0xCD,0xF5,0xED,0xF1,0xF4,0xE3,0xC9,0xFB,0xAB,0xC9,0x1C,0x5E,0x7B,0x96,0x29,0xBA,0xA2,0xB8,0xF2,0x47,0x58,0xD1,0x46,
	0x63,0xD1,0x1F,0xCF,0x0E,0x2E,0x4E,0x68,0x45,0xF3,0x47,0x58,0xF9,0xFD,0x74,0xF9,0xD3,0xC9,0xCF,0xD4,0x96,0x48,0x1E,0x61,0xC5,0x0D,0xA0,0xB8,0x93,0xF3,0x43,0x40,
	0x5E,0xDF,0xCC,0xCF,0x27,0x33,0xC9,0xE2,0x4A,0x1E,0x61,0xC5,0x0D,0x4B,0x8B,0xFB,0x78,0x8B,0x93,0x83,0x54,0x1C,0x7F,0x84,0x95,0x09,0xD3,0x5E,0x39,0xBB,0x9E,0x1D,
	0x7F,0x3C,0xB9,0x38,0xFE,0xF9,0x1C,0x7F,0xC7,0x02,0xDE,0x9B,0x5E,0xB1,0xE4,0x11,0x56,0xDC,0xB8,0x50,0x9C,0xAA,0x95,0x95,0x56,0x5B,0x1C,0x3E,0x82,0xA5,0xE1,0xB5,
	0x9C,0xF9,0x5F,0x8D,0xE9,0xA5,0x8D,0x45,0x69,0x38,0x59,0x2E,0xCF,0xAF,0xCE,0x4F,0xCE,0x4F,0x3F,0x4E,0xCE,0x0E,0xCE,0xAF,0x3E,0xAA,0x03,0x89,0xD2,0x8A,0x8F,0xB0,
	0xD2,0x70,0xD2,0xCC,0xA0,0xD3,0xAF,0x4E,0x3F,0x22,0xAF,0xAC,0x9C,0xB2,0xD2,0xD2,0x8F,0xB0,0x72,0xF4,0xA4,0x1C,0x55,0x2D,0x7D,0x9D,0xBA,0x72,0xF0,0x11,0x56,0x8C,
	0x91,0x14,0xA3,0xD1,0x8B,0xD1,0xA2,0x62,0xFA,0x49,0x31,0x3A,0xBD,0x18,0x3D,0x2A,0x66,0x90,0x14,0x63,0xD0,0x8B,0x31,0xA2,0x62,0x86,0x49,0x31,0xB7,0xE7,0xF3,0xB3,
	0x8F,0xA7,0xD3,0xF3,0x9B,0x59,0x59,0xFD,0x4A,0x8B,0xC9,0x3D,0xC2,0x4A,0xC4,0xE1,0x3E,0x3F,0x9E,0x9C,0x5D,0xC1,0x64,0x3D,0xF8,0xF9,0x22,0x19,0x26,0xF5,0x25,0x96,
	0x3F,0xC2,0x4A,0x1C,0xA7,0x4A,0xC4,0xDF,0x74,0x67,0xBF,0xCC,0xE6,0xC7,0x97,0xC5,0xA9,0x5E,0x5E,0x62,0xF1,0x11,0x2C,0x15,0x0F,0xDC,0x94,0x7E,0xA5,0x30,0xD4,0x9A,
	0x4B,0x8D,0x87,0x9A,0xA6,0xA6,0x0A,0xBD,0xB9,0x3A,0x7E,0x7F,0x79,0x00,0x22,0x81,0xFD,0xFE,0xE3,0xE1,0xF1,0x07,0x10,0x62,0x47,0xB5,0x85,0x56,0x3C,0xC2,0x8A,0xD6,
	0x52,0x45,0x4F,0xCF,0x0F,0x0F,0x8F,0x8F,0x2A,0x66,0x45,0x79,0xD1,0xE9,0x47,0xB0,0xBC,0xBF,0xB2,0x2C,0x29,0x7B,0x0A,0x0B,0x5E,0xC4,0x45,0x34,0xC4,0x94,0xEE,0x75,
	0x6B,0xA8,0x86,0xF3,0x68,0xFA,0xFE,0x10,0x45,0xDD,0xE1,0xC1,0xD5,0x51,0x91,0x5C,0xFE,0x06,0xE9,0x47,0x58,0x4D,0x8C,0x54,0x39,0xC7,0x17,0x73,0x6A,0x39,0xF8,0x08,
	0xAF,0x81,0x18,0x85,0x94,0x97,0x49,0x3F,0xC2,0x5E,0xA6,0x9F,0x6A,0x56,0x2E,0x7F,0x2E,0xCE,0xAF,0x7E,0x6C,0x2C,0xA7,0xE4,0x11,0x56,0xDC,0xA0,0xB4,0x38,0x3E,0x51,
	0xE6,0xB7,0xD7,0x1F,0x67,0xF3,0xF7,0x47,0x33,0x99,0xE2,0xF2,0x8F,0xB0,0xD2,0x87,0x85,0xD2,0xE7,0xD3,0xE3,0x83,0x92,0xCA,0xD7,0x95,0xCE,0x1F,0x61,0xE5,0x8D,0xCA,
	0xCB,0xFB,0xA8,0x8F,0xA8,0xE5,0xE1,0x23,0xAC,0xC8,0xF4,0x64,0xAD,0x78,0xB9,0xBA,0x22,0x93,0x97,0xD3,0x7B,0xF9,0x92,0x3E,0x4E,0x40,0xA3,0xBC,0x38,0x9E,0x12,0x4A,
	0x8A,0x1F,0xE1,0x03,0x66,0xE2,0x6D,0xB6,0x8E,0xC5,0x34,0x4B,0xDC,0x3A,0x29,0x1D,0xE6,0x06,0x72,0x6F,0x2E,0xCE,0x3F,0x16,0x95,0xAF,0x8F,0x5A,0x6F,0x72,0x59,0xC5,
	0xAD,0x7B,0x04,0xE9,0x86,0x5A,0x5D,0xAE,0xDE,0x27,0x97,0xCB,0x1E,0x61,0xE5,0x6A,0xD5,0xE5,0xF6,0xE9,0xEF,0xDB,0x8F,0xDF,0x57,0xCF,0x97,0x8B,0xAA,0xD7,0xF4,0x7A,
	0xFE,0x71,0x76,0x7C,0x35,0xBB,0x9E,0x4A,0x95,0x9B,0x7B,0x84,0x95,0x6B,0x94,0x95,0x7B,0x71,0x7E,0x7A,0x96,0x2F,0xB9,0xA1,0xDC,0xCC,0x23,0xAC,0xE4,0x7E,0x59,0xC9,
	0xBC,0x5A,0xAA,0x2E,0xD9,0x12,0xB9,0x47,0x58,0xB9,0x83,0x9A,0x72,0x87,0xF4,0x72,0x87,0x51,0xB9,0xC3,0xEA,0x72,0x35,0xFA,0xFB,0x6A,0xF1,0xFB,0x8E,0xAA,0xCB,0x35,
	0x64,0x47,0x44,0xEE,0x11,0x56,0xEE,0xB8,0xBA,0xDC,0x01,0xBD,0xDC,0x41,0x54,0x6E,0xBF,0x30,0xE3,0x52,0x8D,0x95,0x79,0x61,0xB9,0xF6,0x8D,0x5F,0xB8,0x5F,0x98,0x72,
	0xC9,0xB7,0x74,0x6D,0x44,0x2D,0x98,0x3F,0xC2,0x0A,0x8E,0xE6,0x5C,0x51,0x49,0x17,0x72,0xFB,0xE0,0x70,0x56,0x51,0x70,0xED,0x23,0xAC,0x70,0xBD,0xBE,0xF0,0xEB,0xF7,
	0x73,0x51,0xBE,0x74,0xE1,0xF1,0x23,0xAC,0x7C,0xA3,0xB4,0xFC,0x12,0x2B,0xA2,0xA9,0xFC,0xC8,0x8A,0xE8,0xF7,0xCB,0x4B,0x2C,0x5A,0x12,0x8D,0x25,0x0A,0x4B,0xA2,0x1F,
	0x4D,0xB9,0x46,0x6B,0xA2,0x58,0x62,0xB9,0x35,0xD1,0x8F,0x26,0x5B,0xA3,0x25,0x50,0x2C,0x31,0x67,0x09,0xF4,0x47,0xD9,0xA2,0xAA,0xAD,0x81,0xCA,0xA2,0x22,0x6D,0xB9,
	0x3F,0xCE,0x16,0x55,0xAD,0x83,0x57,0x16,0x55,0xA2,0x83,0x0F,0x7A,0xD9,0x52,0xAB,0x0D,0x84,0xCA,0x52,0x23,0x03,0x61,0x10,0x4D,0xA1,0x52,0xFD,0xFC,0xE3,0xB0,0xAE,
	0xA8,0xAA,0x47,0x58,0xB9,0x5A,0x6D,0xB9,0xAA,0x4A,0x2E,0x17,0x1E,0x61,0x05,0xEB,0xF5,0x05,0x6B,0xF4,0x82,0x35,0x5E,0xB0,0x51,0x5F,0xB0,0x41,0x2F,0xD8,0xE0,0x05,
	0xF7,0xEB,0x0B,0x1E,0xD0,0x0B,0x1E,0xF0,0x82,0x07,0xF5,0x05,0x8F,0xE9,0x05,0x8F,0x79,0xC1,0xC3,0x5C,0xC1,0x95,0x8A,0x5E,0x75,0xC1,0x89,0xA2,0x37,0x18,0x95,0x95,
	0x56,0xA6,0xEC,0x55,0x97,0x96,0x56,0xF3,0xE6,0x18,0xF0,0xE8,0x62,0x3E,0x01,0x33,0xB4,0x36,0xF0,0xD3,0x77,0xCA,0xF9,0xD5,0xAC,0xE0,0xC1,0x49,0x95,0xC7,0x7F,0x5D,
	0xFA,0x24,0x48,0xCE,0xB2,0x47,0xA3,0x27,0xC5,0xAF,0x4B,0x1F,0x9D,0x4C,0xAF,0x67,0xB3,0xEA,0x26,0x61,0xBF,0xFE,0xE6,0x4F,0x1F,0xEC,0xC0,0x5E,0xD8,0x8E,0x1D,0x3E,
	0xA5,0x9F,0x65,0x2E,0xD4,0x8A,0x07,0xF1,0x77,0x55,0xCF,0x9D,0xD5,0xBC,0xEB,0x19,0x7B,0x51,0x54,0x83,0xF1,0xE2,0x1C,0xEF,0x4E,0xB9,0xB3,0x1D,0xEB,0x9B,0x3F,0xFD,
	0x7F,0x15,0x4B,0x0F,0xBE,
};

static int lcGetMinifigSettings(lcMemFile& File)
{
	const size_t CHUNK = 16384;
	int ret;
	unsigned have;
	z_stream strm;
	unsigned char in[CHUNK];
	unsigned char out[CHUNK];
	int pos;

	strm.zalloc = Z_NULL;
	strm.zfree = Z_NULL;
	strm.opaque = Z_NULL;
	strm.avail_in = 0;
	strm.next_in = Z_NULL;
	pos = 0;

	ret = inflateInit(&strm);
	if (ret != Z_OK)
		return ret;

	do
	{
		strm.avail_in = lcMin(sizeof(sDefaultSettings) - pos, CHUNK);
		strm.next_in = in;

		if (strm.avail_in == 0)
			break;

		memcpy(in, sDefaultSettings + pos, strm.avail_in);
		pos += strm.avail_in;

		do
		{
			strm.avail_out = CHUNK;
			strm.next_out = out;
			ret = inflate(&strm, Z_NO_FLUSH);

			switch (ret)
			{
			case Z_NEED_DICT:
				ret = Z_DATA_ERROR;
			case Z_DATA_ERROR:
			case Z_MEM_ERROR:
				(void)inflateEnd(&strm);
				return ret;
			}

			have = CHUNK - strm.avail_out;
			File.WriteBuffer(out, have);
		} while (strm.avail_out == 0);
	} while (ret != Z_STREAM_END);

	(void)inflateEnd(&strm);

	return ret == Z_STREAM_END ? Z_OK : Z_DATA_ERROR;
}

// =============================================================================
// MinifigWizard class

MinifigWizard::MinifigWizard(lcMinifig* Minifig)
{
	char Filename[LC_MAXPATH];
	strcpy(Filename, lcGetPiecesLibrary()->mLibraryPath);
	strcat(Filename, "mlcad.ini");

	lcDiskFile DiskSettings;
	if (DiskSettings.Open(Filename, "rt"))
	{
		ParseSettings(DiskSettings);
	}
	else
	{
		lcMemFile MemSettings;
		lcGetMinifigSettings(MemSettings);
		ParseSettings(MemSettings);
	}

	mMinifig = Minifig;

	m_RotateX = 75.0f;
	m_RotateZ = 180.0f;
	m_Distance = 10.0f;
	m_AutoZoom = true;
	m_Tracking = LC_TRACK_NONE;
}

void MinifigWizard::OnInitialUpdate()
{
	MakeCurrent();

	memset(mMinifig, 0, sizeof(lcMinifig));

	const int ColorCodes[LC_MFW_NUMITEMS] = { 4, 7, 14, 7, 1, 0, 7, 4, 4, 14, 14, 7, 7, 0, 0, 7, 7 };
	const char* Pieces[LC_MFW_NUMITEMS] = { "3624", "None", "3626BP01", "None", "973", "3815", "None", "3819", "3818", "3820", "3820", "None", "None", "3817", "3816", "None", "None" };

	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
	{
		mMinifig->Colors[i] = lcGetColorIndex(ColorCodes[i]);

		PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(Pieces[i], false);
		if (Info)
		{
			mMinifig->Parts[i] = Info;
			Info->AddRef();
		}
	}

	Calculate();
}

MinifigWizard::~MinifigWizard ()
{
	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
		if (mMinifig->Parts[i])
			mMinifig->Parts[i]->Release();
}

void MinifigWizard::ParseSettings(lcFile& Settings)
{
	const char* SectionNames[LC_MFW_NUMITEMS] =
	{
		"[HATS]",   // LC_MFW_HATS
		"[HATS2]",  // LC_MFW_HATS2
		"[HEAD]",   // LC_MFW_HEAD
		"[NECK]",   // LC_MFW_NECK
		"[BODY]",   // LC_MFW_BODY
		"[BODY2]",  // LC_MFW_BODY2
		"[BODY3]",  // LC_MFW_BODY3
		"[RARM]",   // LC_MFW_RARM
		"[LARM]",   // LC_MFW_LARM
		"[RHAND]",  // LC_MFW_RHAND
		"[LHAND]",  // LC_MFW_LHAND
		"[RHANDA]", // LC_MFW_RHANDA
		"[LHANDA]", // LC_MFW_LHANDA
		"[RLEG]",   // LC_MFW_RLEG
		"[LLEG]",   // LC_MFW_LLEG
		"[RLEGA]",  // LC_MFW_RLEGA
		"[LLEGA]",  // LC_MFW_LLEGA
	};

	for (int SectionIndex = 0; SectionIndex < LC_MFW_NUMITEMS; SectionIndex++)
	{
		lcArray<lcMinifigPieceInfo>& InfoArray = mSettings[SectionIndex];

		InfoArray.RemoveAll();
		Settings.Seek(0, SEEK_SET);

		char Line[1024];
		bool FoundSection = false;
		const char* SectionName = SectionNames[SectionIndex];
		int SectionNameLength = strlen(SectionName);

		// Find start of section
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (!strncmp(Line, SectionName, SectionNameLength))
			{
				FoundSection = true;
				break;
			}
		}

		if (!FoundSection)
		{

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, "None", sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = lcMatrix44Identity();
			MinifigInfo.Info = NULL;

			InfoArray.Add(MinifigInfo);
			continue;
		}

		// Parse section.
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (Line[0] == '[')
				break;

			char* DescriptionStart = strchr(Line, '"');
			if (!DescriptionStart)
				continue;
			DescriptionStart++;
			char* DescriptionEnd = strchr(DescriptionStart, '"');
			if (!DescriptionEnd)
				continue;
			*DescriptionEnd = 0;
			DescriptionEnd++;

			char* NameStart = strchr(DescriptionEnd, '"');
			if (!NameStart)
				continue;
			NameStart++;
			char* NameEnd = strchr(NameStart, '"');
			if (!NameEnd)
				continue;
			*NameEnd = 0;
			NameEnd++;

			strupr(NameStart);
			char* Ext = strrchr(NameStart, '.');
			if (Ext != NULL)
			{
				if (!strcmp(Ext, ".DAT"))
					*Ext = 0;
			}

			PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(NameStart, false);
			if (!Info && *NameStart)
				continue;

			float Mat[12];
			int Flags;

			if (sscanf(NameEnd, "%d %g %g %g %g %g %g %g %g %g %g %g %g",
					   &Flags, &Mat[0], &Mat[1], &Mat[2], &Mat[3], &Mat[4], &Mat[5], &Mat[6], 
					   &Mat[7], &Mat[8], &Mat[9], &Mat[10], &Mat[11]) != 13)
				continue;

			lcMatrix44 Offset = lcMatrix44Identity();
			float* OffsetMatrix = &Offset[0][0];

			OffsetMatrix[0] =  Mat[0];
			OffsetMatrix[8] = -Mat[1];
			OffsetMatrix[4] =  Mat[2];
			OffsetMatrix[2] = -Mat[3];
			OffsetMatrix[10] = Mat[4];
			OffsetMatrix[6] = -Mat[5];
			OffsetMatrix[1] =  Mat[6];
			OffsetMatrix[9] = -Mat[7];
			OffsetMatrix[5] =  Mat[8];
			OffsetMatrix[12] =  Mat[9] / 25.0f;
			OffsetMatrix[14] = -Mat[10] / 25.0f;
			OffsetMatrix[13] =  Mat[11] / 25.0f;

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, DescriptionStart, sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = Offset;
			MinifigInfo.Info = Info;

			InfoArray.Add(MinifigInfo);
		}
	}
}

void MinifigWizard::OnDraw()
{
	float Aspect = (float)mWidth/(float)mHeight;
	glViewport(0, 0, mWidth, mHeight);

	float Box[6] = { 10000, 10000, 10000, -10000, -10000, -10000 };

	for (int InfoIdx = 0; InfoIdx < LC_MFW_NUMITEMS; InfoIdx++)
	{
		PieceInfo* Info = mMinifig->Parts[InfoIdx];

		if (!Info)
			continue;

		lcVector3 Points[8] =
		{
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[2])
		};

		for (int PointIdx = 0; PointIdx < 8; PointIdx++)
		{
			lcVector3 Point = lcMul31(Points[PointIdx], mMinifig->Matrices[InfoIdx]);

			if (Point[0] < Box[0]) Box[0] = Point[0];
			if (Point[1] < Box[1]) Box[1] = Point[1];
			if (Point[2] < Box[2]) Box[2] = Point[2];
			if (Point[0] > Box[3]) Box[3] = Point[0];
			if (Point[1] > Box[4]) Box[4] = Point[1];
			if (Point[2] > Box[5]) Box[5] = Point[2];
		}
	}

	lcVector3 Center((Box[0] + Box[3]) / 2, (Box[1] + Box[4]) / 2, (Box[2] + Box[5]) / 2);

	lcVector3 Eye(0.0f, 0.0f, 1.0f);

	Eye = lcMul30(Eye, lcMatrix44RotationX(-m_RotateX * LC_DTOR));
	Eye = lcMul30(Eye, lcMatrix44RotationZ(-m_RotateZ * LC_DTOR));

	lcMatrix44 Projection = lcMatrix44Perspective(30.0f, Aspect, 1.0f, 100.0f);
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixf(Projection);

	if (m_AutoZoom)
	{
		lcVector3 Points[8] =
		{
			lcVector3(Box[0], Box[1], Box[5]),
			lcVector3(Box[3], Box[1], Box[5]),
			lcVector3(Box[0], Box[1], Box[2]),
			lcVector3(Box[3], Box[4], Box[5]),
			lcVector3(Box[3], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[5]),
			lcVector3(Box[3], Box[1], Box[2])
		};

		Eye += Center;

		lcMatrix44 ModelView = lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1));
		Eye = lcZoomExtents(Eye, ModelView, Projection, Points, 8);

		glMatrixMode(GL_MODELVIEW);
		glLoadMatrixf(lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1)));

		// Update the new camera distance.
		lcVector3 d = Eye - Center;
		m_Distance = d.Length();
	}
	else
	{
		glMatrixMode(GL_MODELVIEW);
		glLoadMatrixf(lcMatrix44LookAt(Eye * m_Distance, Center, lcVector3(0, 0, 1)));
	}

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(0.5f, 0.1f);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	float *bg = lcGetActiveProject()->GetBackgroundColor();
	glClearColor(bg[0], bg[1], bg[2], bg[3]);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	Calculate();

	for (int PieceIdx = 0; PieceIdx < LC_MFW_NUMITEMS; PieceIdx++)
	{
		if (!mMinifig->Parts[PieceIdx])
			continue;

		glPushMatrix();
		glMultMatrixf(mMinifig->Matrices[PieceIdx]);
		mMinifig->Parts[PieceIdx]->RenderPiece(mMinifig->Colors[PieceIdx]);
		glPopMatrix();
	}
}

void MinifigWizard::OnLeftButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_LEFT;
		CaptureMouse();
	}
}

void MinifigWizard::OnLeftButtonUp()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnLeftButtonDoubleClick()
{
	m_AutoZoom = true;
	Redraw();
}

void MinifigWizard::OnRightButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_RIGHT;
		CaptureMouse();
	}
}

void MinifigWizard::OnRightButtonUp()
{
	if (m_Tracking == LC_TRACK_RIGHT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnMouseMove()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		// Rotate.
		m_RotateZ += mInputState.x - m_DownX;
		m_RotateX += mInputState.y - m_DownY;

		if (m_RotateX > 179.5f)
			m_RotateX = 179.5f;
		else if (m_RotateX < 0.5f)
			m_RotateX = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
	else if (m_Tracking == LC_TRACK_RIGHT)
	{
		// Zoom.
		m_Distance += (float)(m_DownY - mInputState.y) * 0.2f;
		m_AutoZoom = false;

		if (m_Distance < 0.5f)
			m_Distance = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
}

void MinifigWizard::Calculate()
{
	float HeadOffset = 0.0f;
	lcMatrix44 Root, Mat, Mat2;

	PieceInfo** Parts = mMinifig->Parts;
	float* Angles = mMinifig->Angles;
	lcMatrix44* Matrices = mMinifig->Matrices;

	bool DroidTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "30375");
	bool SkeletonTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "6260");

	if (Parts[LC_MFW_BODY3])
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.96f));
	else
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.88f));
	Matrices[LC_MFW_BODY] = lcMul(mSettings[LC_MFW_BODY][GetSelectionIndex(LC_MFW_BODY)].Offset, Root);

	if (Parts[LC_MFW_NECK])
	{
		Matrices[LC_MFW_NECK] = lcMul(mSettings[LC_MFW_NECK][GetSelectionIndex(LC_MFW_NECK)].Offset, Root);
		HeadOffset = 0.08f;
	}

	if (Parts[LC_MFW_HEAD])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HEAD]);
		Mat.SetTranslation(lcVector3(0.0f, 0.0f, 0.96f + HeadOffset));
		Mat = lcMul(mSettings[LC_MFW_HEAD][GetSelectionIndex(LC_MFW_HEAD)].Offset, Mat);
		Matrices[LC_MFW_HEAD] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_HATS])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HATS]);
		Mat = lcMul(mSettings[LC_MFW_HATS][GetSelectionIndex(LC_MFW_HATS)].Offset, Mat);
		Matrices[LC_MFW_HATS] = lcMul(Mat, Matrices[LC_MFW_HEAD]);
	}

	if (Parts[LC_MFW_HATS2])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_HATS2]);
		Mat = lcMul(mSettings[LC_MFW_HATS2][GetSelectionIndex(LC_MFW_HATS2)].Offset, Mat);
		Matrices[LC_MFW_HATS2] = lcMul(Mat, Matrices[LC_MFW_HATS]);
	}

	if (Parts[LC_MFW_RARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(-LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(0.62f, 0, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_RARM][GetSelectionIndex(LC_MFW_RARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_RARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_RHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_RHAND][GetSelectionIndex(LC_MFW_RHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_RHAND] = lcMul(Mat, Matrices[LC_MFW_RARM]);
	}

	if (Parts[LC_MFW_RHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_RHANDA][GetSelectionIndex(LC_MFW_RHANDA)].Offset, Mat);
		Matrices[LC_MFW_RHANDA] = lcMul(Mat, Matrices[LC_MFW_RHAND]);
	}

	if (Parts[LC_MFW_LARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(-0.62f, 0.0f, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_LARM][GetSelectionIndex(LC_MFW_LARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_LARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_LHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_LHAND][GetSelectionIndex(LC_MFW_LHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(-0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_LHAND] = lcMul(Mat, Matrices[LC_MFW_LARM]);
	}

	if (Parts[LC_MFW_LHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_LHANDA][GetSelectionIndex(LC_MFW_LHANDA)].Offset, Mat);
		Matrices[LC_MFW_LHANDA] = lcMul(Mat, Matrices[LC_MFW_LHAND]);
	}

	if (Parts[LC_MFW_BODY2])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY2][GetSelectionIndex(LC_MFW_BODY2)].Offset, Mat);
		Matrices[LC_MFW_BODY2] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_BODY3])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY3][GetSelectionIndex(LC_MFW_BODY3)].Offset, Mat);
		Matrices[LC_MFW_BODY3] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_RLEG][GetSelectionIndex(LC_MFW_RLEG)].Offset, Mat);
		Matrices[LC_MFW_RLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEGA])
	{
		lcVector3 Center(-0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RLEGA]);
		Mat2 = mSettings[LC_MFW_RLEGA][GetSelectionIndex(LC_MFW_RLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_RLEGA] = lcMul(Mat, Matrices[LC_MFW_RLEG]);
	}

	if (Parts[LC_MFW_LLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_LLEG][GetSelectionIndex(LC_MFW_LLEG)].Offset, Mat);
		Matrices[LC_MFW_LLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LLEGA])
	{
		lcVector3 Center(0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LLEGA]);
		Mat2 = mSettings[LC_MFW_LLEGA][GetSelectionIndex(LC_MFW_LLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_LLEGA] = lcMul(Mat, Matrices[LC_MFW_LLEG]);
	}
}

int MinifigWizard::GetSelectionIndex(int Type) const
{
	const lcArray<lcMinifigPieceInfo>& InfoArray = mSettings[Type];

	for (int Index = 0; Index < InfoArray.GetSize(); Index++)
		if (InfoArray[Index].Info == mMinifig->Parts[Type])
			return Index;

	return 0;
}

void MinifigWizard::SetSelectionIndex(int Type, int Index)
{
	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->Release();

	mMinifig->Parts[Type] = mSettings[Type][Index].Info;

	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->AddRef();

	Calculate();
}

void MinifigWizard::SetColor(int Type, int Color)
{
	mMinifig->Colors[Type] = Color;
}

void MinifigWizard::SetAngle(int Type, float Angle)
{
	mMinifig->Angles[Type] = Angle;
}
