package latexDraw.ui.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import latexDraw.figures.Draw;
import latexDraw.figures.Figure;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.dialog.ExceptionFrameDialog;
import latexDraw.util.LaTeXDrawResources;
import latexDraw.util.VersionChecker;


/** 
 * This class defines a listener for the menu of the program.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 
 * 09/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.9<br>
 */
public class MenusListener extends AbstractListener implements ActionListener
{
	public static final String ACTION_CMD_SHORTCUTS 		= "shortcut";//$NON-NLS-1$
	
	public static final String ACTION_VISIBLE_ALL_FIGURES 	= "visibleAll";//$NON-NLS-1$
	
	public static final String LABEL_CHECK_UPDATE 			= "checkupdate";//$NON-NLS-1$
	
	
	
	public MenusListener(LaTeXDrawFrame frame)
	{
		super(frame);
	}



	public void actionPerformed(ActionEvent e)
	{
    	Object src = e.getSource();
    	
    	if(src instanceof AbstractButton)
    	{
    		AbstractButton ab = ((AbstractButton)src);
    		String label = ab.getActionCommand();
    		DrawPanel drawPanel = mainFrame.getDrawPanel();
    		boolean ok = ab.isSelected();
    		
    		if(label.equals(LaTeXDrawResources.LABEL_SAVE))
    		{
    			mainFrame.save(false);
    			mainFrame.requestFocus();
    			return;
    		}   		
    		    		
    		if(label.equals(LaTeXDrawResources.LABEL_SAVE_AS))
    		{
    			mainFrame.save(true);
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_OPEN))
    		{
    			try
    			{
    		    	if(drawPanel.isModified())
    		    		switch(JOptionPane.showConfirmDialog(mainFrame,
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.156"), //$NON-NLS-1$
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.10"),  //$NON-NLS-1$
    							JOptionPane.YES_NO_CANCEL_OPTION))
    					{
    		    			case JOptionPane.YES_OPTION:
    		    					boolean saved = mainFrame.save(true);
    		    					if(saved) mainFrame.open(null, true);
    		    					break;
    		    			case JOptionPane.NO_OPTION:
    		    				mainFrame.open(null, true);
    								break;
    						case JOptionPane.CANCEL_OPTION:
    								break;				
    					}
    		    	else
    		    		mainFrame.open(null, true);
    			}catch(Exception ex)
    			{	    				
    				ex.printStackTrace(); 
    				ExceptionFrameDialog.showExceptionDialog(ex);
    			}
    			mainFrame.requestFocus();
    			return;
    		}      		
    		
    		if(label.equals(ACTION_VISIBLE_ALL_FIGURES))
    		{
    			drawPanel.getDraw().recenterFigures();
    			drawPanel.updateDraw(false);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_ZOOM_IN))
    		{
    			drawPanel.zoomIn();
    			drawPanel.getFrameParent().getToolbar().getZoomField().setValue(drawPanel.getZoom()*100);
    			mainFrame.getXScale().repaint();
    			mainFrame.getYScale().repaint();
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_ZOOM_OUT))
    		{
    			drawPanel.zoomOut();
    			drawPanel.getFrameParent().getToolbar().getZoomField().setValue(drawPanel.getZoom()*100);
    			mainFrame.getXScale().repaint();
    			mainFrame.getYScale().repaint();
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_ZOOM_DEFAULT))
    		{
    			drawPanel.zoomDefault();
    			drawPanel.getFrameParent().getToolbar().getZoomField().setValue(drawPanel.getZoom()*100);
    			mainFrame.getXScale().repaint();
    			mainFrame.getYScale().repaint();
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		
    		if(label.equals(LaTeXDrawResources.LABEL_REDO))
    		{
    			mainFrame.getUndoManager().redo();
    			drawPanel.updateDraw(true);
    			mainFrame.setSelection(!drawPanel.getDraw().getSelected().isEmpty());
    			mainFrame.updateUndoRedo();
    			mainFrame.updateFrameFields();
    			mainFrame.setExportAsMenu(drawPanel.getDraw().getNbFigures()>0);
				mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.158")); //$NON-NLS-1$
    			mainFrame.setIsModified(true);
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_UNDO))
    		{
    			mainFrame.getUndoManager().undo();
    			drawPanel.updateDraw(true);
    			mainFrame.setSelection(!drawPanel.getDraw().getSelected().isEmpty());
    			mainFrame.updateUndoRedo();
    			mainFrame.updateFrameFields();
    			mainFrame.setExportAsMenu(drawPanel.getDraw().getNbFigures()>0);
    			mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.159")); //$NON-NLS-1$
    			mainFrame.setIsModified(true);
    			mainFrame.requestFocus();
    			return;
    		}
    		
			if(label.equals(ACTION_CMD_SHORTCUTS))
			{
				mainFrame.showShortcutsFrame();
				return ;
			}
			
			
			if(label.equals(LaTeXDrawResources.LABEL_COPY))
    		{  
				drawPanel.copy();
				mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.146")); //$NON-NLS-1$
    			return;    			
    		}
			
			if(label.equals(LaTeXDrawResources.LABEL_PASTE))
    		{   			
				drawPanel.paste();
				mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.147")); //$NON-NLS-1$
    			return;    			
    		}
			
			if(label.equals(LaTeXDrawResources.LABEL_CUT))
    		{   			
				drawPanel.cut();
				mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.148")); //$NON-NLS-1$
    			return;    			
    		}
			
    		if(label.equals(LaTeXDrawResources.LABEL_DISPLAY_BORDERS))
    		{   			
    			mainFrame.displayBorders(ok);
    			mainFrame.requestFocus();
    			return;    			
    		}

    		if(label.equals(LaTeXDrawResources.LABEL_SELECT_FIGURE))
    		{
    			mainFrame.getLMenuBar().getMenuSelect().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageSelect().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_SELECT_FIGURE);
    			drawPanel.isSelection(true);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_LINE))
    		{
    			mainFrame.getLMenuBar().getMenuLine().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageLine().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_LINE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.0")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_JOINED_LINES))
    		{
    			mainFrame.getLMenuBar().getMenuJoinedLines().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageJoinedLines().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_JOINED_LINES);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.1")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_RECT))
    		{
    			mainFrame.getLMenuBar().getMenuRect().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageRect().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_RECT);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_POLY))
    		{
    			mainFrame.getLMenuBar().getMenuPoly().setSelected(ok);
    			mainFrame.getToolbar().getButtonImagePoly().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_POLY);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.1")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_SQUARE))
    		{
    			mainFrame.getLMenuBar().getMenuSquare().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageSquare().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_SQUARE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_TEXT))
    		{
    			mainFrame.getLMenuBar().getMenuText().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageText().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_TEXT);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.5")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_GRID))
    		{
    			mainFrame.getLMenuBar().getMenuGrid().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageGrid().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_GRID);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.6")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_AXES))
    		{
    			mainFrame.getLMenuBar().getMenuAxes().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageAxes().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_AXES);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.7")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_POINTS_AKIN))
    		{
    			mainFrame.getLMenuBar().getMenuPointsAkin().setSelected(ok);
    			mainFrame.getToolbar().getButtonImagePointsAkin().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_POINTS_AKIN);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.8")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_DOT))
    		{
    			mainFrame.getLMenuBar().getMenuDot().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageDot().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_DOT);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.9")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_RHOMBUS))
    		{
    			mainFrame.getLMenuBar().getMenuRhombus().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageRhombus().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_RHOMBUS);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_TRIANGLE))
    		{
    			mainFrame.getLMenuBar().getMenuTriangle().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageTriangle().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_TRIANGLE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		    		
    		if(label.equals(LaTeXDrawResources.LABEL_CIRCLE))
    		{
    			mainFrame.getLMenuBar().getMenuCircle().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageCircle().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_CIRCLE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		   		
    		if(label.equals(LaTeXDrawResources.LABEL_ELLIPSE))
    		{
    			mainFrame.getLMenuBar().getMenuEllipse().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageEllipse().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_ELLIPSE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		    		
    		if(label.equals(LaTeXDrawResources.LABEL_ARC))
    		{
    			mainFrame.getLMenuBar().getMenuArc().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageArc().setSelected(true);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_ARC);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_CHORD))
    		{
    			mainFrame.getLMenuBar().getMenuChord().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageChord().setSelected(true);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_CHORD);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_WEDGE))
    		{
    			mainFrame.getLMenuBar().getMenuWedge().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageWedge().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_WEDGE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.4")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_BEZIER_CURVE))
    		{
    			mainFrame.getLMenuBar().getMenuBezierCurve().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageBezierCurve().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_BEZIER_CURVE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.1")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_CLOSED_BEZIER_CURVE))
    		{
    			mainFrame.getLMenuBar().getMenuClosedBezierCurve().setSelected(ok);
    			mainFrame.getToolbar().getButtonImageClosedBezierCurve().setSelected(ok);
    			LaTeXDrawFrame.setCurrentChoice(LaTeXDrawResources.LABEL_CLOSED_BEZIER_CURVE);
    			drawPanel.isSelection(false);
    			mainFrame.setSelection(false);
    			drawPanel.setMenuSelectedPopupGeneral(label, true);
    			mainFrame.requestFocus();
    			mainFrame.setStatusBarText(LaTeXDrawLang.getString1_9("MenusListener.1")); //$NON-NLS-1$
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_DELETE))
    		{
    			if(drawPanel.deleteSelection()==0)
    			{
    				mainFrame.setExportAsMenu(false);
    				drawPanel.setIsModified(true);
    				mainFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.149")); //$NON-NLS-1$
    			}
    			mainFrame.setSelection(false);
    			mainFrame.requestFocus();
    			return;
    		}    	
			
    		if(label.equals(LaTeXDrawResources.LABEL_INSERT_PIX))
    		{
    			mainFrame.insertPicture();	
    			mainFrame.requestFocus();
    			return ;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_TEMPLATE_EXPORT))
    		{
    			mainFrame.exportAsTemplate();
    			mainFrame.requestFocus();
    			return ;
    		}
    		
    		
    		if(label.equals(LaTeXDrawResources.LABEL_NEW) || label.equals(LaTeXDrawResources.LABEL_NEW_WITH_SEL))
    		{
    			Draw selection = null;
    			
    			if(label.equals(LaTeXDrawResources.LABEL_NEW_WITH_SEL))
					try { selection = (Draw) mainFrame.getDrawPanel().getDraw().getSelected().clone(); }
    				catch(CloneNotSupportedException e1) { /**/ }
    			
    			mainFrame.newProject();
    			
				if(selection!=null && !selection.isEmpty())
				{
					for(Figure f : selection.getFigures())
						mainFrame.getDrawPanel().getDraw().addFigure(f, null);
					
					mainFrame.setIsModified(true);
					mainFrame.getDrawPanel().updateDraw(true);
					mainFrame.updateFrameFields();
				}
    			
    			mainFrame.requestFocus();
    			return;
    		}    		
    		
    		if(label.equals(LaTeXDrawResources.LABEL_BATCH_CONVERT))
    		{
    			mainFrame.batchConvertion();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_TRICKS))
    		{
    			mainFrame.exportAsPsTricks();
    			return;
    		}	
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_PDF_LATEX_CROP)) {
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_PDF_LATEX_CROP);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_PDF_LATEX)) {
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_PDF_LATEX);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_EPS_LATEX)) {
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_EPS_LATEX);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_BMP))
    		{
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_BMP);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_JPG))
    		{
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_JPG);
    			return;
    		}    
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_PNG))
    		{
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_PNG);
    			return;
    		}    
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_EPS))
    		{
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_EPS);
    			return;
    		}    
    		
    		if(label.equals(LaTeXDrawResources.LABEL_EXPORT_PPM))
    		{
    			mainFrame.exportAsPicture(LaTeXDrawResources.LABEL_EXPORT_PPM);
    			return;
    		}
    		
    		
    		if(label.equals(LaTeXDrawResources.LABEL_PRINT_CODE))
    		{
    			mainFrame.printCode();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_PRINT_DRAW))
    		{
    			mainFrame.printDraw();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_FIGURE_PROPERTIES))
    		{
    			Draw listSelected = drawPanel.getDraw().getSelected();
    			
    			if(listSelected.size()!=1)
    				return;

    			mainFrame.showParamFrame(listSelected.getFigureAt(0), false);
				return ;
    		}
    		
    		if(label.equals(LABEL_CHECK_UPDATE))
    		{
    			VersionChecker vc = new VersionChecker(mainFrame);
	     		vc.start();
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_QUIT))
    			mainFrame.onWindowClosing(); 		
    		
    		if(label.equals(LaTeXDrawResources.LABEL_AUTO_ADJUST_BORDERS))
    		{
    			drawPanel.setAutoAdjustement(ab.isSelected());
    			drawPanel.setIsModified(true);
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_DISPLAY_XSCALE))
    		{
    			mainFrame.displayXScale(ab.isSelected());
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_DISPLAY_YSCALE))
    		{
    			mainFrame.displayYScale(ab.isSelected());
    			return;
    		}
    		
    		if(label.equals(LaTeXDrawResources.LABEL_IMPORT_TEX))
    		{
    			try
    			{
    		    	if(drawPanel.isModified())
    		    		switch(JOptionPane.showConfirmDialog(mainFrame,
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.156"), //$NON-NLS-1$
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.110"),  //$NON-NLS-1$
    							JOptionPane.YES_NO_CANCEL_OPTION))
    					{
    		    			case JOptionPane.YES_OPTION:
    		    					boolean saved = mainFrame.save(true);
    		    					if(saved) mainFrame.importPSTricksFile();
    		    					break;
    		    			case JOptionPane.NO_OPTION:
    		    				mainFrame.importPSTricksFile();
    		    					break;
    						case JOptionPane.CANCEL_OPTION:
    								break;				
    					}
    		    	else
    		    		mainFrame.importPSTricksFile();
    			}catch(Exception ex)
    			{	    				
    				ex.printStackTrace(); 
    				ExceptionFrameDialog.showExceptionDialog(ex);
    			}
    			mainFrame.requestFocus();
    			return;
    		}
    		
    		return ;
    	}
	}
}
