/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "startup_dialog.h"

StartUpDialog::StartUpDialog()
{
    QLabel *label = new QLabel(tr("<font color=\"#FFFFFF\"><strong>Welcome to KontrolPack : </strong><a style='color: white;' href=\"http://www.kontrolpack.com/\">http://www.kontrolpack.com/</a></font>"), this);
    label->setOpenExternalLinks(true);
    settings = new QSettings("OpenNetwork", "KontrolPack", this);
    QString user_mode = settings->value("user/mode",
                                  "NONE").toString();
    if (user_mode.startsWith("END", Qt::CaseInsensitive)) {
        serverModeButton = new QPushButton(tr("Start : KontrolPack in Controlled Mode"));
        clientModeButton = new QPushButton(tr("Start : KontrolPack in Controller Mode"));
    } else {
        serverModeButton = new QPushButton(tr("KontrolPack in Controlled Mode (Server)"));
        clientModeButton = new QPushButton(tr("KontrolPack in Controller Mode (Client)"));
    }
    QLabel *imageLabel = new QLabel(this);
    imageLabel->setPixmap(QPixmap(":/images/startup-logo.png"));
    clientModeButton->setMinimumHeight(60);
    serverModeButton->setMinimumHeight(60);

    QLabel *explanationLabel = new QLabel(tr("<font color=\"#FFFFFF\"><strong>Access any remote computers securely.</strong></font>"), this);
    QGridLayout *layout = new QGridLayout;
    layout->addWidget(label, 0, 0, 1, 6);
    layout->addWidget(imageLabel, 1, 0, 1, 6);
    layout->addWidget(explanationLabel, 2, 0, 1, 6);
    layout->addWidget(serverModeButton, 3, 0, 1, 3);
    layout->addWidget(clientModeButton, 3, 3, 1, 3);
    setLayout(layout);
    QPalette palette = this->palette();
    palette.setBrush(QPalette::Base, Qt::transparent);
    gradientBackground.setColorAt(1.0, QColor(0, 0, 0));
    gradientBackground.setColorAt(0.0, QColor(0, 0, 0));
    gradientBackground.setCoordinateMode(QGradient::ObjectBoundingMode);
    QObject::connect(serverModeButton, SIGNAL(clicked()), this, SLOT(startServerMode()));
    QObject::connect(clientModeButton, SIGNAL(clicked()), this, SLOT(startClientMode()));

    setWindowIcon(QIcon(":/images/kontrolpack.png"));

#ifdef WIN32
#elif defined (linux)
    centerOnScreen();
#elif defined __APPLE__
#else
#endif
}

void StartUpDialog::mouseMoveEvent( QMouseEvent *e )
{
    move( e->globalPos() - clickPos);
}

void StartUpDialog::mousePressEvent( QMouseEvent *e )
{
    clickPos = e->pos() + QPoint(geometry().topLeft() - frameGeometry().topLeft());
    if (e->button() == Qt::RightButton)
    {
        QColor color = QColorDialog::getColor(QColor(3, 85, 144), this);
        gradientBackground.setColorAt(1.0, color);
        gradientBackground.setColorAt(0.0, color);
        repaint();
    }
}

void StartUpDialog::paintEvent(QPaintEvent *event)
{
    QPainter p(this);
    p.fillRect(event->rect(), Qt::transparent);
    p.setPen(Qt::NoPen);
    p.setBrush(gradientBackground);
    p.setOpacity(0.8);
#ifdef WIN32
    p.drawRoundedRect(rect(), 05, 05);
#elif defined (linux)
    p.drawRoundedRect(rect(), 0, 0);
#elif defined __APPLE__
    p.drawRoundedRect(rect(), 05, 05);
#else
    p.drawRoundedRect(rect(), 0, 0);
#endif
    p.end();
}

void StartUpDialog::startClientMode()
{
    this->close();
    settings->setValue("startup/mode", "CLIENT");
    ClientMainWindow *window = new ClientMainWindow(this);
    if (QtWin::isCompositionEnabled()) {
        QtWin::extendFrameIntoClientArea(window);
        window->setContentsMargins(0, 0, 0, 0);
    }
    window->show();
}

void StartUpDialog::centerOnScreen()
{
    QDesktopWidget screen;

    QRect screenGeom = screen.screenGeometry(this);

    int screenCenterX = screenGeom.center().x();
    int screenCenterY = screenGeom.center().y();

    move(screenCenterX - width () / 2,
         screenCenterY - height() / 2);
}

void StartUpDialog::startServerMode()
{
    this->close();
    settings->setValue("startup/mode", "SERVER");
    ServerMainWindow *window = new ServerMainWindow(this);
    if (QtWin::isCompositionEnabled()) {
        QtWin::extendFrameIntoClientArea(window);
        window->setContentsMargins(0, 0, 0, 0);
    }
    window->show();
}


