/* translation of file(s)
	"abs.k"
	"main.k"
	"parse.k"
	"error.k"
	"occur.k"
	"util.k"
	"gen.k"
	"gutil.k"
	"pat.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.13 (C) 1998-2008 Humboldt-Universitaet zu Berlin $
 */
#ifndef KC_TYPES_HEADER
#define KC_TYPES_HEADER

#define KIMWITUVERSIONMAJOR 2
#define KIMWITUVERSIONMINOR 3
#define KIMWITUVERSIONMICRO 13

#include <stdio.h>
#include <stddef.h>
#include <string>
#include <vector>

namespace kc {

#ifndef INTEGER
# define INTEGER int
#endif
#ifndef REAL
# define REAL double
#endif

#ifdef KC_UNICODE

#define kc_t(TEXT) L ## TEXT
typedef wchar_t kc_char_t;
typedef std::wstring kc_string_t;

#if defined(_WIN32) && ! defined (__GNUC__)
#define kc_strlen wcslen
#define kc_strcmp wcscmp
#define kc_strcasecmp _wcsicmp
#define kc_strcpy wcscpy
#define kc_strncpy wcsncpy
#define kc_tolower towlower
#define kc_print_integer(buf,number) swprintf(buf,kc_t("%d"),number)
#define kc_print_real(buf,number) swprintf(buf,kc_t("%g"),number)

// needed for printdot and csgio only
inline
std::string kc_to_cstring(const std::wstring& s) {
    USES_CONVERSION;
    return W2CA(s.c_str());
}

// needed for csgio only
inline
std::wstring kc_to_wstring(const std::string& s) {
    USES_CONVERSION;
    return A2CW(s.c_str());
}

#else // !defined(_WIN32) || defined(__GNUC__)
// if you want to use UNICODE on other platforms you have to write
// the following functions on your own
int kc_strlen(const kc_char_t*);
int kc_strcmp(const kc_char_t*,const kc_char_t*);
int kc_strcasecmp(const kc_char_t*,const kc_char_t*);
int kc_strcpy(kc_char_t*,const kc_char_t*);
int kc_strncpy(kc_char_t*,const kc_char_t*, int);
kc_char_t kc_tolower(kc_char_t);
int kc_print_integer(kc_char_t* buffer, INTEGER number );
int kc_print_real(kc_char_t* buffer, REAL number);

// needed for printdot and csgio only
std::string kc_to_cstring(const std::wstring& );
// needed for csgio only
std::wstring kc_to_wstring(const std::string& );

#endif

#else // !KC_UNICODE

#define kc_t(TEXT) TEXT  
typedef char kc_char_t;
typedef std::string kc_string_t;

#define kc_strlen strlen
#define kc_strcmp strcmp
#if defined(_WIN32) && ! defined (__GNUC__)
#define kc_strcasecmp _stricmp
#else
#define kc_strcasecmp strcasecmp
#endif
#define kc_strcpy strcpy
#define kc_strncpy strncpy
#define kc_tolower tolower  
#define kc_print_integer(buf,number) sprintf(buf,kc_t("%d"),number)
#define kc_print_real(buf,number) sprintf(buf,kc_t("%g"),number)
#endif
class uview_class;
typedef uview_class& uview;
typedef const uview_class& c_uview;

typedef class printer_functor_class& printer_functor;
typedef void (*printer_function)(const kc_char_t*, uview);

class rview_class;
typedef rview_class& rview;
typedef const rview_class& c_rview;

}

// Some compilers know __attribute__. Right now we test for the GNU compiler
// and Intel's icc (for ia32) and ecc (for ia64).
#if !defined __GNUC__ && !defined __ICC && !defined __ECC
# define __attribute__(x)
#endif

// Since all definitions are in namespace kc now, there is no need
// give them a kc_ prefix. Old code may still rely on the prefix, so these
// macros are generated for backwards compatibility
#ifdef KC_DEPRECATED
#define kc_PhylumInfo           phylum_info
#define kc_OperatorInfo         operator_info
#define kc_last_uview           last_uview
#define kc_uviews               uviews
#define kc_rviews               rviews
#define kc_ht_reuse             ht_clear
#define kc_ht_clear             ht_clear
#define kc_ht_assign            ht_assign
#define kc_ht_assigned          ht_assigned
#define kc_phylum_nocasestring phylum_nocasestring
#define kc_tag_nocasestring_NoCaseStr impl_nocasestring_NoCaseStr
#define kc_phylum_casestring phylum_casestring
#define kc_tag_casestring__Str impl_casestring__Str
#define kc_phylum_real phylum_real
#define kc_tag_real__Real impl_real__Real
#define kc_phylum_integer phylum_integer
#define kc_tag_integer__Int impl_integer__Int
#define kc_phylum_voidptr phylum_voidptr
#define kc_tag_voidptr__VoidPtr impl_voidptr__VoidPtr
#define kc_phylum_uniqID phylum_uniqID
#define kc_tag_uniqID_Str impl_uniqID_Str
#define kc_phylum_ID phylum_ID
#define kc_tag_ID_Id impl_ID_Id
#define kc_phylum_INT phylum_INT
#define kc_tag_INT_Int impl_INT_Int
#define kc_phylum_STRING phylum_STRING
#define kc_tag_STRING_String impl_STRING_String
#define kc_phylum_phylumdeclarationsroot phylum_phylumdeclarationsroot
#define kc_tag_phylumdeclarationsroot_PhylumDeclarations impl_phylumdeclarationsroot_PhylumDeclarations
#define kc_phylum_phylumdeclarations phylum_phylumdeclarations
#define kc_tag_phylumdeclarations_Nilphylumdeclarations impl_phylumdeclarations_Nilphylumdeclarations
#define kc_tag_phylumdeclarations_Consphylumdeclarations impl_phylumdeclarations_Consphylumdeclarations
#define kc_phylum_phylumnames phylum_phylumnames
#define kc_tag_phylumnames_Nilphylumnames impl_phylumnames_Nilphylumnames
#define kc_tag_phylumnames_Consphylumnames impl_phylumnames_Consphylumnames
#define kc_phylum_phylumdeclaration phylum_phylumdeclaration
#define kc_tag_phylumdeclaration_PhylumDeclaration impl_phylumdeclaration_PhylumDeclaration
#define kc_phylum_storageoption phylum_storageoption
#define kc_tag_storageoption_NoStorageOption impl_storageoption_NoStorageOption
#define kc_tag_storageoption_NegativeStorageOption impl_storageoption_NegativeStorageOption
#define kc_tag_storageoption_PositiveStorageOption impl_storageoption_PositiveStorageOption
#define kc_phylum_storageclasses phylum_storageclasses
#define kc_tag_storageclasses_Nilstorageclasses impl_storageclasses_Nilstorageclasses
#define kc_tag_storageclasses_Consstorageclasses impl_storageclasses_Consstorageclasses
#define kc_phylum_productionblock phylum_productionblock
#define kc_tag_productionblock_Emptyproductionblock impl_productionblock_Emptyproductionblock
#define kc_tag_productionblock_ListAlternatives impl_productionblock_ListAlternatives
#define kc_tag_productionblock_NonlistAlternatives impl_productionblock_NonlistAlternatives
#define kc_tag_productionblock_PredefinedAlternatives impl_productionblock_PredefinedAlternatives
#define kc_phylum_alternatives phylum_alternatives
#define kc_tag_alternatives_Nilalternatives impl_alternatives_Nilalternatives
#define kc_tag_alternatives_Consalternatives impl_alternatives_Consalternatives
#define kc_phylum_alternative phylum_alternative
#define kc_tag_alternative_Alternative impl_alternative_Alternative
#define kc_phylum_arguments phylum_arguments
#define kc_tag_arguments_Nilarguments impl_arguments_Nilarguments
#define kc_tag_arguments_Consarguments impl_arguments_Consarguments
#define kc_phylum_argument phylum_argument
#define kc_tag_argument_Argument impl_argument_Argument
#define kc_phylum_Ccode_option phylum_Ccode_option
#define kc_tag_Ccode_option_CcodeOption impl_Ccode_option_CcodeOption
#define kc_phylum_attributes phylum_attributes
#define kc_tag_attributes_Nilattributes impl_attributes_Nilattributes
#define kc_tag_attributes_Consattributes impl_attributes_Consattributes
#define kc_phylum_attribute phylum_attribute
#define kc_tag_attribute_Attribute impl_attribute_Attribute
#define kc_phylum_attribute_initialisation_option phylum_attribute_initialisation_option
#define kc_tag_attribute_initialisation_option_Noattribute_initialisation impl_attribute_initialisation_option_Noattribute_initialisation
#define kc_tag_attribute_initialisation_option_Yesattribute_initialisation impl_attribute_initialisation_option_Yesattribute_initialisation
#define kc_phylum_Cexpression phylum_Cexpression
#define kc_tag_Cexpression_NilCexpression impl_Cexpression_NilCexpression
#define kc_tag_Cexpression_ConsCexpression impl_Cexpression_ConsCexpression
#define kc_phylum_Cexpression_elem phylum_Cexpression_elem
#define kc_tag_Cexpression_elem_CExpressionPart impl_Cexpression_elem_CExpressionPart
#define kc_tag_Cexpression_elem_CExpressionDollarvar impl_Cexpression_elem_CExpressionDollarvar
#define kc_tag_Cexpression_elem_CExpressionNl impl_Cexpression_elem_CExpressionNl
#define kc_tag_Cexpression_elem_CExpressionDQ impl_Cexpression_elem_CExpressionDQ
#define kc_tag_Cexpression_elem_CExpressionSQ impl_Cexpression_elem_CExpressionSQ
#define kc_tag_Cexpression_elem_CExpressionPack impl_Cexpression_elem_CExpressionPack
#define kc_tag_Cexpression_elem_CExpressionArray impl_Cexpression_elem_CExpressionArray
#define kc_phylum_CexpressionDQ phylum_CexpressionDQ
#define kc_tag_CexpressionDQ_NilCexpressionDQ impl_CexpressionDQ_NilCexpressionDQ
#define kc_tag_CexpressionDQ_ConsCexpressionDQ impl_CexpressionDQ_ConsCexpressionDQ
#define kc_phylum_CexpressionDQ_elem phylum_CexpressionDQ_elem
#define kc_tag_CexpressionDQ_elem_CExpressionDQPart impl_CexpressionDQ_elem_CExpressionDQPart
#define kc_tag_CexpressionDQ_elem_CExpressionDQNl impl_CexpressionDQ_elem_CExpressionDQNl
#define kc_phylum_CexpressionSQ phylum_CexpressionSQ
#define kc_tag_CexpressionSQ_NilCexpressionSQ impl_CexpressionSQ_NilCexpressionSQ
#define kc_tag_CexpressionSQ_ConsCexpressionSQ impl_CexpressionSQ_ConsCexpressionSQ
#define kc_phylum_CexpressionSQ_elem phylum_CexpressionSQ_elem
#define kc_tag_CexpressionSQ_elem_CExpressionSQPart impl_CexpressionSQ_elem_CExpressionSQPart
#define kc_tag_CexpressionSQ_elem_CExpressionSQNl impl_CexpressionSQ_elem_CExpressionSQNl
#define kc_phylum_idCexpressions phylum_idCexpressions
#define kc_tag_idCexpressions_NilidCexpressions impl_idCexpressions_NilidCexpressions
#define kc_tag_idCexpressions_ConsidCexpressions impl_idCexpressions_ConsidCexpressions
#define kc_phylum_idCexpression phylum_idCexpression
#define kc_tag_idCexpression_IdCexpression impl_idCexpression_IdCexpression
#define kc_phylum_Ctexts phylum_Ctexts
#define kc_tag_Ctexts_NilCtexts impl_Ctexts_NilCtexts
#define kc_tag_Ctexts_ConsCtexts impl_Ctexts_ConsCtexts
#define kc_phylum_includefiles phylum_includefiles
#define kc_tag_includefiles_Nilincludefiles impl_includefiles_Nilincludefiles
#define kc_tag_includefiles_Consincludefiles impl_includefiles_Consincludefiles
#define kc_phylum_includefile phylum_includefile
#define kc_tag_includefile_IncludeFile impl_includefile_IncludeFile
#define kc_phylum_includedeclarations phylum_includedeclarations
#define kc_tag_includedeclarations_Nilincludedeclarations impl_includedeclarations_Nilincludedeclarations
#define kc_tag_includedeclarations_Consincludedeclarations impl_includedeclarations_Consincludedeclarations
#define kc_phylum_includedeclaration phylum_includedeclaration
#define kc_tag_includedeclaration_IncludeDeclaration impl_includedeclaration_IncludeDeclaration
#define kc_phylum_rwdeclarations phylum_rwdeclarations
#define kc_tag_rwdeclarations_Nilrwdeclarations impl_rwdeclarations_Nilrwdeclarations
#define kc_tag_rwdeclarations_Consrwdeclarations impl_rwdeclarations_Consrwdeclarations
#define kc_phylum_rwdeclaration phylum_rwdeclaration
#define kc_tag_rwdeclaration_RwDeclaration impl_rwdeclaration_RwDeclaration
#define kc_phylum_rewriteclauses phylum_rewriteclauses
#define kc_tag_rewriteclauses_Nilrewriteclauses impl_rewriteclauses_Nilrewriteclauses
#define kc_tag_rewriteclauses_Consrewriteclauses impl_rewriteclauses_Consrewriteclauses
#define kc_phylum_rewriteclause phylum_rewriteclause
#define kc_tag_rewriteclause_RewriteClause impl_rewriteclause_RewriteClause
#define kc_phylum_patternchains phylum_patternchains
#define kc_tag_patternchains_Nilpatternchains impl_patternchains_Nilpatternchains
#define kc_tag_patternchains_Conspatternchains impl_patternchains_Conspatternchains
#define kc_phylum_patternchain phylum_patternchain
#define kc_tag_patternchain_Nilpatternchain impl_patternchain_Nilpatternchain
#define kc_tag_patternchain_Conspatternchain impl_patternchain_Conspatternchain
#define kc_phylum_outmostpatterns phylum_outmostpatterns
#define kc_tag_outmostpatterns_Niloutmostpatterns impl_outmostpatterns_Niloutmostpatterns
#define kc_tag_outmostpatterns_Consoutmostpatterns impl_outmostpatterns_Consoutmostpatterns
#define kc_phylum_patternchainitem phylum_patternchainitem
#define kc_tag_patternchainitem_PatternchainitemOutmost impl_patternchainitem_PatternchainitemOutmost
#define kc_tag_patternchainitem_PatternchainitemGroup impl_patternchainitem_PatternchainitemGroup
#define kc_tag_patternchainitem_PatternchainitemDollarid impl_patternchainitem_PatternchainitemDollarid
#define kc_phylum_outmostpattern phylum_outmostpattern
#define kc_tag_outmostpattern_OPOperatorWildcard impl_outmostpattern_OPOperatorWildcard
#define kc_tag_outmostpattern_OPOperator impl_outmostpattern_OPOperator
#define kc_tag_outmostpattern_OPNonLeafVariable impl_outmostpattern_OPNonLeafVariable
#define kc_tag_outmostpattern_OPWildcard impl_outmostpattern_OPWildcard
#define kc_tag_outmostpattern_OPDefault impl_outmostpattern_OPDefault
#define kc_phylum_pattern phylum_pattern
#define kc_tag_pattern_PVariable impl_pattern_PVariable
#define kc_tag_pattern_POperator impl_pattern_POperator
#define kc_tag_pattern_PNonLeafVariable impl_pattern_PNonLeafVariable
#define kc_tag_pattern_PWildcard impl_pattern_PWildcard
#define kc_tag_pattern_PStringLiteral impl_pattern_PStringLiteral
#define kc_tag_pattern_PIntLiteral impl_pattern_PIntLiteral
#define kc_phylum_patterns phylum_patterns
#define kc_tag_patterns_Nilpatterns impl_patterns_Nilpatterns
#define kc_tag_patterns_Conspatterns impl_patterns_Conspatterns
#define kc_phylum_term phylum_term
#define kc_tag_term_TVariable impl_term_TVariable
#define kc_tag_term_TOperator impl_term_TOperator
#define kc_tag_term_TMethod impl_term_TMethod
#define kc_tag_term_TMethodDot impl_term_TMethodDot
#define kc_tag_term_TMemberVar impl_term_TMemberVar
#define kc_tag_term_TMemberVarDot impl_term_TMemberVarDot
#define kc_tag_term_TCTerm impl_term_TCTerm
#define kc_tag_term_TStringLiteral impl_term_TStringLiteral
#define kc_tag_term_TIntLiteral impl_term_TIntLiteral
#define kc_phylum_terms phylum_terms
#define kc_tag_terms_Nilterms impl_terms_Nilterms
#define kc_tag_terms_Consterms impl_terms_Consterms
#define kc_phylum_fnfiles phylum_fnfiles
#define kc_tag_fnfiles_Nilfnfiles impl_fnfiles_Nilfnfiles
#define kc_tag_fnfiles_Consfnfiles impl_fnfiles_Consfnfiles
#define kc_phylum_fnfile phylum_fnfile
#define kc_tag_fnfile_FnFile impl_fnfile_FnFile
#define kc_phylum_fndeclarations phylum_fndeclarations
#define kc_tag_fndeclarations_Nilfndeclarations impl_fndeclarations_Nilfndeclarations
#define kc_tag_fndeclarations_Consfndeclarations impl_fndeclarations_Consfndeclarations
#define kc_phylum_fndeclaration phylum_fndeclaration
#define kc_tag_fndeclaration_FnAcDeclaration impl_fndeclaration_FnAcDeclaration
#define kc_tag_fndeclaration_AcMemberDeclaration impl_fndeclaration_AcMemberDeclaration
#define kc_phylum_fnclass phylum_fnclass
#define kc_tag_fnclass_GlobalFn impl_fnclass_GlobalFn
#define kc_tag_fnclass_StaticFn impl_fnclass_StaticFn
#define kc_tag_fnclass_MemberFn impl_fnclass_MemberFn
#define kc_tag_fnclass_ConstructorFn impl_fnclass_ConstructorFn
#define kc_tag_fnclass_DestructorFn impl_fnclass_DestructorFn
#define kc_tag_fnclass_ConvOperatorFn impl_fnclass_ConvOperatorFn
#define kc_phylum_Ctext phylum_Ctext
#define kc_tag_Ctext_NilCtext impl_Ctext_NilCtext
#define kc_tag_Ctext_ConsCtext impl_Ctext_ConsCtext
#define kc_phylum_Ctext_elem phylum_Ctext_elem
#define kc_tag_Ctext_elem_CTextLine impl_Ctext_elem_CTextLine
#define kc_tag_Ctext_elem_CTextDollarVar impl_Ctext_elem_CTextDollarVar
#define kc_tag_Ctext_elem_CTextNl impl_Ctext_elem_CTextNl
#define kc_tag_Ctext_elem_CTextCexpressionDQ impl_Ctext_elem_CTextCexpressionDQ
#define kc_tag_Ctext_elem_CTextCexpressionSQ impl_Ctext_elem_CTextCexpressionSQ
#define kc_tag_Ctext_elem_CTextCbody impl_Ctext_elem_CTextCbody
#define kc_tag_Ctext_elem_CTextForeachexpression impl_Ctext_elem_CTextForeachexpression
#define kc_tag_Ctext_elem_CTextWithexpression impl_Ctext_elem_CTextWithexpression
#define kc_phylum_foreach_after phylum_foreach_after
#define kc_tag_foreach_after_NoForeachAfter impl_foreach_after_NoForeachAfter
#define kc_tag_foreach_after_ForeachAfter impl_foreach_after_ForeachAfter
#define kc_phylum_contextinfo phylum_contextinfo
#define kc_tag_contextinfo_InForeachContext impl_contextinfo_InForeachContext
#define kc_tag_contextinfo_NotInForeachContext impl_contextinfo_NotInForeachContext
#define kc_phylum_withexpressions phylum_withexpressions
#define kc_tag_withexpressions_Nilwithexpressions impl_withexpressions_Nilwithexpressions
#define kc_tag_withexpressions_Conswithexpressions impl_withexpressions_Conswithexpressions
#define kc_phylum_withexpression phylum_withexpression
#define kc_tag_withexpression_WEVariable impl_withexpression_WEVariable
#define kc_tag_withexpression_WECexpression impl_withexpression_WECexpression
#define kc_phylum_withcases phylum_withcases
#define kc_tag_withcases_Nilwithcases impl_withcases_Nilwithcases
#define kc_tag_withcases_Conswithcases impl_withcases_Conswithcases
#define kc_phylum_withcase phylum_withcase
#define kc_tag_withcase_Withcase impl_withcase_Withcase
#define kc_phylum_unparsedeclarations phylum_unparsedeclarations
#define kc_tag_unparsedeclarations_Nilunparsedeclarations impl_unparsedeclarations_Nilunparsedeclarations
#define kc_tag_unparsedeclarations_Consunparsedeclarations impl_unparsedeclarations_Consunparsedeclarations
#define kc_phylum_unparsedeclaration phylum_unparsedeclaration
#define kc_tag_unparsedeclaration_UnparseDeclaration impl_unparsedeclaration_UnparseDeclaration
#define kc_phylum_unparseclauses phylum_unparseclauses
#define kc_tag_unparseclauses_Nilunparseclauses impl_unparseclauses_Nilunparseclauses
#define kc_tag_unparseclauses_Consunparseclauses impl_unparseclauses_Consunparseclauses
#define kc_phylum_unparseclause phylum_unparseclause
#define kc_tag_unparseclause_UnparseClause impl_unparseclause_UnparseClause
#define kc_phylum_viewnames phylum_viewnames
#define kc_tag_viewnames_Nilviewnames impl_viewnames_Nilviewnames
#define kc_tag_viewnames_Consviewnames impl_viewnames_Consviewnames
#define kc_phylum_unparseitems phylum_unparseitems
#define kc_tag_unparseitems_Nilunparseitems impl_unparseitems_Nilunparseitems
#define kc_tag_unparseitems_Consunparseitems impl_unparseitems_Consunparseitems
#define kc_phylum_unparseitem phylum_unparseitem
#define kc_tag_unparseitem_UnpStr impl_unparseitem_UnpStr
#define kc_tag_unparseitem_UnpSubexpr impl_unparseitem_UnpSubexpr
#define kc_tag_unparseitem_UnpCtext impl_unparseitem_UnpCtext
#define kc_tag_unparseitem_UnpBody impl_unparseitem_UnpBody
#define kc_tag_unparseitem_UViewVarDecl impl_unparseitem_UViewVarDecl
#define kc_phylum_unpsubterm phylum_unpsubterm
#define kc_tag_unpsubterm_UnpSubTerm impl_unpsubterm_UnpSubTerm
#define kc_tag_unpsubterm_UnpDollarvarTerm impl_unpsubterm_UnpDollarvarTerm
#define kc_tag_unpsubterm_UnpSubAttr impl_unpsubterm_UnpSubAttr
#define kc_tag_unpsubterm_UnpDollarvarAttr impl_unpsubterm_UnpDollarvarAttr
#define kc_tag_unpsubterm_UnpCastedVariable impl_unpsubterm_UnpCastedVariable
#define kc_phylum_unpattributes phylum_unpattributes
#define kc_tag_unpattributes_Nilunpattributes impl_unpattributes_Nilunpattributes
#define kc_tag_unpattributes_Consunpattributes impl_unpattributes_Consunpattributes
#define kc_phylum_viewnameoption phylum_viewnameoption
#define kc_tag_viewnameoption_NoViewname impl_viewnameoption_NoViewname
#define kc_tag_viewnameoption_YesViewname impl_viewnameoption_YesViewname
#define kc_phylum_languageoption phylum_languageoption
#define kc_tag_languageoption_NoLanguagename impl_languageoption_NoLanguagename
#define kc_tag_languageoption_LanguageList impl_languageoption_LanguageList
#define kc_phylum_languagenames phylum_languagenames
#define kc_tag_languagenames_Nillanguagenames impl_languagenames_Nillanguagenames
#define kc_tag_languagenames_Conslanguagenames impl_languagenames_Conslanguagenames
#define kc_phylum_fileline phylum_fileline
#define kc_tag_fileline_FileLine impl_fileline_FileLine
#define kc_tag_fileline_NoFileLine impl_fileline_NoFileLine
#define kc_tag_fileline_PosNoFileLine impl_fileline_PosNoFileLine
#define kc_phylum_scopetypefilelinestack phylum_scopetypefilelinestack
#define kc_tag_scopetypefilelinestack_Nilscopetypefilelinestack impl_scopetypefilelinestack_Nilscopetypefilelinestack
#define kc_tag_scopetypefilelinestack_Consscopetypefilelinestack impl_scopetypefilelinestack_Consscopetypefilelinestack
#define kc_phylum_scopetypefileline phylum_scopetypefileline
#define kc_tag_scopetypefileline_ScopeTypeFileLine impl_scopetypefileline_ScopeTypeFileLine
#define kc_phylum_IDtype phylum_IDtype
#define kc_tag_IDtype_ITUnknown impl_IDtype_ITUnknown
#define kc_tag_IDtype_ITPredefinedPhylum impl_IDtype_ITPredefinedPhylum
#define kc_tag_IDtype_ITUserPhylum impl_IDtype_ITUserPhylum
#define kc_tag_IDtype_ITPredefinedOperator impl_IDtype_ITPredefinedOperator
#define kc_tag_IDtype_ITUserOperator impl_IDtype_ITUserOperator
#define kc_tag_IDtype_ITPredefinedStorageClass impl_IDtype_ITPredefinedStorageClass
#define kc_tag_IDtype_ITStorageClass impl_IDtype_ITStorageClass
#define kc_tag_IDtype_ITPredefinedUView impl_IDtype_ITPredefinedUView
#define kc_tag_IDtype_ITUserUView impl_IDtype_ITUserUView
#define kc_tag_IDtype_ITUViewVar impl_IDtype_ITUViewVar
#define kc_tag_IDtype_ITPredefinedRView impl_IDtype_ITPredefinedRView
#define kc_tag_IDtype_ITUserRView impl_IDtype_ITUserRView
#define kc_tag_IDtype_ITUserFunction impl_IDtype_ITUserFunction
#define kc_tag_IDtype_ITPatternVariable impl_IDtype_ITPatternVariable
#define kc_tag_IDtype_ITLanguageName impl_IDtype_ITLanguageName
#define kc_phylum_operators phylum_operators
#define kc_tag_operators_Niloperators impl_operators_Niloperators
#define kc_tag_operators_Consoperators impl_operators_Consoperators
#define kc_phylum_phyla phylum_phyla
#define kc_tag_phyla_Nilphyla impl_phyla_Nilphyla
#define kc_tag_phyla_Consphyla impl_phyla_Consphyla
#define kc_phylum_variables phylum_variables
#define kc_tag_variables_Nilvariables impl_variables_Nilvariables
#define kc_tag_variables_Consvariables impl_variables_Consvariables
#define kc_phylum_dollarvarstatus phylum_dollarvarstatus
#define kc_tag_dollarvarstatus_DVAllowed impl_dollarvarstatus_DVAllowed
#define kc_tag_dollarvarstatus_DVDisallowed impl_dollarvarstatus_DVDisallowed
#define kc_phylum_tribool phylum_tribool
#define kc_tag_tribool_Equal impl_tribool_Equal
#define kc_tag_tribool_Smaller impl_tribool_Smaller
#define kc_tag_tribool_Bigger impl_tribool_Bigger
#define kc_phylum_patternrepresentations phylum_patternrepresentations
#define kc_tag_patternrepresentations_Nilpatternrepresentations impl_patternrepresentations_Nilpatternrepresentations
#define kc_tag_patternrepresentations_Conspatternrepresentations impl_patternrepresentations_Conspatternrepresentations
#define kc_phylum_patternrepresentation phylum_patternrepresentation
#define kc_tag_patternrepresentation_Nilpatternrepresentation impl_patternrepresentation_Nilpatternrepresentation
#define kc_tag_patternrepresentation_Conspatternrepresentation impl_patternrepresentation_Conspatternrepresentation
#define kc_phylum_elem_patternrepresentation phylum_elem_patternrepresentation
#define kc_tag_elem_patternrepresentation_PRBinding impl_elem_patternrepresentation_PRBinding
#define kc_tag_elem_patternrepresentation_PRVarPredicate impl_elem_patternrepresentation_PRVarPredicate
#define kc_tag_elem_patternrepresentation_PROperPredicate impl_elem_patternrepresentation_PROperPredicate
#define kc_tag_elem_patternrepresentation_PRUserPredicate impl_elem_patternrepresentation_PRUserPredicate
#define kc_tag_elem_patternrepresentation_PRNonLeafBinding impl_elem_patternrepresentation_PRNonLeafBinding
#define kc_tag_elem_patternrepresentation_PRWildcard impl_elem_patternrepresentation_PRWildcard
#define kc_tag_elem_patternrepresentation_PRDefault impl_elem_patternrepresentation_PRDefault
#define kc_tag_elem_patternrepresentation_PRStringLiteral impl_elem_patternrepresentation_PRStringLiteral
#define kc_tag_elem_patternrepresentation_PRIntLiteral impl_elem_patternrepresentation_PRIntLiteral
#define kc_phylum_path phylum_path
#define kc_tag_path_Nilpath impl_path_Nilpath
#define kc_tag_path_Conspath impl_path_Conspath
#define kc_phylum_paths phylum_paths
#define kc_tag_paths_Nilpaths impl_paths_Nilpaths
#define kc_tag_paths_Conspaths impl_paths_Conspaths
#define kc_phylum_argsnumbers phylum_argsnumbers
#define kc_tag_argsnumbers_Nilargsnumbers impl_argsnumbers_Nilargsnumbers
#define kc_tag_argsnumbers_Consargsnumbers impl_argsnumbers_Consargsnumbers
#define kc_phylum_rewriterulesinfo phylum_rewriterulesinfo
#define kc_tag_rewriterulesinfo_Nilrewriterulesinfo impl_rewriterulesinfo_Nilrewriterulesinfo
#define kc_tag_rewriterulesinfo_Consrewriterulesinfo impl_rewriterulesinfo_Consrewriterulesinfo
#define kc_phylum_rewriteruleinfo phylum_rewriteruleinfo
#define kc_tag_rewriteruleinfo_Rewriteruleinfo impl_rewriteruleinfo_Rewriteruleinfo
#define kc_phylum_withcasesinfo phylum_withcasesinfo
#define kc_tag_withcasesinfo_Nilwithcasesinfo impl_withcasesinfo_Nilwithcasesinfo
#define kc_tag_withcasesinfo_Conswithcasesinfo impl_withcasesinfo_Conswithcasesinfo
#define kc_phylum_withcaseinfo phylum_withcaseinfo
#define kc_tag_withcaseinfo_Withcaseinfo impl_withcaseinfo_Withcaseinfo
#define kc_phylum_rewriteviewsinfo phylum_rewriteviewsinfo
#define kc_tag_rewriteviewsinfo_Nilrewriteviewsinfo impl_rewriteviewsinfo_Nilrewriteviewsinfo
#define kc_tag_rewriteviewsinfo_Consrewriteviewsinfo impl_rewriteviewsinfo_Consrewriteviewsinfo
#define kc_phylum_rewriteviewinfo phylum_rewriteviewinfo
#define kc_tag_rewriteviewinfo_Rewriteviewinfo impl_rewriteviewinfo_Rewriteviewinfo
#define kc_phylum_unparseviewsinfo phylum_unparseviewsinfo
#define kc_tag_unparseviewsinfo_Nilunparseviewsinfo impl_unparseviewsinfo_Nilunparseviewsinfo
#define kc_tag_unparseviewsinfo_Consunparseviewsinfo impl_unparseviewsinfo_Consunparseviewsinfo
#define kc_phylum_unparseviewinfo phylum_unparseviewinfo
#define kc_tag_unparseviewinfo_Unparseviewinfo impl_unparseviewinfo_Unparseviewinfo
#define kc_phylum_unparsedeclsinfo phylum_unparsedeclsinfo
#define kc_tag_unparsedeclsinfo_Nilunparsedeclsinfo impl_unparsedeclsinfo_Nilunparsedeclsinfo
#define kc_tag_unparsedeclsinfo_Consunparsedeclsinfo impl_unparsedeclsinfo_Consunparsedeclsinfo
#define kc_phylum_unparsedeclinfo phylum_unparsedeclinfo
#define kc_tag_unparsedeclinfo_Unparsedeclinfo impl_unparsedeclinfo_Unparsedeclinfo
#define kc_phylum_ac_declaration phylum_ac_declaration
#define kc_tag_ac_declaration_AcDeclaration impl_ac_declaration_AcDeclaration
#define kc_phylum_ac_declaration_list phylum_ac_declaration_list
#define kc_tag_ac_declaration_list_Nilac_declaration_list impl_ac_declaration_list_Nilac_declaration_list
#define kc_tag_ac_declaration_list_Consac_declaration_list impl_ac_declaration_list_Consac_declaration_list
#define kc_phylum_ac_declaration_specifiers phylum_ac_declaration_specifiers
#define kc_tag_ac_declaration_specifiers_Nilac_declaration_specifiers impl_ac_declaration_specifiers_Nilac_declaration_specifiers
#define kc_tag_ac_declaration_specifiers_Consac_declaration_specifiers impl_ac_declaration_specifiers_Consac_declaration_specifiers
#define kc_phylum_ac_declaration_specifier phylum_ac_declaration_specifier
#define kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec impl_ac_declaration_specifier_AcDeclSpecStorageSpec
#define kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec impl_ac_declaration_specifier_AcDeclSpecTypeSpec
#define kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual impl_ac_declaration_specifier_AcDeclSpecTypeQual
#define kc_phylum_ac_storage_class_specifier phylum_ac_storage_class_specifier
#define kc_tag_ac_storage_class_specifier_AcAuto impl_ac_storage_class_specifier_AcAuto
#define kc_tag_ac_storage_class_specifier_AcRegister impl_ac_storage_class_specifier_AcRegister
#define kc_tag_ac_storage_class_specifier_AcStatic impl_ac_storage_class_specifier_AcStatic
#define kc_tag_ac_storage_class_specifier_AcExtern impl_ac_storage_class_specifier_AcExtern
#define kc_tag_ac_storage_class_specifier_AcTypedef impl_ac_storage_class_specifier_AcTypedef
#define kc_tag_ac_storage_class_specifier_AcVirtual impl_ac_storage_class_specifier_AcVirtual
#define kc_phylum_ac_type_specifier phylum_ac_type_specifier
#define kc_tag_ac_type_specifier_AcTypeSpec impl_ac_type_specifier_AcTypeSpec
#define kc_phylum_ac_type_qualifier phylum_ac_type_qualifier
#define kc_tag_ac_type_qualifier_AcConst impl_ac_type_qualifier_AcConst
#define kc_tag_ac_type_qualifier_AcVolatile impl_ac_type_qualifier_AcVolatile
#define kc_tag_ac_type_qualifier_AcUnsigned impl_ac_type_qualifier_AcUnsigned
#define kc_tag_ac_type_qualifier_AcNoQualifier impl_ac_type_qualifier_AcNoQualifier
#define kc_phylum_ac_init_declarator_list phylum_ac_init_declarator_list
#define kc_tag_ac_init_declarator_list_Nilac_init_declarator_list impl_ac_init_declarator_list_Nilac_init_declarator_list
#define kc_tag_ac_init_declarator_list_Consac_init_declarator_list impl_ac_init_declarator_list_Consac_init_declarator_list
#define kc_phylum_ac_init_declarator phylum_ac_init_declarator
#define kc_tag_ac_init_declarator_AcInitDecl impl_ac_init_declarator_AcInitDecl
#define kc_phylum_ac_declarator phylum_ac_declarator
#define kc_tag_ac_declarator_AcDeclarator impl_ac_declarator_AcDeclarator
#define kc_phylum_ac_direct_declarator phylum_ac_direct_declarator
#define kc_tag_ac_direct_declarator_AcDirectDeclId impl_ac_direct_declarator_AcDirectDeclId
#define kc_tag_ac_direct_declarator_AcDirectDeclPack impl_ac_direct_declarator_AcDirectDeclPack
#define kc_tag_ac_direct_declarator_AcDirectDeclArray impl_ac_direct_declarator_AcDirectDeclArray
#define kc_tag_ac_direct_declarator_AcDirectDeclProto impl_ac_direct_declarator_AcDirectDeclProto
#define kc_tag_ac_direct_declarator_AcQualifiedDeclProto impl_ac_direct_declarator_AcQualifiedDeclProto
#define kc_tag_ac_direct_declarator_AcMemberDecl impl_ac_direct_declarator_AcMemberDecl
#define kc_tag_ac_direct_declarator_AcConvOperatorDecl impl_ac_direct_declarator_AcConvOperatorDecl
#define kc_tag_ac_direct_declarator_AcOperatorDeclId impl_ac_direct_declarator_AcOperatorDeclId
#define kc_phylum_ac_pointer_option phylum_ac_pointer_option
#define kc_tag_ac_pointer_option_Nopointer impl_ac_pointer_option_Nopointer
#define kc_tag_ac_pointer_option_Yespointer impl_ac_pointer_option_Yespointer
#define kc_phylum_ac_pointer phylum_ac_pointer
#define kc_tag_ac_pointer_AcPointerNil impl_ac_pointer_AcPointerNil
#define kc_tag_ac_pointer_AcPointerCons impl_ac_pointer_AcPointerCons
#define kc_phylum_ac_ref_option phylum_ac_ref_option
#define kc_tag_ac_ref_option_AcNoRef impl_ac_ref_option_AcNoRef
#define kc_tag_ac_ref_option_AcRef impl_ac_ref_option_AcRef
#define kc_phylum_ac_operator_name phylum_ac_operator_name
#define kc_tag_ac_operator_name_AcOperatorName impl_ac_operator_name_AcOperatorName
#define kc_phylum_ac_class_qualifier_help_list phylum_ac_class_qualifier_help_list
#define kc_tag_ac_class_qualifier_help_list_Nilac_class_qualifier_help_list impl_ac_class_qualifier_help_list_Nilac_class_qualifier_help_list
#define kc_tag_ac_class_qualifier_help_list_Consac_class_qualifier_help_list impl_ac_class_qualifier_help_list_Consac_class_qualifier_help_list
#define kc_phylum_ac_class_qualifier_list phylum_ac_class_qualifier_list
#define kc_tag_ac_class_qualifier_list_Nilac_class_qualifier_list impl_ac_class_qualifier_list_Nilac_class_qualifier_list
#define kc_tag_ac_class_qualifier_list_Consac_class_qualifier_list impl_ac_class_qualifier_list_Consac_class_qualifier_list
#define kc_phylum_ac_type_qualifier_list phylum_ac_type_qualifier_list
#define kc_tag_ac_type_qualifier_list_Nilac_type_qualifier_list impl_ac_type_qualifier_list_Nilac_type_qualifier_list
#define kc_tag_ac_type_qualifier_list_Consac_type_qualifier_list impl_ac_type_qualifier_list_Consac_type_qualifier_list
#define kc_phylum_ac_parameter_type_list phylum_ac_parameter_type_list
#define kc_tag_ac_parameter_type_list_AcParList impl_ac_parameter_type_list_AcParList
#define kc_tag_ac_parameter_type_list_AcParList3Dot impl_ac_parameter_type_list_AcParList3Dot
#define kc_phylum_ac_parameter_list phylum_ac_parameter_list
#define kc_tag_ac_parameter_list_Nilac_parameter_list impl_ac_parameter_list_Nilac_parameter_list
#define kc_tag_ac_parameter_list_Consac_parameter_list impl_ac_parameter_list_Consac_parameter_list
#define kc_phylum_ac_parameter_declaration phylum_ac_parameter_declaration
#define kc_tag_ac_parameter_declaration_AcParDeclDecl impl_ac_parameter_declaration_AcParDeclDecl
#define kc_tag_ac_parameter_declaration_AcParDeclAbsdecl impl_ac_parameter_declaration_AcParDeclAbsdecl
#define kc_phylum_ac_identifier_list phylum_ac_identifier_list
#define kc_tag_ac_identifier_list_Nilac_identifier_list impl_ac_identifier_list_Nilac_identifier_list
#define kc_tag_ac_identifier_list_Consac_identifier_list impl_ac_identifier_list_Consac_identifier_list
#define kc_phylum_ac_abstract_declarator phylum_ac_abstract_declarator
#define kc_tag_ac_abstract_declarator_AcAbsdeclPointer impl_ac_abstract_declarator_AcAbsdeclPointer
#define kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl impl_ac_abstract_declarator_AcAbsdeclDirdecl
#define kc_phylum_ac_direct_abstract_declarator_option phylum_ac_direct_abstract_declarator_option
#define kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator impl_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator
#define kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator impl_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator
#define kc_phylum_ac_direct_abstract_declarator phylum_ac_direct_abstract_declarator
#define kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack impl_ac_direct_abstract_declarator_AcDirAbsdeclPack
#define kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray impl_ac_direct_abstract_declarator_AcDirAbsdeclArray
#define kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn impl_ac_direct_abstract_declarator_AcDirAbsdeclFn
#define kc_phylum_ac_constant_expression_option phylum_ac_constant_expression_option
#define kc_tag_ac_constant_expression_option_Yesac_constant_expression impl_ac_constant_expression_option_Yesac_constant_expression
#define kc_tag_ac_constant_expression_option_Noac_constant_expression impl_ac_constant_expression_option_Noac_constant_expression
#define kc_phylum_ac_constant_expression phylum_ac_constant_expression
#define kc_tag_ac_constant_expression_AcConstExpr impl_ac_constant_expression_AcConstExpr
#define kc_phylum_ac_constant_expression_list phylum_ac_constant_expression_list
#define kc_tag_ac_constant_expression_list_Nilac_constant_expression_list impl_ac_constant_expression_list_Nilac_constant_expression_list
#define kc_tag_ac_constant_expression_list_Consac_constant_expression_list impl_ac_constant_expression_list_Consac_constant_expression_list
#define kc_phylum_ac_opt_base_init_list phylum_ac_opt_base_init_list
#define kc_tag_ac_opt_base_init_list_AcNoBaseInit impl_ac_opt_base_init_list_AcNoBaseInit
#define kc_tag_ac_opt_base_init_list_AcYesBaseInit impl_ac_opt_base_init_list_AcYesBaseInit
#define kc_phylum_ac_base_init_list phylum_ac_base_init_list
#define kc_tag_ac_base_init_list_Nilac_base_init_list impl_ac_base_init_list_Nilac_base_init_list
#define kc_tag_ac_base_init_list_Consac_base_init_list impl_ac_base_init_list_Consac_base_init_list
#define kc_phylum_ac_base_init phylum_ac_base_init
#define kc_tag_ac_base_init_AcBaseInit impl_ac_base_init_AcBaseInit
#define kc_phylum_baseclass_declarations phylum_baseclass_declarations
#define kc_tag_baseclass_declarations_Nilbaseclass_declarations impl_baseclass_declarations_Nilbaseclass_declarations
#define kc_tag_baseclass_declarations_Consbaseclass_declarations impl_baseclass_declarations_Consbaseclass_declarations
#define kc_phylum_baseclass_decl phylum_baseclass_decl
#define kc_tag_baseclass_decl_BaseClassDecl impl_baseclass_decl_BaseClassDecl
#define kc_phylum_baseclass_list phylum_baseclass_list
#define kc_tag_baseclass_list_Nilbaseclass_list impl_baseclass_list_Nilbaseclass_list
#define kc_tag_baseclass_list_Consbaseclass_list impl_baseclass_list_Consbaseclass_list
#define kc_phylum_error phylum_error
#define kc_tag_error_Fatal impl_error_Fatal
#define kc_tag_error_NonFatal impl_error_NonFatal
#define kc_tag_error_Warning impl_error_Warning
#define kc_phylum_problem phylum_problem
#define kc_tag_problem_Problem1 impl_problem_Problem1
#define kc_tag_problem_Problem1ID impl_problem_Problem1ID
#define kc_tag_problem_Problem1tID impl_problem_Problem1tID
#define kc_tag_problem_Problem1we impl_problem_Problem1we
#define kc_tag_problem_Problem1ID1ID impl_problem_Problem1ID1ID
#define kc_tag_problem_Problem1t1ID impl_problem_Problem1t1ID
#define kc_tag_problem_Problem1INT impl_problem_Problem1INT
#define kc_tag_problem_Problem1int1 impl_problem_Problem1int1
#define kc_tag_problem_Problem1INT1ID impl_problem_Problem1INT1ID
#define kc_tag_problem_Problem1ID1ID1ID impl_problem_Problem1ID1ID1ID
#define kc_tag_problem_Problem1INT1ID1ID impl_problem_Problem1INT1ID1ID
#define kc_tag_problem_Problem1storageoption1ID impl_problem_Problem1storageoption1ID
#define kc_tag_problem_Problem2 impl_problem_Problem2
#define kc_tag_problem_Problem3 impl_problem_Problem3
#define kc_tag_problem_Problem3int1 impl_problem_Problem3int1
#define kc_tag_problem_Problem4 impl_problem_Problem4
#define kc_tag_problem_Problem5 impl_problem_Problem5
#define kc_tag_problem_Problem6 impl_problem_Problem6
#define kc_phylum_addedphylumdeclarations phylum_addedphylumdeclarations
#define kc_tag_addedphylumdeclarations_Niladdedphylumdeclarations impl_addedphylumdeclarations_Niladdedphylumdeclarations
#define kc_tag_addedphylumdeclarations_Consaddedphylumdeclarations impl_addedphylumdeclarations_Consaddedphylumdeclarations
#define kc_phylum_addedphylumdeclaration phylum_addedphylumdeclaration
#define kc_tag_addedphylumdeclaration_AddedPhylumdeclaration impl_addedphylumdeclaration_AddedPhylumdeclaration
#define kc_phylum_countedphylumdeclarations phylum_countedphylumdeclarations
#define kc_tag_countedphylumdeclarations_Nilcountedphylumdeclarations impl_countedphylumdeclarations_Nilcountedphylumdeclarations
#define kc_tag_countedphylumdeclarations_Conscountedphylumdeclarations impl_countedphylumdeclarations_Conscountedphylumdeclarations
#define kc_phylum_countedphylumdeclaration phylum_countedphylumdeclaration
#define kc_tag_countedphylumdeclaration_CountedPhylumdeclaration impl_countedphylumdeclaration_CountedPhylumdeclaration
#define kc_phylum_charruns phylum_charruns
#define kc_tag_charruns_Newlines impl_charruns_Newlines
#define kc_tag_charruns_QuotedNewlines impl_charruns_QuotedNewlines
#define kc_tag_charruns_Stars impl_charruns_Stars
#define kc_phylum_bindingidmarks phylum_bindingidmarks
#define kc_tag_bindingidmarks_Nilbindingidmarks impl_bindingidmarks_Nilbindingidmarks
#define kc_tag_bindingidmarks_Consbindingidmarks impl_bindingidmarks_Consbindingidmarks
#define kc_phylum_bindingidmark phylum_bindingidmark
#define kc_tag_bindingidmark_BindingIdMark impl_bindingidmark_BindingIdMark

#endif // KC_DEPRECATED

// Some compilers are too stupid to detect that a function will always return
// a proper value when it returns one in all branches of an if- or switch-
// statement (with final else or default, of course).
#if !defined __GNUC__
# define NORETURN throw 0;
#else
# define NORETURN
#endif

namespace kc {


typedef enum { one_before_first_phylum = 0 ,
    phylum_nocasestring = 1,
    phylum_casestring = 2,
    phylum_real = 3,
    phylum_integer = 4,
    phylum_voidptr = 5,
    phylum_uniqID = 6,
    phylum_ID = 7,
    phylum_INT = 8,
    phylum_STRING = 9,
    phylum_phylumdeclarationsroot = 10,
    phylum_phylumdeclarations = 11,
    phylum_phylumnames = 12,
    phylum_phylumdeclaration = 13,
    phylum_storageoption = 14,
    phylum_storageclasses = 15,
    phylum_productionblock = 16,
    phylum_alternatives = 17,
    phylum_alternative = 18,
    phylum_arguments = 19,
    phylum_argument = 20,
    phylum_Ccode_option = 21,
    phylum_attributes = 22,
    phylum_attribute = 23,
    phylum_attribute_initialisation_option = 24,
    phylum_Cexpression = 25,
    phylum_Cexpression_elem = 26,
    phylum_CexpressionDQ = 27,
    phylum_CexpressionDQ_elem = 28,
    phylum_CexpressionSQ = 29,
    phylum_CexpressionSQ_elem = 30,
    phylum_idCexpressions = 31,
    phylum_idCexpression = 32,
    phylum_Ctexts = 33,
    phylum_includefiles = 34,
    phylum_includefile = 35,
    phylum_includedeclarations = 36,
    phylum_includedeclaration = 37,
    phylum_rwdeclarations = 38,
    phylum_rwdeclaration = 39,
    phylum_rewriteclauses = 40,
    phylum_rewriteclause = 41,
    phylum_patternchains = 42,
    phylum_patternchain = 43,
    phylum_outmostpatterns = 44,
    phylum_patternchainitem = 45,
    phylum_outmostpattern = 46,
    phylum_pattern = 47,
    phylum_patterns = 48,
    phylum_term = 49,
    phylum_terms = 50,
    phylum_fnfiles = 51,
    phylum_fnfile = 52,
    phylum_fndeclarations = 53,
    phylum_fndeclaration = 54,
    phylum_fnclass = 55,
    phylum_Ctext = 56,
    phylum_Ctext_elem = 57,
    phylum_foreach_after = 58,
    phylum_contextinfo = 59,
    phylum_withexpressions = 60,
    phylum_withexpression = 61,
    phylum_withcases = 62,
    phylum_withcase = 63,
    phylum_unparsedeclarations = 64,
    phylum_unparsedeclaration = 65,
    phylum_unparseclauses = 66,
    phylum_unparseclause = 67,
    phylum_viewnames = 68,
    phylum_unparseitems = 69,
    phylum_unparseitem = 70,
    phylum_unpsubterm = 71,
    phylum_unpattributes = 72,
    phylum_viewnameoption = 73,
    phylum_languageoption = 74,
    phylum_languagenames = 75,
    phylum_fileline = 76,
    phylum_scopetypefilelinestack = 77,
    phylum_scopetypefileline = 78,
    phylum_IDtype = 79,
    phylum_operators = 80,
    phylum_phyla = 81,
    phylum_variables = 82,
    phylum_dollarvarstatus = 83,
    phylum_tribool = 84,
    phylum_patternrepresentations = 85,
    phylum_patternrepresentation = 86,
    phylum_elem_patternrepresentation = 87,
    phylum_path = 88,
    phylum_paths = 89,
    phylum_argsnumbers = 90,
    phylum_rewriterulesinfo = 91,
    phylum_rewriteruleinfo = 92,
    phylum_withcasesinfo = 93,
    phylum_withcaseinfo = 94,
    phylum_rewriteviewsinfo = 95,
    phylum_rewriteviewinfo = 96,
    phylum_unparseviewsinfo = 97,
    phylum_unparseviewinfo = 98,
    phylum_unparsedeclsinfo = 99,
    phylum_unparsedeclinfo = 100,
    phylum_ac_declaration = 101,
    phylum_ac_declaration_list = 102,
    phylum_ac_declaration_specifiers = 103,
    phylum_ac_declaration_specifier = 104,
    phylum_ac_storage_class_specifier = 105,
    phylum_ac_type_specifier = 106,
    phylum_ac_type_qualifier = 107,
    phylum_ac_init_declarator_list = 108,
    phylum_ac_init_declarator = 109,
    phylum_ac_declarator = 110,
    phylum_ac_direct_declarator = 111,
    phylum_ac_pointer_option = 112,
    phylum_ac_pointer = 113,
    phylum_ac_ref_option = 114,
    phylum_ac_operator_name = 115,
    phylum_ac_class_qualifier_help_list = 116,
    phylum_ac_class_qualifier_list = 117,
    phylum_ac_type_qualifier_list = 118,
    phylum_ac_parameter_type_list = 119,
    phylum_ac_parameter_list = 120,
    phylum_ac_parameter_declaration = 121,
    phylum_ac_identifier_list = 122,
    phylum_ac_abstract_declarator = 123,
    phylum_ac_direct_abstract_declarator_option = 124,
    phylum_ac_direct_abstract_declarator = 125,
    phylum_ac_constant_expression_option = 126,
    phylum_ac_constant_expression = 127,
    phylum_ac_constant_expression_list = 128,
    phylum_ac_opt_base_init_list = 129,
    phylum_ac_base_init_list = 130,
    phylum_ac_base_init = 131,
    phylum_baseclass_declarations = 132,
    phylum_baseclass_decl = 133,
    phylum_baseclass_list = 134,
    phylum_error = 135,
    phylum_problem = 136,
    phylum_addedphylumdeclarations = 137,
    phylum_addedphylumdeclaration = 138,
    phylum_countedphylumdeclarations = 139,
    phylum_countedphylumdeclaration = 140,
    phylum_charruns = 141,
    phylum_bindingidmarks = 142,
    phylum_bindingidmark = 143,
    last_phylum = 144
} enum_phyla;

typedef enum { one_before_first_operator = 0 ,
    sel_NoCaseStr = 1,
    sel__Str = 2,
    sel__Real = 3,
    sel__Int = 4,
    sel__VoidPtr = 5,
    sel_Str = 6,
    sel_Id = 7,
    sel_Int = 8,
    sel_String = 9,
    sel_PhylumDeclarations = 10,
    sel_Nilphylumdeclarations = 11,
    sel_Consphylumdeclarations = 12,
    sel_Nilphylumnames = 13,
    sel_Consphylumnames = 14,
    sel_PhylumDeclaration = 15,
    sel_NoStorageOption = 16,
    sel_NegativeStorageOption = 17,
    sel_PositiveStorageOption = 18,
    sel_Nilstorageclasses = 19,
    sel_Consstorageclasses = 20,
    sel_Emptyproductionblock = 21,
    sel_ListAlternatives = 22,
    sel_NonlistAlternatives = 23,
    sel_PredefinedAlternatives = 24,
    sel_Nilalternatives = 25,
    sel_Consalternatives = 26,
    sel_Alternative = 27,
    sel_Nilarguments = 28,
    sel_Consarguments = 29,
    sel_Argument = 30,
    sel_CcodeOption = 31,
    sel_Nilattributes = 32,
    sel_Consattributes = 33,
    sel_Attribute = 34,
    sel_Noattribute_initialisation = 35,
    sel_Yesattribute_initialisation = 36,
    sel_NilCexpression = 37,
    sel_ConsCexpression = 38,
    sel_CExpressionPart = 39,
    sel_CExpressionDollarvar = 40,
    sel_CExpressionNl = 41,
    sel_CExpressionDQ = 42,
    sel_CExpressionSQ = 43,
    sel_CExpressionPack = 44,
    sel_CExpressionArray = 45,
    sel_NilCexpressionDQ = 46,
    sel_ConsCexpressionDQ = 47,
    sel_CExpressionDQPart = 48,
    sel_CExpressionDQNl = 49,
    sel_NilCexpressionSQ = 50,
    sel_ConsCexpressionSQ = 51,
    sel_CExpressionSQPart = 52,
    sel_CExpressionSQNl = 53,
    sel_NilidCexpressions = 54,
    sel_ConsidCexpressions = 55,
    sel_IdCexpression = 56,
    sel_NilCtexts = 57,
    sel_ConsCtexts = 58,
    sel_Nilincludefiles = 59,
    sel_Consincludefiles = 60,
    sel_IncludeFile = 61,
    sel_Nilincludedeclarations = 62,
    sel_Consincludedeclarations = 63,
    sel_IncludeDeclaration = 64,
    sel_Nilrwdeclarations = 65,
    sel_Consrwdeclarations = 66,
    sel_RwDeclaration = 67,
    sel_Nilrewriteclauses = 68,
    sel_Consrewriteclauses = 69,
    sel_RewriteClause = 70,
    sel_Nilpatternchains = 71,
    sel_Conspatternchains = 72,
    sel_Nilpatternchain = 73,
    sel_Conspatternchain = 74,
    sel_Niloutmostpatterns = 75,
    sel_Consoutmostpatterns = 76,
    sel_PatternchainitemOutmost = 77,
    sel_PatternchainitemGroup = 78,
    sel_PatternchainitemDollarid = 79,
    sel_OPOperatorWildcard = 80,
    sel_OPOperator = 81,
    sel_OPNonLeafVariable = 82,
    sel_OPWildcard = 83,
    sel_OPDefault = 84,
    sel_PVariable = 85,
    sel_POperator = 86,
    sel_PNonLeafVariable = 87,
    sel_PWildcard = 88,
    sel_PStringLiteral = 89,
    sel_PIntLiteral = 90,
    sel_Nilpatterns = 91,
    sel_Conspatterns = 92,
    sel_TVariable = 93,
    sel_TOperator = 94,
    sel_TMethod = 95,
    sel_TMethodDot = 96,
    sel_TMemberVar = 97,
    sel_TMemberVarDot = 98,
    sel_TCTerm = 99,
    sel_TStringLiteral = 100,
    sel_TIntLiteral = 101,
    sel_Nilterms = 102,
    sel_Consterms = 103,
    sel_Nilfnfiles = 104,
    sel_Consfnfiles = 105,
    sel_FnFile = 106,
    sel_Nilfndeclarations = 107,
    sel_Consfndeclarations = 108,
    sel_FnAcDeclaration = 109,
    sel_AcMemberDeclaration = 110,
    sel_GlobalFn = 111,
    sel_StaticFn = 112,
    sel_MemberFn = 113,
    sel_ConstructorFn = 114,
    sel_DestructorFn = 115,
    sel_ConvOperatorFn = 116,
    sel_NilCtext = 117,
    sel_ConsCtext = 118,
    sel_CTextLine = 119,
    sel_CTextDollarVar = 120,
    sel_CTextNl = 121,
    sel_CTextCexpressionDQ = 122,
    sel_CTextCexpressionSQ = 123,
    sel_CTextCbody = 124,
    sel_CTextForeachexpression = 125,
    sel_CTextWithexpression = 126,
    sel_NoForeachAfter = 127,
    sel_ForeachAfter = 128,
    sel_InForeachContext = 129,
    sel_NotInForeachContext = 130,
    sel_Nilwithexpressions = 131,
    sel_Conswithexpressions = 132,
    sel_WEVariable = 133,
    sel_WECexpression = 134,
    sel_Nilwithcases = 135,
    sel_Conswithcases = 136,
    sel_Withcase = 137,
    sel_Nilunparsedeclarations = 138,
    sel_Consunparsedeclarations = 139,
    sel_UnparseDeclaration = 140,
    sel_Nilunparseclauses = 141,
    sel_Consunparseclauses = 142,
    sel_UnparseClause = 143,
    sel_Nilviewnames = 144,
    sel_Consviewnames = 145,
    sel_Nilunparseitems = 146,
    sel_Consunparseitems = 147,
    sel_UnpStr = 148,
    sel_UnpSubexpr = 149,
    sel_UnpCtext = 150,
    sel_UnpBody = 151,
    sel_UViewVarDecl = 152,
    sel_UnpSubTerm = 153,
    sel_UnpDollarvarTerm = 154,
    sel_UnpSubAttr = 155,
    sel_UnpDollarvarAttr = 156,
    sel_UnpCastedVariable = 157,
    sel_Nilunpattributes = 158,
    sel_Consunpattributes = 159,
    sel_NoViewname = 160,
    sel_YesViewname = 161,
    sel_NoLanguagename = 162,
    sel_LanguageList = 163,
    sel_Nillanguagenames = 164,
    sel_Conslanguagenames = 165,
    sel_FileLine = 166,
    sel_NoFileLine = 167,
    sel_PosNoFileLine = 168,
    sel_Nilscopetypefilelinestack = 169,
    sel_Consscopetypefilelinestack = 170,
    sel_ScopeTypeFileLine = 171,
    sel_ITUnknown = 172,
    sel_ITPredefinedPhylum = 173,
    sel_ITUserPhylum = 174,
    sel_ITPredefinedOperator = 175,
    sel_ITUserOperator = 176,
    sel_ITPredefinedStorageClass = 177,
    sel_ITStorageClass = 178,
    sel_ITPredefinedUView = 179,
    sel_ITUserUView = 180,
    sel_ITUViewVar = 181,
    sel_ITPredefinedRView = 182,
    sel_ITUserRView = 183,
    sel_ITUserFunction = 184,
    sel_ITPatternVariable = 185,
    sel_ITLanguageName = 186,
    sel_Niloperators = 187,
    sel_Consoperators = 188,
    sel_Nilphyla = 189,
    sel_Consphyla = 190,
    sel_Nilvariables = 191,
    sel_Consvariables = 192,
    sel_DVAllowed = 193,
    sel_DVDisallowed = 194,
    sel_Equal = 195,
    sel_Smaller = 196,
    sel_Bigger = 197,
    sel_Nilpatternrepresentations = 198,
    sel_Conspatternrepresentations = 199,
    sel_Nilpatternrepresentation = 200,
    sel_Conspatternrepresentation = 201,
    sel_PRBinding = 202,
    sel_PRVarPredicate = 203,
    sel_PROperPredicate = 204,
    sel_PRUserPredicate = 205,
    sel_PRNonLeafBinding = 206,
    sel_PRWildcard = 207,
    sel_PRDefault = 208,
    sel_PRStringLiteral = 209,
    sel_PRIntLiteral = 210,
    sel_Nilpath = 211,
    sel_Conspath = 212,
    sel_Nilpaths = 213,
    sel_Conspaths = 214,
    sel_Nilargsnumbers = 215,
    sel_Consargsnumbers = 216,
    sel_Nilrewriterulesinfo = 217,
    sel_Consrewriterulesinfo = 218,
    sel_Rewriteruleinfo = 219,
    sel_Nilwithcasesinfo = 220,
    sel_Conswithcasesinfo = 221,
    sel_Withcaseinfo = 222,
    sel_Nilrewriteviewsinfo = 223,
    sel_Consrewriteviewsinfo = 224,
    sel_Rewriteviewinfo = 225,
    sel_Nilunparseviewsinfo = 226,
    sel_Consunparseviewsinfo = 227,
    sel_Unparseviewinfo = 228,
    sel_Nilunparsedeclsinfo = 229,
    sel_Consunparsedeclsinfo = 230,
    sel_Unparsedeclinfo = 231,
    sel_AcDeclaration = 232,
    sel_Nilac_declaration_list = 233,
    sel_Consac_declaration_list = 234,
    sel_Nilac_declaration_specifiers = 235,
    sel_Consac_declaration_specifiers = 236,
    sel_AcDeclSpecStorageSpec = 237,
    sel_AcDeclSpecTypeSpec = 238,
    sel_AcDeclSpecTypeQual = 239,
    sel_AcAuto = 240,
    sel_AcRegister = 241,
    sel_AcStatic = 242,
    sel_AcExtern = 243,
    sel_AcTypedef = 244,
    sel_AcVirtual = 245,
    sel_AcTypeSpec = 246,
    sel_AcConst = 247,
    sel_AcVolatile = 248,
    sel_AcUnsigned = 249,
    sel_AcNoQualifier = 250,
    sel_Nilac_init_declarator_list = 251,
    sel_Consac_init_declarator_list = 252,
    sel_AcInitDecl = 253,
    sel_AcDeclarator = 254,
    sel_AcDirectDeclId = 255,
    sel_AcDirectDeclPack = 256,
    sel_AcDirectDeclArray = 257,
    sel_AcDirectDeclProto = 258,
    sel_AcQualifiedDeclProto = 259,
    sel_AcMemberDecl = 260,
    sel_AcConvOperatorDecl = 261,
    sel_AcOperatorDeclId = 262,
    sel_Nopointer = 263,
    sel_Yespointer = 264,
    sel_AcPointerNil = 265,
    sel_AcPointerCons = 266,
    sel_AcNoRef = 267,
    sel_AcRef = 268,
    sel_AcOperatorName = 269,
    sel_Nilac_class_qualifier_help_list = 270,
    sel_Consac_class_qualifier_help_list = 271,
    sel_Nilac_class_qualifier_list = 272,
    sel_Consac_class_qualifier_list = 273,
    sel_Nilac_type_qualifier_list = 274,
    sel_Consac_type_qualifier_list = 275,
    sel_AcParList = 276,
    sel_AcParList3Dot = 277,
    sel_Nilac_parameter_list = 278,
    sel_Consac_parameter_list = 279,
    sel_AcParDeclDecl = 280,
    sel_AcParDeclAbsdecl = 281,
    sel_Nilac_identifier_list = 282,
    sel_Consac_identifier_list = 283,
    sel_AcAbsdeclPointer = 284,
    sel_AcAbsdeclDirdecl = 285,
    sel_Noac_direct_abstract_declarator = 286,
    sel_Yesac_direct_abstract_declarator = 287,
    sel_AcDirAbsdeclPack = 288,
    sel_AcDirAbsdeclArray = 289,
    sel_AcDirAbsdeclFn = 290,
    sel_Yesac_constant_expression = 291,
    sel_Noac_constant_expression = 292,
    sel_AcConstExpr = 293,
    sel_Nilac_constant_expression_list = 294,
    sel_Consac_constant_expression_list = 295,
    sel_AcNoBaseInit = 296,
    sel_AcYesBaseInit = 297,
    sel_Nilac_base_init_list = 298,
    sel_Consac_base_init_list = 299,
    sel_AcBaseInit = 300,
    sel_Nilbaseclass_declarations = 301,
    sel_Consbaseclass_declarations = 302,
    sel_BaseClassDecl = 303,
    sel_Nilbaseclass_list = 304,
    sel_Consbaseclass_list = 305,
    sel_Fatal = 306,
    sel_NonFatal = 307,
    sel_Warning = 308,
    sel_Problem1 = 309,
    sel_Problem1ID = 310,
    sel_Problem1tID = 311,
    sel_Problem1we = 312,
    sel_Problem1ID1ID = 313,
    sel_Problem1t1ID = 314,
    sel_Problem1INT = 315,
    sel_Problem1int1 = 316,
    sel_Problem1INT1ID = 317,
    sel_Problem1ID1ID1ID = 318,
    sel_Problem1INT1ID1ID = 319,
    sel_Problem1storageoption1ID = 320,
    sel_Problem2 = 321,
    sel_Problem3 = 322,
    sel_Problem3int1 = 323,
    sel_Problem4 = 324,
    sel_Problem5 = 325,
    sel_Problem6 = 326,
    sel_Niladdedphylumdeclarations = 327,
    sel_Consaddedphylumdeclarations = 328,
    sel_AddedPhylumdeclaration = 329,
    sel_Nilcountedphylumdeclarations = 330,
    sel_Conscountedphylumdeclarations = 331,
    sel_CountedPhylumdeclaration = 332,
    sel_Newlines = 333,
    sel_QuotedNewlines = 334,
    sel_Stars = 335,
    sel_Nilbindingidmarks = 336,
    sel_Consbindingidmarks = 337,
    sel_BindingIdMark = 338,
    last_operator = 339
} enum_operators;

class impl_abstract_phylum;
typedef impl_abstract_phylum * abstract_phylum;
typedef const impl_abstract_phylum * c_abstract_phylum;
class impl_abstract_list;
typedef impl_abstract_list * abstract_list;
typedef const impl_abstract_list * c_abstract_list;

template <typename P, typename T>
P phylum_cast(T* t) {
    return static_cast<P>(t);
}
template <typename P, typename T>
const P phylum_cast(const T* t) {
    return static_cast<const P>(t);
}
class impl_nocasestring_NoCaseStr;
class impl_casestring__Str;
class impl_real__Real;
class impl_integer__Int;
class impl_voidptr__VoidPtr;
class impl_uniqID;
class impl_ID;
class impl_INT;
class impl_STRING;
class impl_phylumdeclarationsroot;
class impl_phylumdeclarations;
class impl_phylumnames;
class impl_phylumdeclaration;
class impl_storageoption;
class impl_storageclasses;
class impl_productionblock;
class impl_alternatives;
class impl_alternative;
class impl_arguments;
class impl_argument;
class impl_Ccode_option;
class impl_attributes;
class impl_attribute;
class impl_attribute_initialisation_option;
class impl_Cexpression;
class impl_Cexpression_elem;
class impl_CexpressionDQ;
class impl_CexpressionDQ_elem;
class impl_CexpressionSQ;
class impl_CexpressionSQ_elem;
class impl_idCexpressions;
class impl_idCexpression;
class impl_Ctexts;
class impl_includefiles;
class impl_includefile;
class impl_includedeclarations;
class impl_includedeclaration;
class impl_rwdeclarations;
class impl_rwdeclaration;
class impl_rewriteclauses;
class impl_rewriteclause;
class impl_patternchains;
class impl_patternchain;
class impl_outmostpatterns;
class impl_patternchainitem;
class impl_outmostpattern;
class impl_pattern;
class impl_patterns;
class impl_term;
class impl_terms;
class impl_fnfiles;
class impl_fnfile;
class impl_fndeclarations;
class impl_fndeclaration;
class impl_fnclass;
class impl_Ctext;
class impl_Ctext_elem;
class impl_foreach_after;
class impl_contextinfo;
class impl_withexpressions;
class impl_withexpression;
class impl_withcases;
class impl_withcase;
class impl_unparsedeclarations;
class impl_unparsedeclaration;
class impl_unparseclauses;
class impl_unparseclause;
class impl_viewnames;
class impl_unparseitems;
class impl_unparseitem;
class impl_unpsubterm;
class impl_unpattributes;
class impl_viewnameoption;
class impl_languageoption;
class impl_languagenames;
class impl_fileline;
class impl_scopetypefilelinestack;
class impl_scopetypefileline;
class impl_IDtype;
class impl_operators;
class impl_phyla;
class impl_variables;
class impl_dollarvarstatus;
class impl_tribool;
class impl_patternrepresentations;
class impl_patternrepresentation;
class impl_elem_patternrepresentation;
class impl_path;
class impl_paths;
class impl_argsnumbers;
class impl_rewriterulesinfo;
class impl_rewriteruleinfo;
class impl_withcasesinfo;
class impl_withcaseinfo;
class impl_rewriteviewsinfo;
class impl_rewriteviewinfo;
class impl_unparseviewsinfo;
class impl_unparseviewinfo;
class impl_unparsedeclsinfo;
class impl_unparsedeclinfo;
class impl_ac_declaration;
class impl_ac_declaration_list;
class impl_ac_declaration_specifiers;
class impl_ac_declaration_specifier;
class impl_ac_storage_class_specifier;
class impl_ac_type_specifier;
class impl_ac_type_qualifier;
class impl_ac_init_declarator_list;
class impl_ac_init_declarator;
class impl_ac_declarator;
class impl_ac_direct_declarator;
class impl_ac_pointer_option;
class impl_ac_pointer;
class impl_ac_ref_option;
class impl_ac_operator_name;
class impl_ac_class_qualifier_help_list;
class impl_ac_class_qualifier_list;
class impl_ac_type_qualifier_list;
class impl_ac_parameter_type_list;
class impl_ac_parameter_list;
class impl_ac_parameter_declaration;
class impl_ac_identifier_list;
class impl_ac_abstract_declarator;
class impl_ac_direct_abstract_declarator_option;
class impl_ac_direct_abstract_declarator;
class impl_ac_constant_expression_option;
class impl_ac_constant_expression;
class impl_ac_constant_expression_list;
class impl_ac_opt_base_init_list;
class impl_ac_base_init_list;
class impl_ac_base_init;
class impl_baseclass_declarations;
class impl_baseclass_decl;
class impl_baseclass_list;
class impl_error;
class impl_problem;
class impl_addedphylumdeclarations;
class impl_addedphylumdeclaration;
class impl_countedphylumdeclarations;
class impl_countedphylumdeclaration;
class impl_charruns;
class impl_bindingidmarks;
class impl_bindingidmark;


void kc_invalid_operator( const char *kc_func_prefix, enum_phyla kc_phy, int kc_line,
    const char *kc_file, enum_operators kc_oper ) __attribute__ ((noreturn));

typedef enum_phyla *enum_phyla_list;

/*
 * make sure that the first 'real' storage class _always_ gets a value > 0
 * and kc_not_uniq gets a value == 0
 * (because then we can use it as a C boolean)
 */
enum kc_storageclass_t {
    kc_not_uniq,
    uniq,
    last_storageclass
};

typedef struct {
    const char *name;			// name of the phylum
    enum_operators first_operator;	// index in operator_info[]
    enum_operators last_operator;	// index in operator_info[]
    kc_storageclass_t uniq_stored;	// storage class
} KC_PHYLUM_INFO;

typedef struct {
    const char *name;			// name of the operator
    size_t no_sons;			// number of sons
    bool atomicity;			// atomic type or not
    enum_phyla phylum;			// index in phylum_info[]
    enum_phyla_list subphylum;		// indexes in phylum_info[]
    int no_attrs;			// number of attributes
    enum_phyla_list attribute;		// indexes in phylum_info[]
    size_t size;			// size of operator (for statistics)
} KC_OPERATOR_INFO;

typedef enum_phyla_list KC_UNIQ_INFO;

extern KC_OPERATOR_INFO operator_info[];
extern KC_PHYLUM_INFO phylum_info[];
extern KC_UNIQ_INFO kc_UniqInfo[];

#define KC_OP_NAME(op) (operator_info[op].name)
#define KC_NO_SONS(prod) (operator_info[prod].no_sons)
#define KC_ATOMICITY(prod) (operator_info[prod].atomicity)


typedef impl_nocasestring_NoCaseStr *nocasestring;
typedef const impl_nocasestring_NoCaseStr *c_nocasestring;
typedef impl_casestring__Str *casestring;
typedef const impl_casestring__Str *c_casestring;
typedef impl_real__Real *real;
typedef const impl_real__Real *c_real;
typedef impl_integer__Int *integer;
typedef const impl_integer__Int *c_integer;
typedef impl_voidptr__VoidPtr *voidptr;
typedef const impl_voidptr__VoidPtr *c_voidptr;
typedef impl_uniqID *uniqID;
typedef const impl_uniqID *c_uniqID;
typedef impl_ID *ID;
typedef const impl_ID *c_ID;
typedef impl_INT *INT;
typedef const impl_INT *c_INT;
typedef impl_STRING *STRING;
typedef const impl_STRING *c_STRING;
typedef impl_phylumdeclarationsroot *phylumdeclarationsroot;
typedef const impl_phylumdeclarationsroot *c_phylumdeclarationsroot;
typedef impl_phylumdeclarations *phylumdeclarations;
typedef const impl_phylumdeclarations *c_phylumdeclarations;
typedef impl_phylumnames *phylumnames;
typedef const impl_phylumnames *c_phylumnames;
typedef impl_phylumdeclaration *phylumdeclaration;
typedef const impl_phylumdeclaration *c_phylumdeclaration;
typedef impl_storageoption *storageoption;
typedef const impl_storageoption *c_storageoption;
typedef impl_storageclasses *storageclasses;
typedef const impl_storageclasses *c_storageclasses;
typedef impl_productionblock *productionblock;
typedef const impl_productionblock *c_productionblock;
typedef impl_alternatives *alternatives;
typedef const impl_alternatives *c_alternatives;
typedef impl_alternative *alternative;
typedef const impl_alternative *c_alternative;
typedef impl_arguments *arguments;
typedef const impl_arguments *c_arguments;
typedef impl_argument *argument;
typedef const impl_argument *c_argument;
typedef impl_Ccode_option *Ccode_option;
typedef const impl_Ccode_option *c_Ccode_option;
typedef impl_attributes *attributes;
typedef const impl_attributes *c_attributes;
typedef impl_attribute *attribute;
typedef const impl_attribute *c_attribute;
typedef impl_attribute_initialisation_option *attribute_initialisation_option;
typedef const impl_attribute_initialisation_option *c_attribute_initialisation_option;
typedef impl_Cexpression *Cexpression;
typedef const impl_Cexpression *c_Cexpression;
typedef impl_Cexpression_elem *Cexpression_elem;
typedef const impl_Cexpression_elem *c_Cexpression_elem;
typedef impl_CexpressionDQ *CexpressionDQ;
typedef const impl_CexpressionDQ *c_CexpressionDQ;
typedef impl_CexpressionDQ_elem *CexpressionDQ_elem;
typedef const impl_CexpressionDQ_elem *c_CexpressionDQ_elem;
typedef impl_CexpressionSQ *CexpressionSQ;
typedef const impl_CexpressionSQ *c_CexpressionSQ;
typedef impl_CexpressionSQ_elem *CexpressionSQ_elem;
typedef const impl_CexpressionSQ_elem *c_CexpressionSQ_elem;
typedef impl_idCexpressions *idCexpressions;
typedef const impl_idCexpressions *c_idCexpressions;
typedef impl_idCexpression *idCexpression;
typedef const impl_idCexpression *c_idCexpression;
typedef impl_Ctexts *Ctexts;
typedef const impl_Ctexts *c_Ctexts;
typedef impl_includefiles *includefiles;
typedef const impl_includefiles *c_includefiles;
typedef impl_includefile *includefile;
typedef const impl_includefile *c_includefile;
typedef impl_includedeclarations *includedeclarations;
typedef const impl_includedeclarations *c_includedeclarations;
typedef impl_includedeclaration *includedeclaration;
typedef const impl_includedeclaration *c_includedeclaration;
typedef impl_rwdeclarations *rwdeclarations;
typedef const impl_rwdeclarations *c_rwdeclarations;
typedef impl_rwdeclaration *rwdeclaration;
typedef const impl_rwdeclaration *c_rwdeclaration;
typedef impl_rewriteclauses *rewriteclauses;
typedef const impl_rewriteclauses *c_rewriteclauses;
typedef impl_rewriteclause *rewriteclause;
typedef const impl_rewriteclause *c_rewriteclause;
typedef impl_patternchains *patternchains;
typedef const impl_patternchains *c_patternchains;
typedef impl_patternchain *patternchain;
typedef const impl_patternchain *c_patternchain;
typedef impl_outmostpatterns *outmostpatterns;
typedef const impl_outmostpatterns *c_outmostpatterns;
typedef impl_patternchainitem *patternchainitem;
typedef const impl_patternchainitem *c_patternchainitem;
typedef impl_outmostpattern *outmostpattern;
typedef const impl_outmostpattern *c_outmostpattern;
typedef impl_pattern *pattern;
typedef const impl_pattern *c_pattern;
typedef impl_patterns *patterns;
typedef const impl_patterns *c_patterns;
typedef impl_term *term;
typedef const impl_term *c_term;
typedef impl_terms *terms;
typedef const impl_terms *c_terms;
typedef impl_fnfiles *fnfiles;
typedef const impl_fnfiles *c_fnfiles;
typedef impl_fnfile *fnfile;
typedef const impl_fnfile *c_fnfile;
typedef impl_fndeclarations *fndeclarations;
typedef const impl_fndeclarations *c_fndeclarations;
typedef impl_fndeclaration *fndeclaration;
typedef const impl_fndeclaration *c_fndeclaration;
typedef impl_fnclass *fnclass;
typedef const impl_fnclass *c_fnclass;
typedef impl_Ctext *Ctext;
typedef const impl_Ctext *c_Ctext;
typedef impl_Ctext_elem *Ctext_elem;
typedef const impl_Ctext_elem *c_Ctext_elem;
typedef impl_foreach_after *foreach_after;
typedef const impl_foreach_after *c_foreach_after;
typedef impl_contextinfo *contextinfo;
typedef const impl_contextinfo *c_contextinfo;
typedef impl_withexpressions *withexpressions;
typedef const impl_withexpressions *c_withexpressions;
typedef impl_withexpression *withexpression;
typedef const impl_withexpression *c_withexpression;
typedef impl_withcases *withcases;
typedef const impl_withcases *c_withcases;
typedef impl_withcase *withcase;
typedef const impl_withcase *c_withcase;
typedef impl_unparsedeclarations *unparsedeclarations;
typedef const impl_unparsedeclarations *c_unparsedeclarations;
typedef impl_unparsedeclaration *unparsedeclaration;
typedef const impl_unparsedeclaration *c_unparsedeclaration;
typedef impl_unparseclauses *unparseclauses;
typedef const impl_unparseclauses *c_unparseclauses;
typedef impl_unparseclause *unparseclause;
typedef const impl_unparseclause *c_unparseclause;
typedef impl_viewnames *viewnames;
typedef const impl_viewnames *c_viewnames;
typedef impl_unparseitems *unparseitems;
typedef const impl_unparseitems *c_unparseitems;
typedef impl_unparseitem *unparseitem;
typedef const impl_unparseitem *c_unparseitem;
typedef impl_unpsubterm *unpsubterm;
typedef const impl_unpsubterm *c_unpsubterm;
typedef impl_unpattributes *unpattributes;
typedef const impl_unpattributes *c_unpattributes;
typedef impl_viewnameoption *viewnameoption;
typedef const impl_viewnameoption *c_viewnameoption;
typedef impl_languageoption *languageoption;
typedef const impl_languageoption *c_languageoption;
typedef impl_languagenames *languagenames;
typedef const impl_languagenames *c_languagenames;
typedef impl_fileline *fileline;
typedef const impl_fileline *c_fileline;
typedef impl_scopetypefilelinestack *scopetypefilelinestack;
typedef const impl_scopetypefilelinestack *c_scopetypefilelinestack;
typedef impl_scopetypefileline *scopetypefileline;
typedef const impl_scopetypefileline *c_scopetypefileline;
typedef impl_IDtype *IDtype;
typedef const impl_IDtype *c_IDtype;
typedef impl_operators *operators;
typedef const impl_operators *c_operators;
typedef impl_phyla *phyla;
typedef const impl_phyla *c_phyla;
typedef impl_variables *variables;
typedef const impl_variables *c_variables;
typedef impl_dollarvarstatus *dollarvarstatus;
typedef const impl_dollarvarstatus *c_dollarvarstatus;
typedef impl_tribool *tribool;
typedef const impl_tribool *c_tribool;
typedef impl_patternrepresentations *patternrepresentations;
typedef const impl_patternrepresentations *c_patternrepresentations;
typedef impl_patternrepresentation *patternrepresentation;
typedef const impl_patternrepresentation *c_patternrepresentation;
typedef impl_elem_patternrepresentation *elem_patternrepresentation;
typedef const impl_elem_patternrepresentation *c_elem_patternrepresentation;
typedef impl_path *path;
typedef const impl_path *c_path;
typedef impl_paths *paths;
typedef const impl_paths *c_paths;
typedef impl_argsnumbers *argsnumbers;
typedef const impl_argsnumbers *c_argsnumbers;
typedef impl_rewriterulesinfo *rewriterulesinfo;
typedef const impl_rewriterulesinfo *c_rewriterulesinfo;
typedef impl_rewriteruleinfo *rewriteruleinfo;
typedef const impl_rewriteruleinfo *c_rewriteruleinfo;
typedef impl_withcasesinfo *withcasesinfo;
typedef const impl_withcasesinfo *c_withcasesinfo;
typedef impl_withcaseinfo *withcaseinfo;
typedef const impl_withcaseinfo *c_withcaseinfo;
typedef impl_rewriteviewsinfo *rewriteviewsinfo;
typedef const impl_rewriteviewsinfo *c_rewriteviewsinfo;
typedef impl_rewriteviewinfo *rewriteviewinfo;
typedef const impl_rewriteviewinfo *c_rewriteviewinfo;
typedef impl_unparseviewsinfo *unparseviewsinfo;
typedef const impl_unparseviewsinfo *c_unparseviewsinfo;
typedef impl_unparseviewinfo *unparseviewinfo;
typedef const impl_unparseviewinfo *c_unparseviewinfo;
typedef impl_unparsedeclsinfo *unparsedeclsinfo;
typedef const impl_unparsedeclsinfo *c_unparsedeclsinfo;
typedef impl_unparsedeclinfo *unparsedeclinfo;
typedef const impl_unparsedeclinfo *c_unparsedeclinfo;
typedef impl_ac_declaration *ac_declaration;
typedef const impl_ac_declaration *c_ac_declaration;
typedef impl_ac_declaration_list *ac_declaration_list;
typedef const impl_ac_declaration_list *c_ac_declaration_list;
typedef impl_ac_declaration_specifiers *ac_declaration_specifiers;
typedef const impl_ac_declaration_specifiers *c_ac_declaration_specifiers;
typedef impl_ac_declaration_specifier *ac_declaration_specifier;
typedef const impl_ac_declaration_specifier *c_ac_declaration_specifier;
typedef impl_ac_storage_class_specifier *ac_storage_class_specifier;
typedef const impl_ac_storage_class_specifier *c_ac_storage_class_specifier;
typedef impl_ac_type_specifier *ac_type_specifier;
typedef const impl_ac_type_specifier *c_ac_type_specifier;
typedef impl_ac_type_qualifier *ac_type_qualifier;
typedef const impl_ac_type_qualifier *c_ac_type_qualifier;
typedef impl_ac_init_declarator_list *ac_init_declarator_list;
typedef const impl_ac_init_declarator_list *c_ac_init_declarator_list;
typedef impl_ac_init_declarator *ac_init_declarator;
typedef const impl_ac_init_declarator *c_ac_init_declarator;
typedef impl_ac_declarator *ac_declarator;
typedef const impl_ac_declarator *c_ac_declarator;
typedef impl_ac_direct_declarator *ac_direct_declarator;
typedef const impl_ac_direct_declarator *c_ac_direct_declarator;
typedef impl_ac_pointer_option *ac_pointer_option;
typedef const impl_ac_pointer_option *c_ac_pointer_option;
typedef impl_ac_pointer *ac_pointer;
typedef const impl_ac_pointer *c_ac_pointer;
typedef impl_ac_ref_option *ac_ref_option;
typedef const impl_ac_ref_option *c_ac_ref_option;
typedef impl_ac_operator_name *ac_operator_name;
typedef const impl_ac_operator_name *c_ac_operator_name;
typedef impl_ac_class_qualifier_help_list *ac_class_qualifier_help_list;
typedef const impl_ac_class_qualifier_help_list *c_ac_class_qualifier_help_list;
typedef impl_ac_class_qualifier_list *ac_class_qualifier_list;
typedef const impl_ac_class_qualifier_list *c_ac_class_qualifier_list;
typedef impl_ac_type_qualifier_list *ac_type_qualifier_list;
typedef const impl_ac_type_qualifier_list *c_ac_type_qualifier_list;
typedef impl_ac_parameter_type_list *ac_parameter_type_list;
typedef const impl_ac_parameter_type_list *c_ac_parameter_type_list;
typedef impl_ac_parameter_list *ac_parameter_list;
typedef const impl_ac_parameter_list *c_ac_parameter_list;
typedef impl_ac_parameter_declaration *ac_parameter_declaration;
typedef const impl_ac_parameter_declaration *c_ac_parameter_declaration;
typedef impl_ac_identifier_list *ac_identifier_list;
typedef const impl_ac_identifier_list *c_ac_identifier_list;
typedef impl_ac_abstract_declarator *ac_abstract_declarator;
typedef const impl_ac_abstract_declarator *c_ac_abstract_declarator;
typedef impl_ac_direct_abstract_declarator_option *ac_direct_abstract_declarator_option;
typedef const impl_ac_direct_abstract_declarator_option *c_ac_direct_abstract_declarator_option;
typedef impl_ac_direct_abstract_declarator *ac_direct_abstract_declarator;
typedef const impl_ac_direct_abstract_declarator *c_ac_direct_abstract_declarator;
typedef impl_ac_constant_expression_option *ac_constant_expression_option;
typedef const impl_ac_constant_expression_option *c_ac_constant_expression_option;
typedef impl_ac_constant_expression *ac_constant_expression;
typedef const impl_ac_constant_expression *c_ac_constant_expression;
typedef impl_ac_constant_expression_list *ac_constant_expression_list;
typedef const impl_ac_constant_expression_list *c_ac_constant_expression_list;
typedef impl_ac_opt_base_init_list *ac_opt_base_init_list;
typedef const impl_ac_opt_base_init_list *c_ac_opt_base_init_list;
typedef impl_ac_base_init_list *ac_base_init_list;
typedef const impl_ac_base_init_list *c_ac_base_init_list;
typedef impl_ac_base_init *ac_base_init;
typedef const impl_ac_base_init *c_ac_base_init;
typedef impl_baseclass_declarations *baseclass_declarations;
typedef const impl_baseclass_declarations *c_baseclass_declarations;
typedef impl_baseclass_decl *baseclass_decl;
typedef const impl_baseclass_decl *c_baseclass_decl;
typedef impl_baseclass_list *baseclass_list;
typedef const impl_baseclass_list *c_baseclass_list;
typedef impl_error *error;
typedef const impl_error *c_error;
typedef impl_problem *problem;
typedef const impl_problem *c_problem;
typedef impl_addedphylumdeclarations *addedphylumdeclarations;
typedef const impl_addedphylumdeclarations *c_addedphylumdeclarations;
typedef impl_addedphylumdeclaration *addedphylumdeclaration;
typedef const impl_addedphylumdeclaration *c_addedphylumdeclaration;
typedef impl_countedphylumdeclarations *countedphylumdeclarations;
typedef const impl_countedphylumdeclarations *c_countedphylumdeclarations;
typedef impl_countedphylumdeclaration *countedphylumdeclaration;
typedef const impl_countedphylumdeclaration *c_countedphylumdeclaration;
typedef impl_charruns *charruns;
typedef const impl_charruns *c_charruns;
typedef impl_bindingidmarks *bindingidmarks;
typedef const impl_bindingidmarks *c_bindingidmarks;
typedef impl_bindingidmark *bindingidmark;
typedef const impl_bindingidmark *c_bindingidmark;

#define KC_NO_OF_OPERATORS 339


} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
typedef enum {include_header =0, include_file =1, include_unknown, include_both} include_type;
class twoIncludedeclarations {
    includedeclarations inc1, inc2;
    public:
    includedeclarations& operator[](int i)
    { return (i==0) ? inc1 : inc2; }
};

//
// The Termprocessor Kimwitu++
//
// Copyright © 1991 University of Twente, Dept TIOS.
// Copyright © 1998-2008 Humboldt-Universität zu Berlin, Institute of Informatics
// All rights reserved.
//
// Kimwitu++ is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Kimwitu++ is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Kimwitu++; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
//

#include "config.h"

extern char kimwitu_copyright[] ; // defined above
extern casestring g_progname;
extern const char* pg_line;
struct cmdline_options {
    std::string hfilename;
    std::string ccfilename;
    bool quiet;
    bool verbose;
    bool no_csgio;
    bool no_unparse;
    bool no_rewrite;
    bool no_printdot;
    bool no_hashtables;
    bool operator_cast;
    bool smart_pointer;
    bool weak_pointer;
    char covariant;
    std::string for_bison;
    bool for_yxx;
    bool overwrite;
    bool linedirec;
    bool rw_loop;
    std::string stdafx;
    std::string dllexports;
    std::string prefix;
    std::string suffix;
    std::string filter;
    std::string msg_format;
    std::string dir_line;
    bool warn_drop_identical_patterns; // actually dropped from generated code (old test)
    bool warn_equivalent_patterns; // informational only (new test)
    bool warn_overlapping_patterns;
    cmdline_options(): hfilename(""), ccfilename(""),
    quiet(false), verbose(false), no_csgio(false), no_unparse(false), no_rewrite(false),
    no_printdot(false), no_hashtables(false), operator_cast(false), smart_pointer(false),
    weak_pointer(false), covariant('y'), for_bison(""), for_yxx(false), overwrite(false),
    linedirec(true), rw_loop(false), stdafx(""), dllexports(""), prefix(""), suffix("cc"),
    filter(""), msg_format(""), dir_line(""),
    warn_drop_identical_patterns(true),
    warn_equivalent_patterns(true),
    warn_overlapping_patterns(false) { }
};
extern cmdline_options g_options;

namespace kc { void leave(int); }

extern int pg_lineno;					/* global line # */
extern int pg_column;					/* global column # */
extern int pg_charpos;					/* global charpos # */
extern casestring pg_filename;				/* global file name */
extern int pg_no_of_arguments;				/* no_of_arguments */
extern phylumdeclarations Thephylumdeclarations;	/* global phylumdecls */
extern rwdeclarations Therwdeclarations;		/* global rw-decls */
extern fndeclarations Thefndeclarations;		/* fn-decls for the file being parsed */
extern fnfiles Thefnfiles;				/* global fn-decls */
extern includefiles Theincludefiles;			/* global incl-decls */
extern unparsedeclarations Theunparsedeclarations;	/* global unp-decls */
extern argsnumbers Theargsnumbers;			/* global list of argsnumbers */
extern viewnames Theuviewnames;				/* global list of u-viewnames */
extern viewnames Therviewnames;				/* global list of r-viewnames */
extern storageclasses Thestorageclasses;		/* global list of storageclasses */
extern languagenames Thelanguages;			/* global list of used languages */
extern baseclass_declarations Thebaseclasses;		/* global list of defined baseclasses */
extern bool pg_uviewshavebeendefined;			/* global indication */
extern bool pg_rviewshavebeendefined;			/* global indication */
extern bool pg_storageclasseshavebeendefined;		/* global indication */
extern bool pg_languageshavebeendefined;		/* global indication */

#include "error.h"

extern viewnameoption ug_viewnameopt;

#include "occur.h"

extern addedphylumdeclarations pl_addedphylumdeclarations;

extern countedphylumdeclarations pl_countedphylumdeclarations;

namespace kc { ID f_emptyId(); }

namespace kc { void collect_strings(void); }

namespace kc { void unparse_string_collection(void); }

extern bindingidmarks Thebindingidmarks;

/* end included stuff */


namespace kc {

#ifndef KC_NO_DEFAULT_IN_WITH
# define KC_NO_DEFAULT_IN_WITH "Internal Error: no default action defined in function %s at %s:%d\n"
#endif
void kc_no_default_in_with (const char*, int, const char*);
void kc_returnless_function (const char *, int, const char*);

#ifndef NDEBUG
# define assertCond(t) do {if (!(t)) kc_assertionFailed(__FILE__,__LINE__);}while(false)
# define assertReason(t,s) do {if (!(t)) kc_assertionReasonFailed(__FILE__,__LINE__,s);}while(false)
# define assertNonNull(p) do {if (p == 0) kc_assertionNonNullFailed(__FILE__,__LINE__,#p);}while(false)
# define assertPhylum(ptr,phy) do { \
    assertNonNull(ptr); \
    if (ptr->phylum()!=phy) \
	kc_assertionOperatorInPhylumFailed(ptr->prod_sel(),#ptr,"->prod_sel()","phy",__FILE__,__LINE__); \
} while(false)
#else
# define assertCond(t)
# define assertReason(t,s)
# define assertNonNull(ptr)
# define assertPhylum(op,phy)
#endif
#define assertionFailed(s) kc_assertionReasonFailed(__FILE__,__LINE__,s)

void kc_assertionFailed (const char*, int) __attribute__ ((noreturn));
void kc_assertionReasonFailed (const char*, int, const char*) __attribute__ ((noreturn));
void kc_assertionNonNullFailed (const char*, int, const char*) __attribute__ ((noreturn));
void kc_assertionOperatorInPhylumFailed (int, const char*, const char*, const char*, const char*, int) __attribute__ ((noreturn));

casestring mkcasestring( const kc_char_t *, int length = -1);
nocasestring mknocasestring( const kc_char_t *, int length = -1);
integer mkinteger( const INTEGER );
real mkreal( const REAL );
inline casestring _Str( const kc_char_t * cc) { return mkcasestring(cc); }
inline nocasestring NoCaseStr( const kc_char_t * cc) { return mknocasestring(cc); }
inline integer _Int( const INTEGER cc) { return mkinteger(cc); }
inline real _Real( const REAL cc) { return mkreal(cc); }
class impl_uniqID_Str* Str (casestring);
class impl_ID_Id* Id (uniqID);
class impl_INT_Int* Int (integer);
class impl_STRING_String* String (casestring);
class impl_phylumdeclarationsroot_PhylumDeclarations* PhylumDeclarations (phylumdeclarations);
phylumdeclarations Nilphylumdeclarations();
phylumdeclarations Consphylumdeclarations(phylumdeclaration,phylumdeclarations);
phylumnames Nilphylumnames();
phylumnames Consphylumnames(ID,phylumnames);
class impl_phylumdeclaration_PhylumDeclaration* PhylumDeclaration (ID, storageoption, productionblock, Ccode_option);
class impl_storageoption_NoStorageOption* NoStorageOption ();
class impl_storageoption_NegativeStorageOption* NegativeStorageOption (ID);
class impl_storageoption_PositiveStorageOption* PositiveStorageOption (ID);
storageclasses Nilstorageclasses();
storageclasses Consstorageclasses(ID,storageclasses);
class impl_productionblock_Emptyproductionblock* Emptyproductionblock ();
class impl_productionblock_ListAlternatives* ListAlternatives (alternatives, ID);
class impl_productionblock_NonlistAlternatives* NonlistAlternatives (alternatives);
class impl_productionblock_PredefinedAlternatives* PredefinedAlternatives (alternatives);
alternatives Nilalternatives();
alternatives Consalternatives(alternative,alternatives);
class impl_alternative_Alternative* Alternative (ID, arguments);
arguments Nilarguments();
arguments Consarguments(ID,arguments);
class impl_argument_Argument* Argument (ID, integer);
class impl_Ccode_option_CcodeOption* CcodeOption (attributes, Ctexts);
attributes Nilattributes();
attributes Consattributes(attribute,attributes);
class impl_attribute_Attribute* Attribute (ID, ID, attribute_initialisation_option);
class impl_attribute_initialisation_option_Noattribute_initialisation* Noattribute_initialisation ();
class impl_attribute_initialisation_option_Yesattribute_initialisation* Yesattribute_initialisation (Cexpression);
Cexpression NilCexpression();
Cexpression ConsCexpression(Cexpression_elem,Cexpression);
class impl_Cexpression_elem_CExpressionPart* CExpressionPart (casestring);
class impl_Cexpression_elem_CExpressionDollarvar* CExpressionDollarvar (INT);
class impl_Cexpression_elem_CExpressionNl* CExpressionNl ();
class impl_Cexpression_elem_CExpressionDQ* CExpressionDQ (CexpressionDQ);
class impl_Cexpression_elem_CExpressionSQ* CExpressionSQ (CexpressionSQ);
class impl_Cexpression_elem_CExpressionPack* CExpressionPack (Cexpression);
class impl_Cexpression_elem_CExpressionArray* CExpressionArray (Cexpression);
CexpressionDQ NilCexpressionDQ();
CexpressionDQ ConsCexpressionDQ(CexpressionDQ_elem,CexpressionDQ);
class impl_CexpressionDQ_elem_CExpressionDQPart* CExpressionDQPart (casestring);
class impl_CexpressionDQ_elem_CExpressionDQNl* CExpressionDQNl ();
CexpressionSQ NilCexpressionSQ();
CexpressionSQ ConsCexpressionSQ(CexpressionSQ_elem,CexpressionSQ);
class impl_CexpressionSQ_elem_CExpressionSQPart* CExpressionSQPart (casestring);
class impl_CexpressionSQ_elem_CExpressionSQNl* CExpressionSQNl ();
idCexpressions NilidCexpressions();
idCexpressions ConsidCexpressions(idCexpression,idCexpressions);
class impl_idCexpression_IdCexpression* IdCexpression (ID, Cexpression);
Ctexts NilCtexts();
Ctexts ConsCtexts(Ctext,Ctexts);
includefiles Nilincludefiles();
includefiles Consincludefiles(includefile,includefiles);
class impl_includefile_IncludeFile* IncludeFile (casestring);
includedeclarations Nilincludedeclarations();
includedeclarations Consincludedeclarations(includedeclaration,includedeclarations);
class impl_includedeclaration_IncludeDeclaration* IncludeDeclaration (casestring);
rwdeclarations Nilrwdeclarations();
rwdeclarations Consrwdeclarations(rwdeclaration,rwdeclarations);
class impl_rwdeclaration_RwDeclaration* RwDeclaration (outmostpatterns, rewriteclauses);
rewriteclauses Nilrewriteclauses();
rewriteclauses Consrewriteclauses(rewriteclause,rewriteclauses);
class impl_rewriteclause_RewriteClause* RewriteClause (viewnames, term);
patternchains Nilpatternchains();
patternchains Conspatternchains(patternchain,patternchains);
patternchain Nilpatternchain();
patternchain Conspatternchain(patternchainitem,patternchain);
outmostpatterns Niloutmostpatterns();
outmostpatterns Consoutmostpatterns(outmostpattern,outmostpatterns);
class impl_patternchainitem_PatternchainitemOutmost* PatternchainitemOutmost (outmostpattern);
class impl_patternchainitem_PatternchainitemGroup* PatternchainitemGroup (patternchains);
class impl_patternchainitem_PatternchainitemDollarid* PatternchainitemDollarid (ID);
class impl_outmostpattern_OPOperatorWildcard* OPOperatorWildcard (ID, Cexpression);
class impl_outmostpattern_OPOperator* OPOperator (ID, patterns, Cexpression);
class impl_outmostpattern_OPNonLeafVariable* OPNonLeafVariable (ID, outmostpattern);
class impl_outmostpattern_OPWildcard* OPWildcard (Cexpression);
class impl_outmostpattern_OPDefault* OPDefault (Cexpression);
class impl_pattern_PVariable* PVariable (ID);
class impl_pattern_POperator* POperator (ID, patterns);
class impl_pattern_PNonLeafVariable* PNonLeafVariable (ID, pattern);
class impl_pattern_PWildcard* PWildcard ();
class impl_pattern_PStringLiteral* PStringLiteral (CexpressionDQ);
class impl_pattern_PIntLiteral* PIntLiteral (INT);
patterns Nilpatterns();
patterns Conspatterns(pattern,patterns);
class impl_term_TVariable* TVariable (ID);
class impl_term_TOperator* TOperator (ID, terms);
class impl_term_TMethod* TMethod (term, ID, terms);
class impl_term_TMethodDot* TMethodDot (term, ID, terms);
class impl_term_TMemberVar* TMemberVar (term, ID);
class impl_term_TMemberVarDot* TMemberVarDot (term, ID);
class impl_term_TCTerm* TCTerm (CexpressionSQ);
class impl_term_TStringLiteral* TStringLiteral (CexpressionDQ);
class impl_term_TIntLiteral* TIntLiteral (INT);
terms Nilterms();
terms Consterms(term,terms);
fnfiles Nilfnfiles();
fnfiles Consfnfiles(fnfile,fnfiles);
class impl_fnfile_FnFile* FnFile (casestring);
fndeclarations Nilfndeclarations();
fndeclarations Consfndeclarations(fndeclaration,fndeclarations);
class impl_fndeclaration_FnAcDeclaration* FnAcDeclaration (ac_declaration_specifiers, ac_declarator, ac_declaration_list, ac_opt_base_init_list, Ctext, ID, fnclass);
class impl_fndeclaration_AcMemberDeclaration* AcMemberDeclaration (ac_declaration_specifiers, ac_declarator, ac_constant_expression_option, fnclass);
class impl_fnclass_GlobalFn* GlobalFn ();
class impl_fnclass_StaticFn* StaticFn (casestring);
class impl_fnclass_MemberFn* MemberFn ();
class impl_fnclass_ConstructorFn* ConstructorFn ();
class impl_fnclass_DestructorFn* DestructorFn ();
class impl_fnclass_ConvOperatorFn* ConvOperatorFn ();
Ctext NilCtext();
Ctext ConsCtext(Ctext_elem,Ctext);
class impl_Ctext_elem_CTextLine* CTextLine (casestring);
class impl_Ctext_elem_CTextDollarVar* CTextDollarVar (INT);
class impl_Ctext_elem_CTextNl* CTextNl (integer);
class impl_Ctext_elem_CTextCexpressionDQ* CTextCexpressionDQ (CexpressionDQ);
class impl_Ctext_elem_CTextCexpressionSQ* CTextCexpressionSQ (CexpressionSQ);
class impl_Ctext_elem_CTextCbody* CTextCbody (Ctext);
class impl_Ctext_elem_CTextForeachexpression* CTextForeachexpression (patternchain, idCexpressions, withexpressions, Ctext, foreach_after);
class impl_Ctext_elem_CTextWithexpression* CTextWithexpression (withexpressions, withcases, contextinfo);
class impl_foreach_after_NoForeachAfter* NoForeachAfter ();
class impl_foreach_after_ForeachAfter* ForeachAfter (patternchain, idCexpressions, withexpressions, Ctext);
class impl_contextinfo_InForeachContext* InForeachContext (patternchain);
class impl_contextinfo_NotInForeachContext* NotInForeachContext ();
withexpressions Nilwithexpressions();
withexpressions Conswithexpressions(withexpression,withexpressions);
class impl_withexpression_WEVariable* WEVariable (ID);
class impl_withexpression_WECexpression* WECexpression (Cexpression);
withcases Nilwithcases();
withcases Conswithcases(withcase,withcases);
class impl_withcase_Withcase* Withcase (patternchains, Ctext);
unparsedeclarations Nilunparsedeclarations();
unparsedeclarations Consunparsedeclarations(unparsedeclaration,unparsedeclarations);
class impl_unparsedeclaration_UnparseDeclaration* UnparseDeclaration (outmostpatterns, unparseclauses);
unparseclauses Nilunparseclauses();
unparseclauses Consunparseclauses(unparseclause,unparseclauses);
class impl_unparseclause_UnparseClause* UnparseClause (viewnames, unparseitems);
viewnames Nilviewnames();
viewnames Consviewnames(ID,viewnames);
unparseitems Nilunparseitems();
unparseitems Consunparseitems(unparseitem,unparseitems);
class impl_unparseitem_UnpStr* UnpStr (languageoption, CexpressionDQ, viewnameoption);
class impl_unparseitem_UnpSubexpr* UnpSubexpr (languageoption, unpsubterm, viewnameoption);
class impl_unparseitem_UnpCtext* UnpCtext (languageoption, Ctext);
class impl_unparseitem_UnpBody* UnpBody (languageoption, unparseitems);
class impl_unparseitem_UViewVarDecl* UViewVarDecl (ID, ID, Cexpression);
class impl_unpsubterm_UnpSubTerm* UnpSubTerm (ID);
class impl_unpsubterm_UnpDollarvarTerm* UnpDollarvarTerm (INT);
class impl_unpsubterm_UnpSubAttr* UnpSubAttr (ID, unpattributes);
class impl_unpsubterm_UnpDollarvarAttr* UnpDollarvarAttr (INT, unpattributes);
class impl_unpsubterm_UnpCastedVariable* UnpCastedVariable (ID, ID);
unpattributes Nilunpattributes();
unpattributes Consunpattributes(ID,unpattributes);
class impl_viewnameoption_NoViewname* NoViewname ();
class impl_viewnameoption_YesViewname* YesViewname (ID);
class impl_languageoption_NoLanguagename* NoLanguagename ();
class impl_languageoption_LanguageList* LanguageList (languagenames);
languagenames Nillanguagenames();
languagenames Conslanguagenames(ID,languagenames);
class impl_fileline_FileLine* FileLine (casestring _file=0, int _line=0);
class impl_fileline_NoFileLine* NoFileLine ();
class impl_fileline_PosNoFileLine* PosNoFileLine ();
scopetypefilelinestack Nilscopetypefilelinestack();
scopetypefilelinestack Consscopetypefilelinestack(scopetypefileline,scopetypefilelinestack);
class impl_scopetypefileline_ScopeTypeFileLine* ScopeTypeFileLine (integer, IDtype, casestring, integer);
class impl_IDtype_ITUnknown* ITUnknown ();
class impl_IDtype_ITPredefinedPhylum* ITPredefinedPhylum (phylumdeclaration);
class impl_IDtype_ITUserPhylum* ITUserPhylum (phylumdeclaration);
class impl_IDtype_ITPredefinedOperator* ITPredefinedOperator (alternative, ID);
class impl_IDtype_ITUserOperator* ITUserOperator (alternative, ID);
class impl_IDtype_ITPredefinedStorageClass* ITPredefinedStorageClass ();
class impl_IDtype_ITStorageClass* ITStorageClass ();
class impl_IDtype_ITPredefinedUView* ITPredefinedUView ();
class impl_IDtype_ITUserUView* ITUserUView ();
class impl_IDtype_ITUViewVar* ITUViewVar ();
class impl_IDtype_ITPredefinedRView* ITPredefinedRView ();
class impl_IDtype_ITUserRView* ITUserRView ();
class impl_IDtype_ITUserFunction* ITUserFunction (fnclass);
class impl_IDtype_ITPatternVariable* ITPatternVariable (ID, integer);
class impl_IDtype_ITLanguageName* ITLanguageName (integer);
operators Niloperators();
operators Consoperators(ID,operators);
phyla Nilphyla();
phyla Consphyla(ID,phyla);
variables Nilvariables();
variables Consvariables(ID,variables);
class impl_dollarvarstatus_DVAllowed* DVAllowed ();
class impl_dollarvarstatus_DVDisallowed* DVDisallowed ();
class impl_tribool_Equal* Equal ();
class impl_tribool_Smaller* Smaller ();
class impl_tribool_Bigger* Bigger ();
patternrepresentations Nilpatternrepresentations();
patternrepresentations Conspatternrepresentations(patternrepresentation,patternrepresentations);
patternrepresentation Nilpatternrepresentation();
patternrepresentation Conspatternrepresentation(elem_patternrepresentation,patternrepresentation);
class impl_elem_patternrepresentation_PRBinding* PRBinding (path, ID);
class impl_elem_patternrepresentation_PRVarPredicate* PRVarPredicate (paths, ID, patternrepresentation);
class impl_elem_patternrepresentation_PROperPredicate* PROperPredicate (path, ID);
class impl_elem_patternrepresentation_PRUserPredicate* PRUserPredicate (Cexpression);
class impl_elem_patternrepresentation_PRNonLeafBinding* PRNonLeafBinding (path, ID, patternrepresentation);
class impl_elem_patternrepresentation_PRWildcard* PRWildcard (path);
class impl_elem_patternrepresentation_PRDefault* PRDefault ();
class impl_elem_patternrepresentation_PRStringLiteral* PRStringLiteral (path, CexpressionDQ);
class impl_elem_patternrepresentation_PRIntLiteral* PRIntLiteral (path, INT);
path Nilpath();
path Conspath(integer,path);
paths Nilpaths();
paths Conspaths(path,paths);
argsnumbers Nilargsnumbers();
argsnumbers Consargsnumbers(integer,argsnumbers);
rewriterulesinfo Nilrewriterulesinfo();
rewriterulesinfo Consrewriterulesinfo(rewriteruleinfo,rewriterulesinfo);
class impl_rewriteruleinfo_Rewriteruleinfo* Rewriteruleinfo (patternrepresentation, patternrepresentation, rewriteclause);
withcasesinfo Nilwithcasesinfo();
withcasesinfo Conswithcasesinfo(withcaseinfo,withcasesinfo);
class impl_withcaseinfo_Withcaseinfo* Withcaseinfo (patternrepresentation, patternrepresentation, Ctext);
rewriteviewsinfo Nilrewriteviewsinfo();
rewriteviewsinfo Consrewriteviewsinfo(rewriteviewinfo,rewriteviewsinfo);
class impl_rewriteviewinfo_Rewriteviewinfo* Rewriteviewinfo (ID, rewriterulesinfo);
unparseviewsinfo Nilunparseviewsinfo();
unparseviewsinfo Consunparseviewsinfo(unparseviewinfo,unparseviewsinfo);
class impl_unparseviewinfo_Unparseviewinfo* Unparseviewinfo (ID, unparsedeclsinfo);
unparsedeclsinfo Nilunparsedeclsinfo();
unparsedeclsinfo Consunparsedeclsinfo(unparsedeclinfo,unparsedeclsinfo);
class impl_unparsedeclinfo_Unparsedeclinfo* Unparsedeclinfo (patternrepresentation, patternrepresentation, unparseclause);
class impl_ac_declaration_AcDeclaration* AcDeclaration (ac_declaration_specifiers, ac_init_declarator_list);
ac_declaration_list Nilac_declaration_list();
ac_declaration_list Consac_declaration_list(ac_declaration,ac_declaration_list);
ac_declaration_specifiers Nilac_declaration_specifiers();
ac_declaration_specifiers Consac_declaration_specifiers(ac_declaration_specifier,ac_declaration_specifiers);
class impl_ac_declaration_specifier_AcDeclSpecStorageSpec* AcDeclSpecStorageSpec (ac_storage_class_specifier);
class impl_ac_declaration_specifier_AcDeclSpecTypeSpec* AcDeclSpecTypeSpec (ac_type_specifier);
class impl_ac_declaration_specifier_AcDeclSpecTypeQual* AcDeclSpecTypeQual (ac_type_qualifier);
class impl_ac_storage_class_specifier_AcAuto* AcAuto ();
class impl_ac_storage_class_specifier_AcRegister* AcRegister ();
class impl_ac_storage_class_specifier_AcStatic* AcStatic ();
class impl_ac_storage_class_specifier_AcExtern* AcExtern ();
class impl_ac_storage_class_specifier_AcTypedef* AcTypedef ();
class impl_ac_storage_class_specifier_AcVirtual* AcVirtual ();
class impl_ac_type_specifier_AcTypeSpec* AcTypeSpec (ID);
class impl_ac_type_qualifier_AcConst* AcConst ();
class impl_ac_type_qualifier_AcVolatile* AcVolatile ();
class impl_ac_type_qualifier_AcUnsigned* AcUnsigned ();
class impl_ac_type_qualifier_AcNoQualifier* AcNoQualifier ();
ac_init_declarator_list Nilac_init_declarator_list();
ac_init_declarator_list Consac_init_declarator_list(ac_init_declarator,ac_init_declarator_list);
class impl_ac_init_declarator_AcInitDecl* AcInitDecl (ac_declarator);
class impl_ac_declarator_AcDeclarator* AcDeclarator (ac_pointer_option, ac_ref_option, ac_direct_declarator);
class impl_ac_direct_declarator_AcDirectDeclId* AcDirectDeclId (ID);
class impl_ac_direct_declarator_AcDirectDeclPack* AcDirectDeclPack (ac_declarator);
class impl_ac_direct_declarator_AcDirectDeclArray* AcDirectDeclArray (ac_direct_declarator, ac_constant_expression_option);
class impl_ac_direct_declarator_AcDirectDeclProto* AcDirectDeclProto (ac_direct_declarator, ac_parameter_type_list);
class impl_ac_direct_declarator_AcQualifiedDeclProto* AcQualifiedDeclProto (ac_class_qualifier_list, ac_direct_declarator, ac_parameter_type_list, ac_type_qualifier);
class impl_ac_direct_declarator_AcMemberDecl* AcMemberDecl (ID, ID, ac_constant_expression_list);
class impl_ac_direct_declarator_AcConvOperatorDecl* AcConvOperatorDecl (ID, ID);
class impl_ac_direct_declarator_AcOperatorDeclId* AcOperatorDeclId (ac_operator_name);
class impl_ac_pointer_option_Nopointer* Nopointer ();
class impl_ac_pointer_option_Yespointer* Yespointer (ac_pointer);
class impl_ac_pointer_AcPointerNil* AcPointerNil (ac_type_qualifier_list);
class impl_ac_pointer_AcPointerCons* AcPointerCons (ac_type_qualifier_list, ac_pointer);
class impl_ac_ref_option_AcNoRef* AcNoRef ();
class impl_ac_ref_option_AcRef* AcRef ();
class impl_ac_operator_name_AcOperatorName* AcOperatorName (casestring);
ac_class_qualifier_help_list Nilac_class_qualifier_help_list();
ac_class_qualifier_help_list Consac_class_qualifier_help_list(ac_direct_declarator,ac_class_qualifier_help_list);
ac_class_qualifier_list Nilac_class_qualifier_list();
ac_class_qualifier_list Consac_class_qualifier_list(ID,ac_class_qualifier_list);
ac_type_qualifier_list Nilac_type_qualifier_list();
ac_type_qualifier_list Consac_type_qualifier_list(ac_type_qualifier,ac_type_qualifier_list);
class impl_ac_parameter_type_list_AcParList* AcParList (ac_parameter_list);
class impl_ac_parameter_type_list_AcParList3Dot* AcParList3Dot (ac_parameter_list);
ac_parameter_list Nilac_parameter_list();
ac_parameter_list Consac_parameter_list(ac_parameter_declaration,ac_parameter_list);
class impl_ac_parameter_declaration_AcParDeclDecl* AcParDeclDecl (ac_declaration_specifiers, ac_declarator, ac_constant_expression_option);
class impl_ac_parameter_declaration_AcParDeclAbsdecl* AcParDeclAbsdecl (ac_declaration_specifiers, ac_abstract_declarator, ac_constant_expression_option);
ac_identifier_list Nilac_identifier_list();
ac_identifier_list Consac_identifier_list(ID,ac_identifier_list);
class impl_ac_abstract_declarator_AcAbsdeclPointer* AcAbsdeclPointer (ac_pointer);
class impl_ac_abstract_declarator_AcAbsdeclDirdecl* AcAbsdeclDirdecl (ac_pointer_option, ac_direct_abstract_declarator);
class impl_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator* Noac_direct_abstract_declarator ();
class impl_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator* Yesac_direct_abstract_declarator (ac_direct_abstract_declarator);
class impl_ac_direct_abstract_declarator_AcDirAbsdeclPack* AcDirAbsdeclPack (ac_abstract_declarator);
class impl_ac_direct_abstract_declarator_AcDirAbsdeclArray* AcDirAbsdeclArray (ac_direct_abstract_declarator_option, ac_constant_expression_option);
class impl_ac_direct_abstract_declarator_AcDirAbsdeclFn* AcDirAbsdeclFn (ac_direct_abstract_declarator_option, ac_parameter_type_list);
class impl_ac_constant_expression_option_Yesac_constant_expression* Yesac_constant_expression (ac_constant_expression);
class impl_ac_constant_expression_option_Noac_constant_expression* Noac_constant_expression ();
class impl_ac_constant_expression_AcConstExpr* AcConstExpr (Cexpression);
ac_constant_expression_list Nilac_constant_expression_list();
ac_constant_expression_list Consac_constant_expression_list(ac_constant_expression,ac_constant_expression_list);
class impl_ac_opt_base_init_list_AcNoBaseInit* AcNoBaseInit ();
class impl_ac_opt_base_init_list_AcYesBaseInit* AcYesBaseInit (ac_base_init_list);
ac_base_init_list Nilac_base_init_list();
ac_base_init_list Consac_base_init_list(ac_base_init,ac_base_init_list);
class impl_ac_base_init_AcBaseInit* AcBaseInit (ID, ac_constant_expression_list);
baseclass_declarations Nilbaseclass_declarations();
baseclass_declarations Consbaseclass_declarations(baseclass_decl,baseclass_declarations);
class impl_baseclass_decl_BaseClassDecl* BaseClassDecl (ID, baseclass_list);
baseclass_list Nilbaseclass_list();
baseclass_list Consbaseclass_list(ID,baseclass_list);
class impl_error_Fatal* Fatal (fileline, problem);
class impl_error_NonFatal* NonFatal (fileline, problem);
class impl_error_Warning* Warning (fileline, problem);
class impl_problem_Problem1* Problem1 (casestring);
class impl_problem_Problem1ID* Problem1ID (casestring, ID);
class impl_problem_Problem1tID* Problem1tID (casestring, ID);
class impl_problem_Problem1we* Problem1we (casestring, withexpression);
class impl_problem_Problem1ID1ID* Problem1ID1ID (casestring, ID, casestring, ID);
class impl_problem_Problem1t1ID* Problem1t1ID (casestring, IDtype, casestring, ID);
class impl_problem_Problem1INT* Problem1INT (casestring, INT);
class impl_problem_Problem1int1* Problem1int1 (casestring, integer, casestring);
class impl_problem_Problem1INT1ID* Problem1INT1ID (casestring, INT, casestring, ID);
class impl_problem_Problem1ID1ID1ID* Problem1ID1ID1ID (casestring, ID, casestring, ID, casestring, ID);
class impl_problem_Problem1INT1ID1ID* Problem1INT1ID1ID (casestring, INT, casestring, ID, casestring, ID);
class impl_problem_Problem1storageoption1ID* Problem1storageoption1ID (casestring, storageoption, casestring, ID);
class impl_problem_Problem2* Problem2 (casestring, casestring);
class impl_problem_Problem3* Problem3 (casestring, casestring, casestring);
class impl_problem_Problem3int1* Problem3int1 (casestring, casestring, casestring, integer, casestring);
class impl_problem_Problem4* Problem4 (casestring, casestring, casestring, casestring);
class impl_problem_Problem5* Problem5 (casestring, casestring, casestring, casestring, casestring);
class impl_problem_Problem6* Problem6 (casestring, casestring, casestring, casestring, casestring, casestring);
addedphylumdeclarations Niladdedphylumdeclarations();
addedphylumdeclarations Consaddedphylumdeclarations(addedphylumdeclaration,addedphylumdeclarations);
class impl_addedphylumdeclaration_AddedPhylumdeclaration* AddedPhylumdeclaration (uniqID);
countedphylumdeclarations Nilcountedphylumdeclarations();
countedphylumdeclarations Conscountedphylumdeclarations(countedphylumdeclaration,countedphylumdeclarations);
class impl_countedphylumdeclaration_CountedPhylumdeclaration* CountedPhylumdeclaration (uniqID);
class impl_charruns_Newlines* Newlines ();
class impl_charruns_QuotedNewlines* QuotedNewlines ();
class impl_charruns_Stars* Stars ();
bindingidmarks Nilbindingidmarks();
bindingidmarks Consbindingidmarks(bindingidmark,bindingidmarks);
class impl_bindingidmark_BindingIdMark* BindingIdMark (uniqID);

//namespace Phylum {

class impl_abstract_phylum {
public:
    virtual enum_operators prod_sel() const =0;
    static const enum_phyla phylum_sel_;
    enum_phyla phylum() const;
    const char* phylum_name() const;
    const char* op_name() const;
    virtual abstract_phylum subphylum(int) const;
    virtual void set_subphylum(int, abstract_phylum);
    void free(bool recursive=true);
    bool eq(c_abstract_phylum) const;
    void print();
    void fprint(FILE *);
    abstract_phylum copy(bool kc_copy_attributes) const;
    void unparse(printer_functor pf, uview uv)
	{ do_unparse(pf, uv); }
    void unparse(printer_function opf, uview uv);
    virtual abstract_phylum rewrite(rview v) { return do_rewrite(v); }
    virtual abstract_phylum do_rewrite(rview) { return this;}
    // called if a subphylum of an op is rewritten and a new op is created by default rule
    virtual void rewrite_members(abstract_phylum from) {} 
    virtual void post_create(){}
    virtual ~impl_abstract_phylum() { }
private:
    virtual void do_unparse(printer_functor, uview) =0;
protected:
    virtual void default_unparse(printer_functor, uview);
};


class impl_abstract_list: public impl_abstract_phylum{
private:
    void fprint_list(FILE *);
    friend class impl_abstract_phylum;
protected:
    abstract_phylum do_concat(c_abstract_phylum other, enum_operators) const;
    abstract_phylum do_reverse(c_abstract_phylum tail, enum_operators) const;
    abstract_phylum do_map(abstract_phylum (*kc_fp)(abstract_phylum), enum_operators);
    abstract_phylum do_filter(bool (*kc_fp)(abstract_phylum), enum_operators);
    abstract_list   do_append(abstract_phylum, abstract_list);
    abstract_phylum do_merge(abstract_list,abstract_phylum (*kc_fp)(abstract_phylum,abstract_phylum), enum_operators);
    abstract_phylum do_reduce(abstract_phylum neutral, abstract_phylum (*kc_fp)(abstract_phylum,abstract_phylum));
public:
    virtual bool is_nil() const =0;
    virtual abstract_list reverse() const =0;
    int length() const;
    abstract_phylum last() const;
    // Non-virtual, non-existing... Type must be known exactly anyway because
    // of the function given as a parameter
    //virtual abstract_list map( abstract_phylum (*)( abstract_phylum )) =0;
    //virtual abstract_list filter(bool (*)(abstract_phylum)) =0;
    void freelist();
};

abstract_phylum kc_create(enum_operators createOp, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0);
abstract_phylum kc_create(enum_operators createOp, const std::vector<abstract_phylum>& kc_ps);
abstract_phylum& attributeOf(abstract_phylum kc_p, int no);

class impl_nocasestring_NoCaseStr;
typedef impl_nocasestring_NoCaseStr impl_nocasestring;
class impl_nocasestring_NoCaseStr:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel_NoCaseStr; }
    static const enum_phyla phylum_sel_;
private:
    explicit impl_nocasestring_NoCaseStr(const kc_char_t*);
    void make_own(int length);
    friend nocasestring mknocasestring(const kc_char_t*, int);
public:
    ~impl_nocasestring_NoCaseStr() {
#if defined (_MSC_VER) && _MSC_VER<1300
	delete [] (kc_char_t*)name;
#else
	delete [] name;
#endif
    }

    nocasestring rewrite( rview )
	{ return this; }
    kc_char_t const* name;
private:
    void do_unparse(printer_functor, uview);
};
class impl_casestring__Str;
typedef impl_casestring__Str impl_casestring;
class impl_casestring__Str:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Str; }
    static const enum_phyla phylum_sel_;
private:
    explicit impl_casestring__Str(const kc_char_t*);
    void make_own(int length);
    friend casestring mkcasestring(const kc_char_t*, int);
public:
    ~impl_casestring__Str() {
#if defined (_MSC_VER) && _MSC_VER<1300
	delete [] (kc_char_t*)name;
#else
	delete [] name;
#endif
    }

    casestring rewrite( rview )
	{ return this; }
    kc_char_t const* name;
private:
    void do_unparse(printer_functor, uview);
};
class impl_real__Real;
typedef impl_real__Real impl_real;
class impl_real__Real:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Real; }
    static const enum_phyla phylum_sel_;
    explicit impl_real__Real(REAL _value);

    real rewrite( rview )
	{ return this; }
    REAL value;
private:
    void do_unparse(printer_functor, uview);
};
class impl_integer__Int;
typedef impl_integer__Int impl_integer;
class impl_integer__Int:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Int; }
    static const enum_phyla phylum_sel_;
    explicit impl_integer__Int(INTEGER _value);

    integer rewrite( rview )
	{ return this; }
    INTEGER value;
private:
    void do_unparse(printer_functor, uview);
};
class impl_voidptr__VoidPtr;
typedef impl_voidptr__VoidPtr impl_voidptr;
class impl_voidptr__VoidPtr:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__VoidPtr; }
    static const enum_phyla phylum_sel_;
    explicit impl_voidptr__VoidPtr(void* _pointer);

    voidptr rewrite( rview )
	{ return this; }
    void* pointer;
private:
    void do_unparse(printer_functor, uview);
};
class impl_uniqID: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    IDtype type;
    int line;
    casestring file;
    scopetypefilelinestack scopeinfo;
    uniqID rewrite(rview) =0;
};
class impl_uniqID_Str:public impl_uniqID{
public:
    enum_operators prod_sel() const
	{ return sel_Str; }
    explicit impl_uniqID_Str(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    uniqID rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ID: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    IDtype type;
    casestring named_subphylum;
    int line;
    casestring file;
    ID rewrite(rview) =0;
};
class impl_ID_Id:public impl_ID{
public:
    enum_operators prod_sel() const
	{ return sel_Id; }
    explicit impl_ID_Id(uniqID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ID rewrite( rview );
    impl_uniqID* uniqID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_INT: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    INT rewrite(rview) =0;
};
class impl_INT_Int:public impl_INT{
public:
    enum_operators prod_sel() const
	{ return sel_Int; }
    explicit impl_INT_Int(integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    INT rewrite( rview );
    impl_integer* integer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_STRING: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    STRING rewrite(rview) =0;
};
class impl_STRING_String:public impl_STRING{
public:
    enum_operators prod_sel() const
	{ return sel_String; }
    explicit impl_STRING_String(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    STRING rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_phylumdeclarationsroot: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    phylumdeclarationsroot rewrite(rview) =0;
};
class impl_phylumdeclarationsroot_PhylumDeclarations:public impl_phylumdeclarationsroot{
public:
    enum_operators prod_sel() const
	{ return sel_PhylumDeclarations; }
    explicit impl_phylumdeclarationsroot_PhylumDeclarations(phylumdeclarations);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    phylumdeclarationsroot rewrite( rview );
    impl_phylumdeclarations* phylumdeclarations_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_phylumdeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilphylumdeclarations: sel_Consphylumdeclarations;
    }
    explicit impl_phylumdeclarations(phylumdeclaration = 0, phylumdeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend phylumdeclarations concat(c_phylumdeclarations, c_phylumdeclarations);
    phylumdeclarations reverse() const;
    phylumdeclarations rewrite(rview);
    phylumdeclaration last() const;
    phylumdeclarations append(phylumdeclaration);
    phylumdeclarations map(phylumdeclaration (*)(phylumdeclaration));
    phylumdeclarations filter( bool (*)(phylumdeclaration));
    phylumdeclarations merge( phylumdeclarations, phylumdeclaration (*)(phylumdeclaration, phylumdeclaration));
    phylumdeclaration reduce( phylumdeclaration, phylumdeclaration (*)(phylumdeclaration, phylumdeclaration));
    bool is_nil() const;
    phylumdeclaration phylumdeclaration_1;
    phylumdeclarations phylumdeclarations_1;
private:
    impl_phylumdeclarations* nil_rewrite(rview);
    impl_phylumdeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_phylumnames: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilphylumnames: sel_Consphylumnames;
    }
    explicit impl_phylumnames(ID = 0, phylumnames = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend phylumnames concat(c_phylumnames, c_phylumnames);
    phylumnames reverse() const;
    phylumnames rewrite(rview);
    ID last() const;
    phylumnames append(ID);
    phylumnames map(ID (*)(ID));
    phylumnames filter( bool (*)(ID));
    phylumnames merge( phylumnames, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    phylumnames phylumnames_1;
private:
    impl_phylumnames* nil_rewrite(rview);
    impl_phylumnames* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_phylumdeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int marked;
    fndeclarations additional_members;
    baseclass_list base_classes;
    phylumdeclaration rewrite(rview) =0;
};
class impl_phylumdeclaration_PhylumDeclaration:public impl_phylumdeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_PhylumDeclaration; }
    explicit impl_phylumdeclaration_PhylumDeclaration(ID, storageoption, productionblock, Ccode_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    phylumdeclaration rewrite( rview );
    impl_ID* ID_1;
    impl_storageoption* storageoption_1;
    impl_productionblock* productionblock_1;
    impl_Ccode_option* Ccode_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_storageoption: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    storageoption rewrite(rview) =0;
};
class impl_storageoption_PositiveStorageOption:public impl_storageoption{
public:
    enum_operators prod_sel() const
	{ return sel_PositiveStorageOption; }
    explicit impl_storageoption_PositiveStorageOption(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    storageoption rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_storageoption_NegativeStorageOption:public impl_storageoption{
public:
    enum_operators prod_sel() const
	{ return sel_NegativeStorageOption; }
    explicit impl_storageoption_NegativeStorageOption(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    storageoption rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_storageoption_NoStorageOption:public impl_storageoption{
public:
    enum_operators prod_sel() const
	{ return sel_NoStorageOption; }
    explicit impl_storageoption_NoStorageOption();

    storageoption rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_storageclasses: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    phylumnames phyla;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilstorageclasses: sel_Consstorageclasses;
    }
    explicit impl_storageclasses(ID = 0, storageclasses = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend storageclasses concat(c_storageclasses, c_storageclasses);
    storageclasses reverse() const;
    storageclasses rewrite(rview);
    ID last() const;
    storageclasses append(ID);
    storageclasses map(ID (*)(ID));
    storageclasses filter( bool (*)(ID));
    storageclasses merge( storageclasses, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    storageclasses storageclasses_1;
private:
    impl_storageclasses* nil_rewrite(rview);
    impl_storageclasses* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_productionblock: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    productionblock rewrite(rview) =0;
};
class impl_productionblock_PredefinedAlternatives:public impl_productionblock{
public:
    enum_operators prod_sel() const
	{ return sel_PredefinedAlternatives; }
    explicit impl_productionblock_PredefinedAlternatives(alternatives);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    productionblock rewrite( rview );
    impl_alternatives* alternatives_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_productionblock_NonlistAlternatives:public impl_productionblock{
public:
    enum_operators prod_sel() const
	{ return sel_NonlistAlternatives; }
    explicit impl_productionblock_NonlistAlternatives(alternatives);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    productionblock rewrite( rview );
    impl_alternatives* alternatives_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_productionblock_ListAlternatives:public impl_productionblock{
public:
    enum_operators prod_sel() const
	{ return sel_ListAlternatives; }
    explicit impl_productionblock_ListAlternatives(alternatives, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    productionblock rewrite( rview );
    impl_alternatives* alternatives_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_productionblock_Emptyproductionblock:public impl_productionblock{
public:
    enum_operators prod_sel() const
	{ return sel_Emptyproductionblock; }
    explicit impl_productionblock_Emptyproductionblock();

    productionblock rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_alternatives: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilalternatives: sel_Consalternatives;
    }
    explicit impl_alternatives(alternative = 0, alternatives = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend alternatives concat(c_alternatives, c_alternatives);
    alternatives reverse() const;
    alternatives rewrite(rview);
    alternative last() const;
    alternatives append(alternative);
    alternatives map(alternative (*)(alternative));
    alternatives filter( bool (*)(alternative));
    alternatives merge( alternatives, alternative (*)(alternative, alternative));
    alternative reduce( alternative, alternative (*)(alternative, alternative));
    bool is_nil() const;
    alternative alternative_1;
    alternatives alternatives_1;
private:
    impl_alternatives* nil_rewrite(rview);
    impl_alternatives* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_alternative: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    rewriterulesinfo rewriteinfo;
    unparsedeclsinfo unparseinfo;
    fndeclarations additional_members;
    baseclass_list base_classes;
    alternative rewrite(rview) =0;
};
class impl_alternative_Alternative:public impl_alternative{
public:
    enum_operators prod_sel() const
	{ return sel_Alternative; }
    explicit impl_alternative_Alternative(ID, arguments);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    alternative rewrite( rview );
    impl_ID* ID_1;
    impl_arguments* arguments_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_arguments: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    int seqnr;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilarguments: sel_Consarguments;
    }
    explicit impl_arguments(ID = 0, arguments = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend arguments concat(c_arguments, c_arguments);
    arguments reverse() const;
    arguments rewrite(rview);
    ID last() const;
    arguments append(ID);
    arguments map(ID (*)(ID));
    arguments filter( bool (*)(ID));
    arguments merge( arguments, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    arguments arguments_1;
private:
    impl_arguments* nil_rewrite(rview);
    impl_arguments* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_argument: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    argument rewrite(rview) =0;
};
class impl_argument_Argument:public impl_argument{
public:
    enum_operators prod_sel() const
	{ return sel_Argument; }
    explicit impl_argument_Argument(ID, integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    argument rewrite( rview );
    impl_ID* ID_1;
    impl_integer* integer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ccode_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    Ccode_option rewrite(rview) =0;
};
class impl_Ccode_option_CcodeOption:public impl_Ccode_option{
public:
    enum_operators prod_sel() const
	{ return sel_CcodeOption; }
    explicit impl_Ccode_option_CcodeOption(attributes, Ctexts);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ccode_option rewrite( rview );
    impl_attributes* attributes_1;
    impl_Ctexts* Ctexts_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_attributes: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilattributes: sel_Consattributes;
    }
    explicit impl_attributes(attribute = 0, attributes = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend attributes concat(c_attributes, c_attributes);
    attributes reverse() const;
    attributes rewrite(rview);
    attribute last() const;
    attributes append(attribute);
    attributes map(attribute (*)(attribute));
    attributes filter( bool (*)(attribute));
    attributes merge( attributes, attribute (*)(attribute, attribute));
    attribute reduce( attribute, attribute (*)(attribute, attribute));
    bool is_nil() const;
    attribute attribute_1;
    attributes attributes_1;
private:
    impl_attributes* nil_rewrite(rview);
    impl_attributes* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_attribute: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    attribute rewrite(rview) =0;
};
class impl_attribute_Attribute:public impl_attribute{
public:
    enum_operators prod_sel() const
	{ return sel_Attribute; }
    explicit impl_attribute_Attribute(ID, ID, attribute_initialisation_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    attribute rewrite( rview );
    impl_ID* ID_1;
    impl_ID* ID_2;
    impl_attribute_initialisation_option* attribute_initialisation_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_attribute_initialisation_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    attribute_initialisation_option rewrite(rview) =0;
};
class impl_attribute_initialisation_option_Yesattribute_initialisation:public impl_attribute_initialisation_option{
public:
    enum_operators prod_sel() const
	{ return sel_Yesattribute_initialisation; }
    explicit impl_attribute_initialisation_option_Yesattribute_initialisation(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    attribute_initialisation_option rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_attribute_initialisation_option_Noattribute_initialisation:public impl_attribute_initialisation_option{
public:
    enum_operators prod_sel() const
	{ return sel_Noattribute_initialisation; }
    explicit impl_attribute_initialisation_option_Noattribute_initialisation();

    attribute_initialisation_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilCexpression: sel_ConsCexpression;
    }
    explicit impl_Cexpression(Cexpression_elem = 0, Cexpression = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend Cexpression concat(c_Cexpression, c_Cexpression);
    Cexpression reverse() const;
    Cexpression rewrite(rview);
    Cexpression_elem last() const;
    Cexpression append(Cexpression_elem);
    Cexpression map(Cexpression_elem (*)(Cexpression_elem));
    Cexpression filter( bool (*)(Cexpression_elem));
    Cexpression merge( Cexpression, Cexpression_elem (*)(Cexpression_elem, Cexpression_elem));
    Cexpression_elem reduce( Cexpression_elem, Cexpression_elem (*)(Cexpression_elem, Cexpression_elem));
    bool is_nil() const;
    Cexpression_elem Cexpression_elem_1;
    Cexpression Cexpression_1;
private:
    impl_Cexpression* nil_rewrite(rview);
    impl_Cexpression* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    Cexpression_elem rewrite(rview) =0;
};
class impl_Cexpression_elem_CExpressionArray:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionArray; }
    explicit impl_Cexpression_elem_CExpressionArray(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionPack:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionPack; }
    explicit impl_Cexpression_elem_CExpressionPack(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionSQ:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionSQ; }
    explicit impl_Cexpression_elem_CExpressionSQ(CexpressionSQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_CexpressionSQ* CexpressionSQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionDQ:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionDQ; }
    explicit impl_Cexpression_elem_CExpressionDQ(CexpressionDQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_CexpressionDQ* CexpressionDQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionNl:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionNl; }
    explicit impl_Cexpression_elem_CExpressionNl();

    Cexpression_elem rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionDollarvar:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionDollarvar; }
    explicit impl_Cexpression_elem_CExpressionDollarvar(INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Cexpression_elem_CExpressionPart:public impl_Cexpression_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionPart; }
    explicit impl_Cexpression_elem_CExpressionPart(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Cexpression_elem rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionDQ: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilCexpressionDQ: sel_ConsCexpressionDQ;
    }
    explicit impl_CexpressionDQ(CexpressionDQ_elem = 0, CexpressionDQ = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend CexpressionDQ concat(c_CexpressionDQ, c_CexpressionDQ);
    CexpressionDQ reverse() const;
    CexpressionDQ rewrite(rview);
    CexpressionDQ_elem last() const;
    CexpressionDQ append(CexpressionDQ_elem);
    CexpressionDQ map(CexpressionDQ_elem (*)(CexpressionDQ_elem));
    CexpressionDQ filter( bool (*)(CexpressionDQ_elem));
    CexpressionDQ merge( CexpressionDQ, CexpressionDQ_elem (*)(CexpressionDQ_elem, CexpressionDQ_elem));
    CexpressionDQ_elem reduce( CexpressionDQ_elem, CexpressionDQ_elem (*)(CexpressionDQ_elem, CexpressionDQ_elem));
    bool is_nil() const;
    CexpressionDQ_elem CexpressionDQ_elem_1;
    CexpressionDQ CexpressionDQ_1;
private:
    impl_CexpressionDQ* nil_rewrite(rview);
    impl_CexpressionDQ* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionDQ_elem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    CexpressionDQ_elem rewrite(rview) =0;
};
class impl_CexpressionDQ_elem_CExpressionDQNl:public impl_CexpressionDQ_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionDQNl; }
    explicit impl_CexpressionDQ_elem_CExpressionDQNl();

    CexpressionDQ_elem rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionDQ_elem_CExpressionDQPart:public impl_CexpressionDQ_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionDQPart; }
    explicit impl_CexpressionDQ_elem_CExpressionDQPart(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    CexpressionDQ_elem rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionSQ: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilCexpressionSQ: sel_ConsCexpressionSQ;
    }
    explicit impl_CexpressionSQ(CexpressionSQ_elem = 0, CexpressionSQ = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend CexpressionSQ concat(c_CexpressionSQ, c_CexpressionSQ);
    CexpressionSQ reverse() const;
    CexpressionSQ rewrite(rview);
    CexpressionSQ_elem last() const;
    CexpressionSQ append(CexpressionSQ_elem);
    CexpressionSQ map(CexpressionSQ_elem (*)(CexpressionSQ_elem));
    CexpressionSQ filter( bool (*)(CexpressionSQ_elem));
    CexpressionSQ merge( CexpressionSQ, CexpressionSQ_elem (*)(CexpressionSQ_elem, CexpressionSQ_elem));
    CexpressionSQ_elem reduce( CexpressionSQ_elem, CexpressionSQ_elem (*)(CexpressionSQ_elem, CexpressionSQ_elem));
    bool is_nil() const;
    CexpressionSQ_elem CexpressionSQ_elem_1;
    CexpressionSQ CexpressionSQ_1;
private:
    impl_CexpressionSQ* nil_rewrite(rview);
    impl_CexpressionSQ* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionSQ_elem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    CexpressionSQ_elem rewrite(rview) =0;
};
class impl_CexpressionSQ_elem_CExpressionSQNl:public impl_CexpressionSQ_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionSQNl; }
    explicit impl_CexpressionSQ_elem_CExpressionSQNl();

    CexpressionSQ_elem rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_CexpressionSQ_elem_CExpressionSQPart:public impl_CexpressionSQ_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CExpressionSQPart; }
    explicit impl_CexpressionSQ_elem_CExpressionSQPart(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    CexpressionSQ_elem rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_idCexpressions: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilidCexpressions: sel_ConsidCexpressions;
    }
    explicit impl_idCexpressions(idCexpression = 0, idCexpressions = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend idCexpressions concat(c_idCexpressions, c_idCexpressions);
    idCexpressions reverse() const;
    idCexpressions rewrite(rview);
    idCexpression last() const;
    idCexpressions append(idCexpression);
    idCexpressions map(idCexpression (*)(idCexpression));
    idCexpressions filter( bool (*)(idCexpression));
    idCexpressions merge( idCexpressions, idCexpression (*)(idCexpression, idCexpression));
    idCexpression reduce( idCexpression, idCexpression (*)(idCexpression, idCexpression));
    bool is_nil() const;
    idCexpression idCexpression_1;
    idCexpressions idCexpressions_1;
private:
    impl_idCexpressions* nil_rewrite(rview);
    impl_idCexpressions* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_idCexpression: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ID id;
    idCexpression rewrite(rview) =0;
};
class impl_idCexpression_IdCexpression:public impl_idCexpression{
public:
    enum_operators prod_sel() const
	{ return sel_IdCexpression; }
    explicit impl_idCexpression_IdCexpression(ID, Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    idCexpression rewrite( rview );
    impl_ID* ID_1;
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctexts: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilCtexts: sel_ConsCtexts;
    }
    explicit impl_Ctexts(Ctext = 0, Ctexts = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend Ctexts concat(c_Ctexts, c_Ctexts);
    Ctexts reverse() const;
    Ctexts rewrite(rview);
    Ctext last() const;
    Ctexts append(Ctext);
    Ctexts map(Ctext (*)(Ctext));
    Ctexts filter( bool (*)(Ctext));
    Ctexts merge( Ctexts, Ctext (*)(Ctext, Ctext));
    Ctext reduce( Ctext, Ctext (*)(Ctext, Ctext));
    bool is_nil() const;
    Ctext Ctext_1;
    Ctexts Ctexts_1;
private:
    impl_Ctexts* nil_rewrite(rview);
    impl_Ctexts* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_includefiles: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilincludefiles: sel_Consincludefiles;
    }
    explicit impl_includefiles(includefile = 0, includefiles = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend includefiles concat(c_includefiles, c_includefiles);
    includefiles reverse() const;
    includefiles rewrite(rview);
    includefile last() const;
    includefiles append(includefile);
    includefiles map(includefile (*)(includefile));
    includefiles filter( bool (*)(includefile));
    includefiles merge( includefiles, includefile (*)(includefile, includefile));
    includefile reduce( includefile, includefile (*)(includefile, includefile));
    bool is_nil() const;
    includefile includefile_1;
    includefiles includefiles_1;
private:
    impl_includefiles* nil_rewrite(rview);
    impl_includefiles* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_includefile: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    include_type inc_type;
    twoIncludedeclarations inc;
    includefile rewrite(rview) =0;
};
class impl_includefile_IncludeFile:public impl_includefile{
public:
    enum_operators prod_sel() const
	{ return sel_IncludeFile; }
    explicit impl_includefile_IncludeFile(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    includefile rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_includedeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilincludedeclarations: sel_Consincludedeclarations;
    }
    explicit impl_includedeclarations(includedeclaration = 0, includedeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend includedeclarations concat(c_includedeclarations, c_includedeclarations);
    includedeclarations reverse() const;
    includedeclarations rewrite(rview);
    includedeclaration last() const;
    includedeclarations append(includedeclaration);
    includedeclarations map(includedeclaration (*)(includedeclaration));
    includedeclarations filter( bool (*)(includedeclaration));
    includedeclarations merge( includedeclarations, includedeclaration (*)(includedeclaration, includedeclaration));
    includedeclaration reduce( includedeclaration, includedeclaration (*)(includedeclaration, includedeclaration));
    bool is_nil() const;
    includedeclaration includedeclaration_1;
    includedeclarations includedeclarations_1;
private:
    impl_includedeclarations* nil_rewrite(rview);
    impl_includedeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_includedeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    includedeclaration rewrite(rview) =0;
};
class impl_includedeclaration_IncludeDeclaration:public impl_includedeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_IncludeDeclaration; }
    explicit impl_includedeclaration_IncludeDeclaration(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    includedeclaration rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_rwdeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilrwdeclarations: sel_Consrwdeclarations;
    }
    explicit impl_rwdeclarations(rwdeclaration = 0, rwdeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend rwdeclarations concat(c_rwdeclarations, c_rwdeclarations);
    rwdeclarations reverse() const;
    rwdeclarations rewrite(rview);
    rwdeclaration last() const;
    rwdeclarations append(rwdeclaration);
    rwdeclarations map(rwdeclaration (*)(rwdeclaration));
    rwdeclarations filter( bool (*)(rwdeclaration));
    rwdeclarations merge( rwdeclarations, rwdeclaration (*)(rwdeclaration, rwdeclaration));
    rwdeclaration reduce( rwdeclaration, rwdeclaration (*)(rwdeclaration, rwdeclaration));
    bool is_nil() const;
    rwdeclaration rwdeclaration_1;
    rwdeclarations rwdeclarations_1;
private:
    impl_rwdeclarations* nil_rewrite(rview);
    impl_rwdeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_rwdeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    rwdeclaration rewrite(rview) =0;
};
class impl_rwdeclaration_RwDeclaration:public impl_rwdeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_RwDeclaration; }
    explicit impl_rwdeclaration_RwDeclaration(outmostpatterns, rewriteclauses);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    rwdeclaration rewrite( rview );
    impl_outmostpatterns* outmostpatterns_1;
    impl_rewriteclauses* rewriteclauses_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_rewriteclauses: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilrewriteclauses: sel_Consrewriteclauses;
    }
    explicit impl_rewriteclauses(rewriteclause = 0, rewriteclauses = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend rewriteclauses concat(c_rewriteclauses, c_rewriteclauses);
    rewriteclauses reverse() const;
    rewriteclauses rewrite(rview);
    rewriteclause last() const;
    rewriteclauses append(rewriteclause);
    rewriteclauses map(rewriteclause (*)(rewriteclause));
    rewriteclauses filter( bool (*)(rewriteclause));
    rewriteclauses merge( rewriteclauses, rewriteclause (*)(rewriteclause, rewriteclause));
    rewriteclause reduce( rewriteclause, rewriteclause (*)(rewriteclause, rewriteclause));
    bool is_nil() const;
    rewriteclause rewriteclause_1;
    rewriteclauses rewriteclauses_1;
private:
    impl_rewriteclauses* nil_rewrite(rview);
    impl_rewriteclauses* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_rewriteclause: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    rewriteclause rewrite(rview) =0;
};
class impl_rewriteclause_RewriteClause:public impl_rewriteclause{
public:
    enum_operators prod_sel() const
	{ return sel_RewriteClause; }
    explicit impl_rewriteclause_RewriteClause(viewnames, term);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    rewriteclause rewrite( rview );
    impl_viewnames* viewnames_1;
    impl_term* term_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_patternchains: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpatternchains: sel_Conspatternchains;
    }
    explicit impl_patternchains(patternchain = 0, patternchains = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend patternchains concat(c_patternchains, c_patternchains);
    patternchains reverse() const;
    patternchains rewrite(rview);
    patternchain last() const;
    patternchains append(patternchain);
    patternchains map(patternchain (*)(patternchain));
    patternchains filter( bool (*)(patternchain));
    patternchains merge( patternchains, patternchain (*)(patternchain, patternchain));
    patternchain reduce( patternchain, patternchain (*)(patternchain, patternchain));
    bool is_nil() const;
    patternchain patternchain_1;
    patternchains patternchains_1;
private:
    impl_patternchains* nil_rewrite(rview);
    impl_patternchains* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_patternchain: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpatternchain: sel_Conspatternchain;
    }
    explicit impl_patternchain(patternchainitem = 0, patternchain = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend patternchain concat(c_patternchain, c_patternchain);
    patternchain reverse() const;
    patternchain rewrite(rview);
    patternchainitem last() const;
    patternchain append(patternchainitem);
    patternchain map(patternchainitem (*)(patternchainitem));
    patternchain filter( bool (*)(patternchainitem));
    patternchain merge( patternchain, patternchainitem (*)(patternchainitem, patternchainitem));
    patternchainitem reduce( patternchainitem, patternchainitem (*)(patternchainitem, patternchainitem));
    bool is_nil() const;
    patternchainitem patternchainitem_1;
    patternchain patternchain_1;
private:
    impl_patternchain* nil_rewrite(rview);
    impl_patternchain* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_outmostpatterns: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Niloutmostpatterns: sel_Consoutmostpatterns;
    }
    explicit impl_outmostpatterns(outmostpattern = 0, outmostpatterns = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend outmostpatterns concat(c_outmostpatterns, c_outmostpatterns);
    outmostpatterns reverse() const;
    outmostpatterns rewrite(rview);
    outmostpattern last() const;
    outmostpatterns append(outmostpattern);
    outmostpatterns map(outmostpattern (*)(outmostpattern));
    outmostpatterns filter( bool (*)(outmostpattern));
    outmostpatterns merge( outmostpatterns, outmostpattern (*)(outmostpattern, outmostpattern));
    outmostpattern reduce( outmostpattern, outmostpattern (*)(outmostpattern, outmostpattern));
    bool is_nil() const;
    outmostpattern outmostpattern_1;
    outmostpatterns outmostpatterns_1;
private:
    impl_outmostpatterns* nil_rewrite(rview);
    impl_outmostpatterns* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_patternchainitem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    ID type;
    patternchainitem rewrite(rview) =0;
};
class impl_patternchainitem_PatternchainitemDollarid:public impl_patternchainitem{
public:
    enum_operators prod_sel() const
	{ return sel_PatternchainitemDollarid; }
    explicit impl_patternchainitem_PatternchainitemDollarid(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    patternchainitem rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_patternchainitem_PatternchainitemGroup:public impl_patternchainitem{
public:
    enum_operators prod_sel() const
	{ return sel_PatternchainitemGroup; }
    explicit impl_patternchainitem_PatternchainitemGroup(patternchains);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    patternchainitem rewrite( rview );
    impl_patternchains* patternchains_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_patternchainitem_PatternchainitemOutmost:public impl_patternchainitem{
public:
    enum_operators prod_sel() const
	{ return sel_PatternchainitemOutmost; }
    explicit impl_patternchainitem_PatternchainitemOutmost(outmostpattern);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    patternchainitem rewrite( rview );
    impl_outmostpattern* outmostpattern_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_outmostpattern: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    ID type;
    outmostpattern rewrite(rview) =0;
};
class impl_outmostpattern_OPDefault:public impl_outmostpattern{
public:
    enum_operators prod_sel() const
	{ return sel_OPDefault; }
    explicit impl_outmostpattern_OPDefault(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    outmostpattern rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_outmostpattern_OPWildcard:public impl_outmostpattern{
public:
    enum_operators prod_sel() const
	{ return sel_OPWildcard; }
    explicit impl_outmostpattern_OPWildcard(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    outmostpattern rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_outmostpattern_OPNonLeafVariable:public impl_outmostpattern{
public:
    enum_operators prod_sel() const
	{ return sel_OPNonLeafVariable; }
    explicit impl_outmostpattern_OPNonLeafVariable(ID, outmostpattern);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    outmostpattern rewrite( rview );
    impl_ID* ID_1;
    impl_outmostpattern* outmostpattern_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_outmostpattern_OPOperator:public impl_outmostpattern{
public:
    enum_operators prod_sel() const
	{ return sel_OPOperator; }
    explicit impl_outmostpattern_OPOperator(ID, patterns, Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    outmostpattern rewrite( rview );
    impl_ID* ID_1;
    impl_patterns* patterns_1;
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_outmostpattern_OPOperatorWildcard:public impl_outmostpattern{
public:
    enum_operators prod_sel() const
	{ return sel_OPOperatorWildcard; }
    explicit impl_outmostpattern_OPOperatorWildcard(ID, Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    outmostpattern rewrite( rview );
    impl_ID* ID_1;
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    pattern rewrite(rview) =0;
};
class impl_pattern_PIntLiteral:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_PIntLiteral; }
    explicit impl_pattern_PIntLiteral(INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    pattern rewrite( rview );
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern_PStringLiteral:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_PStringLiteral; }
    explicit impl_pattern_PStringLiteral(CexpressionDQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    pattern rewrite( rview );
    impl_CexpressionDQ* CexpressionDQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern_PWildcard:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_PWildcard; }
    explicit impl_pattern_PWildcard();

    pattern rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern_PNonLeafVariable:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_PNonLeafVariable; }
    explicit impl_pattern_PNonLeafVariable(ID, pattern);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    pattern rewrite( rview );
    impl_ID* ID_1;
    impl_pattern* pattern_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern_POperator:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_POperator; }
    explicit impl_pattern_POperator(ID, patterns);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    pattern rewrite( rview );
    impl_ID* ID_1;
    impl_patterns* patterns_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_pattern_PVariable:public impl_pattern{
public:
    enum_operators prod_sel() const
	{ return sel_PVariable; }
    explicit impl_pattern_PVariable(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    pattern rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_patterns: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpatterns: sel_Conspatterns;
    }
    explicit impl_patterns(pattern = 0, patterns = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend patterns concat(c_patterns, c_patterns);
    patterns reverse() const;
    patterns rewrite(rview);
    pattern last() const;
    patterns append(pattern);
    patterns map(pattern (*)(pattern));
    patterns filter( bool (*)(pattern));
    patterns merge( patterns, pattern (*)(pattern, pattern));
    pattern reduce( pattern, pattern (*)(pattern, pattern));
    bool is_nil() const;
    pattern pattern_1;
    patterns patterns_1;
private:
    impl_patterns* nil_rewrite(rview);
    impl_patterns* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_term: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    term rewrite(rview) =0;
};
class impl_term_TIntLiteral:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TIntLiteral; }
    explicit impl_term_TIntLiteral(INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TStringLiteral:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TStringLiteral; }
    explicit impl_term_TStringLiteral(CexpressionDQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_CexpressionDQ* CexpressionDQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TCTerm:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TCTerm; }
    explicit impl_term_TCTerm(CexpressionSQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_CexpressionSQ* CexpressionSQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TMemberVarDot:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TMemberVarDot; }
    explicit impl_term_TMemberVarDot(term, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_term* term_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TMemberVar:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TMemberVar; }
    explicit impl_term_TMemberVar(term, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_term* term_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TMethodDot:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TMethodDot; }
    explicit impl_term_TMethodDot(term, ID, terms);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_term* term_1;
    impl_ID* ID_1;
    impl_terms* terms_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TMethod:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TMethod; }
    explicit impl_term_TMethod(term, ID, terms);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_term* term_1;
    impl_ID* ID_1;
    impl_terms* terms_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TOperator:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TOperator; }
    explicit impl_term_TOperator(ID, terms);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_ID* ID_1;
    impl_terms* terms_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_term_TVariable:public impl_term{
public:
    enum_operators prod_sel() const
	{ return sel_TVariable; }
    explicit impl_term_TVariable(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    term rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_terms: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilterms: sel_Consterms;
    }
    explicit impl_terms(term = 0, terms = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend terms concat(c_terms, c_terms);
    terms reverse() const;
    terms rewrite(rview);
    term last() const;
    terms append(term);
    terms map(term (*)(term));
    terms filter( bool (*)(term));
    terms merge( terms, term (*)(term, term));
    term reduce( term, term (*)(term, term));
    bool is_nil() const;
    term term_1;
    terms terms_1;
private:
    impl_terms* nil_rewrite(rview);
    impl_terms* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_fnfiles: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilfnfiles: sel_Consfnfiles;
    }
    explicit impl_fnfiles(fnfile = 0, fnfiles = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend fnfiles concat(c_fnfiles, c_fnfiles);
    fnfiles reverse() const;
    fnfiles rewrite(rview);
    fnfile last() const;
    fnfiles append(fnfile);
    fnfiles map(fnfile (*)(fnfile));
    fnfiles filter( bool (*)(fnfile));
    fnfiles merge( fnfiles, fnfile (*)(fnfile, fnfile));
    fnfile reduce( fnfile, fnfile (*)(fnfile, fnfile));
    bool is_nil() const;
    fnfile fnfile_1;
    fnfiles fnfiles_1;
private:
    impl_fnfiles* nil_rewrite(rview);
    impl_fnfiles* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_fnfile: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    fndeclarations fns;
    fnfile rewrite(rview) =0;
};
class impl_fnfile_FnFile:public impl_fnfile{
public:
    enum_operators prod_sel() const
	{ return sel_FnFile; }
    explicit impl_fnfile_FnFile(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    fnfile rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_fndeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilfndeclarations: sel_Consfndeclarations;
    }
    explicit impl_fndeclarations(fndeclaration = 0, fndeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend fndeclarations concat(c_fndeclarations, c_fndeclarations);
    fndeclarations reverse() const;
    fndeclarations rewrite(rview);
    fndeclaration last() const;
    fndeclarations append(fndeclaration);
    fndeclarations map(fndeclaration (*)(fndeclaration));
    fndeclarations filter( bool (*)(fndeclaration));
    fndeclarations merge( fndeclarations, fndeclaration (*)(fndeclaration, fndeclaration));
    fndeclaration reduce( fndeclaration, fndeclaration (*)(fndeclaration, fndeclaration));
    bool is_nil() const;
    fndeclaration fndeclaration_1;
    fndeclarations fndeclarations_1;
private:
    impl_fndeclarations* nil_rewrite(rview);
    impl_fndeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_fndeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_parameter_type_list sorted;
    int last_line;
    casestring file;
    bool is_attr;
    fndeclaration rewrite(rview) =0;
};
class impl_fndeclaration_AcMemberDeclaration:public impl_fndeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_AcMemberDeclaration; }
    explicit impl_fndeclaration_AcMemberDeclaration(ac_declaration_specifiers, ac_declarator, ac_constant_expression_option, fnclass);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    fndeclaration rewrite( rview );
    impl_ac_declaration_specifiers* ac_declaration_specifiers_1;
    impl_ac_declarator* ac_declarator_1;
    impl_ac_constant_expression_option* ac_constant_expression_option_1;
    impl_fnclass* fnclass_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_fndeclaration_FnAcDeclaration:public impl_fndeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_FnAcDeclaration; }
    explicit impl_fndeclaration_FnAcDeclaration(ac_declaration_specifiers, ac_declarator, ac_declaration_list, ac_opt_base_init_list, Ctext, ID, fnclass);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    fndeclaration rewrite( rview );
    impl_ac_declaration_specifiers* ac_declaration_specifiers_1;
    impl_ac_declarator* ac_declarator_1;
    impl_ac_declaration_list* ac_declaration_list_1;
    impl_ac_opt_base_init_list* ac_opt_base_init_list_1;
    impl_Ctext* Ctext_1;
    impl_ID* ID_1;
    impl_fnclass* fnclass_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    fnclass rewrite(rview) =0;
};
class impl_fnclass_ConvOperatorFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_ConvOperatorFn; }
    explicit impl_fnclass_ConvOperatorFn();

    fnclass rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass_DestructorFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_DestructorFn; }
    explicit impl_fnclass_DestructorFn();

    fnclass rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass_ConstructorFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_ConstructorFn; }
    explicit impl_fnclass_ConstructorFn();

    fnclass rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass_MemberFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_MemberFn; }
    explicit impl_fnclass_MemberFn();

    fnclass rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass_StaticFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_StaticFn; }
    explicit impl_fnclass_StaticFn(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    fnclass rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_fnclass_GlobalFn:public impl_fnclass{
public:
    enum_operators prod_sel() const
	{ return sel_GlobalFn; }
    explicit impl_fnclass_GlobalFn();

    fnclass rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NilCtext: sel_ConsCtext;
    }
    explicit impl_Ctext(Ctext_elem = 0, Ctext = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend Ctext concat(c_Ctext, c_Ctext);
    Ctext reverse() const;
    Ctext rewrite(rview);
    Ctext_elem last() const;
    Ctext append(Ctext_elem);
    Ctext map(Ctext_elem (*)(Ctext_elem));
    Ctext filter( bool (*)(Ctext_elem));
    Ctext merge( Ctext, Ctext_elem (*)(Ctext_elem, Ctext_elem));
    Ctext_elem reduce( Ctext_elem, Ctext_elem (*)(Ctext_elem, Ctext_elem));
    bool is_nil() const;
    Ctext_elem Ctext_elem_1;
    Ctext Ctext_1;
private:
    impl_Ctext* nil_rewrite(rview);
    impl_Ctext* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    Ctext_elem rewrite(rview) =0;
};
class impl_Ctext_elem_CTextWithexpression:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextWithexpression; }
    explicit impl_Ctext_elem_CTextWithexpression(withexpressions, withcases, contextinfo);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_withexpressions* withexpressions_1;
    impl_withcases* withcases_1;
    impl_contextinfo* contextinfo_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextForeachexpression:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextForeachexpression; }
    explicit impl_Ctext_elem_CTextForeachexpression(patternchain, idCexpressions, withexpressions, Ctext, foreach_after);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_patternchain* patternchain_1;
    impl_idCexpressions* idCexpressions_1;
    impl_withexpressions* withexpressions_1;
    impl_Ctext* Ctext_1;
    impl_foreach_after* foreach_after_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextCbody:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextCbody; }
    explicit impl_Ctext_elem_CTextCbody(Ctext);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_Ctext* Ctext_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextCexpressionSQ:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextCexpressionSQ; }
    explicit impl_Ctext_elem_CTextCexpressionSQ(CexpressionSQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_CexpressionSQ* CexpressionSQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextCexpressionDQ:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextCexpressionDQ; }
    explicit impl_Ctext_elem_CTextCexpressionDQ(CexpressionDQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_CexpressionDQ* CexpressionDQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextNl:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextNl; }
    explicit impl_Ctext_elem_CTextNl(integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_integer* integer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextDollarVar:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextDollarVar; }
    explicit impl_Ctext_elem_CTextDollarVar(INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_Ctext_elem_CTextLine:public impl_Ctext_elem{
public:
    enum_operators prod_sel() const
	{ return sel_CTextLine; }
    explicit impl_Ctext_elem_CTextLine(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    Ctext_elem rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_foreach_after: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    foreach_after rewrite(rview) =0;
};
class impl_foreach_after_ForeachAfter:public impl_foreach_after{
public:
    enum_operators prod_sel() const
	{ return sel_ForeachAfter; }
    explicit impl_foreach_after_ForeachAfter(patternchain, idCexpressions, withexpressions, Ctext);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    foreach_after rewrite( rview );
    impl_patternchain* patternchain_1;
    impl_idCexpressions* idCexpressions_1;
    impl_withexpressions* withexpressions_1;
    impl_Ctext* Ctext_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_foreach_after_NoForeachAfter:public impl_foreach_after{
public:
    enum_operators prod_sel() const
	{ return sel_NoForeachAfter; }
    explicit impl_foreach_after_NoForeachAfter();

    foreach_after rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_contextinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    contextinfo rewrite(rview) =0;
};
class impl_contextinfo_NotInForeachContext:public impl_contextinfo{
public:
    enum_operators prod_sel() const
	{ return sel_NotInForeachContext; }
    explicit impl_contextinfo_NotInForeachContext();

    contextinfo rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_contextinfo_InForeachContext:public impl_contextinfo{
public:
    enum_operators prod_sel() const
	{ return sel_InForeachContext; }
    explicit impl_contextinfo_InForeachContext(patternchain);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    contextinfo rewrite( rview );
    impl_patternchain* patternchain_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_withexpressions: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    phylumnames type;
    int line;
    casestring file;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilwithexpressions: sel_Conswithexpressions;
    }
    explicit impl_withexpressions(withexpression = 0, withexpressions = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend withexpressions concat(c_withexpressions, c_withexpressions);
    withexpressions reverse() const;
    withexpressions rewrite(rview);
    withexpression last() const;
    withexpressions append(withexpression);
    withexpressions map(withexpression (*)(withexpression));
    withexpressions filter( bool (*)(withexpression));
    withexpressions merge( withexpressions, withexpression (*)(withexpression, withexpression));
    withexpression reduce( withexpression, withexpression (*)(withexpression, withexpression));
    bool is_nil() const;
    withexpression withexpression_1;
    withexpressions withexpressions_1;
private:
    impl_withexpressions* nil_rewrite(rview);
    impl_withexpressions* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_withexpression: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ID type;
    int line;
    casestring file;
    withexpression rewrite(rview) =0;
};
class impl_withexpression_WECexpression:public impl_withexpression{
public:
    enum_operators prod_sel() const
	{ return sel_WECexpression; }
    explicit impl_withexpression_WECexpression(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    withexpression rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_withexpression_WEVariable:public impl_withexpression{
public:
    enum_operators prod_sel() const
	{ return sel_WEVariable; }
    explicit impl_withexpression_WEVariable(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    withexpression rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_withcases: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    withcasesinfo wcinfo;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilwithcases: sel_Conswithcases;
    }
    explicit impl_withcases(withcase = 0, withcases = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend withcases concat(c_withcases, c_withcases);
    withcases reverse() const;
    withcases rewrite(rview);
    withcase last() const;
    withcases append(withcase);
    withcases map(withcase (*)(withcase));
    withcases filter( bool (*)(withcase));
    withcases merge( withcases, withcase (*)(withcase, withcase));
    withcase reduce( withcase, withcase (*)(withcase, withcase));
    bool is_nil() const;
    withcase withcase_1;
    withcases withcases_1;
private:
    impl_withcases* nil_rewrite(rview);
    impl_withcases* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_withcase: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    withcasesinfo wcinfo;
    withcase rewrite(rview) =0;
};
class impl_withcase_Withcase:public impl_withcase{
public:
    enum_operators prod_sel() const
	{ return sel_Withcase; }
    explicit impl_withcase_Withcase(patternchains, Ctext);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    withcase rewrite( rview );
    impl_patternchains* patternchains_1;
    impl_Ctext* Ctext_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparsedeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunparsedeclarations: sel_Consunparsedeclarations;
    }
    explicit impl_unparsedeclarations(unparsedeclaration = 0, unparsedeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unparsedeclarations concat(c_unparsedeclarations, c_unparsedeclarations);
    unparsedeclarations reverse() const;
    unparsedeclarations rewrite(rview);
    unparsedeclaration last() const;
    unparsedeclarations append(unparsedeclaration);
    unparsedeclarations map(unparsedeclaration (*)(unparsedeclaration));
    unparsedeclarations filter( bool (*)(unparsedeclaration));
    unparsedeclarations merge( unparsedeclarations, unparsedeclaration (*)(unparsedeclaration, unparsedeclaration));
    unparsedeclaration reduce( unparsedeclaration, unparsedeclaration (*)(unparsedeclaration, unparsedeclaration));
    bool is_nil() const;
    unparsedeclaration unparsedeclaration_1;
    unparsedeclarations unparsedeclarations_1;
private:
    impl_unparsedeclarations* nil_rewrite(rview);
    impl_unparsedeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparsedeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    patternrepresentations patternreps;
    unparsedeclaration rewrite(rview) =0;
};
class impl_unparsedeclaration_UnparseDeclaration:public impl_unparsedeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_UnparseDeclaration; }
    explicit impl_unparsedeclaration_UnparseDeclaration(outmostpatterns, unparseclauses);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparsedeclaration rewrite( rview );
    impl_outmostpatterns* outmostpatterns_1;
    impl_unparseclauses* unparseclauses_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseclauses: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunparseclauses: sel_Consunparseclauses;
    }
    explicit impl_unparseclauses(unparseclause = 0, unparseclauses = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unparseclauses concat(c_unparseclauses, c_unparseclauses);
    unparseclauses reverse() const;
    unparseclauses rewrite(rview);
    unparseclause last() const;
    unparseclauses append(unparseclause);
    unparseclauses map(unparseclause (*)(unparseclause));
    unparseclauses filter( bool (*)(unparseclause));
    unparseclauses merge( unparseclauses, unparseclause (*)(unparseclause, unparseclause));
    unparseclause reduce( unparseclause, unparseclause (*)(unparseclause, unparseclause));
    bool is_nil() const;
    unparseclause unparseclause_1;
    unparseclauses unparseclauses_1;
private:
    impl_unparseclauses* nil_rewrite(rview);
    impl_unparseclauses* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparseclause: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    unparseclause rewrite(rview) =0;
};
class impl_unparseclause_UnparseClause:public impl_unparseclause{
public:
    enum_operators prod_sel() const
	{ return sel_UnparseClause; }
    explicit impl_unparseclause_UnparseClause(viewnames, unparseitems);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseclause rewrite( rview );
    impl_viewnames* viewnames_1;
    impl_unparseitems* unparseitems_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_viewnames: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    bool is_extern;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilviewnames: sel_Consviewnames;
    }
    explicit impl_viewnames(ID = 0, viewnames = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend viewnames concat(c_viewnames, c_viewnames);
    viewnames reverse() const;
    viewnames rewrite(rview);
    ID last() const;
    viewnames append(ID);
    viewnames map(ID (*)(ID));
    viewnames filter( bool (*)(ID));
    viewnames merge( viewnames, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    viewnames viewnames_1;
private:
    impl_viewnames* nil_rewrite(rview);
    impl_viewnames* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparseitems: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunparseitems: sel_Consunparseitems;
    }
    explicit impl_unparseitems(unparseitem = 0, unparseitems = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unparseitems concat(c_unparseitems, c_unparseitems);
    unparseitems reverse() const;
    unparseitems rewrite(rview);
    unparseitem last() const;
    unparseitems append(unparseitem);
    unparseitems map(unparseitem (*)(unparseitem));
    unparseitems filter( bool (*)(unparseitem));
    unparseitems merge( unparseitems, unparseitem (*)(unparseitem, unparseitem));
    unparseitem reduce( unparseitem, unparseitem (*)(unparseitem, unparseitem));
    bool is_nil() const;
    unparseitem unparseitem_1;
    unparseitems unparseitems_1;
private:
    impl_unparseitems* nil_rewrite(rview);
    impl_unparseitems* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparseitem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int text_nr;
    unparseitem rewrite(rview) =0;
};
class impl_unparseitem_UViewVarDecl:public impl_unparseitem{
public:
    enum_operators prod_sel() const
	{ return sel_UViewVarDecl; }
    explicit impl_unparseitem_UViewVarDecl(ID, ID, Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseitem rewrite( rview );
    impl_ID* ID_1;
    impl_ID* ID_2;
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseitem_UnpBody:public impl_unparseitem{
public:
    enum_operators prod_sel() const
	{ return sel_UnpBody; }
    explicit impl_unparseitem_UnpBody(languageoption, unparseitems);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseitem rewrite( rview );
    impl_languageoption* languageoption_1;
    impl_unparseitems* unparseitems_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseitem_UnpCtext:public impl_unparseitem{
public:
    enum_operators prod_sel() const
	{ return sel_UnpCtext; }
    explicit impl_unparseitem_UnpCtext(languageoption, Ctext);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseitem rewrite( rview );
    impl_languageoption* languageoption_1;
    impl_Ctext* Ctext_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseitem_UnpSubexpr:public impl_unparseitem{
public:
    enum_operators prod_sel() const
	{ return sel_UnpSubexpr; }
    explicit impl_unparseitem_UnpSubexpr(languageoption, unpsubterm, viewnameoption);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseitem rewrite( rview );
    impl_languageoption* languageoption_1;
    impl_unpsubterm* unpsubterm_1;
    impl_viewnameoption* viewnameoption_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseitem_UnpStr:public impl_unparseitem{
public:
    enum_operators prod_sel() const
	{ return sel_UnpStr; }
    explicit impl_unparseitem_UnpStr(languageoption, CexpressionDQ, viewnameoption);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseitem rewrite( rview );
    impl_languageoption* languageoption_1;
    impl_CexpressionDQ* CexpressionDQ_1;
    impl_viewnameoption* viewnameoption_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpsubterm: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    unpsubterm rewrite(rview) =0;
};
class impl_unpsubterm_UnpCastedVariable:public impl_unpsubterm{
public:
    enum_operators prod_sel() const
	{ return sel_UnpCastedVariable; }
    explicit impl_unpsubterm_UnpCastedVariable(ID, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unpsubterm rewrite( rview );
    impl_ID* ID_1;
    impl_ID* ID_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpsubterm_UnpDollarvarAttr:public impl_unpsubterm{
public:
    enum_operators prod_sel() const
	{ return sel_UnpDollarvarAttr; }
    explicit impl_unpsubterm_UnpDollarvarAttr(INT, unpattributes);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unpsubterm rewrite( rview );
    impl_INT* INT_1;
    impl_unpattributes* unpattributes_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpsubterm_UnpSubAttr:public impl_unpsubterm{
public:
    enum_operators prod_sel() const
	{ return sel_UnpSubAttr; }
    explicit impl_unpsubterm_UnpSubAttr(ID, unpattributes);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unpsubterm rewrite( rview );
    impl_ID* ID_1;
    impl_unpattributes* unpattributes_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpsubterm_UnpDollarvarTerm:public impl_unpsubterm{
public:
    enum_operators prod_sel() const
	{ return sel_UnpDollarvarTerm; }
    explicit impl_unpsubterm_UnpDollarvarTerm(INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unpsubterm rewrite( rview );
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpsubterm_UnpSubTerm:public impl_unpsubterm{
public:
    enum_operators prod_sel() const
	{ return sel_UnpSubTerm; }
    explicit impl_unpsubterm_UnpSubTerm(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unpsubterm rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unpattributes: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunpattributes: sel_Consunpattributes;
    }
    explicit impl_unpattributes(ID = 0, unpattributes = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unpattributes concat(c_unpattributes, c_unpattributes);
    unpattributes reverse() const;
    unpattributes rewrite(rview);
    ID last() const;
    unpattributes append(ID);
    unpattributes map(ID (*)(ID));
    unpattributes filter( bool (*)(ID));
    unpattributes merge( unpattributes, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    unpattributes unpattributes_1;
private:
    impl_unpattributes* nil_rewrite(rview);
    impl_unpattributes* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_viewnameoption: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    viewnameoption rewrite(rview) =0;
};
class impl_viewnameoption_YesViewname:public impl_viewnameoption{
public:
    enum_operators prod_sel() const
	{ return sel_YesViewname; }
    explicit impl_viewnameoption_YesViewname(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    viewnameoption rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_viewnameoption_NoViewname:public impl_viewnameoption{
public:
    enum_operators prod_sel() const
	{ return sel_NoViewname; }
    explicit impl_viewnameoption_NoViewname();

    viewnameoption rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_languageoption: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    languageoption rewrite(rview) =0;
};
class impl_languageoption_LanguageList:public impl_languageoption{
public:
    enum_operators prod_sel() const
	{ return sel_LanguageList; }
    explicit impl_languageoption_LanguageList(languagenames);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    languageoption rewrite( rview );
    impl_languagenames* languagenames_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_languageoption_NoLanguagename:public impl_languageoption{
public:
    enum_operators prod_sel() const
	{ return sel_NoLanguagename; }
    explicit impl_languageoption_NoLanguagename();

    languageoption rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_languagenames: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nillanguagenames: sel_Conslanguagenames;
    }
    explicit impl_languagenames(ID = 0, languagenames = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend languagenames concat(c_languagenames, c_languagenames);
    languagenames reverse() const;
    languagenames rewrite(rview);
    ID last() const;
    languagenames append(ID);
    languagenames map(ID (*)(ID));
    languagenames filter( bool (*)(ID));
    languagenames merge( languagenames, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    languagenames languagenames_1;
private:
    impl_languagenames* nil_rewrite(rview);
    impl_languagenames* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_fileline: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    casestring file;
    int line;
    fileline rewrite(rview) =0;
};
class impl_fileline_PosNoFileLine:public impl_fileline{
public:
    enum_operators prod_sel() const
	{ return sel_PosNoFileLine; }
    explicit impl_fileline_PosNoFileLine();

    fileline rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fileline_NoFileLine:public impl_fileline{
public:
    enum_operators prod_sel() const
	{ return sel_NoFileLine; }
    explicit impl_fileline_NoFileLine();

    fileline rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_fileline_FileLine:public impl_fileline{
public:
    enum_operators prod_sel() const
	{ return sel_FileLine; }

    fileline rewrite( rview );
    impl_fileline_FileLine(casestring _file=0, int _line=0);
private:
    void do_unparse(printer_functor, uview);
};
class impl_scopetypefilelinestack: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilscopetypefilelinestack: sel_Consscopetypefilelinestack;
    }
    explicit impl_scopetypefilelinestack(scopetypefileline = 0, scopetypefilelinestack = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend scopetypefilelinestack concat(c_scopetypefilelinestack, c_scopetypefilelinestack);
    scopetypefilelinestack reverse() const;
    scopetypefilelinestack rewrite(rview);
    scopetypefileline last() const;
    scopetypefilelinestack append(scopetypefileline);
    scopetypefilelinestack map(scopetypefileline (*)(scopetypefileline));
    scopetypefilelinestack filter( bool (*)(scopetypefileline));
    scopetypefilelinestack merge( scopetypefilelinestack, scopetypefileline (*)(scopetypefileline, scopetypefileline));
    scopetypefileline reduce( scopetypefileline, scopetypefileline (*)(scopetypefileline, scopetypefileline));
    bool is_nil() const;
    scopetypefileline scopetypefileline_1;
    scopetypefilelinestack scopetypefilelinestack_1;
private:
    impl_scopetypefilelinestack* nil_rewrite(rview);
    impl_scopetypefilelinestack* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_scopetypefileline: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    scopetypefileline rewrite(rview) =0;
};
class impl_scopetypefileline_ScopeTypeFileLine:public impl_scopetypefileline{
public:
    enum_operators prod_sel() const
	{ return sel_ScopeTypeFileLine; }
    explicit impl_scopetypefileline_ScopeTypeFileLine(integer, IDtype, casestring, integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    scopetypefileline rewrite( rview );
    impl_integer* integer_1;
    impl_IDtype* IDtype_1;
    impl_casestring* casestring_1;
    impl_integer* integer_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    IDtype rewrite(rview) =0;
};
class impl_IDtype_ITLanguageName:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITLanguageName; }
    explicit impl_IDtype_ITLanguageName(integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_integer* integer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPatternVariable:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPatternVariable; }
    explicit impl_IDtype_ITPatternVariable(ID, integer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_ID* ID_1;
    impl_integer* integer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUserFunction:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUserFunction; }
    explicit impl_IDtype_ITUserFunction(fnclass);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_fnclass* fnclass_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUserRView:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUserRView; }
    explicit impl_IDtype_ITUserRView();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPredefinedRView:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPredefinedRView; }
    explicit impl_IDtype_ITPredefinedRView();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUViewVar:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUViewVar; }
    explicit impl_IDtype_ITUViewVar();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUserUView:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUserUView; }
    explicit impl_IDtype_ITUserUView();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPredefinedUView:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPredefinedUView; }
    explicit impl_IDtype_ITPredefinedUView();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITStorageClass:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITStorageClass; }
    explicit impl_IDtype_ITStorageClass();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPredefinedStorageClass:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPredefinedStorageClass; }
    explicit impl_IDtype_ITPredefinedStorageClass();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUserOperator:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUserOperator; }
    explicit impl_IDtype_ITUserOperator(alternative, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_alternative* alternative_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPredefinedOperator:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPredefinedOperator; }
    explicit impl_IDtype_ITPredefinedOperator(alternative, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_alternative* alternative_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUserPhylum:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUserPhylum; }
    explicit impl_IDtype_ITUserPhylum(phylumdeclaration);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_phylumdeclaration* phylumdeclaration_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITPredefinedPhylum:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITPredefinedPhylum; }
    explicit impl_IDtype_ITPredefinedPhylum(phylumdeclaration);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    IDtype rewrite( rview );
    impl_phylumdeclaration* phylumdeclaration_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_IDtype_ITUnknown:public impl_IDtype{
public:
    enum_operators prod_sel() const
	{ return sel_ITUnknown; }
    explicit impl_IDtype_ITUnknown();

    IDtype rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_operators: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Niloperators: sel_Consoperators;
    }
    explicit impl_operators(ID = 0, operators = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend operators concat(c_operators, c_operators);
    operators reverse() const;
    operators rewrite(rview);
    ID last() const;
    operators append(ID);
    operators map(ID (*)(ID));
    operators filter( bool (*)(ID));
    operators merge( operators, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    operators operators_1;
private:
    impl_operators* nil_rewrite(rview);
    impl_operators* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_phyla: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilphyla: sel_Consphyla;
    }
    explicit impl_phyla(ID = 0, phyla = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend phyla concat(c_phyla, c_phyla);
    phyla reverse() const;
    phyla rewrite(rview);
    ID last() const;
    phyla append(ID);
    phyla map(ID (*)(ID));
    phyla filter( bool (*)(ID));
    phyla merge( phyla, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    phyla phyla_1;
private:
    impl_phyla* nil_rewrite(rview);
    impl_phyla* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_variables: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilvariables: sel_Consvariables;
    }
    explicit impl_variables(ID = 0, variables = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend variables concat(c_variables, c_variables);
    variables reverse() const;
    variables rewrite(rview);
    ID last() const;
    variables append(ID);
    variables map(ID (*)(ID));
    variables filter( bool (*)(ID));
    variables merge( variables, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    variables variables_1;
private:
    impl_variables* nil_rewrite(rview);
    impl_variables* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_dollarvarstatus: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    dollarvarstatus rewrite(rview) =0;
};
class impl_dollarvarstatus_DVDisallowed:public impl_dollarvarstatus{
public:
    enum_operators prod_sel() const
	{ return sel_DVDisallowed; }
    explicit impl_dollarvarstatus_DVDisallowed();

    dollarvarstatus rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_dollarvarstatus_DVAllowed:public impl_dollarvarstatus{
public:
    enum_operators prod_sel() const
	{ return sel_DVAllowed; }
    explicit impl_dollarvarstatus_DVAllowed();

    dollarvarstatus rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tribool: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    tribool rewrite(rview) =0;
};
class impl_tribool_Bigger:public impl_tribool{
public:
    enum_operators prod_sel() const
	{ return sel_Bigger; }
    explicit impl_tribool_Bigger();

    tribool rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tribool_Smaller:public impl_tribool{
public:
    enum_operators prod_sel() const
	{ return sel_Smaller; }
    explicit impl_tribool_Smaller();

    tribool rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tribool_Equal:public impl_tribool{
public:
    enum_operators prod_sel() const
	{ return sel_Equal; }
    explicit impl_tribool_Equal();

    tribool rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_patternrepresentations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpatternrepresentations: sel_Conspatternrepresentations;
    }
    explicit impl_patternrepresentations(patternrepresentation = 0, patternrepresentations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend patternrepresentations concat(c_patternrepresentations, c_patternrepresentations);
    patternrepresentations reverse() const;
    patternrepresentations rewrite(rview);
    patternrepresentation last() const;
    patternrepresentations append(patternrepresentation);
    patternrepresentations map(patternrepresentation (*)(patternrepresentation));
    patternrepresentations filter( bool (*)(patternrepresentation));
    patternrepresentations merge( patternrepresentations, patternrepresentation (*)(patternrepresentation, patternrepresentation));
    patternrepresentation reduce( patternrepresentation, patternrepresentation (*)(patternrepresentation, patternrepresentation));
    bool is_nil() const;
    patternrepresentation patternrepresentation_1;
    patternrepresentations patternrepresentations_1;
private:
    impl_patternrepresentations* nil_rewrite(rview);
    impl_patternrepresentations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_patternrepresentation: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpatternrepresentation: sel_Conspatternrepresentation;
    }
    explicit impl_patternrepresentation(elem_patternrepresentation = 0, patternrepresentation = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend patternrepresentation concat(c_patternrepresentation, c_patternrepresentation);
    patternrepresentation reverse() const;
    patternrepresentation rewrite(rview);
    elem_patternrepresentation last() const;
    patternrepresentation append(elem_patternrepresentation);
    patternrepresentation map(elem_patternrepresentation (*)(elem_patternrepresentation));
    patternrepresentation filter( bool (*)(elem_patternrepresentation));
    patternrepresentation merge( patternrepresentation, elem_patternrepresentation (*)(elem_patternrepresentation, elem_patternrepresentation));
    elem_patternrepresentation reduce( elem_patternrepresentation, elem_patternrepresentation (*)(elem_patternrepresentation, elem_patternrepresentation));
    bool is_nil() const;
    elem_patternrepresentation elem_patternrepresentation_1;
    patternrepresentation patternrepresentation_1;
private:
    impl_patternrepresentation* nil_rewrite(rview);
    impl_patternrepresentation* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    ID type;
    elem_patternrepresentation rewrite(rview) =0;
};
class impl_elem_patternrepresentation_PRIntLiteral:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRIntLiteral; }
    explicit impl_elem_patternrepresentation_PRIntLiteral(path, INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRStringLiteral:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRStringLiteral; }
    explicit impl_elem_patternrepresentation_PRStringLiteral(path, CexpressionDQ);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
    impl_CexpressionDQ* CexpressionDQ_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRDefault:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRDefault; }
    explicit impl_elem_patternrepresentation_PRDefault();

    elem_patternrepresentation rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRWildcard:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRWildcard; }
    explicit impl_elem_patternrepresentation_PRWildcard(path);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRNonLeafBinding:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRNonLeafBinding; }
    explicit impl_elem_patternrepresentation_PRNonLeafBinding(path, ID, patternrepresentation);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
    impl_ID* ID_1;
    impl_patternrepresentation* patternrepresentation_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRUserPredicate:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRUserPredicate; }
    explicit impl_elem_patternrepresentation_PRUserPredicate(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PROperPredicate:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PROperPredicate; }
    explicit impl_elem_patternrepresentation_PROperPredicate(path, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRVarPredicate:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRVarPredicate; }
    explicit impl_elem_patternrepresentation_PRVarPredicate(paths, ID, patternrepresentation);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_paths* paths_1;
    impl_ID* ID_1;
    impl_patternrepresentation* patternrepresentation_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_elem_patternrepresentation_PRBinding:public impl_elem_patternrepresentation{
public:
    enum_operators prod_sel() const
	{ return sel_PRBinding; }
    explicit impl_elem_patternrepresentation_PRBinding(path, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    elem_patternrepresentation rewrite( rview );
    impl_path* path_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_path: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    ID op;
    ID id;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpath: sel_Conspath;
    }
    explicit impl_path(integer = 0, path = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend path concat(c_path, c_path);
    path reverse() const;
    path rewrite(rview);
    integer last() const;
    path append(integer);
    path map(integer (*)(integer));
    path filter( bool (*)(integer));
    path merge( path, integer (*)(integer, integer));
    integer reduce( integer, integer (*)(integer, integer));
    bool is_nil() const;
    integer integer_1;
    path path_1;
private:
    impl_path* nil_rewrite(rview);
    impl_path* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_paths: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilpaths: sel_Conspaths;
    }
    explicit impl_paths(path = 0, paths = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend paths concat(c_paths, c_paths);
    paths reverse() const;
    paths rewrite(rview);
    path last() const;
    paths append(path);
    paths map(path (*)(path));
    paths filter( bool (*)(path));
    paths merge( paths, path (*)(path, path));
    path reduce( path, path (*)(path, path));
    bool is_nil() const;
    path path_1;
    paths paths_1;
private:
    impl_paths* nil_rewrite(rview);
    impl_paths* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_argsnumbers: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilargsnumbers: sel_Consargsnumbers;
    }
    explicit impl_argsnumbers(integer = 0, argsnumbers = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend argsnumbers concat(c_argsnumbers, c_argsnumbers);
    argsnumbers reverse() const;
    argsnumbers rewrite(rview);
    integer last() const;
    argsnumbers append(integer);
    argsnumbers map(integer (*)(integer));
    argsnumbers filter( bool (*)(integer));
    argsnumbers merge( argsnumbers, integer (*)(integer, integer));
    integer reduce( integer, integer (*)(integer, integer));
    bool is_nil() const;
    integer integer_1;
    argsnumbers argsnumbers_1;
private:
    impl_argsnumbers* nil_rewrite(rview);
    impl_argsnumbers* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_rewriterulesinfo: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilrewriterulesinfo: sel_Consrewriterulesinfo;
    }
    explicit impl_rewriterulesinfo(rewriteruleinfo = 0, rewriterulesinfo = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend rewriterulesinfo concat(c_rewriterulesinfo, c_rewriterulesinfo);
    rewriterulesinfo reverse() const;
    rewriterulesinfo rewrite(rview);
    rewriteruleinfo last() const;
    rewriterulesinfo append(rewriteruleinfo);
    rewriterulesinfo map(rewriteruleinfo (*)(rewriteruleinfo));
    rewriterulesinfo filter( bool (*)(rewriteruleinfo));
    rewriterulesinfo merge( rewriterulesinfo, rewriteruleinfo (*)(rewriteruleinfo, rewriteruleinfo));
    rewriteruleinfo reduce( rewriteruleinfo, rewriteruleinfo (*)(rewriteruleinfo, rewriteruleinfo));
    bool is_nil() const;
    rewriteruleinfo rewriteruleinfo_1;
    rewriterulesinfo rewriterulesinfo_1;
private:
    impl_rewriterulesinfo* nil_rewrite(rview);
    impl_rewriterulesinfo* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_rewriteruleinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    rewriteruleinfo rewrite(rview) =0;
};
class impl_rewriteruleinfo_Rewriteruleinfo:public impl_rewriteruleinfo{
public:
    enum_operators prod_sel() const
	{ return sel_Rewriteruleinfo; }
    explicit impl_rewriteruleinfo_Rewriteruleinfo(patternrepresentation, patternrepresentation, rewriteclause);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    rewriteruleinfo rewrite( rview );
    impl_patternrepresentation* patternrepresentation_1;
    impl_patternrepresentation* patternrepresentation_2;
    impl_rewriteclause* rewriteclause_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_withcasesinfo: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilwithcasesinfo: sel_Conswithcasesinfo;
    }
    explicit impl_withcasesinfo(withcaseinfo = 0, withcasesinfo = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend withcasesinfo concat(c_withcasesinfo, c_withcasesinfo);
    withcasesinfo reverse() const;
    withcasesinfo rewrite(rview);
    withcaseinfo last() const;
    withcasesinfo append(withcaseinfo);
    withcasesinfo map(withcaseinfo (*)(withcaseinfo));
    withcasesinfo filter( bool (*)(withcaseinfo));
    withcasesinfo merge( withcasesinfo, withcaseinfo (*)(withcaseinfo, withcaseinfo));
    withcaseinfo reduce( withcaseinfo, withcaseinfo (*)(withcaseinfo, withcaseinfo));
    bool is_nil() const;
    withcaseinfo withcaseinfo_1;
    withcasesinfo withcasesinfo_1;
private:
    impl_withcasesinfo* nil_rewrite(rview);
    impl_withcasesinfo* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_withcaseinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    withcaseinfo rewrite(rview) =0;
};
class impl_withcaseinfo_Withcaseinfo:public impl_withcaseinfo{
public:
    enum_operators prod_sel() const
	{ return sel_Withcaseinfo; }
    explicit impl_withcaseinfo_Withcaseinfo(patternrepresentation, patternrepresentation, Ctext);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    withcaseinfo rewrite( rview );
    impl_patternrepresentation* patternrepresentation_1;
    impl_patternrepresentation* patternrepresentation_2;
    impl_Ctext* Ctext_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_rewriteviewsinfo: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilrewriteviewsinfo: sel_Consrewriteviewsinfo;
    }
    explicit impl_rewriteviewsinfo(rewriteviewinfo = 0, rewriteviewsinfo = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend rewriteviewsinfo concat(c_rewriteviewsinfo, c_rewriteviewsinfo);
    rewriteviewsinfo reverse() const;
    rewriteviewsinfo rewrite(rview);
    rewriteviewinfo last() const;
    rewriteviewsinfo append(rewriteviewinfo);
    rewriteviewsinfo map(rewriteviewinfo (*)(rewriteviewinfo));
    rewriteviewsinfo filter( bool (*)(rewriteviewinfo));
    rewriteviewsinfo merge( rewriteviewsinfo, rewriteviewinfo (*)(rewriteviewinfo, rewriteviewinfo));
    rewriteviewinfo reduce( rewriteviewinfo, rewriteviewinfo (*)(rewriteviewinfo, rewriteviewinfo));
    bool is_nil() const;
    rewriteviewinfo rewriteviewinfo_1;
    rewriteviewsinfo rewriteviewsinfo_1;
private:
    impl_rewriteviewsinfo* nil_rewrite(rview);
    impl_rewriteviewsinfo* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_rewriteviewinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    rewriteviewinfo rewrite(rview) =0;
};
class impl_rewriteviewinfo_Rewriteviewinfo:public impl_rewriteviewinfo{
public:
    enum_operators prod_sel() const
	{ return sel_Rewriteviewinfo; }
    explicit impl_rewriteviewinfo_Rewriteviewinfo(ID, rewriterulesinfo);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    rewriteviewinfo rewrite( rview );
    impl_ID* ID_1;
    impl_rewriterulesinfo* rewriterulesinfo_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparseviewsinfo: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunparseviewsinfo: sel_Consunparseviewsinfo;
    }
    explicit impl_unparseviewsinfo(unparseviewinfo = 0, unparseviewsinfo = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unparseviewsinfo concat(c_unparseviewsinfo, c_unparseviewsinfo);
    unparseviewsinfo reverse() const;
    unparseviewsinfo rewrite(rview);
    unparseviewinfo last() const;
    unparseviewsinfo append(unparseviewinfo);
    unparseviewsinfo map(unparseviewinfo (*)(unparseviewinfo));
    unparseviewsinfo filter( bool (*)(unparseviewinfo));
    unparseviewsinfo merge( unparseviewsinfo, unparseviewinfo (*)(unparseviewinfo, unparseviewinfo));
    unparseviewinfo reduce( unparseviewinfo, unparseviewinfo (*)(unparseviewinfo, unparseviewinfo));
    bool is_nil() const;
    unparseviewinfo unparseviewinfo_1;
    unparseviewsinfo unparseviewsinfo_1;
private:
    impl_unparseviewsinfo* nil_rewrite(rview);
    impl_unparseviewsinfo* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparseviewinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    unparseviewinfo rewrite(rview) =0;
};
class impl_unparseviewinfo_Unparseviewinfo:public impl_unparseviewinfo{
public:
    enum_operators prod_sel() const
	{ return sel_Unparseviewinfo; }
    explicit impl_unparseviewinfo_Unparseviewinfo(ID, unparsedeclsinfo);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparseviewinfo rewrite( rview );
    impl_ID* ID_1;
    impl_unparsedeclsinfo* unparsedeclsinfo_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_unparsedeclsinfo: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilunparsedeclsinfo: sel_Consunparsedeclsinfo;
    }
    explicit impl_unparsedeclsinfo(unparsedeclinfo = 0, unparsedeclsinfo = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend unparsedeclsinfo concat(c_unparsedeclsinfo, c_unparsedeclsinfo);
    unparsedeclsinfo reverse() const;
    unparsedeclsinfo rewrite(rview);
    unparsedeclinfo last() const;
    unparsedeclsinfo append(unparsedeclinfo);
    unparsedeclsinfo map(unparsedeclinfo (*)(unparsedeclinfo));
    unparsedeclsinfo filter( bool (*)(unparsedeclinfo));
    unparsedeclsinfo merge( unparsedeclsinfo, unparsedeclinfo (*)(unparsedeclinfo, unparsedeclinfo));
    unparsedeclinfo reduce( unparsedeclinfo, unparsedeclinfo (*)(unparsedeclinfo, unparsedeclinfo));
    bool is_nil() const;
    unparsedeclinfo unparsedeclinfo_1;
    unparsedeclsinfo unparsedeclsinfo_1;
private:
    impl_unparsedeclsinfo* nil_rewrite(rview);
    impl_unparsedeclsinfo* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_unparsedeclinfo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    unparsedeclinfo rewrite(rview) =0;
};
class impl_unparsedeclinfo_Unparsedeclinfo:public impl_unparsedeclinfo{
public:
    enum_operators prod_sel() const
	{ return sel_Unparsedeclinfo; }
    explicit impl_unparsedeclinfo_Unparsedeclinfo(patternrepresentation, patternrepresentation, unparseclause);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    unparsedeclinfo rewrite( rview );
    impl_patternrepresentation* patternrepresentation_1;
    impl_patternrepresentation* patternrepresentation_2;
    impl_unparseclause* unparseclause_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_declaration rewrite(rview) =0;
};
class impl_ac_declaration_AcDeclaration:public impl_ac_declaration{
public:
    enum_operators prod_sel() const
	{ return sel_AcDeclaration; }
    explicit impl_ac_declaration_AcDeclaration(ac_declaration_specifiers, ac_init_declarator_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_declaration rewrite( rview );
    impl_ac_declaration_specifiers* ac_declaration_specifiers_1;
    impl_ac_init_declarator_list* ac_init_declarator_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_declaration_list: sel_Consac_declaration_list;
    }
    explicit impl_ac_declaration_list(ac_declaration = 0, ac_declaration_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_declaration_list concat(c_ac_declaration_list, c_ac_declaration_list);
    ac_declaration_list reverse() const;
    ac_declaration_list rewrite(rview);
    ac_declaration last() const;
    ac_declaration_list append(ac_declaration);
    ac_declaration_list map(ac_declaration (*)(ac_declaration));
    ac_declaration_list filter( bool (*)(ac_declaration));
    ac_declaration_list merge( ac_declaration_list, ac_declaration (*)(ac_declaration, ac_declaration));
    ac_declaration reduce( ac_declaration, ac_declaration (*)(ac_declaration, ac_declaration));
    bool is_nil() const;
    ac_declaration ac_declaration_1;
    ac_declaration_list ac_declaration_list_1;
private:
    impl_ac_declaration_list* nil_rewrite(rview);
    impl_ac_declaration_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration_specifiers: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_declaration_specifiers: sel_Consac_declaration_specifiers;
    }
    explicit impl_ac_declaration_specifiers(ac_declaration_specifier = 0, ac_declaration_specifiers = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_declaration_specifiers concat(c_ac_declaration_specifiers, c_ac_declaration_specifiers);
    ac_declaration_specifiers reverse() const;
    ac_declaration_specifiers rewrite(rview);
    ac_declaration_specifier last() const;
    ac_declaration_specifiers append(ac_declaration_specifier);
    ac_declaration_specifiers map(ac_declaration_specifier (*)(ac_declaration_specifier));
    ac_declaration_specifiers filter( bool (*)(ac_declaration_specifier));
    ac_declaration_specifiers merge( ac_declaration_specifiers, ac_declaration_specifier (*)(ac_declaration_specifier, ac_declaration_specifier));
    ac_declaration_specifier reduce( ac_declaration_specifier, ac_declaration_specifier (*)(ac_declaration_specifier, ac_declaration_specifier));
    bool is_nil() const;
    ac_declaration_specifier ac_declaration_specifier_1;
    ac_declaration_specifiers ac_declaration_specifiers_1;
private:
    impl_ac_declaration_specifiers* nil_rewrite(rview);
    impl_ac_declaration_specifiers* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration_specifier: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_declaration_specifier rewrite(rview) =0;
};
class impl_ac_declaration_specifier_AcDeclSpecTypeQual:public impl_ac_declaration_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcDeclSpecTypeQual; }
    explicit impl_ac_declaration_specifier_AcDeclSpecTypeQual(ac_type_qualifier);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_declaration_specifier rewrite( rview );
    impl_ac_type_qualifier* ac_type_qualifier_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration_specifier_AcDeclSpecTypeSpec:public impl_ac_declaration_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcDeclSpecTypeSpec; }
    explicit impl_ac_declaration_specifier_AcDeclSpecTypeSpec(ac_type_specifier);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_declaration_specifier rewrite( rview );
    impl_ac_type_specifier* ac_type_specifier_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_declaration_specifier_AcDeclSpecStorageSpec:public impl_ac_declaration_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcDeclSpecStorageSpec; }
    explicit impl_ac_declaration_specifier_AcDeclSpecStorageSpec(ac_storage_class_specifier);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_declaration_specifier rewrite( rview );
    impl_ac_storage_class_specifier* ac_storage_class_specifier_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_storage_class_specifier rewrite(rview) =0;
};
class impl_ac_storage_class_specifier_AcVirtual:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcVirtual; }
    explicit impl_ac_storage_class_specifier_AcVirtual();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier_AcTypedef:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcTypedef; }
    explicit impl_ac_storage_class_specifier_AcTypedef();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier_AcExtern:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcExtern; }
    explicit impl_ac_storage_class_specifier_AcExtern();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier_AcStatic:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcStatic; }
    explicit impl_ac_storage_class_specifier_AcStatic();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier_AcRegister:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcRegister; }
    explicit impl_ac_storage_class_specifier_AcRegister();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_storage_class_specifier_AcAuto:public impl_ac_storage_class_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcAuto; }
    explicit impl_ac_storage_class_specifier_AcAuto();

    ac_storage_class_specifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_specifier: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_type_specifier rewrite(rview) =0;
};
class impl_ac_type_specifier_AcTypeSpec:public impl_ac_type_specifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcTypeSpec; }
    explicit impl_ac_type_specifier_AcTypeSpec(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_type_specifier rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_qualifier: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_type_qualifier rewrite(rview) =0;
};
class impl_ac_type_qualifier_AcNoQualifier:public impl_ac_type_qualifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcNoQualifier; }
    explicit impl_ac_type_qualifier_AcNoQualifier();

    ac_type_qualifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_qualifier_AcUnsigned:public impl_ac_type_qualifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcUnsigned; }
    explicit impl_ac_type_qualifier_AcUnsigned();

    ac_type_qualifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_qualifier_AcVolatile:public impl_ac_type_qualifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcVolatile; }
    explicit impl_ac_type_qualifier_AcVolatile();

    ac_type_qualifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_qualifier_AcConst:public impl_ac_type_qualifier{
public:
    enum_operators prod_sel() const
	{ return sel_AcConst; }
    explicit impl_ac_type_qualifier_AcConst();

    ac_type_qualifier rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_init_declarator_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_init_declarator_list: sel_Consac_init_declarator_list;
    }
    explicit impl_ac_init_declarator_list(ac_init_declarator = 0, ac_init_declarator_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_init_declarator_list concat(c_ac_init_declarator_list, c_ac_init_declarator_list);
    ac_init_declarator_list reverse() const;
    ac_init_declarator_list rewrite(rview);
    ac_init_declarator last() const;
    ac_init_declarator_list append(ac_init_declarator);
    ac_init_declarator_list map(ac_init_declarator (*)(ac_init_declarator));
    ac_init_declarator_list filter( bool (*)(ac_init_declarator));
    ac_init_declarator_list merge( ac_init_declarator_list, ac_init_declarator (*)(ac_init_declarator, ac_init_declarator));
    ac_init_declarator reduce( ac_init_declarator, ac_init_declarator (*)(ac_init_declarator, ac_init_declarator));
    bool is_nil() const;
    ac_init_declarator ac_init_declarator_1;
    ac_init_declarator_list ac_init_declarator_list_1;
private:
    impl_ac_init_declarator_list* nil_rewrite(rview);
    impl_ac_init_declarator_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_init_declarator: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_init_declarator rewrite(rview) =0;
};
class impl_ac_init_declarator_AcInitDecl:public impl_ac_init_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcInitDecl; }
    explicit impl_ac_init_declarator_AcInitDecl(ac_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_init_declarator rewrite( rview );
    impl_ac_declarator* ac_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_declarator: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_declarator rewrite(rview) =0;
};
class impl_ac_declarator_AcDeclarator:public impl_ac_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDeclarator; }
    explicit impl_ac_declarator_AcDeclarator(ac_pointer_option, ac_ref_option, ac_direct_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_declarator rewrite( rview );
    impl_ac_pointer_option* ac_pointer_option_1;
    impl_ac_ref_option* ac_ref_option_1;
    impl_ac_direct_declarator* ac_direct_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_direct_declarator rewrite(rview) =0;
};
class impl_ac_direct_declarator_AcOperatorDeclId:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcOperatorDeclId; }
    explicit impl_ac_direct_declarator_AcOperatorDeclId(ac_operator_name);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ac_operator_name* ac_operator_name_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcConvOperatorDecl:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcConvOperatorDecl; }
    explicit impl_ac_direct_declarator_AcConvOperatorDecl(ID, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ID* ID_1;
    impl_ID* ID_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcMemberDecl:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcMemberDecl; }
    explicit impl_ac_direct_declarator_AcMemberDecl(ID, ID, ac_constant_expression_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ID* ID_1;
    impl_ID* ID_2;
    impl_ac_constant_expression_list* ac_constant_expression_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcQualifiedDeclProto:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcQualifiedDeclProto; }
    explicit impl_ac_direct_declarator_AcQualifiedDeclProto(ac_class_qualifier_list, ac_direct_declarator, ac_parameter_type_list, ac_type_qualifier);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ac_class_qualifier_list* ac_class_qualifier_list_1;
    impl_ac_direct_declarator* ac_direct_declarator_1;
    impl_ac_parameter_type_list* ac_parameter_type_list_1;
    impl_ac_type_qualifier* ac_type_qualifier_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcDirectDeclProto:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirectDeclProto; }
    explicit impl_ac_direct_declarator_AcDirectDeclProto(ac_direct_declarator, ac_parameter_type_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ac_direct_declarator* ac_direct_declarator_1;
    impl_ac_parameter_type_list* ac_parameter_type_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcDirectDeclArray:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirectDeclArray; }
    explicit impl_ac_direct_declarator_AcDirectDeclArray(ac_direct_declarator, ac_constant_expression_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ac_direct_declarator* ac_direct_declarator_1;
    impl_ac_constant_expression_option* ac_constant_expression_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcDirectDeclPack:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirectDeclPack; }
    explicit impl_ac_direct_declarator_AcDirectDeclPack(ac_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ac_declarator* ac_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_declarator_AcDirectDeclId:public impl_ac_direct_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirectDeclId; }
    explicit impl_ac_direct_declarator_AcDirectDeclId(ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_declarator rewrite( rview );
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_pointer_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_pointer_option rewrite(rview) =0;
};
class impl_ac_pointer_option_Yespointer:public impl_ac_pointer_option{
public:
    enum_operators prod_sel() const
	{ return sel_Yespointer; }
    explicit impl_ac_pointer_option_Yespointer(ac_pointer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_pointer_option rewrite( rview );
    impl_ac_pointer* ac_pointer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_pointer_option_Nopointer:public impl_ac_pointer_option{
public:
    enum_operators prod_sel() const
	{ return sel_Nopointer; }
    explicit impl_ac_pointer_option_Nopointer();

    ac_pointer_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_pointer: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_pointer rewrite(rview) =0;
};
class impl_ac_pointer_AcPointerCons:public impl_ac_pointer{
public:
    enum_operators prod_sel() const
	{ return sel_AcPointerCons; }
    explicit impl_ac_pointer_AcPointerCons(ac_type_qualifier_list, ac_pointer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_pointer rewrite( rview );
    impl_ac_type_qualifier_list* ac_type_qualifier_list_1;
    impl_ac_pointer* ac_pointer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_pointer_AcPointerNil:public impl_ac_pointer{
public:
    enum_operators prod_sel() const
	{ return sel_AcPointerNil; }
    explicit impl_ac_pointer_AcPointerNil(ac_type_qualifier_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_pointer rewrite( rview );
    impl_ac_type_qualifier_list* ac_type_qualifier_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_ref_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_ref_option rewrite(rview) =0;
};
class impl_ac_ref_option_AcRef:public impl_ac_ref_option{
public:
    enum_operators prod_sel() const
	{ return sel_AcRef; }
    explicit impl_ac_ref_option_AcRef();

    ac_ref_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_ref_option_AcNoRef:public impl_ac_ref_option{
public:
    enum_operators prod_sel() const
	{ return sel_AcNoRef; }
    explicit impl_ac_ref_option_AcNoRef();

    ac_ref_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_operator_name: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int line;
    casestring file;
    ac_operator_name rewrite(rview) =0;
};
class impl_ac_operator_name_AcOperatorName:public impl_ac_operator_name{
public:
    enum_operators prod_sel() const
	{ return sel_AcOperatorName; }
    explicit impl_ac_operator_name_AcOperatorName(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_operator_name rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_class_qualifier_help_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_class_qualifier_help_list: sel_Consac_class_qualifier_help_list;
    }
    explicit impl_ac_class_qualifier_help_list(ac_direct_declarator = 0, ac_class_qualifier_help_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_class_qualifier_help_list concat(c_ac_class_qualifier_help_list, c_ac_class_qualifier_help_list);
    ac_class_qualifier_help_list reverse() const;
    ac_class_qualifier_help_list rewrite(rview);
    ac_direct_declarator last() const;
    ac_class_qualifier_help_list append(ac_direct_declarator);
    ac_class_qualifier_help_list map(ac_direct_declarator (*)(ac_direct_declarator));
    ac_class_qualifier_help_list filter( bool (*)(ac_direct_declarator));
    ac_class_qualifier_help_list merge( ac_class_qualifier_help_list, ac_direct_declarator (*)(ac_direct_declarator, ac_direct_declarator));
    ac_direct_declarator reduce( ac_direct_declarator, ac_direct_declarator (*)(ac_direct_declarator, ac_direct_declarator));
    bool is_nil() const;
    ac_direct_declarator ac_direct_declarator_1;
    ac_class_qualifier_help_list ac_class_qualifier_help_list_1;
private:
    impl_ac_class_qualifier_help_list* nil_rewrite(rview);
    impl_ac_class_qualifier_help_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_class_qualifier_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_class_qualifier_list: sel_Consac_class_qualifier_list;
    }
    explicit impl_ac_class_qualifier_list(ID = 0, ac_class_qualifier_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_class_qualifier_list concat(c_ac_class_qualifier_list, c_ac_class_qualifier_list);
    ac_class_qualifier_list reverse() const;
    ac_class_qualifier_list rewrite(rview);
    ID last() const;
    ac_class_qualifier_list append(ID);
    ac_class_qualifier_list map(ID (*)(ID));
    ac_class_qualifier_list filter( bool (*)(ID));
    ac_class_qualifier_list merge( ac_class_qualifier_list, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    ac_class_qualifier_list ac_class_qualifier_list_1;
private:
    impl_ac_class_qualifier_list* nil_rewrite(rview);
    impl_ac_class_qualifier_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_type_qualifier_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_type_qualifier_list: sel_Consac_type_qualifier_list;
    }
    explicit impl_ac_type_qualifier_list(ac_type_qualifier = 0, ac_type_qualifier_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_type_qualifier_list concat(c_ac_type_qualifier_list, c_ac_type_qualifier_list);
    ac_type_qualifier_list reverse() const;
    ac_type_qualifier_list rewrite(rview);
    ac_type_qualifier last() const;
    ac_type_qualifier_list append(ac_type_qualifier);
    ac_type_qualifier_list map(ac_type_qualifier (*)(ac_type_qualifier));
    ac_type_qualifier_list filter( bool (*)(ac_type_qualifier));
    ac_type_qualifier_list merge( ac_type_qualifier_list, ac_type_qualifier (*)(ac_type_qualifier, ac_type_qualifier));
    ac_type_qualifier reduce( ac_type_qualifier, ac_type_qualifier (*)(ac_type_qualifier, ac_type_qualifier));
    bool is_nil() const;
    ac_type_qualifier ac_type_qualifier_1;
    ac_type_qualifier_list ac_type_qualifier_list_1;
private:
    impl_ac_type_qualifier_list* nil_rewrite(rview);
    impl_ac_type_qualifier_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_parameter_type_list: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_parameter_type_list rewrite(rview) =0;
};
class impl_ac_parameter_type_list_AcParList3Dot:public impl_ac_parameter_type_list{
public:
    enum_operators prod_sel() const
	{ return sel_AcParList3Dot; }
    explicit impl_ac_parameter_type_list_AcParList3Dot(ac_parameter_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_parameter_type_list rewrite( rview );
    impl_ac_parameter_list* ac_parameter_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_parameter_type_list_AcParList:public impl_ac_parameter_type_list{
public:
    enum_operators prod_sel() const
	{ return sel_AcParList; }
    explicit impl_ac_parameter_type_list_AcParList(ac_parameter_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_parameter_type_list rewrite( rview );
    impl_ac_parameter_list* ac_parameter_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_parameter_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_parameter_list: sel_Consac_parameter_list;
    }
    explicit impl_ac_parameter_list(ac_parameter_declaration = 0, ac_parameter_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_parameter_list concat(c_ac_parameter_list, c_ac_parameter_list);
    ac_parameter_list reverse() const;
    ac_parameter_list rewrite(rview);
    ac_parameter_declaration last() const;
    ac_parameter_list append(ac_parameter_declaration);
    ac_parameter_list map(ac_parameter_declaration (*)(ac_parameter_declaration));
    ac_parameter_list filter( bool (*)(ac_parameter_declaration));
    ac_parameter_list merge( ac_parameter_list, ac_parameter_declaration (*)(ac_parameter_declaration, ac_parameter_declaration));
    ac_parameter_declaration reduce( ac_parameter_declaration, ac_parameter_declaration (*)(ac_parameter_declaration, ac_parameter_declaration));
    bool is_nil() const;
    ac_parameter_declaration ac_parameter_declaration_1;
    ac_parameter_list ac_parameter_list_1;
private:
    impl_ac_parameter_list* nil_rewrite(rview);
    impl_ac_parameter_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_parameter_declaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_parameter_declaration rewrite(rview) =0;
};
class impl_ac_parameter_declaration_AcParDeclAbsdecl:public impl_ac_parameter_declaration{
public:
    enum_operators prod_sel() const
	{ return sel_AcParDeclAbsdecl; }
    explicit impl_ac_parameter_declaration_AcParDeclAbsdecl(ac_declaration_specifiers, ac_abstract_declarator, ac_constant_expression_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_parameter_declaration rewrite( rview );
    impl_ac_declaration_specifiers* ac_declaration_specifiers_1;
    impl_ac_abstract_declarator* ac_abstract_declarator_1;
    impl_ac_constant_expression_option* ac_constant_expression_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_parameter_declaration_AcParDeclDecl:public impl_ac_parameter_declaration{
public:
    enum_operators prod_sel() const
	{ return sel_AcParDeclDecl; }
    explicit impl_ac_parameter_declaration_AcParDeclDecl(ac_declaration_specifiers, ac_declarator, ac_constant_expression_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_parameter_declaration rewrite( rview );
    impl_ac_declaration_specifiers* ac_declaration_specifiers_1;
    impl_ac_declarator* ac_declarator_1;
    impl_ac_constant_expression_option* ac_constant_expression_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_identifier_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_identifier_list: sel_Consac_identifier_list;
    }
    explicit impl_ac_identifier_list(ID = 0, ac_identifier_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_identifier_list concat(c_ac_identifier_list, c_ac_identifier_list);
    ac_identifier_list reverse() const;
    ac_identifier_list rewrite(rview);
    ID last() const;
    ac_identifier_list append(ID);
    ac_identifier_list map(ID (*)(ID));
    ac_identifier_list filter( bool (*)(ID));
    ac_identifier_list merge( ac_identifier_list, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    ac_identifier_list ac_identifier_list_1;
private:
    impl_ac_identifier_list* nil_rewrite(rview);
    impl_ac_identifier_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_abstract_declarator: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_abstract_declarator rewrite(rview) =0;
};
class impl_ac_abstract_declarator_AcAbsdeclDirdecl:public impl_ac_abstract_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcAbsdeclDirdecl; }
    explicit impl_ac_abstract_declarator_AcAbsdeclDirdecl(ac_pointer_option, ac_direct_abstract_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_abstract_declarator rewrite( rview );
    impl_ac_pointer_option* ac_pointer_option_1;
    impl_ac_direct_abstract_declarator* ac_direct_abstract_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_abstract_declarator_AcAbsdeclPointer:public impl_ac_abstract_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcAbsdeclPointer; }
    explicit impl_ac_abstract_declarator_AcAbsdeclPointer(ac_pointer);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_abstract_declarator rewrite( rview );
    impl_ac_pointer* ac_pointer_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_abstract_declarator_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_direct_abstract_declarator_option rewrite(rview) =0;
};
class impl_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator:public impl_ac_direct_abstract_declarator_option{
public:
    enum_operators prod_sel() const
	{ return sel_Yesac_direct_abstract_declarator; }
    explicit impl_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator(ac_direct_abstract_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_abstract_declarator_option rewrite( rview );
    impl_ac_direct_abstract_declarator* ac_direct_abstract_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator:public impl_ac_direct_abstract_declarator_option{
public:
    enum_operators prod_sel() const
	{ return sel_Noac_direct_abstract_declarator; }
    explicit impl_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator();

    ac_direct_abstract_declarator_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_abstract_declarator: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_direct_abstract_declarator rewrite(rview) =0;
};
class impl_ac_direct_abstract_declarator_AcDirAbsdeclFn:public impl_ac_direct_abstract_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirAbsdeclFn; }
    explicit impl_ac_direct_abstract_declarator_AcDirAbsdeclFn(ac_direct_abstract_declarator_option, ac_parameter_type_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_abstract_declarator rewrite( rview );
    impl_ac_direct_abstract_declarator_option* ac_direct_abstract_declarator_option_1;
    impl_ac_parameter_type_list* ac_parameter_type_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_abstract_declarator_AcDirAbsdeclArray:public impl_ac_direct_abstract_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirAbsdeclArray; }
    explicit impl_ac_direct_abstract_declarator_AcDirAbsdeclArray(ac_direct_abstract_declarator_option, ac_constant_expression_option);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_abstract_declarator rewrite( rview );
    impl_ac_direct_abstract_declarator_option* ac_direct_abstract_declarator_option_1;
    impl_ac_constant_expression_option* ac_constant_expression_option_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_direct_abstract_declarator_AcDirAbsdeclPack:public impl_ac_direct_abstract_declarator{
public:
    enum_operators prod_sel() const
	{ return sel_AcDirAbsdeclPack; }
    explicit impl_ac_direct_abstract_declarator_AcDirAbsdeclPack(ac_abstract_declarator);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_direct_abstract_declarator rewrite( rview );
    impl_ac_abstract_declarator* ac_abstract_declarator_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_constant_expression_option: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_constant_expression_option rewrite(rview) =0;
};
class impl_ac_constant_expression_option_Noac_constant_expression:public impl_ac_constant_expression_option{
public:
    enum_operators prod_sel() const
	{ return sel_Noac_constant_expression; }
    explicit impl_ac_constant_expression_option_Noac_constant_expression();

    ac_constant_expression_option rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_constant_expression_option_Yesac_constant_expression:public impl_ac_constant_expression_option{
public:
    enum_operators prod_sel() const
	{ return sel_Yesac_constant_expression; }
    explicit impl_ac_constant_expression_option_Yesac_constant_expression(ac_constant_expression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_constant_expression_option rewrite( rview );
    impl_ac_constant_expression* ac_constant_expression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_constant_expression: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_constant_expression rewrite(rview) =0;
};
class impl_ac_constant_expression_AcConstExpr:public impl_ac_constant_expression{
public:
    enum_operators prod_sel() const
	{ return sel_AcConstExpr; }
    explicit impl_ac_constant_expression_AcConstExpr(Cexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_constant_expression rewrite( rview );
    impl_Cexpression* Cexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_constant_expression_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_constant_expression_list: sel_Consac_constant_expression_list;
    }
    explicit impl_ac_constant_expression_list(ac_constant_expression = 0, ac_constant_expression_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_constant_expression_list concat(c_ac_constant_expression_list, c_ac_constant_expression_list);
    ac_constant_expression_list reverse() const;
    ac_constant_expression_list rewrite(rview);
    ac_constant_expression last() const;
    ac_constant_expression_list append(ac_constant_expression);
    ac_constant_expression_list map(ac_constant_expression (*)(ac_constant_expression));
    ac_constant_expression_list filter( bool (*)(ac_constant_expression));
    ac_constant_expression_list merge( ac_constant_expression_list, ac_constant_expression (*)(ac_constant_expression, ac_constant_expression));
    ac_constant_expression reduce( ac_constant_expression, ac_constant_expression (*)(ac_constant_expression, ac_constant_expression));
    bool is_nil() const;
    ac_constant_expression ac_constant_expression_1;
    ac_constant_expression_list ac_constant_expression_list_1;
private:
    impl_ac_constant_expression_list* nil_rewrite(rview);
    impl_ac_constant_expression_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_opt_base_init_list: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_opt_base_init_list rewrite(rview) =0;
};
class impl_ac_opt_base_init_list_AcYesBaseInit:public impl_ac_opt_base_init_list{
public:
    enum_operators prod_sel() const
	{ return sel_AcYesBaseInit; }
    explicit impl_ac_opt_base_init_list_AcYesBaseInit(ac_base_init_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_opt_base_init_list rewrite( rview );
    impl_ac_base_init_list* ac_base_init_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_opt_base_init_list_AcNoBaseInit:public impl_ac_opt_base_init_list{
public:
    enum_operators prod_sel() const
	{ return sel_AcNoBaseInit; }
    explicit impl_ac_opt_base_init_list_AcNoBaseInit();

    ac_opt_base_init_list rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_ac_base_init_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilac_base_init_list: sel_Consac_base_init_list;
    }
    explicit impl_ac_base_init_list(ac_base_init = 0, ac_base_init_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend ac_base_init_list concat(c_ac_base_init_list, c_ac_base_init_list);
    ac_base_init_list reverse() const;
    ac_base_init_list rewrite(rview);
    ac_base_init last() const;
    ac_base_init_list append(ac_base_init);
    ac_base_init_list map(ac_base_init (*)(ac_base_init));
    ac_base_init_list filter( bool (*)(ac_base_init));
    ac_base_init_list merge( ac_base_init_list, ac_base_init (*)(ac_base_init, ac_base_init));
    ac_base_init reduce( ac_base_init, ac_base_init (*)(ac_base_init, ac_base_init));
    bool is_nil() const;
    ac_base_init ac_base_init_1;
    ac_base_init_list ac_base_init_list_1;
private:
    impl_ac_base_init_list* nil_rewrite(rview);
    impl_ac_base_init_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_ac_base_init: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    ac_base_init rewrite(rview) =0;
};
class impl_ac_base_init_AcBaseInit:public impl_ac_base_init{
public:
    enum_operators prod_sel() const
	{ return sel_AcBaseInit; }
    explicit impl_ac_base_init_AcBaseInit(ID, ac_constant_expression_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    ac_base_init rewrite( rview );
    impl_ID* ID_1;
    impl_ac_constant_expression_list* ac_constant_expression_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_baseclass_declarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilbaseclass_declarations: sel_Consbaseclass_declarations;
    }
    explicit impl_baseclass_declarations(baseclass_decl = 0, baseclass_declarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend baseclass_declarations concat(c_baseclass_declarations, c_baseclass_declarations);
    baseclass_declarations reverse() const;
    baseclass_declarations rewrite(rview);
    baseclass_decl last() const;
    baseclass_declarations append(baseclass_decl);
    baseclass_declarations map(baseclass_decl (*)(baseclass_decl));
    baseclass_declarations filter( bool (*)(baseclass_decl));
    baseclass_declarations merge( baseclass_declarations, baseclass_decl (*)(baseclass_decl, baseclass_decl));
    baseclass_decl reduce( baseclass_decl, baseclass_decl (*)(baseclass_decl, baseclass_decl));
    bool is_nil() const;
    baseclass_decl baseclass_decl_1;
    baseclass_declarations baseclass_declarations_1;
private:
    impl_baseclass_declarations* nil_rewrite(rview);
    impl_baseclass_declarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_baseclass_decl: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    baseclass_decl rewrite(rview) =0;
};
class impl_baseclass_decl_BaseClassDecl:public impl_baseclass_decl{
public:
    enum_operators prod_sel() const
	{ return sel_BaseClassDecl; }
    explicit impl_baseclass_decl_BaseClassDecl(ID, baseclass_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    baseclass_decl rewrite( rview );
    impl_ID* ID_1;
    impl_baseclass_list* baseclass_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_baseclass_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilbaseclass_list: sel_Consbaseclass_list;
    }
    explicit impl_baseclass_list(ID = 0, baseclass_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend baseclass_list concat(c_baseclass_list, c_baseclass_list);
    baseclass_list reverse() const;
    baseclass_list rewrite(rview);
    ID last() const;
    baseclass_list append(ID);
    baseclass_list map(ID (*)(ID));
    baseclass_list filter( bool (*)(ID));
    baseclass_list merge( baseclass_list, ID (*)(ID, ID));
    ID reduce( ID, ID (*)(ID, ID));
    bool is_nil() const;
    ID ID_1;
    baseclass_list baseclass_list_1;
private:
    impl_baseclass_list* nil_rewrite(rview);
    impl_baseclass_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_error: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    error rewrite(rview) =0;
};
class impl_error_Warning:public impl_error{
public:
    enum_operators prod_sel() const
	{ return sel_Warning; }
    explicit impl_error_Warning(fileline, problem);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    error rewrite( rview );
    impl_fileline* fileline_1;
    impl_problem* problem_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_error_NonFatal:public impl_error{
public:
    enum_operators prod_sel() const
	{ return sel_NonFatal; }
    explicit impl_error_NonFatal(fileline, problem);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    error rewrite( rview );
    impl_fileline* fileline_1;
    impl_problem* problem_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_error_Fatal:public impl_error{
public:
    enum_operators prod_sel() const
	{ return sel_Fatal; }
    explicit impl_error_Fatal(fileline, problem);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    error rewrite( rview );
    impl_fileline* fileline_1;
    impl_problem* problem_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    problem rewrite(rview) =0;
};
class impl_problem_Problem6:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem6; }
    explicit impl_problem_Problem6(casestring, casestring, casestring, casestring, casestring, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
    impl_casestring* casestring_3;
    impl_casestring* casestring_4;
    impl_casestring* casestring_5;
    impl_casestring* casestring_6;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem5:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem5; }
    explicit impl_problem_Problem5(casestring, casestring, casestring, casestring, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
    impl_casestring* casestring_3;
    impl_casestring* casestring_4;
    impl_casestring* casestring_5;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem4:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem4; }
    explicit impl_problem_Problem4(casestring, casestring, casestring, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
    impl_casestring* casestring_3;
    impl_casestring* casestring_4;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem3int1:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem3int1; }
    explicit impl_problem_Problem3int1(casestring, casestring, casestring, integer, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
    impl_casestring* casestring_3;
    impl_integer* integer_1;
    impl_casestring* casestring_4;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem3:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem3; }
    explicit impl_problem_Problem3(casestring, casestring, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
    impl_casestring* casestring_3;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem2:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem2; }
    explicit impl_problem_Problem2(casestring, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_casestring* casestring_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1storageoption1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1storageoption1ID; }
    explicit impl_problem_Problem1storageoption1ID(casestring, storageoption, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_storageoption* storageoption_1;
    impl_casestring* casestring_2;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1INT1ID1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1INT1ID1ID; }
    explicit impl_problem_Problem1INT1ID1ID(casestring, INT, casestring, ID, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_INT* INT_1;
    impl_casestring* casestring_2;
    impl_ID* ID_1;
    impl_casestring* casestring_3;
    impl_ID* ID_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1ID1ID1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1ID1ID1ID; }
    explicit impl_problem_Problem1ID1ID1ID(casestring, ID, casestring, ID, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_ID* ID_1;
    impl_casestring* casestring_2;
    impl_ID* ID_2;
    impl_casestring* casestring_3;
    impl_ID* ID_3;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1INT1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1INT1ID; }
    explicit impl_problem_Problem1INT1ID(casestring, INT, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_INT* INT_1;
    impl_casestring* casestring_2;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1int1:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1int1; }
    explicit impl_problem_Problem1int1(casestring, integer, casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_integer* integer_1;
    impl_casestring* casestring_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1INT:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1INT; }
    explicit impl_problem_Problem1INT(casestring, INT);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_INT* INT_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1t1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1t1ID; }
    explicit impl_problem_Problem1t1ID(casestring, IDtype, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_IDtype* IDtype_1;
    impl_casestring* casestring_2;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1ID1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1ID1ID; }
    explicit impl_problem_Problem1ID1ID(casestring, ID, casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_ID* ID_1;
    impl_casestring* casestring_2;
    impl_ID* ID_2;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1we:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1we; }
    explicit impl_problem_Problem1we(casestring, withexpression);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_withexpression* withexpression_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1tID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1tID; }
    explicit impl_problem_Problem1tID(casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1ID:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1ID; }
    explicit impl_problem_Problem1ID(casestring, ID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
    impl_ID* ID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_problem_Problem1:public impl_problem{
public:
    enum_operators prod_sel() const
	{ return sel_Problem1; }
    explicit impl_problem_Problem1(casestring);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    problem rewrite( rview );
    impl_casestring* casestring_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_addedphylumdeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Niladdedphylumdeclarations: sel_Consaddedphylumdeclarations;
    }
    explicit impl_addedphylumdeclarations(addedphylumdeclaration = 0, addedphylumdeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend addedphylumdeclarations concat(c_addedphylumdeclarations, c_addedphylumdeclarations);
    addedphylumdeclarations reverse() const;
    addedphylumdeclarations rewrite(rview);
    addedphylumdeclaration last() const;
    addedphylumdeclarations append(addedphylumdeclaration);
    addedphylumdeclarations map(addedphylumdeclaration (*)(addedphylumdeclaration));
    addedphylumdeclarations filter( bool (*)(addedphylumdeclaration));
    addedphylumdeclarations merge( addedphylumdeclarations, addedphylumdeclaration (*)(addedphylumdeclaration, addedphylumdeclaration));
    addedphylumdeclaration reduce( addedphylumdeclaration, addedphylumdeclaration (*)(addedphylumdeclaration, addedphylumdeclaration));
    bool is_nil() const;
    addedphylumdeclaration addedphylumdeclaration_1;
    addedphylumdeclarations addedphylumdeclarations_1;
private:
    impl_addedphylumdeclarations* nil_rewrite(rview);
    impl_addedphylumdeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_addedphylumdeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    bool added;
    addedphylumdeclaration rewrite(rview) =0;
};
class impl_addedphylumdeclaration_AddedPhylumdeclaration:public impl_addedphylumdeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_AddedPhylumdeclaration; }
    explicit impl_addedphylumdeclaration_AddedPhylumdeclaration(uniqID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    addedphylumdeclaration rewrite( rview );
    impl_uniqID* uniqID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_countedphylumdeclarations: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilcountedphylumdeclarations: sel_Conscountedphylumdeclarations;
    }
    explicit impl_countedphylumdeclarations(countedphylumdeclaration = 0, countedphylumdeclarations = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend countedphylumdeclarations concat(c_countedphylumdeclarations, c_countedphylumdeclarations);
    countedphylumdeclarations reverse() const;
    countedphylumdeclarations rewrite(rview);
    countedphylumdeclaration last() const;
    countedphylumdeclarations append(countedphylumdeclaration);
    countedphylumdeclarations map(countedphylumdeclaration (*)(countedphylumdeclaration));
    countedphylumdeclarations filter( bool (*)(countedphylumdeclaration));
    countedphylumdeclarations merge( countedphylumdeclarations, countedphylumdeclaration (*)(countedphylumdeclaration, countedphylumdeclaration));
    countedphylumdeclaration reduce( countedphylumdeclaration, countedphylumdeclaration (*)(countedphylumdeclaration, countedphylumdeclaration));
    bool is_nil() const;
    countedphylumdeclaration countedphylumdeclaration_1;
    countedphylumdeclarations countedphylumdeclarations_1;
private:
    impl_countedphylumdeclarations* nil_rewrite(rview);
    impl_countedphylumdeclarations* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_countedphylumdeclaration: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int count;
    countedphylumdeclaration rewrite(rview) =0;
};
class impl_countedphylumdeclaration_CountedPhylumdeclaration:public impl_countedphylumdeclaration{
public:
    enum_operators prod_sel() const
	{ return sel_CountedPhylumdeclaration; }
    explicit impl_countedphylumdeclaration_CountedPhylumdeclaration(uniqID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    countedphylumdeclaration rewrite( rview );
    impl_uniqID* uniqID_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_charruns: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    int number;
    charruns set(int _n= 0);
    charruns rewrite(rview) =0;
};
class impl_charruns_Stars:public impl_charruns{
public:
    enum_operators prod_sel() const
	{ return sel_Stars; }
    explicit impl_charruns_Stars();

    charruns rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_charruns_QuotedNewlines:public impl_charruns{
public:
    enum_operators prod_sel() const
	{ return sel_QuotedNewlines; }
    explicit impl_charruns_QuotedNewlines();

    charruns rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_charruns_Newlines:public impl_charruns{
public:
    enum_operators prod_sel() const
	{ return sel_Newlines; }
    explicit impl_charruns_Newlines();

    charruns rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_bindingidmarks: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilbindingidmarks: sel_Consbindingidmarks;
    }
    explicit impl_bindingidmarks(bindingidmark = 0, bindingidmarks = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend bindingidmarks concat(c_bindingidmarks, c_bindingidmarks);
    bindingidmarks reverse() const;
    bindingidmarks rewrite(rview);
    bindingidmark last() const;
    bindingidmarks append(bindingidmark);
    bindingidmarks map(bindingidmark (*)(bindingidmark));
    bindingidmarks filter( bool (*)(bindingidmark));
    bindingidmarks merge( bindingidmarks, bindingidmark (*)(bindingidmark, bindingidmark));
    bindingidmark reduce( bindingidmark, bindingidmark (*)(bindingidmark, bindingidmark));
    bool is_nil() const;
    bindingidmark bindingidmark_1;
    bindingidmarks bindingidmarks_1;
private:
    impl_bindingidmarks* nil_rewrite(rview);
    impl_bindingidmarks* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_bindingidmark: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    bool marked;
    bindingidmark rewrite(rview) =0;
};
class impl_bindingidmark_BindingIdMark:public impl_bindingidmark{
public:
    enum_operators prod_sel() const
	{ return sel_BindingIdMark; }
    explicit impl_bindingidmark_BindingIdMark(uniqID);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    bindingidmark rewrite( rview );
    impl_uniqID* uniqID_1;
private:
    void do_unparse(printer_functor, uview);
};

//} // namespace Phylum


extern bool kc_storageclass_still_uniq[];

typedef struct {
    int created;
    int existing_not_found;
    int free_called[2];
    int freed[2];
} KC_OPERATOR_STATISTICS;

#ifdef KC_STATISTICS
# define print_operator_statistics(kc_f) do_print_operator_statistics(kc_f)
void	do_print_operator_statistics(FILE*);
#else
# define print_operator_statistics(kc_f)
#endif

typedef class hashtable_struct_t* hashtable_t;
const char *phylumname_or_error ( enum_phyla );
const char *kc_operatorname_or_error ( enum_operators );


} // namespace kc
#endif // KC_TYPES_HEADER
