/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.util;

import com.sun.tools.doclets.util.PathSpecifier;
import com.sun.tools.doclets.util.Specifier;
import java.util.LinkedList;
import java.util.List;

public class FileSpecifier {
    protected PathSpecifier pathSpec;
    protected Specifier nameSpec;
    String separator = "";

    public FileSpecifier(String pattern) {
        this.separator = System.getProperty("file.separator");
        LinkedList pList = PathSpecifier.parsePath(pattern);
        this.initSpec(pList);
    }

    public FileSpecifier(String s, String aSeparator) {
        this.separator = aSeparator;
        LinkedList pList = PathSpecifier.parsePath(s, this.separator);
        this.initSpec(pList);
    }

    public FileSpecifier(List pList) {
        this.separator = System.getProperty("file.separator");
        this.initSpec(pList);
    }

    public FileSpecifier(List pList, String aSeparator) {
        this.separator = aSeparator;
        this.initSpec(pList);
    }

    protected void initSpec(List pList) {
        if (pList == null || pList.size() == 0) {
            this.nameSpec = new Specifier("*");
            this.pathSpec = new PathSpecifier("*");
            return;
        }
        LinkedList pLL = new LinkedList(pList);
        String s = (String)pLL.getLast();
        this.nameSpec = new Specifier(s);
        pLL.removeLast();
        this.pathSpec = new PathSpecifier(pLL);
    }

    public boolean match(String s) {
        String separator = System.getProperty("file.separator");
        return this.match(s, separator);
    }

    public boolean match(String path, String separator) {
        if (path == null || path.equals("")) {
            return false;
        }
        LinkedList testList = PathSpecifier.parsePath(path, separator);
        String filename = (String)testList.getLast();
        if (!this.nameSpec.match(filename)) {
            return false;
        }
        testList.removeLast();
        return this.pathSpec.match(testList);
    }

    public String toString() {
        String s = this.pathSpec.toString();
        if (s != "") {
            s = s + this.separator;
        }
        s = s + this.nameSpec.toString();
        return s;
    }
}

