#include "mainwindow.h"
#include "gpsshogi/revision.h"
#include <qapplication.h>
#include <QLibraryInfo>
#include <QLocale>
#include <QTranslator>
#include <iostream>
#include <string>

int main(int argc, char **argv)
{
  QApplication app(argc, argv);
  Q_INIT_RESOURCE(gui);
  QStringList opts = app.arguments();
  if (opts.contains("--version")) {
    std::cout << "viewer "  << gpsshogi::gpsshogi_revision << "\n\n"
       << gpsshogi::gpsshogi_copyright << "\n";
    return 0;
  } else if (opts.contains("--help")) {
    std::cout << 
      "USAGE: viewer [options]\n" <<
      " --version  show version\n" <<
      " --help     show this help message\n";
    return 0;
  }
  QTranslator qtTranslator;
  qtTranslator.load("qt_" + QLocale::system().name(),
                    QLibraryInfo::location(QLibraryInfo::TranslationsPath));
  app.installTranslator(&qtTranslator);

  QTranslator translator;
  translator.load("viewer_" + QLocale::system().name());
  app.installTranslator(&translator);
  MainWindow mainWin;
  app.setMainWidget(&mainWin);
  mainWin.show();
  return app.exec();
}
