/* ChannelListReader.c generated by valac 0.34.4, the Vala compiler
 * generated from ChannelListReader.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/mpegts/mpegts.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
typedef struct _DVBioChannelListReaderPrivate DVBioChannelListReaderPrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_PARAMETER (dvb_parameter_get_type ())
#define DVB_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PARAMETER, DVBParameter))
#define DVB_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PARAMETER, DVBParameterClass))
#define DVB_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PARAMETER))
#define DVB_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PARAMETER))
#define DVB_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PARAMETER, DVBParameterClass))

typedef struct _DVBParameter DVBParameter;
typedef struct _DVBParameterClass DVBParameterClass;

#define DVB_TYPE_DVB_TPARAMETER (dvb_dvb_tparameter_get_type ())
#define DVB_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter))
#define DVB_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))
#define DVB_IS_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_TPARAMETER))
#define DVB_IS_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_TPARAMETER))
#define DVB_DVB_TPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))

typedef struct _DVBDvbTParameter DVBDvbTParameter;
typedef struct _DVBDvbTParameterClass DVBDvbTParameterClass;

#define DVB_TYPE_DVB_SPARAMETER (dvb_dvb_sparameter_get_type ())
#define DVB_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameter))
#define DVB_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))
#define DVB_IS_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_SPARAMETER))
#define DVB_IS_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_SPARAMETER))
#define DVB_DVB_SPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))

typedef struct _DVBDvbSParameter DVBDvbSParameter;
typedef struct _DVBDvbSParameterClass DVBDvbSParameterClass;

#define DVB_TYPE_DVB_CEUROPE_PARAMETER (dvb_dvb_ceurope_parameter_get_type ())
#define DVB_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameter))
#define DVB_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))
#define DVB_IS_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_IS_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_DVB_CEUROPE_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))

typedef struct _DVBDvbCEuropeParameter DVBDvbCEuropeParameter;
typedef struct _DVBDvbCEuropeParameterClass DVBDvbCEuropeParameterClass;

struct _DVBioChannelListReader {
	GObject parent_instance;
	DVBioChannelListReaderPrivate * priv;
};

struct _DVBioChannelListReaderClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBioChannelListReaderPrivate {
	DVBChannelList* _channels;
	DVBAdapterType _Type;
	GKeyFile* file;
};


static gpointer dvb_io_channel_list_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_channel_list_reader_log;
static DVBLoggingLogger* dvb_io_channel_list_reader_log = NULL;

GType dvb_io_channel_list_reader_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_READER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_READER_CHANNELS,
	DVB_IO_CHANNEL_LIST_READER_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_channel_get_type (void) G_GNUC_CONST;
static DVBChannel* dvb_io_channel_list_reader_parse_dvb_t (DVBioChannelListReader* self, const gchar* group, GError** error);
static DVBChannel* dvb_io_channel_list_reader_parse_dvb_c (DVBioChannelListReader* self, const gchar* group, GError** error);
static DVBChannel* dvb_io_channel_list_reader_parse_dvb_s (DVBioChannelListReader* self, const gchar* group, GError** error);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
void dvb_channel_set_ServiceType (DVBChannel* self, GstMpegtsDVBServiceType value);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
DVBChannel* dvb_channel_new (guint group_id);
DVBChannel* dvb_channel_construct (GType object_type, guint group_id);
GType dvb_parameter_get_type (void) G_GNUC_CONST;
GType dvb_dvb_tparameter_get_type (void) G_GNUC_CONST;
GstMpegtsTerrestrialGuardInterval dvb_getGuardIntervalEnum (const gchar* val);
GstMpegtsTerrestrialTransmissionMode dvb_getTransmissionModeEnum (const gchar* val);
GstMpegtsTerrestrialHierarchy dvb_getHierarchyEnum (const gchar* val);
GstMpegtsModulationType dvb_getModulationEnum (const gchar* val);
GstMpegtsDVBCodeRate dvb_getCodeRateEnum (const gchar* val);
DVBDvbTParameter* dvb_dvb_tparameter_new_with_parameter (guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
DVBDvbTParameter* dvb_dvb_tparameter_construct_with_parameter (GType object_type, guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
void dvb_channel_set_Param (DVBChannel* self, DVBParameter* value);
GType dvb_dvb_sparameter_get_type (void) G_GNUC_CONST;
GstMpegtsSatellitePolarizationType dvb_getPolarizationEnum (const gchar* val);
DVBDvbSParameter* dvb_dvb_sparameter_new_with_parameter (guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
DVBDvbSParameter* dvb_dvb_sparameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
void dvb_dvb_sparameter_set_DiseqcSource (DVBDvbSParameter* self, gint value);
GType dvb_dvb_ceurope_parameter_get_type (void) G_GNUC_CONST;
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_new_with_parameter (guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value);
static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value);
static void dvb_io_channel_list_reader_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type) {
	DVBioChannelListReader * self = NULL;
	DVBChannelList* _tmp0_ = NULL;
	DVBAdapterType _tmp1_ = 0;
	GKeyFile* _tmp2_ = NULL;
	GKeyFile* _tmp3_ = NULL;
	g_return_val_if_fail (channels != NULL, NULL);
	_tmp0_ = channels;
	_tmp1_ = type;
	self = (DVBioChannelListReader*) g_object_new (object_type, "channels", _tmp0_, "Type", _tmp1_, NULL);
	_tmp2_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->file);
	self->priv->file = _tmp2_;
	_tmp3_ = self->priv->file;
	g_key_file_set_list_separator (_tmp3_, ' ');
	return self;
}


DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type) {
	return dvb_io_channel_list_reader_construct (DVB_IO_TYPE_CHANNEL_LIST_READER, channels, type);
}


void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error) {
	DVBChannelList* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_channels;
	_tmp1_ = dvb_channel_list_get_channels_file (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	{
		GKeyFile* _tmp3_ = NULL;
		DVBChannelList* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GKeyFile* _tmp9_ = NULL;
		gsize _tmp10_;
		gchar** _tmp11_ = NULL;
		_tmp3_ = self->priv->file;
		_tmp4_ = self->priv->_channels;
		_tmp5_ = dvb_channel_list_get_channels_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		g_key_file_load_from_file (_tmp3_, _tmp8_, G_KEY_FILE_NONE, &_inner_error_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch8_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->file;
		_tmp11_ = g_key_file_get_groups (_tmp9_, &_tmp10_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp11_;
			group_collection_length1 = _tmp10_;
			for (group_it = 0; group_it < _tmp10_; group_it = group_it + 1) {
				const gchar* group = NULL;
				group = group_collection[group_it];
				{
					DVBLoggingLogger* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					DVBChannel* c = NULL;
					gchar* _tmp14_ = NULL;
					GKeyFile* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					GQuark _tmp21_ = 0U;
					static GQuark _tmp20_label0 = 0;
					static GQuark _tmp20_label1 = 0;
					static GQuark _tmp20_label2 = 0;
					DVBChannel* _tmp34_ = NULL;
					guint64 _tmp35_ = 0ULL;
					GKeyFile* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					guint64 _tmp38_ = 0ULL;
					DVBChannel* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					GKeyFile* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					DVBChannel* _tmp44_ = NULL;
					guint64 _tmp45_ = 0ULL;
					GKeyFile* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					guint64 _tmp48_ = 0ULL;
					DVBChannel* _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					GKeyFile* _tmp51_ = NULL;
					const gchar* _tmp52_ = NULL;
					gboolean _tmp53_ = FALSE;
					DVBChannel* _tmp54_ = NULL;
					guint64 _tmp55_ = 0ULL;
					GKeyFile* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					guint64 _tmp58_ = 0ULL;
					DVBChannel* _tmp59_ = NULL;
					gboolean _tmp60_ = FALSE;
					GKeyFile* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					gboolean _tmp63_ = FALSE;
					gboolean _tmp69_ = FALSE;
					GKeyFile* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					gboolean _tmp72_ = FALSE;
					DVBChannel* _tmp89_ = NULL;
					gboolean _tmp90_ = FALSE;
					_tmp12_ = dvb_io_channel_list_reader_log;
					_tmp13_ = group;
					dvb_logging_logger_debug (_tmp12_, "ChannelListReader.vala:48: Channel: %s", _tmp13_);
					c = NULL;
					_tmp15_ = self->priv->file;
					_tmp16_ = group;
					_tmp17_ = g_key_file_get_string (_tmp15_, _tmp16_, "DELIVERY_SYSTEM", &_inner_error_);
					_tmp14_ = _tmp17_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp18_ = _tmp14_;
					_tmp14_ = NULL;
					_tmp19_ = _tmp18_;
					_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
					g_free (_tmp19_);
					if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("DVBT")))) {
						switch (0) {
							default:
							{
								DVBChannel* _tmp22_ = NULL;
								const gchar* _tmp23_ = NULL;
								DVBChannel* _tmp24_ = NULL;
								DVBChannel* _tmp25_ = NULL;
								_tmp23_ = group;
								_tmp24_ = dvb_io_channel_list_reader_parse_dvb_t (self, _tmp23_, &_inner_error_);
								_tmp22_ = _tmp24_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_FILE_ERROR) {
										goto __catch8_g_file_error;
									}
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch8_g_key_file_error;
									}
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp25_ = _tmp22_;
								_tmp22_ = NULL;
								_g_object_unref0 (c);
								c = _tmp25_;
								_g_object_unref0 (_tmp22_);
								break;
							}
						}
					} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("DVBC/ANNEX_A")))) {
						switch (0) {
							default:
							{
								DVBChannel* _tmp26_ = NULL;
								const gchar* _tmp27_ = NULL;
								DVBChannel* _tmp28_ = NULL;
								DVBChannel* _tmp29_ = NULL;
								_tmp27_ = group;
								_tmp28_ = dvb_io_channel_list_reader_parse_dvb_c (self, _tmp27_, &_inner_error_);
								_tmp26_ = _tmp28_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_FILE_ERROR) {
										goto __catch8_g_file_error;
									}
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch8_g_key_file_error;
									}
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp29_ = _tmp26_;
								_tmp26_ = NULL;
								_g_object_unref0 (c);
								c = _tmp29_;
								_g_object_unref0 (_tmp26_);
								break;
							}
						}
					} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("DVBS")))) {
						switch (0) {
							default:
							{
								DVBChannel* _tmp30_ = NULL;
								const gchar* _tmp31_ = NULL;
								DVBChannel* _tmp32_ = NULL;
								DVBChannel* _tmp33_ = NULL;
								_tmp31_ = group;
								_tmp32_ = dvb_io_channel_list_reader_parse_dvb_s (self, _tmp31_, &_inner_error_);
								_tmp30_ = _tmp32_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_FILE_ERROR) {
										goto __catch8_g_file_error;
									}
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch8_g_key_file_error;
									}
									_g_free0 (_tmp14_);
									_g_object_unref0 (c);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
								_tmp33_ = _tmp30_;
								_tmp30_ = NULL;
								_g_object_unref0 (c);
								c = _tmp33_;
								_g_object_unref0 (_tmp30_);
								break;
							}
						}
					} else {
						switch (0) {
							default:
							{
								break;
							}
						}
					}
					_tmp34_ = c;
					if (_tmp34_ == NULL) {
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						continue;
					}
					_tmp36_ = self->priv->file;
					_tmp37_ = group;
					_tmp38_ = g_key_file_get_uint64 (_tmp36_, _tmp37_, "SERVICE_ID", &_inner_error_);
					_tmp35_ = _tmp38_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp39_ = c;
					dvb_channel_set_Sid (_tmp39_, (guint) _tmp35_);
					_tmp41_ = self->priv->file;
					_tmp42_ = group;
					_tmp43_ = g_key_file_get_string (_tmp41_, _tmp42_, "SERVICE_NAME", &_inner_error_);
					_tmp40_ = _tmp43_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp44_ = c;
					dvb_channel_set_Name (_tmp44_, _tmp40_);
					_tmp46_ = self->priv->file;
					_tmp47_ = group;
					_tmp48_ = g_key_file_get_uint64 (_tmp46_, _tmp47_, "TRANSPORT_STREAM_ID", &_inner_error_);
					_tmp45_ = _tmp48_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp49_ = c;
					dvb_channel_set_TransportStreamId (_tmp49_, (guint) _tmp45_);
					_tmp51_ = self->priv->file;
					_tmp52_ = group;
					_tmp53_ = g_key_file_get_boolean (_tmp51_, _tmp52_, "SCRAMBLED", &_inner_error_);
					_tmp50_ = _tmp53_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp54_ = c;
					dvb_channel_set_Scrambled (_tmp54_, _tmp50_);
					_tmp56_ = self->priv->file;
					_tmp57_ = group;
					_tmp58_ = g_key_file_get_uint64 (_tmp56_, _tmp57_, "SERVICE_TYPE", &_inner_error_);
					_tmp55_ = _tmp58_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp59_ = c;
					dvb_channel_set_ServiceType (_tmp59_, (GstMpegtsDVBServiceType) _tmp55_);
					_tmp61_ = self->priv->file;
					_tmp62_ = group;
					_tmp63_ = g_key_file_has_key (_tmp61_, _tmp62_, "VIDEO_PID", &_inner_error_);
					_tmp60_ = _tmp63_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (_tmp60_) {
						guint64 _tmp64_ = 0ULL;
						GKeyFile* _tmp65_ = NULL;
						const gchar* _tmp66_ = NULL;
						guint64 _tmp67_ = 0ULL;
						DVBChannel* _tmp68_ = NULL;
						_tmp65_ = self->priv->file;
						_tmp66_ = group;
						_tmp67_ = g_key_file_get_uint64 (_tmp65_, _tmp66_, "VIDEO_PID", &_inner_error_);
						_tmp64_ = _tmp67_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (_tmp40_);
							_g_free0 (_tmp14_);
							_g_object_unref0 (c);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error_->domain == G_FILE_ERROR) {
								goto __catch8_g_file_error;
							}
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch8_g_key_file_error;
							}
							_g_free0 (_tmp40_);
							_g_free0 (_tmp14_);
							_g_object_unref0 (c);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp68_ = c;
						dvb_channel_set_VideoPID (_tmp68_, (guint) _tmp64_);
					}
					_tmp70_ = self->priv->file;
					_tmp71_ = group;
					_tmp72_ = g_key_file_has_key (_tmp70_, _tmp71_, "AUDIO_PID", &_inner_error_);
					_tmp69_ = _tmp72_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch8_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch8_g_key_file_error;
						}
						_g_free0 (_tmp40_);
						_g_free0 (_tmp14_);
						_g_object_unref0 (c);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (_tmp69_) {
						gint* _tmp73_ = NULL;
						GKeyFile* _tmp74_ = NULL;
						const gchar* _tmp75_ = NULL;
						gsize _tmp76_;
						gint* _tmp77_ = NULL;
						gint _tmp73__length1 = 0;
						gint __tmp73__size_ = 0;
						guint* apids = NULL;
						gint* _tmp78_ = NULL;
						gint _tmp78__length1 = 0;
						gint apids_length1 = 0;
						gint _apids_size_ = 0;
						_tmp74_ = self->priv->file;
						_tmp75_ = group;
						_tmp77_ = g_key_file_get_integer_list (_tmp74_, _tmp75_, "AUDIO_PID", &_tmp76_, &_inner_error_);
						_tmp73_ = _tmp77_;
						_tmp73__length1 = _tmp76_;
						__tmp73__size_ = _tmp73__length1;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (_tmp40_);
							_g_free0 (_tmp14_);
							_g_object_unref0 (c);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							if (_inner_error_->domain == G_FILE_ERROR) {
								goto __catch8_g_file_error;
							}
							if (_inner_error_->domain == G_KEY_FILE_ERROR) {
								goto __catch8_g_key_file_error;
							}
							_g_free0 (_tmp40_);
							_g_free0 (_tmp14_);
							_g_object_unref0 (c);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp78_ = _tmp73_;
						_tmp78__length1 = _tmp73__length1;
						_tmp73_ = NULL;
						_tmp73__length1 = 0;
						apids = (guint*) _tmp78_;
						apids_length1 = (_tmp78__length1 * sizeof (gint)) / sizeof (guint);
						_apids_size_ = apids_length1;
						{
							guint i = 0U;
							i = (guint) 0;
							{
								gboolean _tmp79_ = FALSE;
								_tmp79_ = TRUE;
								while (TRUE) {
									guint _tmp81_ = 0U;
									guint* _tmp82_ = NULL;
									gint _tmp82__length1 = 0;
									DVBChannel* _tmp83_ = NULL;
									GeeList* _tmp84_ = NULL;
									GeeList* _tmp85_ = NULL;
									guint* _tmp86_ = NULL;
									gint _tmp86__length1 = 0;
									guint _tmp87_ = 0U;
									guint _tmp88_ = 0U;
									if (!_tmp79_) {
										guint _tmp80_ = 0U;
										_tmp80_ = i;
										i = _tmp80_ + 1;
									}
									_tmp79_ = FALSE;
									_tmp81_ = i;
									_tmp82_ = apids;
									_tmp82__length1 = apids_length1;
									if (!(_tmp81_ < ((guint) _tmp82__length1))) {
										break;
									}
									_tmp83_ = c;
									_tmp84_ = dvb_channel_get_AudioPIDs (_tmp83_);
									_tmp85_ = _tmp84_;
									_tmp86_ = apids;
									_tmp86__length1 = apids_length1;
									_tmp87_ = i;
									_tmp88_ = _tmp86_[_tmp87_];
									gee_collection_add ((GeeCollection*) _tmp85_, (gpointer) ((guintptr) _tmp88_));
								}
							}
						}
						apids = (g_free (apids), NULL);
						_tmp73_ = (g_free (_tmp73_), NULL);
					}
					_tmp89_ = c;
					_tmp90_ = dvb_channel_is_valid (_tmp89_);
					if (_tmp90_) {
						DVBChannelList* _tmp91_ = NULL;
						DVBChannel* _tmp92_ = NULL;
						_tmp91_ = self->priv->_channels;
						_tmp92_ = c;
						dvb_channel_list_add (_tmp91_, _tmp92_);
					} else {
						g_warning ("ChannelListReader.vala:85: Could not parse channel");
					}
					_g_free0 (_tmp40_);
					_g_free0 (_tmp14_);
					_g_object_unref0 (c);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp93_ = NULL;
		GError* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp93_ = dvb_io_channel_list_reader_log;
		_tmp94_ = e;
		_tmp95_ = _tmp94_->message;
		dvb_logging_logger_error (_tmp93_, "ChannelListReader.vala:88: Can not open channel file: %s", _tmp95_);
		_g_error_free0 (e);
	}
	goto __finally8;
	__catch8_g_key_file_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp96_ = NULL;
		GError* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp96_ = dvb_io_channel_list_reader_log;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		dvb_logging_logger_error (_tmp96_, "ChannelListReader.vala:90: %s", _tmp98_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static DVBChannel* dvb_io_channel_list_reader_parse_dvb_t (DVBioChannelListReader* self, const gchar* group, GError** error) {
	DVBChannel* result = NULL;
	DVBAdapterType _tmp0_ = 0;
	DVBChannel* c = NULL;
	DVBChannelList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	DVBChannel* _tmp4_ = NULL;
	guint64 _tmp5_ = 0ULL;
	GKeyFile* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	guint64 _tmp8_ = 0ULL;
	guint64 _tmp9_ = 0ULL;
	GKeyFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	guint64 _tmp12_ = 0ULL;
	gchar* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GKeyFile* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GKeyFile* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GKeyFile* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GKeyFile* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	DVBDvbTParameter* param = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp37_ = 0;
	GstMpegtsTerrestrialTransmissionMode _tmp38_ = 0;
	GstMpegtsTerrestrialHierarchy _tmp39_ = 0;
	GstMpegtsModulationType _tmp40_ = 0;
	GstMpegtsDVBCodeRate _tmp41_ = 0;
	GstMpegtsDVBCodeRate _tmp42_ = 0;
	DVBDvbTParameter* _tmp43_ = NULL;
	DVBChannel* _tmp44_ = NULL;
	DVBDvbTParameter* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = self->priv->_Type;
	if (_tmp0_ != DVB_ADAPTER_TYPE_TERRESTRIAL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_channels;
	_tmp2_ = dvb_channel_list_get_GroupId (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = dvb_channel_new (_tmp3_);
	c = _tmp4_;
	_tmp6_ = self->priv->file;
	_tmp7_ = group;
	_tmp8_ = g_key_file_get_uint64 (_tmp6_, _tmp7_, "FREQUENCY", &_inner_error_);
	_tmp5_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = self->priv->file;
	_tmp11_ = group;
	_tmp12_ = g_key_file_get_uint64 (_tmp10_, _tmp11_, "BANDWIDTH_HZ", &_inner_error_);
	_tmp9_ = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = self->priv->file;
	_tmp15_ = group;
	_tmp16_ = g_key_file_get_string (_tmp14_, _tmp15_, "GUARD_INTERVAL", &_inner_error_);
	_tmp13_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->file;
	_tmp19_ = group;
	_tmp20_ = g_key_file_get_string (_tmp18_, _tmp19_, "TRANSMISSION_MODE", &_inner_error_);
	_tmp17_ = _tmp20_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = self->priv->file;
	_tmp23_ = group;
	_tmp24_ = g_key_file_get_string (_tmp22_, _tmp23_, "HIERARCHY", &_inner_error_);
	_tmp21_ = _tmp24_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp26_ = self->priv->file;
	_tmp27_ = group;
	_tmp28_ = g_key_file_get_string (_tmp26_, _tmp27_, "MODULATION", &_inner_error_);
	_tmp25_ = _tmp28_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp30_ = self->priv->file;
	_tmp31_ = group;
	_tmp32_ = g_key_file_get_string (_tmp30_, _tmp31_, "CODE_RATE_LP", &_inner_error_);
	_tmp29_ = _tmp32_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp34_ = self->priv->file;
	_tmp35_ = group;
	_tmp36_ = g_key_file_get_string (_tmp34_, _tmp35_, "CODE_RATE_HP", &_inner_error_);
	_tmp33_ = _tmp36_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp29_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp37_ = dvb_getGuardIntervalEnum (_tmp13_);
	_tmp38_ = dvb_getTransmissionModeEnum (_tmp17_);
	_tmp39_ = dvb_getHierarchyEnum (_tmp21_);
	_tmp40_ = dvb_getModulationEnum (_tmp25_);
	_tmp41_ = dvb_getCodeRateEnum (_tmp29_);
	_tmp42_ = dvb_getCodeRateEnum (_tmp33_);
	_tmp43_ = dvb_dvb_tparameter_new_with_parameter ((guint) _tmp5_, (guint) _tmp9_, _tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_);
	param = _tmp43_;
	_tmp44_ = c;
	_tmp45_ = param;
	dvb_channel_set_Param (_tmp44_, (DVBParameter*) _tmp45_);
	result = c;
	_g_object_unref0 (param);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp13_);
	return result;
}


static DVBChannel* dvb_io_channel_list_reader_parse_dvb_s (DVBioChannelListReader* self, const gchar* group, GError** error) {
	DVBChannel* result = NULL;
	DVBAdapterType _tmp0_ = 0;
	DVBChannel* c = NULL;
	DVBChannelList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	DVBChannel* _tmp4_ = NULL;
	guint64 _tmp5_ = 0ULL;
	GKeyFile* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	guint64 _tmp8_ = 0ULL;
	guint64 _tmp9_ = 0ULL;
	GKeyFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	guint64 _tmp12_ = 0ULL;
	gdouble _tmp13_ = 0.0;
	GKeyFile* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	gchar* _tmp17_ = NULL;
	GKeyFile* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GKeyFile* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	DVBDvbSParameter* param = NULL;
	GstMpegtsSatellitePolarizationType _tmp25_ = 0;
	GstMpegtsDVBCodeRate _tmp26_ = 0;
	DVBDvbSParameter* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	GKeyFile* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	DVBChannel* _tmp37_ = NULL;
	DVBDvbSParameter* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = self->priv->_Type;
	if (_tmp0_ != DVB_ADAPTER_TYPE_SATELLITE) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_channels;
	_tmp2_ = dvb_channel_list_get_GroupId (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = dvb_channel_new (_tmp3_);
	c = _tmp4_;
	_tmp6_ = self->priv->file;
	_tmp7_ = group;
	_tmp8_ = g_key_file_get_uint64 (_tmp6_, _tmp7_, "FREQUENCY", &_inner_error_);
	_tmp5_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = self->priv->file;
	_tmp11_ = group;
	_tmp12_ = g_key_file_get_uint64 (_tmp10_, _tmp11_, "SYMBOL_RATE", &_inner_error_);
	_tmp9_ = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = self->priv->file;
	_tmp15_ = group;
	_tmp16_ = g_key_file_get_double (_tmp14_, _tmp15_, "ORBITAL_POSITION", &_inner_error_);
	_tmp13_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->file;
	_tmp19_ = group;
	_tmp20_ = g_key_file_get_string (_tmp18_, _tmp19_, "POLARIZATION", &_inner_error_);
	_tmp17_ = _tmp20_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = self->priv->file;
	_tmp23_ = group;
	_tmp24_ = g_key_file_get_string (_tmp22_, _tmp23_, "INNER_FEC", &_inner_error_);
	_tmp21_ = _tmp24_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp17_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp17_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = dvb_getPolarizationEnum (_tmp17_);
	_tmp26_ = dvb_getCodeRateEnum (_tmp21_);
	_tmp27_ = dvb_dvb_sparameter_new_with_parameter ((guint) _tmp5_, (guint) _tmp9_, (gfloat) _tmp13_, _tmp25_, _tmp26_);
	param = _tmp27_;
	_tmp29_ = self->priv->file;
	_tmp30_ = group;
	_tmp31_ = g_key_file_has_key (_tmp29_, _tmp30_, "SAT_NUMBER", &_inner_error_);
	_tmp28_ = _tmp31_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (param);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (param);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp17_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp28_) {
		gint _tmp32_ = 0;
		GKeyFile* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		DVBDvbSParameter* _tmp36_ = NULL;
		_tmp33_ = self->priv->file;
		_tmp34_ = group;
		_tmp35_ = g_key_file_get_integer (_tmp33_, _tmp34_, "SAT_NUMBER", &_inner_error_);
		_tmp32_ = _tmp35_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (param);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp17_);
				_g_object_unref0 (c);
				return NULL;
			} else {
				_g_object_unref0 (param);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp17_);
				_g_object_unref0 (c);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp36_ = param;
		dvb_dvb_sparameter_set_DiseqcSource (_tmp36_, _tmp32_);
	}
	_tmp37_ = c;
	_tmp38_ = param;
	dvb_channel_set_Param (_tmp37_, (DVBParameter*) _tmp38_);
	result = c;
	_g_object_unref0 (param);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp17_);
	return result;
}


static DVBChannel* dvb_io_channel_list_reader_parse_dvb_c (DVBioChannelListReader* self, const gchar* group, GError** error) {
	DVBChannel* result = NULL;
	DVBAdapterType _tmp0_ = 0;
	DVBChannel* c = NULL;
	DVBChannelList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	DVBChannel* _tmp4_ = NULL;
	guint64 _tmp5_ = 0ULL;
	GKeyFile* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	guint64 _tmp8_ = 0ULL;
	guint64 _tmp9_ = 0ULL;
	GKeyFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	guint64 _tmp12_ = 0ULL;
	gchar* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GKeyFile* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	DVBDvbCEuropeParameter* param = NULL;
	GstMpegtsModulationType _tmp21_ = 0;
	GstMpegtsDVBCodeRate _tmp22_ = 0;
	DVBDvbCEuropeParameter* _tmp23_ = NULL;
	DVBChannel* _tmp24_ = NULL;
	DVBDvbCEuropeParameter* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = self->priv->_Type;
	if (_tmp0_ != DVB_ADAPTER_TYPE_CABLE) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_channels;
	_tmp2_ = dvb_channel_list_get_GroupId (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = dvb_channel_new (_tmp3_);
	c = _tmp4_;
	_tmp6_ = self->priv->file;
	_tmp7_ = group;
	_tmp8_ = g_key_file_get_uint64 (_tmp6_, _tmp7_, "FREQUENCY", &_inner_error_);
	_tmp5_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = self->priv->file;
	_tmp11_ = group;
	_tmp12_ = g_key_file_get_uint64 (_tmp10_, _tmp11_, "SYMBOL_RATE", &_inner_error_);
	_tmp9_ = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = self->priv->file;
	_tmp15_ = group;
	_tmp16_ = g_key_file_get_string (_tmp14_, _tmp15_, "MODULATION", &_inner_error_);
	_tmp13_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->file;
	_tmp19_ = group;
	_tmp20_ = g_key_file_get_string (_tmp18_, _tmp19_, "INNER_FEC", &_inner_error_);
	_tmp17_ = _tmp20_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			return NULL;
		} else {
			_g_free0 (_tmp13_);
			_g_object_unref0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp21_ = dvb_getModulationEnum (_tmp13_);
	_tmp22_ = dvb_getCodeRateEnum (_tmp17_);
	_tmp23_ = dvb_dvb_ceurope_parameter_new_with_parameter ((guint) _tmp5_, (guint) _tmp9_, _tmp21_, _tmp22_);
	param = _tmp23_;
	_tmp24_ = c;
	_tmp25_ = param;
	dvb_channel_set_Param (_tmp24_, (DVBParameter*) _tmp25_);
	result = c;
	_g_object_unref0 (param);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp13_);
	return result;
}


DVBChannelList* dvb_io_channel_list_reader_get_channels (DVBioChannelListReader* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_channels;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_reader_set_channels (DVBioChannelListReader* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_ = NULL;
	DVBChannelList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_channels);
	self->priv->_channels = _tmp1_;
	g_object_notify ((GObject *) self, "channels");
}


DVBAdapterType dvb_io_channel_list_reader_get_Type (DVBioChannelListReader* self) {
	DVBAdapterType result;
	DVBAdapterType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Type;
	result = _tmp0_;
	return result;
}


static void dvb_io_channel_list_reader_set_Type (DVBioChannelListReader* self, DVBAdapterType value) {
	DVBAdapterType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Type = _tmp0_;
	g_object_notify ((GObject *) self, "Type");
}


static void dvb_io_channel_list_reader_class_init (DVBioChannelListReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_channel_list_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_CHANNELS, g_param_spec_object ("channels", "channels", "channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_READER_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_channel_list_reader_log = _tmp1_;
}


static void dvb_io_channel_list_reader_instance_init (DVBioChannelListReader * self) {
	self->priv = DVB_IO_CHANNEL_LIST_READER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_reader_finalize (GObject* obj) {
	DVBioChannelListReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader);
	_g_object_unref0 (self->priv->_channels);
	_g_key_file_unref0 (self->priv->file);
	G_OBJECT_CLASS (dvb_io_channel_list_reader_parent_class)->finalize (obj);
}


GType dvb_io_channel_list_reader_get_type (void) {
	static volatile gsize dvb_io_channel_list_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListReader), 0, (GInstanceInitFunc) dvb_io_channel_list_reader_instance_init, NULL };
		GType dvb_io_channel_list_reader_type_id;
		dvb_io_channel_list_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_reader_type_id__volatile, dvb_io_channel_list_reader_type_id);
	}
	return dvb_io_channel_list_reader_type_id__volatile;
}


static void _vala_dvb_io_channel_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		g_value_set_object (value, dvb_io_channel_list_reader_get_channels (self));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		g_value_set_enum (value, dvb_io_channel_list_reader_get_Type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_READER_CHANNELS:
		dvb_io_channel_list_reader_set_channels (self, g_value_get_object (value));
		break;
		case DVB_IO_CHANNEL_LIST_READER_TYPE:
		dvb_io_channel_list_reader_set_Type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



