# GNOME Backgrounds

This module contains a set of backgrounds packaged with the GNOME desktop.

## Design Guidelines

![Defaults](defaults.jpg)

### Default

The default wallpaper has historically been strictly abstract, low contrast. The geometric pattern has oscillated around stripes and triangles and over the years has become part of the GNOME brand. Steering too much away from it will dilute the brand. 

### Supplemental

It is desirable to have a wide mix of themes and colors for the additional wallpapers. Photographs and illustrations that would otherwise be too contrasty and with high frequency detail to be a good backdrop are perfectly suitable. Starting with GNOME 42, each wallpaper should come in two variants, light and dark. While the actual difference isn't well defined, the dark variant should try to limit the overall brightness.

#### Cultural Considerations

GNOME is deployed globally. Be aware of some bad connotations in certain geographical areas. Depictions of some animals, flags or body parts are better avoided.

#### Technical Constraints

##### Resolution

It is recommended to submit wallpapers of 4 megapixels and above. Photos should generally come in the standard size of 4096x2160px, with no artifacts such as chromatic aberration. The wallpapers get scaled with the `background-size: cover` equivalent method but due to portrait aspect for displays being rather rare and the texture size being a real constraint we have not switched to square backgrounds yet. Do take various possible display aspect ratios into consideration when submitting wallpapers with strong reliance on composition. Important elements might get cropped.

##### File size

Unfortunately due to distribution limits, the background collection has to keep its size contrained to around 40MB. This forces us to replace assets rather than add them. You can download the [Nostalgia](https://flathub.org/apps/details/im.bernard.Nostalgia) app to view previous release wallpapers.

One wallpaper is reserved for plain color to be used for remote access where it's beneficial for the compression algorithm to cope with it with ease. 

##### Sharpness

Many photographic sources look great as a thumbnail or scaled down, but at 1:1 aren't 100% sharp. While it may not present itself as a problem on an average laptop screen, the wallpaper has to work on super wide screens where it's cropped to fit and is presented at 1:1 or even scaled up in some cases. Many otherwise suitable background images just fall short when observed at the nominal pixel view. Chromatic aberation and noise is also something that becomes apparent as you approach 1:1.

![Bad Scaling](badscaling.jpg)

##### Color Banding

Images should look decent even on lower quality displays. Techniques such as dithering should be used for elements with low contrast areas that would otherwise be prone for color banding.

## License

CCBYSA / Public Domain / CC0 is preferred. Authorship does need to be sourced, all attribution goes to the AUTHORS file.
