/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * InvocationTrace.java
 *
 * Created on November 22, 2004, 4:35 PM
 */

package com.sun.enterprise.webservice.monitoring;

import java.util.Date;
import java.util.logging.Level;
import java.io.ByteArrayOutputStream;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * An invocation trace contains the timestamp os a particular
 * message invocation, the stringified SOAP request and 
 * response or the SOAP Faults if the invocation resulted in one.
 * <p><b>NOT THREAD SAFE: mutable instance variables</b>
 *
 * @author Jerome Dochez
 */
public class MessageTraceImpl implements MessageTrace {
        
    private Endpoint source;
    private String soapMessage=null;
    private TransportInfo transportInfo=null;
    private int hashcode=0;
    
    
    /** Creates a new instance of InvocationTrace */
    public MessageTraceImpl() {
        
    }
    
    /** 
     * Return the SOAPMessage as a string including the SOAPHeaders or not
     * @param include the soap headers.
     * @return the soap message
     */ 
    public String getMessage(boolean includeHeaders) {

        if (soapMessage!=null) {
            if (includeHeaders) {
                return soapMessage;
            }
        
            StringBuffer sb = new StringBuffer();
            Pattern p = Pattern.compile("<env:Body>.*</env:Body>");
            Matcher m = p.matcher(soapMessage);
            if (m.find()) {
                return soapMessage.substring(m.start(),m.end());
            } else {
                return soapMessage;
            }
        }
        return null;
    }
    
    /**
     * Return the endpoint where this message originated from
     */
    public Endpoint getEndpoint() {
        return source;
    }
    
    public void setMessageContext(com.sun.xml.rpc.spi.runtime.SOAPMessageContext soapMessageCtx) {
        
        hashcode = soapMessageCtx.hashCode();
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();        
        try {
            soapMessageCtx.getMessage().writeTo(baos);       
        } catch(Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "Cannot log SOAP Message " + e.getMessage());
        }    

        soapMessage = baos.toString();          
    }
    
    public void setMessageContext(com.sun.enterprise.webservice.SOAPMessageContext soapMessageCtx) {
        
        hashcode = soapMessageCtx.hashCode();
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();        
        try {
            soapMessageCtx.getMessage().writeTo(baos);       
        } catch(Exception e) {
            WebServiceEngineImpl.sLogger.log(Level.WARNING, "Cannot log SOAP Message " + e.getMessage());
        }    

        soapMessage = baos.toString();          
    }
    
    public String getMessageID() {
        return String.valueOf(hashcode);
    }
    
    public void setEndpoint(Endpoint source) {
        this.source = source;
    }
    
    public TransportInfo getTransportInfo() {
        return transportInfo;
    }
    
    public void setTransportInfo(TransportInfo info) {
        transportInfo = info;
    }
}
