.\" @(#)$RCSfile: gfal_set_verbose.man,v $ $Revision: 1.1 $ $Date: 2008/12/18 13:19:12 $ CERN Remi Mollon
.\" Copyright (C) 2009 by CERN
.\" All rights reserved
.\"
.TH GFAL_SET_VERBOSE 3 "$Date: 2008/12/18 13:19:12 $" GFAL "Library Functions"

.SH NAME
gfal_set_verbose \- Set verbose level

.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_set_verboose (int " value );

.SH DESCRIPTION
.B gfal_set_verbose sets the level of verbosity. By default, it is set to -1, what means no error
at all on stderr, but it isn't possible to set it to -1 yourself, only positive or null values are
accepted.

Moreover, note that if you define
.I errbuf
for functions which supports it, then critical errors will be put in your buffer and not on stderr,
whatever the verbose level is.

Here are the possible levels:
.RS 
.TP 0.5i
.B 0
Only critical errors are displayed on stderr.
.TP
.B 1
Warnings are displayed on stderr as well as critical errors.
.TP
.B 2
Debug information is displayed as well as warnings and critical errors.
.RE

.SH RETURN VALUE
This routine returns 0 in case of success, or -1 in case of error.

.SH SEE ALSO
.BR gfal (3),
.BR gfal_request_new (3),
.BR gfal_internal_free (3),
.BR gfal_init (3),
.BR gfal_deletesurls (3),
.BR gfal_removedir (3),
.BR gfal_turlsfromsurls (3),
.BR gfal_ls (3),
.BR gfal_get (3),
.BR gfal_getstatus (3),
.BR gfal_prestage (3),
.BR gfal_prestagestatus (3),
.BR gfal_pin (3),
.BR gfal_release (3),
.BR gfal_abortrequest (3),
.BR gfal_abortfiles (3),
.BR gfal_set_xfer_done (3),
.BR gfal_set_xfer_running (3),
.BR gfal_get_ids (3),
.BR gfal_set_ids (3),
.BR gfal_get_results (3),
