// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__ -ffp-contract=off" }

// Copyright (C) 2016-2021 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  assoc_legendre
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< '\n'; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>

// Test data for l=0, m=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_legendre<double>
data001[21] =
{
  { 1.0000000000000000, 0, 0, 
	  -1.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.90000000000000002, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.69999999999999996, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.59999999999999998, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.39999999999999991, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.29999999999999993, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.19999999999999996, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.0000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.10000000000000009, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.20000000000000018, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.30000000000000004, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.40000000000000013, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.50000000000000000, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.60000000000000009, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.70000000000000018, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.80000000000000004, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 0, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for l=1, m=0.
// max(|f - f_GSL|): 0.0000000000000000 at index 0
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_legendre<double>
data002[21] =
{
  { -1.0000000000000000, 1, 0, 
	  -1.0000000000000000, 0.0 },
  { -0.90000000000000002, 1, 0, 
	  -0.90000000000000002, 0.0 },
  { -0.80000000000000004, 1, 0, 
	  -0.80000000000000004, 0.0 },
  { -0.69999999999999996, 1, 0, 
	  -0.69999999999999996, 0.0 },
  { -0.59999999999999998, 1, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.50000000000000000, 1, 0, 
	  -0.50000000000000000, 0.0 },
  { -0.39999999999999991, 1, 0, 
	  -0.39999999999999991, 0.0 },
  { -0.29999999999999993, 1, 0, 
	  -0.29999999999999993, 0.0 },
  { -0.19999999999999996, 1, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.099999999999999978, 1, 0, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 1, 0, 
	  0.0000000000000000, 0.0 },
  { 0.10000000000000009, 1, 0, 
	  0.10000000000000009, 0.0 },
  { 0.20000000000000018, 1, 0, 
	  0.20000000000000018, 0.0 },
  { 0.30000000000000004, 1, 0, 
	  0.30000000000000004, 0.0 },
  { 0.40000000000000013, 1, 0, 
	  0.40000000000000013, 0.0 },
  { 0.50000000000000000, 1, 0, 
	  0.50000000000000000, 0.0 },
  { 0.60000000000000009, 1, 0, 
	  0.60000000000000009, 0.0 },
  { 0.70000000000000018, 1, 0, 
	  0.70000000000000018, 0.0 },
  { 0.80000000000000004, 1, 0, 
	  0.80000000000000004, 0.0 },
  { 0.90000000000000013, 1, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 1, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for l=1, m=1.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 12
// max(|f - f_GSL| / |f_GSL|): 2.4227052612512390e-16
// mean(f - f_GSL): -1.0573552615477681e-17
// variance(f - f_GSL): 5.8695007828944331e-36
// stddev(f - f_GSL): 2.4227052612512388e-18
const testcase_assoc_legendre<double>
data003[21] =
{
  { 0.0000000000000000, 1, 1, 
	  -1.0000000000000000, 0.0 },
  { 0.43588989435406728, 1, 1, 
	  -0.90000000000000002, 0.0 },
  { 0.59999999999999987, 1, 1, 
	  -0.80000000000000004, 0.0 },
  { 0.71414284285428509, 1, 1, 
	  -0.69999999999999996, 0.0 },
  { 0.80000000000000004, 1, 1, 
	  -0.59999999999999998, 0.0 },
  { 0.86602540378443860, 1, 1, 
	  -0.50000000000000000, 0.0 },
  { 0.91651513899116799, 1, 1, 
	  -0.39999999999999991, 0.0 },
  { 0.95393920141694555, 1, 1, 
	  -0.29999999999999993, 0.0 },
  { 0.97979589711327120, 1, 1, 
	  -0.19999999999999996, 0.0 },
  { 0.99498743710661997, 1, 1, 
	  -0.099999999999999978, 0.0 },
  { 1.0000000000000000, 1, 1, 
	  0.0000000000000000, 0.0 },
  { 0.99498743710661997, 1, 1, 
	  0.10000000000000009, 0.0 },
  { 0.97979589711327120, 1, 1, 
	  0.20000000000000018, 0.0 },
  { 0.95393920141694577, 1, 1, 
	  0.30000000000000004, 0.0 },
  { 0.91651513899116788, 1, 1, 
	  0.40000000000000013, 0.0 },
  { 0.86602540378443860, 1, 1, 
	  0.50000000000000000, 0.0 },
  { 0.79999999999999993, 1, 1, 
	  0.60000000000000009, 0.0 },
  { 0.71414284285428475, 1, 1, 
	  0.70000000000000018, 0.0 },
  { 0.59999999999999987, 1, 1, 
	  0.80000000000000004, 0.0 },
  { 0.43588989435406711, 1, 1, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 1, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for l=2, m=0.
// max(|f - f_GSL|): 1.1102230246251565e-16 at index 17
// max(|f - f_GSL| / |f_GSL|): 1.3877787807814482e-15
// mean(f - f_GSL): 1.8503717077085941e-17
// variance(f - f_GSL): 1.7975346147614202e-35
// stddev(f - f_GSL): 4.2397342071896678e-18
const testcase_assoc_legendre<double>
data004[21] =
{
  { 1.0000000000000000, 2, 0, 
	  -1.0000000000000000, 0.0 },
  { 0.71500000000000008, 2, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.46000000000000019, 2, 0, 
	  -0.80000000000000004, 0.0 },
  { 0.23499999999999988, 2, 0, 
	  -0.69999999999999996, 0.0 },
  { 0.039999999999999925, 2, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.12500000000000000, 2, 0, 
	  -0.50000000000000000, 0.0 },
  { -0.26000000000000012, 2, 0, 
	  -0.39999999999999991, 0.0 },
  { -0.36500000000000005, 2, 0, 
	  -0.29999999999999993, 0.0 },
  { -0.44000000000000006, 2, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.48499999999999999, 2, 0, 
	  -0.099999999999999978, 0.0 },
  { -0.50000000000000000, 2, 0, 
	  0.0000000000000000, 0.0 },
  { -0.48499999999999999, 2, 0, 
	  0.10000000000000009, 0.0 },
  { -0.43999999999999989, 2, 0, 
	  0.20000000000000018, 0.0 },
  { -0.36499999999999999, 2, 0, 
	  0.30000000000000004, 0.0 },
  { -0.25999999999999984, 2, 0, 
	  0.40000000000000013, 0.0 },
  { -0.12500000000000000, 2, 0, 
	  0.50000000000000000, 0.0 },
  { 0.040000000000000147, 2, 0, 
	  0.60000000000000009, 0.0 },
  { 0.23500000000000032, 2, 0, 
	  0.70000000000000018, 0.0 },
  { 0.46000000000000019, 2, 0, 
	  0.80000000000000004, 0.0 },
  { 0.71500000000000030, 2, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 2, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for l=2, m=1.
// max(|f - f_GSL|): 2.2204460492503131e-16 at index 3
// max(|f - f_GSL| / |f_GSL|): 3.7770554319736585e-16
// mean(f - f_GSL): 1.0573552615477681e-17
// variance(f - f_GSL): 5.8695007828944331e-36
// stddev(f - f_GSL): 2.4227052612512388e-18
const testcase_assoc_legendre<double>
data005[21] =
{
  { -0.0000000000000000, 2, 1, 
	  -1.0000000000000000, 0.0 },
  { -1.1769027147559816, 2, 1, 
	  -0.90000000000000002, 0.0 },
  { -1.4399999999999999, 2, 1, 
	  -0.80000000000000004, 0.0 },
  { -1.4996999699939983, 2, 1, 
	  -0.69999999999999996, 0.0 },
  { -1.4399999999999999, 2, 1, 
	  -0.59999999999999998, 0.0 },
  { -1.2990381056766580, 2, 1, 
	  -0.50000000000000000, 0.0 },
  { -1.0998181667894014, 2, 1, 
	  -0.39999999999999991, 0.0 },
  { -0.85854528127525076, 2, 1, 
	  -0.29999999999999993, 0.0 },
  { -0.58787753826796263, 2, 1, 
	  -0.19999999999999996, 0.0 },
  { -0.29849623113198592, 2, 1, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 2, 1, 
	  0.0000000000000000, 0.0 },
  { 0.29849623113198626, 2, 1, 
	  0.10000000000000009, 0.0 },
  { 0.58787753826796330, 2, 1, 
	  0.20000000000000018, 0.0 },
  { 0.85854528127525132, 2, 1, 
	  0.30000000000000004, 0.0 },
  { 1.0998181667894018, 2, 1, 
	  0.40000000000000013, 0.0 },
  { 1.2990381056766580, 2, 1, 
	  0.50000000000000000, 0.0 },
  { 1.4400000000000002, 2, 1, 
	  0.60000000000000009, 0.0 },
  { 1.4996999699939983, 2, 1, 
	  0.70000000000000018, 0.0 },
  { 1.4399999999999999, 2, 1, 
	  0.80000000000000004, 0.0 },
  { 1.1769027147559812, 2, 1, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 2, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for l=2, m=2.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 12
// max(|f - f_GSL| / |f_GSL|): 5.2867763077388426e-16
// mean(f - f_GSL): -8.4588420923821446e-17
// variance(f - f_GSL): 3.7564805010524372e-34
// stddev(f - f_GSL): 1.9381642090009910e-17
const testcase_assoc_legendre<double>
data006[21] =
{
  { 0.0000000000000000, 2, 2, 
	  -1.0000000000000000, 0.0 },
  { 0.56999999999999984, 2, 2, 
	  -0.90000000000000002, 0.0 },
  { 1.0799999999999996, 2, 2, 
	  -0.80000000000000004, 0.0 },
  { 1.5300000000000005, 2, 2, 
	  -0.69999999999999996, 0.0 },
  { 1.9200000000000004, 2, 2, 
	  -0.59999999999999998, 0.0 },
  { 2.2500000000000000, 2, 2, 
	  -0.50000000000000000, 0.0 },
  { 2.5200000000000000, 2, 2, 
	  -0.39999999999999991, 0.0 },
  { 2.7299999999999995, 2, 2, 
	  -0.29999999999999993, 0.0 },
  { 2.8799999999999999, 2, 2, 
	  -0.19999999999999996, 0.0 },
  { 2.9700000000000002, 2, 2, 
	  -0.099999999999999978, 0.0 },
  { 3.0000000000000000, 2, 2, 
	  0.0000000000000000, 0.0 },
  { 2.9700000000000002, 2, 2, 
	  0.10000000000000009, 0.0 },
  { 2.8799999999999999, 2, 2, 
	  0.20000000000000018, 0.0 },
  { 2.7300000000000004, 2, 2, 
	  0.30000000000000004, 0.0 },
  { 2.5199999999999991, 2, 2, 
	  0.40000000000000013, 0.0 },
  { 2.2500000000000000, 2, 2, 
	  0.50000000000000000, 0.0 },
  { 1.9199999999999997, 2, 2, 
	  0.60000000000000009, 0.0 },
  { 1.5299999999999989, 2, 2, 
	  0.70000000000000018, 0.0 },
  { 1.0799999999999996, 2, 2, 
	  0.80000000000000004, 0.0 },
  { 0.56999999999999929, 2, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 2, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for l=5, m=0.
// max(|f - f_GSL|): 2.0122792321330962e-16 at index 19
// max(|f - f_GSL| / |f_GSL|): 4.8911475274405560e-15
// mean(f - f_GSL): -2.3129646346357427e-18
// variance(f - f_GSL): 2.8086478355647191e-37
// stddev(f - f_GSL): 5.2996677589870847e-19
const testcase_assoc_legendre<double>
data007[21] =
{
  { -1.0000000000000000, 5, 0, 
	  -1.0000000000000000, 0.0 },
  { 0.041141250000000087, 5, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.39951999999999993, 5, 0, 
	  -0.80000000000000004, 0.0 },
  { 0.36519874999999991, 5, 0, 
	  -0.69999999999999996, 0.0 },
  { 0.15263999999999994, 5, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.089843750000000000, 5, 0, 
	  -0.50000000000000000, 0.0 },
  { -0.27064000000000010, 5, 0, 
	  -0.39999999999999991, 0.0 },
  { -0.34538624999999995, 5, 0, 
	  -0.29999999999999993, 0.0 },
  { -0.30751999999999996, 5, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.17882874999999995, 5, 0, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 5, 0, 
	  0.0000000000000000, 0.0 },
  { 0.17882875000000015, 5, 0, 
	  0.10000000000000009, 0.0 },
  { 0.30752000000000013, 5, 0, 
	  0.20000000000000018, 0.0 },
  { 0.34538625000000001, 5, 0, 
	  0.30000000000000004, 0.0 },
  { 0.27063999999999988, 5, 0, 
	  0.40000000000000013, 0.0 },
  { 0.089843750000000000, 5, 0, 
	  0.50000000000000000, 0.0 },
  { -0.15264000000000016, 5, 0, 
	  0.60000000000000009, 0.0 },
  { -0.36519875000000024, 5, 0, 
	  0.70000000000000018, 0.0 },
  { -0.39951999999999993, 5, 0, 
	  0.80000000000000004, 0.0 },
  { -0.041141249999999151, 5, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 5, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for l=5, m=1.
// max(|f - f_GSL|): 6.6613381477509392e-16 at index 14
// max(|f - f_GSL| / |f_GSL|): 5.5186908001167120e-16
// mean(f - f_GSL): 1.0573552615477681e-17
// variance(f - f_GSL): 5.8695007828944331e-36
// stddev(f - f_GSL): 2.4227052612512388e-18
const testcase_assoc_legendre<double>
data008[21] =
{
  { -0.0000000000000000, 5, 1, 
	  -1.0000000000000000, 0.0 },
  { 2.8099369608350981, 5, 1, 
	  -0.90000000000000002, 0.0 },
  { 0.72180000000000089, 5, 1, 
	  -0.80000000000000004, 0.0 },
  { -1.0951826834447254, 5, 1, 
	  -0.69999999999999996, 0.0 },
  { -1.9775999999999998, 5, 1, 
	  -0.59999999999999998, 0.0 },
  { -1.9282596881137892, 5, 1, 
	  -0.50000000000000000, 0.0 },
  { -1.2070504380513671, 5, 1, 
	  -0.39999999999999991, 0.0 },
  { -0.16079837663884300, 5, 1, 
	  -0.29999999999999993, 0.0 },
  { 0.87005875663658538, 5, 1, 
	  -0.19999999999999996, 0.0 },
  { 1.6083350053680323, 5, 1, 
	  -0.099999999999999978, 0.0 },
  { 1.8750000000000000, 5, 1, 
	  0.0000000000000000, 0.0 },
  { 1.6083350053680314, 5, 1, 
	  0.10000000000000009, 0.0 },
  { 0.87005875663658327, 5, 1, 
	  0.20000000000000018, 0.0 },
  { -0.16079837663884422, 5, 1, 
	  0.30000000000000004, 0.0 },
  { -1.2070504380513694, 5, 1, 
	  0.40000000000000013, 0.0 },
  { -1.9282596881137892, 5, 1, 
	  0.50000000000000000, 0.0 },
  { -1.9775999999999998, 5, 1, 
	  0.60000000000000009, 0.0 },
  { -1.0951826834447216, 5, 1, 
	  0.70000000000000018, 0.0 },
  { 0.72180000000000089, 5, 1, 
	  0.80000000000000004, 0.0 },
  { 2.8099369608350999, 5, 1, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 5, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for l=5, m=2.
// max(|f - f_GSL|): 3.5527136788005009e-15 at index 12
// max(|f - f_GSL| / |f_GSL|): 5.4136589391245733e-16
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 0.0000000000000000
// stddev(f - f_GSL): 0.0000000000000000
const testcase_assoc_legendre<double>
data009[21] =
{
  { 0.0000000000000000, 5, 2, 
	  -1.0000000000000000, 0.0 },
  { -12.837825000000000, 5, 2, 
	  -0.90000000000000002, 0.0 },
  { -13.910400000000001, 5, 2, 
	  -0.80000000000000004, 0.0 },
  { -8.8089749999999967, 5, 2, 
	  -0.69999999999999996, 0.0 },
  { -1.6128000000000000, 5, 2, 
	  -0.59999999999999998, 0.0 },
  { 4.9218750000000000, 5, 2, 
	  -0.50000000000000000, 0.0 },
  { 9.1728000000000005, 5, 2, 
	  -0.39999999999999991, 0.0 },
  { 10.462724999999997, 5, 2, 
	  -0.29999999999999993, 0.0 },
  { 8.8703999999999983, 5, 2, 
	  -0.19999999999999996, 0.0 },
  { 5.0415749999999990, 5, 2, 
	  -0.099999999999999978, 0.0 },
  { -0.0000000000000000, 5, 2, 
	  0.0000000000000000, 0.0 },
  { -5.0415750000000044, 5, 2, 
	  0.10000000000000009, 0.0 },
  { -8.8704000000000054, 5, 2, 
	  0.20000000000000018, 0.0 },
  { -10.462725000000001, 5, 2, 
	  0.30000000000000004, 0.0 },
  { -9.1727999999999970, 5, 2, 
	  0.40000000000000013, 0.0 },
  { -4.9218750000000000, 5, 2, 
	  0.50000000000000000, 0.0 },
  { 1.6128000000000047, 5, 2, 
	  0.60000000000000009, 0.0 },
  { 8.8089750000000109, 5, 2, 
	  0.70000000000000018, 0.0 },
  { 13.910400000000001, 5, 2, 
	  0.80000000000000004, 0.0 },
  { 12.837824999999990, 5, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 5, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for l=5, m=5.
// max(|f - f_GSL|): 1.0231815394945443e-12 at index 12
// max(|f - f_GSL| / |f_GSL|): 1.1990652164995755e-15
// mean(f - f_GSL): -3.1128538899966297e-14
// variance(f - f_GSL): 5.0871761537452526e-29
// stddev(f - f_GSL): 7.1324442891236469e-15
const testcase_assoc_legendre<double>
data010[21] =
{
  { 0.0000000000000000, 5, 5, 
	  -1.0000000000000000, 0.0 },
  { 14.870165800941818, 5, 5, 
	  -0.90000000000000002, 0.0 },
  { 73.483199999999925, 5, 5, 
	  -0.80000000000000004, 0.0 },
  { 175.53238298794764, 5, 5, 
	  -0.69999999999999996, 0.0 },
  { 309.65760000000006, 5, 5, 
	  -0.59999999999999998, 0.0 },
  { 460.34662869916559, 5, 5, 
	  -0.50000000000000000, 0.0 },
  { 611.12496255819883, 5, 5, 
	  -0.39999999999999991, 0.0 },
  { 746.50941479523703, 5, 5, 
	  -0.29999999999999993, 0.0 },
  { 853.31600434671316, 5, 5, 
	  -0.19999999999999996, 0.0 },
  { 921.55189181724734, 5, 5, 
	  -0.099999999999999978, 0.0 },
  { 945.00000000000000, 5, 5, 
	  0.0000000000000000, 0.0 },
  { 921.55189181724734, 5, 5, 
	  0.10000000000000009, 0.0 },
  { 853.31600434671316, 5, 5, 
	  0.20000000000000018, 0.0 },
  { 746.50941479523760, 5, 5, 
	  0.30000000000000004, 0.0 },
  { 611.12496255819838, 5, 5, 
	  0.40000000000000013, 0.0 },
  { 460.34662869916559, 5, 5, 
	  0.50000000000000000, 0.0 },
  { 309.65759999999989, 5, 5, 
	  0.60000000000000009, 0.0 },
  { 175.53238298794724, 5, 5, 
	  0.70000000000000018, 0.0 },
  { 73.483199999999925, 5, 5, 
	  0.80000000000000004, 0.0 },
  { 14.870165800941789, 5, 5, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 5, 5, 
	  1.0000000000000000, 0.0 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for l=10, m=0.
// max(|f - f_GSL|): 3.8857805861880479e-16 at index 19
// max(|f - f_GSL| / |f_GSL|): 1.4766655123690915e-15
// mean(f - f_GSL): -2.5112187461759493e-17
// variance(f - f_GSL): 3.3107652853513909e-35
// stddev(f - f_GSL): 5.7539249954716919e-18
const testcase_assoc_legendre<double>
data011[21] =
{
  { 1.0000000000000000, 10, 0, 
	  -1.0000000000000000, 0.0 },
  { -0.26314561785585960, 10, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.30052979560000004, 10, 0, 
	  -0.80000000000000004, 0.0 },
  { 0.085805795531640333, 10, 0, 
	  -0.69999999999999996, 0.0 },
  { -0.24366274560000001, 10, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.18822860717773438, 10, 0, 
	  -0.50000000000000000, 0.0 },
  { 0.096839064400000258, 10, 0, 
	  -0.39999999999999991, 0.0 },
  { 0.25147634951601561, 10, 0, 
	  -0.29999999999999993, 0.0 },
  { 0.12907202559999983, 10, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.12212499738710943, 10, 0, 
	  -0.099999999999999978, 0.0 },
  { -0.24609375000000000, 10, 0, 
	  0.0000000000000000, 0.0 },
  { -0.12212499738710922, 10, 0, 
	  0.10000000000000009, 0.0 },
  { 0.12907202560000042, 10, 0, 
	  0.20000000000000018, 0.0 },
  { 0.25147634951601561, 10, 0, 
	  0.30000000000000004, 0.0 },
  { 0.096839064399999633, 10, 0, 
	  0.40000000000000013, 0.0 },
  { -0.18822860717773438, 10, 0, 
	  0.50000000000000000, 0.0 },
  { -0.24366274559999984, 10, 0, 
	  0.60000000000000009, 0.0 },
  { 0.085805795531641277, 10, 0, 
	  0.70000000000000018, 0.0 },
  { 0.30052979560000004, 10, 0, 
	  0.80000000000000004, 0.0 },
  { -0.26314561785586010, 10, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 10, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for l=10, m=1.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 14
// max(|f - f_GSL| / |f_GSL|): 5.3672431731635395e-16
// mean(f - f_GSL): -6.3441315692866085e-17
// variance(f - f_GSL): 2.1130202818419960e-34
// stddev(f - f_GSL): 1.4536231567507432e-17
const testcase_assoc_legendre<double>
data012[21] =
{
  { 0.0000000000000000, 10, 1, 
	  -1.0000000000000000, 0.0 },
  { 3.0438748781479039, 10, 1, 
	  -0.90000000000000002, 0.0 },
  { 0.87614260800000254, 10, 1, 
	  -0.80000000000000004, 0.0 },
  { -2.9685359952934527, 10, 1, 
	  -0.69999999999999996, 0.0 },
  { -1.2511825919999997, 10, 1, 
	  -0.59999999999999998, 0.0 },
  { 2.0066877394361260, 10, 1, 
	  -0.50000000000000000, 0.0 },
  { 2.4822196173476647, 10, 1, 
	  -0.39999999999999991, 0.0 },
  { 0.12309508907433593, 10, 1, 
	  -0.29999999999999993, 0.0 },
  { -2.2468221751958413, 10, 1, 
	  -0.19999999999999996, 0.0 },
  { -2.2472659777983512, 10, 1, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 10, 1, 
	  0.0000000000000000, 0.0 },
  { 2.2472659777983535, 10, 1, 
	  0.10000000000000009, 0.0 },
  { 2.2468221751958377, 10, 1, 
	  0.20000000000000018, 0.0 },
  { -0.12309508907433910, 10, 1, 
	  0.30000000000000004, 0.0 },
  { -2.4822196173476669, 10, 1, 
	  0.40000000000000013, 0.0 },
  { -2.0066877394361260, 10, 1, 
	  0.50000000000000000, 0.0 },
  { 1.2511825920000037, 10, 1, 
	  0.60000000000000009, 0.0 },
  { 2.9685359952934505, 10, 1, 
	  0.70000000000000018, 0.0 },
  { -0.87614260800000254, 10, 1, 
	  0.80000000000000004, 0.0 },
  { -3.0438748781478981, 10, 1, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 10, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for l=10, m=2.
// max(|f - f_GSL|): 1.2434497875801753e-14 at index 12
// max(|f - f_GSL| / |f_GSL|): 1.9632900580960751e-15
// mean(f - f_GSL): -8.4588420923821446e-17
// variance(f - f_GSL): 3.7564805010524372e-34
// stddev(f - f_GSL): 1.9381642090009910e-17
const testcase_assoc_legendre<double>
data013[21] =
{
  { 0.0000000000000000, 10, 2, 
	  -1.0000000000000000, 0.0 },
  { 16.376387762496137, 10, 2, 
	  -0.90000000000000002, 0.0 },
  { -35.394657804000005, 10, 2, 
	  -0.80000000000000004, 0.0 },
  { -3.6191429423788648, 10, 2, 
	  -0.69999999999999996, 0.0 },
  { 28.679675904000014, 10, 2, 
	  -0.59999999999999998, 0.0 },
  { 18.388023376464844, 10, 2, 
	  -0.50000000000000000, 0.0 },
  { -12.818955996000021, 10, 2, 
	  -0.39999999999999991, 0.0 },
  { -27.739821675972646, 10, 2, 
	  -0.29999999999999993, 0.0 },
  { -13.280661503999987, 10, 2, 
	  -0.19999999999999996, 0.0 },
  { 13.885467170308601, 10, 2, 
	  -0.099999999999999978, 0.0 },
  { 27.070312500000000, 10, 2, 
	  0.0000000000000000, 0.0 },
  { 13.885467170308573, 10, 2, 
	  0.10000000000000009, 0.0 },
  { -13.280661504000051, 10, 2, 
	  0.20000000000000018, 0.0 },
  { -27.739821675972664, 10, 2, 
	  0.30000000000000004, 0.0 },
  { -12.818955995999961, 10, 2, 
	  0.40000000000000013, 0.0 },
  { 18.388023376464844, 10, 2, 
	  0.50000000000000000, 0.0 },
  { 28.679675904000000, 10, 2, 
	  0.60000000000000009, 0.0 },
  { -3.6191429423789856, 10, 2, 
	  0.70000000000000018, 0.0 },
  { -35.394657804000005, 10, 2, 
	  0.80000000000000004, 0.0 },
  { 16.376387762496201, 10, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 10, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for l=10, m=5.
// max(|f - f_GSL|): 2.9103830456733704e-11 at index 12
// max(|f - f_GSL| / |f_GSL|): 1.4825078449301893e-15
// mean(f - f_GSL): -2.4253192047278085e-12
// variance(f - f_GSL): 3.0881409535313035e-25
// stddev(f - f_GSL): 5.5571044200476413e-13
const testcase_assoc_legendre<double>
data014[21] =
{
  { -0.0000000000000000, 10, 5, 
	  -1.0000000000000000, 0.0 },
  { -21343.618518164680, 10, 5, 
	  -0.90000000000000002, 0.0 },
  { -40457.016407807983, 10, 5, 
	  -0.80000000000000004, 0.0 },
  { -20321.279317331315, 10, 5, 
	  -0.69999999999999996, 0.0 },
  { 14410.820616192004, 10, 5, 
	  -0.59999999999999998, 0.0 },
  { 30086.169706116176, 10, 5, 
	  -0.50000000000000000, 0.0 },
  { 17177.549337582834, 10, 5, 
	  -0.39999999999999991, 0.0 },
  { -9272.5119495412546, 10, 5, 
	  -0.29999999999999993, 0.0 },
  { -26591.511184414714, 10, 5, 
	  -0.19999999999999996, 0.0 },
  { -21961.951238504211, 10, 5, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 10, 5, 
	  0.0000000000000000, 0.0 },
  { 21961.951238504229, 10, 5, 
	  0.10000000000000009, 0.0 },
  { 26591.511184414703, 10, 5, 
	  0.20000000000000018, 0.0 },
  { 9272.5119495412364, 10, 5, 
	  0.30000000000000004, 0.0 },
  { -17177.549337582877, 10, 5, 
	  0.40000000000000013, 0.0 },
  { -30086.169706116176, 10, 5, 
	  0.50000000000000000, 0.0 },
  { -14410.820616191972, 10, 5, 
	  0.60000000000000009, 0.0 },
  { 20321.279317331391, 10, 5, 
	  0.70000000000000018, 0.0 },
  { 40457.016407807983, 10, 5, 
	  0.80000000000000004, 0.0 },
  { 21343.618518164636, 10, 5, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 10, 5, 
	  1.0000000000000000, 0.0 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for l=10, m=10.
// max(|f - f_GSL|): 1.1920928955078125e-06 at index 12
// max(|f - f_GSL| / |f_GSL|): 2.3944993944674592e-15
// mean(f - f_GSL): -1.5610740298316593e-08
// variance(f - f_GSL): 1.2793998664727994e-17
// stddev(f - f_GSL): 3.5768699535666649e-09
const testcase_assoc_legendre<double>
data015[21] =
{
  { 0.0000000000000000, 10, 10, 
	  -1.0000000000000000, 0.0 },
  { 162117.40078784220, 10, 10, 
	  -0.90000000000000002, 0.0 },
  { 3958896.3481267113, 10, 10, 
	  -0.80000000000000004, 0.0 },
  { 22589806.343887307, 10, 10, 
	  -0.69999999999999996, 0.0 },
  { 70300999.121633321, 10, 10, 
	  -0.59999999999999998, 0.0 },
  { 155370278.54003900, 10, 10, 
	  -0.50000000000000000, 0.0 },
  { 273815518.20150518, 10, 10, 
	  -0.39999999999999991, 0.0 },
  { 408571989.13158852, 10, 10, 
	  -0.29999999999999993, 0.0 },
  { 533848212.07990247, 10, 10, 
	  -0.19999999999999996, 0.0 },
  { 622640835.70523083, 10, 10, 
	  -0.099999999999999978, 0.0 },
  { 654729075.00000000, 10, 10, 
	  0.0000000000000000, 0.0 },
  { 622640835.70523083, 10, 10, 
	  0.10000000000000009, 0.0 },
  { 533848212.07990247, 10, 10, 
	  0.20000000000000018, 0.0 },
  { 408571989.13158917, 10, 10, 
	  0.30000000000000004, 0.0 },
  { 273815518.20150483, 10, 10, 
	  0.40000000000000013, 0.0 },
  { 155370278.54003900, 10, 10, 
	  0.50000000000000000, 0.0 },
  { 70300999.121633217, 10, 10, 
	  0.60000000000000009, 0.0 },
  { 22589806.343887202, 10, 10, 
	  0.70000000000000018, 0.0 },
  { 3958896.3481267113, 10, 10, 
	  0.80000000000000004, 0.0 },
  { 162117.40078784159, 10, 10, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 10, 10, 
	  1.0000000000000000, 0.0 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for l=20, m=0.
// max(|f - f_GSL|): 3.6082248300317588e-16 at index 19
// max(|f - f_GSL| / |f_GSL|): 2.4166281401316513e-15
// mean(f - f_GSL): 0.0000000000000000
// variance(f - f_GSL): 4.9424644697959907e-65
// stddev(f - f_GSL): 7.0302663319365015e-33
const testcase_assoc_legendre<double>
data016[21] =
{
  { 1.0000000000000000, 20, 0, 
	  -1.0000000000000000, 0.0 },
  { -0.14930823530984835, 20, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.22420460541741347, 20, 0, 
	  -0.80000000000000004, 0.0 },
  { -0.20457394463834172, 20, 0, 
	  -0.69999999999999996, 0.0 },
  { 0.15916752910098109, 20, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.048358381067373557, 20, 0, 
	  -0.50000000000000000, 0.0 },
  { -0.10159261558628112, 20, 0, 
	  -0.39999999999999991, 0.0 },
  { 0.18028715947998047, 20, 0, 
	  -0.29999999999999993, 0.0 },
  { -0.098042194344594796, 20, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.082077130944527663, 20, 0, 
	  -0.099999999999999978, 0.0 },
  { 0.17619705200195312, 20, 0, 
	  0.0000000000000000, 0.0 },
  { -0.082077130944528023, 20, 0, 
	  0.10000000000000009, 0.0 },
  { -0.098042194344594089, 20, 0, 
	  0.20000000000000018, 0.0 },
  { 0.18028715947998042, 20, 0, 
	  0.30000000000000004, 0.0 },
  { -0.10159261558628192, 20, 0, 
	  0.40000000000000013, 0.0 },
  { -0.048358381067373557, 20, 0, 
	  0.50000000000000000, 0.0 },
  { 0.15916752910098075, 20, 0, 
	  0.60000000000000009, 0.0 },
  { -0.20457394463834136, 20, 0, 
	  0.70000000000000018, 0.0 },
  { 0.22420460541741347, 20, 0, 
	  0.80000000000000004, 0.0 },
  { -0.14930823530984758, 20, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 20, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for l=20, m=1.
// max(|f - f_GSL|): 1.3322676295501878e-15 at index 12
// max(|f - f_GSL| / |f_GSL|): 1.0752784502271902e-15
// mean(f - f_GSL): -1.4274296030894871e-16
// variance(f - f_GSL): 1.0697165176825104e-33
// stddev(f - f_GSL): 3.2706521026891724e-17
const testcase_assoc_legendre<double>
data017[21] =
{
  { -0.0000000000000000, 20, 1, 
	  -1.0000000000000000, 0.0 },
  { -4.3838334818220499, 20, 1, 
	  -0.90000000000000002, 0.0 },
  { 0.63138296146340844, 20, 1, 
	  -0.80000000000000004, 0.0 },
  { -0.72274871413391395, 20, 1, 
	  -0.69999999999999996, 0.0 },
  { 2.3203528743824910, 20, 1, 
	  -0.59999999999999998, 0.0 },
  { -3.7399919228791405, 20, 1, 
	  -0.50000000000000000, 0.0 },
  { 3.1692202279270085, 20, 1, 
	  -0.39999999999999991, 0.0 },
  { -0.15804468835345031, 20, 1, 
	  -0.29999999999999993, 0.0 },
  { -3.0366182393271171, 20, 1, 
	  -0.19999999999999996, 0.0 },
  { 3.2115523815580209, 20, 1, 
	  -0.099999999999999978, 0.0 },
  { -0.0000000000000000, 20, 1, 
	  0.0000000000000000, 0.0 },
  { -3.2115523815580169, 20, 1, 
	  0.10000000000000009, 0.0 },
  { 3.0366182393271259, 20, 1, 
	  0.20000000000000018, 0.0 },
  { 0.15804468835344135, 20, 1, 
	  0.30000000000000004, 0.0 },
  { -3.1692202279269970, 20, 1, 
	  0.40000000000000013, 0.0 },
  { 3.7399919228791405, 20, 1, 
	  0.50000000000000000, 0.0 },
  { -2.3203528743824995, 20, 1, 
	  0.60000000000000009, 0.0 },
  { 0.72274871413393793, 20, 1, 
	  0.70000000000000018, 0.0 },
  { -0.63138296146340844, 20, 1, 
	  0.80000000000000004, 0.0 },
  { 4.3838334818220686, 20, 1, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 20, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for l=20, m=2.
// max(|f - f_GSL|): 2.4868995751603507e-14 at index 5
// max(|f - f_GSL| / |f_GSL|): 1.0097407175524082e-15
// mean(f - f_GSL): -2.0301221021717147e-15
// variance(f - f_GSL): 2.1637327686062039e-31
// stddev(f - f_GSL): 4.6515941016023782e-16
const testcase_assoc_legendre<double>
data018[21] =
{
  { 0.0000000000000000, 20, 2, 
	  -1.0000000000000000, 0.0 },
  { 80.812425587310102, 20, 2, 
	  -0.90000000000000002, 0.0 },
  { -95.849622172549374, 20, 2, 
	  -0.80000000000000004, 0.0 },
  { 87.337927630325510, 20, 2, 
	  -0.69999999999999996, 0.0 },
  { -70.330891533985834, 20, 2, 
	  -0.59999999999999998, 0.0 },
  { 24.629090735179489, 20, 2, 
	  -0.50000000000000000, 0.0 },
  { 39.902576338912247, 20, 2, 
	  -0.39999999999999991, 0.0 },
  { -75.621201471396546, 20, 2, 
	  -0.29999999999999993, 0.0 },
  { 42.417415829726494, 20, 2, 
	  -0.19999999999999996, 0.0 },
  { 33.826848678871293, 20, 2, 
	  -0.099999999999999978, 0.0 },
  { -74.002761840820312, 20, 2, 
	  0.0000000000000000, 0.0 },
  { 33.826848678871464, 20, 2, 
	  0.10000000000000009, 0.0 },
  { 42.417415829726188, 20, 2, 
	  0.20000000000000018, 0.0 },
  { -75.621201471396603, 20, 2, 
	  0.30000000000000004, 0.0 },
  { 39.902576338912553, 20, 2, 
	  0.40000000000000013, 0.0 },
  { 24.629090735179489, 20, 2, 
	  0.50000000000000000, 0.0 },
  { -70.330891533985721, 20, 2, 
	  0.60000000000000009, 0.0 },
  { 87.337927630325453, 20, 2, 
	  0.70000000000000018, 0.0 },
  { -95.849622172549374, 20, 2, 
	  0.80000000000000004, 0.0 },
  { 80.812425587309747, 20, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 20, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for l=20, m=5.
// max(|f - f_GSL|): 1.2805685400962830e-09 at index 14
// max(|f - f_GSL| / |f_GSL|): 2.0861530799041223e-15
// mean(f - f_GSL): -1.1641532182693481e-10
// variance(f - f_GSL): 7.1150767569361226e-22
// stddev(f - f_GSL): 2.6674101216228678e-11
const testcase_assoc_legendre<double>
data019[21] =
{
  { 0.0000000000000000, 20, 5, 
	  -1.0000000000000000, 0.0 },
  { 315702.32715134218, 20, 5, 
	  -0.90000000000000002, 0.0 },
  { -503060.91484852589, 20, 5, 
	  -0.80000000000000004, 0.0 },
  { 298127.28360361955, 20, 5, 
	  -0.69999999999999996, 0.0 },
  { 114444.61447464029, 20, 5, 
	  -0.59999999999999998, 0.0 },
  { -543428.40914592845, 20, 5, 
	  -0.50000000000000000, 0.0 },
  { 613842.07728185481, 20, 5, 
	  -0.39999999999999991, 0.0 },
  { -143765.42411271061, 20, 5, 
	  -0.29999999999999993, 0.0 },
  { -472600.45321372285, 20, 5, 
	  -0.19999999999999996, 0.0 },
  { 563861.76771496492, 20, 5, 
	  -0.099999999999999978, 0.0 },
  { -0.0000000000000000, 20, 5, 
	  0.0000000000000000, 0.0 },
  { -563861.76771496458, 20, 5, 
	  0.10000000000000009, 0.0 },
  { 472600.45321372483, 20, 5, 
	  0.20000000000000018, 0.0 },
  { 143765.42411270936, 20, 5, 
	  0.30000000000000004, 0.0 },
  { -613842.07728185353, 20, 5, 
	  0.40000000000000013, 0.0 },
  { 543428.40914592845, 20, 5, 
	  0.50000000000000000, 0.0 },
  { -114444.61447464178, 20, 5, 
	  0.60000000000000009, 0.0 },
  { -298127.28360361519, 20, 5, 
	  0.70000000000000018, 0.0 },
  { 503060.91484852589, 20, 5, 
	  0.80000000000000004, 0.0 },
  { -315702.32715133618, 20, 5, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 20, 5, 
	  1.0000000000000000, 0.0 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for l=20, m=10.
// max(|f - f_GSL|): 0.0039062500000000000 at index 12
// max(|f - f_GSL| / |f_GSL|): 2.6634565089260680e-15
// mean(f - f_GSL): -0.00043596540178571431
// variance(f - f_GSL): 9.9784562846311215e-09
// stddev(f - f_GSL): 9.9892223344117843e-05
const testcase_assoc_legendre<double>
data020[21] =
{
  { -0.0000000000000000, 20, 10, 
	  -1.0000000000000000, 0.0 },
  { 990017476694.99084, 20, 10, 
	  -0.90000000000000002, 0.0 },
  { 2392757933281.0498, 20, 10, 
	  -0.80000000000000004, 0.0 },
  { -1548364524949.5808, 20, 10, 
	  -0.69999999999999996, 0.0 },
  { -424471915195.05627, 20, 10, 
	  -0.59999999999999998, 0.0 },
  { 1744502295946.2073, 20, 10, 
	  -0.50000000000000000, 0.0 },
  { -899973487310.55530, 20, 10, 
	  -0.39999999999999991, 0.0 },
  { -1092420454297.7119, 20, 10, 
	  -0.29999999999999993, 0.0 },
  { 1466609267659.8816, 20, 10, 
	  -0.19999999999999996, 0.0 },
  { 356041756390.71674, 20, 10, 
	  -0.099999999999999978, 0.0 },
  { -1612052956674.3164, 20, 10, 
	  0.0000000000000000, 0.0 },
  { 356041756390.71985, 20, 10, 
	  0.10000000000000009, 0.0 },
  { 1466609267659.8796, 20, 10, 
	  0.20000000000000018, 0.0 },
  { -1092420454297.7161, 20, 10, 
	  0.30000000000000004, 0.0 },
  { -899973487310.54810, 20, 10, 
	  0.40000000000000013, 0.0 },
  { 1744502295946.2073, 20, 10, 
	  0.50000000000000000, 0.0 },
  { -424471915195.05896, 20, 10, 
	  0.60000000000000009, 0.0 },
  { -1548364524949.5730, 20, 10, 
	  0.70000000000000018, 0.0 },
  { 2392757933281.0498, 20, 10, 
	  0.80000000000000004, 0.0 },
  { 990017476694.98828, 20, 10, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 20, 10, 
	  1.0000000000000000, 0.0 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for l=20, m=20.
// max(|f - f_GSL|): 838860800.00000000 at index 12
// max(|f - f_GSL| / |f_GSL|): 4.3488507135833189e-15
// mean(f - f_GSL): -2855497.1428571427
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data021[21] =
{
  { 0.0000000000000000, 20, 20, 
	  -1.0000000000000000, 0.0 },
  { 19609049712023808., 20, 20, 
	  -0.90000000000000002, 0.0 },
  { 1.1693527616833221e+19, 20, 20, 
	  -0.80000000000000004, 0.0 },
  { 3.8073455880620691e+20, 20, 20, 
	  -0.69999999999999996, 0.0 },
  { 3.6874002249007927e+21, 20, 20, 
	  -0.59999999999999998, 0.0 },
  { 1.8010806978179592e+22, 20, 20, 
	  -0.50000000000000000, 0.0 },
  { 5.5938832584012466e+22, 20, 20, 
	  -0.39999999999999991, 0.0 },
  { 1.2454734132297759e+23, 20, 20, 
	  -0.29999999999999993, 0.0 },
  { 2.1263407800797497e+23, 20, 20, 
	  -0.19999999999999996, 0.0 },
  { 2.8924941146976873e+23, 20, 20, 
	  -0.099999999999999978, 0.0 },
  { 3.1983098677287775e+23, 20, 20, 
	  0.0000000000000000, 0.0 },
  { 2.8924941146976873e+23, 20, 20, 
	  0.10000000000000009, 0.0 },
  { 2.1263407800797497e+23, 20, 20, 
	  0.20000000000000018, 0.0 },
  { 1.2454734132297811e+23, 20, 20, 
	  0.30000000000000004, 0.0 },
  { 5.5938832584012366e+22, 20, 20, 
	  0.40000000000000013, 0.0 },
  { 1.8010806978179592e+22, 20, 20, 
	  0.50000000000000000, 0.0 },
  { 3.6874002249007807e+21, 20, 20, 
	  0.60000000000000009, 0.0 },
  { 3.8073455880620343e+20, 20, 20, 
	  0.70000000000000018, 0.0 },
  { 1.1693527616833221e+19, 20, 20, 
	  0.80000000000000004, 0.0 },
  { 19609049712023672., 20, 20, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 20, 20, 
	  1.0000000000000000, 0.0 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for l=50, m=0.
// max(|f - f_GSL|): 1.6653345369377348e-16 at index 2
// max(|f - f_GSL| / |f_GSL|): 1.6665460706897444e-15
// mean(f - f_GSL): -8.0953762212251003e-18
// variance(f - f_GSL): 3.4405935985667807e-36
// stddev(f - f_GSL): 1.8548837156454796e-18
const testcase_assoc_legendre<double>
data022[21] =
{
  { 1.0000000000000000, 50, 0, 
	  -1.0000000000000000, 0.0 },
  { -0.17003765994383671, 50, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.13879737345093113, 50, 0, 
	  -0.80000000000000004, 0.0 },
  { -0.014572731645892852, 50, 0, 
	  -0.69999999999999996, 0.0 },
  { -0.058860798844002096, 50, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.031059099239609811, 50, 0, 
	  -0.50000000000000000, 0.0 },
  { 0.041569033381824674, 50, 0, 
	  -0.39999999999999991, 0.0 },
  { 0.10911051574714790, 50, 0, 
	  -0.29999999999999993, 0.0 },
  { 0.083432272204197494, 50, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.038205812661313600, 50, 0, 
	  -0.099999999999999978, 0.0 },
  { -0.11227517265921705, 50, 0, 
	  0.0000000000000000, 0.0 },
  { -0.038205812661314155, 50, 0, 
	  0.10000000000000009, 0.0 },
  { 0.083432272204196564, 50, 0, 
	  0.20000000000000018, 0.0 },
  { 0.10911051574714797, 50, 0, 
	  0.30000000000000004, 0.0 },
  { 0.041569033381826007, 50, 0, 
	  0.40000000000000013, 0.0 },
  { -0.031059099239609811, 50, 0, 
	  0.50000000000000000, 0.0 },
  { -0.058860798844001430, 50, 0, 
	  0.60000000000000009, 0.0 },
  { -0.014572731645890737, 50, 0, 
	  0.70000000000000018, 0.0 },
  { 0.13879737345093113, 50, 0, 
	  0.80000000000000004, 0.0 },
  { -0.17003765994383679, 50, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 50, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for l=50, m=1.
// max(|f - f_GSL|): 4.4408920985006262e-15 at index 3
// max(|f - f_GSL| / |f_GSL|): 6.6657627150738456e-16
// mean(f - f_GSL): -6.3441315692866085e-17
// variance(f - f_GSL): 2.1130202818419960e-34
// stddev(f - f_GSL): 1.4536231567507432e-17
const testcase_assoc_legendre<double>
data023[21] =
{
  { -0.0000000000000000, 50, 1, 
	  -1.0000000000000000, 0.0 },
  { 0.13424149984449490, 50, 1, 
	  -0.90000000000000002, 0.0 },
  { -2.2011219672413018, 50, 1, 
	  -0.80000000000000004, 0.0 },
  { -6.6622414993232004, 50, 1, 
	  -0.69999999999999996, 0.0 },
  { -5.5772846936919249, 50, 1, 
	  -0.59999999999999998, 0.0 },
  { -5.8787148815607608, 50, 1, 
	  -0.50000000000000000, 0.0 },
  { -5.5473459458634080, 50, 1, 
	  -0.39999999999999991, 0.0 },
  { -1.8444956647620248, 50, 1, 
	  -0.29999999999999993, 0.0 },
  { 3.8722014306642127, 50, 1, 
	  -0.19999999999999996, 0.0 },
  { 5.3488751322285628, 50, 1, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 50, 1, 
	  0.0000000000000000, 0.0 },
  { -5.3488751322285522, 50, 1, 
	  0.10000000000000009, 0.0 },
  { -3.8722014306642620, 50, 1, 
	  0.20000000000000018, 0.0 },
  { 1.8444956647619930, 50, 1, 
	  0.30000000000000004, 0.0 },
  { 5.5473459458633814, 50, 1, 
	  0.40000000000000013, 0.0 },
  { 5.8787148815607608, 50, 1, 
	  0.50000000000000000, 0.0 },
  { 5.5772846936919453, 50, 1, 
	  0.60000000000000009, 0.0 },
  { 6.6622414993232182, 50, 1, 
	  0.70000000000000018, 0.0 },
  { 2.2011219672413018, 50, 1, 
	  0.80000000000000004, 0.0 },
  { -0.13424149984438935, 50, 1, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 50, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for l=50, m=2.
// max(|f - f_GSL|): 3.0553337637684308e-13 at index 3
// max(|f - f_GSL| / |f_GSL|): 6.0837685805857877e-15
// mean(f - f_GSL): -3.3835368369528578e-16
// variance(f - f_GSL): 6.0103688016838995e-33
// stddev(f - f_GSL): 7.7526568360039641e-17
const testcase_assoc_legendre<double>
data024[21] =
{
  { 0.0000000000000000, 50, 2, 
	  -1.0000000000000000, 0.0 },
  { 433.04168483713511, 50, 2, 
	  -0.90000000000000002, 0.0 },
  { -348.06364372056424, 50, 2, 
	  -0.80000000000000004, 0.0 },
  { 50.221071418108444, 50, 2, 
	  -0.69999999999999996, 0.0 },
  { 158.46096409274352, 50, 2, 
	  -0.59999999999999998, 0.0 },
  { 85.988858299721457, 50, 2, 
	  -0.50000000000000000, 0.0 },
  { -101.15891460879088, 50, 2, 
	  -0.39999999999999991, 0.0 },
  { -277.07168105316526, 50, 2, 
	  -0.29999999999999993, 0.0 },
  { -214.33311373510401, 50, 2, 
	  -0.19999999999999996, 0.0 },
  { 96.349657930951665, 50, 2, 
	  -0.099999999999999978, 0.0 },
  { 286.30169028100346, 50, 2, 
	  0.0000000000000000, 0.0 },
  { 96.349657930953242, 50, 2, 
	  0.10000000000000009, 0.0 },
  { -214.33311373510165, 50, 2, 
	  0.20000000000000018, 0.0 },
  { -277.07168105316617, 50, 2, 
	  0.30000000000000004, 0.0 },
  { -101.15891460879435, 50, 2, 
	  0.40000000000000013, 0.0 },
  { 85.988858299721457, 50, 2, 
	  0.50000000000000000, 0.0 },
  { 158.46096409274153, 50, 2, 
	  0.60000000000000009, 0.0 },
  { 50.221071418103143, 50, 2, 
	  0.70000000000000018, 0.0 },
  { -348.06364372056424, 50, 2, 
	  0.80000000000000004, 0.0 },
  { 433.04168483713596, 50, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 50, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler024 = 5.0000000000000039e-13;

// Test data for l=50, m=5.
// max(|f - f_GSL|): 7.4505805969238281e-08 at index 14
// max(|f - f_GSL| / |f_GSL|): 2.0088060426072767e-15
// mean(f - f_GSL): 6.3862119402204238e-09
// variance(f - f_GSL): 2.1411444046342303e-18
// stddev(f - f_GSL): 1.4632649810045447e-09
const testcase_assoc_legendre<double>
data025[21] =
{
  { 0.0000000000000000, 50, 5, 
	  -1.0000000000000000, 0.0 },
  { 27340473.952132829, 50, 5, 
	  -0.90000000000000002, 0.0 },
  { -27753716.768532373, 50, 5, 
	  -0.80000000000000004, 0.0 },
  { -40808153.913493633, 50, 5, 
	  -0.69999999999999996, 0.0 },
  { -32071189.035790090, 50, 5, 
	  -0.59999999999999998, 0.0 },
  { -36265736.218529105, 50, 5, 
	  -0.50000000000000000, 0.0 },
  { -37089596.700204931, 50, 5, 
	  -0.39999999999999991, 0.0 },
  { -14562029.629244687, 50, 5, 
	  -0.29999999999999993, 0.0 },
  { 23686895.217517190, 50, 5, 
	  -0.19999999999999996, 0.0 },
  { 34878992.965676002, 50, 5, 
	  -0.099999999999999978, 0.0 },
  { 0.0000000000000000, 50, 5, 
	  0.0000000000000000, 0.0 },
  { -34878992.965675958, 50, 5, 
	  0.10000000000000009, 0.0 },
  { -23686895.217517529, 50, 5, 
	  0.20000000000000018, 0.0 },
  { 14562029.629244499, 50, 5, 
	  0.30000000000000004, 0.0 },
  { 37089596.700204782, 50, 5, 
	  0.40000000000000013, 0.0 },
  { 36265736.218529105, 50, 5, 
	  0.50000000000000000, 0.0 },
  { 32071189.035790242, 50, 5, 
	  0.60000000000000009, 0.0 },
  { 40808153.913493834, 50, 5, 
	  0.70000000000000018, 0.0 },
  { 27753716.768532373, 50, 5, 
	  0.80000000000000004, 0.0 },
  { -27340473.952132136, 50, 5, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 50, 5, 
	  1.0000000000000000, 0.0 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for l=50, m=10.
// max(|f - f_GSL|): 22.000000000000000 at index 3
// max(|f - f_GSL| / |f_GSL|): 2.2163032493360465e-15
// mean(f - f_GSL): -1.9821428571428572
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data026[21] =
{
  { -0.0000000000000000, 50, 10, 
	  -1.0000000000000000, 0.0 },
  { -8994661710093155.0, 50, 10, 
	  -0.90000000000000002, 0.0 },
  { 932311375306569.62, 50, 10, 
	  -0.80000000000000004, 0.0 },
  { 12153535011507012., 50, 10, 
	  -0.69999999999999996, 0.0 },
  { 12176690755542240., 50, 10, 
	  -0.59999999999999998, 0.0 },
  { 9180035388465754.0, 50, 10, 
	  -0.50000000000000000, 0.0 },
  { 889201701866984.00, 50, 10, 
	  -0.39999999999999991, 0.0 },
  { -9451384032851544.0, 50, 10, 
	  -0.29999999999999993, 0.0 },
  { -9926439446673564.0, 50, 10, 
	  -0.19999999999999996, 0.0 },
  { 2794368162749970.5, 50, 10, 
	  -0.099999999999999978, 0.0 },
  { 11452238249246346., 50, 10, 
	  0.0000000000000000, 0.0 },
  { 2794368162750031.0, 50, 10, 
	  0.10000000000000009, 0.0 },
  { -9926439446673506.0, 50, 10, 
	  0.20000000000000018, 0.0 },
  { -9451384032851604.0, 50, 10, 
	  0.30000000000000004, 0.0 },
  { 889201701866835.25, 50, 10, 
	  0.40000000000000013, 0.0 },
  { 9180035388465754.0, 50, 10, 
	  0.50000000000000000, 0.0 },
  { 12176690755542214., 50, 10, 
	  0.60000000000000009, 0.0 },
  { 12153535011506908., 50, 10, 
	  0.70000000000000018, 0.0 },
  { 932311375306569.62, 50, 10, 
	  0.80000000000000004, 0.0 },
  { -8994661710093013.0, 50, 10, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 50, 10, 
	  1.0000000000000000, 0.0 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for l=50, m=20.
// max(|f - f_GSL|): 3.6028797018963968e+18 at index 14
// max(|f - f_GSL| / |f_GSL|): 5.0227025739283085e-15
// mean(f - f_GSL): -1.8529095609752899e+17
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data027[21] =
{
  { 0.0000000000000000, 50, 20, 
	  -1.0000000000000000, 0.0 },
  { 1.6630925158645501e+33, 50, 20, 
	  -0.90000000000000002, 0.0 },
  { 1.0622676657892052e+33, 50, 20, 
	  -0.80000000000000004, 0.0 },
  { 8.6022521164717112e+32, 50, 20, 
	  -0.69999999999999996, 0.0 },
  { 4.0860128756808466e+32, 50, 20, 
	  -0.59999999999999998, 0.0 },
  { -4.0169860814274459e+32, 50, 20, 
	  -0.50000000000000000, 0.0 },
  { -8.2324325279773994e+32, 50, 20, 
	  -0.39999999999999991, 0.0 },
  { -4.0054067236247267e+31, 50, 20, 
	  -0.29999999999999993, 0.0 },
  { 7.9309266056434309e+32, 50, 20, 
	  -0.19999999999999996, 0.0 },
  { 5.4151358290898977e+31, 50, 20, 
	  -0.099999999999999978, 0.0 },
  { -7.8735935697332210e+32, 50, 20, 
	  0.0000000000000000, 0.0 },
  { 5.4151358290894924e+31, 50, 20, 
	  0.10000000000000009, 0.0 },
  { 7.9309266056434453e+32, 50, 20, 
	  0.20000000000000018, 0.0 },
  { -4.0054067236243731e+31, 50, 20, 
	  0.30000000000000004, 0.0 },
  { -8.2324325279773893e+32, 50, 20, 
	  0.40000000000000013, 0.0 },
  { -4.0169860814274459e+32, 50, 20, 
	  0.50000000000000000, 0.0 },
  { 4.0860128756807846e+32, 50, 20, 
	  0.60000000000000009, 0.0 },
  { 8.6022521164716291e+32, 50, 20, 
	  0.70000000000000018, 0.0 },
  { 1.0622676657892052e+33, 50, 20, 
	  0.80000000000000004, 0.0 },
  { 1.6630925158645541e+33, 50, 20, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 50, 20, 
	  1.0000000000000000, 0.0 },
};
const double toler027 = 5.0000000000000039e-13;

// Test data for l=50, m=50.
// max(|f - f_GSL|): 1.0695779622587839e+64 at index 12
// max(|f - f_GSL| / |f_GSL|): 1.1061123055945194e-14
// mean(f - f_GSL): -2.0817504896587826e+62
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data028[21] =
{
  { 0.0000000000000000, 50, 50, 
	  -1.0000000000000000, 0.0 },
  { 2.5366994974431341e+60, 50, 50, 
	  -0.90000000000000002, 0.0 },
  { 2.2028834403101213e+67, 50, 50, 
	  -0.80000000000000004, 0.0 },
  { 1.3325496559566651e+71, 50, 50, 
	  -0.69999999999999996, 0.0 },
  { 3.8898096431781969e+73, 50, 50, 
	  -0.59999999999999998, 0.0 },
  { 2.0509760257037188e+75, 50, 50, 
	  -0.50000000000000000, 0.0 },
  { 3.4866724533443283e+76, 50, 50, 
	  -0.39999999999999991, 0.0 },
  { 2.5790740224149893e+77, 50, 50, 
	  -0.29999999999999993, 0.0 },
  { 9.8222237931680989e+77, 50, 50, 
	  -0.19999999999999996, 0.0 },
  { 2.1198682190366617e+78, 50, 50, 
	  -0.099999999999999978, 0.0 },
  { 2.7253921397507295e+78, 50, 50, 
	  0.0000000000000000, 0.0 },
  { 2.1198682190366617e+78, 50, 50, 
	  0.10000000000000009, 0.0 },
  { 9.8222237931680989e+77, 50, 50, 
	  0.20000000000000018, 0.0 },
  { 2.5790740224150207e+77, 50, 50, 
	  0.30000000000000004, 0.0 },
  { 3.4866724533443123e+76, 50, 50, 
	  0.40000000000000013, 0.0 },
  { 2.0509760257037188e+75, 50, 50, 
	  0.50000000000000000, 0.0 },
  { 3.8898096431781724e+73, 50, 50, 
	  0.60000000000000009, 0.0 },
  { 1.3325496559566344e+71, 50, 50, 
	  0.70000000000000018, 0.0 },
  { 2.2028834403101213e+67, 50, 50, 
	  0.80000000000000004, 0.0 },
  { 2.5366994974430855e+60, 50, 50, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 50, 50, 
	  1.0000000000000000, 0.0 },
};
const double toler028 = 1.0000000000000008e-12;

// Test data for l=100, m=0.
// max(|f - f_GSL|): 3.4694469519536142e-16 at index 2
// max(|f - f_GSL| / |f_GSL|): 6.8214063779431592e-15
// mean(f - f_GSL): -4.1385545784018113e-17
// variance(f - f_GSL): 8.9920078491655612e-35
// stddev(f - f_GSL): 9.4826198116161765e-18
const testcase_assoc_legendre<double>
data029[21] =
{
  { 1.0000000000000000, 100, 0, 
	  -1.0000000000000000, 0.0 },
  { 0.10226582055871893, 100, 0, 
	  -0.90000000000000002, 0.0 },
  { 0.050861167913584228, 100, 0, 
	  -0.80000000000000004, 0.0 },
  { -0.077132507199778641, 100, 0, 
	  -0.69999999999999996, 0.0 },
  { -0.023747023905133141, 100, 0, 
	  -0.59999999999999998, 0.0 },
  { -0.060518025961861198, 100, 0, 
	  -0.50000000000000000, 0.0 },
  { -0.072258202125685025, 100, 0, 
	  -0.39999999999999991, 0.0 },
  { 0.057127392202801046, 100, 0, 
	  -0.29999999999999993, 0.0 },
  { 0.014681835355659706, 100, 0, 
	  -0.19999999999999996, 0.0 },
  { -0.063895098434750205, 100, 0, 
	  -0.099999999999999978, 0.0 },
  { 0.079589237387178727, 100, 0, 
	  0.0000000000000000, 0.0 },
  { -0.063895098434749761, 100, 0, 
	  0.10000000000000009, 0.0 },
  { 0.014681835355657875, 100, 0, 
	  0.20000000000000018, 0.0 },
  { 0.057127392202801566, 100, 0, 
	  0.30000000000000004, 0.0 },
  { -0.072258202125684082, 100, 0, 
	  0.40000000000000013, 0.0 },
  { -0.060518025961861198, 100, 0, 
	  0.50000000000000000, 0.0 },
  { -0.023747023905134217, 100, 0, 
	  0.60000000000000009, 0.0 },
  { -0.077132507199780501, 100, 0, 
	  0.70000000000000018, 0.0 },
  { 0.050861167913584228, 100, 0, 
	  0.80000000000000004, 0.0 },
  { 0.10226582055872063, 100, 0, 
	  0.90000000000000013, 0.0 },
  { 1.0000000000000000, 100, 0, 
	  1.0000000000000000, 0.0 },
};
const double toler029 = 5.0000000000000039e-13;

// Test data for l=100, m=1.
// max(|f - f_GSL|): 1.1546319456101628e-14 at index 3
// max(|f - f_GSL| / |f_GSL|): 2.1111954004946762e-15
// mean(f - f_GSL): 8.0358999877630379e-16
// variance(f - f_GSL): 3.3902236521998243e-32
// stddev(f - f_GSL): 1.8412559985509414e-16
const testcase_assoc_legendre<double>
data030[21] =
{
  { 0.0000000000000000, 100, 1, 
	  -1.0000000000000000, 0.0 },
  { -6.5200167187780345, 100, 1, 
	  -0.90000000000000002, 0.0 },
  { -9.0065170007027486, 100, 1, 
	  -0.80000000000000004, 0.0 },
  { 5.4690908541180976, 100, 1, 
	  -0.69999999999999996, 0.0 },
  { 8.6275439170430790, 100, 1, 
	  -0.59999999999999998, 0.0 },
  { 6.0909031663448454, 100, 1, 
	  -0.50000000000000000, 0.0 },
  { -4.1160338699560395, 100, 1, 
	  -0.39999999999999991, 0.0 },
  { -5.8491043010758634, 100, 1, 
	  -0.29999999999999993, 0.0 },
  { 7.9435138723089826, 100, 1, 
	  -0.19999999999999996, 0.0 },
  { -4.7996285823989355, 100, 1, 
	  -0.099999999999999978, 0.0 },
  { -0.0000000000000000, 100, 1, 
	  0.0000000000000000, 0.0 },
  { 4.7996285823990101, 100, 1, 
	  0.10000000000000009, 0.0 },
  { -7.9435138723090155, 100, 1, 
	  0.20000000000000018, 0.0 },
  { 5.8491043010758013, 100, 1, 
	  0.30000000000000004, 0.0 },
  { 4.1160338699562162, 100, 1, 
	  0.40000000000000013, 0.0 },
  { -6.0909031663448454, 100, 1, 
	  0.50000000000000000, 0.0 },
  { -8.6275439170430470, 100, 1, 
	  0.60000000000000009, 0.0 },
  { -5.4690908541178693, 100, 1, 
	  0.70000000000000018, 0.0 },
  { 9.0065170007027486, 100, 1, 
	  0.80000000000000004, 0.0 },
  { 6.5200167187777787, 100, 1, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 100, 1, 
	  1.0000000000000000, 0.0 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for l=100, m=2.
// max(|f - f_GSL|): 6.8212102632969618e-13 at index 5
// max(|f - f_GSL| / |f_GSL|): 2.0632212207447263e-15
// mean(f - f_GSL): 8.2558298821649733e-14
// variance(f - f_GSL): 3.5783331697705263e-28
// stddev(f - f_GSL): 1.8916482679849673e-14
const testcase_assoc_legendre<double>
data031[21] =
{
  { 0.0000000000000000, 100, 2, 
	  -1.0000000000000000, 0.0 },
  { -1005.9604880761002, 100, 2, 
	  -0.90000000000000002, 0.0 },
  { -489.68041725865947, 100, 2, 
	  -0.80000000000000004, 0.0 },
  { 768.31676011669924, 100, 2, 
	  -0.69999999999999996, 0.0 },
  { 226.90362556627937, 100, 2, 
	  -0.59999999999999998, 0.0 },
  { 604.19889304940341, 100, 2, 
	  -0.50000000000000000, 0.0 },
  { 733.40061037838518, 100, 2, 
	  -0.39999999999999991, 0.0 },
  { -573.30774483995629, 100, 2, 
	  -0.29999999999999993, 0.0 },
  { -151.52946305080880, 100, 2, 
	  -0.19999999999999996, 0.0 },
  { 646.30525583587985, 100, 2, 
	  -0.099999999999999978, 0.0 },
  { -803.85129761050518, 100, 2, 
	  0.0000000000000000, 0.0 },
  { 646.30525583587439, 100, 2, 
	  0.10000000000000009, 0.0 },
  { -151.52946305079013, 100, 2, 
	  0.20000000000000018, 0.0 },
  { -573.30774483996390, 100, 2, 
	  0.30000000000000004, 0.0 },
  { 733.40061037837552, 100, 2, 
	  0.40000000000000013, 0.0 },
  { 604.19889304940341, 100, 2, 
	  0.50000000000000000, 0.0 },
  { 226.90362556629168, 100, 2, 
	  0.60000000000000009, 0.0 },
  { 768.31676011671766, 100, 2, 
	  0.70000000000000018, 0.0 },
  { -489.68041725865947, 100, 2, 
	  0.80000000000000004, 0.0 },
  { -1005.9604880761161, 100, 2, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 100, 2, 
	  1.0000000000000000, 0.0 },
};
const double toler031 = 2.5000000000000020e-13;

// Test data for l=100, m=5.
// max(|f - f_GSL|): 1.4305114746093750e-06 at index 14
// max(|f - f_GSL| / |f_GSL|): 3.7628882298853693e-15
// mean(f - f_GSL): 5.1089695521763390e-08
// variance(f - f_GSL): 1.3703324189659077e-16
// stddev(f - f_GSL): 1.1706119848036358e-08
const testcase_assoc_legendre<double>
data032[21] =
{
  { -0.0000000000000000, 100, 5, 
	  -1.0000000000000000, 0.0 },
  { -900551126.09653807, 100, 5, 
	  -0.90000000000000002, 0.0 },
  { -988567431.55756140, 100, 5, 
	  -0.80000000000000004, 0.0 },
  { 645646451.90344620, 100, 5, 
	  -0.69999999999999996, 0.0 },
  { 897114585.29920685, 100, 5, 
	  -0.59999999999999998, 0.0 },
  { 661710744.42483854, 100, 5, 
	  -0.50000000000000000, 0.0 },
  { -380163158.51424754, 100, 5, 
	  -0.39999999999999991, 0.0 },
  { -617391071.36633193, 100, 5, 
	  -0.29999999999999993, 0.0 },
  { 805288801.85509109, 100, 5, 
	  -0.19999999999999996, 0.0 },
  { -481041740.16728652, 100, 5, 
	  -0.099999999999999978, 0.0 },
  { -0.0000000000000000, 100, 5, 
	  0.0000000000000000, 0.0 },
  { 481041740.16729391, 100, 5, 
	  0.10000000000000009, 0.0 },
  { -805288801.85509515, 100, 5, 
	  0.20000000000000018, 0.0 },
  { 617391071.36632574, 100, 5, 
	  0.30000000000000004, 0.0 },
  { 380163158.51426536, 100, 5, 
	  0.40000000000000013, 0.0 },
  { -661710744.42483854, 100, 5, 
	  0.50000000000000000, 0.0 },
  { -897114585.29920483, 100, 5, 
	  0.60000000000000009, 0.0 },
  { -645646451.90342283, 100, 5, 
	  0.70000000000000018, 0.0 },
  { 988567431.55756140, 100, 5, 
	  0.80000000000000004, 0.0 },
  { 900551126.09651637, 100, 5, 
	  0.90000000000000013, 0.0 },
  { -0.0000000000000000, 100, 5, 
	  1.0000000000000000, 0.0 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for l=100, m=10.
// max(|f - f_GSL|): 14336.000000000000 at index 14
// max(|f - f_GSL| / |f_GSL|): 3.4905902237930355e-15
// mean(f - f_GSL): 341.33333333333331
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data033[21] =
{
  { 0.0000000000000000, 100, 10, 
	  -1.0000000000000000, 0.0 },
  { 2.5643395957658602e+17, 100, 10, 
	  -0.90000000000000002, 0.0 },
  { 1.5778673545673485e+18, 100, 10, 
	  -0.80000000000000004, 0.0 },
  { 4.4355048487496801e+18, 100, 10, 
	  -0.69999999999999996, 0.0 },
  { -9.5936111659124288e+17, 100, 10, 
	  -0.59999999999999998, 0.0 },
  { 4.2387123021963438e+18, 100, 10, 
	  -0.50000000000000000, 0.0 },
  { 8.2370834618426767e+18, 100, 10, 
	  -0.39999999999999991, 0.0 },
  { -4.9089358388051978e+18, 100, 10, 
	  -0.29999999999999993, 0.0 },
  { -2.3468810358091274e+18, 100, 10, 
	  -0.19999999999999996, 0.0 },
  { 6.8627855225034568e+18, 100, 10, 
	  -0.099999999999999978, 0.0 },
  { -8.2494597181670380e+18, 100, 10, 
	  0.0000000000000000, 0.0 },
  { 6.8627855225034056e+18, 100, 10, 
	  0.10000000000000009, 0.0 },
  { -2.3468810358089518e+18, 100, 10, 
	  0.20000000000000018, 0.0 },
  { -4.9089358388052941e+18, 100, 10, 
	  0.30000000000000004, 0.0 },
  { 8.2370834618426112e+18, 100, 10, 
	  0.40000000000000013, 0.0 },
  { 4.2387123021963438e+18, 100, 10, 
	  0.50000000000000000, 0.0 },
  { -9.5936111659112640e+17, 100, 10, 
	  0.60000000000000009, 0.0 },
  { 4.4355048487499668e+18, 100, 10, 
	  0.70000000000000018, 0.0 },
  { 1.5778673545673485e+18, 100, 10, 
	  0.80000000000000004, 0.0 },
  { 2.5643395957630058e+17, 100, 10, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 100, 10, 
	  1.0000000000000000, 0.0 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for l=100, m=20.
// max(|f - f_GSL|): 3.9290089137475448e+24 at index 14
// max(|f - f_GSL| / |f_GSL|): 5.1615589395022552e-15
// mean(f - f_GSL): -5.0371909150609551e+23
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data034[21] =
{
  { 0.0000000000000000, 100, 20, 
	  -1.0000000000000000, 0.0 },
  { 7.1604344878780134e+37, 100, 20, 
	  -0.90000000000000002, 0.0 },
  { -8.3963895116962231e+38, 100, 20, 
	  -0.80000000000000004, 0.0 },
  { 7.9022236853110145e+38, 100, 20, 
	  -0.69999999999999996, 0.0 },
  { 8.2680005574121013e+38, 100, 20, 
	  -0.59999999999999998, 0.0 },
  { 3.0750497039999552e+38, 100, 20, 
	  -0.50000000000000000, 0.0 },
  { -7.6120586043843556e+38, 100, 20, 
	  -0.39999999999999991, 0.0 },
  { 1.1474496891900921e+38, 100, 20, 
	  -0.29999999999999993, 0.0 },
  { 4.3966251307444241e+38, 100, 20, 
	  -0.19999999999999996, 0.0 },
  { -7.0503266451702591e+38, 100, 20, 
	  -0.099999999999999978, 0.0 },
  { 7.7727439836159581e+38, 100, 20, 
	  0.0000000000000000, 0.0 },
  { -7.0503266451702213e+38, 100, 20, 
	  0.10000000000000009, 0.0 },
  { 4.3966251307442783e+38, 100, 20, 
	  0.20000000000000018, 0.0 },
  { 1.1474496891901797e+38, 100, 20, 
	  0.30000000000000004, 0.0 },
  { -7.6120586043844176e+38, 100, 20, 
	  0.40000000000000013, 0.0 },
  { 3.0750497039999552e+38, 100, 20, 
	  0.50000000000000000, 0.0 },
  { 8.2680005574120394e+38, 100, 20, 
	  0.60000000000000009, 0.0 },
  { 7.9022236853108422e+38, 100, 20, 
	  0.70000000000000018, 0.0 },
  { -8.3963895116962231e+38, 100, 20, 
	  0.80000000000000004, 0.0 },
  { 7.1604344878751847e+37, 100, 20, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 100, 20, 
	  1.0000000000000000, 0.0 },
};
const double toler034 = 5.0000000000000039e-13;

// Test data for l=100, m=50.
// max(|f - f_GSL|): 6.8296953242310788e+83 at index 14
// max(|f - f_GSL| / |f_GSL|): 2.0345950516284159e-14
// mean(f - f_GSL): 7.0103750947133818e+82
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data035[21] =
{
  { 0.0000000000000000, 100, 50, 
	  -1.0000000000000000, 0.0 },
  { 9.3231278516893716e+96, 100, 50, 
	  -0.90000000000000002, 0.0 },
  { -1.1029797977454281e+98, 100, 50, 
	  -0.80000000000000004, 0.0 },
  { 1.8089333903465606e+97, 100, 50, 
	  -0.69999999999999996, 0.0 },
  { 5.9364045925669405e+97, 100, 50, 
	  -0.59999999999999998, 0.0 },
  { -8.2252620339727118e+97, 100, 50, 
	  -0.50000000000000000, 0.0 },
  { 7.1431385093740728e+97, 100, 50, 
	  -0.39999999999999991, 0.0 },
  { -3.3520602067479935e+97, 100, 50, 
	  -0.29999999999999993, 0.0 },
  { -2.7791149588121382e+97, 100, 50, 
	  -0.19999999999999996, 0.0 },
  { 9.0119338550180417e+97, 100, 50, 
	  -0.099999999999999978, 0.0 },
  { -1.1712145031578381e+98, 100, 50, 
	  0.0000000000000000, 0.0 },
  { 9.0119338550181207e+97, 100, 50, 
	  0.10000000000000009, 0.0 },
  { -2.7791149588123644e+97, 100, 50, 
	  0.20000000000000018, 0.0 },
  { -3.3520602067479344e+97, 100, 50, 
	  0.30000000000000004, 0.0 },
  { 7.1431385093738816e+97, 100, 50, 
	  0.40000000000000013, 0.0 },
  { -8.2252620339727118e+97, 100, 50, 
	  0.50000000000000000, 0.0 },
  { 5.9364045925668024e+97, 100, 50, 
	  0.60000000000000009, 0.0 },
  { 1.8089333903469005e+97, 100, 50, 
	  0.70000000000000018, 0.0 },
  { -1.1029797977454281e+98, 100, 50, 
	  0.80000000000000004, 0.0 },
  { 9.3231278516892938e+96, 100, 50, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 100, 50, 
	  1.0000000000000000, 0.0 },
};
const double toler035 = 2.5000000000000015e-12;

// Test data for l=100, m=100.
// max(|f - f_GSL|): 1.9201920817492002e+172 at index 12
// max(|f - f_GSL| / |f_GSL|): 2.3348104188683898e-14
// mean(f - f_GSL): -4.0709851490379341e+170
// variance(f - f_GSL): inf
// stddev(f - f_GSL): inf
const testcase_assoc_legendre<double>
data036[21] =
{
  { 0.0000000000000000, 100, 100, 
	  -1.0000000000000000, 0.0 },
  { 5.7751792255758316e+150, 100, 100, 
	  -0.90000000000000002, 0.0 },
  { 4.3552236041585515e+164, 100, 100, 
	  -0.80000000000000004, 0.0 },
  { 1.5936546850595123e+172, 100, 100, 
	  -0.69999999999999996, 0.0 },
  { 1.3579510590289176e+177, 100, 100, 
	  -0.59999999999999998, 0.0 },
  { 3.7752749682889513e+180, 100, 100, 
	  -0.50000000000000000, 0.0 },
  { 1.0910627330458913e+183, 100, 100, 
	  -0.39999999999999991, 0.0 },
  { 5.9697347526821064e+184, 100, 100, 
	  -0.29999999999999993, 0.0 },
  { 8.6585879147526714e+185, 100, 100, 
	  -0.19999999999999996, 0.0 },
  { 4.0331571908057011e+186, 100, 100, 
	  -0.099999999999999978, 0.0 },
  { 6.6663086700729543e+186, 100, 100, 
	  0.0000000000000000, 0.0 },
  { 4.0331571908057011e+186, 100, 100, 
	  0.10000000000000009, 0.0 },
  { 8.6585879147526714e+185, 100, 100, 
	  0.20000000000000018, 0.0 },
  { 5.9697347526822483e+184, 100, 100, 
	  0.30000000000000004, 0.0 },
  { 1.0910627330458797e+183, 100, 100, 
	  0.40000000000000013, 0.0 },
  { 3.7752749682889513e+180, 100, 100, 
	  0.50000000000000000, 0.0 },
  { 1.3579510590289000e+177, 100, 100, 
	  0.60000000000000009, 0.0 },
  { 1.5936546850594382e+172, 100, 100, 
	  0.70000000000000018, 0.0 },
  { 4.3552236041585515e+164, 100, 100, 
	  0.80000000000000004, 0.0 },
  { 5.7751792255756128e+150, 100, 100, 
	  0.90000000000000013, 0.0 },
  { 0.0000000000000000, 100, 100, 
	  1.0000000000000000, 0.0 },
};
const double toler036 = 2.5000000000000015e-12;

template<typename Ret, unsigned int Num>
  void
  test(const testcase_assoc_legendre<Ret> (&data)[Num], Ret toler)
  {
    bool test __attribute__((unused)) = true;
    const Ret eps = std::numeric_limits<Ret>::epsilon();
    Ret max_abs_diff = -Ret(1);
    Ret max_abs_frac = -Ret(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Ret f = std::assoc_legendre(data[i].l, data[i].m,
		     data[i].x);
	const Ret f0 = data[i].f0;
	const Ret diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Ret(10) * eps
	 && std::abs(f) > Ret(10) * eps)
	  {
	    const Ret frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  return 0;
}
