# 34 "src/wp/why3_xml.mll"
 
  type element =
    { name : string;
      attributes : (string * string) list;
      elements : element list;
    }

  type t =
      { version : string;
        encoding : string;
        doctype : string;
        dtd : string;
        content : element;
      }

  let buf = Buffer.create 17

  let rec pop_all group_stack element_stack =
    match group_stack with
      | [] -> element_stack
      | (elem,att,elems)::g ->
          let e = {
            name = elem;
            attributes = att;
            elements = List.rev element_stack;
          }
          in pop_all g (e::elems)

  exception Parse_error of string

  let parse_error s = raise (Parse_error s)

# 35 "src/wp/why3_xml.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\251\255\000\000\002\000\000\000\000\000\000\000\007\000\
    \002\000\003\000\009\000\004\000\005\000\006\000\008\000\011\000\
    \013\000\012\000\014\000\016\000\015\000\032\000\018\000\027\000\
    \074\000\019\000\023\000\254\255\025\000\028\000\026\000\029\000\
    \030\000\033\000\036\000\052\000\031\000\041\000\037\000\065\000\
    \055\000\067\000\122\000\132\000\040\000\253\255\252\255\134\000\
    \253\255\000\000\014\000\030\000\024\000\045\000\030\000\028\000\
    \053\000\069\000\139\000\087\001\201\001\146\000\254\255\084\000\
    \178\000\250\255\251\255\021\002\148\000\096\002\171\002\029\003\
    \253\255\160\000\143\003\250\255\251\255\000\000\253\255\001\004\
    \173\000\254\255\180\000\115\004\252\255\215\000\252\255\253\255\
    \254\255\187\000\017\000\248\255\249\255\071\000\255\255\041\000\
    \034\000\044\000\046\000\104\000\254\255\106\000\253\255\056\000\
    \056\000\117\000\252\255\065\000\070\000\083\000\140\000\251\255\
    \142\000\250\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\004\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\002\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\003\000\000\000\255\255\001\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\004\000\255\255\004\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\006\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255";
  Lexing.lex_default = 
   "\001\000\000\000\255\255\255\255\255\255\255\255\255\255\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\000\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\000\000\000\000\048\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\063\000\000\000\063\000\
    \065\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\076\000\000\000\000\000\255\255\000\000\255\255\
    \255\255\000\000\255\255\255\255\000\000\087\000\000\000\000\000\
    \000\000\255\255\092\000\000\000\000\000\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\000\000\255\255\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\003\000\003\000\003\000\003\000\003\000\000\000\003\000\
    \010\000\010\000\010\000\010\000\010\000\000\000\010\000\050\000\
    \050\000\000\000\000\000\050\000\000\000\000\000\000\000\000\000\
    \003\000\051\000\003\000\000\000\024\000\024\000\000\000\010\000\
    \024\000\010\000\000\000\000\000\000\000\000\000\050\000\000\000\
    \019\000\000\000\000\000\094\000\023\000\000\000\000\000\093\000\
    \000\000\000\000\000\000\024\000\002\000\021\000\084\000\004\000\
    \046\000\020\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\018\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \022\000\008\000\008\000\024\000\024\000\027\000\036\000\024\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\035\000\052\000\008\000\008\000\042\000\045\000\053\000\
    \008\000\012\000\024\000\039\000\007\000\006\000\040\000\041\000\
    \054\000\015\000\055\000\008\000\037\000\056\000\008\000\013\000\
    \005\000\014\000\016\000\017\000\029\000\038\000\031\000\011\000\
    \008\000\028\000\008\000\043\000\043\000\057\000\032\000\043\000\
    \034\000\026\000\058\000\030\000\033\000\043\000\043\000\050\000\
    \050\000\043\000\062\000\050\000\059\000\059\000\107\000\103\000\
    \059\000\108\000\043\000\061\000\061\000\068\000\068\000\061\000\
    \101\000\068\000\099\000\100\000\043\000\102\000\050\000\104\000\
    \095\000\073\000\073\000\059\000\105\000\073\000\097\000\025\000\
    \106\000\112\000\061\000\098\000\068\000\109\000\080\000\080\000\
    \096\000\008\000\080\000\068\000\068\000\082\000\082\000\068\000\
    \073\000\082\000\049\000\044\000\089\000\089\000\110\000\111\000\
    \089\000\113\000\000\000\000\000\000\000\080\000\000\000\000\000\
    \062\000\000\000\068\000\000\000\082\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\089\000\000\000\000\000\072\000\000\000\
    \089\000\089\000\000\000\000\000\089\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\067\000\000\000\
    \000\000\081\000\000\000\000\000\000\000\000\000\000\000\089\000\
    \000\000\088\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\091\000\255\255\255\255\000\000\000\000\000\000\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\000\000\255\255\255\255\000\000\000\000\
    \255\255\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \059\000\059\000\000\000\000\000\059\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\059\000\
    \000\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\000\000\255\255\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\000\000\255\255\000\000\000\000\000\000\000\000\000\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\066\000\000\000\000\000\000\000\060\000\000\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\061\000\061\000\000\000\000\000\061\000\086\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\061\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\000\000\000\000\000\000\000\000\
    \060\000\000\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\069\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \000\000\000\000\000\000\000\000\070\000\000\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\000\000\000\000\000\000\000\000\071\000\
    \000\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\000\000\000\000\
    \000\000\000\000\070\000\000\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\073\000\073\000\
    \000\000\000\000\073\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\073\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\000\000\
    \000\000\000\000\000\000\072\000\000\000\000\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \000\000\000\000\000\000\000\000\071\000\000\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \080\000\080\000\000\000\000\000\080\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\077\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\000\000\000\000\000\000\000\000\078\000\000\000\000\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\000\000\000\000\000\000\000\000\079\000\000\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\082\000\082\000\000\000\000\000\082\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\082\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\000\000\000\000\000\000\081\000\000\000\
    \000\000\000\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\000\000\000\000\000\000\000\000\
    \083\000\000\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\082\000\082\000\000\000\000\000\
    \082\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\075\000\
    \000\000\000\000\000\000\082\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\000\000\000\000\000\000\
    \081\000\000\000\000\000\000\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\000\000\000\000\
    \000\000\000\000\083\000\000\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\003\000\003\000\000\000\255\255\003\000\
    \007\000\007\000\010\000\010\000\007\000\255\255\010\000\050\000\
    \050\000\255\255\255\255\050\000\255\255\255\255\255\255\255\255\
    \000\000\049\000\003\000\255\255\023\000\023\000\255\255\007\000\
    \023\000\010\000\255\255\255\255\255\255\255\255\050\000\255\255\
    \018\000\255\255\255\255\090\000\022\000\255\255\255\255\090\000\
    \255\255\255\255\255\255\023\000\000\000\020\000\077\000\002\000\
    \008\000\019\000\009\000\011\000\012\000\013\000\007\000\014\000\
    \010\000\017\000\015\000\017\000\016\000\018\000\020\000\019\000\
    \021\000\022\000\025\000\024\000\024\000\026\000\035\000\024\000\
    \028\000\030\000\023\000\029\000\031\000\032\000\036\000\021\000\
    \033\000\034\000\051\000\034\000\038\000\041\000\044\000\052\000\
    \037\000\011\000\024\000\038\000\006\000\005\000\039\000\040\000\
    \053\000\014\000\054\000\035\000\036\000\055\000\040\000\012\000\
    \004\000\013\000\015\000\016\000\028\000\037\000\030\000\010\000\
    \039\000\025\000\041\000\042\000\042\000\056\000\031\000\042\000\
    \033\000\024\000\057\000\029\000\032\000\043\000\043\000\047\000\
    \047\000\043\000\063\000\047\000\058\000\058\000\095\000\096\000\
    \058\000\095\000\042\000\061\000\061\000\068\000\068\000\061\000\
    \097\000\068\000\098\000\099\000\043\000\101\000\047\000\103\000\
    \093\000\073\000\073\000\058\000\104\000\073\000\093\000\024\000\
    \105\000\107\000\061\000\093\000\068\000\108\000\080\000\080\000\
    \093\000\042\000\080\000\064\000\064\000\082\000\082\000\064\000\
    \073\000\082\000\047\000\043\000\089\000\089\000\109\000\110\000\
    \089\000\112\000\255\255\255\255\255\255\080\000\255\255\255\255\
    \061\000\255\255\064\000\255\255\082\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\089\000\255\255\255\255\073\000\255\255\
    \085\000\085\000\255\255\255\255\085\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\064\000\255\255\
    \255\255\082\000\255\255\255\255\255\255\255\255\255\255\085\000\
    \255\255\085\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\008\000\009\000\011\000\012\000\013\000\007\000\
    \014\000\010\000\255\255\015\000\017\000\016\000\018\000\020\000\
    \019\000\090\000\022\000\025\000\255\255\255\255\255\255\026\000\
    \255\255\028\000\030\000\023\000\029\000\031\000\032\000\036\000\
    \021\000\033\000\255\255\255\255\034\000\038\000\255\255\255\255\
    \044\000\037\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\035\000\255\255\255\255\040\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\039\000\255\255\041\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\024\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\063\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \059\000\059\000\255\255\255\255\059\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\059\000\
    \255\255\255\255\042\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\043\000\255\255\047\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\255\255\061\000\255\255\255\255\255\255\255\255\255\255\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\064\000\255\255\255\255\255\255\059\000\255\255\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\060\000\060\000\255\255\255\255\060\000\085\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\060\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\255\255\255\255\255\255\255\255\
    \060\000\255\255\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \255\255\255\255\255\255\255\255\067\000\255\255\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \067\000\067\000\067\000\067\000\067\000\067\000\067\000\067\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\255\255\255\255\255\255\255\255\069\000\
    \255\255\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\255\255\255\255\
    \255\255\255\255\070\000\255\255\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\071\000\071\000\
    \255\255\255\255\071\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\071\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\255\255\
    \255\255\255\255\255\255\071\000\255\255\255\255\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \255\255\255\255\255\255\255\255\071\000\255\255\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \074\000\074\000\255\255\255\255\074\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\074\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\255\255\255\255\255\255\255\255\074\000\255\255\255\255\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\255\255\255\255\255\255\255\255\074\000\255\255\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\079\000\079\000\255\255\255\255\079\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\079\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\255\255\255\255\255\255\079\000\255\255\
    \255\255\255\255\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\255\255\255\255\255\255\255\255\
    \079\000\255\255\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\083\000\083\000\255\255\255\255\
    \083\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\074\000\
    \255\255\255\255\255\255\083\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\255\255\255\255\255\255\
    \083\000\255\255\255\255\255\255\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\255\255\255\255\
    \255\255\255\255\083\000\255\255\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\002\000\077\000\000\000\007\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\152\000\000\000\227\000\
    \015\000\000\000\046\001\000\000\000\000\000\000\000\000\121\001\
    \000\000\015\000\000\000\196\001\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_backtrk_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_default_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_trans_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\001\000\001\000\001\000\000\000\001\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\000\000\000\000\000\000\
    \000\000\004\000\000\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \000\000\000\000\000\000\000\000\004\000\000\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\000\000\000\000\000\000\000\000\012\000\
    \000\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\000\000\000\000\
    \000\000\000\000\012\000\000\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\000\000\000\000\000\000\000\000\012\000\000\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\000\000\000\000\000\000\000\000\
    \012\000\000\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\000\000\
    \000\000\000\000\000\000\012\000\000\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check_code = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\058\000\058\000\059\000\059\000\058\000\255\255\059\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \058\000\255\255\059\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\255\255\255\255\255\255\
    \255\255\059\000\255\255\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\059\000\059\000\059\000\
    \059\000\059\000\059\000\059\000\059\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \255\255\255\255\255\255\255\255\060\000\255\255\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \060\000\060\000\060\000\060\000\060\000\060\000\060\000\060\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\255\255\255\255\255\255\255\255\069\000\
    \255\255\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\255\255\255\255\
    \255\255\255\255\071\000\255\255\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\255\255\255\255\255\255\255\255\074\000\255\255\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\074\000\074\000\074\000\074\000\074\000\074\000\074\000\
    \074\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\255\255\255\255\255\255\255\255\
    \079\000\255\255\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\079\000\079\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\255\255\
    \255\255\255\255\255\255\083\000\255\255\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_code = 
   "\255\002\255\255\003\255\255\000\002\001\003\255\001\255\255\000\
    \001\255";
}

let rec xml_prolog lexbuf =
    __ocaml_lex_xml_prolog_rec lexbuf 0
and __ocaml_lex_xml_prolog_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 79 "src/wp/why3_xml.mll"
    ( xml_prolog lexbuf )
# 677 "src/wp/why3_xml.ml"

  | 1 ->
# 81 "src/wp/why3_xml.mll"
    ( xml_doctype "1.0" "" lexbuf )
# 682 "src/wp/why3_xml.ml"

  | 2 ->
# 83 "src/wp/why3_xml.mll"
    ( xml_doctype "1.0" "" lexbuf )
# 687 "src/wp/why3_xml.ml"

  | 3 ->
# 85 "src/wp/why3_xml.mll"
    ( (* dprintf debug "[Xml warning] prolog ignored@."; *)
      xml_doctype "1.0" "" lexbuf )
# 693 "src/wp/why3_xml.ml"

  | 4 ->
# 88 "src/wp/why3_xml.mll"
    ( parse_error "wrong prolog" )
# 698 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_xml_prolog_rec lexbuf __ocaml_lex_state

and xml_doctype version encoding lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 4 (-1) ;   __ocaml_lex_xml_doctype_rec version encoding lexbuf 47
and __ocaml_lex_xml_doctype_rec version encoding lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 92 "src/wp/why3_xml.mll"
    ( xml_doctype version encoding lexbuf )
# 709 "src/wp/why3_xml.ml"

  | 1 ->
let
# 93 "src/wp/why3_xml.mll"
                               doctype
# 715 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 94 "src/wp/why3_xml.mll"
    ( match elements [] [] lexbuf with
         | [x] ->
            { version = version;
              encoding = encoding;
              doctype = doctype;
              dtd = "";
              content = x;
            }
         | _ -> parse_error "there should be exactly one root element"
    )
# 728 "src/wp/why3_xml.ml"

  | 2 ->
# 105 "src/wp/why3_xml.mll"
    ( parse_error "wrong DOCTYPE" )
# 733 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_xml_doctype_rec version encoding lexbuf __ocaml_lex_state

and elements group_stack element_stack lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ;   __ocaml_lex_elements_rec group_stack element_stack lexbuf 64
and __ocaml_lex_elements_rec group_stack element_stack lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 109 "src/wp/why3_xml.mll"
      ( elements group_stack element_stack lexbuf )
# 744 "src/wp/why3_xml.ml"

  | 1 ->
let
# 110 "src/wp/why3_xml.mll"
                  elem
# 750 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) lexbuf.Lexing.lex_curr_pos in
# 111 "src/wp/why3_xml.mll"
      ( attributes group_stack element_stack elem [] lexbuf )
# 754 "src/wp/why3_xml.ml"

  | 2 ->
let
# 112 "src/wp/why3_xml.mll"
                   _celem
# 760 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_mem.(0) in
# 113 "src/wp/why3_xml.mll"
      ( match group_stack with
         | [] ->
             (* dprintf debug *)
             (*   "[Xml warning] unexpected closing Xml element `%s'@." *)
             (*   celem; *)
             elements group_stack element_stack lexbuf
         | (elem,att,stack)::g ->
             (* if celem <> elem then *)
               (* dprintf debug *)
               (*   "[Xml warning] Xml element `%s' closed by `%s'@." *)
               (*   elem celem; *)
             let e = {
                name = elem;
                attributes = att;
                elements = List.rev element_stack;
             }
             in elements g (e::stack) lexbuf
       )
# 781 "src/wp/why3_xml.ml"

  | 3 ->
# 132 "src/wp/why3_xml.mll"
      ( (* dprintf debug "[Xml warning] unexpected '<'@."; *)
        elements group_stack element_stack lexbuf )
# 787 "src/wp/why3_xml.ml"

  | 4 ->
# 135 "src/wp/why3_xml.mll"
      ( match group_stack with
         | [] -> element_stack
         | (_elem,_,_)::_ ->
             (* dprintf debug "[Xml warning] unclosed Xml element `%s'@."
                elem; *)
             pop_all group_stack element_stack
      )
# 798 "src/wp/why3_xml.ml"

  | 5 ->
let
# 142 "src/wp/why3_xml.mll"
         c
# 804 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 143 "src/wp/why3_xml.mll"
      ( parse_error ("invalid element starting with " ^ String.make 1 c) )
# 808 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_elements_rec group_stack element_stack lexbuf __ocaml_lex_state

and attributes groupe_stack element_stack elem acc lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 2 (-1) ;   __ocaml_lex_attributes_rec groupe_stack element_stack elem acc lexbuf 74
and __ocaml_lex_attributes_rec groupe_stack element_stack elem acc lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 147 "src/wp/why3_xml.mll"
      ( attributes groupe_stack element_stack elem acc lexbuf )
# 819 "src/wp/why3_xml.ml"

  | 1 ->
let
# 148 "src/wp/why3_xml.mll"
              key
# 825 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 149 "src/wp/why3_xml.mll"
      ( let v = value lexbuf in
        attributes groupe_stack element_stack elem ((key,v)::acc) lexbuf )
# 830 "src/wp/why3_xml.ml"

  | 2 ->
# 152 "src/wp/why3_xml.mll"
      ( elements ((elem,acc,element_stack)::groupe_stack) [] lexbuf )
# 835 "src/wp/why3_xml.ml"

  | 3 ->
# 154 "src/wp/why3_xml.mll"
      ( let e = { name = elem ;
                  attributes = acc;
                  elements = [] }
        in
        elements groupe_stack (e::element_stack) lexbuf )
# 844 "src/wp/why3_xml.ml"

  | 4 ->
let
# 159 "src/wp/why3_xml.mll"
         c
# 850 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 160 "src/wp/why3_xml.mll"
      ( parse_error ("'>' expected, got " ^ String.make 1 c) )
# 854 "src/wp/why3_xml.ml"

  | 5 ->
# 162 "src/wp/why3_xml.mll"
      ( parse_error "unclosed element, `>' expected" )
# 859 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_attributes_rec groupe_stack element_stack elem acc lexbuf __ocaml_lex_state

and value lexbuf =
    __ocaml_lex_value_rec lexbuf 85
and __ocaml_lex_value_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 166 "src/wp/why3_xml.mll"
      ( value lexbuf )
# 870 "src/wp/why3_xml.ml"

  | 1 ->
# 168 "src/wp/why3_xml.mll"
      ( Buffer.clear buf;
        string_val lexbuf )
# 876 "src/wp/why3_xml.ml"

  | 2 ->
let
# 170 "src/wp/why3_xml.mll"
         c
# 882 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 171 "src/wp/why3_xml.mll"
      ( parse_error ("invalid value starting with " ^ String.make 1 c) )
# 886 "src/wp/why3_xml.ml"

  | 3 ->
# 173 "src/wp/why3_xml.mll"
      ( parse_error "unterminated keyval pair" )
# 891 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_value_rec lexbuf __ocaml_lex_state

and string_val lexbuf =
    __ocaml_lex_string_val_rec lexbuf 90
and __ocaml_lex_string_val_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 177 "src/wp/why3_xml.mll"
      ( Buffer.contents buf )
# 902 "src/wp/why3_xml.ml"

  | 1 ->
# 179 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf '<';
        string_val lexbuf )
# 908 "src/wp/why3_xml.ml"

  | 2 ->
# 182 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf '>';
        string_val lexbuf )
# 914 "src/wp/why3_xml.ml"

  | 3 ->
# 185 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf '"';
        string_val lexbuf )
# 920 "src/wp/why3_xml.ml"

  | 4 ->
# 188 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf '\'';
        string_val lexbuf )
# 926 "src/wp/why3_xml.ml"

  | 5 ->
# 191 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf '&';
        string_val lexbuf )
# 932 "src/wp/why3_xml.ml"

  | 6 ->
let
# 193 "src/wp/why3_xml.mll"
               c
# 938 "src/wp/why3_xml.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 194 "src/wp/why3_xml.mll"
      ( Buffer.add_char buf c;
        string_val lexbuf )
# 943 "src/wp/why3_xml.ml"

  | 7 ->
# 197 "src/wp/why3_xml.mll"
      ( parse_error "unterminated string" )
# 948 "src/wp/why3_xml.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_val_rec lexbuf __ocaml_lex_state

;;

# 199 "src/wp/why3_xml.mll"
 

  let from_file f =
      let c = open_in f in
      let lb = Lexing.from_channel c in
      let t = xml_prolog lb in
      close_in c;
      t


# 965 "src/wp/why3_xml.ml"
