#!/usr/bin/perl

# upstream.pl
# creates a new upstream version of a Debian package
#
# Usage: perl upstream.pl <VERSION>
# Please note that if you specify a version number that is the same of this debianized source tree, your
# old orig.tar.gz will get overwritten!

use strict;
use warnings;

my $newversion = $ARGV[0];

my $pwd = `pwd`;
my $basepwd = `basename $pwd`;

# If you don't want to specify a version number, it will
# increment by 0.1
my $increment = 0.1;

# Let's get the package name
# and the version number
my ($package, $version) = ($1, $2) if $basepwd =~ /([\w\d\_]+)-([\d\.]+)/;
die "Seems like you're not standing in a Debianized source tree.\n" unless (defined ($package) && defined($version));

# Let's create a new orig
# working directory
$newversion = $version + $increment unless (defined($newversion) && $newversion ne '');
my $neworig = "$package_" . $newversion;
print "Creating new orig files for the new upstream version: $neworig\n";
system ("mkdir $neworig.orig");

# Let's copy all the upstream
# files in there
my @files = split("\n", `ls`);
foreach my $file (@files) {
	system("cp -R $file $neworig.orig/") unless ($file =~ /^debian$/ || $file =~ /^$neworig.orig$/);
}

# Now we'll compress the new
# file and delete the temporary
# directory
system("tar czf ../$neworig.orig.tar.gz $neworig.orig/");
system("rm -rf $neworig.orig/");

print "Created a new orig file in ../$neworig.orig.tar.gz\n";
print "Done! Now you should debian/rules binary again so the .diff.gz is recreated!\n";
