/*
 * This file is part of the Score-P software (http://www.score-p.org)
 *
 * Copyright (c) 2009-2011,
 *    RWTH Aachen University, Germany
 *    Gesellschaft fuer numerische Simulation mbH Braunschweig, Germany
 *    Technische Universitaet Dresden, Germany
 *    University of Oregon, Eugene, USA
 *    Forschungszentrum Juelich GmbH, Germany
 *    German Research School for Simulation Sciences GmbH, Juelich/Aachen, Germany
 *    Technische Universitaet Muenchen, Germany
 *
 * See the COPYING file in the package base directory for details.
 *
 */
/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
**  KOJAK       http://www.fz-juelich.de/jsc/kojak/                        **
*****************************************************************************
**  Copyright (c) 1998-2009                                                **
**  Forschungszentrum Juelich, Juelich Supercomputing Centre               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/
/** @internal
 *
 *  @file       pomp2_lib.c
 *  @status     alpha
 *
 *  @maintainer Dirk Schmidl <schmidl@rz.rwth-aachen.de>
 *
 *  @authors    Dirk Schmidl <schmidl@rz.rwth-aachen.de>
 *              Peter Philippen <p.philippen@fz-juelich.de>
 *
 *  @brief      Dummy implementation of all POMP2 Functions. These functions
 *              only print out messages and do not measure anything.*/

#include <pomp2_lib.h>

/*
 * C pomp2 function library
 */

void
POMP2_Finalize()
{
}

void
POMP2_Init()
{
}

void
POMP2_Off()
{
}

void
POMP2_On()
{
}

void
POMP2_Begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_End( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Assign_handle( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                     const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Atomic_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		    const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Atomic_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Implicit_barrier_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                              POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) )
{
}

extern void
POMP2_Implicit_barrier_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                             POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}


void
POMP2_Barrier_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                     POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) ,
                     const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Barrier_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                    POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}

void
POMP2_Flush_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		   const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Flush_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Critical_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Critical_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Critical_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		      const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Critical_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_For_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		 const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_For_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Master_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		    const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Master_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Parallel_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Parallel_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Parallel_fork( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                     int                  if_clause __attribute__((unused)) ,
                     int                  num_threads __attribute__((unused)) ,
                     POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) ,
                     const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Parallel_join( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                     POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}

void
POMP2_Section_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		     const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Section_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Sections_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		      const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Sections_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Single_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Single_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Single_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		    const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Single_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Workshare_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
		       const char ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Workshare_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Ordered_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Ordered_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Ordered_enter( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                    const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Ordered_exit( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}


void
POMP2_Task_create_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                         POMP2_Task_handle*   pomp2_new_task __attribute__((unused)) ,
                         POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) ,
                         int                  pomp2_if __attribute__((unused)) ,
                         const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Task_create_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                       POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}

void
POMP2_Task_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                  POMP2_Task_handle    pomp2_task __attribute__((unused)) )
{
}

void
POMP2_Task_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Untied_task_create_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                                POMP2_Task_handle*   pomp2_new_task __attribute__((unused)) ,
                                POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) ,
                                int                  pomp2_if __attribute__((unused)) ,
                                const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Untied_task_create_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                              POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}

void
POMP2_Untied_task_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                         POMP2_Task_handle    pomp2_parent_task __attribute__((unused)) )
{
}

void
POMP2_Untied_task_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) )
{
}

void
POMP2_Taskwait_begin( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                      POMP2_Task_handle*   pomp2_old_task __attribute__((unused)) ,
                      const char           ctc_string[] __attribute__((unused)) )
{
}

void
POMP2_Taskwait_end( POMP2_Region_handle* pomp2_handle __attribute__((unused)) ,
                    POMP2_Task_handle    pomp2_old_task __attribute__((unused)) )
{
}

/*
   *----------------------------------------------------------------
 * C Wrapper for OpenMP API
 ******----------------------------------------------------------------
 */
#ifdef OPENMP_FOUND
void
POMP2_Init_lock( omp_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Destroy_lock( omp_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Set_lock( omp_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Unset_lock( omp_lock_t* s __attribute__((unused)))
{
}

int
POMP2_Test_lock( omp_lock_t* s __attribute__((unused)))
{
  return -1;
}

void
POMP2_Init_nest_lock( omp_nest_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Destroy_nest_lock( omp_nest_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Set_nest_lock( omp_nest_lock_t* s __attribute__((unused)))
{
}

void
POMP2_Unset_nest_lock( omp_nest_lock_t* s __attribute__((unused)))
{
}

int
POMP2_Test_nest_lock( omp_nest_lock_t* s __attribute__((unused)))
{
  return -1;
}

#endif /* OPENMP_FOUND */
