#!/bin/sh

set -e

# Find the available Python 3.x versions.

interpreters=''
if [ -n "$(command -v py3versions 2>/dev/null || true)" ]; then
	for ver in $(py3versions -s -v); do
		interpreters="$interpreters python$ver"
	done
fi

# Finally run the tests.

for python in $interpreters; do
	printf -- '\n\n============ Testing %s\n\n' "$python"
	env CONFGET="$python -Wignore::SyntaxWarning -m confget" prove t
done

printf -- '\n\n============ The TAP tests passed for all Python versions\n\n'
