//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobResultsPresenter.h
//! @brief     Defines class JobResultsPresenter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBRESULTSPRESENTER_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBRESULTSPRESENTER_H

#include "GUI/View/Widget/ItemComboWidget.h"

class InstrumentItem;
enum class JobViewActivity;

//! Presents results of job (JobItem) using stack of different widgets and combo box in the
//! right top corner of JobView, to switch between widgets.

class JobResultsPresenter : public ItemComboWidget {
    Q_OBJECT
public:
    explicit JobResultsPresenter(QWidget* parent = nullptr);

    void setJobItem(JobItem* jobItem);
    void setPresentation(const QString& presentationType) override;
    void setPresentationForActivity(JobViewActivity activity);

private:
    QString itemPresentation() const override;
    QStringList activePresentationList() const override;
    QStringList presentationList() const override;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBRESULTSPRESENTER_H
