## ART Service

Warning: The contents in this doc can become stale while the code evolves.

ART Service manages dexopt artifacts of apps. With ART Service, you can dexopt
apps, query their dexopt status (the compiler filter, the compilation reason,
whether the dexopt artifacts are up-to-date, etc.), and delete dexopt artifacts.

Note: ART Service is introduced since Android U. Prior to ART Service, dexopt
artifacts were managed by Package Manager with a legacy implementation. ART
Service is the default on Android U, while partners are allowed to opt-out and
use the legacy implementation instead. The legacy implementation will be removed
since Android V. This doc only describes ART Service, not the legacy
implementation.

### Primary dex vs. secondary dex

ART Service dexopts both primary dex files and secondary dex files of an app.

A primary dex file refers to the base APK or a split APK of an app. It's
installed by Package Manager or shipped as a part of the system image, and it's
loaded by Framework on app startup.

A secondary dex file refers to an APK or JAR file that an app adds to its own
data directory and loads dynamically.

Note: Strictly speaking, an APK/JAR file is not a DEX file. It is a ZIP file
that contain one or more DEX files. However, it is called a *dex file*
conventionally.

### Compiler filters

See
[Compilation options](https://source.android.com/docs/core/runtime/configure#compilation_options).

### Dexopt scenarios

At a high level, ART Service dexopts apps in the following senarios:

-   the device is on the very first boot
-   the device is on the first boot after an OTA update
-   the device is on the first boot after a mainline update
-   an app is being installed
-   the device is idle and charging

Tip: The compilation reason, stored in the header of the OAT file, shows the
senario, in which the app is dexopted.

The sections below describe the default behavior in each senario. Note that the
list of apps to dexopt and the compiler filter, as well as other options, can be
customized by partners through a callback.

#### On the very first boot / the first boot after an OTA update

On the very first boot / the first boot after an OTA update, ART Service only
dexopts primary dex files of all apps with the "verify" compiler filter.

Note: It doesn't dexopt secondary dex files or use the "speed-profile" filter
because doing so may block the boot for too long.

Note: In practice, ART Service does nothing for most of the apps because the
apps on the system partitions have dexopt artifacts generated by dexpreopt, and
the apps on the data partition still have VDEX files usable even though their
dependencies (bootclasspath and class loader context) have probably changed. In
this senario, ART Service mostly dexopt apps in APEXes because they are not
supported by dexpreopt.

#### On the first boot after a mainline update

On the first boot after a mainline update, ART Service dexopts the primary dex
files of the system UI and the launcher. It uses the "speed" compiler filter for
the system UI, and uses the "speed-profile" compiler filter for the launcher.

Note: It only dexopts those two apps because they are important to user
experience.

Note: ART Service cannot use the "speed-profile" compiler filter for the system
UI because the system UI is dexpreopted using the "speed" compiler filter and
therefore it's never JITed and as a result there is no profile collected on the
device to use. This may change in the future.

#### During app installation

During app installation, ART Service dexopts the primary dex files of the app.
If the app is installed along with a DM file that contains a profile (known as a
*cloud profile*), it uses the "speed-profile" compiler filter. Otherwise, it
uses the "verify" compiler filter.

Note: If the APK is uncompressed and aligned, and it is installed along with a
DM file that only contains a VDEX file (but not a profile), no dexopt will be
performed because the compiler filter will be "verify" and the VDEX file is
satisfactory.

Note: There is no secondary dex file present during installation.

#### When the device is idle and charging

ART Service has a job called *background dexopt job* managed by Job Scheduler.
It is triggered when the device is idle and charging. During the job execution,
it dexopts primary dex files and secondary dex files of all apps with the
"speed-profile" compiler filter.

The job is cancellable. When the device is no longer idle or charging, Job
Scheduler cancels the job.
