//%Header {
/*****************************************************************************
 *
 * File: src/MushMesh/MushMeshPosticity.cpp
 *
 * Author: Andy Southgate 2002-2007
 *
 * This file contains original work by Andy Southgate.  The author and his
 * employer (Mushware Limited) irrevocably waive all of their copyright rights
 * vested in this particular version of this file to the furthest extent
 * permitted.  The author and Mushware Limited also irrevocably waive any and
 * all of their intellectual property rights arising from said file and its
 * creation that would otherwise restrict the rights of any party to use and/or
 * distribute the use of, the techniques and methods used herein.  A written
 * waiver can be obtained via http://www.mushware.com/.
 *
 * This software carries NO WARRANTY of any kind.
 *
 ****************************************************************************/
//%Header } H5XIwA/Xd/UlDZMi/ZJ3yQ
/*
 * $Id: MushMeshPosticity.cpp,v 1.4 2007/04/18 09:22:49 southa Exp $
 * $Log: MushMeshPosticity.cpp,v $
 * Revision 1.4  2007/04/18 09:22:49  southa
 * Header and level fixes
 *
 * Revision 1.3  2006/06/01 15:39:31  southa
 * DrawArray verification and fixes
 *
 * Revision 1.2  2005/07/02 00:42:38  southa
 * Conditioning tweaks
 *
 * Revision 1.1  2005/06/24 10:30:13  southa
 * MushGame camera work
 *
 */

#include "MushMeshPosticity.h"

//%outOfLineFunctions {

const char *MushMeshPosticity::AutoName(void) const
{
    return "MushMeshPosticity";
}

MushcoreVirtualObject *MushMeshPosticity::AutoClone(void) const
{
    return new MushMeshPosticity(*this);
}

MushcoreVirtualObject *MushMeshPosticity::AutoCreate(void) const
{
    return new MushMeshPosticity;
}

MushcoreVirtualObject *MushMeshPosticity::AutoVirtualFactory(void)
{
    return new MushMeshPosticity;
}
namespace
{
void AutoInstall(void)
{
    MushcoreFactory::Sgl().FactoryAdd("MushMeshPosticity", MushMeshPosticity::AutoVirtualFactory);
}
MushcoreInstaller AutoInstaller(AutoInstall);
} // end anonymous namespace
bool
MushMeshPosticity::AutoEquals(const MushMeshPosticity& inObj) const
{
    return 1
        && (m_angPos == inObj.m_angPos)
        && (m_angVel == inObj.m_angVel)
        && (m_pos == inObj.m_pos)
        && (m_vel == inObj.m_vel)
        && (m_timestamp == inObj.m_timestamp)
        && (m_timeValid == inObj.m_timeValid)
    ;
}
void
MushMeshPosticity::AutoPrint(std::ostream& ioOut) const
{
    ioOut << "[";
    ioOut << "angPos=" << m_angPos << ", ";
    ioOut << "angVel=" << m_angVel << ", ";
    ioOut << "pos=" << m_pos << ", ";
    ioOut << "vel=" << m_vel << ", ";
    ioOut << "timestamp=" << m_timestamp << ", ";
    ioOut << "timeValid=" << m_timeValid;
    ioOut << "]";
}
bool
MushMeshPosticity::AutoXMLDataProcess(MushcoreXMLIStream& ioIn, const std::string& inTagStr)
{
    if (inTagStr == "obj")
    {
        AutoInputPrologue(ioIn);
        ioIn >> *this;
        AutoInputEpilogue(ioIn);
    }
    else if (inTagStr == "angPos")
    {
        ioIn >> m_angPos;
    }
    else if (inTagStr == "angVel")
    {
        ioIn >> m_angVel;
    }
    else if (inTagStr == "pos")
    {
        ioIn >> m_pos;
    }
    else if (inTagStr == "vel")
    {
        ioIn >> m_vel;
    }
    else if (inTagStr == "timestamp")
    {
        ioIn >> m_timestamp;
    }
    else if (inTagStr == "timeValid")
    {
        ioIn >> m_timeValid;
    }
    else 
    {
        return false;
    }
    return true;
}
void
MushMeshPosticity::AutoXMLPrint(MushcoreXMLOStream& ioOut) const
{
    ioOut.TagSet("angPos");
    ioOut << m_angPos;
    ioOut.TagSet("angVel");
    ioOut << m_angVel;
    ioOut.TagSet("pos");
    ioOut << m_pos;
    ioOut.TagSet("vel");
    ioOut << m_vel;
    ioOut.TagSet("timestamp");
    ioOut << m_timestamp;
    ioOut.TagSet("timeValid");
    ioOut << m_timeValid;
}
//%outOfLineFunctions } 9RLjOHmJ+KGuDf3hVF4yAw
