/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 2008  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * This module takes care to update and draw the bottom strip of the instruments
 * panel, which includes:
 * 
 * - lights panel
 * - radar altimeter
 * - HSI tuner, or ADF tuner or TEWS (depending on the settings)
 * - HSI, or ADF or radar (depending on the settings)
 * - flaps status, max bank, gear status
 * - engine setting
 * 
 * @file
 */

#ifndef _panel_h
#define _panel_h

#include "pm.h"

#ifdef panel_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Updates and draws the bottom strip of the instruments panel.
 * @param c
 * @param u
 */
EXTERN void panel_updateAndDraw(craft *c, viewer *u);

#undef EXTERN
#endif
