!{\src2tex{textfont=tt}}
!!****f* ABINIT/diffvx
!! NAME
!! diffvx
!!
!! FUNCTION
!!
!! Calculate the differential of the exchange potential wrt Rho for
!! a homogenous e-gas of density RHO. This is done by differenting the
!! relativistic term (see VXCCA).
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density in real space, at a specific grid point
!!
!! OUTPUT
!!  function diffvx=differential of the exchange potential wrt Rho
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function diffvx(rho)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_15gw, except_this_one => diffvx
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: diffvx
 real(dp),intent(in) :: rho

!Local variables ------------------------------
!scalars
 real(dp) :: rs
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: difrel
 real(dp) :: rel
 real(dp) :: vxnr
#endif
!End of the abilint section

!************************************************************************
 rs=(3.0/(4.0*pi*rho))**third
 diffvx=(0.610887057/(rs*rs))*rel(rho)+vxnr(rho)*difrel(rho)
 diffvx=diffvx*(-4.0*pi/9.0)*(rs**4)

 return
 end function diffvx
!!***
