// CorePlugin: Provides most of the common Agora UI elements.
// Prefer adding shared UI code to this plugin instead of the AppLib static library.
AppLib.logInfo("Loading CorePlugin");

// ----------------------------------------------------------------------------
// Important: These states need to match the ones defined in CoreStates.h.
// ----------------------------------------------------------------------------
var states = {
    IsConnected: "$$.IsConnected",
    IsDebugBuild: "$$.IsDebugBuild",
    IsExportLevelInternal: "$$.IsExportLevelInternal",
    IsExportLevelNDA: "$$.IsExportLevelNDA",
    InActivity: "$$.InActivity",
};

addPlugin({
    pluginDependencies: [],
    pluginLibrary: "CorePlugin", // Library suffix (.so, .dll) appended automatically

    hostApplication: {
        defaultTheme: "Light",
    },

    toolWindows: {
        "$$.LogWindow": {
            text: qsTr("Output Messages"),
            layout: "dockSouth",
            persistable: true,
            commandBars: {
                "$$.LogWindowToolbar": { order: 1000 }
            },
            properties: {
                columns: {
                    "ID": { visible: true },
                    "Type": { visible: true },
                    "Origin": { visible: true },
                    "Source": { visible: true },
                    "Message": { visible: true },
                },
            },
        },

        "$$.ProjectExplorer": {
            text: qsTr("Project Explorer"),
            layout: "dockWest",
            persistable: true,
            defaultWidth: 10,
        },

        "$$.DocumentsWindow": {
            text: qsTr("Documents"),
            sizeMode: "percent",
            defaultHeight: 50,
            defaultWidth: 50,
            deleteOnClose: true,
            isFixed: true,
            preservesContents: true,
            persistable: true,
            layout: "dockEast",
        },

        "$$.SecondaryDocumentsWindow": {
            text: qsTr("Documents"),
            sizeMode: "percent",
            defaultHeight: 50,
            defaultWidth: 50,
            deleteOnClose: true,
            isFixed: true,
            preservesContents: true,
            persistable: false,
            layout: "floating",
        },
    },

    documentWells: {
        main: {
            closeWhenEmpty: false
        },

        secondary: {
            // Not needed for now, but if needed later config could go here.
        },
    },

    commands: {

        // Project commands
        "$$.NewProject": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("New Project..."),
            importance: "high",
        },
        "$$.OpenProject": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("Open Project..."),
            imageFontIcon: "fa-folder-open",
            importance: "high",
        },
        "$$.SaveProject": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("Save Project"),
            imageFontIcon: "fa-save",
            importance: "high",
        },
        "$$.SaveProjectAs": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("Save Project As..."),
            importance: "high",
        },
        "$$.CloseProject": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("Close Project"),
            importance: "high",
        },
        "$$.RecentProjects": {
            visibleWithFlags: ["CorePlugin.HasProjectService", "CorePlugin.HasRecentFileService"],
            requiresFlags: [not(states.InActivity)],
            text: qsTr("Recent Projects"),
        },

        // Document commands
        "$$.NewFile": {
            text: qsTr("&New File..."),
            shortcut: codeTr("Ctrl+N"),
            importance: "high"
        },
        "$$.OpenFile": {
            text: qsTr("&Open File..."),
            image: codeTr(":/Common/Open.png"),
            shortcut: codeTr("Ctrl+O"),
            importance: "high"
        },
        "$$.SaveFile": {
            text: qsTr("&Save File"),
            image: codeTr(":/Common/Save.png"),
            shortcut: codeTr("Ctrl+S"),
            importance: "high"
        },
        "$$.SaveFileAs": {
            text: qsTr("Save File &As..."),
            image: codeTr(":/Common/SaveAs.png"),
            importance: "high"
        },
        "$$.SaveAllFiles": {
            text: qsTr("Save A&ll Files"),
            image: codeTr(":/Common/SaveAll.png"),
            shortcut: codeTr("Ctrl+Shift+S"),
            importance: "high"
        },
        "$$.CloseFile": {
            text: qsTr("&Close File"),
            shortcut: codeTr("Ctrl+W"),
            importance: "high"
        },
        "$$.CloseAllFiles": {
            text: qsTr("Close All Files"),
            importance: "high"
        },
        "$$.RecentFiles": {
            visibleWithFlags: ["CorePlugin.HasRecentFileService"],
            text: qsTr("Recent Files"),
        },

        // General file commands
        "$$.ExitCommand": {
            text: qsTr("E&xit"),
            image: codeTr(":/Common/Exit.png"),
            shortcut: codeTr("Ctrl+Q"),
        },

        // Window commands
        // NOTE: Battle & Rebel have their own product specific window commands (but should really use this)
        "$$.ExportWindowLayout": {
            visibleWithFlags: [states.IsDebugBuild],
            text: qsTr("[Debug] Export Window Layout"),
        },
        "$$.ResetWindowLayout": {
            text: qsTr("&Reset Window Layout"),
        },

        // Connection commands
        // DEPRECATED: Prefer TPSConnectionPlugin
        "$$.ConnectCommand": {
            text: qsTr("&Connect..."),
            image: codeTr(":/Common/Connect.png"),
            importance: "high",
            requiresFlags: [not(states.IsConnected)],
            shortcut: codeTr("Ctrl+Shift+C"),
        },
        "$$.DisconnectCommand": {
            text: qsTr("&Disconnect"),
            image: codeTr(":/Common/Disconnect.png"),
            importance: "high",
            requiresFlags: [states.IsConnected],
            shortcut: codeTr("Ctrl+Shift+D"),
        },

        "$$.SettingsCommand": {
            text: qsTr("&Options..."),
            shortcut: codeTr("F7"),
        },
        "$$.ShowLogsCommand": {
            text: qsTr("Output &Messages"),
        },
        "$$.ExportLogsCommand": {
            text: qsTr("Export to CSV"),
            imageFontIcon: "fa-save",
        },
        "$$.ClearLogsCommand": {
            text: qsTr("Clear"),
            imageFontIcon: "fa-trash",
            importance: "high"
        },
        "$$.ShowInfoLogLevelCommand": {
            text: qsTr("Show &Info Messages"),
            image: codeTr(":/NV_UI/info.ico"),
            checked: true
        },
        "$$.ShowWarningLogLevelCommand": {
            text: qsTr("Show &Warning Messages"),
            image: codeTr(":/NV_UI/warning.ico"),
            checked: true
        },
        "$$.ShowErrorLogLevelCommand": {
            text: qsTr("Show &Error Messages"),
            image: codeTr(":/NV_UI/error.ico"),
            checked: true
        },
        "$$.ShowFatalLogLevelCommand": {
            text: qsTr("Show &Fatal Messages"),
            image: codeTr(":/NV_UI/fatal.ico"),
            checked: true
        },
        "$$.FilterLogSourceCommand": {
            text: qsTr("Filter &Sources:"),
            editable: true,
            type: "list",
            width: 30
        },
        "$$.CheckForUpdatesCommand": {
            text: qsTr("&Check For Updates..."),
            visibleWithFlags: ["CorePlugin.HasVersionUpdateService"],
        },
        "$$.AboutCommand": {
            text: qsTr("&About..."),
            menuRole: "about",
        },
        "$$.DocumentationCommand": {
            text: qsTr("&Documentation..."),
        },
        "$$.FeedbackCommand": {
            text: qsTr("Send Feedbac&k..."),
            imageFontIcon: "fa-comment-alt",
        },
        "$$.SelectPreviousCommand": {
            text: qsTr("Select &Previous"),
            shortcut: codeTr("Ctrl+Left"),
        },
        "$$.SelectNextCommand": {
            text: qsTr("Select &Next"),
            shortcut: codeTr("Ctrl+Right"),
        },
        "$$.SelectFirstCommand": {
            text: qsTr("Select &First"),
            shortcut: codeTr("Ctrl+Home"),
        },
        "$$.SelectLastCommand": {
            text: qsTr("Select &Last"),
            shortcut: codeTr("Ctrl+End"),
        },
        "$$.ShowProjectExplorerCommand": {
            visibleWithFlags: ["CorePlugin.HasProjectService"],
            text: qsTr("Project Explorer"),
        },
        "$$.ResetAppDataCommand": {
            text: qsTr("Reset Application Data..."),
        },
        "$$.ShowWelcomePage": {
            text: qsTr("Show Welcome Page"),
            visibleWithFlags: ["CorePlugin.HasProjectService"],
        },
        "$$.ConsoleLaunch": {
            // Internal command, used when CorePlugin is ready in
            // a console host.
        },
    },

    commandGroups: {

        // NOTE: Not a default group in the FileMenu
        "$$.ProjectGroup": {
            "$$.NewProject": { order: 100 },
            "$$.OpenProject": { order: 110 },
            "$$.RecentProjects": { order: 120 },
            "$$.SaveProject": { order: 130 },
            "$$.SaveProjectAs": { order: 140 },
            "$$.CloseProject": { order: 150 },
        },

        // NOTE: Not a default group in the FileMenu
        "$$.FileGroup": {
            "$$.NewFile": { order: 100 },
            "$$.OpenFile": { order: 110 },
            "$$.SaveFile": { order: 120 },
            "$$.SaveFileAs": { order: 130 },
            "$$.SaveAllFiles": { order: 140 },
            "$$.CloseFile": { order: 150 },
            "$$.CloseAllFiles": { order: 160 },
            "$$.RecentFiles" : { order: 170 },
        },

        // NOTE: Battle & Rebel have their own product specific layout group (but should really use this)
        "$$.LayoutGroup": {
            "$$.ExportWindowLayout": { order: 99 },
            "$$.ResetWindowLayout": { order: 100 },
            "$$.ShowWelcomePage": { order: 110 },
        },

        "$$.ExitGroup": {
            "$$.ExitCommand": { order: 100 }
        },
        "$$.SettingsGroup": {
            "$$.SettingsCommand": { order: 100 },
        },
        "$$.FileCloseGroup": {
            "$$.CloseDocumentCommand": { order: 100 }
        },
        "$$.ConnectionGroup": {
            "$$.ConnectCommand": { order: 100 },
            "$$.DisconnectCommand": { order: 110 },
        },
        "$$.LogViewGroup": {
            "$$.ShowLogsCommand": { order: 100 }
        },
        "$$.LogClearGroup": {
            "$$.ExportLogsCommand": { order: 100 },
            "$$.ClearLogsCommand": { order: 110 },
        },
        "$$.LogFilterGroup": {
            "$$.ShowInfoLogLevelCommand": { order: 100 },
            "$$.ShowWarningLogLevelCommand": { order: 110 },
            "$$.ShowErrorLogLevelCommand": { order: 120 },
            "$$.ShowFatalLogLevelCommand": { order: 130 },
        },
        "$$.LogSourceFilterGroup": {
            "$$.FilterLogSourceCommand": { order: 100 }
        },
        "$$.DocumentationGroup": {
            "$$.DocumentationCommand": { order: 100 },
            "$$.CheckForUpdatesCommand": { order: 200 },
        },
        "$$.FeedbackGroup": {
            "$$.FeedbackCommand": { order: 100 },
        },
        "$$.AboutGroup": {
            "$$.AboutCommand": { order: 100 },
        },
        "$$.ProjectExplorerViewGroup": {
            "$$.ShowProjectExplorerCommand": { order: 100 }
        },
        "$$.ResetAppDataGroup": {
            "$$.ResetAppDataCommand": { order: 100},
        },
    },

    commandBars: {
        "$$.FileMenu": {
            type: "menu",
            text: qsTr("&File"),
            commandGroups: {
                "$$.ExitGroup": { order: 100 },
            },
        },
        "$$.ConnectionMenu": {
            type: "menu",
            text: qsTr("&Connection"),
            commandGroups: {
                "$$.ConnectionGroup": { order: 100 },
            },
        },
        "$$.ToolsMenu": {
            type: "menu",
            text: qsTr("&Tools"),
            commandGroups: {
                "$$.LogViewGroup": { order: 100 },
                "$$.ProjectExplorerViewGroup": { order: 110 },
                "$$.SettingsGroup": { order: 120 },
            },
        },

        // NOTE: Battle & Rebel have their own product specific window menu (but should really use this)
        "$$.WindowMenu": {
            type: "menu",
            text: qsTr("&Window"),
            commandGroups: {
                "$$.LayoutGroup": { order: 100 },
            },
        },

        "$$.HelpMenu": {
            type: "menu",
            text: qsTr("&Help"),
            commandGroups: {
                "$$.DocumentationGroup": { order: 100 },
                "$$.ResetAppDataGroup" : { order: 110 },
                "$$.FeedbackGroup": { order: 120 },
                "$$.AboutGroup": { order: 130 },
            },
        },
        "$$.ConnectionToolbar": {
            type: "toolbar",
            text: qsTr("Connection"),
            commandGroups: {
                "$$.ConnectionGroup": { order: 100 },
            },
        },
        "$$.LogWindowToolbar": {
            type: "toolbar",
            text: qsTr("Main"),
            commandGroups: {
                "$$.LogClearGroup": { order: 100 },
                "$$.LogFilterGroup": { order: 110 },
                "$$.LogSourceFilterGroup" : { order: 120 },
            }
        },
        "$$.FeedbackToolbar": {
            type: "rightJustifedToolbar",
            text: qsTr("Feedback"),
            commandGroups: {
                "$$.FeedbackGroup": { order: 100 },
            },
        },
    },

    settings: {
        "$$.Environment": {
            order: 50,
            text: qsTr("Environment"),
            properties: {
                "$$.ColorTheme": {
                    order: 100,
                    type: "installedThemes",
                    category: qsTr("Visual Experience"),
                    text: qsTr("Color Theme"),
                    detailsText: qsTr("The currently selected application color theme."),
                },
                "$$.DefaultDocumentsFolder": {
                    requiresFlags: ["CorePlugin.HasProjectService"],
                    order: 110,
                    type: "directoryPath",
                    category: qsTr("Default Document Folder"),
                    detailsText: qsTr("Directory where documents unassociated with a project will be saved."),
                },
                "$$.StartupBehavior": {
                    requiresFlags: ["CorePlugin.HasProjectService"],
                    order: 120,
                    type: "enum",
                    category: qsTr("Startup Behavior"),
                    text: qsTr("At Startup"),
                    detailsText: qsTr("What to do when the host is launched"),
                    enumValues: {
                        "welcomePage": {
                            order: 100,
                            text: qsTr("Show Welcome Page"),
                        },
                        "quickLaunch": {
                            order: 200,
                            text: qsTr("Show Quick Launch Dialog"),
                        },
                        "lastProject": {
                            order: 300,
                            text: qsTr("Load Last Project"),
                        },
                        "empty": {
                            order: 400,
                            text: qsTr("Show Empty Environment"),
                        },
                    },
                },
                "$$.ShowVersionUpdateNotifications": {
                    requiresFlags: ["CorePlugin.HasVersionUpdateService"],
                    order: 130,
                    type: "bool",
                    category: qsTr("Updates"),
                    text: qsTr("Show version update notifications"),
                    detailsText: qsTr("Show notifications when a new version of this product is available."),
                    defaultValue: true
                },
            },
        },

        "$$.Privacy": {
            requiresFlags: ["CorePlugin.HasPrivacyDialog"],
            order: 9999,
            text: qsTr("Send Feedback..."),
            properties: {
                "$$.AllowAnalytics": {
                    order: 100,
                    type: "bool",
                    category: qsTr("Help Improve NVIDIA Software"),
                    text: qsTr("Collect Usage and Platform Data"),
                    detailsText: qsTr("NVIDIA software packages collect usage and platform data via Google Analytics. \nThis data is not associated with any account information registered with NVIDIA \nand is used under the legitimate interest standard for the sole purpose of \nimproving NVIDIA software. For inquiries, please contact privacy@nvidia.com."),
                },
            },
        },

    },
});

// Rename some commands for increased Mac integration
if (AppLib.environment.darwin) {
    addPlugin({
        commands: {
            "CorePlugin.ExitCommand": {
                shortcut: codeTr("Ctrl+Q"),
                menuRole: "quit",
            },
            "CorePlugin.SettingsCommand": {
                text: qsTr("Preferences..."),
                shortcut: codeTr("Ctrl+,"),
                menuRole: "preferences",
            },
        },
    });
}
