/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.NewSessionAction;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.CpuTreeView;
import com.nvidia.viper.ui.ImportCsvWizard;
import com.nvidia.viper.ui.ImportNvprofWizard;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenSessionAction
extends Action {
    private IWorkbenchWindow window;

    public OpenSessionAction(IWorkbenchWindow window) {
        super(ViperMessages.OpenSession_Label, null);
        this.window = window;
        this.setToolTipText(ViperMessages.OpenSession_Tooltip);
        this.setId("com.nvidia.viper.sessionopen");
        this.setActionDefinitionId("com.nvidia.viper.command.opensession");
    }

    public void run() {
        String filename = LocalFileSystem.browseForSessionFileOpen(this.window.getShell());
        if (filename != null) {
            OpenSessionAction.handleOpenFile(this.window, filename);
            Viper.setWelcomePageStandby(this.window);
        }
    }

    public static FileTypes handleOpenFile(IWorkbenchWindow window, String filename) {
        return OpenSessionAction.handleOpenFiles(window, new String[]{filename}, null);
    }

    public static FileTypes handleOpenFiles(IWorkbenchWindow window, String[] filenames, RemoteConnectionArgs remote) {
        FileTypes type = OpenSessionAction.handleOpenImport(window, filenames);
        if (type.equals((Object)FileTypes.UNSUPPORTED)) {
            try {
                Executable executable = new Executable();
                IPath path = CoreUtil.getFileOnPath((String)filenames[0]);
                executable.setFilename(path != null ? path.toOSString() : filenames[0]);
                if (filenames.length > 1) {
                    executable.setArgs(CoreUtil.concat((String[])Arrays.copyOfRange(filenames, 1, filenames.length)));
                }
                if (OpenSessionAction.isRemoteProfile(remote)) {
                    executable.setRemoteArgs(remote);
                }
                if (OpenSessionAction.isRemoteProfile(remote)) {
                    OpenSessionAction.openNewSessionWizard(window, executable);
                    return FileTypes.EXECUTABLE;
                }
                if (executable.isRunnable()) {
                    OpenSessionAction.openNewSessionWizard(window, executable);
                    return FileTypes.EXECUTABLE;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViperMessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message);
                    }
                });
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message, new ViperException(e));
            }
        }
        return type;
    }

    private static boolean isRemoteProfile(RemoteConnectionArgs remote) {
        return remote != null && remote.host != null && remote.user != null;
    }

    private static void openNewSessionWizard(final IWorkbenchWindow window, final Executable executable) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NewSessionAction.createNewSession(executable, window, false);
            }
        });
    }

    private static FileTypes handleOpenImport(IWorkbenchWindow window, String[] filenames) {
        final RunnableWithProgress progress = new RunnableWithProgress(window, filenames);
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    dialog.run(true, true, (IRunnableWithProgress)progress);
                }
                catch (InvocationTargetException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
            }
        });
        return progress.getFileType();
    }

    public static enum FileTypes {
        CSV,
        NVPROF,
        EXECUTABLE,
        SESSION,
        UNSUPPORTED;

    }

    public static class RemoteConnectionArgs {
        public String host = null;
        public String user = null;
        public String type = null;
        public int port = -1;
        public String toolkit = null;
    }

    static class RunnableWithProgress
    implements IRunnableWithProgress {
        private IWorkbenchWindow window;
        private String[] filenames;
        private FileTypes fileType = FileTypes.UNSUPPORTED;

        public RunnableWithProgress(IWorkbenchWindow window, String[] filenames) {
            this.window = window;
            this.filenames = filenames;
        }

        public FileTypes getFileType() {
            return this.fileType;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Open file...", -1);
            monitor.subTask("Open file " + this.filenames[0]);
            Thread thread = new Thread("LoadPdm"){

                @Override
                public void run() {
                    block2: {
                        try {
                            RunnableWithProgress.this.performOpen();
                        }
                        catch (Exception e) {
                            if (!(e instanceof ViperException)) break block2;
                            ViperException ex = (ViperException)e;
                            ex.getMessage().endsWith("LoadPdmCancel");
                        }
                    }
                }
            };
            thread.start();
            while (thread != null && thread.isAlive()) {
                if (!monitor.isCanceled()) continue;
                thread.interrupt();
            }
        }

        private boolean tryOpenCSV(File file) throws CoreException {
            try {
                if (ImportCsvWizard.isCSV(file)) {
                    Session session = new Session();
                    new ImportCsvWizard.ImportCSVRunnableWithProgress(session, file.getName(), this.filenames).run((IProgressMonitor)new NullProgressMonitor());
                    this.fileType = FileTypes.CSV;
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        private boolean tryOpenPDMS() throws CoreException {
            try {
                Session session = new Session();
                if (this.filenames.length == 1) {
                    if ((session = ImportNvprofWizard.importNvprofTimelineFileThrowsException(this.filenames[0], session)) != null) {
                        session.importNvprofCpuData(this.filenames[0]);
                        CpuTreeView.newSession = session;
                    }
                } else {
                    ImportNvprofWizard.importNvprofTimelineFiles(this.filenames, session);
                }
                this.fileType = FileTypes.NVPROF;
                return true;
            }
            catch (ViperException e) {
                if (e.getMessage().endsWith("LoadPdmCancel")) {
                    this.fileType = FileTypes.NVPROF;
                    return true;
                }
                return false;
            }
        }

        private boolean tryOpenSession(File file) {
            try {
                final Session session = FileUtils.loadSession(file);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage activePage = RunnableWithProgress.this.window.getActivePage();
                        try {
                            SessionEditor editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor");
                            editor.scaleToFit();
                            editor.setDirty(false);
                            session.setDirty(false);
                        }
                        catch (PartInitException e) {
                            ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, "Unable to open file " + RunnableWithProgress.this.filenames[0], new ViperException(e));
                        }
                    }
                });
                this.fileType = FileTypes.SESSION;
                return true;
            }
            catch (Exception e) {
                if (e.getMessage().endsWith("LoadPdmCancel")) {
                    this.fileType = FileTypes.SESSION;
                    return true;
                }
                return false;
            }
        }

        private void performOpen() {
            try {
                File file = new File(this.filenames[0]);
                if (this.tryOpenCSV(file)) {
                    return;
                }
                if (this.tryOpenPDMS()) {
                    return;
                }
                if (this.tryOpenSession(file)) {
                    return;
                }
            }
            catch (CoreException e) {
                ViperExceptionHandler.handle(ViperMessages.Open_Fail_Title, ViperMessages.Open_Fail_Message, new ViperException(e));
            }
            this.fileType = FileTypes.UNSUPPORTED;
        }
    }
}

