/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class TemplateDrivenWizard
extends Wizard {
    protected List<IWizardPage> pagesBeforeTemplatePages = new ArrayList<IWizardPage>();
    protected List<IWizardPage> pagesAfterTemplatePages = new ArrayList<IWizardPage>();
    protected Template template;
    protected int pageIndex;
    protected Map<String, UIWizardPage> templatePages;
    protected Composite pageContainer;
    protected List<String> templatePagesOrderVector;

    public final void addPage(IWizardPage page) {
        page.setWizard((IWizard)this);
    }

    public final void addPages() {
        IWizardPage page;
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getPagesBeforeTemplatePages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            page = iWizardPageArray[n2];
            this.addPageBeforeTemplatePages(page);
            ++n2;
        }
        iWizardPageArray = pages = this.getPagesAfterTemplatePages();
        n = pages.length;
        n2 = 0;
        while (n2 < n) {
            page = iWizardPageArray[n2];
            this.addPageAfterTemplatePages(page);
            ++n2;
        }
    }

    private void addPageBeforeTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesBeforeTemplatePages.add(page);
    }

    private void addPageAfterTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesAfterTemplatePages.add(page);
    }

    protected abstract IWizardPage[] getPagesBeforeTemplatePages();

    protected abstract IWizardPage[] getPagesAfterTemplatePages();

    protected abstract Template getTemplate();

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.pageIndex > this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size()) {
            --this.pageIndex;
            return this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        if (this.pageIndex > this.pagesBeforeTemplatePages.size()) {
            --this.pageIndex;
            return this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
            return this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() - 1) {
            ++this.pageIndex;
            return this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() - 1) {
            if (this.pageIndex == this.pagesBeforeTemplatePages.size() - 1) {
                Template template = this.getTemplate();
                if (this.template != null && !((Object)((Object)this.template)).equals((Object)template)) {
                    this.template = template;
                    this.templatePages = template.getUIPages();
                    this.templatePagesOrderVector = template.getPagesOrderVector();
                }
            }
            ++this.pageIndex;
            IWizardPage nextPage = this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
            nextPage.setWizard((IWizard)this);
            if (nextPage.getControl() == null) {
                nextPage.createControl(this.pageContainer);
            }
            return nextPage;
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() + this.pagesAfterTemplatePages.size() - 1) {
            ++this.pageIndex;
            return this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        return null;
    }

    public final boolean canFinish() {
        IWizardPage page;
        for (IWizardPage iWizardPage : this.pagesBeforeTemplatePages) {
            page = iWizardPage;
            if (page.isPageComplete()) continue;
            return false;
        }
        if (this.templatePages == null) {
            return false;
        }
        for (IWizardPage iWizardPage : this.templatePages.values()) {
            page = iWizardPage;
            if (page.isPageComplete()) continue;
            return false;
        }
        for (IWizardPage iWizardPage : this.pagesAfterTemplatePages) {
            page = iWizardPage;
            if (page.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TemplateDrivenWizard.this.finishPage(monitor);
            }
        });
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private boolean finishPage(IProgressMonitor monitor) {
        IStatus[] statuses = this.template.executeTemplateProcesses(monitor, false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            TemplateEngineUIUtil.showError(statuses[0].getMessage(), statuses[0].getException());
            return false;
        }
        String msg = Messages.getString("TemplateDrivenWizard.0");
        TemplateEngineUIUtil.showStatusDialog(msg, (IStatus)new MultiStatus(CUIPlugin.getPluginId(), 0, statuses, msg, null));
        return true;
    }

    public final void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.pageContainer = pageContainer;
    }
}

