/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.editor.CDocumentSetupParticipant;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class CStringDoubleClickSelector
extends CDoubleClickSelector {
    private String fPartitioning;
    private ITextDoubleClickStrategy fFallbackStrategy;

    public CStringDoubleClickSelector(String partitioning) {
        this(partitioning, null);
    }

    public CStringDoubleClickSelector(String partitioning, ITextDoubleClickStrategy doubleClickStrategy) {
        this.fPartitioning = partitioning;
        this.fFallbackStrategy = doubleClickStrategy;
    }

    @Override
    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.matchString(document, offset);
        if (region != null) {
            if (region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
            }
        } else if (this.fFallbackStrategy != null) {
            this.fFallbackStrategy.doubleClicked(textViewer);
        } else {
            region = this.selectWord(document, offset);
            if (region != null) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
            }
        }
    }

    private IRegion matchString(IDocument document, int offset) {
        try {
            if (document.getChar(offset) == '\"' || document.getChar(offset) == '\'' || document.getChar(offset - 1) == '\"' || document.getChar(offset - 1) == '\'') {
                ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)true);
                if ("__c_preprocessor".equals(region.getType())) {
                    String ppDirective = document.get(region.getOffset(), region.getLength());
                    int hashIdx = ppDirective.indexOf(35);
                    document = new Document(ppDirective.substring(hashIdx + 1));
                    new CDocumentSetupParticipant().setup(document);
                    int delta = region.getOffset() + hashIdx + 1;
                    region = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)(offset - delta), (boolean)true);
                    return new Region(region.getOffset() + delta, region.getLength());
                }
                return region;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }
}

