/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import java.util.Map;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

public final class KernelImage
extends LabelAttribute {
    private static final CudaDebugImages[][] KERNEL_IMAGES = new CudaDebugImages[][]{{CudaDebugImages.KERNEL, CudaDebugImages.KERNEL_PAUSED, CudaDebugImages.KERNEL_PAUSED_ERROR, CudaDebugImages.KERNEL_INACTIVE}, {CudaDebugImages.CDP_KERNEL, CudaDebugImages.CDP_KERNEL_PAUSED, CudaDebugImages.CDP_KERNEL_PAUSED_ERROR, CudaDebugImages.KERNEL_INACTIVE}};
    private final boolean showPausedState;

    private static String[] getProperties(boolean showPausedState) {
        if (showPausedState) {
            return new String[]{"active_kernel_blocks", "is_suspended", "prop.is.error", "is_cdp_kernel"};
        }
        return new String[]{"active_kernel_blocks", "is_cdp_kernel"};
    }

    public KernelImage(boolean showPausedState) {
        super(KernelImage.getProperties(showPausedState));
        this.showPausedState = showPausedState;
    }

    private int getImageId(Map<String, Object> properties) {
        if (Integer.valueOf(0).equals(properties.get("active_kernel_blocks"))) {
            return 3;
        }
        if (this.showPausedState && Boolean.TRUE.equals(properties.get("is_suspended"))) {
            if (CoreUtil.isTrue((Object)properties.get("prop.is.error"))) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public boolean isEnabled(IStatus status, Map<String, Object> properties) {
        return true;
    }

    public void updateAttribute(ILabelUpdate update, int columnIndex, IStatus status, Map<String, Object> properties) {
        boolean isCDP = Boolean.TRUE.equals(properties.get("is_cdp_kernel"));
        int imageId = this.getImageId(properties);
        CudaDebugImages image = KERNEL_IMAGES[isCDP ? 1 : 0][imageId];
        update.setImageDescriptor(image.getDescriptor(), columnIndex);
    }
}

