/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.ui.viewmodel.CudaInformationColumnPresentation;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaVMProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.SelectionSynchronizer;
import com.nvidia.cuda.ide.debug.ui.viewmodel.events.ElementQuerySet;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ActiveElementsOnly;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.HardwareElementsFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.LogicalElementsFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.QueryFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.BlockVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.DeviceThreadVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.DeviceVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.LaneVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.NoCudaElementsNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.SmVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.WarpVMNode;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractLaunchVMProvider;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;

public final class CudaInformationVMProvider
extends AbstractLaunchVMProvider
implements IPropertyChangeListener,
ICudaVMProvider {
    private IElementQuery query;
    private ICudaElementFilter queryFilter;
    private final SelectionSynchronizer selectionSynchronizer;
    private final DsfServicesTracker tracker;
    private final IWorkbenchPartSite viewSite;

    public CudaInformationVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        this.selectionSynchronizer = new SelectionSynchronizer((ScheduledExecutorService)DisplayDsfExecutor.getDisplayDsfExecutor((Display)presentationContext.getWindow().getShell().getDisplay()), session, (IVMEventListener)this);
        this.viewSite = presentationContext.getPart().getSite();
        this.viewSite.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.selectionSynchronizer);
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.viewSite, (IDebugContextListener)this.selectionSynchronizer);
        this.tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
        presentationContext.addPropertyChangeListener((IPropertyChangeListener)this);
        RootDMVMNode launchNode = new RootDMVMNode((AbstractVMProvider)this);
        this.setRootNode((IRootVMNode)launchNode);
        KernelVMNode cudaKernelsNode = new KernelVMNode((AbstractDMVMProvider)this, this.getSession(), true);
        DeviceVMNode cudaDevicesNode = new DeviceVMNode((AbstractDMVMProvider)this, this.getSession());
        NoCudaElementsNode nothingNode = new NoCudaElementsNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)launchNode, new IVMNode[]{cudaKernelsNode, cudaDevicesNode, nothingNode});
        BlockVMNode cudaBlocksNode = new BlockVMNode((AbstractDMVMProvider)this, BlockVMNode.ParentKind.CUDA_INFORMATION_VIEW, this.getSession(), false);
        this.addChildNodes((IVMNode)cudaKernelsNode, new IVMNode[]{cudaBlocksNode});
        DeviceThreadVMNode cudaThreadsNode = new DeviceThreadVMNode((AbstractDMVMProvider)this, this.getSession(), true);
        this.addChildNodes((IVMNode)cudaBlocksNode, new IVMNode[]{cudaThreadsNode});
        SmVMNode cudaSMsNode = new SmVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)cudaDevicesNode, new IVMNode[]{cudaSMsNode});
        WarpVMNode cudaWarpsNode = new WarpVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)cudaSMsNode, new IVMNode[]{cudaWarpsNode});
        LaneVMNode cudaLanesNode = new LaneVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)cudaWarpsNode, new IVMNode[]{cudaLanesNode});
        this.selectionSynchronizer.setLinkedSelection(this.isSelectionLinked());
        this.refreshFilter();
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        if (eventToSkip instanceof ICommandControlService.ICommandControlInitializedDMEvent || eventToSkip instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return false;
        }
        if ((eventToSkip instanceof IGDBTraceControl.ITracingStartedDMEvent || eventToSkip instanceof IGDBTraceControl.ITracingStoppedDMEvent) && (newEvent instanceof IGDBTraceControl.ITracingStartedDMEvent || newEvent instanceof IGDBTraceControl.ITracingStoppedDMEvent)) {
            return true;
        }
        if (eventToSkip instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent && newEvent instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
            return true;
        }
        return super.canSkipHandlingEvent(newEvent, eventToSkip);
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new CudaInformationColumnPresentation();
    }

    public void dispose() {
        this.viewSite.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.selectionSynchronizer);
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.viewSite, (IDebugContextListener)this.selectionSynchronizer);
        this.tracker.dispose();
        super.dispose();
    }

    private LinkedSelectionChangedEvent fixMode(LinkedSelectionChangedEvent event, final RequestMonitor rm) {
        ICudaRuntimeObject dmc = event.getDMContext();
        if (dmc == null) {
            return null;
        }
        ElementType type = dmc.getType();
        if (this.isHardwareViewMode() && type.isHardware() || !this.isHardwareViewMode() && type.isLogical()) {
            return event;
        }
        DataRequestMonitor<ICudaRuntimeObject> drm = new DataRequestMonitor<ICudaRuntimeObject>(this.getExecutor(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                if (this.getData() == null) {
                    if (rm != null) {
                        rm.done();
                    }
                } else {
                    CudaInformationVMProvider.this.handleEvent(new LinkedSelectionChangedEvent((ICudaRuntimeObject)this.getData()), rm);
                }
            }
        };
        if (this.isHardwareViewMode()) {
            dmc.toHardwareElement(drm);
        } else {
            dmc.toLogicalElement(drm);
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return CudaInformationColumnPresentation.ID;
    }

    @Override
    public ICudaElementFilter getFilter() {
        return this.queryFilter;
    }

    private Object getInputObject(Object ... selection) {
        ILaunch root = null;
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ILaunch launch = (ILaunch)DebugPlugin.getAdapter((Object)object, ILaunch.class);
            if (root == null) {
                root = launch;
            } else if (launch != null && !launch.equals(root)) {
                return null;
            }
            ++n2;
        }
        if (root != null) {
            return new CudaInformationViewInput(root, (String)this.getPresentationContext().getProperty("view.mode"));
        }
        return root;
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        if (event instanceof LinkedSelectionChangedEvent) {
            if ((event = this.fixMode((LinkedSelectionChangedEvent)event, rm)) == null) {
                return;
            }
        } else {
            if (event instanceof IGDBTraceControl.ITracingStartedDMEvent || event instanceof IGDBTraceControl.ITracingStoppedDMEvent || event instanceof IGDBTraceControl.ITracingSupportedChangeDMEvent) {
                this.refresh();
                rm.done();
                return;
            }
            if (event instanceof IRunControl.IExitedDMEvent) {
                this.refresh();
            } else if (event instanceof ModelProxyInstalledEvent) {
                DisplayDsfExecutor.getDisplayDsfExecutor((Display)this.getPresentationContext().getWindow().getShell().getDisplay()).schedule(new Runnable(){

                    @Override
                    public void run() {
                        CudaInformationVMProvider.this.selectionSynchronizer.setLinkedSelection(CudaInformationVMProvider.this.isSelectionLinked());
                        CudaInformationVMProvider.this.selectionSynchronizer.repost();
                    }
                }, 50L, TimeUnit.MILLISECONDS);
            }
        }
        super.handleEvent(event, rm);
    }

    public boolean isHardwareViewMode() {
        return "hardware.view.mode".equals(this.getPresentationContext().getProperty("view.mode"));
    }

    protected final boolean isSelectionLinked() {
        return !Boolean.FALSE.equals(this.getPresentationContext().getProperty("link.selection"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (ElementQuery.PROPERTY.equals(propertyName)) {
            this.query = (IElementQuery)event.getNewValue();
            this.refreshFilter();
            this.handleEvent(new ElementQuerySet(this.query));
        } else if ("coalescing.action".equals(propertyName) || "view.mode".equals(propertyName)) {
            this.refreshFilter();
        } else if ("link.selection".equals(propertyName)) {
            this.selectionSynchronizer.setLinkedSelection(this.isSelectionLinked());
        } else if ("noselectiontracking".equals(propertyName)) {
            this.selectionSynchronizer.setSuspended(Boolean.TRUE.equals(event.getNewValue()));
        }
    }

    private void refreshFilter() {
        this.selectionSynchronizer.maintainingSelection(new Runnable(){

            @Override
            public void run() {
                Object property = CudaInformationVMProvider.this.getPresentationContext().getProperty("coalescing.action");
                ICudaElementFilter filter = Boolean.FALSE.equals(property) ? (CudaInformationVMProvider.this.isHardwareViewMode() ? new HardwareElementsFilter() : new LogicalElementsFilter()) : new ActiveElementsOnly();
                if (CudaInformationVMProvider.this.query == null) {
                    CudaInformationVMProvider.this.queryFilter = filter;
                } else {
                    CudaInformationVMProvider.this.queryFilter = new QueryFilter(CudaInformationVMProvider.this.tracker, CudaInformationVMProvider.this.query, filter);
                }
                CudaInformationVMProvider.this.refresh();
            }
        });
    }

    public String toString() {
        return "CudaLogicalStructureVMProvider(" + this.getSession().getId() + ")";
    }

    public void update(IViewerInputUpdate update) {
        update.setInputElement(this.getInputObject(update.getElement()));
        update.done();
    }

    private static final class CudaInformationViewInput
    extends PlatformObject {
        private final ILaunch launch;
        private final String mode;

        public CudaInformationViewInput(ILaunch launch, String mode) {
            this.launch = launch;
            this.mode = mode == null ? "logical.view.mode" : mode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CudaInformationViewInput)) {
                return false;
            }
            CudaInformationViewInput other = (CudaInformationViewInput)((Object)obj);
            return this.launch.equals(other.launch) && this.mode.equals(other.mode);
        }

        public Object getAdapter(Class adapter) {
            if (IElementMementoProvider.class.equals((Object)adapter)) {
                return new ViewerInputMementoProvider();
            }
            Object a = super.getAdapter(adapter);
            if (a == null) {
                a = DebugPlugin.getAdapter((Object)this.launch, (Class)adapter);
            }
            return a;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getMode() {
            return this.mode;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.launch == null ? 0 : this.launch.hashCode());
            result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
            return result;
        }
    }

    private static final class ViewerInputMementoProvider
    implements IElementMementoProvider {
        private static final String PROP_LAUNCH_NAME = "launch";
        private static final String PROP_MODE = "mode";

        private ViewerInputMementoProvider() {
        }

        public void compareElements(IElementCompareRequest[] requests) {
            IElementCompareRequest[] iElementCompareRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IElementCompareRequest request = iElementCompareRequestArray[n2];
                Object element = request.getElement();
                if (element instanceof CudaInformationViewInput) {
                    CudaInformationViewInput input = (CudaInformationViewInput)((Object)element);
                    IMemento memento = request.getMemento();
                    boolean sameLaunchName = input.getLaunch().getLaunchConfiguration().getName().equals(memento.getString(PROP_LAUNCH_NAME));
                    boolean sameMode = input.getMode().equals(memento.getString(PROP_MODE));
                    request.setEqual(sameLaunchName && sameMode);
                } else {
                    request.cancel();
                }
                request.done();
                ++n2;
            }
        }

        public void encodeElements(IElementMementoRequest[] requests) {
            IElementMementoRequest[] iElementMementoRequestArray = requests;
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IElementMementoRequest request = iElementMementoRequestArray[n2];
                Object element = request.getElement();
                if (element instanceof CudaInformationViewInput) {
                    CudaInformationViewInput input = (CudaInformationViewInput)((Object)element);
                    ILaunch launch = input.getLaunch();
                    String mode = input.getMode();
                    request.getMemento().putString(PROP_LAUNCH_NAME, launch.getLaunchConfiguration().getName());
                    request.getMemento().putString(PROP_MODE, mode);
                } else {
                    request.cancel();
                }
                request.done();
                ++n2;
            }
        }
    }
}

