/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.model.Kernel;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CudaRunControl
extends GDBRunControl_7_0 {
    private IRunControl.IExecutionDMContext[] triggerContexts;

    public CudaRunControl(DsfSession session) {
        super(session);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunControl.ContainerSuspendedEvent e) {
        this.triggerContexts = e.getTriggeringContexts();
        super.eventDispatched(e);
    }

    public void getKernelExecutionData(IRunControl.IExecutionDMContext dmc, Kernel kernel, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (!this.isTriggerContainer(kernel)) {
            rm.setData((Object)new IRunControl.IExecutionDMData(){

                public IRunControl.StateChangeReason getStateChangeReason() {
                    return null;
                }
            });
            rm.done();
        } else {
            super.getExecutionData(dmc, rm);
        }
    }

    protected boolean isTriggerContainer(Kernel dmc) {
        if (this.triggerContexts == null || this.triggerContexts.length == 0) {
            return true;
        }
        IRunControl.IExecutionDMContext[] iExecutionDMContextArray = this.triggerContexts;
        int n = this.triggerContexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRunControl.IExecutionDMContext trigger = iExecutionDMContextArray[n2];
            if (DMContexts.isAncestorOf((IDMContext)trigger, (IDMContext)dmc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void suspendIndefinite(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    IGDBBackend backend = (IGDBBackend)CudaRunControl.this.getServicesTracker().getService(IGDBBackend.class);
                    if (backend != null) {
                        backend.interruptAndWait(300000, rm);
                    }
                } else {
                    rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 10001, "Context cannot be suspended.", null));
                    rm.done();
                }
            }
        });
    }
}

